untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwfBBh7FUGdoHCLm2u3Ne63iRs1wU7SUJFMM5YUh3ipR9HwJjszB3IMYT+FTORDsIO1tvGkANeIH6tzSh2o48Hw0=

OpenBSD 5.9 errata 14, Jul 14, 2016:

Multiple processes exiting with a fd-passing control message on a
shared socket could crash the system.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 014_unp.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/uipc_usrreq.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_usrreq.c,v
retrieving revision 1.95
diff -u -p -r1.95 uipc_usrreq.c
--- sys/kern/uipc_usrreq.c	5 Dec 2015 10:11:53 -0000	1.95
+++ sys/kern/uipc_usrreq.c	14 Jul 2016 03:08:11 -0000
@@ -903,6 +903,8 @@ unp_gc(void *arg __unused)
 		for (i = 0; i < defer->ud_n; i++) {
 			memcpy(&fp, &((struct file **)(defer + 1))[i],
 			    sizeof(fp));
+			if (fp == NULL)
+				continue;
 			FREF(fp);
 			if ((unp = fptounp(fp)) != NULL)
 				unp->unp_msgcount--;
