untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ+RuVaD9ouo/4Ah7rg8rxFBCX41Jn48wqhdO1CUs19ufYZOSpoPGcS9JZgkIf6RtVDA3LYo3LhJvYsxv/PkTAwk=

OpenBSD 6.0 errata 032, August 3, 2017:

An alignment issue in recv() may result in an info leak via ktrace().

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 032_recv.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/uipc_syscalls.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_syscalls.c,v
--- sys/kern/uipc_syscalls.c	27 Mar 2017 11:45:49 -0000	1.151
+++ sys/kern/uipc_syscalls.c	1 Aug 2017 22:10:56 -0000	1.151.4.1
@@ -872,16 +872,16 @@ recvit(struct proc *p, int s, struct msg
 					i = len;
 				}
 				error = copyout(mtod(m, caddr_t), cp, i);
+#ifdef KTRACE
+				if (KTRPOINT(p, KTR_STRUCT) && error == 0 && i)
+					ktrcmsghdr(p, mtod(m, char *), i);
+#endif
 				if (m->m_next)
 					i = ALIGN(i);
 				cp += i;
 				len -= i;
 				if (error != 0 || len <= 0)
 					break;
-#ifdef KTRACE
-				if (KTRPOINT(p, KTR_STRUCT) && i)
-					ktrcmsghdr(p, mtod(m, char *), i);
-#endif
 			} while ((m = m->m_next) != NULL);
 			len = cp - (caddr_t)mp->msg_control;
 		}
