untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEt9y1EwEuUE88Uc+nni5tuz5oXKmL5/Mi4tB3BK8sD5BqqeRY7IXplQjEk2eQw2EooJolUl6nqIqk03YkQzWFw4=

OpenBSD 6.1 errata 004, May 2, 2017:

softraid(4) was unable to create usable concat volumes because
it always set the size of the volume to zero sectors.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 004_softraid_concat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/softraid_concat.c
===================================================================
RCS file: /cvs/src/sys/dev/softraid_concat.c,v
diff -u -p -r1.25 -r1.26
--- sys/dev/softraid_concat.c	12 Apr 2016 16:26:54 -0000	1.25
+++ sys/dev/softraid_concat.c	28 Apr 2017 23:33:07 -0000	1.26
@@ -60,11 +60,19 @@ int
 sr_concat_create(struct sr_discipline *sd, struct bioc_createraid *bc,
     int no_chunk, int64_t coerced_size)
 {
+	int i;
+
 	if (no_chunk < 2) {
 		sr_error(sd->sd_sc, "%s requires two or more chunks",
 		    sd->sd_name);
 		return EINVAL;
         }
+	
+	sd->sd_meta->ssdi.ssd_size = 0;
+	for (i = 0; i < no_chunk; i++) {
+		sd->sd_meta->ssdi.ssd_size +=
+		    sd->sd_vol.sv_chunks[i]->src_size;
+	}
 
 	return sr_concat_init(sd);
 }

