untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEu8A6W+DS3/rnzQbdEE7Nwt9V4Cx35ELeHvtWBoDLzDma3txO1lcPeG1EU/jNisHTtrHNppUrf43CUV8KMPX/gE=

OpenBSD 6.1 errata 028, September 22, 2017:

A buffer over-read and heap overflow in perl's regexp may result in
a crash or memory leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 028_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install perl:
    cd /usr/src/gnu/usr.bin/perl/
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper depend
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: gnu/usr.bin/perl/regcomp.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/regcomp.c,v
retrieving revision 1.22
diff -u -p -r1.22 regcomp.c
--- gnu/usr.bin/perl/regcomp.c	5 Feb 2017 00:31:53 -0000	1.22
+++ gnu/usr.bin/perl/regcomp.c	11 Sep 2017 01:37:03 -0000
@@ -11918,14 +11918,16 @@ S_grok_bslash_N(pTHX_ RExC_state_t *pREx
 	}
         sv_catpv(substitute_parse, ")");
 
-        RExC_parse = RExC_start = RExC_adjusted_start = SvPV(substitute_parse,
-                                                             len);
+        len = SvCUR(substitute_parse);
 
 	/* Don't allow empty number */
 	if (len < (STRLEN) 8) {
             RExC_parse = endbrace;
 	    vFAIL("Invalid hexadecimal number in \\N{U+...}");
 	}
+
+        RExC_parse = RExC_start = RExC_adjusted_start
+                                              = SvPV_nolen(substitute_parse);
 	RExC_end = RExC_parse + len;
 
         /* The values are Unicode, and therefore not subject to recoding, but
@@ -13018,6 +13020,7 @@ S_regatom(pTHX_ RExC_state_t *pRExC_stat
                             goto loopdone;
                         }
                         p = RExC_parse;
+                        RExC_parse = parse_start;
                         if (ender > 0xff) {
                             REQUIRE_UTF8(flagp);
                         }
