untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT259PM1AAcZuaBttAcDYuG6LuuE+Vio/h3QKQpzuESujYBEPzjwnjrOeL6A/OoQ/6i/fcASc5ZMpCgzKDnPDwQs=

OpenBSD 6.5 errata 020, December 3, 2019:

Environment-provided paths are used for dlopen() in mesa, resulting in
escalation to the auth group in xlock(1).

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 020_mesaxlock.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild Mesa and xlock
    cd /usr/xenocara/lib/mesa
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build
    cd /usr/xenocara/app/xlockmore
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/mesa/src/glx/dri_common.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/glx/dri_common.c,v
diff -u -p -u -r1.9 dri_common.c
--- lib/mesa/src/glx/dri_common.c	29 Jan 2019 11:52:21 -0000	1.9
+++ lib/mesa/src/glx/dri_common.c	3 Dec 2019 01:00:26 -0000
@@ -110,7 +110,7 @@ driOpenDriver(const char *driverName)
    glhandle = dlopen(GL_LIB_NAME, RTLD_NOW | RTLD_GLOBAL);
 
    libPaths = NULL;
-   if (geteuid() == getuid()) {
+   if (issetugid() == 0 && geteuid() == getuid()) {
       /* don't allow setuid apps to use LIBGL_DRIVERS_PATH */
       libPaths = getenv("LIBGL_DRIVERS_PATH");
       if (!libPaths)
Index: lib/mesa/src/loader/loader.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/loader/loader.c,v
diff -u -p -u -r1.6 loader.c
--- lib/mesa/src/loader/loader.c	29 Jan 2019 11:52:24 -0000	1.6
+++ lib/mesa/src/loader/loader.c	3 Dec 2019 01:00:26 -0000
@@ -441,7 +441,7 @@ loader_get_driver_for_fd(int fd)
     * user's problem, but this allows vc4 simulator to run on an i965 host,
     * and may be useful for some touch testing of i915 on an i965 host.
     */
-   if (geteuid() == getuid()) {
+   if (issetugid() == 0 && geteuid() == getuid()) {
       driver = getenv("MESA_LOADER_DRIVER_OVERRIDE");
       if (driver)
          return strdup(driver);
Index: app/xlockmore/Makefile.bsd-wrapper
===================================================================
RCS file: /cvs/xenocara/app/xlockmore/Makefile.bsd-wrapper,v
diff -u -p -u -r1.13 Makefile.bsd-wrapper
--- app/xlockmore/Makefile.bsd-wrapper	7 Mar 2017 21:35:57 -0000	1.13
+++ app/xlockmore/Makefile.bsd-wrapper	3 Dec 2019 01:00:34 -0000
@@ -17,6 +17,7 @@ config.status:
 		--enable-appdefaultdir=${X11BASE}/share/X11/app-defaults \
 		--enable-syslog --without-motif --without-ttf \
 		--without-gtk2 --without-gtk --without-esound \
-		--without-rplay --without-ftgl
+		--without-rplay --without-ftgl \
+		--without-opengl --without-mesa
 
 .include <bsd.xorg.mk>
