untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2u9OZ40lA9RY4O94zxVupSjXHJK2KurKIM6fKPFr3EzqkqISb5v+wYAoax5JfH0A4U4qUuwSlXtM9S81QrMpgwA=

OpenBSD 6.8 errata 027, August 4, 2021:

On sparc64, a misaligned address could panic the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 027_vmparam.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/sparc64/include/vmparam.h
===================================================================
RCS file: /cvs/src/sys/arch/sparc64/include/vmparam.h,v
diff -u -p -r1.32 vmparam.h
--- sys/arch/sparc64/include/vmparam.h	1 Nov 2015 20:10:00 -0000	1.32
+++ sys/arch/sparc64/include/vmparam.h	3 Aug 2021 07:18:17 -0000
@@ -102,7 +102,7 @@
  */
 #define VM_MIN_ADDRESS		((vaddr_t)PAGE_SIZE)
 #define VM_MAX_ADDRESS		((vaddr_t)-1)
-#define VM_MAXUSER_ADDRESS	((vaddr_t)-1)
+#define VM_MAXUSER_ADDRESS	((vaddr_t)-PAGE_SIZE)
 
 /* map PIE into the first quarter of the address space before hole */
 #define VM_PIE_MIN_ADDR		PAGE_SIZE
