untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8oro2U8wpIKC2o8r4I/f3K/Zer2tOTaXaSSSJlofoH5M0nBajIdjWe5S+KhDrqa+qkgVqpjGQaVn6KDeeNTIVkQo=

OpenBSD 7.6 errata 004, October 31, 2024:

Updating Apple Silicon system firmware to the latest version cripples
OpenBSD.  This disabled the onboard WiFi.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 004_aplsmc.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/arm64/dev/aplsmc.c
===================================================================
RCS file: /cvs/src/sys/arch/arm64/dev/aplsmc.c,v
diff -u -p -r1.25 aplsmc.c
--- sys/arch/arm64/dev/aplsmc.c	16 Jul 2023 16:11:11 -0000	1.25
+++ sys/arch/arm64/dev/aplsmc.c	29 Oct 2024 21:23:20 -0000
@@ -250,6 +250,12 @@ aplsmc_attach(struct device *parent, str
 		return;
 	}
 
+	error = rtkit_set_ap_pwrstate(sc->sc_rs, RTKIT_MGMT_PWR_STATE_ON);
+	if (error) {
+		printf(": can't set AP power state\n");
+		return;
+	}
+
 	error = rtkit_start_endpoint(sc->sc_rs, SMC_EP, aplsmc_callback, sc);
 	if (error) {
 		printf(": can't start SMC endpoint\n");
