untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEqf+3JwyuvA28tOdO0buVbw+K7RUVvgzbtns+y8D9fsPdT5X1X7N+Q+HJSVJvIdmEoV5SEG/tZmuzV/1XFv0XQ0=

OpenBSD 6.1 errata 013, Jun 27, 2017:

When pinging an IPv6 link-local address, the reflected packet had
::1 as source address.  The echo reply was ignored as it must be
from the link-local address.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 013_icmp6_linklocal.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet6/icmp6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/icmp6.c,v
retrieving revision 1.203
retrieving revision 1.203.4.1
diff -u -p -r1.203 -r1.203.4.1
--- sys/netinet6/icmp6.c	3 Mar 2017 13:19:40 -0000	1.203
+++ sys/netinet6/icmp6.c	26 Jun 2017 20:41:37 -0000	1.203.4.1
@@ -1218,14 +1218,10 @@ icmp6_reflect(struct mbuf *m, size_t off
 	sa6_src.sin6_family = AF_INET6;
 	sa6_src.sin6_len = sizeof(sa6_src);
 	sa6_src.sin6_addr = ip6->ip6_dst;
-	in6_recoverscope(&sa6_src, &ip6->ip6_dst);
-	in6_embedscope(&ip6->ip6_dst, &sa6_src, NULL);
 	bzero(&sa6_dst, sizeof(sa6_dst));
 	sa6_dst.sin6_family = AF_INET6;
 	sa6_dst.sin6_len = sizeof(sa6_dst);
 	sa6_dst.sin6_addr = t;
-	in6_recoverscope(&sa6_dst, &t);
-	in6_embedscope(&t, &sa6_dst, NULL);
 
 	/*
 	 * This is the case if the dst is our link-local address
