untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEpr/ltkkiesp2rSMlsojmMCZTGSBcnZRbqtJJ1EgseKuS50uwNP4smt3vzOezNNB57u44GiDcVxy4g099KfiawQ=

OpenBSD 6.1 errata 016, August 3, 2017:

A missing length check in sendsyslog() may result in a kernel panic.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 016_sendsyslog.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/subr_log.c
===================================================================
RCS file: /cvs/src/sys/kern/subr_log.c,v
--- sys/kern/subr_log.c	27 Mar 2017 11:45:49 -0000	1.50
+++ sys/kern/subr_log.c	18 Jul 2017 22:22:19 -0000	1.51
@@ -417,6 +417,9 @@ dosendsyslog(struct proc *p, const char 
 	struct uio auio;
 	size_t i, len;
 	int error;
+
+	if (nbyte > 8192)
+		nbyte = 8192;
 
 	/* Global variable syslogf may change during sleep, use local copy. */
 	fp = syslogf;
