untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEnKz7KcQQfD5wvwxtkZjmjz3TKSm8WvPEfC1mNNI4MAgxByNo9xbz4BGOmCjL3/5yDqKU8FwNltpyDP91WH1qgM=

OpenBSD 6.1 errata 009, May 22, 2017:

The kernel could leak memory when processing ICMP packets with IP
options.  Note that pf(4) blocks such packets by default.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 009_icmp_opts.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_icmp.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_icmp.c,v
retrieving revision 1.163.4.1
diff -u -p -r1.163.4.1 ip_icmp.c
--- sys/netinet/ip_icmp.c	11 May 2017 11:22:30 -0000	1.163.4.1
+++ sys/netinet/ip_icmp.c	22 May 2017 15:49:11 -0000
@@ -591,8 +591,10 @@ reflect:
 
 		icmpstat_inc(icps_reflect);
 		icmpstat_inc(icps_outhist + icp->icmp_type);
-		if (!icmp_reflect(m, &opts, NULL))
+		if (!icmp_reflect(m, &opts, NULL)) {
 			icmp_send(m, opts);
+			m_free(opts);
+		}
 		return IPPROTO_DONE;
 
 	case ICMP_REDIRECT:
