untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEn2gSjsLGHt1S/7bw7HQMq8RQpBaux/sGxLP3zGOjYZNaXayxw2dm+dugVWMPTnPBqI2tbFeIH3LU359ew/BKgA=

OpenBSD 6.1 errata 021, August 3, 2017:

An uninitialized variable in ptrace() may result in an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 021_ptrace.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/sys_process.c
===================================================================
RCS file: /cvs/src/sys/kern/sys_process.c,v
--- sys/kern/sys_process.c	25 Jan 2017 07:35:04 -0000	1.76
+++ sys/kern/sys_process.c	19 Jul 2017 14:17:49 -0000	1.77
@@ -101,7 +101,7 @@ sys_ptrace(struct proc *p, void *v, regi
 	register_t wcookie;
 #endif
 	int error, write;
-	int temp;
+	int temp = 0;
 	int req = SCARG(uap, req);
 	pid_t pid = SCARG(uap, pid);
 	caddr_t addr = SCARG(uap, addr);
