untrusted comment: verify with openbsd-62-base.pub
RWRVWzAMgtyg7l5ZGCJBAbSiJfEEzMq3kY1fOgLnDQLF1KtEQWJk2Hai+/9Yi+z9QWhnZ8htj8QT1a5QFMiSctASBt55FWvKsgE=

OpenBSD 6.2 errata 022, August 24, 2018:

State from the FPU of one user land process could be exposed to
other processes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 022_fpufork.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/vm_machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/vm_machdep.c,v
retrieving revision 1.40.2.1
diff -u -p -r1.40.2.1 vm_machdep.c
--- sys/arch/amd64/amd64/vm_machdep.c	22 Jun 2018 13:05:33 -0000	1.40.2.1
+++ sys/arch/amd64/amd64/vm_machdep.c	21 Aug 2018 19:43:42 -0000
@@ -72,13 +72,15 @@ void
 cpu_fork(struct proc *p1, struct proc *p2, void *stack, void *tcb,
     void (*func)(void *), void *arg)
 {
+	struct cpu_info *ci = curcpu();
 	struct pcb *pcb = &p2->p_addr->u_pcb;
 	struct pcb *pcb1 = &p1->p_addr->u_pcb;
 	struct trapframe *tf;
 	struct switchframe *sf;
 
 	/* Save the fpu h/w state to p1's pcb so that we can copy it. */
-	fpusave(&pcb1->pcb_savefpu);
+	if (p1 != &proc0 && (ci->ci_flags & CPUF_USERXSTATE))
+		fpusave(&pcb1->pcb_savefpu);
 
 	p2->p_md.md_flags = p1->p_md.md_flags;
 
