untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT5lR0j+sCNPdaYGoT4b5iS35Hth/VPTkY2IDQtcgEDYtWKz0EeqyzpzFhvuKSg7QSP3FurSYd00ya/xUoPtAZQ8=

OpenBSD 6.5 errata 036, May 10, 2020:

ospfd could generate corrupt OSPF Router (Type 1) LSAs in certain situations.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 036_ospfd_lsa.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ospfd:
    cd /usr/src/usr.sbin/ospfd
    make obj
    make clean
    make
    make install

Index: usr.sbin/ospfd/lsupdate.c
===================================================================
RCS file: /cvs/src/usr.sbin/ospfd/lsupdate.c,v
retrieving revision 1.45
diff -u -p -r1.45 lsupdate.c
--- usr.sbin/ospfd/lsupdate.c	26 Dec 2016 17:38:14 -0000	1.45
+++ usr.sbin/ospfd/lsupdate.c	6 May 2020 20:10:47 -0000
@@ -175,8 +175,8 @@ int
 add_ls_update(struct ibuf *buf, struct iface *iface, void *data, u_int16_t len,
     u_int16_t older)
 {
-	void		*lsage;
-	u_int16_t	 age;
+	size_t		ageoff;
+	u_int16_t	age;
 
 	if ((size_t)iface->mtu < sizeof(struct ip) + sizeof(struct ospf_hdr) +
 	    sizeof(u_int32_t) + ibuf_size(buf) + len + MD5_DIGEST_LENGTH) {
@@ -186,7 +186,7 @@ add_ls_update(struct ibuf *buf, struct i
 			return (0);
 	}
 
-	lsage = ibuf_reserve(buf, 0);
+	ageoff = ibuf_size(buf);
 	if (ibuf_add(buf, data, len)) {
 		log_warn("add_ls_update");
 		return (0);
@@ -198,7 +198,7 @@ add_ls_update(struct ibuf *buf, struct i
 	if ((age += older + iface->transmit_delay) >= MAX_AGE)
 		age = MAX_AGE;
 	age = htons(age);
-	memcpy(lsage, &age, sizeof(age));
+	memcpy(ibuf_seek(buf, ageoff, sizeof(age)), &age, sizeof(age));
 
 	return (1);
 }
