untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3iwHXQk8YMhMhXw/fWdV4rCfk6/SL3NxnuOudPSIKsvCw+amx3gjeot8JpjIcZi/ild5muNrBt6wsi7Ap8fkJwQ=

OpenBSD 6.7 errata 003, May 22, 2020:

When attempting to download resident keys from a FIDO token that does
not require a password/PIN, ssh-keygen would crash with a NULL
dereference.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 003_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ospfd:
    cd /usr/src/usr.bin/ssh/ssh-keygen
    make obj
    make clean
    make
    make install

Index: usr.bin/ssh/ssh-keygen.c
===================================================================
diff -u -p -r1.410 -r1.411
--- usr.bin/ssh/ssh-keygen.c	13 May 2020 09:55:57 -0000	1.410
+++ usr.bin/ssh/ssh-keygen.c	18 May 2020 04:29:35 -0000	1.411
@@ -1,4 +1,4 @@
-/* $OpenBSD: ssh-keygen.c,v 1.410 2020/05/13 09:55:57 djm Exp $ */
+/* $OpenBSD: ssh-keygen.c,v 1.411 2020/05/18 04:29:35 djm Exp $ */
 /*
  * Author: Tatu Ylonen <ylo@cs.hut.fi>
  * Copyright (c) 1994 Tatu Ylonen <ylo@cs.hut.fi>, Espoo, Finland
@@ -2932,14 +2932,16 @@ do_download_sk(const char *skprovider, c
 		    &keys, &nkeys)) != 0) {
 			if (i == 0 && r == SSH_ERR_KEY_WRONG_PASSPHRASE)
 				continue;
-			freezero(pin, strlen(pin));
+			if (pin != NULL)
+				freezero(pin, strlen(pin));
 			error("Unable to load resident keys: %s", ssh_err(r));
 			return -1;
 		}
 	}
 	if (nkeys == 0)
 		logit("No keys to download");
-	freezero(pin, strlen(pin));
+	if (pin != NULL)
+		freezero(pin, strlen(pin));
 
 	for (i = 0; i < nkeys; i++) {
 		if (keys[i]->type != KEY_ECDSA_SK &&
