untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2mhu6ysq+2q42V7hPMLeKUV6DmxLM+8u8Gn701REbmm9juhggMukzTzqGUu+HB7wbJTUz3v4UjgDA6Rj5Loi1Ak=

OpenBSD 6.8 errata 024, June 8, 2021:

Disable PPGTT on Intel machines with cherryview/braswell graphics
to avoid memory corruption.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 024_inteldrm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/i915/i915_pci.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/i915_pci.c,v
diff -u -p -r1.4 i915_pci.c
--- sys/dev/pci/drm/i915/i915_pci.c	1 Jul 2020 02:08:14 -0000	1.4
+++ sys/dev/pci/drm/i915/i915_pci.c	4 Jun 2021 03:44:03 -0000
@@ -598,7 +598,15 @@ static const struct intel_device_info ch
 	.has_logical_ring_contexts = 0,
 #endif
 	.display.has_gmch = 1,
+#ifdef __linux__
 	.ppgtt_type = INTEL_PPGTT_ALIASING,
+#else
+	/*
+	 * Enabling aliasing ppgtt results in struct gen6_ppgtt
+	 * being overwritten.
+	 */
+	.ppgtt_type = INTEL_PPGTT_NONE,
+#endif
 	.ppgtt_size = 32,
 	.has_reset_engine = 1,
 	.has_snoop = true,
