untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46MNdiIS9XR9Qvk43P4o5EZ9EDtk04KAn+jb9xKTRZm1TuBzM5RK2ZDX5akfhCvKm0X673KhXfKTHJUgsQPEouw8=

OpenBSD 6.9 errata 029, February 2, 2022:

Fix two security issues in libexpat related to integer overflow.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 029_expat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libexpat:
    cd /usr/src/lib/libexpat
    make obj
    make
    make install

Index: lib/libexpat/Changes
===================================================================
RCS file: /cvs/src/lib/libexpat/Changes,v
retrieving revision 1.15.2.1
diff -u -p -r1.15.2.1 Changes
--- lib/libexpat/Changes	17 Jan 2022 21:13:06 -0000	1.15.2.1
+++ lib/libexpat/Changes	30 Jan 2022 23:31:10 -0000
@@ -3,6 +3,19 @@ NOTE: We are looking for help with a few
       If you can help, please get in touch.  Thanks!
 
         Security fixes:
+            #550  CVE-2022-23852 -- Fix signed integer overflow
+                    (undefined behavior) in function XML_GetBuffer
+                    (that is also called by function XML_Parse internally)
+                    for when XML_CONTEXT_BYTES is defined to >0 (which is both
+                    common and default).
+                    Impact is denial of service or more.
+            #551  CVE-2022-23990 -- Fix unsigned integer overflow in function
+                    doProlog triggered by large content in element type
+                    declarations when there is an element declaration handler
+                    present (from a prior call to XML_SetElementDeclHandler).
+                    Impact is denial of service or more.
+
+        Security fixes:
        #531 #534  CVE-2021-45960 -- Fix issues with left shifts by >=29 places
                     resulting in
                       a) realloc acting as free
Index: lib/libexpat/lib/xmlparse.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmlparse.c,v
retrieving revision 1.26.2.1
diff -u -p -r1.26.2.1 xmlparse.c
--- lib/libexpat/lib/xmlparse.c	17 Jan 2022 21:13:06 -0000	1.26.2.1
+++ lib/libexpat/lib/xmlparse.c	30 Jan 2022 23:31:24 -0000
@@ -9,6 +9,7 @@
    Copyright (c) 1997-2000 Thai Open Source Software Center Ltd
    Copyright (c) 2000-2017 Expat development team
    Copyright (c) 2016-2022 Sebastian Pipping <sebastian@pipping.org>
+   Copyright (c) 2022      Samanta Navarro <ferivoz@riseup.net>
    Licensed under the MIT license:
 
    Permission is  hereby granted,  free of charge,  to any  person obtaining
@@ -1776,6 +1777,11 @@ XML_GetBuffer(XML_Parser parser, int len
     keep = (int)EXPAT_SAFE_PTR_DIFF(parser->m_bufferPtr, parser->m_buffer);
     if (keep > XML_CONTEXT_BYTES)
       keep = XML_CONTEXT_BYTES;
+    /* Detect and prevent integer overflow */
+    if (keep > INT_MAX - neededSize) {
+      parser->m_errorCode = XML_ERROR_NO_MEMORY;
+      return NULL;
+    }
     neededSize += keep;
 #endif /* defined XML_CONTEXT_BYTES */
     if (neededSize
@@ -4926,7 +4932,7 @@ doProlog(XML_Parser parser, const ENCODI
       if (dtd->in_eldecl) {
         ELEMENT_TYPE *el;
         const XML_Char *name;
-        int nameLen;
+        size_t nameLen;
         const char *nxt
             = (quant == XML_CQUANT_NONE ? next : next - enc->minBytesPerChar);
         int myindex = nextScaffoldPart(parser);
@@ -4942,7 +4948,13 @@ doProlog(XML_Parser parser, const ENCODI
         nameLen = 0;
         for (; name[nameLen++];)
           ;
-        dtd->contentStringLen += nameLen;
+
+        /* Detect and prevent integer overflow */
+        if (nameLen > UINT_MAX - dtd->contentStringLen) {
+          return XML_ERROR_NO_MEMORY;
+        }
+
+        dtd->contentStringLen += (unsigned)nameLen;
         if (parser->m_elementDeclHandler)
           handleDefault = XML_FALSE;
       }
Index: lib/libexpat/tests/runtests.c
===================================================================
RCS file: /cvs/src/lib/libexpat/tests/runtests.c,v
retrieving revision 1.10
diff -u -p -r1.10 runtests.c
--- lib/libexpat/tests/runtests.c	29 Dec 2020 16:59:42 -0000	1.10
+++ lib/libexpat/tests/runtests.c	30 Jan 2022 23:31:50 -0000
@@ -3860,6 +3860,30 @@ START_TEST(test_get_buffer_2) {
 }
 END_TEST
 
+/* Test for signed integer overflow CVE-2022-23852 */
+#if defined(XML_CONTEXT_BYTES)
+START_TEST(test_get_buffer_3_overflow) {
+  XML_Parser parser = XML_ParserCreate(NULL);
+  assert(parser != NULL);
+
+  const char *const text = "\n";
+  const int expectedKeepValue = (int)strlen(text);
+
+  // After this call, variable "keep" in XML_GetBuffer will
+  // have value expectedKeepValue
+  if (XML_Parse(parser, text, (int)strlen(text), XML_FALSE /* isFinal */)
+      == XML_STATUS_ERROR)
+    xml_failure(parser);
+
+  assert(expectedKeepValue > 0);
+  if (XML_GetBuffer(parser, INT_MAX - expectedKeepValue + 1) != NULL)
+    fail("enlarging buffer not failed");
+
+  XML_ParserFree(parser);
+}
+END_TEST
+#endif // defined(XML_CONTEXT_BYTES)
+
 /* Test position information macros */
 START_TEST(test_byte_info_at_end) {
   const char *text = "<doc></doc>";
@@ -11353,6 +11377,9 @@ make_suite(void) {
   tcase_add_test(tc_basic, test_empty_parse);
   tcase_add_test(tc_basic, test_get_buffer_1);
   tcase_add_test(tc_basic, test_get_buffer_2);
+#if defined(XML_CONTEXT_BYTES)
+  tcase_add_test(tc_basic, test_get_buffer_3_overflow);
+#endif
   tcase_add_test(tc_basic, test_byte_info_at_end);
   tcase_add_test(tc_basic, test_byte_info_at_error);
   tcase_add_test(tc_basic, test_byte_info_at_cdata);
