untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46KPU6k6tmRU21GJNByVaxamFKGGQEH4h3FmzACUMbwjLyWQ2iEumzSIO9uXUV9uSIVSyF5D/if/NR4fbTOUFIQc=

OpenBSD 6.9 errata 028, February 2, 2022:

Userspace controlled code on GPU can access kernel memory on Intel
gen 8 and later GPUs.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 028_gpuflush.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/i915/i915_reg.h
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/i915_reg.h,v
retrieving revision 1.22
diff -u -p -r1.22 i915_reg.h
--- sys/dev/pci/drm/i915/i915_reg.h	26 Jun 2020 05:43:59 -0000	1.22
+++ sys/dev/pci/drm/i915/i915_reg.h	29 Jan 2022 23:26:10 -0000
@@ -2615,6 +2615,12 @@ static inline bool i915_mmio_reg_valid(i
 #define   GAMT_CHKN_DISABLE_DYNAMIC_CREDIT_SHARING	(1 << 28)
 #define   GAMT_CHKN_DISABLE_I2M_CYCLE_ON_WR_PORT	(1 << 24)
 
+#define GEN8_RTCR	_MMIO(0x4260)
+#define GEN8_M1TCR	_MMIO(0x4264)
+#define GEN8_M2TCR	_MMIO(0x4268)
+#define GEN8_BTCR	_MMIO(0x426c)
+#define GEN8_VTCR	_MMIO(0x4270)
+
 #if 0
 #define PRB0_TAIL	_MMIO(0x2030)
 #define PRB0_HEAD	_MMIO(0x2034)
@@ -2702,6 +2708,11 @@ static inline bool i915_mmio_reg_valid(i
 #define GEN12_FAULT_TLB_DATA1		_MMIO(0xcebc)
 #define   FAULT_VA_HIGH_BITS		(0xf << 0)
 #define   FAULT_GTT_SEL			(1 << 4)
+
+#define GEN12_GFX_TLB_INV_CR	_MMIO(0xced8)
+#define GEN12_VD_TLB_INV_CR	_MMIO(0xcedc)
+#define GEN12_VE_TLB_INV_CR	_MMIO(0xcee0)
+#define GEN12_BLT_TLB_INV_CR	_MMIO(0xcee4)
 
 #define GEN12_AUX_ERR_DBG		_MMIO(0x43f4)
 
Index: sys/dev/pci/drm/i915/i915_vma.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/i915_vma.c,v
retrieving revision 1.5
diff -u -p -r1.5 i915_vma.c
--- sys/dev/pci/drm/i915/i915_vma.c	11 Oct 2020 05:45:33 -0000	1.5
+++ sys/dev/pci/drm/i915/i915_vma.c	29 Jan 2022 22:48:41 -0000
@@ -456,6 +456,9 @@ int i915_vma_bind(struct i915_vma *vma,
 			return ret;
 	}
 
+	if (vma->obj)
+		set_bit(I915_BO_WAS_BOUND_BIT, &vma->obj->flags);
+
 	atomic_or(bind_flags, &vma->flags);
 	return 0;
 }
Index: sys/dev/pci/drm/i915/gem/i915_gem_object_types.h
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gem/i915_gem_object_types.h,v
retrieving revision 1.1
diff -u -p -r1.1 i915_gem_object_types.h
--- sys/dev/pci/drm/i915/gem/i915_gem_object_types.h	8 Jun 2020 04:48:13 -0000	1.1
+++ sys/dev/pci/drm/i915/gem/i915_gem_object_types.h	29 Jan 2022 22:53:02 -0000
@@ -145,6 +145,7 @@ struct drm_i915_gem_object {
 #define I915_BO_ALLOC_VOLATILE   BIT(1)
 #define I915_BO_ALLOC_FLAGS (I915_BO_ALLOC_CONTIGUOUS | I915_BO_ALLOC_VOLATILE)
 #define I915_BO_READONLY         BIT(2)
+#define I915_BO_WAS_BOUND_BIT    3
 
 	/*
 	 * Is the object to be mapped as read-only to the GPU
Index: sys/dev/pci/drm/i915/gem/i915_gem_pages.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gem/i915_gem_pages.c,v
retrieving revision 1.2
diff -u -p -r1.2 i915_gem_pages.c
--- sys/dev/pci/drm/i915/gem/i915_gem_pages.c	14 Jun 2020 15:20:07 -0000	1.2
+++ sys/dev/pci/drm/i915/gem/i915_gem_pages.c	29 Jan 2022 22:45:42 -0000
@@ -10,6 +10,8 @@
 #include "i915_gem_lmem.h"
 #include "i915_gem_mman.h"
 
+#include "gt/intel_gt.h"
+
 void __i915_gem_object_set_pages(struct drm_i915_gem_object *obj,
 				 struct sg_table *pages,
 				 unsigned int sg_page_sizes)
@@ -187,6 +189,14 @@ __i915_gem_object_unset_pages(struct drm
 
 	__i915_gem_object_reset_page_iter(obj);
 	obj->mm.page_sizes.phys = obj->mm.page_sizes.sg = 0;
+
+	if (test_and_clear_bit(I915_BO_WAS_BOUND_BIT, &obj->flags)) {
+		struct drm_i915_private *i915 = to_i915(obj->base.dev);
+		intel_wakeref_t wakeref;
+
+		with_intel_runtime_pm_if_in_use(&i915->runtime_pm, wakeref)
+			intel_gt_invalidate_tlbs(&i915->gt);
+	}
 
 	return pages;
 }
Index: sys/dev/pci/drm/i915/gt/intel_gt.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gt/intel_gt.c,v
retrieving revision 1.2
diff -u -p -r1.2 intel_gt.c
--- sys/dev/pci/drm/i915/gt/intel_gt.c	22 Aug 2020 06:18:08 -0000	1.2
+++ sys/dev/pci/drm/i915/gt/intel_gt.c	29 Jan 2022 23:44:41 -0000
@@ -23,6 +23,8 @@ void intel_gt_init_early(struct intel_gt
 
 	mtx_init(&gt->irq_lock, IPL_TTY);
 
+	rw_init(&gt->tlb_invalidate_lock, "itlbinv");
+
 	INIT_LIST_HEAD(&gt->closed_vma);
 	mtx_init(&gt->closed_lock, IPL_TTY);
 
@@ -680,4 +682,103 @@ void intel_gt_driver_late_release(struct
 	intel_gt_fini_reset(gt);
 	intel_gt_fini_timelines(gt);
 	intel_engines_free(gt);
+}
+
+struct reg_and_bit {
+	i915_reg_t reg;
+	u32 bit;
+};
+
+static struct reg_and_bit
+get_reg_and_bit(const struct intel_engine_cs *engine, const bool gen8,
+		const i915_reg_t *regs, const unsigned int num)
+{
+	const unsigned int class = engine->class;
+	struct reg_and_bit rb = { };
+
+	if (drm_WARN_ON_ONCE(&engine->i915->drm,
+			     class >= num || !regs[class].reg))
+		return rb;
+
+	rb.reg = regs[class];
+	if (gen8 && class == VIDEO_DECODE_CLASS)
+		rb.reg.reg += 4 * engine->instance; /* GEN8_M2TCR */
+	else
+		rb.bit = engine->instance;
+
+	rb.bit = BIT(rb.bit);
+
+	return rb;
+}
+
+void intel_gt_invalidate_tlbs(struct intel_gt *gt)
+{
+	static const i915_reg_t gen8_regs[] = {
+		[RENDER_CLASS]			= GEN8_RTCR,
+		[VIDEO_DECODE_CLASS]		= GEN8_M1TCR, /* , GEN8_M2TCR */
+		[VIDEO_ENHANCEMENT_CLASS]	= GEN8_VTCR,
+		[COPY_ENGINE_CLASS]		= GEN8_BTCR,
+	};
+	static const i915_reg_t gen12_regs[] = {
+		[RENDER_CLASS]			= GEN12_GFX_TLB_INV_CR,
+		[VIDEO_DECODE_CLASS]		= GEN12_VD_TLB_INV_CR,
+		[VIDEO_ENHANCEMENT_CLASS]	= GEN12_VE_TLB_INV_CR,
+		[COPY_ENGINE_CLASS]		= GEN12_BLT_TLB_INV_CR,
+	};
+	struct drm_i915_private *i915 = gt->i915;
+	struct intel_uncore *uncore = gt->uncore;
+	struct intel_engine_cs *engine;
+	enum intel_engine_id id;
+	const i915_reg_t *regs;
+	unsigned int num = 0;
+
+	if (I915_SELFTEST_ONLY(gt->awake == -ENODEV))
+		return;
+
+	if (INTEL_GEN(i915) == 12) {
+		regs = gen12_regs;
+		num = ARRAY_SIZE(gen12_regs);
+	} else if (INTEL_GEN(i915) >= 8 && INTEL_GEN(i915) <= 11) {
+		regs = gen8_regs;
+		num = ARRAY_SIZE(gen8_regs);
+	} else if (INTEL_GEN(i915) < 8) {
+		return;
+	}
+
+	if (drm_WARN_ONCE(&i915->drm, !num,
+			  "Platform does not implement TLB invalidation!"))
+		return;
+
+	GEM_TRACE("\n");
+
+	assert_rpm_wakelock_held(&i915->runtime_pm);
+
+	mutex_lock(&gt->tlb_invalidate_lock);
+	intel_uncore_forcewake_get(uncore, FORCEWAKE_ALL);
+
+	for_each_engine(engine, gt, id) {
+		/*
+		 * HW architecture suggest typical invalidation time at 40us,
+		 * with pessimistic cases up to 100us and a recommendation to
+		 * cap at 1ms. We go a bit higher just in case.
+		 */
+		const unsigned int timeout_us = 100;
+		const unsigned int timeout_ms = 4;
+		struct reg_and_bit rb;
+
+		rb = get_reg_and_bit(engine, regs == gen8_regs, regs, num);
+		if (!i915_mmio_reg_offset(rb.reg))
+			continue;
+
+		intel_uncore_write_fw(uncore, rb.reg, rb.bit);
+		if (__intel_wait_for_register_fw(uncore,
+						 rb.reg, rb.bit, 0,
+						 timeout_us, timeout_ms,
+						 NULL))
+			DRM_ERROR_RATELIMITED("%s TLB invalidation did not complete in %ums!\n",
+					      engine->name, timeout_ms);
+	}
+
+	intel_uncore_forcewake_put(uncore, FORCEWAKE_ALL);
+	mutex_unlock(&gt->tlb_invalidate_lock);
 }
Index: sys/dev/pci/drm/i915/gt/intel_gt.h
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gt/intel_gt.h,v
retrieving revision 1.1
diff -u -p -r1.1 intel_gt.h
--- sys/dev/pci/drm/i915/gt/intel_gt.h	8 Jun 2020 04:48:13 -0000	1.1
+++ sys/dev/pci/drm/i915/gt/intel_gt.h	29 Jan 2022 22:45:42 -0000
@@ -57,6 +57,8 @@ static inline u32 intel_gt_scratch_offse
 {
 	return i915_ggtt_offset(gt->scratch) + field;
 }
+void intel_gt_invalidate_tlbs(struct intel_gt *gt);
+
 
 static inline bool intel_gt_is_wedged(const struct intel_gt *gt)
 {
Index: sys/dev/pci/drm/i915/gt/intel_gt_types.h
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gt/intel_gt_types.h,v
retrieving revision 1.1
diff -u -p -r1.1 intel_gt_types.h
--- sys/dev/pci/drm/i915/gt/intel_gt_types.h	8 Jun 2020 04:48:13 -0000	1.1
+++ sys/dev/pci/drm/i915/gt/intel_gt_types.h	29 Jan 2022 22:54:39 -0000
@@ -35,6 +35,8 @@ struct intel_gt {
 
 	struct intel_uc uc;
 
+	struct rwlock tlb_invalidate_lock;
+
 	struct intel_gt_timelines {
 		spinlock_t lock; /* protects active_list */
 		struct list_head active_list;
