untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTZkYQsJc8PV9EJCorS0695DBabC2/FYKz8pcwZc0O+/uXRXs6g9HGBjmz/byrI3XBgzYXeLJnWtZozxD3t2HIQw=

OpenBSD 7.1 errata 002, May 5, 2022:

When using IPsec, the kernel could crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 002_ipsec.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_ipsp.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_ipsp.c,v
diff -u -p -r1.269 ip_ipsp.c
--- sys/netinet/ip_ipsp.c	10 Mar 2022 15:21:08 -0000	1.269
+++ sys/netinet/ip_ipsp.c	1 May 2022 13:25:14 -0000
@@ -1205,7 +1205,7 @@ ipsp_ids_insert(struct ipsec_ids *ids)
 	found = RBT_INSERT(ipsec_ids_tree, &ipsec_ids_tree, ids);
 	if (found) {
 		/* if refcount was zero, then timeout is running */
-		if (atomic_inc_int_nv(&found->id_refcount) == 1) {
+		if ((++found->id_refcount) == 1) {
 			LIST_REMOVE(found, id_gc_list);
 
 			if (LIST_EMPTY(&ipsp_ids_gc_list))
@@ -1248,7 +1248,12 @@ ipsp_ids_lookup(u_int32_t ipsecflowinfo)
 
 	mtx_enter(&ipsec_flows_mtx);
 	ids = RBT_FIND(ipsec_ids_flows, &ipsec_ids_flows, &key);
-	atomic_inc_int(&ids->id_refcount);
+	if (ids != NULL) {
+		if (ids->id_refcount != 0)
+			ids->id_refcount++;
+		else
+			ids = NULL;
+	}
 	mtx_leave(&ipsec_flows_mtx);
 
 	return ids;
@@ -1290,6 +1295,8 @@ ipsp_ids_free(struct ipsec_ids *ids)
 	if (ids == NULL)
 		return;
 
+	mtx_enter(&ipsec_flows_mtx);
+
 	/*
 	 * If the refcount becomes zero, then a timeout is started. This
 	 * timeout must be cancelled if refcount is increased from zero.
@@ -1297,10 +1304,10 @@ ipsp_ids_free(struct ipsec_ids *ids)
 	DPRINTF("ids %p count %d", ids, ids->id_refcount);
 	KASSERT(ids->id_refcount > 0);
 
-	if (atomic_dec_int_nv(&ids->id_refcount) > 0)
+	if ((--ids->id_refcount) > 0) {
+		mtx_leave(&ipsec_flows_mtx);
 		return;
-
-	mtx_enter(&ipsec_flows_mtx);
+	}
 
 	/*
 	 * Add second for the case ipsp_ids_gc() is already running and
