untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8AQC/6HPpggBwdS4j0S7U1+zok563OzQCUTFQxttQuxy4Rotv3mczkYnzqULlinrvo0c/Ohlx4qkqnxsdXZHNA8=

OpenBSD 7.2 errata 013, January 13, 2023:

A TCP packet with destination port 0 that matches a pf divert-to
rule could crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 013_tcp.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
diff -u -p -r1.1140.2.1 pf.c
--- sys/net/pf.c	24 Nov 2022 22:51:23 -0000	1.1140.2.1
+++ sys/net/pf.c	10 Jan 2023 11:06:36 -0000
@@ -6847,7 +6847,8 @@ pf_setup_pdesc(struct pf_pdesc *pd, sa_f
 		    NULL, reason, pd->af))
 			return (PF_DROP);
 		pd->hdrlen = sizeof(*th);
-		if (pd->off + (th->th_off << 2) > pd->tot_len ||
+		if (th->th_dport == 0 ||
+		    pd->off + (th->th_off << 2) > pd->tot_len ||
 		    (th->th_off << 2) < sizeof(struct tcphdr)) {
 			REASON_SET(reason, PFRES_SHORT);
 			return (PF_DROP);
Index: sys/netinet/tcp_input.c
===================================================================
RCS file: /cvs/src/sys/netinet/tcp_input.c,v
diff -u -p -r1.380 tcp_input.c
--- sys/netinet/tcp_input.c	3 Sep 2022 19:22:19 -0000	1.380
+++ sys/netinet/tcp_input.c	10 Jan 2023 11:06:37 -0000
@@ -522,6 +522,11 @@ tcp_input(struct mbuf **mp, int *offp, i
 	th->th_win = ntohs(th->th_win);
 	th->th_urp = ntohs(th->th_urp);
 
+	if (th->th_dport == 0) {
+		tcpstat_inc(tcps_noport);
+		goto dropwithreset_ratelim;
+	}
+
 	/*
 	 * Locate pcb for segment.
 	 */
