untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFppvU9/OP1h+1KjPyUTv/nQp+ku47/f6Opd3f34j2R7Kc3YIgjPPFkZ35trGGHMm2kkHzSchLs1oSVksx/eLiAw=

OpenBSD 7.3 errata 018, October 25, 2023:

Fix several input validation errors in the X server.
CVE-2023-5367 CVE-2023-5380 CVE-2023-5574

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 018_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xi/xiproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/xiproperty.c,v
diff -u -p -r1.13 xiproperty.c
--- xserver/Xi/xiproperty.c	14 Dec 2022 10:29:00 -0000	1.13
+++ xserver/Xi/xiproperty.c	16 Oct 2023 17:20:50 -0000
@@ -730,7 +730,7 @@ XIChangeDeviceProperty(DeviceIntPtr dev,
                 XIDestroyDeviceProperty(prop);
             return BadAlloc;
         }
-        new_value.size = len;
+        new_value.size = total_len;
         new_value.type = type;
         new_value.format = format;
 
@@ -747,7 +747,7 @@ XIChangeDeviceProperty(DeviceIntPtr dev,
         case PropModePrepend:
             new_data = new_value.data;
             old_data = (void *) (((char *) new_value.data) +
-                                  (prop_value->size * size_in_bytes));
+                                  (len * size_in_bytes));
             break;
         }
         if (new_data)
Index: xserver/dix/enterleave.h
===================================================================
RCS file: /cvs/xenocara/xserver/dix/enterleave.h,v
diff -u -p -r1.5 enterleave.h
--- xserver/dix/enterleave.h	29 May 2016 12:02:35 -0000	1.5
+++ xserver/dix/enterleave.h	16 Oct 2023 17:20:50 -0000
@@ -58,8 +58,6 @@ extern void DeviceFocusEvent(DeviceIntPt
 
 extern void EnterWindow(DeviceIntPtr dev, WindowPtr win, int mode);
 
-extern void LeaveWindow(DeviceIntPtr dev);
-
 extern void CoreFocusEvent(DeviceIntPtr kbd,
                            int type, int mode, int detail, WindowPtr pWin);
 
Index: xserver/fb/fb.h
===================================================================
RCS file: /cvs/xenocara/xserver/fb/fb.h,v
diff -u -p -r1.13 fb.h
--- xserver/fb/fb.h	27 Jul 2019 07:57:09 -0000	1.13
+++ xserver/fb/fb.h	16 Oct 2023 17:20:50 -0000
@@ -410,6 +410,7 @@ typedef struct {
 #endif
     DevPrivateKeyRec    gcPrivateKeyRec;
     DevPrivateKeyRec    winPrivateKeyRec;
+    CloseScreenProcPtr  CloseScreen;
 } FbScreenPrivRec, *FbScreenPrivPtr;
 
 #define fbGetScreenPrivate(pScreen) ((FbScreenPrivPtr) \
Index: xserver/fb/fbscreen.c
===================================================================
RCS file: /cvs/xenocara/xserver/fb/fbscreen.c,v
diff -u -p -r1.11 fbscreen.c
--- xserver/fb/fbscreen.c	27 Jul 2019 07:57:10 -0000	1.11
+++ xserver/fb/fbscreen.c	16 Oct 2023 17:20:50 -0000
@@ -29,6 +29,7 @@
 Bool
 fbCloseScreen(ScreenPtr pScreen)
 {
+    FbScreenPrivPtr screen_priv = fbGetScreenPrivate(pScreen);
     int d;
     DepthPtr depths = pScreen->allowedDepths;
 
@@ -37,9 +38,10 @@ fbCloseScreen(ScreenPtr pScreen)
         free(depths[d].vids);
     free(depths);
     free(pScreen->visuals);
-    if (pScreen->devPrivate)
-        FreePixmap((PixmapPtr)pScreen->devPrivate);
-    return TRUE;
+
+    pScreen->CloseScreen = screen_priv->CloseScreen;
+
+    return pScreen->CloseScreen(pScreen);
 }
 
 Bool
@@ -144,6 +146,7 @@ fbFinishScreenInit(ScreenPtr pScreen, vo
                    int dpix, int dpiy, int width, int bpp)
 #endif
 {
+    FbScreenPrivPtr screen_priv;
     VisualPtr visuals;
     DepthPtr depths;
     int nvisuals;
@@ -177,8 +180,11 @@ fbFinishScreenInit(ScreenPtr pScreen, vo
                       rootdepth, ndepths, depths,
                       defaultVisual, nvisuals, visuals))
         return FALSE;
-    /* overwrite miCloseScreen with our own */
+
+    screen_priv = fbGetScreenPrivate(pScreen);
+    screen_priv->CloseScreen = pScreen->CloseScreen;
     pScreen->CloseScreen = fbCloseScreen;
+
     return TRUE;
 }
 
Index: xserver/hw/vfb/InitOutput.c
===================================================================
RCS file: /cvs/xenocara/xserver/hw/vfb/InitOutput.c,v
diff -u -p -r1.17 InitOutput.c
--- xserver/hw/vfb/InitOutput.c	11 Nov 2021 09:03:05 -0000	1.17
+++ xserver/hw/vfb/InitOutput.c	16 Oct 2023 17:20:50 -0000
@@ -727,13 +727,6 @@ vfbCloseScreen(ScreenPtr pScreen)
 
     pScreen->CloseScreen = pvfb->closeScreen;
 
-    /*
-     * fb overwrites miCloseScreen, so do this here
-     */
-    if (pScreen->devPrivate)
-        (*pScreen->DestroyPixmap) (pScreen->devPrivate);
-    pScreen->devPrivate = NULL;
-
     return pScreen->CloseScreen(pScreen);
 }
 
Index: xserver/include/eventstr.h
===================================================================
RCS file: /cvs/xenocara/xserver/include/eventstr.h,v
diff -u -p -r1.11 eventstr.h
--- xserver/include/eventstr.h	11 Nov 2021 09:03:13 -0000	1.11
+++ xserver/include/eventstr.h	16 Oct 2023 17:20:51 -0000
@@ -335,4 +335,7 @@ union _InternalEvent {
     GestureEvent gesture_event;
 };
 
+extern void
+LeaveWindow(DeviceIntPtr dev);
+
 #endif
Index: xserver/mi/mipointer.c
===================================================================
RCS file: /cvs/xenocara/xserver/mi/mipointer.c,v
diff -u -p -r1.13 mipointer.c
--- xserver/mi/mipointer.c	11 Nov 2021 09:03:13 -0000	1.13
+++ xserver/mi/mipointer.c	16 Oct 2023 17:20:51 -0000
@@ -397,8 +397,21 @@ miPointerWarpCursor(DeviceIntPtr pDev, S
 #ifdef PANORAMIX
         && noPanoramiXExtension
 #endif
-        )
-        UpdateSpriteForScreen(pDev, pScreen);
+        ) {
+            DeviceIntPtr master = GetMaster(pDev, MASTER_POINTER);
+            /* Hack for CVE-2023-5380: if we're moving
+             * screens PointerWindows[] keeps referring to the
+             * old window. If that gets destroyed we have a UAF
+             * bug later. Only happens when jumping from a window
+             * to the root window on the other screen.
+             * Enter/Leave events are incorrect for that case but
+             * too niche to fix.
+             */
+            LeaveWindow(pDev);
+            if (master)
+                LeaveWindow(master);
+            UpdateSpriteForScreen(pDev, pScreen);
+    }
 }
 
 /**
Index: xserver/mi/miscrinit.c
===================================================================
RCS file: /cvs/xenocara/xserver/mi/miscrinit.c,v
diff -u -p -r1.14 miscrinit.c
--- xserver/mi/miscrinit.c	11 Nov 2021 09:03:13 -0000	1.14
+++ xserver/mi/miscrinit.c	16 Oct 2023 17:20:51 -0000
@@ -249,10 +249,10 @@ miScreenInit(ScreenPtr pScreen, void *pb
     pScreen->numVisuals = numVisuals;
     pScreen->visuals = visuals;
     if (width) {
+        pScreen->CloseScreen = miCloseScreen;
 #ifdef MITSHM
         ShmRegisterFbFuncs(pScreen);
 #endif
-        pScreen->CloseScreen = miCloseScreen;
     }
     /* else CloseScreen */
     /* QueryBestSize */
Index: xserver/randr/rrproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/randr/rrproperty.c,v
diff -u -p -r1.12 rrproperty.c
--- xserver/randr/rrproperty.c	27 Jul 2019 07:57:24 -0000	1.12
+++ xserver/randr/rrproperty.c	16 Oct 2023 17:20:51 -0000
@@ -209,7 +209,7 @@ RRChangeOutputProperty(RROutputPtr outpu
                 RRDestroyOutputProperty(prop);
             return BadAlloc;
         }
-        new_value.size = len;
+        new_value.size = total_len;
         new_value.type = type;
         new_value.format = format;
 
@@ -226,7 +226,7 @@ RRChangeOutputProperty(RROutputPtr outpu
         case PropModePrepend:
             new_data = new_value.data;
             old_data = (void *) (((char *) new_value.data) +
-                                  (prop_value->size * size_in_bytes));
+                                  (len * size_in_bytes));
             break;
         }
         if (new_data)
