untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWTUapAL5sADHuxaO4v+Y2VYLPIgSNcIqmuStVLbASlX4UexiGvsxvO5LS0loVnBYi4ZS5VGZ1LmRzPCFE3VAGgo=

OpenBSD 7.8 errata 003, October 28, 2025:

DNS cache poisoning vulnerabilities in unbound could lead to domain
hijacking.  CVE-2025-11411

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 003_unbound.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install unwind and unbound:
    cd /usr/src/sbin/unwind
    make obj
    make
    make install
    cd /usr/src/usr.sbin/unbound
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: sbin/unwind/libunbound/iterator/iter_scrub.c
===================================================================
RCS file: /cvs/src/sbin/unwind/libunbound/iterator/iter_scrub.c,v
diff -u -p -r1.8 iter_scrub.c
--- sbin/unwind/libunbound/iterator/iter_scrub.c	23 Feb 2025 07:53:40 -0000	1.8
+++ sbin/unwind/libunbound/iterator/iter_scrub.c	22 Oct 2025 19:20:10 -0000
@@ -634,6 +634,22 @@ scrub_normalize(sldns_buffer* pkt, struc
 					"RRset:", pkt, msg, prev, &rrset);
 				continue;
 			}
+			/* If the NS set is a promiscuous NS set, scrub that
+			 * to remove potential for poisonous contents that
+			 * affects other names in the same zone. Remove
+			 * promiscuous NS sets in positive answers, that
+			 * thus have records in the answer section. Nodata
+			 * and nxdomain promiscuous NS sets have been removed
+			 * already. Since the NS rrset is scrubbed, its
+			 * address records are also not marked to be allowed
+			 * and are removed later. */
+			if(FLAGS_GET_RCODE(msg->flags) == LDNS_RCODE_NOERROR &&
+				msg->an_rrsets != 0 &&
+				1 /* env->cfg->iter_scrub_promiscuous */) {
+				remove_rrset("normalize: removing promiscuous "
+					"RRset:", pkt, msg, prev, &rrset);
+				continue;
+			}
 			if(nsset == NULL) {
 				nsset = rrset;
 			} else {
Index: usr.sbin/unbound/iterator/iter_scrub.c
===================================================================
RCS file: /cvs/src/usr.sbin/unbound/iterator/iter_scrub.c,v
diff -u -p -r1.17 iter_scrub.c
--- usr.sbin/unbound/iterator/iter_scrub.c	21 Feb 2025 13:20:40 -0000	1.17
+++ usr.sbin/unbound/iterator/iter_scrub.c	22 Oct 2025 19:20:10 -0000
@@ -634,6 +634,22 @@ scrub_normalize(sldns_buffer* pkt, struc
 					"RRset:", pkt, msg, prev, &rrset);
 				continue;
 			}
+			/* If the NS set is a promiscuous NS set, scrub that
+			 * to remove potential for poisonous contents that
+			 * affects other names in the same zone. Remove
+			 * promiscuous NS sets in positive answers, that
+			 * thus have records in the answer section. Nodata
+			 * and nxdomain promiscuous NS sets have been removed
+			 * already. Since the NS rrset is scrubbed, its
+			 * address records are also not marked to be allowed
+			 * and are removed later. */
+			if(FLAGS_GET_RCODE(msg->flags) == LDNS_RCODE_NOERROR &&
+				msg->an_rrsets != 0 &&
+				1 /* env->cfg->iter_scrub_promiscuous */) {
+				remove_rrset("normalize: removing promiscuous "
+					"RRset:", pkt, msg, prev, &rrset);
+				continue;
+			}
 			if(nsset == NULL) {
 				nsset = rrset;
 			} else {
