/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Handle;

/**
 * The AttrFontDesc object is used to store an attribute that sets all aspects
 * of the font description at once.
 */
public class AttrFontDesc extends Attribute 
{

	/**
	 * Returns the font description which is the value of this attribute
	 */
	public FontDescription getDescription(){
		return new FontDescription( getDesc(handle) );
	}


    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected Handle getDesc (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

