/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Bitmap
 * Method:    gdk_bitmap_create_from_data
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Bitmap_gdk_1bitmap_1create_1from_1data (JNIEnv *env, 
    jclass cls, jobject window, jbyteArray data, jint width, jint height) 
{
    GdkWindow *window_g = (GdkWindow *)getPointerFromHandle(env, window);
    jint data_len = (*env)->GetArrayLength(env, data);
    gchar* data_g = (gchar*)g_malloc(data_len + 1);
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
    data_g[data_len] = 0;
    return getHandleFromPointer(env, 
    		gdk_bitmap_create_from_data (window_g, data_g, width_g, height_g));
}

#ifdef __cplusplus
}

#endif
