/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifndef _Included_org_gnu_gdk_Display
#define _Included_org_gnu_gdk_Display
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gdk_display_get_type();
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_open
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1open
  (JNIEnv *env, jclass cls, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	jobject dis = getHandleFromPointer(env, gdk_display_open(n));
	(*env)->ReleaseStringUTFChars(env, name, n);
	return dis;
}


/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1name
  (JNIEnv *env, jclass cls, jobject display)
{
	const gchar* name = gdk_display_get_name((GdkDisplay*)getPointerFromHandle(env, display));
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_n_screens
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1n_1screens
  (JNIEnv *env, jclass cls, jobject display)
{
	return (jint)gdk_display_get_n_screens((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_screen
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1screen
  (JNIEnv *env, jclass cls, jobject display, jint screenNum)
{
	return getHandleFromPointer(env, gdk_display_get_screen(
			(GdkDisplay*)getPointerFromHandle(env, display), screenNum));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default_screen
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default_1screen
  (JNIEnv *env, jclass cls, jobject display)
{
	return getHandleFromPointer(env, gdk_display_get_default_screen(
			(GdkDisplay*)getPointerFromHandle(env, display)));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_pointer_ungrab
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1pointer_1ungrab
  (JNIEnv *env, jclass cls, jobject display, jint time)
{
	gdk_display_pointer_ungrab((GdkDisplay*)getPointerFromHandle(env, display), (guint32)time);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_keyboard_ungrab
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1keyboard_1ungrab
  (JNIEnv *env, jclass cls, jobject display, jint time)
{
	gdk_display_keyboard_ungrab((GdkDisplay*)getPointerFromHandle(env, display), (guint32)time);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_pointer_is_grabbed
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1pointer_1is_1grabbed
  (JNIEnv *env, jclass cls, jobject display)
{
	return (jboolean)gdk_display_pointer_is_grabbed((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_beep
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1beep
  (JNIEnv *env, jclass cls, jobject display)
{
	gdk_display_beep((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_sync
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1sync
  (JNIEnv *env, jclass cls, jobject display)
{
	gdk_display_sync((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_flush
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1flush
  (JNIEnv *env, jclass cls, jobject display)
{
	gdk_display_flush((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_close
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1close
  (JNIEnv *env, jclass cls, jobject display)
{
	gdk_display_close((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_list_devices
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gdk_Display_gdk_1display_1list_1devices
  (JNIEnv *env, jclass cls, jobject display)
{
	return getList(env,gdk_display_list_devices((GdkDisplay*)display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_event
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1event
  (JNIEnv *env, jclass cls, jobject display)
{
	return getHandleFromPointer(env, gdk_display_get_event(
			(GdkDisplay*)getPointerFromHandle(env, display)));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_peek_event
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1peek_1event
  (JNIEnv *env, jclass cls, jobject display)
{
	return getHandleFromPointer(env, gdk_display_peek_event(
			(GdkDisplay*)getPointerFromHandle(env, display)));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_put_event
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1put_1event
  (JNIEnv *env, jclass cls, jobject display, jobject event)
{
	gdk_display_put_event((GdkDisplay*)getPointerFromHandle(env, display),
						  (GdkEvent*)getPointerFromHandle(env, event));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default
  (JNIEnv *env,  jclass cls)
{
	return getHandleFromPointer(env, gdk_display_get_default());
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_core_pointer
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1core_1pointer
  (JNIEnv *env, jclass cls, jobject display)
{
	return getHandleFromPointer(env, gdk_display_get_core_pointer(
			(GdkDisplay*)getPointerFromHandle(env, display)));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_pointer
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1pointer
  (JNIEnv *env, jclass cls, jobject display, jobject screen, jintArray xVal, jintArray yVal, jintArray mask)
{
	GdkScreen* scr = g_new(GdkScreen, 1);
	int* x = (int*)(*env)->GetIntArrayElements(env, xVal, NULL);
	int* y = (int*)(*env)->GetIntArrayElements(env, yVal, NULL);
	GdkModifierType* mod = (GdkModifierType*)(*env)->GetIntArrayElements(env, mask, NULL);
	gdk_display_get_pointer((GdkDisplay*)getPointerFromHandle(env, display), &scr, x, y, mod);
	(*env)->ReleaseIntArrayElements(env, xVal, (jint*)x, 0);
	(*env)->ReleaseIntArrayElements(env, yVal, (jint*)y, 0);
	(*env)->ReleaseIntArrayElements(env, mask, (jint*)mod, 0);
	updateHandle(env, screen, scr);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_window_at_pointer
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1window_1at_1pointer
  (JNIEnv *env, jclass cls, jobject display, jint x, jint y)
{
	return getHandleFromPointer(env, gdk_display_get_window_at_pointer(
			(GdkDisplay*)getPointerFromHandle(env, display), (gint *)&x, (gint *)&y));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_cursor_alpha
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1cursor_1alpha
  (JNIEnv *env, jclass cls, jobject display)
{
	return (jboolean)gdk_display_supports_cursor_alpha((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_cursor_color
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1cursor_1color
  (JNIEnv *env, jclass cls, jobject display)
{
	return (jboolean)gdk_display_supports_cursor_color((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default_cursor_size
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default_1cursor_1size
  (JNIEnv *env, jclass cls, jobject display)
{
	return (jint)gdk_display_get_default_cursor_size((GdkDisplay*)getPointerFromHandle(env, display));
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_maximum_cursor_size
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1maximum_1cursor_1size
  (JNIEnv *env, jclass cls, jobject display, jintArray width, jintArray height)
{
	int* w = (int*)(*env)->GetIntArrayElements(env, width, NULL);
	int* h = (int*)(*env)->GetIntArrayElements(env, height, NULL);
	gdk_display_get_maximal_cursor_size((GdkDisplay*)getPointerFromHandle(env, display), w, h);
	(*env)->ReleaseIntArrayElements(env, width, (jint*)w, 0);
	(*env)->ReleaseIntArrayElements(env, height, (jint*)h, 0);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_selection_notification
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1selection_1notification
  (JNIEnv *env, jclass cls, jobject display)
{
	GdkDisplay* display_g = (GdkDisplay*)getPointerFromHandle(env, display);
	return (jboolean)gdk_display_supports_selection_notification(display_g);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_request_selection_notification
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1request_1selection_1notification
  (JNIEnv *env, jclass cls, jobject display, jobject atom)
{
	GdkDisplay* display_g = (GdkDisplay*)getPointerFromHandle(env, display);
	GdkAtom* atom_g = (GdkAtom*)getPointerFromHandle(env, atom);
	return (jboolean)gdk_display_request_selection_notification(display_g, *atom_g);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_supports_clipboard_persistence
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Display_gdk_1display_1supports_1clipboard_1persistence
  (JNIEnv *env, jclass cls, jobject display)
{
	GdkDisplay* display_g = (GdkDisplay*)getPointerFromHandle(env, display);
	return (jboolean)gdk_display_supports_clipboard_persistence(display_g);	
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_store_clipboard
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;I[Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Display_gdk_1display_1store_1clipboard
  (JNIEnv *env, jclass cls, jobject display, jobject clipboardWindow, jint time, jobjectArray targets)
{
	GdkDisplay* display_g = (GdkDisplay*)getPointerFromHandle(env, display);
	GdkWindow* clipboardWindow_g = (GdkWindow*)getPointerFromHandle(env, clipboardWindow);
	GdkAtom* targets_g = (GdkAtom*)getPointerArrayFromHandles(env, targets);
	jint size = (*env)->GetArrayLength(env, targets);
	gdk_display_store_clipboard(display_g, clipboardWindow_g, time, targets_g, size);
}

/*
 * Class:     org_gnu_gdk_Display
 * Method:    gdk_display_get_default_group
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Display_gdk_1display_1get_1default_1group
  (JNIEnv *env, jclass cls, jobject display)
{
	GdkDisplay* display_g = (GdkDisplay*)getPointerFromHandle(env, display);
	return getHandleFromPointer(env, gdk_display_get_default_group(display_g));
}

  
  #ifdef __cplusplus
}
#endif
#endif
