/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:18:46 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.GtkObject;
/**
 * The GnomeCanvasItem is the base class of all items that a
 * GnomeCanvas displays.
 */
public class CanvasItem extends GtkObject {
	/**
	 * Constructs an instance of CanvasItem from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasItem(int handle) {
		this.handle = handle;
	}

	protected void noopInit() {
	}

	/**
	 * Apply an absolute affine transformation to the item.
	 * @param affine the affine to apply.
	 */
	public void affineAbsolute(double[] affine) {
		gnome_canvas_item_affine_absolute(handle, affine);
	}

	/**
	 * Apply a relative affine transformation to the item.
	 * @param affine The affine to apply.
	 */
	public void affineRelative(double[] affine) {
		gnome_canvas_item_affine_relative(handle, affine);
	}

	/**
	 * Returns the parent canvas for this item.
	 * @return The parent canvas.
	 */
	public Canvas getCanvas() {
		return new Canvas(getCanvas(handle));
	}

	/**
	 * Return the parent canvas group for this item.
	 * @return The parent cavas group.
	 */
	public CanvasGroup getParent() {
		return new CanvasGroup(getParent(handle));
	}

	/**
	 * X1 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The X1 coordinate.
	 */
	public double getX1() {
		return getX1(handle);
	}

	/**
	 * X2 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The X2 coordinate.
	 */
	public double getX2() {
		return getX2(handle);
	}

	/**
	 * Y1 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The Y1 coordinate.
	 */
	public double getY1() {
		return getY1(handle);
	}

	/**
	 * Y2 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The Y2 coordinate.
	 */
	public double getY2() {
		return getY2(handle);
	}

	/**
	 * Hide the item (make it invisible).  If the item is already invisible, it
	 * has no effect.
	 */
	public void hide() {
		gnome_canvas_item_hide(handle);
	}

	/**
	 * Lower the item in the z-order of its parent group by the specified
	 * number of positions.
	 * @param positions The number of positions to lower the item.
	 */
	public void lower(int positions) {
		gnome_canvas_item_lower(handle, positions);
	}

	/**
	 * Lower the item to the bottom of its parent group's z-order.
	 */
	public void lowerToBotton() {
		gnome_canvas_item_lower_to_bottom(handle);
	}

	/**
	 * Move the item by the specified amount.
	 * @param x The amount to move the item horizontally.
	 * @param y The amount to move the item vertically.
	 */
	public void move(double x, double y) {
		gnome_canvas_item_move(handle, x, y);
	}

	/**
	 * Raise the item in the z-order of its parent group by the specified
	 * number of positions.
	 * @param positions The number of positions to raise the item.
	 */
	public void raise(int positions) {
		gnome_canvas_item_raise(handle, positions);
	}

	/**
	 * Raise the item to the top of its parent group's z-order.
	 */
	public void raiseToTop() {
		gnome_canvas_item_raise_to_top(handle);
	}

	/**
	 * Show the item (make it visible).  If the item is already shown, it has
	 * no effect.
	 */
	public void show() {
		gnome_canvas_item_show(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_item_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getCanvas(int cptr);
	native static final protected int getParent(int cptr);
	native static final protected double getX1(int cptr);
	native static final protected double getY1(int cptr);
	native static final protected double getX2(int cptr);
	native static final protected double getY2(int cptr);
	native static final protected int gnome_canvas_item_get_type();
	native static final protected void gnome_canvas_item_move(int item, double dx, double dy);
	native static final protected void gnome_canvas_item_affine_relative(int item, double[] affine);
	native static final protected void gnome_canvas_item_affine_absolute(int item, double[] affine);
	native static final protected void gnome_canvas_item_raise(int item, int position);
	native static final protected void gnome_canvas_item_raise_to_top(int item);
	native static final protected void gnome_canvas_item_lower(int item, int positions);
	native static final protected void gnome_canvas_item_lower_to_bottom(int item);
	native static final protected void gnome_canvas_item_show(int item);
	native static final protected void gnome_canvas_item_hide(int item);
	native static final protected int gnome_canvas_item_grab(int item, int event_mask, int cursor, int etime);
	native static final protected void gnome_canvas_item_ungrab(int item, int etime);
	native static final protected void gnome_canvas_item_reparent(int item, int new_group);
	native static final protected void gnome_canvas_item_grab_focus(int item);
	native static final protected void gnome_canvas_item_request_update(int item);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
