/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import java.io.File;
import java.io.FileNotFoundException;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 *  
 */
public class Pixbuf extends GObject {
    /**
     * Constructs a Pixbuf from a handle to native resources. This should only
     * be used internally by java-gnome.
     */
    public Pixbuf(Handle handle) {
        super(handle);
    }

	/**
	 * Construct a new Pixbuf from an image file.
	 * @param filename The name of the image file.
	 * @throws FileNotFoundException if filename doesn't exist.
	 */
	public Pixbuf(String filename) throws FileNotFoundException {
	    super(createWithFile(filename));
	}
	
	private static Handle createWithFile(String filename) throws FileNotFoundException {
	    File aFile = new File(filename);
	    if (!aFile.exists())
	        throw new FileNotFoundException(filename);
		return gdk_pixbuf_new_from_file(filename, 0);
	}

    /**
     * Return the width of the pixbuf.
     * 
     * @return The width
     */
    public int width() {
        return gdk_pixbuf_get_width(getHandle());
    }

    /**
     * Return the height of the pixbuf.
     * 
     * @return The height
     */
    public int height() {
        return gdk_pixbuf_get_height(getHandle());
    }

    /**
     * Create a new pixbuf from an existing pixbuf scaled to the size provided.
     */
    public Pixbuf scale(int width, int height, org.gnu.gdk.InterpType itype) {
        Handle newH = gdk_pixbuf_scale_simple(getHandle(), width, height, itype.getValue());
        return new Pixbuf(newH);
    }

    /***************************************************************************
     * BEGINNING OF GENERATED CODE
     **************************************************************************/
    native static final protected void gdk_pixbuf_render_threshold_alpha(
            Handle pixbuf, Handle bitmap, int srcX, int srcY, int destX,
            int destY, int width, int height, int alphaThreshold);
    native static final protected void gdk_pixbuf_render_to_drawable(
            Handle pixbuf, Handle drawable, Handle gc, int srcX, int srcY, int destX,
            int destY, int width, int height, int dither, int xDither,
            int yDither);
    native static final protected void gdk_pixbuf_render_to_drawable_alpha(
            Handle pixbuf, Handle drawable, int srcX, int srcY, int destX, int destY,
            int width, int height, int alphaMode, int alphaThreshold,
            int dither, int xDither, int yDither);
    native static final protected void gdk_pixbuf_render_pixmap_and_mask_for_colormap(
            Handle pixbuf, Handle colormap, Handle pixmapReturn, Handle maskReturn,
            int alphaThreshold);
    native static final protected void gdk_pixbuf_render_pixmap_and_mask(
            Handle pixbuf, Handle pixmapReturn, Handle maskReturn, int alphaThreshold);
    native static final protected Handle gdk_pixbuf_get_from_drawable(Handle dest,
            Handle src, Handle cmap, int srcX, int srcY, int destX, int destY,
            int width, int height);
    native static final protected Handle gdk_pixbuf_get_from_image(Handle dest,
            Handle src, Handle cmap, int srcX, int srcY, int destX, int destY,
            int width, int height);
    native static final protected int gdk_pixbuf_get_colorspace(Handle pixbuf);
    native static final protected int gdk_pixbuf_get_n_channels(Handle pixbuf);
    native static final protected boolean gdk_pixbuf_get_has_alpha(Handle pixbuf);
    native static final protected int gdk_pixbuf_get_bits_per_sample(Handle pixbuf);
    native static final protected byte[] gdk_pixbuf_get_pixels(Handle pixbuf);
    native static final protected int gdk_pixbuf_get_width(Handle pixbuf);
    native static final protected int gdk_pixbuf_get_height(Handle pixbuf);
    native static final protected int gdk_pixbuf_get_rowstride(Handle pixbuf);
    native static final protected Handle gdk_pixbuf_new(Handle colorspace,
            boolean hasAlpha, int bitsPerSample, int width, int height);
    native static final protected Handle gdk_pixbuf_copy(Handle pixbuf);
    native static final protected Handle gdk_pixbuf_new_subpixbuf(Handle srcPixbuf,
            int srcX, int srcY, int width, int height);
    native static final protected Handle gdk_pixbuf_new_from_file(String filename,
            int error);
    native static final protected Handle gdk_pixbuf_new_from_xpm_data(byte[] data);
    native static final protected Handle gdk_pixbuf_new_from_inline(
            int dataLength, byte[] data, boolean copyPixels, int error);
    native static final protected void gdk_pixbuf_fill(Handle pixbuf, int pixel);
    native static final protected int gdk_pixbuf_add_alpha(Handle pixbuf,
            boolean substituteColor, int r, int g, int b);
    native static final protected void gdk_pixbuf_copy_area(int srcPixbuf,
            int srcX, int srcY, int width, int height, int destPixbuf,
            int destX, int destY);
    native static final protected void gdk_pixbuf_saturate_and_pixelate(
            int src, int dest, double saturation, boolean pixelate);
    native static final protected void gdk_pixbuf_scale(Handle src, Handle dest,
            int destX, int destY, int destWidth, int destHeight,
            double offsetX, double offsetY, double scaleX, double scaleY,
            int interpType);
    native static final protected void gdk_pixbuf_composite(Handle src, Handle dest,
            int destX, int destY, int destWidth, int destHeight,
            double offsetX, double offsetY, double scaleX, double scaleY,
            int interpType, int overallAlpha);
    native static final protected void gdk_pixbuf_composite_color(Handle src,
            Handle dest, int destX, int destY, int destWidth, int destHeight,
            double offsetX, double offsetY, double scaleX, double scaleY,
            int interpType, int overallAlpha, int checkX, int checkY,
            int checkSize, int color1, int color2);
    native static final protected Handle gdk_pixbuf_scale_simple(Handle src,
            int destWidth, int destHeight, int interpType);
    native static final protected Handle gdk_pixbuf_composite_color_simple(
            Handle src, int destWidth, int destHeight, int interpType,
            int overallAlpha, int checkSize, int color1, int color2);
    native static final protected byte[] gdk_pixbuf_get_option(Handle pixbuf,
            byte[] key);
    /***************************************************************************
     * END OF GENERATED CODE
     **************************************************************************/
}