/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventProperty_get_type (GdkEventProperty * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProperty_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventProperty_get_type (obj_g));
}

GdkWindow * GdkEventProperty_get_window (GdkEventProperty * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventProperty_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventProperty_get_window (obj_g));
}

gboolean GdkEventProperty_get_send_event (GdkEventProperty * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventProperty_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventProperty_get_send_event (obj_g));
}

GdkAtom * GdkEventProperty_get_atom (GdkEventProperty * cptr) 
{
    return (GdkAtom *)cptr->atom;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getAtom
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProperty_getAtom (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return (jint)GdkEventProperty_get_atom (obj_g);
}

time_t GdkEventProperty_get_time (GdkEventProperty * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProperty_getTime (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return GdkEventProperty_get_time (obj_g);
}

guint32 GdkEventProperty_get_state (GdkEventProperty * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventProperty
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventProperty_getState (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventProperty *obj_g = (GdkEventProperty *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventProperty_get_state (obj_g));
}


#ifdef __cplusplus
}

#endif
