/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:27 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1type (JNIEnv *env, jclass cls) 
{
    return (jint)gtk_table_get_type ();
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_new
 * Signature: (IIZ)I
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Table_gtk_1table_1new (JNIEnv *env, jclass cls, jint rows, jint columns, jboolean homogenous) 
{
    gint32 rows_g = (gint32) rows;
    gint32 columns_g = (gint32) columns;
    gboolean homogenous_g = (gboolean) homogenous;
    return getHandleFromPointer(env, gtk_table_new (rows_g, columns_g, homogenous_g));
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_resize
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1resize (JNIEnv *env, jclass cls, jobject table, jint rows, jint cols) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    guint32 rows_g = (guint32) rows;
    guint32 cols_g = (guint32) cols;
    gtk_table_resize (table_g, rows_g, cols_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_attach
 * Signature: (IIIIIIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1attach (JNIEnv *env, jclass cls, jobject table, jobject child, jint leftAttach, jint rightAttach, jint topAttach, jint bottomAttach, jint xoptions, jint yoptions, jint xpadding, jint ypadding) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    GtkWidget *child_g = (GtkWidget *)getPointerFromHandle(env, child);
    gint32 leftAttach_g = (gint32) leftAttach;
    gint32 rightAttach_g = (gint32) rightAttach;
    gint32 topAttach_g = (gint32) topAttach;
    gint32 bottomAttach_g = (gint32) bottomAttach;
    GtkAttachOptions xoptions_g = (GtkAttachOptions) xoptions;
    GtkAttachOptions yoptions_g = (GtkAttachOptions) yoptions;
    gint32 xpadding_g = (gint32) xpadding;
    gint32 ypadding_g = (gint32) ypadding;
    gtk_table_attach (table_g, child_g, leftAttach_g, rightAttach_g, 
                      topAttach_g, bottomAttach_g, 
                      xoptions_g, yoptions_g, xpadding_g, ypadding_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_attach_defaults
 * Signature: (IIIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1attach_1defaults (JNIEnv *env, jclass cls, jobject table, jobject child, jint leftAttach, jint rightAttach, jint topAttach, jint bottomAttach) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    GtkWidget *child_g = (GtkWidget *)getPointerFromHandle(env, child);
    gint32 leftAttach_g = (gint32) leftAttach;
    gint32 rightAttach_g = (gint32) rightAttach;
    gint32 topAttach_g = (gint32) topAttach;
    gint32 bottomAttach_g = (gint32) bottomAttach;
    gtk_table_attach_defaults (table_g, child_g, 
                               leftAttach_g, rightAttach_g, 
                               topAttach_g, bottomAttach_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_set_row_spacing
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1set_1row_1spacing (JNIEnv *env, jclass cls, jobject table, jint row, jint spacing) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 row_g = (gint32) row;
    gint32 spacing_g = (gint32) spacing;
    gtk_table_set_row_spacing (table_g, row_g, spacing_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_row_spacing
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1row_1spacing (JNIEnv *env, jclass cls, jobject table, jint row) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 row_g = (gint32) row;
    return (jint) (gtk_table_get_row_spacing (table_g, row_g));
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_set_col_spacing
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1set_1col_1spacing (JNIEnv *env, jclass cls, jobject table, jint column, jint spacing) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 column_g = (gint32) column;
    gint32 spacing_g = (gint32) spacing;
    gtk_table_set_col_spacing (table_g, column_g, spacing_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_col_spacing
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1col_1spacing (JNIEnv *env, jclass cls, jobject table, jint column) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 column_g = (gint32) column;
    return (jint) (gtk_table_get_col_spacing (table_g, column_g));
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_set_row_spacings
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1set_1row_1spacings (JNIEnv *env, jclass cls, jobject table, jint spacing) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 spacing_g = (gint32) spacing;
    gtk_table_set_row_spacings (table_g, spacing_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_default_row_spacing
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1default_1row_1spacing (JNIEnv *env, jclass cls, jobject table) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    return (jint) (gtk_table_get_default_row_spacing (table_g));
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_set_col_spacings
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1set_1col_1spacings (JNIEnv *env, jclass cls, jobject table, jint spacing) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gint32 spacing_g = (gint32) spacing;
    gtk_table_set_col_spacings (table_g, spacing_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_default_col_spacing
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1default_1col_1spacing (JNIEnv *env, jclass cls, jobject table) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    return (jint) (gtk_table_get_default_col_spacing (table_g));
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_set_homogeneous
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Table_gtk_1table_1set_1homogeneous (JNIEnv *env, jclass cls, jobject table, jboolean homogeneous) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    gboolean homogeneous_g = (gboolean) homogeneous;
    gtk_table_set_homogeneous (table_g, homogeneous_g);
}

/*
 * Class:     org.gnu.gtk.Table
 * Method:    gtk_table_get_homogeneous
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Table_gtk_1table_1get_1homogeneous (JNIEnv *env, jclass cls, jobject table) 
{
    GtkTable *table_g = (GtkTable *)getPointerFromHandle(env, table);
    return (jboolean) (gtk_table_get_homogeneous (table_g));
}

#ifdef __cplusplus
}

#endif
