/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	gboolean _tmp45_ = FALSE;
	ValaAttribute* _tmp46_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp58_;
	ValaSemanticAnalyzer* _tmp75_;
	ValaSemanticAnalyzer* _tmp76_;
	ValaDataType* _tmp77_;
	ValaDataType* _tmp78_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaArrayType* _tmp92_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_ = FALSE;
	ValaArrayType* _tmp106_;
	ValaExpression* _tmp115_;
	ValaExpression* _tmp116_;
	gboolean _tmp237_ = FALSE;
	ValaMemberBinding _tmp238_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp243_;
	ValaSymbol* _tmp244_;
	gboolean _tmp253_ = FALSE;
	gboolean _tmp254_ = FALSE;
	gboolean _tmp255_;
	gboolean _tmp256_;
	ValaSemanticAnalyzer* _tmp269_;
	ValaSemanticAnalyzer* _tmp270_;
	ValaSourceFile* _tmp271_;
	ValaSemanticAnalyzer* _tmp272_;
	ValaSemanticAnalyzer* _tmp273_;
	ValaSymbol* _tmp274_;
	gboolean _tmp275_;
	gboolean _tmp276_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp38_, "`%s' not supported as field type", _tmp44_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp46_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
	if (_tmp46_ != NULL) {
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_data_type_get_value_owned (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp45_ = _tmp50_;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		ValaSourceReference* _tmp51_;
		ValaSourceReference* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp52_ = _tmp51_;
		vala_report_warning (_tmp52_, "[GtkChild] fields must be declared as `unowned'");
		_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		vala_data_type_set_value_owned (_tmp54_, FALSE);
	}
	_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp56_ = _tmp55_;
	vala_code_node_check ((ValaCodeNode*) _tmp56_, context);
	_tmp57_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp58_ = _tmp57_;
	if (!_tmp58_) {
		ValaSemanticAnalyzer* _tmp59_;
		ValaSemanticAnalyzer* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaTypeSymbol* _tmp65_;
		ValaTypeSymbol* _tmp66_;
		_tmp59_ = vala_code_context_get_analyzer (context);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		vala_semantic_analyzer_check_type (_tmp60_, _tmp62_);
		_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_data_type_get_type_symbol (_tmp64_);
		_tmp66_ = _tmp65_;
		if (_tmp66_ != NULL) {
			ValaDataType* _tmp67_;
			ValaDataType* _tmp68_;
			ValaTypeSymbol* _tmp69_;
			ValaTypeSymbol* _tmp70_;
			ValaVersionAttribute* _tmp71_;
			ValaVersionAttribute* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_data_type_get_type_symbol (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_symbol_get_version ((ValaSymbol*) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			vala_version_attribute_check (_tmp72_, context, _tmp74_);
		}
	}
	_tmp75_ = vala_code_context_get_analyzer (context);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp78_ = _tmp77_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp76_, (ValaSymbol*) self, _tmp78_)) {
		ValaSourceReference* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaDataType* _tmp81_;
		ValaDataType* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_code_node_to_string ((ValaCodeNode*) _tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp86_ = _tmp85_;
		vala_report_error (_tmp80_, "field type `%s' is less accessible than field `%s'", _tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
		_g_free0 (_tmp84_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp88_ = _tmp87_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp88_) ? ((ValaArrayType*) _tmp88_) : NULL;
	_tmp92_ = variable_array_type;
	if (_tmp92_ != NULL) {
		ValaArrayType* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		_tmp93_ = variable_array_type;
		_tmp94_ = vala_array_type_get_inline_allocated (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp91_ = _tmp95_;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp90_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp97_);
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		ValaInitializerList* _tmp100_;
		ValaInitializerList* _tmp101_;
		_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp101_ = _tmp100_;
		_tmp89_ = _tmp101_ == NULL;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		vala_report_warning (_tmp103_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp106_ = variable_array_type;
	if (_tmp106_ != NULL) {
		ValaArrayType* _tmp107_;
		gboolean _tmp108_;
		gboolean _tmp109_;
		_tmp107_ = variable_array_type;
		_tmp108_ = vala_array_type_get_inline_allocated (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp105_ = _tmp109_;
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaArrayType* _tmp110_;
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp110_ = variable_array_type;
		_tmp111_ = vala_array_type_get_fixed_length (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp104_ = !_tmp112_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		vala_report_error (_tmp114_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp115_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp116_ = _tmp115_;
	if (_tmp116_ != NULL) {
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaDataType* _tmp119_;
		ValaDataType* _tmp120_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp121_;
		ValaExpression* _tmp122_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		ValaExpression* _tmp135_;
		ValaExpression* _tmp136_;
		ValaDataType* _tmp137_;
		ValaDataType* _tmp138_;
		ValaDataType* _tmp139_;
		ValaDataType* _tmp140_;
		gboolean _tmp153_ = FALSE;
		gboolean _tmp154_ = FALSE;
		gboolean _tmp155_ = FALSE;
		ValaArrayType* _tmp156_;
		gboolean _tmp170_ = FALSE;
		gboolean _tmp171_ = FALSE;
		ValaArrayType* _tmp172_;
		ValaExpression* _tmp182_;
		ValaExpression* _tmp183_;
		ValaDataType* _tmp184_;
		ValaDataType* _tmp185_;
		gboolean _tmp195_ = FALSE;
		ValaSymbol* _tmp196_;
		ValaSymbol* _tmp197_;
		gboolean _tmp202_ = FALSE;
		gboolean _tmp203_ = FALSE;
		ValaSymbol* _tmp204_;
		ValaSymbol* _tmp205_;
		gboolean _tmp219_ = FALSE;
		gboolean _tmp220_ = FALSE;
		gboolean _tmp221_ = FALSE;
		ValaMemberBinding _tmp222_;
		gboolean _tmp233_;
		gboolean _tmp234_;
		_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		vala_expression_set_target_type (_tmp118_, _tmp120_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp122_ = _tmp121_;
		if (VALA_IS_INITIALIZER_LIST (_tmp122_)) {
			ValaExpression* _tmp123_;
			ValaExpression* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			_tmp123_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp126_ = _tmp125_;
			initializer_size = _tmp126_;
			is_initializer_list = TRUE;
		}
		_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp129_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_expression_get_value_type (_tmp130_);
		_tmp132_ = _tmp131_;
		if (_tmp132_ == NULL) {
			ValaSourceReference* _tmp133_;
			ValaSourceReference* _tmp134_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp134_ = _tmp133_;
			vala_report_error (_tmp134_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp135_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_expression_get_value_type (_tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp140_ = _tmp139_;
		if (!vala_data_type_compatible (_tmp138_, _tmp140_)) {
			ValaSourceReference* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaExpression* _tmp143_;
			ValaExpression* _tmp144_;
			ValaDataType* _tmp145_;
			ValaDataType* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_expression_get_value_type (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_code_node_to_string ((ValaCodeNode*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_code_node_to_string ((ValaCodeNode*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp142_, "Cannot convert from `%s' to `%s'", _tmp148_, _tmp152_);
			_g_free0 (_tmp152_);
			_g_free0 (_tmp148_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp156_ = variable_array_type;
		if (_tmp156_ != NULL) {
			ValaArrayType* _tmp157_;
			gboolean _tmp158_;
			gboolean _tmp159_;
			_tmp157_ = variable_array_type;
			_tmp158_ = vala_array_type_get_inline_allocated (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp155_ = _tmp159_;
		} else {
			_tmp155_ = FALSE;
		}
		if (_tmp155_) {
			ValaArrayType* _tmp160_;
			gboolean _tmp161_;
			gboolean _tmp162_;
			_tmp160_ = variable_array_type;
			_tmp161_ = vala_array_type_get_fixed_length (_tmp160_);
			_tmp162_ = _tmp161_;
			_tmp154_ = !_tmp162_;
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			_tmp153_ = is_initializer_list;
		} else {
			_tmp153_ = FALSE;
		}
		if (_tmp153_) {
			ValaArrayType* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			ValaIntegerLiteral* _tmp166_;
			ValaIntegerLiteral* _tmp167_;
			ValaArrayType* _tmp168_;
			ValaArrayType* _tmp169_;
			_tmp163_ = variable_array_type;
			_tmp164_ = g_strdup_printf ("%i", initializer_size);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_integer_literal_new (_tmp165_, NULL);
			_tmp167_ = _tmp166_;
			vala_array_type_set_length (_tmp163_, (ValaExpression*) _tmp167_);
			_vala_code_node_unref0 (_tmp167_);
			_g_free0 (_tmp165_);
			_tmp168_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp168_, TRUE);
			_tmp169_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp169_, FALSE);
		}
		_tmp172_ = variable_array_type;
		if (_tmp172_ != NULL) {
			ValaArrayType* _tmp173_;
			gboolean _tmp174_;
			gboolean _tmp175_;
			_tmp173_ = variable_array_type;
			_tmp174_ = vala_array_type_get_inline_allocated (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp171_ = _tmp175_;
		} else {
			_tmp171_ = FALSE;
		}
		if (_tmp171_) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaDataType* _tmp178_;
			ValaDataType* _tmp179_;
			_tmp176_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_expression_get_value_type (_tmp177_);
			_tmp179_ = _tmp178_;
			_tmp170_ = !VALA_IS_ARRAY_TYPE (_tmp179_);
		} else {
			_tmp170_ = FALSE;
		}
		if (_tmp170_) {
			ValaSourceReference* _tmp180_;
			ValaSourceReference* _tmp181_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp181_ = _tmp180_;
			vala_report_error (_tmp181_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp182_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_expression_get_value_type (_tmp183_);
		_tmp185_ = _tmp184_;
		if (vala_data_type_is_disposable (_tmp185_)) {
			gboolean _tmp186_ = FALSE;
			ValaDataType* _tmp187_;
			ValaDataType* _tmp188_;
			_tmp187_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp188_ = _tmp187_;
			if (!VALA_IS_POINTER_TYPE (_tmp188_)) {
				ValaDataType* _tmp189_;
				ValaDataType* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp189_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_data_type_get_value_owned (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp186_ = !_tmp192_;
			} else {
				_tmp186_ = FALSE;
			}
			if (_tmp186_) {
				ValaSourceReference* _tmp193_;
				ValaSourceReference* _tmp194_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp194_ = _tmp193_;
				vala_report_error (_tmp194_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp197_ = _tmp196_;
		if (VALA_IS_NAMESPACE (_tmp197_)) {
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			_tmp198_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp199_ = _tmp198_;
			_tmp195_ = !vala_expression_is_constant (_tmp199_);
		} else {
			_tmp195_ = FALSE;
		}
		if (_tmp195_) {
			ValaSourceReference* _tmp200_;
			ValaSourceReference* _tmp201_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp201_ = _tmp200_;
			vala_report_error (_tmp201_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp204_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp205_ = _tmp204_;
		if (VALA_IS_NAMESPACE (_tmp205_)) {
			ValaExpression* _tmp206_;
			ValaExpression* _tmp207_;
			_tmp206_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp207_ = _tmp206_;
			_tmp203_ = vala_expression_is_constant (_tmp207_);
		} else {
			_tmp203_ = FALSE;
		}
		if (_tmp203_) {
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			_tmp208_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp209_ = _tmp208_;
			_tmp202_ = vala_expression_is_non_null (_tmp209_);
		} else {
			_tmp202_ = FALSE;
		}
		if (_tmp202_) {
			gboolean _tmp210_ = FALSE;
			ValaDataType* _tmp211_;
			ValaDataType* _tmp212_;
			_tmp211_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp212_ = _tmp211_;
			if (vala_data_type_is_disposable (_tmp212_)) {
				ValaDataType* _tmp213_;
				ValaDataType* _tmp214_;
				gboolean _tmp215_;
				gboolean _tmp216_;
				_tmp213_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_data_type_get_value_owned (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp210_ = _tmp216_;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp218_ = _tmp217_;
				vala_report_error (_tmp218_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp222_ = self->priv->_binding;
		if (_tmp222_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp223_;
			ValaSymbol* _tmp224_;
			_tmp223_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp224_ = _tmp223_;
			_tmp221_ = VALA_IS_CLASS (_tmp224_);
		} else {
			_tmp221_ = FALSE;
		}
		if (_tmp221_) {
			ValaSymbol* _tmp225_;
			ValaSymbol* _tmp226_;
			gboolean _tmp227_;
			gboolean _tmp228_;
			_tmp225_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp226_ = _tmp225_;
			_tmp227_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_CLASS, ValaClass));
			_tmp228_ = _tmp227_;
			_tmp220_ = _tmp228_;
		} else {
			_tmp220_ = FALSE;
		}
		if (_tmp220_) {
			ValaExpression* _tmp229_;
			ValaExpression* _tmp230_;
			_tmp229_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp230_ = _tmp229_;
			_tmp219_ = !vala_expression_is_constant (_tmp230_);
		} else {
			_tmp219_ = FALSE;
		}
		if (_tmp219_) {
			ValaSourceReference* _tmp231_;
			ValaSourceReference* _tmp232_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp232_ = _tmp231_;
			vala_report_error (_tmp232_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp233_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp234_ = _tmp233_;
		if (_tmp234_) {
			ValaSourceReference* _tmp235_;
			ValaSourceReference* _tmp236_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp236_ = _tmp235_;
			vala_report_error (_tmp236_, "External fields cannot use initializers");
		}
	}
	_tmp238_ = self->priv->_binding;
	if (_tmp238_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp239_;
		ValaSymbol* _tmp240_;
		_tmp239_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp240_ = _tmp239_;
		_tmp237_ = VALA_IS_INTERFACE (_tmp240_);
	} else {
		_tmp237_ = FALSE;
	}
	if (_tmp237_) {
		ValaSourceReference* _tmp241_;
		ValaSourceReference* _tmp242_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp242_ = _tmp241_;
		vala_report_error (_tmp242_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp243_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp244_ = _tmp243_;
	if (VALA_IS_CLASS (_tmp244_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		ValaClass* _tmp247_;
		gboolean _tmp248_ = FALSE;
		ValaClass* _tmp249_;
		gboolean _tmp250_;
		gboolean _tmp251_;
		_tmp245_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp246_ = _tmp245_;
		_tmp247_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp246_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp247_;
		_tmp249_ = cl;
		_tmp250_ = vala_class_get_is_compact (_tmp249_);
		_tmp251_ = _tmp250_;
		if (_tmp251_) {
			ValaClass* _tmp252_;
			_tmp252_ = cl;
			_tmp248_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp252_);
		} else {
			_tmp248_ = FALSE;
		}
		if (_tmp248_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp255_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp256_ = _tmp255_;
	if (!_tmp256_) {
		gboolean _tmp257_;
		gboolean _tmp258_;
		_tmp257_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp258_ = _tmp257_;
		_tmp254_ = !_tmp258_;
	} else {
		_tmp254_ = FALSE;
	}
	if (_tmp254_) {
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		_tmp259_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp260_ = _tmp259_;
		_tmp253_ = _tmp260_ != NULL;
		_vala_code_node_unref0 (_tmp260_);
	} else {
		_tmp253_ = FALSE;
	}
	if (_tmp253_) {
		ValaSourceReference* _tmp261_;
		ValaSourceReference* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		ValaSymbol* _tmp265_;
		ValaSymbol* _tmp266_;
		gchar* _tmp267_;
		gchar* _tmp268_;
		_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_symbol_get_full_name (_tmp266_);
		_tmp268_ = _tmp267_;
		vala_report_warning (_tmp262_, "%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp264_, _tmp268_);
		_g_free0 (_tmp268_);
		_vala_code_node_unref0 (_tmp266_);
		_g_free0 (_tmp264_);
	}
	_tmp269_ = vala_code_context_get_analyzer (context);
	_tmp270_ = _tmp269_;
	_tmp271_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp270_, _tmp271_);
	_tmp272_ = vala_code_context_get_analyzer (context);
	_tmp273_ = _tmp272_;
	_tmp274_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp273_, _tmp274_);
	_tmp275_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp276_ = _tmp275_;
	result = !_tmp276_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

