/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp704_ = FALSE;
	gboolean _tmp705_ = FALSE;
	gboolean _tmp706_ = FALSE;
	ValaExpression* _tmp707_;
	ValaExpression* _tmp708_;
	ValaSymbol* _tmp735_;
	ValaSymbol* _tmp736_;
	ValaSymbol* _tmp805_;
	ValaSymbol* _tmp806_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp842_;
	ValaSymbol* _tmp843_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp844_;
	ValaSymbol* _tmp845_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1293_;
	ValaSymbol* _tmp1294_;
	ValaSymbol* _tmp1296_;
	ValaVersionAttribute* _tmp1297_;
	ValaVersionAttribute* _tmp1298_;
	ValaSourceReference* _tmp1299_;
	ValaSourceReference* _tmp1300_;
	gboolean _tmp1301_ = FALSE;
	gboolean _tmp1352_ = FALSE;
	gboolean _tmp1379_ = FALSE;
	gboolean _tmp1380_ = FALSE;
	ValaDataType* _tmp1681_;
	ValaDataType* _tmp1682_;
	gboolean _tmp1685_;
	gboolean _tmp1686_;
	gboolean _tmp1687_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			gboolean _tmp303_ = FALSE;
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			gboolean _tmp312_ = FALSE;
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			gboolean _tmp335_ = FALSE;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			gboolean _tmp392_ = FALSE;
			gboolean _tmp393_ = FALSE;
			ValaSymbol* _tmp394_;
			ValaSymbol* _tmp395_;
			ValaSymbol* _tmp670_;
			ValaSymbol* _tmp671_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp289_ = vala_member_access_get_inner (self);
			_tmp290_ = _tmp289_;
			if (VALA_IS_MEMBER_ACCESS (_tmp290_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp291_;
				ValaExpression* _tmp292_;
				ValaMemberAccess* _tmp293_;
				gboolean _tmp294_;
				_tmp291_ = vala_member_access_get_inner (self);
				_tmp292_ = _tmp291_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp292_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp293_ = ma;
				_tmp294_ = _tmp293_->priv->_prototype_access;
				if (_tmp294_) {
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					ValaExpression* _tmp297_;
					ValaExpression* _tmp298_;
					ValaSymbol* _tmp299_;
					ValaSymbol* _tmp300_;
					gchar* _tmp301_;
					gchar* _tmp302_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_member_access_get_inner (self);
					_tmp298_ = _tmp297_;
					_tmp299_ = vala_expression_get_symbol_reference (_tmp298_);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_symbol_get_full_name (_tmp300_);
					_tmp302_ = _tmp301_;
					vala_report_error (_tmp296_, "Access to instance member `%s' denied", _tmp302_);
					_g_free0 (_tmp302_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp304_ = vala_member_access_get_inner (self);
			_tmp305_ = _tmp304_;
			if (VALA_IS_CAST_EXPRESSION (_tmp305_)) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				gboolean _tmp308_;
				gboolean _tmp309_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp307_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp309_ = _tmp308_;
				_tmp303_ = _tmp309_;
			} else {
				_tmp303_ = FALSE;
			}
			if (_tmp303_) {
				ValaSourceReference* _tmp310_;
				ValaSourceReference* _tmp311_;
				_tmp310_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp311_ = _tmp310_;
				vala_report_warning (_tmp311_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp313_ = vala_member_access_get_inner (self);
			_tmp314_ = _tmp313_;
			if (VALA_IS_MEMBER_ACCESS (_tmp314_)) {
				_tmp312_ = TRUE;
			} else {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp312_ = VALA_IS_BASE_ACCESS (_tmp316_);
			}
			if (_tmp312_) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				gboolean _tmp321_ = FALSE;
				ValaSymbol* _tmp322_;
				ValaSymbol* _tmp323_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference (_tmp318_);
				_tmp320_ = _tmp319_;
				base_symbol = _tmp320_;
				_tmp322_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp323_ = _tmp322_;
				if (_tmp323_ == NULL) {
					gboolean _tmp324_ = FALSE;
					ValaSymbol* _tmp325_;
					_tmp325_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp325_)) {
						_tmp324_ = TRUE;
					} else {
						ValaSymbol* _tmp326_;
						_tmp326_ = base_symbol;
						_tmp324_ = VALA_IS_TYPESYMBOL (_tmp326_);
					}
					_tmp321_ = _tmp324_;
				} else {
					_tmp321_ = FALSE;
				}
				if (_tmp321_) {
					ValaSymbol* _tmp327_;
					ValaScope* _tmp328_;
					ValaScope* _tmp329_;
					const gchar* _tmp330_;
					ValaSymbol* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					_tmp327_ = base_symbol;
					_tmp328_ = vala_symbol_get_scope (_tmp327_);
					_tmp329_ = _tmp328_;
					_tmp330_ = self->priv->_member_name;
					_tmp331_ = vala_scope_lookup (_tmp329_, _tmp330_);
					_tmp332_ = _tmp331_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp332_);
					_vala_code_node_unref0 (_tmp332_);
					_tmp333_ = vala_member_access_get_inner (self);
					_tmp334_ = _tmp333_;
					if (VALA_IS_BASE_ACCESS (_tmp334_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp336_ = vala_member_access_get_inner (self);
			_tmp337_ = _tmp336_;
			if (VALA_IS_MEMBER_ACCESS (_tmp337_)) {
				ValaExpression* _tmp338_;
				ValaExpression* _tmp339_;
				ValaSymbol* _tmp340_;
				ValaSymbol* _tmp341_;
				_tmp338_ = vala_member_access_get_inner (self);
				_tmp339_ = _tmp338_;
				_tmp340_ = vala_expression_get_symbol_reference (_tmp339_);
				_tmp341_ = _tmp340_;
				_tmp335_ = VALA_IS_TYPEPARAMETER (_tmp341_);
			} else {
				_tmp335_ = FALSE;
			}
			if (_tmp335_) {
				ValaExpression* _tmp342_;
				ValaExpression* _tmp343_;
				ValaExpression* _tmp344_;
				ValaExpression* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaGenericType* _tmp348_;
				ValaGenericType* _tmp349_;
				ValaExpression* _tmp350_;
				ValaExpression* _tmp351_;
				ValaDataType* _tmp352_;
				ValaDataType* _tmp353_;
				ValaSourceReference* _tmp354_;
				ValaSourceReference* _tmp355_;
				_tmp342_ = vala_member_access_get_inner (self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_member_access_get_inner (self);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_expression_get_symbol_reference (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp349_ = _tmp348_;
				vala_expression_set_value_type (_tmp343_, (ValaDataType*) _tmp349_);
				_vala_code_node_unref0 (_tmp349_);
				_tmp350_ = vala_member_access_get_inner (self);
				_tmp351_ = _tmp350_;
				_tmp352_ = vala_expression_get_value_type (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp355_ = _tmp354_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp353_, _tmp355_);
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				gboolean _tmp363_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				_tmp363_ = self->priv->_pointer_member_access;
				if (_tmp363_) {
					ValaExpression* _tmp364_;
					ValaExpression* _tmp365_;
					ValaDataType* _tmp366_;
					ValaDataType* _tmp367_;
					const gchar* _tmp368_;
					ValaSymbol* _tmp369_;
					ValaSymbol* _tmp370_;
					_tmp364_ = vala_member_access_get_inner (self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_expression_get_value_type (_tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = self->priv->_member_name;
					_tmp369_ = vala_data_type_get_pointer_member (_tmp367_, _tmp368_);
					_tmp370_ = _tmp369_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp370_);
					_vala_code_node_unref0 (_tmp370_);
				} else {
					ValaExpression* _tmp371_;
					ValaExpression* _tmp372_;
					ValaDataType* _tmp373_;
					ValaDataType* _tmp374_;
					ValaTypeSymbol* _tmp375_;
					ValaTypeSymbol* _tmp376_;
					ValaExpression* _tmp383_;
					ValaExpression* _tmp384_;
					ValaDataType* _tmp385_;
					ValaDataType* _tmp386_;
					const gchar* _tmp387_;
					ValaSymbol* _tmp388_;
					ValaSymbol* _tmp389_;
					_tmp371_ = vala_member_access_get_inner (self);
					_tmp372_ = _tmp371_;
					_tmp373_ = vala_expression_get_value_type (_tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = vala_data_type_get_type_symbol (_tmp374_);
					_tmp376_ = _tmp375_;
					if (_tmp376_ != NULL) {
						ValaExpression* _tmp377_;
						ValaExpression* _tmp378_;
						ValaDataType* _tmp379_;
						ValaDataType* _tmp380_;
						ValaTypeSymbol* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						_tmp377_ = vala_member_access_get_inner (self);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_expression_get_value_type (_tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
						_tmp382_ = _tmp381_;
						base_symbol = (ValaSymbol*) _tmp382_;
					}
					_tmp383_ = vala_member_access_get_inner (self);
					_tmp384_ = _tmp383_;
					_tmp385_ = vala_expression_get_value_type (_tmp384_);
					_tmp386_ = _tmp385_;
					_tmp387_ = self->priv->_member_name;
					_tmp388_ = vala_data_type_get_member (_tmp386_, _tmp387_);
					_tmp389_ = _tmp388_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp389_);
					_vala_code_node_unref0 (_tmp389_);
				}
				_tmp390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp391_ = _tmp390_;
				if (_tmp391_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp395_ = _tmp394_;
			if (_tmp395_ == NULL) {
				ValaExpression* _tmp396_;
				ValaExpression* _tmp397_;
				ValaDataType* _tmp398_;
				ValaDataType* _tmp399_;
				_tmp396_ = vala_member_access_get_inner (self);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_expression_get_value_type (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp393_ = _tmp399_ != NULL;
			} else {
				_tmp393_ = FALSE;
			}
			if (_tmp393_) {
				ValaExpression* _tmp400_;
				ValaExpression* _tmp401_;
				ValaDataType* _tmp402_;
				ValaDataType* _tmp403_;
				gboolean _tmp404_;
				gboolean _tmp405_;
				_tmp400_ = vala_member_access_get_inner (self);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_expression_get_value_type (_tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_data_type_get_is_dynamic (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp392_ = _tmp405_;
			} else {
				_tmp392_ = FALSE;
			}
			if (_tmp392_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				ValaObjectType* _tmp410_;
				ValaCodeNode* _tmp411_;
				ValaCodeNode* _tmp412_;
				ValaSymbol* _tmp605_;
				ValaSymbol* _tmp606_;
				ValaSymbol* _tmp668_;
				ValaSymbol* _tmp669_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp410_;
				_tmp411_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp412_ = _tmp411_;
				if (VALA_IS_METHOD_CALL (_tmp412_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp413_;
					ValaCodeNode* _tmp414_;
					ValaMethodCall* _tmp415_;
					ValaExpression* _tmp416_;
					ValaExpression* _tmp417_;
					_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp414_ = _tmp413_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp415_ = invoc;
					_tmp416_ = vala_method_call_get_call (_tmp415_);
					_tmp417_ = _tmp416_;
					if (_tmp417_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp435_;
						ValaExpression* _tmp436_;
						ValaDataType* _tmp437_;
						ValaDataType* _tmp438_;
						const gchar* _tmp439_;
						ValaDataType* _tmp440_;
						ValaSourceReference* _tmp441_;
						ValaSourceReference* _tmp442_;
						ValaDynamicMethod* _tmp443_;
						ValaDynamicMethod* _tmp444_;
						ValaMethodCall* _tmp445_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaErrorType* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaErrorType* _tmp452_;
						ValaDynamicMethod* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaParameter* _tmp455_;
						ValaParameter* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaObjectType* _tmp458_;
						ValaDataType* _tmp459_;
						ValaDataType* _tmp460_;
						ValaDynamicMethod* _tmp461_;
						ValaSourceReference* _tmp462_;
						ValaSourceReference* _tmp463_;
						ValaParameter* _tmp464_;
						ValaParameter* _tmp465_;
						ValaObjectType* _tmp466_;
						ValaTypeSymbol* _tmp467_;
						ValaTypeSymbol* _tmp468_;
						ValaScope* _tmp469_;
						ValaScope* _tmp470_;
						ValaDynamicMethod* _tmp471_;
						ValaDynamicMethod* _tmp472_;
						_tmp418_ = invoc;
						_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
						_tmp420_ = _tmp419_;
						if (_tmp420_ != NULL) {
							ValaMethodCall* _tmp421_;
							ValaDataType* _tmp422_;
							ValaDataType* _tmp423_;
							ValaDataType* _tmp424_;
							ValaDataType* _tmp425_;
							_tmp421_ = invoc;
							_tmp422_ = vala_expression_get_target_type ((ValaExpression*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_data_type_copy (_tmp423_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp424_;
							_tmp425_ = ret_type;
							vala_data_type_set_value_owned (_tmp425_, TRUE);
						} else {
							ValaMethodCall* _tmp426_;
							ValaCodeNode* _tmp427_;
							ValaCodeNode* _tmp428_;
							_tmp426_ = invoc;
							_tmp427_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp426_);
							_tmp428_ = _tmp427_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp428_)) {
								ValaVoidType* _tmp429_;
								_tmp429_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp429_;
							} else {
								ValaExpression* _tmp430_;
								ValaExpression* _tmp431_;
								ValaDataType* _tmp432_;
								ValaDataType* _tmp433_;
								ValaDataType* _tmp434_;
								_tmp430_ = vala_member_access_get_inner (self);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_expression_get_value_type (_tmp431_);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_data_type_copy (_tmp433_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp434_;
							}
						}
						_tmp435_ = vala_member_access_get_inner (self);
						_tmp436_ = _tmp435_;
						_tmp437_ = vala_expression_get_value_type (_tmp436_);
						_tmp438_ = _tmp437_;
						_tmp439_ = self->priv->_member_name;
						_tmp440_ = ret_type;
						_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_dynamic_method_new (_tmp438_, _tmp439_, _tmp440_, _tmp442_, NULL);
						m = _tmp443_;
						_tmp444_ = m;
						_tmp445_ = invoc;
						vala_dynamic_method_set_invocation (_tmp444_, _tmp445_);
						_tmp446_ = m;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp446_);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_error_type_new (NULL, NULL, _tmp448_);
						err = _tmp449_;
						_tmp450_ = err;
						vala_error_type_set_dynamic_error (_tmp450_, TRUE);
						_tmp451_ = m;
						_tmp452_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp451_, (ValaDataType*) _tmp452_);
						_tmp453_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp454_ = m;
						_tmp455_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp456_ = _tmp455_;
						vala_callable_add_parameter ((ValaCallable*) _tmp454_, _tmp456_);
						_vala_code_node_unref0 (_tmp456_);
						_tmp457_ = m;
						_tmp458_ = dynamic_object_type;
						_tmp459_ = vala_data_type_copy ((ValaDataType*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = m;
						_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp461_);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_parameter_new ("this", _tmp460_, _tmp463_);
						_tmp465_ = _tmp464_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp457_, _tmp465_);
						_vala_code_node_unref0 (_tmp465_);
						_vala_code_node_unref0 (_tmp460_);
						_tmp466_ = dynamic_object_type;
						_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = m;
						vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
						_tmp472_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp473_;
					ValaCodeNode* _tmp474_;
					_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (VALA_IS_ASSIGNMENT (_tmp474_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp475_;
						ValaCodeNode* _tmp476_;
						ValaAssignment* _tmp477_;
						ValaExpression* _tmp478_;
						ValaExpression* _tmp479_;
						_tmp475_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp476_ = _tmp475_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp477_ = a;
						_tmp478_ = vala_assignment_get_left (_tmp477_);
						_tmp479_ = _tmp478_;
						if (_tmp479_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							const gchar* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaDynamicProperty* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaPropertyAccessor* _tmp493_;
							ValaPropertyAccessor* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaExpression* _tmp496_;
							ValaExpression* _tmp497_;
							ValaDataType* _tmp498_;
							ValaDataType* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaTypeSymbol* _tmp501_;
							ValaScope* _tmp502_;
							ValaScope* _tmp503_;
							ValaObjectType* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaScope* _tmp507_;
							ValaScope* _tmp508_;
							ValaDynamicProperty* _tmp509_;
							ValaDynamicProperty* _tmp510_;
							ValaObjectType* _tmp511_;
							ValaTypeSymbol* _tmp512_;
							ValaTypeSymbol* _tmp513_;
							ValaSemanticAnalyzer* _tmp514_;
							ValaSemanticAnalyzer* _tmp515_;
							ValaClass* _tmp516_;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = self->priv->_member_name;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_dynamic_property_new (_tmp483_, _tmp484_, _tmp486_, NULL);
							prop = _tmp487_;
							_tmp488_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp489_ = prop;
							_tmp490_ = prop;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp492_, NULL);
							_tmp494_ = _tmp493_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp489_, _tmp494_);
							_vala_code_node_unref0 (_tmp494_);
							_tmp495_ = prop;
							_tmp496_ = vala_member_access_get_inner (self);
							_tmp497_ = _tmp496_;
							_tmp498_ = vala_expression_get_value_type (_tmp497_);
							_tmp499_ = _tmp498_;
							_tmp500_ = vala_data_type_get_type_symbol (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
							_tmp503_ = _tmp502_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
							_tmp504_ = dynamic_object_type;
							_tmp505_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
							_tmp508_ = _tmp507_;
							_tmp509_ = prop;
							vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
							_tmp510_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
							_tmp511_ = dynamic_object_type;
							_tmp512_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp511_);
							_tmp513_ = _tmp512_;
							_tmp514_ = vala_code_context_get_analyzer (context);
							_tmp515_ = _tmp514_;
							_tmp516_ = _tmp515_->object_type;
							if (!vala_typesymbol_is_subtype_of (_tmp513_, (ValaTypeSymbol*) _tmp516_)) {
								ValaSourceReference* _tmp517_;
								ValaSourceReference* _tmp518_;
								ValaObjectType* _tmp519_;
								ValaTypeSymbol* _tmp520_;
								ValaTypeSymbol* _tmp521_;
								gchar* _tmp522_;
								gchar* _tmp523_;
								_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp518_ = _tmp517_;
								_tmp519_ = dynamic_object_type;
								_tmp520_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp519_);
								_tmp521_ = _tmp520_;
								_tmp522_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp521_);
								_tmp523_ = _tmp522_;
								vala_report_error (_tmp518_, "dynamic properties are not supported for `%s'", _tmp523_);
								_g_free0 (_tmp523_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							}
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp524_ = FALSE;
						gboolean _tmp525_ = FALSE;
						ValaCodeNode* _tmp526_;
						ValaCodeNode* _tmp527_;
						_tmp526_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp527_ = _tmp526_;
						if (VALA_IS_MEMBER_ACCESS (_tmp527_)) {
							ValaExpression* _tmp528_;
							ValaExpression* _tmp529_;
							_tmp528_ = vala_member_access_get_inner (self);
							_tmp529_ = _tmp528_;
							_tmp525_ = VALA_IS_MEMBER_ACCESS (_tmp529_);
						} else {
							_tmp525_ = FALSE;
						}
						if (_tmp525_) {
							ValaCodeNode* _tmp530_;
							ValaCodeNode* _tmp531_;
							ValaCodeNode* _tmp532_;
							ValaCodeNode* _tmp533_;
							_tmp530_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp531_ = _tmp530_;
							_tmp532_ = vala_code_node_get_parent_node (_tmp531_);
							_tmp533_ = _tmp532_;
							_tmp524_ = VALA_IS_METHOD_CALL (_tmp533_);
						} else {
							_tmp524_ = FALSE;
						}
						if (_tmp524_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp534_;
							ValaCodeNode* _tmp535_;
							gboolean _tmp536_ = FALSE;
							ValaMemberAccess* _tmp537_;
							const gchar* _tmp538_;
							_tmp534_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp535_ = _tmp534_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp535_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp537_ = ma;
							_tmp538_ = _tmp537_->priv->_member_name;
							if (g_strcmp0 (_tmp538_, "connect") == 0) {
								_tmp536_ = TRUE;
							} else {
								ValaMemberAccess* _tmp539_;
								const gchar* _tmp540_;
								_tmp539_ = ma;
								_tmp540_ = _tmp539_->priv->_member_name;
								_tmp536_ = g_strcmp0 (_tmp540_, "connect_after") == 0;
							}
							if (_tmp536_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp541_;
								ValaExpression* _tmp542_;
								ValaDataType* _tmp543_;
								ValaDataType* _tmp544_;
								const gchar* _tmp545_;
								ValaVoidType* _tmp546_;
								ValaVoidType* _tmp547_;
								ValaSourceReference* _tmp548_;
								ValaSourceReference* _tmp549_;
								ValaDynamicSignal* _tmp550_;
								ValaDynamicSignal* _tmp551_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp552_;
								ValaCodeNode* _tmp553_;
								ValaCodeNode* _tmp554_;
								ValaCodeNode* _tmp555_;
								ValaMethodCall* _tmp556_;
								ValaMethodCall* _tmp557_;
								ValaList* _tmp558_;
								gint _tmp559_;
								gint _tmp560_;
								ValaDynamicSignal* _tmp592_;
								ValaObjectType* _tmp593_;
								ValaTypeSymbol* _tmp594_;
								ValaTypeSymbol* _tmp595_;
								ValaScope* _tmp596_;
								ValaScope* _tmp597_;
								ValaDynamicSignal* _tmp598_;
								ValaDynamicSignal* _tmp599_;
								_tmp541_ = vala_member_access_get_inner (self);
								_tmp542_ = _tmp541_;
								_tmp543_ = vala_expression_get_value_type (_tmp542_);
								_tmp544_ = _tmp543_;
								_tmp545_ = self->priv->_member_name;
								_tmp546_ = vala_void_type_new (NULL);
								_tmp547_ = _tmp546_;
								_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp549_ = _tmp548_;
								_tmp550_ = vala_dynamic_signal_new (_tmp544_, _tmp545_, (ValaDataType*) _tmp547_, _tmp549_, NULL);
								_tmp551_ = _tmp550_;
								_vala_code_node_unref0 (_tmp547_);
								s = _tmp551_;
								_tmp552_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp553_ = _tmp552_;
								_tmp554_ = vala_code_node_get_parent_node (_tmp553_);
								_tmp555_ = _tmp554_;
								_tmp556_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp555_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp556_;
								_tmp557_ = mcall;
								_tmp558_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp557_);
								_tmp559_ = vala_collection_get_size ((ValaCollection*) _tmp558_);
								_tmp560_ = _tmp559_;
								if (_tmp560_ > 0) {
									ValaDynamicSignal* _tmp561_;
									ValaMethodCall* _tmp562_;
									ValaList* _tmp563_;
									gpointer _tmp564_;
									ValaExpression* _tmp565_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp566_;
									ValaExpression* _tmp567_;
									ValaExpression* _tmp568_;
									gboolean _tmp569_ = FALSE;
									gboolean _tmp570_ = FALSE;
									ValaMemberAccess* _tmp571_;
									_tmp561_ = s;
									_tmp562_ = mcall;
									_tmp563_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp562_);
									_tmp564_ = vala_list_get (_tmp563_, 0);
									_tmp565_ = (ValaExpression*) _tmp564_;
									vala_dynamic_signal_set_handler (_tmp561_, _tmp565_);
									_vala_code_node_unref0 (_tmp565_);
									_tmp566_ = s;
									_tmp567_ = vala_dynamic_signal_get_handler (_tmp566_);
									_tmp568_ = _tmp567_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp568_) ? ((ValaMemberAccess*) _tmp568_) : NULL;
									_tmp571_ = arg;
									if (_tmp571_ == NULL) {
										_tmp570_ = TRUE;
									} else {
										ValaMemberAccess* _tmp572_;
										_tmp572_ = arg;
										_tmp570_ = !vala_code_node_check ((ValaCodeNode*) _tmp572_, context);
									}
									if (_tmp570_) {
										_tmp569_ = TRUE;
									} else {
										ValaMemberAccess* _tmp573_;
										ValaSymbol* _tmp574_;
										ValaSymbol* _tmp575_;
										_tmp573_ = arg;
										_tmp574_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp573_);
										_tmp575_ = _tmp574_;
										_tmp569_ = !VALA_IS_METHOD (_tmp575_);
									}
									if (_tmp569_) {
										ValaDynamicSignal* _tmp576_;
										ValaExpression* _tmp577_;
										ValaExpression* _tmp578_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp576_ = s;
										_tmp577_ = vala_dynamic_signal_get_handler (_tmp576_);
										_tmp578_ = _tmp577_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp578_)) {
											ValaDynamicSignal* _tmp579_;
											ValaExpression* _tmp580_;
											ValaExpression* _tmp581_;
											ValaSourceReference* _tmp582_;
											ValaSourceReference* _tmp583_;
											_tmp579_ = s;
											_tmp580_ = vala_dynamic_signal_get_handler (_tmp579_);
											_tmp581_ = _tmp580_;
											_tmp582_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp581_);
											_tmp583_ = _tmp582_;
											vala_report_error (_tmp583_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp584_;
											ValaExpression* _tmp585_;
											ValaExpression* _tmp586_;
											ValaSourceReference* _tmp587_;
											ValaSourceReference* _tmp588_;
											ValaDynamicSignal* _tmp589_;
											gchar* _tmp590_;
											gchar* _tmp591_;
											_tmp584_ = s;
											_tmp585_ = vala_dynamic_signal_get_handler (_tmp584_);
											_tmp586_ = _tmp585_;
											_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
											_tmp588_ = _tmp587_;
											_tmp589_ = s;
											_tmp590_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp589_);
											_tmp591_ = _tmp590_;
											vala_report_error (_tmp588_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp591_);
											_g_free0 (_tmp591_);
										}
									}
								}
								_tmp592_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp592_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp593_ = dynamic_object_type;
								_tmp594_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp593_);
								_tmp595_ = _tmp594_;
								_tmp596_ = vala_symbol_get_scope ((ValaSymbol*) _tmp595_);
								_tmp597_ = _tmp596_;
								_tmp598_ = s;
								vala_scope_add (_tmp597_, NULL, (ValaSymbol*) _tmp598_);
								_tmp599_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp599_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp600_;
								const gchar* _tmp601_;
								_tmp600_ = ma;
								_tmp601_ = _tmp600_->priv->_member_name;
								if (g_strcmp0 (_tmp601_, "disconnect") == 0) {
									ValaMemberAccess* _tmp602_;
									ValaSourceReference* _tmp603_;
									ValaSourceReference* _tmp604_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp602_ = ma;
									_tmp603_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp602_);
									_tmp604_ = _tmp603_;
									vala_report_error (_tmp604_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp605_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp606_ = _tmp605_;
				if (_tmp606_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp607_;
					ValaExpression* _tmp608_;
					ValaDataType* _tmp609_;
					ValaDataType* _tmp610_;
					const gchar* _tmp611_;
					ValaSourceReference* _tmp612_;
					ValaSourceReference* _tmp613_;
					ValaDynamicProperty* _tmp614_;
					ValaDataType* _tmp615_;
					ValaDataType* _tmp616_;
					ValaDynamicProperty* _tmp627_;
					ValaDynamicProperty* _tmp628_;
					ValaDynamicProperty* _tmp629_;
					ValaDataType* _tmp630_;
					ValaDataType* _tmp631_;
					ValaDataType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDynamicProperty* _tmp634_;
					ValaSourceReference* _tmp635_;
					ValaSourceReference* _tmp636_;
					ValaPropertyAccessor* _tmp637_;
					ValaPropertyAccessor* _tmp638_;
					ValaDynamicProperty* _tmp639_;
					ValaExpression* _tmp640_;
					ValaExpression* _tmp641_;
					ValaDataType* _tmp642_;
					ValaDataType* _tmp643_;
					ValaTypeSymbol* _tmp644_;
					ValaTypeSymbol* _tmp645_;
					ValaScope* _tmp646_;
					ValaScope* _tmp647_;
					ValaObjectType* _tmp648_;
					ValaTypeSymbol* _tmp649_;
					ValaTypeSymbol* _tmp650_;
					ValaScope* _tmp651_;
					ValaScope* _tmp652_;
					ValaDynamicProperty* _tmp653_;
					ValaDynamicProperty* _tmp654_;
					ValaObjectType* _tmp655_;
					ValaTypeSymbol* _tmp656_;
					ValaTypeSymbol* _tmp657_;
					ValaSemanticAnalyzer* _tmp658_;
					ValaSemanticAnalyzer* _tmp659_;
					ValaClass* _tmp660_;
					_tmp607_ = vala_member_access_get_inner (self);
					_tmp608_ = _tmp607_;
					_tmp609_ = vala_expression_get_value_type (_tmp608_);
					_tmp610_ = _tmp609_;
					_tmp611_ = self->priv->_member_name;
					_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp613_ = _tmp612_;
					_tmp614_ = vala_dynamic_property_new (_tmp610_, _tmp611_, _tmp613_, NULL);
					prop = _tmp614_;
					_tmp615_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp616_ = _tmp615_;
					if (_tmp616_ != NULL) {
						ValaDynamicProperty* _tmp617_;
						ValaDataType* _tmp618_;
						ValaDataType* _tmp619_;
						_tmp617_ = prop;
						_tmp618_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp619_ = _tmp618_;
						vala_property_set_property_type ((ValaProperty*) _tmp617_, _tmp619_);
					} else {
						ValaDynamicProperty* _tmp620_;
						ValaExpression* _tmp621_;
						ValaExpression* _tmp622_;
						ValaDataType* _tmp623_;
						ValaDataType* _tmp624_;
						ValaDataType* _tmp625_;
						ValaDataType* _tmp626_;
						_tmp620_ = prop;
						_tmp621_ = vala_member_access_get_inner (self);
						_tmp622_ = _tmp621_;
						_tmp623_ = vala_expression_get_value_type (_tmp622_);
						_tmp624_ = _tmp623_;
						_tmp625_ = vala_data_type_copy (_tmp624_);
						_tmp626_ = _tmp625_;
						vala_property_set_property_type ((ValaProperty*) _tmp620_, _tmp626_);
						_vala_code_node_unref0 (_tmp626_);
					}
					_tmp627_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp627_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp628_ = prop;
					_tmp629_ = prop;
					_tmp630_ = vala_property_get_property_type ((ValaProperty*) _tmp629_);
					_tmp631_ = _tmp630_;
					_tmp632_ = vala_data_type_copy (_tmp631_);
					_tmp633_ = _tmp632_;
					_tmp634_ = prop;
					_tmp635_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp633_, NULL, _tmp636_, NULL);
					_tmp638_ = _tmp637_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp628_, _tmp638_);
					_vala_code_node_unref0 (_tmp638_);
					_vala_code_node_unref0 (_tmp633_);
					_tmp639_ = prop;
					_tmp640_ = vala_member_access_get_inner (self);
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_expression_get_value_type (_tmp641_);
					_tmp643_ = _tmp642_;
					_tmp644_ = vala_data_type_get_type_symbol (_tmp643_);
					_tmp645_ = _tmp644_;
					_tmp646_ = vala_symbol_get_scope ((ValaSymbol*) _tmp645_);
					_tmp647_ = _tmp646_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp639_, _tmp647_);
					_tmp648_ = dynamic_object_type;
					_tmp649_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_symbol_get_scope ((ValaSymbol*) _tmp650_);
					_tmp652_ = _tmp651_;
					_tmp653_ = prop;
					vala_scope_add (_tmp652_, NULL, (ValaSymbol*) _tmp653_);
					_tmp654_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp654_);
					_tmp655_ = dynamic_object_type;
					_tmp656_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp655_);
					_tmp657_ = _tmp656_;
					_tmp658_ = vala_code_context_get_analyzer (context);
					_tmp659_ = _tmp658_;
					_tmp660_ = _tmp659_->object_type;
					if (!vala_typesymbol_is_subtype_of (_tmp657_, (ValaTypeSymbol*) _tmp660_)) {
						ValaSourceReference* _tmp661_;
						ValaSourceReference* _tmp662_;
						ValaObjectType* _tmp663_;
						ValaTypeSymbol* _tmp664_;
						ValaTypeSymbol* _tmp665_;
						gchar* _tmp666_;
						gchar* _tmp667_;
						_tmp661_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp662_ = _tmp661_;
						_tmp663_ = dynamic_object_type;
						_tmp664_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp663_);
						_tmp665_ = _tmp664_;
						_tmp666_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp665_);
						_tmp667_ = _tmp666_;
						vala_report_error (_tmp662_, "dynamic properties are not supported for %s", _tmp667_);
						_g_free0 (_tmp667_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_vala_code_node_unref0 (prop);
				}
				_tmp668_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp669_ = _tmp668_;
				if (_tmp669_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp670_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp671_ = _tmp670_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp671_)) {
				ValaExpression* _tmp672_;
				ValaExpression* _tmp673_;
				ValaSymbol* _tmp674_;
				ValaSymbol* _tmp675_;
				_tmp672_ = vala_member_access_get_inner (self);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_expression_get_symbol_reference (_tmp673_);
				_tmp675_ = _tmp674_;
				if (VALA_IS_VARIABLE (_tmp675_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp676_;
					ValaSemanticAnalyzer* _tmp677_;
					ValaExpression* _tmp678_;
					ValaExpression* _tmp679_;
					ValaSymbol* _tmp680_;
					ValaSymbol* _tmp681_;
					ValaDataType* _tmp682_;
					ValaArrayType* _tmp683_;
					gboolean _tmp684_ = FALSE;
					ValaArrayType* _tmp685_;
					_tmp676_ = vala_code_context_get_analyzer (context);
					_tmp677_ = _tmp676_;
					_tmp678_ = vala_member_access_get_inner (self);
					_tmp679_ = _tmp678_;
					_tmp680_ = vala_expression_get_symbol_reference (_tmp679_);
					_tmp681_ = _tmp680_;
					_tmp682_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp677_, _tmp681_, TRUE);
					_tmp683_ = VALA_IS_ARRAY_TYPE (_tmp682_) ? ((ValaArrayType*) _tmp682_) : NULL;
					if (_tmp683_ == NULL) {
						_vala_code_node_unref0 (_tmp682_);
					}
					inner_type = _tmp683_;
					_tmp685_ = inner_type;
					if (_tmp685_ != NULL) {
						ValaArrayType* _tmp686_;
						gboolean _tmp687_;
						gboolean _tmp688_;
						_tmp686_ = inner_type;
						_tmp687_ = vala_array_type_get_inline_allocated (_tmp686_);
						_tmp688_ = _tmp687_;
						_tmp684_ = _tmp688_;
					} else {
						_tmp684_ = FALSE;
					}
					if (_tmp684_) {
						ValaSourceReference* _tmp689_;
						ValaSourceReference* _tmp690_;
						_tmp689_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp690_ = _tmp689_;
						vala_report_error (_tmp690_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp691_ = FALSE;
						ValaArrayType* _tmp692_;
						_tmp692_ = inner_type;
						if (_tmp692_ != NULL) {
							ValaArrayType* _tmp693_;
							gboolean _tmp694_;
							gboolean _tmp695_;
							_tmp693_ = inner_type;
							_tmp694_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp693_);
							_tmp695_ = _tmp694_;
							_tmp691_ = !_tmp695_;
						} else {
							_tmp691_ = FALSE;
						}
						if (_tmp691_) {
							ValaSourceReference* _tmp696_;
							ValaSourceReference* _tmp697_;
							_tmp696_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp697_ = _tmp696_;
							vala_report_error (_tmp697_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp698_;
					ValaExpression* _tmp699_;
					ValaSymbol* _tmp700_;
					ValaSymbol* _tmp701_;
					_tmp698_ = vala_member_access_get_inner (self);
					_tmp699_ = _tmp698_;
					_tmp700_ = vala_expression_get_symbol_reference (_tmp699_);
					_tmp701_ = _tmp700_;
					if (VALA_IS_CONSTANT (_tmp701_)) {
						ValaSourceReference* _tmp702_;
						ValaSourceReference* _tmp703_;
						_tmp702_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp703_ = _tmp702_;
						vala_report_error (_tmp703_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp707_ = vala_member_access_get_inner (self);
	_tmp708_ = _tmp707_;
	if (_tmp708_ == NULL) {
		ValaSymbol* _tmp709_;
		ValaSymbol* _tmp710_;
		_tmp709_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp710_ = _tmp709_;
		_tmp706_ = _tmp710_ == NULL;
	} else {
		_tmp706_ = FALSE;
	}
	if (_tmp706_) {
		ValaDataType* _tmp711_;
		ValaDataType* _tmp712_;
		_tmp711_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp712_ = _tmp711_;
		_tmp705_ = _tmp712_ != NULL;
	} else {
		_tmp705_ = FALSE;
	}
	if (_tmp705_) {
		ValaDataType* _tmp713_;
		ValaDataType* _tmp714_;
		ValaTypeSymbol* _tmp715_;
		ValaTypeSymbol* _tmp716_;
		_tmp713_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp714_ = _tmp713_;
		_tmp715_ = vala_data_type_get_type_symbol (_tmp714_);
		_tmp716_ = _tmp715_;
		_tmp704_ = VALA_IS_ENUM (_tmp716_);
	} else {
		_tmp704_ = FALSE;
	}
	if (_tmp704_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp717_;
		ValaDataType* _tmp718_;
		ValaTypeSymbol* _tmp719_;
		ValaTypeSymbol* _tmp720_;
		_tmp717_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp718_ = _tmp717_;
		_tmp719_ = vala_data_type_get_type_symbol (_tmp718_);
		_tmp720_ = _tmp719_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp720_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp721_;
			ValaList* _tmp722_;
			gint _val_size = 0;
			ValaList* _tmp723_;
			gint _tmp724_;
			gint _tmp725_;
			gint _val_index = 0;
			_tmp721_ = enum_type;
			_tmp722_ = vala_enum_get_values (_tmp721_);
			_val_list = _tmp722_;
			_tmp723_ = _val_list;
			_tmp724_ = vala_collection_get_size ((ValaCollection*) _tmp723_);
			_tmp725_ = _tmp724_;
			_val_size = _tmp725_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp726_;
				gint _tmp727_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp728_;
				gpointer _tmp729_;
				const gchar* _tmp730_;
				ValaEnumValue* _tmp731_;
				const gchar* _tmp732_;
				const gchar* _tmp733_;
				_val_index = _val_index + 1;
				_tmp726_ = _val_index;
				_tmp727_ = _val_size;
				if (!(_tmp726_ < _tmp727_)) {
					break;
				}
				_tmp728_ = _val_list;
				_tmp729_ = vala_list_get (_tmp728_, _val_index);
				val = (ValaEnumValue*) _tmp729_;
				_tmp730_ = self->priv->_member_name;
				_tmp731_ = val;
				_tmp732_ = vala_symbol_get_name ((ValaSymbol*) _tmp731_);
				_tmp733_ = _tmp732_;
				if (g_strcmp0 (_tmp730_, _tmp733_) == 0) {
					ValaEnumValue* _tmp734_;
					_tmp734_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp734_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp735_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp736_ = _tmp735_;
	if (_tmp736_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp737_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp738_ = FALSE;
		ValaExpression* _tmp739_;
		ValaExpression* _tmp740_;
		gchar* base_type_package = NULL;
		gchar* _tmp760_;
		gboolean _tmp761_ = FALSE;
		ValaSymbol* _tmp762_;
		gchar* visited_types_string = NULL;
		gchar* _tmp777_;
		ValaSourceReference* _tmp793_;
		ValaSourceReference* _tmp794_;
		const gchar* _tmp795_;
		const gchar* _tmp796_;
		const gchar* _tmp797_;
		const gchar* _tmp798_;
		ValaInvalidType* _tmp799_;
		ValaInvalidType* _tmp800_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp737_ = g_strdup ("(null)");
		base_type_name = _tmp737_;
		base_type = NULL;
		_tmp739_ = vala_member_access_get_inner (self);
		_tmp740_ = _tmp739_;
		if (_tmp740_ != NULL) {
			ValaExpression* _tmp741_;
			ValaExpression* _tmp742_;
			ValaDataType* _tmp743_;
			ValaDataType* _tmp744_;
			_tmp741_ = vala_member_access_get_inner (self);
			_tmp742_ = _tmp741_;
			_tmp743_ = vala_expression_get_value_type (_tmp742_);
			_tmp744_ = _tmp743_;
			_tmp738_ = _tmp744_ != NULL;
		} else {
			_tmp738_ = FALSE;
		}
		if (_tmp738_) {
			ValaExpression* _tmp745_;
			ValaExpression* _tmp746_;
			ValaDataType* _tmp747_;
			ValaDataType* _tmp748_;
			gchar* _tmp749_;
			ValaExpression* _tmp750_;
			ValaExpression* _tmp751_;
			ValaDataType* _tmp752_;
			ValaDataType* _tmp753_;
			ValaTypeSymbol* _tmp754_;
			ValaTypeSymbol* _tmp755_;
			_tmp745_ = vala_member_access_get_inner (self);
			_tmp746_ = _tmp745_;
			_tmp747_ = vala_expression_get_value_type (_tmp746_);
			_tmp748_ = _tmp747_;
			_tmp749_ = vala_code_node_to_string ((ValaCodeNode*) _tmp748_);
			_g_free0 (base_type_name);
			base_type_name = _tmp749_;
			_tmp750_ = vala_member_access_get_inner (self);
			_tmp751_ = _tmp750_;
			_tmp752_ = vala_expression_get_value_type (_tmp751_);
			_tmp753_ = _tmp752_;
			_tmp754_ = vala_data_type_get_type_symbol (_tmp753_);
			_tmp755_ = _tmp754_;
			base_type = (ValaSymbol*) _tmp755_;
		} else {
			ValaSymbol* _tmp756_;
			_tmp756_ = base_symbol;
			if (_tmp756_ != NULL) {
				ValaSymbol* _tmp757_;
				gchar* _tmp758_;
				ValaSymbol* _tmp759_;
				_tmp757_ = base_symbol;
				_tmp758_ = vala_symbol_get_full_name (_tmp757_);
				_g_free0 (base_type_name);
				base_type_name = _tmp758_;
				_tmp759_ = base_symbol;
				base_type = _tmp759_;
			}
		}
		_tmp760_ = g_strdup ("");
		base_type_package = _tmp760_;
		_tmp762_ = base_type;
		if (_tmp762_ != NULL) {
			ValaSymbol* _tmp763_;
			gboolean _tmp764_;
			gboolean _tmp765_;
			_tmp763_ = base_type;
			_tmp764_ = vala_symbol_get_external_package (_tmp763_);
			_tmp765_ = _tmp764_;
			_tmp761_ = _tmp765_;
		} else {
			_tmp761_ = FALSE;
		}
		if (_tmp761_) {
			ValaSymbol* _tmp766_;
			ValaSourceReference* _tmp767_;
			ValaSourceReference* _tmp768_;
			ValaSourceFile* _tmp769_;
			ValaSourceFile* _tmp770_;
			const gchar* _tmp771_;
			const gchar* _tmp772_;
			gchar* _tmp773_;
			const gchar* _tmp774_;
			_tmp766_ = base_symbol;
			_tmp767_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp766_);
			_tmp768_ = _tmp767_;
			_tmp769_ = vala_source_reference_get_file (_tmp768_);
			_tmp770_ = _tmp769_;
			_tmp771_ = vala_source_file_get_package_name (_tmp770_);
			_tmp772_ = _tmp771_;
			_tmp773_ = g_strdup (_tmp772_);
			_g_free0 (base_type_package);
			base_type_package = _tmp773_;
			_tmp774_ = base_type_package;
			if (_tmp774_ != NULL) {
				const gchar* _tmp775_;
				gchar* _tmp776_;
				_tmp775_ = base_type_package;
				_tmp776_ = g_strdup_printf (" (%s)", _tmp775_);
				_g_free0 (base_type_package);
				base_type_package = _tmp776_;
			}
		}
		_tmp777_ = g_strdup ("");
		visited_types_string = _tmp777_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp778_;
			gint _type_size = 0;
			ValaArrayList* _tmp779_;
			gint _tmp780_;
			gint _tmp781_;
			gint _type_index = 0;
			_tmp778_ = visited_types;
			_type_list = _tmp778_;
			_tmp779_ = _type_list;
			_tmp780_ = vala_collection_get_size ((ValaCollection*) _tmp779_);
			_tmp781_ = _tmp780_;
			_type_size = _tmp781_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp782_;
				gint _tmp783_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp784_;
				gpointer _tmp785_;
				const gchar* _tmp786_;
				ValaDataType* _tmp787_;
				gchar* _tmp788_;
				gchar* _tmp789_;
				gchar* _tmp790_;
				gchar* _tmp791_;
				gchar* _tmp792_;
				_type_index = _type_index + 1;
				_tmp782_ = _type_index;
				_tmp783_ = _type_size;
				if (!(_tmp782_ < _tmp783_)) {
					break;
				}
				_tmp784_ = _type_list;
				_tmp785_ = vala_list_get ((ValaList*) _tmp784_, _type_index);
				type = (ValaDataType*) _tmp785_;
				_tmp786_ = visited_types_string;
				_tmp787_ = type;
				_tmp788_ = vala_code_node_to_string ((ValaCodeNode*) _tmp787_);
				_tmp789_ = _tmp788_;
				_tmp790_ = g_strdup_printf (" or `%s'", _tmp789_);
				_tmp791_ = _tmp790_;
				_tmp792_ = g_strconcat (_tmp786_, _tmp791_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp792_;
				_g_free0 (_tmp791_);
				_g_free0 (_tmp789_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp793_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp794_ = _tmp793_;
		_tmp795_ = self->priv->_member_name;
		_tmp796_ = base_type_name;
		_tmp797_ = base_type_package;
		_tmp798_ = visited_types_string;
		vala_report_error (_tmp794_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp795_, _tmp796_, _tmp797_, _tmp798_);
		_tmp799_ = vala_invalid_type_new ();
		_tmp800_ = _tmp799_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp800_);
		_vala_code_node_unref0 (_tmp800_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp801_;
		ValaSymbol* _tmp802_;
		gboolean _tmp803_;
		gboolean _tmp804_;
		_tmp801_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp802_ = _tmp801_;
		_tmp803_ = vala_code_node_get_error ((ValaCodeNode*) _tmp802_);
		_tmp804_ = _tmp803_;
		if (_tmp804_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp805_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp806_ = _tmp805_;
	if (VALA_IS_SIGNAL (_tmp806_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp807_;
		ValaSymbol* _tmp808_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp815_;
		ValaCodeNode* _tmp816_;
		ValaCodeNode* _tmp817_;
		gboolean _tmp818_ = FALSE;
		gboolean _tmp819_ = FALSE;
		gboolean _tmp820_ = FALSE;
		ValaCodeNode* _tmp821_;
		_tmp807_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp808_ = _tmp807_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp808_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp809_;
			ValaCodeNode* _tmp810_;
			ValaCodeNode* _tmp811_;
			ValaCodeNode* _tmp812_;
			ValaCodeNode* _tmp813_;
			ValaCodeNode* _tmp814_;
			_tmp809_ = ma;
			_tmp810_ = vala_code_node_get_parent_node (_tmp809_);
			_tmp811_ = _tmp810_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp811_)) {
				break;
			}
			_tmp812_ = ma;
			_tmp813_ = vala_code_node_get_parent_node (_tmp812_);
			_tmp814_ = _tmp813_;
			ma = _tmp814_;
		}
		_tmp815_ = ma;
		_tmp816_ = vala_code_node_get_parent_node (_tmp815_);
		_tmp817_ = _tmp816_;
		parent = _tmp817_;
		_tmp821_ = parent;
		if (_tmp821_ != NULL) {
			ValaCodeNode* _tmp822_;
			_tmp822_ = parent;
			_tmp820_ = !VALA_IS_ELEMENT_ACCESS (_tmp822_);
		} else {
			_tmp820_ = FALSE;
		}
		if (_tmp820_) {
			ValaCodeNode* _tmp823_;
			ValaExpression* _tmp824_;
			ValaExpression* _tmp825_;
			_tmp823_ = ma;
			_tmp824_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp823_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp825_ = _tmp824_;
			_tmp819_ = !VALA_IS_BASE_ACCESS (_tmp825_);
		} else {
			_tmp819_ = FALSE;
		}
		if (_tmp819_) {
			gboolean _tmp826_ = FALSE;
			ValaCodeNode* _tmp827_;
			_tmp827_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp827_)) {
				_tmp826_ = TRUE;
			} else {
				ValaCodeNode* _tmp828_;
				ValaList* _tmp829_;
				_tmp828_ = parent;
				_tmp829_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp828_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp826_ = vala_collection_contains ((ValaCollection*) _tmp829_, (ValaExpression*) self);
			}
			_tmp818_ = _tmp826_;
		} else {
			_tmp818_ = FALSE;
		}
		if (_tmp818_) {
			ValaSignal* _tmp830_;
			ValaAttribute* _tmp831_;
			_tmp830_ = sig;
			_tmp831_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp830_, "HasEmitter");
			if (_tmp831_ != NULL) {
				ValaSignal* _tmp832_;
				ValaSignal* _tmp833_;
				ValaMethod* _tmp834_;
				ValaMethod* _tmp835_;
				_tmp832_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp832_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp833_ = sig;
				_tmp834_ = vala_signal_get_emitter (_tmp833_);
				_tmp835_ = _tmp834_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp835_);
			} else {
				ValaSourceReference* _tmp836_;
				ValaSourceReference* _tmp837_;
				ValaSymbol* _tmp838_;
				ValaSymbol* _tmp839_;
				gchar* _tmp840_;
				gchar* _tmp841_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp836_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp839_ = _tmp838_;
				_tmp840_ = vala_symbol_get_full_name (_tmp839_);
				_tmp841_ = _tmp840_;
				vala_report_error (_tmp837_, "Signal `%s' requires emitter in this context", _tmp841_);
				_g_free0 (_tmp841_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp842_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp843_ = _tmp842_;
	member = _tmp843_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp844_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp844_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp845_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp845_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp846_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp847_;
		ValaSymbol* _tmp848_;
		ValaSymbol* _tmp849_;
		gboolean _tmp850_ = FALSE;
		ValaBlock* _tmp851_;
		_tmp846_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp846_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp847_ = local;
		_tmp848_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp847_);
		_tmp849_ = _tmp848_;
		block = VALA_IS_BLOCK (_tmp849_) ? ((ValaBlock*) _tmp849_) : NULL;
		_tmp851_ = block;
		if (_tmp851_ != NULL) {
			ValaBlock* _tmp852_;
			ValaSymbol* _tmp853_;
			ValaSemanticAnalyzer* _tmp854_;
			ValaSemanticAnalyzer* _tmp855_;
			ValaSymbol* _tmp856_;
			ValaSymbol* _tmp857_;
			_tmp852_ = block;
			_tmp853_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp852_);
			_tmp854_ = vala_code_context_get_analyzer (context);
			_tmp855_ = _tmp854_;
			_tmp856_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp855_);
			_tmp857_ = _tmp856_;
			_tmp850_ = _tmp853_ != _tmp857_;
		} else {
			_tmp850_ = FALSE;
		}
		if (_tmp850_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp858_;
			ValaSemanticAnalyzer* _tmp859_;
			ValaSymbol* _tmp860_;
			ValaSymbol* _tmp861_;
			ValaLocalVariable* _tmp872_;
			ValaBlock* _tmp873_;
			ValaLocalVariable* _tmp874_;
			ValaDataType* _tmp875_;
			ValaDataType* _tmp876_;
			ValaTypeSymbol* _tmp877_;
			ValaTypeSymbol* _tmp878_;
			ValaSemanticAnalyzer* _tmp879_;
			ValaSemanticAnalyzer* _tmp880_;
			ValaDataType* _tmp881_;
			ValaTypeSymbol* _tmp882_;
			ValaTypeSymbol* _tmp883_;
			_tmp858_ = vala_code_context_get_analyzer (context);
			_tmp859_ = _tmp858_;
			_tmp860_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp859_);
			_tmp861_ = _tmp860_;
			sym = _tmp861_;
			while (TRUE) {
				ValaSymbol* _tmp862_;
				ValaBlock* _tmp863_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp864_;
				ValaMethod* _tmp865_;
				ValaSymbol* _tmp869_;
				ValaSymbol* _tmp870_;
				ValaSymbol* _tmp871_;
				_tmp862_ = sym;
				_tmp863_ = block;
				if (!(_tmp862_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp863_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp864_ = sym;
				method = VALA_IS_METHOD (_tmp864_) ? ((ValaMethod*) _tmp864_) : NULL;
				_tmp865_ = method;
				if (_tmp865_ != NULL) {
					ValaMethod* _tmp866_;
					ValaMethod* _tmp867_;
					ValaLocalVariable* _tmp868_;
					_tmp866_ = method;
					vala_method_set_closure (_tmp866_, TRUE);
					_tmp867_ = method;
					_tmp868_ = local;
					vala_method_add_captured_variable (_tmp867_, _tmp868_);
				}
				_tmp869_ = sym;
				_tmp870_ = vala_symbol_get_parent_symbol (_tmp869_);
				_tmp871_ = _tmp870_;
				sym = _tmp871_;
			}
			_tmp872_ = local;
			vala_local_variable_set_captured (_tmp872_, TRUE);
			_tmp873_ = block;
			vala_block_set_captured (_tmp873_, TRUE);
			_tmp874_ = local;
			_tmp875_ = vala_variable_get_variable_type ((ValaVariable*) _tmp874_);
			_tmp876_ = _tmp875_;
			_tmp877_ = vala_data_type_get_type_symbol (_tmp876_);
			_tmp878_ = _tmp877_;
			_tmp879_ = vala_code_context_get_analyzer (context);
			_tmp880_ = _tmp879_;
			_tmp881_ = _tmp880_->va_list_type;
			_tmp882_ = vala_data_type_get_type_symbol (_tmp881_);
			_tmp883_ = _tmp882_;
			if (_tmp878_ == _tmp883_) {
				ValaSourceReference* _tmp884_;
				ValaSourceReference* _tmp885_;
				ValaLocalVariable* _tmp886_;
				gchar* _tmp887_;
				gchar* _tmp888_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp884_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp885_ = _tmp884_;
				_tmp886_ = local;
				_tmp887_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp886_);
				_tmp888_ = _tmp887_;
				vala_report_error (_tmp885_, "Capturing `va_list' variable `%s' is not allowed", _tmp888_);
				_g_free0 (_tmp888_);
			}
		}
	} else {
		ValaSymbol* _tmp889_;
		_tmp889_ = member;
		if (VALA_IS_PARAMETER (_tmp889_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp890_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp891_;
			ValaSymbol* _tmp892_;
			ValaSymbol* _tmp893_;
			gboolean _tmp894_ = FALSE;
			gboolean _tmp895_ = FALSE;
			ValaMethod* _tmp896_;
			_tmp890_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp890_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp891_ = param;
			_tmp892_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp891_);
			_tmp893_ = _tmp892_;
			m = VALA_IS_METHOD (_tmp893_) ? ((ValaMethod*) _tmp893_) : NULL;
			_tmp896_ = m;
			if (_tmp896_ != NULL) {
				ValaMethod* _tmp897_;
				ValaSemanticAnalyzer* _tmp898_;
				ValaSemanticAnalyzer* _tmp899_;
				ValaSymbol* _tmp900_;
				ValaSymbol* _tmp901_;
				_tmp897_ = m;
				_tmp898_ = vala_code_context_get_analyzer (context);
				_tmp899_ = _tmp898_;
				_tmp900_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp899_);
				_tmp901_ = _tmp900_;
				_tmp895_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp897_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp901_;
			} else {
				_tmp895_ = FALSE;
			}
			if (_tmp895_) {
				ValaParameter* _tmp902_;
				ValaMethod* _tmp903_;
				ValaParameter* _tmp904_;
				ValaParameter* _tmp905_;
				_tmp902_ = param;
				_tmp903_ = m;
				_tmp904_ = vala_method_get_this_parameter (_tmp903_);
				_tmp905_ = _tmp904_;
				_tmp894_ = _tmp902_ != _tmp905_;
			} else {
				_tmp894_ = FALSE;
			}
			if (_tmp894_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp906_;
				ValaSemanticAnalyzer* _tmp907_;
				ValaSymbol* _tmp908_;
				ValaSymbol* _tmp909_;
				ValaParameter* _tmp918_;
				ValaMethod* _tmp919_;
				ValaBlock* _tmp920_;
				ValaBlock* _tmp921_;
				ValaParameter* _tmp922_;
				ValaParameterDirection _tmp923_;
				ValaParameterDirection _tmp924_;
				ValaParameter* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaTypeSymbol* _tmp933_;
				ValaTypeSymbol* _tmp934_;
				ValaSemanticAnalyzer* _tmp935_;
				ValaSemanticAnalyzer* _tmp936_;
				ValaDataType* _tmp937_;
				ValaTypeSymbol* _tmp938_;
				ValaTypeSymbol* _tmp939_;
				_tmp906_ = vala_code_context_get_analyzer (context);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp907_);
				_tmp909_ = _tmp908_;
				sym = _tmp909_;
				while (TRUE) {
					ValaSymbol* _tmp910_;
					ValaMethod* _tmp911_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp912_;
					ValaMethod* _tmp913_;
					ValaSymbol* _tmp915_;
					ValaSymbol* _tmp916_;
					ValaSymbol* _tmp917_;
					_tmp910_ = sym;
					_tmp911_ = m;
					if (!(_tmp910_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp911_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp912_ = sym;
					method = VALA_IS_METHOD (_tmp912_) ? ((ValaMethod*) _tmp912_) : NULL;
					_tmp913_ = method;
					if (_tmp913_ != NULL) {
						ValaMethod* _tmp914_;
						_tmp914_ = method;
						vala_method_set_closure (_tmp914_, TRUE);
					}
					_tmp915_ = sym;
					_tmp916_ = vala_symbol_get_parent_symbol (_tmp915_);
					_tmp917_ = _tmp916_;
					sym = _tmp917_;
				}
				_tmp918_ = param;
				vala_parameter_set_captured (_tmp918_, TRUE);
				_tmp919_ = m;
				_tmp920_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp919_);
				_tmp921_ = _tmp920_;
				vala_block_set_captured (_tmp921_, TRUE);
				_tmp922_ = param;
				_tmp923_ = vala_parameter_get_direction (_tmp922_);
				_tmp924_ = _tmp923_;
				if (_tmp924_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp925_;
					ValaSourceReference* _tmp926_;
					ValaParameter* _tmp927_;
					gchar* _tmp928_;
					gchar* _tmp929_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp925_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp926_ = _tmp925_;
					_tmp927_ = param;
					_tmp928_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp927_);
					_tmp929_ = _tmp928_;
					vala_report_error (_tmp926_, "Cannot capture reference or output parameter `%s'", _tmp929_);
					_g_free0 (_tmp929_);
				}
				_tmp930_ = param;
				_tmp931_ = vala_variable_get_variable_type ((ValaVariable*) _tmp930_);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_data_type_get_type_symbol (_tmp932_);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_code_context_get_analyzer (context);
				_tmp936_ = _tmp935_;
				_tmp937_ = _tmp936_->va_list_type;
				_tmp938_ = vala_data_type_get_type_symbol (_tmp937_);
				_tmp939_ = _tmp938_;
				if (_tmp934_ == _tmp939_) {
					ValaSourceReference* _tmp940_;
					ValaSourceReference* _tmp941_;
					ValaParameter* _tmp942_;
					gchar* _tmp943_;
					gchar* _tmp944_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp940_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp941_ = _tmp940_;
					_tmp942_ = param;
					_tmp943_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp942_);
					_tmp944_ = _tmp943_;
					vala_report_error (_tmp941_, "Capturing `va_list' parameter `%s' is not allowed", _tmp944_);
					_g_free0 (_tmp944_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp945_;
				ValaSymbol* _tmp946_;
				ValaSymbol* _tmp947_;
				ValaSymbol* _tmp948_;
				ValaSymbol* _tmp949_;
				gboolean _tmp950_ = FALSE;
				gboolean _tmp951_ = FALSE;
				ValaPropertyAccessor* _tmp952_;
				_tmp945_ = param;
				_tmp946_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp945_);
				_tmp947_ = _tmp946_;
				_tmp948_ = vala_symbol_get_parent_symbol (_tmp947_);
				_tmp949_ = _tmp948_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp949_) ? ((ValaPropertyAccessor*) _tmp949_) : NULL;
				_tmp952_ = acc;
				if (_tmp952_ != NULL) {
					ValaPropertyAccessor* _tmp953_;
					ValaSemanticAnalyzer* _tmp954_;
					ValaSemanticAnalyzer* _tmp955_;
					ValaSymbol* _tmp956_;
					ValaSymbol* _tmp957_;
					_tmp953_ = acc;
					_tmp954_ = vala_code_context_get_analyzer (context);
					_tmp955_ = _tmp954_;
					_tmp956_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp955_);
					_tmp957_ = _tmp956_;
					_tmp951_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp953_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp957_;
				} else {
					_tmp951_ = FALSE;
				}
				if (_tmp951_) {
					ValaParameter* _tmp958_;
					ValaPropertyAccessor* _tmp959_;
					ValaProperty* _tmp960_;
					ValaProperty* _tmp961_;
					ValaParameter* _tmp962_;
					ValaParameter* _tmp963_;
					_tmp958_ = param;
					_tmp959_ = acc;
					_tmp960_ = vala_property_accessor_get_prop (_tmp959_);
					_tmp961_ = _tmp960_;
					_tmp962_ = vala_property_get_this_parameter (_tmp961_);
					_tmp963_ = _tmp962_;
					_tmp950_ = _tmp958_ != _tmp963_;
				} else {
					_tmp950_ = FALSE;
				}
				if (_tmp950_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp964_;
					ValaSemanticAnalyzer* _tmp965_;
					ValaSymbol* _tmp966_;
					ValaSymbol* _tmp967_;
					ValaParameter* _tmp976_;
					ValaPropertyAccessor* _tmp977_;
					ValaBlock* _tmp978_;
					ValaBlock* _tmp979_;
					_tmp964_ = vala_code_context_get_analyzer (context);
					_tmp965_ = _tmp964_;
					_tmp966_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp965_);
					_tmp967_ = _tmp966_;
					sym = _tmp967_;
					while (TRUE) {
						ValaSymbol* _tmp968_;
						ValaMethod* _tmp969_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp970_;
						ValaMethod* _tmp971_;
						ValaSymbol* _tmp973_;
						ValaSymbol* _tmp974_;
						ValaSymbol* _tmp975_;
						_tmp968_ = sym;
						_tmp969_ = m;
						if (!(_tmp968_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp969_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp970_ = sym;
						method = VALA_IS_METHOD (_tmp970_) ? ((ValaMethod*) _tmp970_) : NULL;
						_tmp971_ = method;
						if (_tmp971_ != NULL) {
							ValaMethod* _tmp972_;
							_tmp972_ = method;
							vala_method_set_closure (_tmp972_, TRUE);
						}
						_tmp973_ = sym;
						_tmp974_ = vala_symbol_get_parent_symbol (_tmp973_);
						_tmp975_ = _tmp974_;
						sym = _tmp975_;
					}
					_tmp976_ = param;
					vala_parameter_set_captured (_tmp976_, TRUE);
					_tmp977_ = acc;
					_tmp978_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp977_);
					_tmp979_ = _tmp978_;
					vala_block_set_captured (_tmp979_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp980_;
			_tmp980_ = member;
			if (VALA_IS_FIELD (_tmp980_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp981_;
				ValaField* _tmp982_;
				ValaSymbolAccessibility _tmp983_;
				ValaSymbolAccessibility _tmp984_;
				ValaField* _tmp985_;
				ValaMemberBinding _tmp986_;
				ValaMemberBinding _tmp987_;
				ValaField* _tmp988_;
				ValaMemberBinding _tmp989_;
				ValaMemberBinding _tmp990_;
				ValaField* _tmp991_;
				ValaDataType* _tmp992_;
				ValaDataType* _tmp993_;
				_tmp981_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp981_, VALA_TYPE_FIELD, ValaField);
				_tmp982_ = f;
				_tmp983_ = vala_symbol_get_access ((ValaSymbol*) _tmp982_);
				_tmp984_ = _tmp983_;
				access = _tmp984_;
				_tmp985_ = f;
				_tmp986_ = vala_field_get_binding (_tmp985_);
				_tmp987_ = _tmp986_;
				instance = _tmp987_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp988_ = f;
				_tmp989_ = vala_field_get_binding (_tmp988_);
				_tmp990_ = _tmp989_;
				klass = _tmp990_ == VALA_MEMBER_BINDING_CLASS;
				_tmp991_ = f;
				_tmp992_ = vala_variable_get_variable_type ((ValaVariable*) _tmp991_);
				_tmp993_ = _tmp992_;
				if (VALA_IS_GENERIC_TYPE (_tmp993_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp994_;
				_tmp994_ = member;
				if (VALA_IS_CONSTANT (_tmp994_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp995_;
					ValaConstant* _tmp996_;
					ValaSymbolAccessibility _tmp997_;
					ValaSymbolAccessibility _tmp998_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp999_;
					ValaSymbol* _tmp1000_;
					ValaSymbol* _tmp1001_;
					gboolean _tmp1002_ = FALSE;
					ValaBlock* _tmp1003_;
					_tmp995_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp995_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp996_ = c;
					_tmp997_ = vala_symbol_get_access ((ValaSymbol*) _tmp996_);
					_tmp998_ = _tmp997_;
					access = _tmp998_;
					_tmp999_ = c;
					_tmp1000_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp999_);
					_tmp1001_ = _tmp1000_;
					block = VALA_IS_BLOCK (_tmp1001_) ? ((ValaBlock*) _tmp1001_) : NULL;
					_tmp1003_ = block;
					if (_tmp1003_ != NULL) {
						ValaBlock* _tmp1004_;
						ValaSymbol* _tmp1005_;
						ValaSemanticAnalyzer* _tmp1006_;
						ValaSemanticAnalyzer* _tmp1007_;
						ValaSymbol* _tmp1008_;
						ValaSymbol* _tmp1009_;
						_tmp1004_ = block;
						_tmp1005_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1004_);
						_tmp1006_ = vala_code_context_get_analyzer (context);
						_tmp1007_ = _tmp1006_;
						_tmp1008_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1007_);
						_tmp1009_ = _tmp1008_;
						_tmp1002_ = _tmp1005_ != _tmp1009_;
					} else {
						_tmp1002_ = FALSE;
					}
					if (_tmp1002_) {
						ValaSourceReference* _tmp1010_;
						ValaSourceReference* _tmp1011_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1010_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1011_ = _tmp1010_;
						vala_report_error (_tmp1011_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1012_;
					_tmp1012_ = member;
					if (VALA_IS_METHOD (_tmp1012_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1013_;
						ValaMethod* _tmp1014_;
						gboolean _tmp1015_;
						gboolean _tmp1016_;
						ValaMethod* _tmp1103_;
						ValaSymbolAccessibility _tmp1104_;
						ValaSymbolAccessibility _tmp1105_;
						ValaMethod* _tmp1106_;
						ValaMethod* _tmp1110_;
						ValaMemberBinding _tmp1111_;
						ValaMemberBinding _tmp1112_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1132_;
						ValaDataType* _tmp1133_;
						ValaDataType* _tmp1134_;
						gboolean _tmp1135_ = FALSE;
						ValaGenericType* _tmp1136_;
						_tmp1013_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1013_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1014_ = m;
						_tmp1015_ = vala_method_get_is_async_callback (_tmp1014_);
						_tmp1016_ = _tmp1015_;
						if (_tmp1016_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1017_;
							ValaSemanticAnalyzer* _tmp1018_;
							ValaMethod* _tmp1019_;
							ValaMethod* _tmp1020_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1021_;
							ValaMethod* _tmp1048_;
							ValaSemanticAnalyzer* _tmp1049_;
							ValaSemanticAnalyzer* _tmp1050_;
							ValaMethod* _tmp1051_;
							ValaMethod* _tmp1052_;
							ValaMethod* _tmp1068_;
							ValaMethod* _tmp1069_;
							ValaMethod* _tmp1070_;
							ValaSymbol* _tmp1071_;
							ValaSymbol* _tmp1072_;
							_tmp1017_ = vala_code_context_get_analyzer (context);
							_tmp1018_ = _tmp1017_;
							_tmp1019_ = vala_semantic_analyzer_get_current_async_method (_tmp1018_);
							_tmp1020_ = _tmp1019_;
							async_method = _tmp1020_;
							is_valid_access = FALSE;
							_tmp1021_ = async_method;
							if (_tmp1021_ != NULL) {
								ValaMethod* _tmp1022_;
								ValaMethod* _tmp1023_;
								ValaMethod* _tmp1024_;
								_tmp1022_ = m;
								_tmp1023_ = async_method;
								_tmp1024_ = vala_method_get_callback_method (_tmp1023_);
								if (_tmp1022_ == _tmp1024_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1025_ = FALSE;
									ValaMethod* _tmp1026_;
									ValaMethod* _tmp1027_;
									ValaMethod* _tmp1028_;
									_tmp1026_ = async_method;
									_tmp1027_ = vala_method_get_base_method (_tmp1026_);
									_tmp1028_ = _tmp1027_;
									if (_tmp1028_ != NULL) {
										ValaMethod* _tmp1029_;
										ValaMethod* _tmp1030_;
										ValaMethod* _tmp1031_;
										ValaMethod* _tmp1032_;
										ValaMethod* _tmp1033_;
										_tmp1029_ = m;
										_tmp1030_ = async_method;
										_tmp1031_ = vala_method_get_base_method (_tmp1030_);
										_tmp1032_ = _tmp1031_;
										_tmp1033_ = vala_method_get_callback_method (_tmp1032_);
										_tmp1025_ = _tmp1029_ == _tmp1033_;
									} else {
										_tmp1025_ = FALSE;
									}
									if (_tmp1025_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1034_ = FALSE;
										ValaMethod* _tmp1035_;
										ValaMethod* _tmp1036_;
										ValaMethod* _tmp1037_;
										_tmp1035_ = async_method;
										_tmp1036_ = vala_method_get_base_interface_method (_tmp1035_);
										_tmp1037_ = _tmp1036_;
										if (_tmp1037_ != NULL) {
											ValaMethod* _tmp1038_;
											ValaMethod* _tmp1039_;
											ValaMethod* _tmp1040_;
											ValaMethod* _tmp1041_;
											ValaMethod* _tmp1042_;
											_tmp1038_ = m;
											_tmp1039_ = async_method;
											_tmp1040_ = vala_method_get_base_interface_method (_tmp1039_);
											_tmp1041_ = _tmp1040_;
											_tmp1042_ = vala_method_get_callback_method (_tmp1041_);
											_tmp1034_ = _tmp1038_ == _tmp1042_;
										} else {
											_tmp1034_ = FALSE;
										}
										if (_tmp1034_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1043_;
								ValaSourceReference* _tmp1044_;
								ValaMethod* _tmp1045_;
								gchar* _tmp1046_;
								gchar* _tmp1047_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1043_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1044_ = _tmp1043_;
								_tmp1045_ = m;
								_tmp1046_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1045_);
								_tmp1047_ = _tmp1046_;
								vala_report_error (_tmp1044_, "Access to async callback `%s' not allowed in this context", _tmp1047_);
								_g_free0 (_tmp1047_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1048_ = async_method;
							_tmp1049_ = vala_code_context_get_analyzer (context);
							_tmp1050_ = _tmp1049_;
							_tmp1051_ = vala_semantic_analyzer_get_current_method (_tmp1050_);
							_tmp1052_ = _tmp1051_;
							if (_tmp1048_ != _tmp1052_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1053_;
								ValaSemanticAnalyzer* _tmp1054_;
								ValaMethod* _tmp1055_;
								ValaMethod* _tmp1056_;
								ValaMethod* _tmp1065_;
								ValaBlock* _tmp1066_;
								ValaBlock* _tmp1067_;
								_tmp1053_ = vala_code_context_get_analyzer (context);
								_tmp1054_ = _tmp1053_;
								_tmp1055_ = vala_semantic_analyzer_get_current_method (_tmp1054_);
								_tmp1056_ = _tmp1055_;
								sym = (ValaSymbol*) _tmp1056_;
								while (TRUE) {
									ValaSymbol* _tmp1057_;
									ValaMethod* _tmp1058_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1059_;
									ValaMethod* _tmp1060_;
									ValaSymbol* _tmp1062_;
									ValaSymbol* _tmp1063_;
									ValaSymbol* _tmp1064_;
									_tmp1057_ = sym;
									_tmp1058_ = async_method;
									if (!(_tmp1057_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1058_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1059_ = sym;
									method = VALA_IS_METHOD (_tmp1059_) ? ((ValaMethod*) _tmp1059_) : NULL;
									_tmp1060_ = method;
									if (_tmp1060_ != NULL) {
										ValaMethod* _tmp1061_;
										_tmp1061_ = method;
										vala_method_set_closure (_tmp1061_, TRUE);
									}
									_tmp1062_ = sym;
									_tmp1063_ = vala_symbol_get_parent_symbol (_tmp1062_);
									_tmp1064_ = _tmp1063_;
									sym = _tmp1064_;
								}
								_tmp1065_ = async_method;
								_tmp1066_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1065_);
								_tmp1067_ = _tmp1066_;
								vala_block_set_captured (_tmp1067_, TRUE);
							}
							_tmp1068_ = async_method;
							_tmp1069_ = vala_method_get_callback_method (_tmp1068_);
							m = _tmp1069_;
							_tmp1070_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1070_);
							_tmp1071_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1072_ = _tmp1071_;
							member = _tmp1072_;
						} else {
							ValaMethod* _tmp1073_;
							ValaMethod* _tmp1074_;
							ValaMethod* _tmp1075_;
							_tmp1073_ = m;
							_tmp1074_ = vala_method_get_base_method (_tmp1073_);
							_tmp1075_ = _tmp1074_;
							if (_tmp1075_ != NULL) {
								ValaMethod* _tmp1076_;
								ValaMethod* _tmp1077_;
								ValaMethod* _tmp1078_;
								ValaMethod* _tmp1079_;
								ValaSignal* _tmp1080_;
								ValaSignal* _tmp1081_;
								ValaSymbol* _tmp1086_;
								ValaSymbol* _tmp1087_;
								_tmp1076_ = m;
								_tmp1077_ = vala_method_get_base_method (_tmp1076_);
								_tmp1078_ = _tmp1077_;
								m = _tmp1078_;
								_tmp1079_ = m;
								_tmp1080_ = vala_method_get_signal_reference (_tmp1079_);
								_tmp1081_ = _tmp1080_;
								if (_tmp1081_ != NULL) {
									ValaMethod* _tmp1082_;
									ValaSignal* _tmp1083_;
									ValaSignal* _tmp1084_;
									_tmp1082_ = m;
									_tmp1083_ = vala_method_get_signal_reference (_tmp1082_);
									_tmp1084_ = _tmp1083_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1084_);
								} else {
									ValaMethod* _tmp1085_;
									_tmp1085_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1085_);
								}
								_tmp1086_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1087_ = _tmp1086_;
								member = _tmp1087_;
							} else {
								ValaMethod* _tmp1088_;
								ValaMethod* _tmp1089_;
								ValaMethod* _tmp1090_;
								_tmp1088_ = m;
								_tmp1089_ = vala_method_get_base_interface_method (_tmp1088_);
								_tmp1090_ = _tmp1089_;
								if (_tmp1090_ != NULL) {
									ValaMethod* _tmp1091_;
									ValaMethod* _tmp1092_;
									ValaMethod* _tmp1093_;
									ValaMethod* _tmp1094_;
									ValaSignal* _tmp1095_;
									ValaSignal* _tmp1096_;
									ValaSymbol* _tmp1101_;
									ValaSymbol* _tmp1102_;
									_tmp1091_ = m;
									_tmp1092_ = vala_method_get_base_interface_method (_tmp1091_);
									_tmp1093_ = _tmp1092_;
									m = _tmp1093_;
									_tmp1094_ = m;
									_tmp1095_ = vala_method_get_signal_reference (_tmp1094_);
									_tmp1096_ = _tmp1095_;
									if (_tmp1096_ != NULL) {
										ValaMethod* _tmp1097_;
										ValaSignal* _tmp1098_;
										ValaSignal* _tmp1099_;
										_tmp1097_ = m;
										_tmp1098_ = vala_method_get_signal_reference (_tmp1097_);
										_tmp1099_ = _tmp1098_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1099_);
									} else {
										ValaMethod* _tmp1100_;
										_tmp1100_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1100_);
									}
									_tmp1101_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1102_ = _tmp1101_;
									member = _tmp1102_;
								}
							}
						}
						_tmp1103_ = m;
						_tmp1104_ = vala_symbol_get_access ((ValaSymbol*) _tmp1103_);
						_tmp1105_ = _tmp1104_;
						access = _tmp1105_;
						_tmp1106_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1106_)) {
							ValaMethod* _tmp1107_;
							ValaMemberBinding _tmp1108_;
							ValaMemberBinding _tmp1109_;
							_tmp1107_ = m;
							_tmp1108_ = vala_method_get_binding (_tmp1107_);
							_tmp1109_ = _tmp1108_;
							instance = _tmp1109_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1110_ = m;
						_tmp1111_ = vala_method_get_binding (_tmp1110_);
						_tmp1112_ = _tmp1111_;
						klass = _tmp1112_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1113_;
							ValaList* _tmp1114_;
							gint _param_size = 0;
							ValaList* _tmp1115_;
							gint _tmp1116_;
							gint _tmp1117_;
							gint _param_index = 0;
							_tmp1113_ = m;
							_tmp1114_ = vala_callable_get_parameters ((ValaCallable*) _tmp1113_);
							_param_list = _tmp1114_;
							_tmp1115_ = _param_list;
							_tmp1116_ = vala_collection_get_size ((ValaCollection*) _tmp1115_);
							_tmp1117_ = _tmp1116_;
							_param_size = _tmp1117_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1118_;
								gint _tmp1119_;
								ValaParameter* param = NULL;
								ValaList* _tmp1120_;
								gpointer _tmp1121_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1122_;
								ValaDataType* _tmp1123_;
								ValaDataType* _tmp1124_;
								gboolean _tmp1125_ = FALSE;
								ValaGenericType* _tmp1126_;
								_param_index = _param_index + 1;
								_tmp1118_ = _param_index;
								_tmp1119_ = _param_size;
								if (!(_tmp1118_ < _tmp1119_)) {
									break;
								}
								_tmp1120_ = _param_list;
								_tmp1121_ = vala_list_get (_tmp1120_, _param_index);
								param = (ValaParameter*) _tmp1121_;
								_tmp1122_ = param;
								_tmp1123_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1122_);
								_tmp1124_ = _tmp1123_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1124_) ? ((ValaGenericType*) _tmp1124_) : NULL;
								_tmp1126_ = generic_type;
								if (_tmp1126_ != NULL) {
									ValaGenericType* _tmp1127_;
									ValaTypeParameter* _tmp1128_;
									ValaTypeParameter* _tmp1129_;
									ValaSymbol* _tmp1130_;
									ValaSymbol* _tmp1131_;
									_tmp1127_ = generic_type;
									_tmp1128_ = vala_generic_type_get_type_parameter (_tmp1127_);
									_tmp1129_ = _tmp1128_;
									_tmp1130_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1129_);
									_tmp1131_ = _tmp1130_;
									_tmp1125_ = VALA_IS_TYPESYMBOL (_tmp1131_);
								} else {
									_tmp1125_ = FALSE;
								}
								if (_tmp1125_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1132_ = m;
						_tmp1133_ = vala_callable_get_return_type ((ValaCallable*) _tmp1132_);
						_tmp1134_ = _tmp1133_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1134_) ? ((ValaGenericType*) _tmp1134_) : NULL;
						_tmp1136_ = generic_type;
						if (_tmp1136_ != NULL) {
							ValaGenericType* _tmp1137_;
							ValaTypeParameter* _tmp1138_;
							ValaTypeParameter* _tmp1139_;
							ValaSymbol* _tmp1140_;
							ValaSymbol* _tmp1141_;
							_tmp1137_ = generic_type;
							_tmp1138_ = vala_generic_type_get_type_parameter (_tmp1137_);
							_tmp1139_ = _tmp1138_;
							_tmp1140_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1139_);
							_tmp1141_ = _tmp1140_;
							_tmp1135_ = VALA_IS_TYPESYMBOL (_tmp1141_);
						} else {
							_tmp1135_ = FALSE;
						}
						if (_tmp1135_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1142_;
						_tmp1142_ = member;
						if (VALA_IS_PROPERTY (_tmp1142_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1143_;
							ValaProperty* _tmp1144_;
							ValaProperty* _tmp1145_;
							ValaProperty* _tmp1146_;
							ValaProperty* _tmp1147_;
							ValaProperty* _tmp1163_;
							ValaSymbolAccessibility _tmp1164_;
							ValaSymbolAccessibility _tmp1165_;
							gboolean _tmp1166_;
							gboolean _tmp1167_;
							ValaProperty* _tmp1266_;
							ValaMemberBinding _tmp1267_;
							ValaMemberBinding _tmp1268_;
							ValaProperty* _tmp1269_;
							ValaDataType* _tmp1270_;
							ValaDataType* _tmp1271_;
							_tmp1143_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1143_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1144_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1144_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1145_ = prop;
							_tmp1146_ = vala_property_get_base_property (_tmp1145_);
							_tmp1147_ = _tmp1146_;
							if (_tmp1147_ != NULL) {
								ValaProperty* _tmp1148_;
								ValaProperty* _tmp1149_;
								ValaProperty* _tmp1150_;
								ValaProperty* _tmp1151_;
								ValaSymbol* _tmp1152_;
								ValaSymbol* _tmp1153_;
								_tmp1148_ = prop;
								_tmp1149_ = vala_property_get_base_property (_tmp1148_);
								_tmp1150_ = _tmp1149_;
								prop = _tmp1150_;
								_tmp1151_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1151_);
								_tmp1152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1153_ = _tmp1152_;
								member = _tmp1153_;
							} else {
								ValaProperty* _tmp1154_;
								ValaProperty* _tmp1155_;
								ValaProperty* _tmp1156_;
								_tmp1154_ = prop;
								_tmp1155_ = vala_property_get_base_interface_property (_tmp1154_);
								_tmp1156_ = _tmp1155_;
								if (_tmp1156_ != NULL) {
									ValaProperty* _tmp1157_;
									ValaProperty* _tmp1158_;
									ValaProperty* _tmp1159_;
									ValaProperty* _tmp1160_;
									ValaSymbol* _tmp1161_;
									ValaSymbol* _tmp1162_;
									_tmp1157_ = prop;
									_tmp1158_ = vala_property_get_base_interface_property (_tmp1157_);
									_tmp1159_ = _tmp1158_;
									prop = _tmp1159_;
									_tmp1160_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1160_);
									_tmp1161_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1162_ = _tmp1161_;
									member = _tmp1162_;
								}
							}
							_tmp1163_ = prop;
							_tmp1164_ = vala_symbol_get_access ((ValaSymbol*) _tmp1163_);
							_tmp1165_ = _tmp1164_;
							access = _tmp1165_;
							_tmp1166_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1167_ = _tmp1166_;
							if (_tmp1167_) {
								ValaProperty* _tmp1168_;
								ValaPropertyAccessor* _tmp1169_;
								ValaPropertyAccessor* _tmp1170_;
								ValaProperty* _tmp1214_;
								ValaSymbolAccessibility _tmp1215_;
								ValaSymbolAccessibility _tmp1216_;
								_tmp1168_ = prop;
								_tmp1169_ = vala_property_get_set_accessor (_tmp1168_);
								_tmp1170_ = _tmp1169_;
								if (_tmp1170_ == NULL) {
									ValaSourceReference* _tmp1171_;
									ValaSourceReference* _tmp1172_;
									ValaProperty* _tmp1173_;
									gchar* _tmp1174_;
									gchar* _tmp1175_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1172_ = _tmp1171_;
									_tmp1173_ = prop;
									_tmp1174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1173_);
									_tmp1175_ = _tmp1174_;
									vala_report_error (_tmp1172_, "Property `%s' is read-only", _tmp1175_);
									_g_free0 (_tmp1175_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1176_ = FALSE;
									ValaProperty* _tmp1177_;
									ValaPropertyAccessor* _tmp1178_;
									ValaPropertyAccessor* _tmp1179_;
									gboolean _tmp1180_;
									gboolean _tmp1181_;
									_tmp1177_ = prop;
									_tmp1178_ = vala_property_get_set_accessor (_tmp1177_);
									_tmp1179_ = _tmp1178_;
									_tmp1180_ = vala_property_accessor_get_writable (_tmp1179_);
									_tmp1181_ = _tmp1180_;
									if (!_tmp1181_) {
										ValaProperty* _tmp1182_;
										ValaPropertyAccessor* _tmp1183_;
										ValaPropertyAccessor* _tmp1184_;
										gboolean _tmp1185_;
										gboolean _tmp1186_;
										_tmp1182_ = prop;
										_tmp1183_ = vala_property_get_set_accessor (_tmp1182_);
										_tmp1184_ = _tmp1183_;
										_tmp1185_ = vala_property_accessor_get_construction (_tmp1184_);
										_tmp1186_ = _tmp1185_;
										_tmp1176_ = _tmp1186_;
									} else {
										_tmp1176_ = FALSE;
									}
									if (_tmp1176_) {
										ValaSemanticAnalyzer* _tmp1187_;
										ValaSemanticAnalyzer* _tmp1188_;
										ValaMethod* _tmp1189_;
										_tmp1187_ = vala_code_context_get_analyzer (context);
										_tmp1188_ = _tmp1187_;
										_tmp1189_ = vala_semantic_analyzer_find_current_method (_tmp1188_);
										if (VALA_IS_CREATION_METHOD (_tmp1189_)) {
											ValaSourceReference* _tmp1190_;
											ValaSourceReference* _tmp1191_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1191_ = _tmp1190_;
											vala_report_error (_tmp1191_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1192_;
											ValaSemanticAnalyzer* _tmp1193_;
											_tmp1192_ = vala_code_context_get_analyzer (context);
											_tmp1193_ = _tmp1192_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1193_)) {
												ValaSemanticAnalyzer* _tmp1194_;
												ValaSemanticAnalyzer* _tmp1195_;
												ValaTypeSymbol* _tmp1196_;
												ValaTypeSymbol* _tmp1197_;
												ValaProperty* _tmp1198_;
												ValaSymbol* _tmp1199_;
												ValaSymbol* _tmp1200_;
												_tmp1194_ = vala_code_context_get_analyzer (context);
												_tmp1195_ = _tmp1194_;
												_tmp1196_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1195_);
												_tmp1197_ = _tmp1196_;
												_tmp1198_ = prop;
												_tmp1199_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1198_);
												_tmp1200_ = _tmp1199_;
												if (!vala_typesymbol_is_subtype_of (_tmp1197_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1200_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1201_;
													ValaSourceReference* _tmp1202_;
													ValaProperty* _tmp1203_;
													gchar* _tmp1204_;
													gchar* _tmp1205_;
													ValaSemanticAnalyzer* _tmp1206_;
													ValaSemanticAnalyzer* _tmp1207_;
													ValaTypeSymbol* _tmp1208_;
													ValaTypeSymbol* _tmp1209_;
													gchar* _tmp1210_;
													gchar* _tmp1211_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1202_ = _tmp1201_;
													_tmp1203_ = prop;
													_tmp1204_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1203_);
													_tmp1205_ = _tmp1204_;
													_tmp1206_ = vala_code_context_get_analyzer (context);
													_tmp1207_ = _tmp1206_;
													_tmp1208_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1207_);
													_tmp1209_ = _tmp1208_;
													_tmp1210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1209_);
													_tmp1211_ = _tmp1210_;
													vala_report_error (_tmp1202_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1205_, _tmp1211_);
													_g_free0 (_tmp1211_);
													_g_free0 (_tmp1205_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1212_;
												ValaSourceReference* _tmp1213_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1213_ = _tmp1212_;
												vala_report_error (_tmp1213_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1214_ = prop;
								_tmp1215_ = vala_symbol_get_access ((ValaSymbol*) _tmp1214_);
								_tmp1216_ = _tmp1215_;
								if (_tmp1216_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1217_;
									ValaPropertyAccessor* _tmp1218_;
									ValaPropertyAccessor* _tmp1219_;
									ValaSymbolAccessibility _tmp1220_;
									ValaSymbolAccessibility _tmp1221_;
									_tmp1217_ = prop;
									_tmp1218_ = vala_property_get_set_accessor (_tmp1217_);
									_tmp1219_ = _tmp1218_;
									_tmp1220_ = vala_symbol_get_access ((ValaSymbol*) _tmp1219_);
									_tmp1221_ = _tmp1220_;
									access = _tmp1221_;
								} else {
									gboolean _tmp1222_ = FALSE;
									ValaProperty* _tmp1223_;
									ValaSymbolAccessibility _tmp1224_;
									ValaSymbolAccessibility _tmp1225_;
									_tmp1223_ = prop;
									_tmp1224_ = vala_symbol_get_access ((ValaSymbol*) _tmp1223_);
									_tmp1225_ = _tmp1224_;
									if (_tmp1225_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1226_;
										ValaPropertyAccessor* _tmp1227_;
										ValaPropertyAccessor* _tmp1228_;
										ValaSymbolAccessibility _tmp1229_;
										ValaSymbolAccessibility _tmp1230_;
										_tmp1226_ = prop;
										_tmp1227_ = vala_property_get_set_accessor (_tmp1226_);
										_tmp1228_ = _tmp1227_;
										_tmp1229_ = vala_symbol_get_access ((ValaSymbol*) _tmp1228_);
										_tmp1230_ = _tmp1229_;
										_tmp1222_ = _tmp1230_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1222_ = FALSE;
									}
									if (_tmp1222_) {
										ValaProperty* _tmp1231_;
										ValaPropertyAccessor* _tmp1232_;
										ValaPropertyAccessor* _tmp1233_;
										ValaSymbolAccessibility _tmp1234_;
										ValaSymbolAccessibility _tmp1235_;
										_tmp1231_ = prop;
										_tmp1232_ = vala_property_get_set_accessor (_tmp1231_);
										_tmp1233_ = _tmp1232_;
										_tmp1234_ = vala_symbol_get_access ((ValaSymbol*) _tmp1233_);
										_tmp1235_ = _tmp1234_;
										access = _tmp1235_;
									}
								}
							} else {
								ValaProperty* _tmp1236_;
								ValaPropertyAccessor* _tmp1237_;
								ValaPropertyAccessor* _tmp1238_;
								ValaProperty* _tmp1244_;
								ValaSymbolAccessibility _tmp1245_;
								ValaSymbolAccessibility _tmp1246_;
								_tmp1236_ = prop;
								_tmp1237_ = vala_property_get_get_accessor (_tmp1236_);
								_tmp1238_ = _tmp1237_;
								if (_tmp1238_ == NULL) {
									ValaSourceReference* _tmp1239_;
									ValaSourceReference* _tmp1240_;
									ValaProperty* _tmp1241_;
									gchar* _tmp1242_;
									gchar* _tmp1243_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1240_ = _tmp1239_;
									_tmp1241_ = prop;
									_tmp1242_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1241_);
									_tmp1243_ = _tmp1242_;
									vala_report_error (_tmp1240_, "Property `%s' is write-only", _tmp1243_);
									_g_free0 (_tmp1243_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1244_ = prop;
								_tmp1245_ = vala_symbol_get_access ((ValaSymbol*) _tmp1244_);
								_tmp1246_ = _tmp1245_;
								if (_tmp1246_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1247_;
									ValaPropertyAccessor* _tmp1248_;
									ValaPropertyAccessor* _tmp1249_;
									ValaSymbolAccessibility _tmp1250_;
									ValaSymbolAccessibility _tmp1251_;
									_tmp1247_ = prop;
									_tmp1248_ = vala_property_get_get_accessor (_tmp1247_);
									_tmp1249_ = _tmp1248_;
									_tmp1250_ = vala_symbol_get_access ((ValaSymbol*) _tmp1249_);
									_tmp1251_ = _tmp1250_;
									access = _tmp1251_;
								} else {
									gboolean _tmp1252_ = FALSE;
									ValaProperty* _tmp1253_;
									ValaSymbolAccessibility _tmp1254_;
									ValaSymbolAccessibility _tmp1255_;
									_tmp1253_ = prop;
									_tmp1254_ = vala_symbol_get_access ((ValaSymbol*) _tmp1253_);
									_tmp1255_ = _tmp1254_;
									if (_tmp1255_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1256_;
										ValaPropertyAccessor* _tmp1257_;
										ValaPropertyAccessor* _tmp1258_;
										ValaSymbolAccessibility _tmp1259_;
										ValaSymbolAccessibility _tmp1260_;
										_tmp1256_ = prop;
										_tmp1257_ = vala_property_get_get_accessor (_tmp1256_);
										_tmp1258_ = _tmp1257_;
										_tmp1259_ = vala_symbol_get_access ((ValaSymbol*) _tmp1258_);
										_tmp1260_ = _tmp1259_;
										_tmp1252_ = _tmp1260_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1252_ = FALSE;
									}
									if (_tmp1252_) {
										ValaProperty* _tmp1261_;
										ValaPropertyAccessor* _tmp1262_;
										ValaPropertyAccessor* _tmp1263_;
										ValaSymbolAccessibility _tmp1264_;
										ValaSymbolAccessibility _tmp1265_;
										_tmp1261_ = prop;
										_tmp1262_ = vala_property_get_get_accessor (_tmp1261_);
										_tmp1263_ = _tmp1262_;
										_tmp1264_ = vala_symbol_get_access ((ValaSymbol*) _tmp1263_);
										_tmp1265_ = _tmp1264_;
										access = _tmp1265_;
									}
								}
							}
							_tmp1266_ = prop;
							_tmp1267_ = vala_property_get_binding (_tmp1266_);
							_tmp1268_ = _tmp1267_;
							instance = _tmp1268_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1269_ = prop;
							_tmp1270_ = vala_property_get_property_type (_tmp1269_);
							_tmp1271_ = _tmp1270_;
							if (VALA_IS_GENERIC_TYPE (_tmp1271_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1272_;
							_tmp1272_ = member;
							if (VALA_IS_SIGNAL (_tmp1272_)) {
								ValaSymbol* _tmp1273_;
								ValaSymbolAccessibility _tmp1274_;
								ValaSymbolAccessibility _tmp1275_;
								instance = TRUE;
								_tmp1273_ = member;
								_tmp1274_ = vala_symbol_get_access (_tmp1273_);
								_tmp1275_ = _tmp1274_;
								access = _tmp1275_;
							} else {
								gboolean _tmp1276_ = FALSE;
								gboolean _tmp1277_;
								_tmp1277_ = self->priv->_creation_member;
								if (!_tmp1277_) {
									ValaSymbol* _tmp1278_;
									_tmp1278_ = member;
									_tmp1276_ = VALA_IS_ERROR_CODE (_tmp1278_);
								} else {
									_tmp1276_ = FALSE;
								}
								if (_tmp1276_) {
									ValaSymbol* _tmp1279_;
									ValaConstant* _tmp1280_;
									ValaConstant* _tmp1281_;
									ValaSymbol* _tmp1282_;
									ValaSymbol* _tmp1283_;
									_tmp1279_ = member;
									_tmp1280_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1279_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1281_ = _tmp1280_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1281_);
									_tmp1282_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1283_ = _tmp1282_;
									member = _tmp1283_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1284_;
		ValaSymbol* _tmp1285_;
		ValaCodeNode* _tmp1286_;
		ValaCodeNode* _tmp1287_;
		ValaCodeNode* _tmp1288_;
		gboolean _tmp1289_ = FALSE;
		ValaCodeNode* _tmp1290_;
		_tmp1284_ = parent;
		_tmp1285_ = member;
		if (!(_tmp1284_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1285_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1286_ = parent;
		_tmp1287_ = vala_code_node_get_parent_node (_tmp1286_);
		_tmp1288_ = _tmp1287_;
		parent = _tmp1288_;
		_tmp1290_ = parent;
		if (_tmp1290_ == NULL) {
			_tmp1289_ = TRUE;
		} else {
			ValaCodeNode* _tmp1291_;
			ValaSymbol* _tmp1292_;
			_tmp1291_ = parent;
			_tmp1292_ = member;
			_tmp1289_ = _tmp1291_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1292_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1289_) {
			break;
		}
	}
	_tmp1293_ = parent;
	_tmp1294_ = member;
	if (_tmp1293_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1294_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1295_;
		_tmp1295_ = member;
		vala_symbol_set_used (_tmp1295_, TRUE);
	}
	_tmp1296_ = member;
	_tmp1297_ = vala_symbol_get_version (_tmp1296_);
	_tmp1298_ = _tmp1297_;
	_tmp1299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1300_ = _tmp1299_;
	vala_version_attribute_check (_tmp1298_, context, _tmp1300_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1302_;
		ValaSymbol* _tmp1303_;
		ValaSymbol* _tmp1304_;
		_tmp1302_ = member;
		_tmp1303_ = vala_symbol_get_parent_symbol (_tmp1302_);
		_tmp1304_ = _tmp1303_;
		_tmp1301_ = VALA_IS_TYPESYMBOL (_tmp1304_);
	} else {
		_tmp1301_ = FALSE;
	}
	if (_tmp1301_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1305_;
		ValaSymbol* _tmp1306_;
		ValaSymbol* _tmp1307_;
		gboolean in_subtype = FALSE;
		_tmp1305_ = member;
		_tmp1306_ = vala_symbol_get_parent_symbol (_tmp1305_);
		_tmp1307_ = _tmp1306_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1307_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1308_;
			ValaSemanticAnalyzer* _tmp1309_;
			ValaSymbol* _tmp1310_;
			ValaSymbol* _tmp1311_;
			ValaSymbol* _tmp1312_;
			_tmp1308_ = vala_code_context_get_analyzer (context);
			_tmp1309_ = _tmp1308_;
			_tmp1310_ = vala_semantic_analyzer_get_current_symbol (_tmp1309_);
			_tmp1311_ = _tmp1310_;
			_tmp1312_ = _vala_code_node_ref0 (_tmp1311_);
			this_symbol = _tmp1312_;
			{
				gboolean _tmp1313_ = FALSE;
				_tmp1313_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1318_;
					ValaSymbol* _tmp1319_;
					ValaTypeSymbol* _tmp1320_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1321_;
					gboolean _tmp1322_ = FALSE;
					ValaClass* _tmp1323_;
					if (!_tmp1313_) {
						ValaSymbol* _tmp1314_;
						ValaSymbol* _tmp1315_;
						ValaSymbol* _tmp1316_;
						ValaSymbol* _tmp1317_;
						_tmp1314_ = this_symbol;
						_tmp1315_ = vala_symbol_get_parent_symbol (_tmp1314_);
						_tmp1316_ = _tmp1315_;
						_tmp1317_ = _vala_code_node_ref0 (_tmp1316_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1317_;
					}
					_tmp1313_ = FALSE;
					_tmp1318_ = this_symbol;
					if (!(_tmp1318_ != NULL)) {
						break;
					}
					_tmp1319_ = this_symbol;
					_tmp1320_ = target_type;
					if (_tmp1319_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1320_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1321_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1321_) ? ((ValaClass*) _tmp1321_) : NULL;
					_tmp1323_ = cl;
					if (_tmp1323_ != NULL) {
						ValaClass* _tmp1324_;
						ValaTypeSymbol* _tmp1325_;
						_tmp1324_ = cl;
						_tmp1325_ = target_type;
						_tmp1322_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1324_, _tmp1325_);
					} else {
						_tmp1322_ = FALSE;
					}
					if (_tmp1322_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1326_;
			ValaSourceReference* _tmp1327_;
			ValaSymbol* _tmp1328_;
			gchar* _tmp1329_;
			gchar* _tmp1330_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = member;
			_tmp1329_ = vala_symbol_get_full_name (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			vala_report_error (_tmp1327_, "Access to protected member `%s' denied", _tmp1330_);
			_g_free0 (_tmp1330_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1331_;
			ValaSymbol* _tmp1332_;
			ValaSymbol* _tmp1333_;
			gboolean in_target_type = FALSE;
			_tmp1331_ = member;
			_tmp1332_ = vala_symbol_get_parent_symbol (_tmp1331_);
			_tmp1333_ = _tmp1332_;
			target_type = _tmp1333_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1334_;
				ValaSemanticAnalyzer* _tmp1335_;
				ValaSymbol* _tmp1336_;
				ValaSymbol* _tmp1337_;
				ValaSymbol* _tmp1338_;
				_tmp1334_ = vala_code_context_get_analyzer (context);
				_tmp1335_ = _tmp1334_;
				_tmp1336_ = vala_semantic_analyzer_get_current_symbol (_tmp1335_);
				_tmp1337_ = _tmp1336_;
				_tmp1338_ = _vala_code_node_ref0 (_tmp1337_);
				this_symbol = _tmp1338_;
				{
					gboolean _tmp1339_ = FALSE;
					_tmp1339_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1344_;
						ValaSymbol* _tmp1345_;
						ValaSymbol* _tmp1346_;
						if (!_tmp1339_) {
							ValaSymbol* _tmp1340_;
							ValaSymbol* _tmp1341_;
							ValaSymbol* _tmp1342_;
							ValaSymbol* _tmp1343_;
							_tmp1340_ = this_symbol;
							_tmp1341_ = vala_symbol_get_parent_symbol (_tmp1340_);
							_tmp1342_ = _tmp1341_;
							_tmp1343_ = _vala_code_node_ref0 (_tmp1342_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1343_;
						}
						_tmp1339_ = FALSE;
						_tmp1344_ = this_symbol;
						if (!(_tmp1344_ != NULL)) {
							break;
						}
						_tmp1345_ = target_type;
						_tmp1346_ = this_symbol;
						if (_tmp1345_ == _tmp1346_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1347_;
				ValaSourceReference* _tmp1348_;
				ValaSymbol* _tmp1349_;
				gchar* _tmp1350_;
				gchar* _tmp1351_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1347_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1348_ = _tmp1347_;
				_tmp1349_ = member;
				_tmp1350_ = vala_symbol_get_full_name (_tmp1349_);
				_tmp1351_ = _tmp1350_;
				vala_report_error (_tmp1348_, "Access to private member `%s' denied", _tmp1351_);
				_g_free0 (_tmp1351_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1353_;
		ValaExpression* _tmp1354_;
		_tmp1353_ = vala_member_access_get_inner (self);
		_tmp1354_ = _tmp1353_;
		_tmp1352_ = _tmp1354_ != NULL;
	} else {
		_tmp1352_ = FALSE;
	}
	if (_tmp1352_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1355_;
		ValaExpression* _tmp1356_;
		ValaDataType* _tmp1357_;
		ValaDataType* _tmp1358_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1359_;
		ValaExpression* _tmp1360_;
		ValaDataType* _tmp1361_;
		ValaDataType* _tmp1362_;
		ValaPointerType* _tmp1363_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1367_;
		gboolean _tmp1368_ = FALSE;
		gboolean _tmp1369_ = FALSE;
		ValaObjectType* _tmp1370_;
		_tmp1355_ = vala_member_access_get_inner (self);
		_tmp1356_ = _tmp1355_;
		_tmp1357_ = vala_expression_get_value_type (_tmp1356_);
		_tmp1358_ = _tmp1357_;
		instance_type = _tmp1358_;
		_tmp1359_ = vala_member_access_get_inner (self);
		_tmp1360_ = _tmp1359_;
		_tmp1361_ = vala_expression_get_value_type (_tmp1360_);
		_tmp1362_ = _tmp1361_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1362_) ? ((ValaPointerType*) _tmp1362_) : NULL;
		_tmp1363_ = pointer_type;
		if (_tmp1363_ != NULL) {
			ValaPointerType* _tmp1364_;
			ValaDataType* _tmp1365_;
			ValaDataType* _tmp1366_;
			_tmp1364_ = pointer_type;
			_tmp1365_ = vala_pointer_type_get_base_type (_tmp1364_);
			_tmp1366_ = _tmp1365_;
			instance_type = _tmp1366_;
		}
		_tmp1367_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1367_) ? ((ValaObjectType*) _tmp1367_) : NULL;
		_tmp1370_ = object_type;
		if (_tmp1370_ != NULL) {
			ValaObjectType* _tmp1371_;
			ValaObjectTypeSymbol* _tmp1372_;
			ValaObjectTypeSymbol* _tmp1373_;
			_tmp1371_ = object_type;
			_tmp1372_ = vala_object_type_get_object_type_symbol (_tmp1371_);
			_tmp1373_ = _tmp1372_;
			_tmp1369_ = vala_object_type_symbol_has_type_parameters (_tmp1373_);
		} else {
			_tmp1369_ = FALSE;
		}
		if (_tmp1369_) {
			ValaDataType* _tmp1374_;
			_tmp1374_ = instance_type;
			_tmp1368_ = !vala_data_type_has_type_arguments (_tmp1374_);
		} else {
			_tmp1368_ = FALSE;
		}
		if (_tmp1368_) {
			ValaExpression* _tmp1375_;
			ValaExpression* _tmp1376_;
			ValaSourceReference* _tmp1377_;
			ValaSourceReference* _tmp1378_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1375_ = vala_member_access_get_inner (self);
			_tmp1376_ = _tmp1375_;
			_tmp1377_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1376_);
			_tmp1378_ = _tmp1377_;
			vala_report_error (_tmp1378_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1380_ = !may_access_instance_members;
	} else {
		_tmp1380_ = FALSE;
	}
	if (_tmp1380_) {
		_tmp1379_ = TRUE;
	} else {
		gboolean _tmp1381_ = FALSE;
		if (klass) {
			_tmp1381_ = !may_access_klass_members;
		} else {
			_tmp1381_ = FALSE;
		}
		_tmp1379_ = _tmp1381_;
	}
	if (_tmp1379_) {
		ValaSymbol* _tmp1382_;
		ValaSymbol* _tmp1383_;
		ValaDataType* _tmp1418_;
		ValaDataType* _tmp1419_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1382_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1383_ = _tmp1382_;
		if (VALA_IS_METHOD (_tmp1383_)) {
			ValaSemanticAnalyzer* _tmp1384_;
			ValaSemanticAnalyzer* _tmp1385_;
			ValaSymbol* _tmp1386_;
			ValaSymbol* _tmp1387_;
			gboolean _tmp1388_;
			gboolean _tmp1389_;
			ValaDataType* _tmp1390_;
			ValaDataType* _tmp1391_;
			ValaDataType* _tmp1392_;
			ValaDataType* _tmp1393_;
			ValaSourceReference* _tmp1394_;
			ValaSourceReference* _tmp1395_;
			_tmp1384_ = vala_code_context_get_analyzer (context);
			_tmp1385_ = _tmp1384_;
			_tmp1386_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1387_ = _tmp1386_;
			_tmp1388_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1385_, _tmp1387_, _tmp1389_);
			_tmp1391_ = _tmp1390_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1391_);
			_vala_code_node_unref0 (_tmp1391_);
			_tmp1392_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1395_ = _tmp1394_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1393_, _tmp1395_);
		} else {
			ValaSymbol* _tmp1396_;
			ValaSymbol* _tmp1397_;
			_tmp1396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1397_ = _tmp1396_;
			if (VALA_IS_FIELD (_tmp1397_)) {
				ValaSymbol* _tmp1398_;
				ValaSymbol* _tmp1399_;
				ValaFieldPrototype* _tmp1400_;
				ValaFieldPrototype* _tmp1401_;
				ValaDataType* _tmp1402_;
				ValaDataType* _tmp1403_;
				ValaSourceReference* _tmp1404_;
				ValaSourceReference* _tmp1405_;
				_tmp1398_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1399_, VALA_TYPE_FIELD, ValaField));
				_tmp1401_ = _tmp1400_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1401_);
				_vala_code_node_unref0 (_tmp1401_);
				_tmp1402_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1405_ = _tmp1404_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1403_, _tmp1405_);
			} else {
				ValaSymbol* _tmp1406_;
				ValaSymbol* _tmp1407_;
				_tmp1406_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1407_ = _tmp1406_;
				if (VALA_IS_PROPERTY (_tmp1407_)) {
					ValaSymbol* _tmp1408_;
					ValaSymbol* _tmp1409_;
					ValaPropertyPrototype* _tmp1410_;
					ValaPropertyPrototype* _tmp1411_;
					ValaDataType* _tmp1412_;
					ValaDataType* _tmp1413_;
					ValaSourceReference* _tmp1414_;
					ValaSourceReference* _tmp1415_;
					_tmp1408_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1409_ = _tmp1408_;
					_tmp1410_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1409_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1411_ = _tmp1410_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1411_);
					_vala_code_node_unref0 (_tmp1411_);
					_tmp1412_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1413_ = _tmp1412_;
					_tmp1414_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1415_ = _tmp1414_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1413_, _tmp1415_);
				} else {
					ValaInvalidType* _tmp1416_;
					ValaInvalidType* _tmp1417_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1416_ = vala_invalid_type_new ();
					_tmp1417_ = _tmp1416_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1417_);
					_vala_code_node_unref0 (_tmp1417_);
				}
			}
		}
		_tmp1418_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1419_ = _tmp1418_;
		if (_tmp1419_ != NULL) {
			ValaDataType* _tmp1420_;
			ValaDataType* _tmp1421_;
			ValaDataType* _tmp1422_;
			ValaDataType* _tmp1423_;
			gboolean _tmp1424_;
			gboolean _tmp1425_;
			_tmp1420_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1423_ = _tmp1422_;
			_tmp1424_ = vala_data_type_get_value_owned (_tmp1423_);
			_tmp1425_ = _tmp1424_;
			vala_data_type_set_value_owned (_tmp1421_, _tmp1425_);
		}
	} else {
		gboolean _tmp1426_ = FALSE;
		gboolean _tmp1447_ = FALSE;
		gboolean _tmp1448_ = FALSE;
		gboolean _tmp1449_ = FALSE;
		gboolean _tmp1450_ = FALSE;
		gboolean _tmp1491_ = FALSE;
		gboolean _tmp1492_ = FALSE;
		gboolean _tmp1493_ = FALSE;
		gboolean _tmp1494_ = FALSE;
		gboolean _tmp1495_ = FALSE;
		gboolean _tmp1496_;
		gboolean _tmp1497_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1522_;
		ValaSymbol* _tmp1523_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1524_;
		ValaExpression* _tmp1525_;
		gboolean _tmp1526_ = FALSE;
		gboolean _tmp1527_ = FALSE;
		gboolean _tmp1528_ = FALSE;
		gboolean _tmp1529_ = FALSE;
		gboolean _tmp1530_ = FALSE;
		ValaMethod* _tmp1531_;
		ValaSemanticAnalyzer* _tmp1575_;
		ValaSemanticAnalyzer* _tmp1576_;
		ValaSymbol* _tmp1577_;
		ValaSymbol* _tmp1578_;
		gboolean _tmp1579_;
		gboolean _tmp1580_;
		ValaDataType* _tmp1581_;
		ValaDataType* _tmp1582_;
		gboolean _tmp1583_ = FALSE;
		ValaExpression* _tmp1584_;
		ValaExpression* _tmp1585_;
		ValaSymbol* _tmp1598_;
		ValaSymbol* _tmp1599_;
		gboolean _tmp1673_ = FALSE;
		gboolean _tmp1674_ = FALSE;
		ValaExpression* _tmp1675_;
		ValaExpression* _tmp1676_;
		if (instance) {
			ValaExpression* _tmp1427_;
			ValaExpression* _tmp1428_;
			_tmp1427_ = vala_member_access_get_inner (self);
			_tmp1428_ = _tmp1427_;
			_tmp1426_ = _tmp1428_ == NULL;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaSourceReference* _tmp1429_;
			ValaSourceReference* _tmp1430_;
			ValaMemberAccess* _tmp1431_;
			ValaMemberAccess* _tmp1432_;
			ValaExpression* _tmp1433_;
			ValaExpression* _tmp1434_;
			ValaParameter* _tmp1435_;
			ValaDataType* _tmp1436_;
			ValaDataType* _tmp1437_;
			ValaDataType* _tmp1438_;
			ValaDataType* _tmp1439_;
			ValaExpression* _tmp1440_;
			ValaExpression* _tmp1441_;
			ValaDataType* _tmp1442_;
			ValaDataType* _tmp1443_;
			ValaExpression* _tmp1444_;
			ValaExpression* _tmp1445_;
			ValaParameter* _tmp1446_;
			_tmp1429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1430_ = _tmp1429_;
			_tmp1431_ = vala_member_access_new (NULL, "this", _tmp1430_);
			_tmp1432_ = _tmp1431_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1432_);
			_vala_code_node_unref0 (_tmp1432_);
			_tmp1433_ = vala_member_access_get_inner (self);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = this_parameter;
			_tmp1436_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1435_);
			_tmp1437_ = _tmp1436_;
			_tmp1438_ = vala_data_type_copy (_tmp1437_);
			_tmp1439_ = _tmp1438_;
			vala_expression_set_value_type (_tmp1434_, _tmp1439_);
			_vala_code_node_unref0 (_tmp1439_);
			_tmp1440_ = vala_member_access_get_inner (self);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = vala_expression_get_value_type (_tmp1441_);
			_tmp1443_ = _tmp1442_;
			vala_data_type_set_value_owned (_tmp1443_, FALSE);
			_tmp1444_ = vala_member_access_get_inner (self);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1445_, (ValaSymbol*) _tmp1446_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1450_ = !klass;
		} else {
			_tmp1450_ = FALSE;
		}
		if (_tmp1450_) {
			ValaSymbol* _tmp1451_;
			ValaSymbol* _tmp1452_;
			_tmp1451_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1452_ = _tmp1451_;
			_tmp1449_ = !VALA_IS_CREATION_METHOD (_tmp1452_);
		} else {
			_tmp1449_ = FALSE;
		}
		if (_tmp1449_) {
			_tmp1448_ = may_access_instance_members;
		} else {
			_tmp1448_ = FALSE;
		}
		if (_tmp1448_) {
			ValaExpression* _tmp1453_;
			ValaExpression* _tmp1454_;
			_tmp1453_ = vala_member_access_get_inner (self);
			_tmp1454_ = _tmp1453_;
			_tmp1447_ = _tmp1454_ != NULL;
		} else {
			_tmp1447_ = FALSE;
		}
		if (_tmp1447_) {
			ValaExpression* _tmp1455_;
			ValaExpression* _tmp1456_;
			ValaSymbol* _tmp1457_;
			ValaSymbol* _tmp1458_;
			_tmp1455_ = vala_member_access_get_inner (self);
			_tmp1456_ = _tmp1455_;
			_tmp1457_ = vala_expression_get_symbol_reference (_tmp1456_);
			_tmp1458_ = _tmp1457_;
			if (VALA_IS_METHOD (_tmp1458_)) {
			} else {
				ValaSourceReference* _tmp1459_;
				ValaSourceReference* _tmp1460_;
				ValaSymbol* _tmp1461_;
				ValaSymbol* _tmp1462_;
				gchar* _tmp1463_;
				gchar* _tmp1464_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1465_;
				ValaSymbol* _tmp1466_;
				ValaSymbol* _tmp1467_;
				ValaSymbol* _tmp1468_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1488_;
				ValaExpression* _tmp1489_;
				ValaExpression* _tmp1490_;
				_tmp1459_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1460_ = _tmp1459_;
				_tmp1461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1462_ = _tmp1461_;
				_tmp1463_ = vala_symbol_get_full_name (_tmp1462_);
				_tmp1464_ = _tmp1463_;
				vala_report_warning (_tmp1460_, "Access to static member `%s' with an instance reference", _tmp1464_);
				_g_free0 (_tmp1464_);
				_tmp1465_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1466_ = _tmp1465_;
				_tmp1467_ = vala_symbol_get_parent_symbol (_tmp1466_);
				_tmp1468_ = _tmp1467_;
				inner_sym = _tmp1468_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1469_ = FALSE;
					ValaSymbol* _tmp1470_;
					ValaMemberAccess* _tmp1474_;
					ValaSymbol* _tmp1475_;
					const gchar* _tmp1476_;
					const gchar* _tmp1477_;
					ValaSourceReference* _tmp1478_;
					ValaSourceReference* _tmp1479_;
					ValaMemberAccess* _tmp1480_;
					ValaMemberAccess* _tmp1481_;
					ValaMemberAccess* _tmp1482_;
					ValaExpression* _tmp1483_;
					ValaExpression* _tmp1484_;
					ValaSymbol* _tmp1485_;
					ValaSymbol* _tmp1486_;
					ValaSymbol* _tmp1487_;
					_tmp1470_ = inner_sym;
					if (_tmp1470_ != NULL) {
						ValaSymbol* _tmp1471_;
						const gchar* _tmp1472_;
						const gchar* _tmp1473_;
						_tmp1471_ = inner_sym;
						_tmp1472_ = vala_symbol_get_name (_tmp1471_);
						_tmp1473_ = _tmp1472_;
						_tmp1469_ = _tmp1473_ != NULL;
					} else {
						_tmp1469_ = FALSE;
					}
					if (!_tmp1469_) {
						break;
					}
					_tmp1474_ = inner_ma;
					_tmp1475_ = inner_sym;
					_tmp1476_ = vala_symbol_get_name (_tmp1475_);
					_tmp1477_ = _tmp1476_;
					_tmp1478_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1479_ = _tmp1478_;
					_tmp1480_ = vala_member_access_new (NULL, _tmp1477_, _tmp1479_);
					_tmp1481_ = _tmp1480_;
					vala_member_access_set_inner (_tmp1474_, (ValaExpression*) _tmp1481_);
					_vala_code_node_unref0 (_tmp1481_);
					_tmp1482_ = inner_ma;
					_tmp1483_ = vala_member_access_get_inner (_tmp1482_);
					_tmp1484_ = _tmp1483_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1484_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1485_ = inner_sym;
					_tmp1486_ = vala_symbol_get_parent_symbol (_tmp1485_);
					_tmp1487_ = _tmp1486_;
					inner_sym = _tmp1487_;
				}
				_tmp1488_ = inner_ma;
				vala_member_access_set_qualified (_tmp1488_, TRUE);
				_tmp1489_ = vala_member_access_get_inner (self);
				_tmp1490_ = _tmp1489_;
				vala_code_node_check ((ValaCodeNode*) _tmp1490_, context);
			}
		}
		_tmp1496_ = vala_code_context_get_experimental_non_null (context);
		_tmp1497_ = _tmp1496_;
		if (_tmp1497_) {
			_tmp1495_ = instance;
		} else {
			_tmp1495_ = FALSE;
		}
		if (_tmp1495_) {
			ValaExpression* _tmp1498_;
			ValaExpression* _tmp1499_;
			ValaDataType* _tmp1500_;
			ValaDataType* _tmp1501_;
			gboolean _tmp1502_;
			gboolean _tmp1503_;
			_tmp1498_ = vala_member_access_get_inner (self);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = vala_expression_get_value_type (_tmp1499_);
			_tmp1501_ = _tmp1500_;
			_tmp1502_ = vala_data_type_get_nullable (_tmp1501_);
			_tmp1503_ = _tmp1502_;
			_tmp1494_ = _tmp1503_;
		} else {
			_tmp1494_ = FALSE;
		}
		if (_tmp1494_) {
			ValaExpression* _tmp1504_;
			ValaExpression* _tmp1505_;
			ValaDataType* _tmp1506_;
			ValaDataType* _tmp1507_;
			_tmp1504_ = vala_member_access_get_inner (self);
			_tmp1505_ = _tmp1504_;
			_tmp1506_ = vala_expression_get_value_type (_tmp1505_);
			_tmp1507_ = _tmp1506_;
			_tmp1493_ = !VALA_IS_POINTER_TYPE (_tmp1507_);
		} else {
			_tmp1493_ = FALSE;
		}
		if (_tmp1493_) {
			ValaExpression* _tmp1508_;
			ValaExpression* _tmp1509_;
			ValaDataType* _tmp1510_;
			ValaDataType* _tmp1511_;
			_tmp1508_ = vala_member_access_get_inner (self);
			_tmp1509_ = _tmp1508_;
			_tmp1510_ = vala_expression_get_value_type (_tmp1509_);
			_tmp1511_ = _tmp1510_;
			_tmp1492_ = !VALA_IS_GENERIC_TYPE (_tmp1511_);
		} else {
			_tmp1492_ = FALSE;
		}
		if (_tmp1492_) {
			ValaExpression* _tmp1512_;
			ValaExpression* _tmp1513_;
			ValaDataType* _tmp1514_;
			ValaDataType* _tmp1515_;
			_tmp1512_ = vala_member_access_get_inner (self);
			_tmp1513_ = _tmp1512_;
			_tmp1514_ = vala_expression_get_value_type (_tmp1513_);
			_tmp1515_ = _tmp1514_;
			_tmp1491_ = !VALA_IS_ARRAY_TYPE (_tmp1515_);
		} else {
			_tmp1491_ = FALSE;
		}
		if (_tmp1491_) {
			ValaSourceReference* _tmp1516_;
			ValaSourceReference* _tmp1517_;
			ValaSymbol* _tmp1518_;
			ValaSymbol* _tmp1519_;
			gchar* _tmp1520_;
			gchar* _tmp1521_;
			_tmp1516_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1517_ = _tmp1516_;
			_tmp1518_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1519_ = _tmp1518_;
			_tmp1520_ = vala_symbol_get_full_name (_tmp1519_);
			_tmp1521_ = _tmp1520_;
			vala_report_error (_tmp1517_, "Access to instance member `%s' from nullable reference denied", _tmp1521_);
			_g_free0 (_tmp1521_);
		}
		_tmp1522_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1523_ = _tmp1522_;
		m = VALA_IS_METHOD (_tmp1523_) ? ((ValaMethod*) _tmp1523_) : NULL;
		_tmp1524_ = vala_member_access_get_inner (self);
		_tmp1525_ = _tmp1524_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1525_) ? ((ValaMemberAccess*) _tmp1525_) : NULL;
		_tmp1531_ = m;
		if (_tmp1531_ != NULL) {
			ValaMethod* _tmp1532_;
			ValaMemberBinding _tmp1533_;
			ValaMemberBinding _tmp1534_;
			_tmp1532_ = m;
			_tmp1533_ = vala_method_get_binding (_tmp1532_);
			_tmp1534_ = _tmp1533_;
			_tmp1530_ = _tmp1534_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1530_ = FALSE;
		}
		if (_tmp1530_) {
			ValaMethod* _tmp1535_;
			ValaSymbol* _tmp1536_;
			ValaSymbol* _tmp1537_;
			_tmp1535_ = m;
			_tmp1536_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1535_);
			_tmp1537_ = _tmp1536_;
			_tmp1529_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1537_);
		} else {
			_tmp1529_ = FALSE;
		}
		if (_tmp1529_) {
			ValaExpression* _tmp1538_;
			ValaExpression* _tmp1539_;
			_tmp1538_ = vala_member_access_get_inner (self);
			_tmp1539_ = _tmp1538_;
			_tmp1528_ = _tmp1539_ != NULL;
		} else {
			_tmp1528_ = FALSE;
		}
		if (_tmp1528_) {
			ValaExpression* _tmp1540_;
			ValaExpression* _tmp1541_;
			ValaDataType* _tmp1542_;
			ValaDataType* _tmp1543_;
			_tmp1540_ = vala_member_access_get_inner (self);
			_tmp1541_ = _tmp1540_;
			_tmp1542_ = vala_expression_get_value_type (_tmp1541_);
			_tmp1543_ = _tmp1542_;
			_tmp1527_ = _tmp1543_ == NULL;
		} else {
			_tmp1527_ = FALSE;
		}
		if (_tmp1527_) {
			ValaMemberAccess* _tmp1544_;
			ValaList* _tmp1545_;
			gint _tmp1546_;
			gint _tmp1547_;
			_tmp1544_ = inner_ma;
			_tmp1545_ = _tmp1544_->priv->type_argument_list;
			_tmp1546_ = vala_collection_get_size ((ValaCollection*) _tmp1545_);
			_tmp1547_ = _tmp1546_;
			_tmp1526_ = _tmp1547_ > 0;
		} else {
			_tmp1526_ = FALSE;
		}
		if (_tmp1526_) {
			ValaExpression* _tmp1548_;
			ValaExpression* _tmp1549_;
			ValaMethod* _tmp1550_;
			ValaSymbol* _tmp1551_;
			ValaSymbol* _tmp1552_;
			ValaObjectType* _tmp1553_;
			ValaObjectType* _tmp1554_;
			ValaExpression* _tmp1555_;
			ValaExpression* _tmp1556_;
			ValaDataType* _tmp1557_;
			ValaDataType* _tmp1558_;
			ValaSourceReference* _tmp1559_;
			ValaSourceReference* _tmp1560_;
			_tmp1548_ = vala_member_access_get_inner (self);
			_tmp1549_ = _tmp1548_;
			_tmp1550_ = m;
			_tmp1551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1550_);
			_tmp1552_ = _tmp1551_;
			_tmp1553_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1552_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1554_ = _tmp1553_;
			vala_expression_set_value_type (_tmp1549_, (ValaDataType*) _tmp1554_);
			_vala_code_node_unref0 (_tmp1554_);
			_tmp1555_ = vala_member_access_get_inner (self);
			_tmp1556_ = _tmp1555_;
			_tmp1557_ = vala_expression_get_value_type (_tmp1556_);
			_tmp1558_ = _tmp1557_;
			_tmp1559_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1560_ = _tmp1559_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1558_, _tmp1560_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1561_;
				ValaList* _tmp1562_;
				gint _type_argument_size = 0;
				ValaList* _tmp1563_;
				gint _tmp1564_;
				gint _tmp1565_;
				gint _type_argument_index = 0;
				_tmp1561_ = inner_ma;
				_tmp1562_ = _tmp1561_->priv->type_argument_list;
				_type_argument_list = _tmp1562_;
				_tmp1563_ = _type_argument_list;
				_tmp1564_ = vala_collection_get_size ((ValaCollection*) _tmp1563_);
				_tmp1565_ = _tmp1564_;
				_type_argument_size = _tmp1565_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1566_;
					gint _tmp1567_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1568_;
					gpointer _tmp1569_;
					ValaExpression* _tmp1570_;
					ValaExpression* _tmp1571_;
					ValaDataType* _tmp1572_;
					ValaDataType* _tmp1573_;
					ValaDataType* _tmp1574_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1566_ = _type_argument_index;
					_tmp1567_ = _type_argument_size;
					if (!(_tmp1566_ < _tmp1567_)) {
						break;
					}
					_tmp1568_ = _type_argument_list;
					_tmp1569_ = vala_list_get (_tmp1568_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1569_;
					_tmp1570_ = vala_member_access_get_inner (self);
					_tmp1571_ = _tmp1570_;
					_tmp1572_ = vala_expression_get_value_type (_tmp1571_);
					_tmp1573_ = _tmp1572_;
					_tmp1574_ = type_argument;
					vala_data_type_add_type_argument (_tmp1573_, _tmp1574_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1575_ = vala_code_context_get_analyzer (context);
		_tmp1576_ = _tmp1575_;
		_tmp1577_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1578_ = _tmp1577_;
		_tmp1579_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1580_ = _tmp1579_;
		_tmp1581_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1576_, _tmp1578_, _tmp1580_);
		_tmp1582_ = _tmp1581_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1582_);
		_vala_code_node_unref0 (_tmp1582_);
		_tmp1584_ = vala_member_access_get_inner (self);
		_tmp1585_ = _tmp1584_;
		if (_tmp1585_ != NULL) {
			ValaDataType* _tmp1586_;
			ValaDataType* _tmp1587_;
			_tmp1586_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1587_ = _tmp1586_;
			_tmp1583_ = _tmp1587_ != NULL;
		} else {
			_tmp1583_ = FALSE;
		}
		if (_tmp1583_) {
			ValaDataType* _tmp1588_;
			ValaDataType* _tmp1589_;
			ValaExpression* _tmp1590_;
			ValaExpression* _tmp1591_;
			ValaDataType* _tmp1592_;
			ValaDataType* _tmp1593_;
			ValaDataType* _tmp1594_;
			ValaDataType* _tmp1595_;
			_tmp1588_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1589_ = _tmp1588_;
			_tmp1590_ = vala_member_access_get_inner (self);
			_tmp1591_ = _tmp1590_;
			_tmp1592_ = vala_expression_get_value_type (_tmp1591_);
			_tmp1593_ = _tmp1592_;
			_tmp1594_ = vala_data_type_get_actual_type (_tmp1589_, _tmp1593_, NULL, (ValaCodeNode*) self);
			_tmp1595_ = _tmp1594_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1595_);
			_vala_code_node_unref0 (_tmp1595_);
		} else {
			ValaDataType* _tmp1596_;
			ValaDataType* _tmp1597_;
			_tmp1596_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1597_ = _tmp1596_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1597_);
		}
		_tmp1598_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1599_ = _tmp1598_;
		if (VALA_IS_METHOD (_tmp1599_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1600_;
			ValaSymbol* _tmp1601_;
			ValaDataType* _tmp1602_;
			ValaDataType* _tmp1603_;
			gboolean _tmp1610_ = FALSE;
			_tmp1600_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1601_ = _tmp1600_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1601_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1602_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1603_ = _tmp1602_;
			if (_tmp1603_ != NULL) {
				ValaDataType* _tmp1604_;
				ValaDataType* _tmp1605_;
				ValaDataType* _tmp1606_;
				ValaDataType* _tmp1607_;
				gboolean _tmp1608_;
				gboolean _tmp1609_;
				_tmp1604_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1605_ = _tmp1604_;
				_tmp1606_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1607_ = _tmp1606_;
				_tmp1608_ = vala_data_type_get_value_owned (_tmp1607_);
				_tmp1609_ = _tmp1608_;
				vala_data_type_set_value_owned (_tmp1605_, _tmp1609_);
			}
			if (instance) {
				ValaMethod* _tmp1611_;
				ValaSymbol* _tmp1612_;
				ValaSymbol* _tmp1613_;
				_tmp1611_ = method;
				_tmp1612_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1611_);
				_tmp1613_ = _tmp1612_;
				_tmp1610_ = VALA_IS_TYPESYMBOL (_tmp1613_);
			} else {
				_tmp1610_ = FALSE;
			}
			if (_tmp1610_) {
				ValaExpression* _tmp1614_;
				ValaExpression* _tmp1615_;
				ValaMethod* _tmp1616_;
				ValaSymbol* _tmp1617_;
				ValaSymbol* _tmp1618_;
				ValaDataType* _tmp1619_;
				ValaDataType* _tmp1620_;
				ValaExpression* _tmp1621_;
				ValaExpression* _tmp1622_;
				ValaDataType* _tmp1623_;
				ValaDataType* _tmp1624_;
				ValaMethod* _tmp1625_;
				ValaParameter* _tmp1626_;
				ValaParameter* _tmp1627_;
				ValaDataType* _tmp1628_;
				ValaDataType* _tmp1629_;
				gboolean _tmp1630_;
				gboolean _tmp1631_;
				_tmp1614_ = vala_member_access_get_inner (self);
				_tmp1615_ = _tmp1614_;
				_tmp1616_ = method;
				_tmp1617_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1616_);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1618_);
				_tmp1620_ = _tmp1619_;
				vala_expression_set_target_type (_tmp1615_, _tmp1620_);
				_vala_code_node_unref0 (_tmp1620_);
				_tmp1621_ = vala_member_access_get_inner (self);
				_tmp1622_ = _tmp1621_;
				_tmp1623_ = vala_expression_get_target_type (_tmp1622_);
				_tmp1624_ = _tmp1623_;
				_tmp1625_ = method;
				_tmp1626_ = vala_method_get_this_parameter (_tmp1625_);
				_tmp1627_ = _tmp1626_;
				_tmp1628_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1627_);
				_tmp1629_ = _tmp1628_;
				_tmp1630_ = vala_data_type_get_value_owned (_tmp1629_);
				_tmp1631_ = _tmp1630_;
				vala_data_type_set_value_owned (_tmp1624_, _tmp1631_);
			}
		} else {
			gboolean _tmp1632_ = FALSE;
			gboolean _tmp1633_ = FALSE;
			ValaSymbol* _tmp1634_;
			ValaSymbol* _tmp1635_;
			_tmp1634_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1635_ = _tmp1634_;
			if (VALA_IS_PROPERTY (_tmp1635_)) {
				_tmp1633_ = instance;
			} else {
				_tmp1633_ = FALSE;
			}
			if (_tmp1633_) {
				ValaSymbol* _tmp1636_;
				ValaSymbol* _tmp1637_;
				ValaSymbol* _tmp1638_;
				ValaSymbol* _tmp1639_;
				_tmp1636_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1637_ = _tmp1636_;
				_tmp1638_ = vala_symbol_get_parent_symbol (_tmp1637_);
				_tmp1639_ = _tmp1638_;
				_tmp1632_ = _tmp1639_ != NULL;
			} else {
				_tmp1632_ = FALSE;
			}
			if (_tmp1632_) {
				ValaExpression* _tmp1640_;
				ValaExpression* _tmp1641_;
				ValaSymbol* _tmp1642_;
				ValaSymbol* _tmp1643_;
				ValaSymbol* _tmp1644_;
				ValaSymbol* _tmp1645_;
				ValaDataType* _tmp1646_;
				ValaDataType* _tmp1647_;
				_tmp1640_ = vala_member_access_get_inner (self);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1643_ = _tmp1642_;
				_tmp1644_ = vala_symbol_get_parent_symbol (_tmp1643_);
				_tmp1645_ = _tmp1644_;
				_tmp1646_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1645_);
				_tmp1647_ = _tmp1646_;
				vala_expression_set_target_type (_tmp1641_, _tmp1647_);
				_vala_code_node_unref0 (_tmp1647_);
			} else {
				gboolean _tmp1648_ = FALSE;
				gboolean _tmp1649_ = FALSE;
				gboolean _tmp1650_ = FALSE;
				ValaSymbol* _tmp1651_;
				ValaSymbol* _tmp1652_;
				_tmp1651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1652_ = _tmp1651_;
				if (VALA_IS_FIELD (_tmp1652_)) {
					_tmp1650_ = TRUE;
				} else {
					ValaSymbol* _tmp1653_;
					ValaSymbol* _tmp1654_;
					_tmp1653_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1654_ = _tmp1653_;
					_tmp1650_ = VALA_IS_SIGNAL (_tmp1654_);
				}
				if (_tmp1650_) {
					_tmp1649_ = instance;
				} else {
					_tmp1649_ = FALSE;
				}
				if (_tmp1649_) {
					ValaSymbol* _tmp1655_;
					ValaSymbol* _tmp1656_;
					ValaSymbol* _tmp1657_;
					ValaSymbol* _tmp1658_;
					_tmp1655_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1656_ = _tmp1655_;
					_tmp1657_ = vala_symbol_get_parent_symbol (_tmp1656_);
					_tmp1658_ = _tmp1657_;
					_tmp1648_ = _tmp1658_ != NULL;
				} else {
					_tmp1648_ = FALSE;
				}
				if (_tmp1648_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1659_;
					ValaSymbol* _tmp1660_;
					ValaSymbol* _tmp1661_;
					ValaSymbol* _tmp1662_;
					ValaDataType* _tmp1663_;
					ValaExpression* _tmp1664_;
					ValaExpression* _tmp1665_;
					ValaDataType* _tmp1666_;
					ValaExpression* _tmp1667_;
					ValaExpression* _tmp1668_;
					ValaDataType* _tmp1669_;
					ValaDataType* _tmp1670_;
					ValaDataType* _tmp1671_;
					ValaDataType* _tmp1672_;
					_tmp1659_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1660_ = _tmp1659_;
					_tmp1661_ = vala_symbol_get_parent_symbol (_tmp1660_);
					_tmp1662_ = _tmp1661_;
					_tmp1663_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1662_);
					parent_type = _tmp1663_;
					_tmp1664_ = vala_member_access_get_inner (self);
					_tmp1665_ = _tmp1664_;
					_tmp1666_ = parent_type;
					_tmp1667_ = vala_member_access_get_inner (self);
					_tmp1668_ = _tmp1667_;
					_tmp1669_ = vala_expression_get_value_type (_tmp1668_);
					_tmp1670_ = _tmp1669_;
					_tmp1671_ = vala_data_type_get_actual_type (_tmp1666_, _tmp1670_, NULL, (ValaCodeNode*) self);
					_tmp1672_ = _tmp1671_;
					vala_expression_set_target_type (_tmp1665_, _tmp1672_);
					_vala_code_node_unref0 (_tmp1672_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1675_ = vala_member_access_get_inner (self);
		_tmp1676_ = _tmp1675_;
		if (_tmp1676_ == NULL) {
			ValaDataType* _tmp1677_;
			ValaDataType* _tmp1678_;
			_tmp1677_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1678_ = _tmp1677_;
			_tmp1674_ = _tmp1678_ != NULL;
		} else {
			_tmp1674_ = FALSE;
		}
		if (_tmp1674_) {
			ValaProfile _tmp1679_;
			ValaProfile _tmp1680_;
			_tmp1679_ = vala_code_context_get_profile (context);
			_tmp1680_ = _tmp1679_;
			_tmp1673_ = _tmp1680_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1673_ = FALSE;
		}
		if (_tmp1673_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1681_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1682_ = _tmp1681_;
	if (_tmp1682_ != NULL) {
		ValaDataType* _tmp1683_;
		ValaDataType* _tmp1684_;
		_tmp1683_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1684_ = _tmp1683_;
		vala_code_node_check ((ValaCodeNode*) _tmp1684_, context);
	}
	_tmp1685_ = self->priv->_tainted_access;
	if (!_tmp1685_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1686_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1687_ = _tmp1686_;
	result = !_tmp1687_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp93_ = _tmp98_ != NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaClass* _tmp105_;
		_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_METHOD, ValaMethod));
		_tmp102_ = _tmp101_;
		cl = VALA_IS_CLASS (_tmp102_) ? ((ValaClass*) _tmp102_) : NULL;
		_tmp105_ = cl;
		if (_tmp105_ != NULL) {
			ValaClass* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_is_compact (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp104_ = _tmp108_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaMemberAccess* _tmp109_;
			_tmp109_ = ma;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp110_;
			ValaMemberAccess* _tmp111_;
			_tmp110_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp110_, TRUE);
			_tmp111_ = ma;
			vala_member_access_check_lvalue_access (_tmp111_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

