/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_SYMBOL_MANAGER_H_
#define _IANJUTA_SYMBOL_MANAGER_H_

#include <glib-object.h>
#include <libanjuta/anjuta-async-notify.h>
#include <libanjuta/interfaces/ianjuta-iterable.h>
#include <libanjuta/interfaces/ianjuta-symbol.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_SYMBOL_MANAGER (ianjuta_symbol_manager_get_type ())
#define IANJUTA_SYMBOL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_SYMBOL_MANAGER, IAnjutaSymbolManager))
#define IANJUTA_IS_SYMBOL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_SYMBOL_MANAGER))
#define IANJUTA_SYMBOL_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_SYMBOL_MANAGER, IAnjutaSymbolManagerIface))

#define IANJUTA_TYPE_SYMBOL_MANAGER_SEARCH_FILESCOPE (ianjuta_symbol_manager_search_filescope_get_type())

#define IANJUTA_SYMBOL_MANAGER_ERROR ianjuta_symbol_manager_error_quark()

typedef struct _IAnjutaSymbolManager IAnjutaSymbolManager;
typedef struct _IAnjutaSymbolManagerIface IAnjutaSymbolManagerIface;

/** 
 * IAnjutaSymbolManagerSearchFileScope: 
 	 * You cannot use bitwise OR in this parameter.	 
 *
 * @IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE: to be ignored (e.g. Will search both private and public scopes). 
 * @IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC: only global public function will be searched 
 	 * (the ones that _do not_ belong to the file scope). 
 * @IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE: only private or static (for C language) will be searched 
     * (the ones that _do_ belong to the file scope). 
 */	
typedef enum {
	IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE = -1,
	IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC = 1,
	IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE = 0
} IAnjutaSymbolManagerSearchFileScope;

typedef void (*IAnjutaSymbolManagerSearchCallback) (guint search_id, IAnjutaIterable* result, gpointer user_data);


struct _IAnjutaSymbolManagerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*prj_scan_end) (IAnjutaSymbolManager *obj, gint process_id);
	/* Signal */
	void (*prj_symbol_inserted) (IAnjutaSymbolManager *obj, gint symbol_id);
	/* Signal */
	void (*prj_symbol_removed) (IAnjutaSymbolManager *obj, gint symbol_id);
	/* Signal */
	void (*prj_symbol_updated) (IAnjutaSymbolManager *obj, gint symbol_id);
	/* Signal */
	void (*sys_scan_end) (IAnjutaSymbolManager *obj, gint process_id);
	/* Signal */
	void (*sys_symbol_inserted) (IAnjutaSymbolManager *obj, gint symbol_id);
	/* Signal */
	void (*sys_symbol_removed) (IAnjutaSymbolManager *obj, gint symbol_id);
	/* Signal */
	void (*sys_symbol_updated) (IAnjutaSymbolManager *obj, gint symbol_id);

	IAnjutaIterable* (*get_class_parents) (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaIterable* (*get_members) (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaIterable* (*get_parent_scope) (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  const gchar *filename,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaIterable* (*get_scope) (IAnjutaSymbolManager *obj, const gchar* filename,  gulong line,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaSymbol* (*get_symbol_by_id) (IAnjutaSymbolManager *obj, gint symbol_id,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaIterable* (*get_symbol_more_info) (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);
	IAnjutaIterable* (*search) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *match_name,  gboolean partial_name_match,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gboolean global_tags_search,  gint results_limit,  gint results_offset, GError **err);
	IAnjutaIterable* (*search_file) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  const GFile *file,  gint results_limit,  gint results_offset, GError **err);
	guint (*search_file_async) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  const GFile *file,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);
	IAnjutaIterable* (*search_project) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset, GError **err);
	guint (*search_project_async) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);
	IAnjutaIterable* (*search_system) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset, GError **err);
	guint (*search_system_async) (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);

};

GType ianjuta_symbol_manager_search_filescope_get_type (void);

GQuark ianjuta_symbol_manager_error_quark     (void);
GType  ianjuta_symbol_manager_get_type        (void);

IAnjutaIterable* ianjuta_symbol_manager_get_class_parents (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_get_members (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_get_parent_scope (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  const gchar *filename,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_get_scope (IAnjutaSymbolManager *obj, const gchar* filename,  gulong line,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaSymbol* ianjuta_symbol_manager_get_symbol_by_id (IAnjutaSymbolManager *obj, gint symbol_id,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_get_symbol_more_info (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,  IAnjutaSymbolField info_fields, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_search (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *match_name,  gboolean partial_name_match,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gboolean global_tags_search,  gint results_limit,  gint results_offset, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_search_file (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  const GFile *file,  gint results_limit,  gint results_offset, GError **err);

guint ianjuta_symbol_manager_search_file_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  const GFile *file,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_search_project (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset, GError **err);

guint ianjuta_symbol_manager_search_project_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);

IAnjutaIterable* ianjuta_symbol_manager_search_system (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset, GError **err);

guint ianjuta_symbol_manager_search_system_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,  gboolean include_types,  IAnjutaSymbolField info_fields,  const gchar *pattern,  IAnjutaSymbolManagerSearchFileScope filescope_search,  gint results_limit,  gint results_offset,  GCancellable* cancel,  AnjutaAsyncNotify *notify,  IAnjutaSymbolManagerSearchCallback callback,  gpointer callback_user_data, GError **err);


G_END_DECLS

#endif
