/*
 *      SCCS:  @(#)  TestS.c Rel 1.1	    (11/28/91)
 *
 *	UniSoft Ltd., London, England
 *
 * (C) Copyright 1991 X/Open Company Limited
 *
 * All rights reserved.  No part of this source code may be reproduced,
 * stored in a retrieval system, or transmitted, in any form or by any
 * means, electronic, mechanical, photocopying, recording or otherwise,
 * except as stated in the end-user licence agreement, without the prior
 * permission of the copyright owners.
 *
 * X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
 * the UK and other countries.
 */

#include        <stdlib.h>
#include        "xtest.h"
#include        "Xlib.h"
#include        "Xutil.h"
#include        "Xresource.h"
#include        "tet_api.h"
#include        "xtestlib.h"
#include        "pixval.h"

extern char	*TestName;
extern Display	*Dsp;

int		minkc;
int		maxkc;
int		keysyms_per_keycode;

static int
test(symbol, str)
KeySym	symbol;
char	*str;
{
KeyCode	kycd;
int	mod;

	kycd = XKeysymToKeycode(Dsp, symbol);
	if(kycd == 0) {
		trace("XKeysymToKeycode() returned 0 for KeySym \"XK_%s\".", str);
		return(1);
	}

	if(kycd > maxkc || kycd < minkc) {
		report("XKeysymToKeycode() returned invalid keycode value %d for KeySym \"XK_%s\".", kycd, str);
		return(0);
	}

	for(mod = 0; mod < keysyms_per_keycode; mod++) {
		if( symbol == XKeycodeToKeysym(Dsp, kycd, mod))  {
			trace("KeySym \"XK_%s\", keycode %d, mod %d", 
								str, kycd, mod);
			return(1);
		}
	}

	report("The keycode value %d for KeySym \"XK_%s\"", kycd, str);
	report("never returns that KeySym when using XKeycodeToKeysym()");
	return(0);
}

static void
reporterr(s)
char	*s;
{
	report("Symbol XK_\"%s\" is not defined.", s);
}
#define XK_SPECIAL
#include	<X11/keysymdef.h>
#undef XK_SPECIAL

kysymtcdS()
{ 
int 	pass = 0, fail = 0;

	XDisplayKeycodes(Dsp, &minkc, &maxkc);
	XGetKeyboardMapping(Dsp, (KeyCode)minkc, 1, &keysyms_per_keycode);

#ifdef XK_blank
	if(test(XK_blank, "blank") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("blank");
	FAIL;
#endif

#ifdef XK_soliddiamond
	if(test(XK_soliddiamond, "soliddiamond") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("soliddiamond");
	FAIL;
#endif

#ifdef XK_checkerboard
	if(test(XK_checkerboard, "checkerboard") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("checkerboard");
	FAIL;
#endif

#ifdef XK_ht
	if(test(XK_ht, "ht") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("ht");
	FAIL;
#endif

#ifdef XK_ff
	if(test(XK_ff, "ff") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("ff");
	FAIL;
#endif

#ifdef XK_cr
	if(test(XK_cr, "cr") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("cr");
	FAIL;
#endif

#ifdef XK_lf
	if(test(XK_lf, "lf") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("lf");
	FAIL;
#endif

#ifdef XK_nl
	if(test(XK_nl, "nl") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("nl");
	FAIL;
#endif

#ifdef XK_vt
	if(test(XK_vt, "vt") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("vt");
	FAIL;
#endif

#ifdef XK_lowrightcorner
	if(test(XK_lowrightcorner, "lowrightcorner") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("lowrightcorner");
	FAIL;
#endif

#ifdef XK_uprightcorner
	if(test(XK_uprightcorner, "uprightcorner") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("uprightcorner");
	FAIL;
#endif

#ifdef XK_upleftcorner
	if(test(XK_upleftcorner, "upleftcorner") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("upleftcorner");
	FAIL;
#endif

#ifdef XK_lowleftcorner
	if(test(XK_lowleftcorner, "lowleftcorner") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("lowleftcorner");
	FAIL;
#endif

#ifdef XK_crossinglines
	if(test(XK_crossinglines, "crossinglines") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("crossinglines");
	FAIL;
#endif

#ifdef XK_horizlinescan1
	if(test(XK_horizlinescan1, "horizlinescan1") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("horizlinescan1");
	FAIL;
#endif

#ifdef XK_horizlinescan3
	if(test(XK_horizlinescan3, "horizlinescan3") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("horizlinescan3");
	FAIL;
#endif

#ifdef XK_horizlinescan5
	if(test(XK_horizlinescan5, "horizlinescan5") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("horizlinescan5");
	FAIL;
#endif

#ifdef XK_horizlinescan7
	if(test(XK_horizlinescan7, "horizlinescan7") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("horizlinescan7");
	FAIL;
#endif

#ifdef XK_horizlinescan9
	if(test(XK_horizlinescan9, "horizlinescan9") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("horizlinescan9");
	FAIL;
#endif

#ifdef XK_leftt
	if(test(XK_leftt, "leftt") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("leftt");
	FAIL;
#endif

#ifdef XK_rightt
	if(test(XK_rightt, "rightt") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("rightt");
	FAIL;
#endif

#ifdef XK_bott
	if(test(XK_bott, "bott") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("bott");
	FAIL;
#endif

#ifdef XK_topt
	if(test(XK_topt, "topt") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("topt");
	FAIL;
#endif

#ifdef XK_vertbar
	if(test(XK_vertbar, "vertbar") == 1)
		CHECK;
	else
		FAIL;
#else
	reporterr("vertbar");
	FAIL;
#endif

	CHECKPASS(24);
}
