beginc $Id: c1.sgml,v 1.11 2000/08/15 01:52:50 jashley Exp $ endc

iybeginchapter(intro, xreflabel="1")
tagdocinfo([[$Id: c1.sgml,v 1.11 2000/08/15 01:52:50 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Getting Started
,
Ϥ褦
)]])

beginpara
iydraft([[dnl
tagGnupg is a tool for secure communication.
This chapter is a quick-start guide that covers the core functionality
of taggnupg.
This includes keypair creation, exchanging and verifying keys, encrypting
and decrypting documents, and authenticating documents with digital
signatures.
It does not explain in detail the concepts behind public-key cryptography,
encryption, and digital signatures.
This is covered in Chapter tagxref(concepts).
It also does not explain how to use taggnupg wisely.
This is covered in Chapters tagxref(management) and 
tagxref(wise).
]],[[dnl
tagGnupgϡ̿ΤΥġǤ
ξϤϡ
taggnupgδܵǽ򤢤Ĥåȡɤǡ
ˤϸФκ
θ򴹤両ڡ
ʸΰŹ沽桢
Żҽ̾Ȥäʸǧڤʤɤޤ
Źˡ
Ź沽Żҽ̾ˤĤƤξܺ٤ʴܳǰϡ
ޤ
ϡ
tagxref(concepts)ξϤޤ
taggnupgθʻˡƱޤ
ϡ
tagxref(management)ξϤ
tagxref(wise)ξϤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
tagGnupg uses public-key cryptography so that users may communicate securely.
In a public-key system, each user has a pair of keys consisting of
a tagfirstterm(private key) and a tagfirstterm(public key).
A user's private key is kept secret; it need never be revealed.
The public key may be given to anyone with whom the user wants to
communicate.
tagGnupg uses a somewhat more sophisticated scheme in which a user has
a primary keypair and then zero or more additional subordinate keypairs.
The primary and subordinate keypairs are bundled to facilitate key
management and the bundle can often be considered simply as one keypair.
]],[[dnl
tagGnupgϸŹˡȤäơ
桼̿Ǥ褦ˤޤ
Ϥˤơ
ƥ桼ϡ
tagfirstterm()tagfirstterm(̩)ǤǤФޤ
桼̩̩ξ֤ˤ⤿졢
褷餫ˤɬפޤ
ϡ
桼̿ɤʿͤˤƤ⤫ޤޤ
縰ФǤդİʾФ桼äƤȤ
ʤ줿Ȥߤ
tagGnupgǤϺѤƤޤ
θФϡ򤹤뤿Ȥ߹蘆졢
ȹ礻ϤФС
ñ1ФǤȹͤޤ
]])dnl
endpara


beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Generating a new keypair
,
Ф
)]])

beginpara
iydraft([[dnl
The command-line option taglink(gen-key,tagoption(--gen-key))
is used to create a new primary keypair.
]],[[dnl
taglink(gen-key,tagoption(--gen-key))ޥɹԥץϡ
縰Ф뤿˻Ȥޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --gen-key)
gpg (GnuPG) 0.9.4; Copyright (C) 1999 Free Software Foundation, Inc.
This program comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under certain conditions. See the file COPYING for details.

Please select what kind of key you want:
   (1) DSA and ElGamal (default)
   (2) DSA (sign only)
   (4) ElGamal (sign and encrypt)
Your selection?
endscreen

beginignore
REWRITE
From Thomas Zander (zander[[]]atmark[[]]microweb.nl):
In GPG you can create 3 type of keypairs. A keypair is the combination
of a publ ic key and a private key, see chapter X. A DSA keypair can
only be used to sign a message. A ElGamal subordinate keypair can be
used for encryption as well as s igning, but is not as compatible with
former standards.

Option 1 creates 2 keypairs; a DSA (signing) and a ElGamal (Encryption).
Option 2 creates a DSA keypair (Signing)
Option 4 creates a ElGemal keypair (Signing & Encryption).

note: option 3 xxxx

This doesn't quite work, but I agree the following paragraph is rough.
endignore

iydraft([[dnl
tagGnupg is able to create several different types of keypairs, but a primary
key must be capable of making signatures.
There are therefore only three options.
Option 1 actually creates two keypairs.
A DSA keypair is the primary keypair usable only for making signatures.
An ElGamal subordinate keypair is also created for encryption. 
Option 2 is similar but creates only a DSA keypair.
Option 4[[]]tagfootnote(beginpara()Option 3 is to generate an ElGamal keypair that is
not usable for making signatures.endpara) creates a single ElGamal 
keypair usable for both making signatures and performing encryption.
In all cases it is possible to later add additional subkeys for encryption
and signing.
For most users the default option is fine.
]],[[dnl
tagGnupgϡ
ʼθФǤޤ
Ǥ
縰ǤϽ̾ǤʤФʤޤΤǡ
ϡ
3Ĥˤʤޤ
Υץ1ϡ
2ĤθФºݤޤ
DSAФ̾Ѥμ縰ФǤ
ŹElGamalФǤޤ
ץ2ƱͤǤDSAФΤߤǤޤ
ץ4[[]]tagfootnote(beginparaץ3ϡ
̾򤪤ʤˤϻѤǤʤElGamalФǤޤendpara)ϡ
̾ŹξѤElGamalФ1ޤ
ɤξ⡢Ź沽Ƚ̾ΤᡢɲäФ򤯤廊뤳ȤǤޤ
ۤȤɤΥ桼ϡ
ΥץǤǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
You must also choose a key size.
The size of a DSA key must be between 512 and 1024 bits, and an ElGamal
key may be of any size.
tagGnupg, however, requires that keys be no smaller than 768 bits.
Therefore, if Option 1 was chosen and you choose a keysize larger than
1024 bits, the ElGamal key will have the requested size, but the DSA
key will be 1024 bits.
]],[[dnl
⤨ФʤФʤޤ
DSAΥϡ
5121024ӥåȤδ֤ǤʤФʤޤ
ElGamalϡ
륵Ǥꤨޤ
ǤtagGnupgǤϡ
768ӥåȤĹɬפޤ
äơ
⤷ץ11024ӥåȤĹ򤨤֤ʤС
ElGamalϻꤷȤΥˤʤޤ
DSA1024ӥåȤˤʤ뤳Ȥˤʤޤ
]])dnl

beginscreen(width="80")
About to generate a new ELG-E keypair.
              minimum keysize is  768 bits
              default keysize is 1024 bits
    highest suggested keysize is 2048 bits
What keysize do you want? (1024)
endscreen

iydraft([[dnl
The longer the key the more secure it is against brute-force attacks,
but for almost all purposes the default keysize is adequate since
it would be cheaper to circumvent the encryption than try to break it.
Also, encryption and decryption will be slower as the
key size is increased, and a larger keysize may affect signature length.
Once selected, the keysize can never be changed.
]],[[dnl
ĹĹۤ깶ˤưˤʤޤ
Ź沽ˤȤ򤹤äȰ¾ˤʤΤǡ
ۤȤɤ٤ƤŪˤθǽʬǤ
ޤ礹ȡ
Ź沽椬ä٤ʤǤ礦
ˡ
ĹǤϡ
̾Ĺˤƶ뤫⤷ޤ
ä򤵤줿ǡ
Ѥ뤳Ȥϡ
褷ƤǤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Finally, you must choose an expiration date.
If Option 1 was chosen, the expiration date will be used for both the
ElGamal and DSA keypairs.
]],[[dnl
Ǹˡλ򤨤ФʤФʤޤ
ץ1򤨤֤ȡ
λElGamalDSAξθФ˶̤ˤʤޤ
]])dnl

beginscreen(width="80")
Please specify how long the key should be valid.
         0 = key does not expire
      taglt()n>  = key expires in n days
      taglt()n>w = key expires in n weeks
      taglt()n>m = key expires in n months
      taglt()n>y = key expires in n years
Key is valid for? (0) 
endscreen

iydraft([[dnl
For most users a key that does not expire is adequate.
The expiration time should be chosen with care, however,
since although it is possible to change the expiration date after the key
is created, it may be difficult to communicate a change
to users who have your public key.
]],[[dnl
ۤȤɤΥ桼ˤϡΤʤǽʬǤ
ʤ顢λϡտ֤٤Ǥ
ʤʤ顢塢λѤ뤳ȤǤΤǤ
ʤθĥ桼ѹΤ뤳Ȥϡ
񤷤⤷ʤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
You must provide a user ID in addition to the key parameters.
The user ID is used to associate the key being created with a real
person.
]],[[dnl
ѥ᡼˲ä桼ID⤢ʤФʤޤ
桼IDϡ
ǤȼºݤοͤȤбŤ˻Ȥޤ
]])dnl

beginscreen(width="80")
You need a User-ID to identify your key; the software constructs the user id
from Real Name, Comment and Email Address in this form:
    "Heinrich Heine (Der Dichter) taglt()heinrichh[[]]atmark[[]]duesseldorf.de>"

Real name: 
endscreen

iydraft([[dnl
Only one user ID is created when a key is created, but it is possible
to create additional user IDs if you want to use the key in two or
more contexts, tageg, as an employee at work and a political activist
on the side.
A user ID should be created carefully since it cannot be edited after
it is created.
]],[[dnl
ȡ桼ID1ĤǤޤ
طˤơ
ȤСܶȤνȰȤưȤȤơ
ʣθȤʬС
ǤդΥ桼ID뤳ȤǤޤ
ԽϤǤʤΤǡ
桼IDϡտ٤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
tagGnupg needs a passphrase to protect the primary and subordinate 
private keys that you keep in your possession.
]],[[dnl
tagGnupgǤϡ
ʤλʪǤ̩ޤ뤿ᡢ
ѥե졼ޤ
]])dnl

beginscreen(width="80")
You need a Passphrase to protect your private key.    

Enter passphrase: 
endscreen

iydraft([[dnl
There is no limit on the length of a passphrase, and it should be
carefully chosen.
From the perspective of security, the passphrase to unlock the private
key is one of the weakest points in taggnupg (and other public-key 
encryption systems as well) since it is the only protection you 
have if another individual gets your private key.
Ideally, the passphrase should not use words from a dictionary and
should mix the case of alphabetic characters as well as use 
non-alphabetic characters.
A good passphrase is crucial to the secure use of taggnupg.
]],[[dnl
ѥե졼Ĺˤϸ³ޤ
ѥե졼ϡտ֤٤Ǥ
⤷¾θĿͤʤ̩ˤ줿ʤС
ʤͣݸϥѥե졼ʤΤǡ
̩򳫾ѥե졼ϡ
taggnupgˤ
(¾θŹ沽ƥˤƤǤ)
ƥθϤ顢
Ǥ夤Τ1ĤǤ
Ūˤȡ
ѥե졼ϡ
ˤȤ٤Ǥʤ
󥢥ե٥åʸλѤƱ͡
ʸȾʸޤ٤Ǥ
ɤѥե졼ϡtaggnupgΰʻѤˤȤäƷŪǤ
]])dnl
endpara

beginsubsection([[ id="revocation"]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Generating a revocation certificate
,
˴
)]])

beginpara
iydraft([[dnl
After your keypair is created you should immediately generate a revocation
certificate for the primary public key using the option
taglink(gen-revoke,tagoption(--gen-revoke)).
If you forget your passphrase or if your private key is compromised 
or lost, this revocation certificate may be published to notify others
that the public key should no longer be used.
A revoked public key can still be used to verify signatures made
by you in the past, but it cannot be used to encrypt future messages
to you.
It also does not affect your ability to decrypt messages sent to
you in the past if you still do have access to the private key.
]],[[dnl
Ф塢
taglink(gen-revoke,tagoption(--gen-revoke))
ץǡ
Τ¨¤˴٤Ǥ
⤷ѥե졼˺줿ꡢ
̩Ȥ줿ꡢ
ʤʤäꤹʤС
֤Ϥ䤽θȤ٤ǤϤʤ
¾ο̹ͤ𤹤뤿ˡ
˴뤳Ȥˤʤޤ
˴줿ϡ
ʤˤäƲ˺줿̾뤿ˤϤޤȤޤ
褢ʤˤƤΥåΰŹ沽ˤϻȤޤ
ޤ⤷ʤޤ̩إǤʤ顢
ˤʤ줿åǽϤˤ⡢
ƶϤޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output revoke.asc --gen-revoke mykey)
[tagdots]
endscreen

iydraft([[dnl
The argument tagvar(mykey) must be a tagemphasis(key
specifier),
either the key ID of your primary keypair or any part of a user ID
that identifies your keypair.
The generated certificate will be left in the file
tagparameter(revoke.asc).
If the taglink(output,tagoption(--output)) option is 
omitted, the result will be placed on standard output.
Since the certificate is short, you may wish to print a hardcopy of
the certificate to store somewhere safe such as your safe deposit box.
The certificate should not be stored where others can access it since
anybody can publish the revocation certificate and render the
corresponding public key useless.
]],[[dnl
tagvar(mykey)ϡ
tagemphasis()
Ĥޤ縰ФθID
ФƱꤹǤդΥ桼IDΤɤ餫ǤʤФʤޤ
줿ϡ
եtagparameter(revoke.asc)ϤǤ
taglink(output,tagoption(--output))
ץ󤬾άȡ̤ɸϤˤʤޤ
ûΤǡϡɥԡ
ݴɶˤΤ褦ˤɤʾسǼ⤷ޤ
˴ФǤб̵ˤǤΤǡ
˴ϡ
¾ͤΥǤ褦ʤȤˤ٤ǤϤޤ
]])dnl
endpara
endsubsection
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Exchanging keys
,
θ
)]])

beginpara
iydraft([[dnl
To communicate with others you must exchange public keys.
To list the keys on your public keyring use the command-line 
option taglink(list-keys,tagoption(--list-keys)).
]],[[dnl
¾οͤ̿ˤϡ򴹤ʤФʤޤ
ؤθȤˤϡ
taglink(list-keys,tagoption(--list-keys))
ޥɹԥץȤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --list-keys)
/users/alice/.gnupg/pubring.gpg
---------------------------------------
pub  1024D/BB7576AC 1999-06-04 Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>
sub  1024g/78E9A8FA 1999-06-04
endscreen

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Exporting a public key
,
νФ
)]])

beginpara
iydraft([[dnl
To send your public key to a correspondent you must first export it.
The command-line option taglink(export,tagoption(--export))
is used to do this.
It takes an additional argument identifying the public key to export.
As with the tagoption(--gen-revoke) option, either the key ID or any part of
the user ID may be used to identify the key to export.
]],[[dnl
ʬθ̿ˤϡ
ǽˤ񤭽ФʤФʤޤ
ˤϡ
taglink(export,tagoption(--export))
ޥɹԥץȤޤ
Ͻ񤭽ФƱꤹǤդΰȤޤ
񤭽ФƱꤹ뤿ᡢ
tagoption(--gen-revoke)ץƱ͡
ID⡢
ФƱꤹǤդΥ桼ID⡢
ɤǤȤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output alice.gpg --export alice[[]]atmark[[]]cyb.org)
endscreen

beginpara
iydraft([[dnl
The key is exported in a binary format, but this can be inconvenient
when the key is to be sent though email or published on a web page.
]],[[dnl
ϡХʥ꡼ǽ񤭽Фޤ
٤Żҥ᡼ͳꡢ
֡ڡǸ줿ꤹȤ
ؤ⤷ޤ
]])dnl
iydraft([[dnl
tagGnupg therefore supports a command-line option 
taglink(armor,tagoption(--armor))tagfootnote([[
]]beginpara()iydraft([[Many
command-line options that are frequently used can also be set in a
taglink(optionsfile,configuration file).
]],[[dnl
]])dnl
endpara
)
that 
causes output to be generated in an ASCII-armored format similar to
uuencoded documents.
In general, any output from taggnupg, tageg, keys, encrypted documents, and
signatures, can be ASCII-armored by adding the tagoption(--armor) option.
]],[[dnl
ätagGnupgϡ
Ϥuuencode줿ʸȻASCII
taglink(armor,tagoption(--armor))tagfootnote([[
]]beginparaˤ˻Ȥ륳ޥɹԥץ¿ϡ
taglink(optionsfile,ե)֤ȤǤޤ
endpara
)
ޥɹԥץٱ礷Ƥޤ
̡taggnupgΤϡ
ȤСŹ沽ʸ񡢽̾ϡ
tagoption(--armor)ץ򤢤뤳ȤˤäASCIIˤǤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --armor --export alice[[]]atmark[[]]cyb.org)
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v0.9.7 (GNU/Linux)
Comment: For info see http://www.gnupg.org

[tagdots]
-----END PGP PUBLIC KEY BLOCK-----
endscreen
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Importing a public key
,
ɹ
)]])

beginpara
iydraft([[dnl
A public key may be added to your public keyring with the
taglink(import,tagoption(--import)) option.
]],[[dnl
taglink(import,tagoption(--import))ץǡ
ؤ˸ĤȤǤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --import blake.gpg)
gpg: key 9E98BC16: public key imported
gpg: Total number processed: 1
gpg:               imported: 1
tagprompt(alice%) taguserinput(gpg --list-keys)
/users/alice/.gnupg/pubring.gpg
---------------------------------------
pub  1024D/BB7576AC 1999-06-04 Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>
sub  1024g/78E9A8FA 1999-06-04

pub  1024D/9E98BC16 1999-06-04 Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>
sub  1024g/5C8CBD41 1999-06-04
endscreen

beginpara
iydraft([[dnl
Once a key is imported it should be validated.
tagGnupg uses a powerful and flexible trust model that does not require
you to personally validate each key you import.
Some keys may need to be personally validated, however.
A key is validated by verifying the key's fingerprint and then signing
the key to certify it as a valid key.
A key's fingerprint can be quickly viewed with the
taglink(fingerprint,tagoption(--fingerprint))
command-line option, but in order to certify the key you must edit it.
]],[[dnl
ä󸰤ɤ߹ޤСͭˤ٤Ǥ
tagGnupgϡϤǡʿѥǥȤäƤΤǡ
ɤ߹򤽤줾ĿŪͭˤɬפϤޤ
ȤϤˤäƤϡ
ĿŪͭˤʤȤʤȤ⤢ޤ
ͭˤˤϡ
ޤλ򸡾ڤơ
ͭʸǤȾ褦˽̾򤷤ޤ
taglink(fingerprint,tagoption(--fingerprint))
ޥɹԥץǡ
λ򸫤뤳Ȥϼ᤯Ǥޤ
ˤϡԽʤФʤޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --edit-key blake[[]]atmark[[]]cyb.org)

pub  1024D/9E98BC16  created: 1999-06-04 expires: never      trust: -/q
sub  1024g/5C8CBD41  created: 1999-06-04 expires: never     
(1)  Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>

tagprompt(Command>) taguserinput(fpr)
pub  1024D/9E98BC16 1999-06-04 Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>
             Fingerprint: 268F 448F CCD7 AF34 183E  52D8 9BDE 1A08 9E98 BC16
endscreen

iydraft([[dnl
A key's fingerprint is verified with the key's owner.
This may be done in person or over the phone or through any other means
as long as you can guarantee that you are communicating with the key's
true owner.
If the fingerprint you get is the same as the fingerprint the key's
owner gets, then you can be sure that you have a correct copy of the key.
]],[[dnl
λϡθλȸڤ٤Ǥ
ϡľܤޤäܿͤȡޤϡ
ολ̿ƤȼʬݾڤǤ褦ǤС
¾ΤɤˡˤäƤǤ⤫ޤޤ
⤷줿椬λν̾ƱʤС
ʣΤǤ뤳ȤοǤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
After checking the fingerprint, you may sign the key to validate it.
Since key verification is a weak point in public-key cryptography,
you should be extremely careful and tagemphasis(always) check
a key's fingerprint with the owner before signing the key.
]],
Υåθ塢
̾򤷤ơ
θͭˤ뤳ȤǤޤ
ڤϸŹˡˤûʤΤǡ
տ
Ƹ˽̾tagemphasis(ɬ)ȸλå٤Ǥ
)dnl
endpara

beginscreen(width="80")
tagprompt(Command>) taguserinput(sign)
             
pub  1024D/9E98BC16  created: 1999-06-04 expires: never      trust: -/q
             Fingerprint: 268F 448F CCD7 AF34 183E  52D8 9BDE 1A08 9E98 BC16

     Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>

Are you really sure that you want to sign this key
with your key: "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"

Really sign?
endscreen

beginpara
iydraft([[dnl
Once signed you can check the key to list the signatures on it and
see the signature that you have added.
Every user ID on the key will have one or more self-signatures as well
as a signature for each user that has validated the key.
]],[[dnl
ä̾С
åơ̾ꥹȤĤ­̾򸫤뤳ȤǤޤ
ͭˤƥ桼ν̾Ʊ͡
桼IDˤϡ1İʾμʽ̾Ǥ礦
]])dnl
endpara

beginscreen(width="80")
tagprompt(Command>) taguserinput(check)
uid  Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>
sig!       9E98BC16 1999-06-04   [self-signature]
sig!       BB7576AC 1999-06-04   Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>
endscreen
endsubsection
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Encrypting and decrypting documents
,
ʸΰŹ沽
)]])

beginpara
iydraft([[dnl
A public and private key each have a specific role when
encrypting and decrypting documents.
A public key may be thought of as an open safe.
When a correspondent encrypts a document using a public
key, that document is put in the safe, the safe shut, and the
combination lock spun several times.
The corresponding private key is the combination that can 
reopen the safe and retrieve the document.
In other words, only the person who holds the private key
can recover a document encrypted using the associated public key.
]],
̩ˤϡ
ʸΰŹ沽Ǥ줾䤬ޤ
ϡ
ˤȹͤ뤫⤷ޤ
̿ȤʸŹ沽Ȥ
ʸ϶ˤ졢
(ĤƤ)
ޤ蘆ޤ
б̩ϡ
ޤˤ򳫤ʸ򸡺Ǥ褦ֹȹ礻Ǥ
Ĥޤꡢ
̩Ŀͤ
бǰŹ沽줿ʸ᤹ȤǤΤǤ
)dnl
endpara

beginpara
iydraft([[dnl
The procedure for encrypting and decrypting documents is
straightforward with this mental model.
If you want to encrypt a message to Alice, you encrypt it
using Alice's public key, and she decrypts it with her private key.
If Alice wants to send you a message, she encrypts it using your
public key, and you decrypt it with your private key.
]],
ʸΰŹ沽
μ³ϡ
ñˤλۥǥΤޤޤǤ
åAlice˰Ź沽Ȥϡ
AliceθǰŹ沽
AliceAliceȤ̩椷ޤ
Aliceå򤢤ʤꤿȤϡ
AliceʤθǰŹ沽
ʤʬ̩椷ޤ
)dnl
endpara

beginpara
iydraft([[dnl
To encrypt a document the option 
taglink(encrypt,tagoption(--encrypt)) is used.
You must have the public keys of the intended recipients.
The software expects the name of the document to encrypt as input; if
omitted, it reads standard input.
The encrypted result is placed on standard output or as specified using
the option tagoption(--output).
The document is compressed for additional security in addition to
encrypting it.
]],[[dnl
ʸŹ沽ˤϡ
taglink(encrypt,tagoption(--encrypt))
ץȤޤ
ˤϼäƤۤͤθޤ
Ź沽ʸ̾ϤȤƤȤޤ
άȡɸϤˤʤޤ
Ź沽η̤ϡɸϡޤϡ
tagoption(--output)ץǻǤޤ
ƥΤᡢ
Ź沽ʸϡ
̤⤵ޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output doc.gpg --encrypt --recipient blake[[]]atmark[[]]cyb.org doc)
endscreen

iydraft([[dnl
The taglink(recipient,tagoption(--recipient)) option
is used once for each recipient and takes an extra argument specifying
the public key to which the document should be encrypted.
The encrypted document can only be decrypted by someone with a private
key that complements one of the recipients' public keys.
In particular, you cannot decrypt a document encrypted by you unless
you included your own public key in the recipient list.
]],[[dnl
taglink(recipient,tagoption(--recipient))ץϡ
Ƽͤˤ1ٻȤ졢
ʸΰŹ沽˻ȤꤹǤդΰȤޤ
Ź沽ʸϡ
ͤθΤ1Ĥб̩ĿͤǤޤ
Ǥ顢ʬθͥꥹȤʤС
ʬǰŹ沽ʸ񤵤Ǥʤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
To decrypt a message the option 
taglink(decrypt,tagoption(--decrypt)) is used.
You need the private key to which the message was encrypted.
Similar to the encryption process, the document to decrypt is
input, and the decrypted result is output.
]],[[dnl
å椹ˤϡ
taglink(decrypt,tagoption(--decrypt))ץȤޤ
ˤϥåŹ沽Ȥθ̩ޤ
Ź沽ΤȤƱͤǤ
椹ʸϤˤʤꡢ̤Ϥˤʤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(blake%) taguserinput(gpg --output doc --decrypt doc.gpg)

You need a passphrase to unlock the secret key for
user: "Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>"
1024-bit ELG-E key, ID 5C8CBD41, created 1999-06-04 (main key ID 9E98BC16)

Enter passphrase: 
endscreen

beginpara
iydraft([[dnl
Documents may also be encrypted without using public-key cryptography.
Instead, you use a symmetric cipher to encrypt the document.
The key used to drive the symmetric cipher is derived from a passphrase
supplied when the document is encrypted, and for good security, it
should not be the same passphrase that you use to protect your private key.
Symmetric encryption is useful for securing documents when the
passphrase does not need to be communicated to others.
A document can be encrypted with a symmetric cipher by using the
taglink(symmetric,tagoption(--symmetric)) option.
]],[[dnl
ŹˡȤʤȤ⡢
ʸŹ沽뤳ȤϤǤޤ
ʸΰŹ沽ǻȤΤ¾ˡ
оΰŹ椬ޤ
оΰŹζưǻȤϡ
ʸŹ沽Ȥˤѥե졼Ȥޤ
ƥɤ뤿ˤϡ
̩ޤ뤿˻ȤΤƱѥե졼Ǥ٤ǤϤޤ
ѥե졼¾ԤɬפΤʤȤʸޤˤϡ
оΰŹ椬Ωޤ
ʸоΰŹǰŹ沽ˤϡ
taglink(symmetric,tagoption(--symmetric))
ץȤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output doc.gpg --symmetric doc)
Enter passphrase: 
endscreen
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Making and verifying signatures
,
̾Ȥθ
)]])

beginpara
iydraft([[dnl
A digital signature certifies and timestamps a document.
If the document is subsequently modified in any way, a verification
of the signature will fail.
A digital signature can serve the same purpose as a hand-written signature
with the additional benefit of being tamper-resistant.
The taggnupg source distribution, for example, is signed so that users can
verify that the source code has not been modified since it was packaged.
]],[[dnl
Żҽ̾ϡʸݾڤॹפ򤪤ޤ
ɤˡǤ줽ʸ񤬸ѹȡ
̾θڤϼԤǤ礦
ɻ߸̤򤢤뤳Ȥˤꡢ
Żҽ̾ϼ񤭤ν̾ƱŪΩޤ
ȤtaggnupgΥʪＫΤ̾ƤΤǡ
ʪȤƤޤȤ᤿塢
ɤѹΤʤȤ
桼ǧ뤳ȤǤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Creating and verifying signatures uses the public/private keypair
in an operation different from encryption and decryption.
A signature is created using the private key of the signer.
The signature is verified using the corresponding public key.
For example, Alice would use her own private key to digitally sign
her latest submission to the Journal of Inorganic Chemistry.
The associate editor handling her submission would use Alice's
public key to check the signature to verify that the submission
indeed came from Alice and that it had not been modified since Alice
sent it.
A consequence of using digital signatures is that it is difficult to 
deny that you made a digital signature since that would imply 
your private key had been compromised.
]],[[dnl
̾ȸڤˤϡ
Ź沽ΤȤȤ̤ʡ
̩θФȤޤ
̾Ԥ̩ǡ
̾ޤ
бǡ
ν̾򸡾ڤǤޤ
ȤС
Alicethe Journal of Inorganic ChemistryκǿؤƤˡ
ʬ̩Żҽ̾򤷤Ȥޤ礦
ôԽԤϡ
Aliceθǽ̾򸡾ڤ
ƤΤAliceΤΤǡ
Aliceä塢
ѹΤʤȤåǤޤ
Żҽ̾η̡
ʤŻҽ̾򤷤Ȥꤹ뤳Ȥϡ
̩Ȥ줿
Ȥ̣ˤʤ뤿ᡢ
Τ褦񤷤
ȤȤˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
The command-line option 
taglink(sign-doc,tagoption(--sign)) is
used to make a digital signature.
The document to sign is input, and the signed document is output.
]],[[dnl
Żҽ̾򤹤ˤϡ
taglink(sign,tagoption(--sign))
ޥɹԥץȤޤ
̾褦ȤʸϤǡ
̾ʸ񤬽ϤǤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output doc.sig --sign doc)

You need a passphrase to unlock the private key for
user: "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"
1024-bit DSA key, ID BB7576AC, created 1999-06-04

Enter passphrase: 
endscreen

iydraft([[dnl
The document is compressed before being signed, and the output is in binary
format.
]],[[dnl
ʸϽ̾˰̤졢ϤϥХʥ꡼ˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Given a signed document, you can either check the signature or
check the signature and recover the original document.
To check the signature use the 
taglink(verify,tagoption(--verify)) option.
To verify the signature and extract the document use the
tagoption(--decrypt)
option.
The signed document to verify and recover is input and the recovered
document is output.
]],[[dnl
̾줿ǤդʸˤĤơ
ñ˽̾Υå򤷤ꡢ
̾åʸ򤷤ꤹ뤳ȤǤޤ
̾åˤϡ
taglink(verify,tagoption(--verify))
ץȤޤ
̾ʸФˤϡ
tagoption(--decrypt)
ץȤޤ
̾򸡾ڤʸϤǡ줿ʸ񤬽ϤǤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(blake%) taguserinput(gpg --output doc --decrypt doc.sig)
gpg: Signature made Fri Jun  4 12:02:38 1999 CDT using DSA key ID BB7576AC
gpg: Good signature from "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"
endscreen

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Clearsigned documents
,
ꥢ̾ʸ
)]])

beginpara
iydraft([[dnl
A common use of digital signatures is to sign usenet postings or
email messages.
In such situations it is undesirable to compress the document while
signing it.
The option 
taglink(clearsign,tagoption(--clearsign)) 
causes the document to be wrapped in an ASCII-armored signature but 
otherwise does not modify the document.
]],[[dnl
Żҽ̡̾
usenetؤƤŻҥ᡼Υåؤν̾˻Ȥޤ
硢
ʸ˽̾Ȥ˰̤򤹤Τϡ
ޤޤ
taglink(clearsign,tagoption(--clearsign))
ץǤϡ
ASCII̾ʸ񤬤ĤĤޤΤ
ѹ򤷤ޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --clearsign doc)

You need a passphrase to unlock the secret key for
user: "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"
1024-bit DSA key, ID BB7576AC, created 1999-06-04

-----BEGIN PGP SIGNED MESSAGE-----
Hash: SHA1

[tagdots]
-----BEGIN PGP SIGNATURE-----
Version: GnuPG v0.9.7 (GNU/Linux)
Comment: For info see http://www.gnupg.org

iEYEARECAAYFAjdYCQoACgkQJ9S6ULt1dqz6IwCfQ7wP6i/i8HhbcOSKF4ELyQB1
oCoAoOuqpRqEzr4kOkQqHRLE/b8/Rw2k
=y6kj
-----END PGP SIGNATURE-----
endscreen
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Detached signatures
,
ʬΥ̾
)]])

beginpara
iydraft([[dnl
A signed document has limited usefulness.
Other users must recover the original document from the signed
version, and even with clearsigned documents, the signed document
must be edited to recover the original.
Therefore, there is a third method for signing a document that
creates a detached signature, which is a separate file.
A detached signature is created using the 
taglink(detach-signature,tagoption(--detach-sig))
option.
]],[[dnl
̾줿ʸϡ
ͭ˸³ޤ
¾Υ桼ϡ̾줿ǤʸʤФʤʤ
ꥢ̾줿ʸ˴ؤƤ⡢
ʸˤϡ̾줿ʸԽʤФʤޤ
äơʸ˽̾뤿3ˡϡ
̤ʥեʬΥ̾뤳ȤǤ
ʬΥ̾ˤϡ
taglink(detach-sig,tagoption(--detach-sig))
ץȤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --output doc.sig --detach-sig doc)

You need a passphrase to unlock the secret key for
user: "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"
1024-bit DSA key, ID BB7576AC, created 1999-06-04

Enter passphrase: 
endscreen

beginpara
iydraft([[dnl
Both the document and detached signature are needed to verify
the signature.
The tagoption(--verify) option can be to check the 
signature.
]],[[dnl
̾򸡾ڤˤϡʸʬΥ̾ξޤ
tagoption(--verify)ץǡ
̾åǤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(blake%) taguserinput(gpg --verify doc.sig doc)
gpg: Signature made Fri Jun  4 12:38:46 1999 CDT using DSA key ID BB7576AC
gpg: Good signature from "Alice (Judge) taglt()alice[[]]atmark[[]]cyb.org>"
endscreen
endsubsection
endsection
endchapter

beginignore
In the "Getting Started" chapter, it would be interesting to provide
a checklist of assumptions that the reader can consult to determine
whether or not she fits the "most users" profile.  Perhaps put this
at the end of the chapter (perhaps w/ forward pointer?).  You could
include cross references for each item on the list.  For example:

    23.  Your use of public key encryption has property X with attribute Y.
         (see Section 3.4.1 for a more detailed discussion of other
          attributes of property X)

What prompted this was wondering, as I read through the generating keypair
section, "under what circumstances would these defaults be inappropriate?"

The notion of using the same key with different user IDs "as an employee at
work and a political activist on the side" is interesting.  Knowing one,
could you be traced to the other?  (Are they separate numeric ids, and is
that enough?)  (seems someone could just match the public keys)

It's a very nice touch that you don't cover every single prompt that the
system throws at you, but instead treat them functionally.  For example,
I can imagine other books going through the "Comment:" and "Email Address:"
prompts.
endignore

beginignore
"Key verification is a weak point in public-key cryptography tagdots"
Saying "weak point" makes it sound like a slam on public key stuff.
Although we've talked about weaknesses of the trust model, I'm guessing
the point here is that communication is only secure if you verify the
identity of the key's owner.

Key verification can be done through any means "as long as you can
guarantee that you are communicating with the key's true owner".
I suspect we'd also like to prevent leaking information that an
interceptor could use to pose as us in a key verification step with
another party.  I suppose the notion of bootstrapping may not be widely
appreciated as an analogy.

I'm almost inclined to want to see a section in the Getting Started
guide called "Why you should read the rest of this book".  Failing
that, or perhaps better yet, maybe it would work to have some margin
notes that point to other sections of the book for more information
("a discussion of trust models begins on p. 95").
endignore

