beginchapter(concepts,xreflabel="2")dnl
tagdocinfo([[$Id: c2.sgml,v 1.11 2000/08/15 01:52:50 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Concepts
,
ǰ
)]])

beginpara
iydraft([[dnl
tagGnupg makes uses of several cryptographic concepts including 
tagfirstterm(symmetric ciphers), 
tagfirstterm(public-key ciphers), and 
tagfirstterm(one-way hashing).
You can make basic use taggnupg without fully understanding these concepts,
but in order to use it wisely some understanding of them is necessary.
]],[[dnl
tagGnupgϡtagfirstterm(оΰŹ)
tagfirstterm(Ź)
tagfirstterm(ϥå)ޤŹ泵ǰ򤤤ĤȤäƤޤ
γǰʬ򤷤ʤƤ⡢ŪtaggnupgλѤϤǤޤ
ʻѤΤˤϡ¿ɬפǤ
]])dnl
endpara

beginpara
iydraft([[dnl
This chapter introduces the basic cryptographic concepts used in GnuPG.
Other books cover these topics in much more detail.
A good book with which to pursue further study is 
taguref(http://www.counterpane.com/schneier.html, Bruce 
Schneier)'s
taguref(http://www.counterpane.com/applied.html,tagldquo[[]]Applied 
Cryptography[[]]tagrdquo).
]],[[dnl
ξϤǤϡGnuPG˻ȤŪʰŹ泵ǰҲ𤷤ޤ
ˤĤƤä¿ξܺ٤ϡ
¾ʸǤĤäƤޤ
ʤ븦ɵɤܤϡ
taguref(http://www.counterpane.com/schneier.html, Bruce 
Schneier)taguref(http://www.counterpane.com/applied.html, "Applied 
Cryptography")Ǥ
]])dnl
endpara

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Symmetric ciphers
,
оΰŹ
)]])

beginpara
iydraft([[dnl
A symmetric cipher is a cipher that uses the same key for both encryption
and decryption.
Two parties communicating using a symmetric cipher must agree on the
key beforehand.
Once they agree, the sender encrypts a message using the key, sends it
to the receiver, and the receiver decrypts the message using the key.
As an example, the German Enigma is a symmetric cipher, and daily keys
were distributed as code books.
Each day, a sending or receiving radio operator would consult his copy
of the code book to find the day's key.
Radio traffic for that day was then encrypted and decrypted using the
day's key.
Modern examples of symmetric ciphers include 3DES, Blowfish, and IDEA.
]],[[dnl
оΰŹϡŹ沽ξƱȤŹǤ
оΰŹȤä̿ξԤϡ
äƸˤĤƹդʤФʤޤ
äդС
¦θǥåŹ沽
¦ꡢ
¦θǥå椷ޤ
ȤХɥĤEnigmaоΰŹǡɥ֥åޤ
򤹤̵̿Τϡ
ɥ֥åĴ٤ơ
θ򸫤Ĥޤ
̵̿ϡθǰŹ沽졢椵ޤ
ǶоΰŹˤϡ3DESBlowfishIDEAʤɤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
A good cipher puts all the security in the key and none in the algorithm.
In other words, it should be no help to an attacker if he knows which
cipher is being used.
Only if he obtains the key would knowledge of the algorithm be needed.
The ciphers used in taggnupg have this property.
]],[[dnl
ɤŹϡ
ƥ
르ꥺˤǤϤʤ
ޤ
ĤޤꡢɤΰŹ椬ȤäƤΤΤäƤƤ⡢
¦ؤμˤϤʤޤ
Ȥ
르ꥺˤĤƤξɬפȤʤޤ
taggnupg˻ȤŹϡ
ääƤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Since all the security is in the key, then it is important that it be
very difficult to guess the key.
In other words, the set of possible keys, tagie, the tagemphasis(key
space), needs
to be large.
While at Los Alamos, Richard Feynman was famous for his ability to
crack safes.
To encourage the mystique he even carried around a set of tools
including an old stethoscope.
In reality, he used a variety of tricks to reduce the number of
combinations he had to try to a small number and then simply guessed
until he found the right combination.
In other words, he reduced the size of the key space.
]],[[dnl
ƥΤ٤ƤˤΤǡ
ο¬񤷤ȤפǤ
ȡǽʸν硢Ĥޤꡢtagemphasis()ϡ
礭ɬפޤ
ˤǽϤǥ⥹ͭ̾äRichard FeynmanȤͤޤ
򤢤뤿ᡢ
ϡŤİǴޤƻ켰ηӤƤޤ
¤ϡᤵʤФʤʤȹ礻򾮤餹ˤϡ
͡ʾٹȤäΤǤ
ȹ礻ȯˤϡñ˿¬򤷤ΤǤ
ȡϸ֤礭̤᤿櫓Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
Britain used machines to guess keys during World War 2.
The German Enigma had a very large key space, but the British built
specialized computing engines, the Bombes, to mechanically try 
keys until the day's key was found.
This meant that sometimes they found the day's key within hours of
the new key's use, but it also meant that on some days they never
did find the right key.
The Bombes were not general-purpose computers but were precursors
to modern-day computers.
]],[[dnl
ꥹϡ2δ֡¬뵡Ȥޤ
ɥĤEnigmaˤϡ礭֤ޤ
θθĤޤǵŪ˸򤿤᤹η׻ؤǤBombes
ꥹͤϺޤ
ϡˤϿȤäƤ1ְˤθĤꡢ
ޤˤäƤϡ
褷ƸĤʤä
Ȥ̣Ǥ
Bombesϡѥԥ塼ǤϤޤǤ
Υԥ塼ǤϤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Today, computers can guess keys very quickly, and this is why key
size is important in modern cryptosystems.
The cipher DES uses a 56-bit key, which means that there are
beginc inlineequation endc
2[[]]tagsuperscript(56) possible keys.
beginc inlineequation endc
2[[]]tagsuperscript(56) is 72,057,594,037,927,936 keys.
This is a lot of keys, but a general-purpose computer can check the
entire key space in a matter of days.
A specialized computer can check it in hours.
On the other hand, more recently designed ciphers such as 3DES, 
Blowfish, and IDEA
beginc inlineequation endc
all use 128-bit keys, which means there are 2[[]]tagsuperscript(128) 
possible keys.
This is many, many more keys, and even if all the computers on the
planet cooperated, it could still take more time than the age of
the universe to find the key.
]],[[dnl
ԥ塼ϡ˿®˸¬ǤΤᡢ
ϡΰŹϤˤƽפǤ
DESŹϡ56ӥåȸ
beginc inlineequation endc
(2[[]]tagsuperscript(56)βǽʸ뤳Ȥ̣)
Ȥޤ
beginc inlineequation endc
2[[]]tagsuperscript(56)Ȥϡ
72,057,594,037,927,936ĤθǤ
¿θǤ
ѥԥ塼Ǥ⡢
23֤åǤ
ѥԥ塼ʤ顢֤ǥåǤޤ
3DESBlowfishIDEAΤ褦ʺǶ߷פ줿ŹϤ٤ơ
128ӥåȸ
beginc inlineequation endc
(2[[]]tagsuperscript(128)βǽʸ뤳Ȥ̣)Ȥޤ
Ϲ˰¿θǡԥ塼ϤȤƤ⡢
ȯˤϡ
ޤǯ⤺äĹ֤Ǥ礦
]])dnl
endpara
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Public-key ciphers
,
Ź
)]])

beginpara
iydraft([[dnl
The primary problem with symmetric ciphers is not their security but
with key exchange.
Once the sender and receiver have exchanged keys, that key can be
used to securely communicate, but what secure communication channel
was used to communicate the key itself?
In particular, it would probably be much easier for an attacker to work
to intercept the key than it is to try all the keys in the key space.
Another problem is the number of keys needed.
beginc inlineequation endc
If there are tagemphasis(n) people who need to communicate, then 
beginc inlineequation endc
tagemphasis(n(n-1)/2) keys
are needed for each pair of people to communicate privately.
This may be OK for a small number of people but quickly becomes unwieldy
for large groups of people.
]],[[dnl
оΰŹ˴ؤϡ
ƥǤϤʤ
θ򴹤Ǥ
ä̿˻ȤԼԤ򴹤ǤȤơ
ΤΤãˤϤɤʰ̿ͥȤǤ礦?
ä˹¦ˤȤäơ
֤Ǥ٤Ƥθ򤿤ᤷƤߤꡢ
İϤ餯Ȥϡ
餯Ϥ뤫˴ñǤ礦
¾ϡɬפʸοǤ
beginc inlineequation endc
̿ɬפΤtagemphasis(n)ͤȤϡ
1Фοͤġ̿ˤϡ
beginc inlineequation endc
tagemphasis(n(n-1)/2)Ĥθޤ
ʿͿѤˤϤǤ⤷ޤ󤬡
礭ʿͿΥ롼פǤϤѤˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Public-key ciphers were invented to avoid the key-exchange problem
entirely.
A public-key cipher uses a pair of keys for sending messages.
The two keys belong to the person receiving the message.
One key is a tagemphasis(public key) and may be given to anybody.
The other key is a tagemphasis(private key) and is kept 
secret by the owner.
A sender encrypts a message using the public key and once encrypted,
only the private key may be used to decrypt it.
]],[[dnl
Źϡ
˲򤹤뤿ȯޤ
Źϡå뤿1ФθȤޤ
2Ĥθϡ
åȤꤹͤΤΤǤ
θtagemphasis()ǡˤƤ⤫ޤޤ
⤦θtagemphasis(̩)ǡ
̩ˤƤޤ
¦ϸǥåŹ沽
äŹ沽ȡ̩˻Ȥޤ
]])dnl
endpara

beginpara
iydraft([[dnl
This protocol solves the key-exchange problem inherent with symmetric
ciphers.
There is no need for the sender and receiver to agree
upon a key.
All that is required is that some time before secret communication the
sender gets a copy of the receiver's public key.
Furthermore, the one public key can be used by anybody wishing to
communicate with the receiver.
beginc inlineequation endc
So only tagemphasis(n) keypairs are needed for tagemphasis(n) 
people to communicate secretly
with one another.
]],[[dnl
Υץȥǡ
оΰŹ椫餯븰꤬
褷ޤ
¦ȼ¦ǸˤĤƤιդޤ
ɬפʤΤϡ
¦θʣ
̩̿Фäơ
¦ȤäƤȤǤ
ޤ¦̿ͤοͤθ1ĻȤޤ
äơ
beginc inlineequation endc
tagemphasis(n)ͤ̿ˤϡtagemphasis(n)ФΤߤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Public-key ciphers are based on one-way trapdoor functions.
A one-way function is a function that is easy to compute,
but the inverse is hard to compute.
For example, it is easy to multiply two prime numbers together to get
a composite, but it is difficult to factor a composite into its prime
components.
A one-way trapdoor function is similar, but it has a trapdoor.
That is, if some piece of information is known, it becomes easy
to compute the inverse.
For example, if you have a number made of two prime factors, then knowing
one of the factors makes it easy to compute the second.
Given a public-key cipher based on prime factorization, the public
key contains a composite number made from two large prime factors, and
the encryption algorithm uses that composite to encrypt the
message.
The algorithm to decrypt the message requires knowing the prime factors,
so decryption is easy if you have the private key containing one of the
factors but extremely difficult if you do not have it.
]],[[dnl
ŹϡȤʹؿ˴ŤƤޤ
ؿȤϡ׻䤹ؿǡεդ׻Τ񤷤ΤǤ
ȤСȤΤˡ2Ĥǿ򤫤ΤϴñǤ
ǰʬѤǤ
ȤʹؿȤϡȻƤϤޤȴ꤬ꡢ
󤬤狼äƤС
դη׻ñˤʤ롢
ȤΤǤ
ȤС2ĤǰǤǤʤ顢
ΤΤȡ⤦η׻ϴñˤʤޤ
ʬˤȤŤǤդθŹǡ
ϡ
2Ĥ礭ǰǤޤߡ
Ź沽르ꥺϡåŹ沽뤿ˤιȤޤ
å楢르ꥺˤ2Ĥǰɬפǡ
äϡ
ΰޤ̩дñǤ
ʤФȤƤѤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
As with good symmetric ciphers, with a good public-key cipher all of the
security rests with the key.
Therefore, key size is a measure of the system's security, but
one cannot compare the size of a symmetric cipher key and a public-key
cipher key as a measure of their relative security.
In a brute-force attack on a symmetric cipher with a key size of 80 bits,
beginc inlineequation endc
the attacker must enumerate up to 2[[]]tagsuperscript(80) keys to 
find the right key.
In a brute-force attack on a public-key cipher with a key size of 512 bits,
the attacker must factor a composite number encoded in 512 bits (up to
155 decimal digits).
The workload for the attacker is fundamentally different depending on
the cipher he is attacking.
While 128 bits is sufficient for symmetric ciphers, given today's factoring
technology public keys with 1024 bits are recommended for most purposes.
]],[[dnl
ɤоΰŹƱ͡ɤŹ⡢
ƥΤ٤Ƥϸˤޤ
äơϡƥΥƥμ٤Ǥ
Ūʥƥμ٤Ȥơ
оΰŹ渰Ź渰Υ򤯤٤뤳ȤϤǤޤ
80ӥåȤθоΰŹˤ깶ˤơ
򸫤Ĥˤϡ¦ϡǹ
beginc inlineequation endc
2[[]]tagsuperscript(80)Ĥθ󤷤ʤФʤޤ
512ӥåȤθθŹˤ깶ˤơ
¦ϡ512ӥå
(10ʿǺǹ155)
沽줿ǰʬ򤷤ʤФʤޤ
¦Τκ٤ϡоݤΰŹˤäƺŪ˰㤤ޤ
оΰŹˤ128ӥåȤǽʬʰ
Ǥդΰʬ򵻽Ѥ餷ơ
ۤȤɤŪ1024ӥåȤθ侩ޤ
]])dnl
endpara
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Hybrid ciphers
,
Ź
)]])

beginpara
iydraft([[dnl
Public-key ciphers are no panacea.
Many symmetric ciphers are stronger from a security standpoint,
and public-key encryption and decryption are more expensive than the
corresponding operations in symmetric systems.
Public-key ciphers are nevertheless an effective tool for distributing
symmetric cipher keys, and that is how they are used in hybrid cipher
systems.
]],[[dnl
ŹϡǽǤϤޤ
ƥδϡ
ƤоΰŹ
ΰŹ沽ϡ
оηϤǤƱǤ
ǤʤŹϡоΰŹ渰θŪġǡ
ơŹϤǤϤޤˤΤ褦˻ȤƤΤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
A hybrid cipher uses both a symmetric cipher and a public-key cipher.
It works by using a public-key cipher to share a key for the symmetric
cipher.
The actual message being sent is then encrypted using the key and sent
to the recipient.
Since symmetric key sharing is secure, the symmetric key used is different
for each message sent.
Hence it is sometimes called a session key.
]],[[dnl
ŹϡоΰŹȸŹξȤޤ
оΰŹ渰ζͭѤ˸ŹȤäƵǽޤ
ºݤåϡȤäưŹ沽ơͤޤ
оθ˶ͭΤǡ
ƥå뤴ȤˡȤоθϰ㤤ޤ
äơȤɤå󸰤Ȥ⤤ޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Both PGP and taggnupg use hybrid ciphers.
The session key, encrypted using the public-key cipher, and the message
being sent, encrypted with the symmetric cipher, are automatically
combined in one package.
The recipient uses his private-key to decrypt the session key and the
session key is then used to decrypt the message.
]],[[dnl
PGPtaggnupgξȤ⡢ŹȤޤ
ŹǰŹ沽줿å󸰤ȡоΰŹǰŹ沽줿å
ưŪ1ĤˤޤȤޤ
ͤϡå󸰤̩Ȥơ
å˥å󸰤Ȥޤ
]])dnl
endpara

beginpara
iydraft([[dnl
A hybrid cipher is no stronger than the public-key cipher or symmetric
cipher it uses, whichever is weaker.
In PGP and taggnupg, the public-key cipher is probably the weaker of
the pair.
Fortunately, however, if an attacker could decrypt a session key it
would only be useful for reading the one message encrypted with that
session key.
The attacker would have to start over and decrypt another session
key in order to read any other message.
]],[[dnl
ŹϸŹоΰŹȤޤ顢
Τɤ餫夯⶯ʤ롢ȤȤϤޤ
PGPtaggnupgˤơ餯Ź椬夤Ǥ
⤷¦å󸰤ǤȤƤ⡢ʤȤˡϡ
Υå󸰤ǰŹ沽줿1åɤΤͭפǤ
¾Υåɤˤϡ
¦ϡǽ餫¾Υå󸰤椷ʤФʤʤǤ礦
]])dnl
endpara
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Digital signatures
,
Żҽ̾
)]])

beginpara
iydraft([[dnl
A hash function is a many-to-one function that maps its input to a
value in a finite set.
Typically this set is a range of natural numbers.
beginc inlineequation endc
A simple hash function is tagemphasis(f)(tagemphasis(x)) = 0 
for all integers tagemphasis(x).
A more interesting hash function is 
tagemphasis(f)(tagemphasis(x)) = tagemphasis(x) 
tagemphasis(mod) 37, which
maps tagemphasis(x) to the remainder of dividing tagemphasis(x) by 37.
]],[[dnl
ϥåؿϡϤͭ½Τͤ˼¿аؿǤ
̤νϡϰϤǤ
ñʥϥåؿϡ
beginc inlineequation endc
٤Ƥtagemphasis(x)ˤĤtagemphasis(f)(tagemphasis(x)) = 0Ǥ
⤦򤤥ϥåؿϡ
(tagemphasis(x)37ǳäĤtagemphasis(x))
tagemphasis(f)(tagemphasis(x)) = tagemphasis(x) 
tagemphasis(mod) 37Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
A document's digital signature is the result of applying a hash
function to the document.
To be useful, however, the hash function needs to satisfy two
important properties.
First, it should be hard to find two documents that hash to the
same value.
Second, given a hash value it should be hard to recover the document
that produced that value.
]],[[dnl
ʸŻҽ̾ϡʸؤΥϥåؿŬѷ̤Ǥ
ʤ顢ϥåؿˤʤˤϡ
2Ĥνפɬפޤ
1ˡƱϥåͤˤʤ2Ĥʸ򸫤Ĥ뤳Ȥ
Ǥ٤ȤǤ
2ˡϥåͤ򤢤줿Ȥ
ʸ뤳ȤǤ٤ȤǤ
]])dnl
endpara

beginpara
iydraft(
Some public-key ciphers,
Źΰ)[[]]tagfootnote(beginpara
iydraft([[dnl
The cipher must have the property that the actual public key or private
key could be used by the encryption algorithm as the public key.
RSA is an example of such an algorithm while ElGamal is not an example.
]],[[dnl
ΰŹϡŹ沽르ꥺˤäơ
¤θ̩ȤƻȤ롢
ȤäƤʤФʤޤ
RSAϡΤ褦ʥ르ꥺǤElGamalϤǤϤޤ
]])dnl
endpara
) iydraft(
[[dnl
could be used to sign documents.
The signer encrypts the document with his tagemphasis(private) key.
Anybody wishing to check the signature and see the document simply
uses the signer's public key to decrypt the document.
This algorithm does satisfy the two properties needed from a good hash
function, but in practice, this algorithm is too slow to be useful.
]],[[dnl
ϡʸν̾ˤȤǤ礦
̾Ԥϡtagemphasis(̩)ˤäʸŹ沽ޤ
̾åʸɤߤͤϡñʸ˽̾ԤθȤޤ
Υ르ꥺϡɤϥåؿɬפ2Ĥޤ
ºݾ塢ǤϤޤˤٲ᤮ơؤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
An alternative is to use hash functions designed to satisfy these
two important properties.
SHA and MD5 are examples of such algorithms.
Using such an algorithm, a document is signed by hashing it, and
the hash value is the signature.
Another person can check the signature by also hashing their copy of the
document and comparing the hash value they get with the hash value of
the original document.
If they match, it is almost certain that the documents are identical.
]],[[dnl
Τϡ
2Ĥνפ褦߷פ줿ϥåؿȤȤǤ
SHAMD5ϡΤ褦ʥ르ꥺǤ
Τ褦ʥ르ꥺȤȡʸϥϥå夹뤳Ȥǽ̾졢
ϥåͤ̾ˤʤޤ
¾οͤϡʸʣƱ褦˥ϥå夷
ΥϥåͤʸˤϥåͤȤӤǡ
̾åǤޤ
⤷פС
ʸʣƱǤ뤳Ȥϡ
ۤȤɳΤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
Of course, the problem now is using a hash function for digital
signatures without permitting an attacker to interfere with signature
checking.
If the document and signature are sent unencrypted, an attacker could
modify the document and generate a corresponding signature without the
recipient's knowledge.
If only the document is encrypted, an attacker could tamper with the
signature and cause a signature check to fail.
A third option is to use a hybrid public-key encryption to encrypt both
the signature and document.
The signer uses his private key, and anybody can use his public key
to check the signature and document.
This sounds good but is actually nonsense.
If this algorithm truly secured the document it would also
secure it from tampering and there would be no need for the signature.
The more serious problem, however, is that this does not protect either
the signature or document from tampering.
With this algorithm, only the session key for the symmetric cipher
is encrypted using the signer's private key.
Anybody can use the public key to recover the session key.
Therefore, it is straightforward for an attacker to recover the session
key and use it to encrypt substitute documents and signatures to send
to others in the sender's name.
]],[[dnl
Ȥʤȡϡ̾å򹶷¦˸ˡ
Żҽ̾ΤΥϥåؿȤˤϤɤ뤫ȤȤǤ
⤷ʸȽ̾Ź沽줺ʤСͤ˵դ줺ˡ
¦ʸѹν̾ǤǤ礦
⤷ʸŹ沽ʤС¦ϡ̾˴Ĥơ
åԤ뤳ȤǤǤ礦
3ϡ̾ʸξ˺Ź沽ȤȤǤ
̾Ԥ̩ȤơǤǽ̾ʸΥåǤޤ
ɤ褦ʹޤºݤϥʥ󥻥󥹤Ǥ
Υ르ꥺबʤʸݾڤʤ顢ϡ
ĤˤƤƱͤݾڤ򤹤ΤǤ顢
⤽̾ɬʤǤ礦
äȽʤΤϡ
Υ르ꥺबĤ̾ʸݸʤȤǤ
Υ르ꥺˤơоΰŹΥå󸰤Τߤ
̾Ԥ̩ǰŹ沽ޤ
Ǥ⥻å󸰤˸Ȥޤ
äơå󸰤
¦̾򤫤ä¾ͤʸȽ̾ΰŹ沽ˤȤΤϡ
¦ˤȤäƴñǤ
]])dnl
endpara

beginpara
iydraft([[dnl
An algorithm that does work is to use a public key algorithm to
encrypt only the signature.
In particular, the hash value is encrypted using the signer's private
key, and anybody can check the signature using the public key.
The signed document can be sent using any other encryption algorithm
including none if it is a public document.
If the document is modified the signature check will fail, but this
is precisely what the signature check is supposed to catch.
The Digital Signature Standard (DSA) is a public key signature 
algorithm that works as just described.
DSA is the primary signing algorithm used in tagGnupg.
]],[[dnl
ޤ르ꥺϡ̾ΰŹ沽˸르ꥺȤȤǤ
äˡϥåͤϡ̾Ԥ̩ǰŹ沽졢
Ǥǽ̾åǤޤ
̾줿ʸϡ¾ΰŹ沽르ꥺ
(⤷ʸʤ顢Ź沽ʤȤȤ⤢ꤨޤ)
뤳ȤǤޤ
ʸ񤬲󤵤С̾åϼԤޤ
Ϥޤˡ̾åθФϤΤȤǤ
Digital Signature Standard (DSA)ϡ
Ǽ줿褦ʸ̾르ꥺǤ
DSAϡtagGnupgλȤܽ̾르ꥺǤ
]])dnl
endpara

endsection
endchapter

