beginchapter(management,xreflabel="3")dnl
tagdocinfo([[$Id: c3.sgml,v 1.13 2000/08/15 01:52:50 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Key Management
,

)]])

beginpara
iydraft([[dnl
Key tampering is a major security weakness with public-key cryptography.
An eavesdropper may tamper with a user's keyrings or forge a
user's public key and post it for others to download and use.
For example, suppose Chloe wants to monitor the messages that Alice
sends to Blake.
She could mount what is called a tagfirstterm(man in the
middle) attack.
In this attack, Chloe creates a new public/private keypair.
She replaces Alice's copy of Blake's public key with the new public key.
She then intercepts the messages that Alice sends to Blake.
For each intercept, she decrypts it using the new private key, reencrypts
it using Blake's true public key, and forwards the reencrypted
message to Blake.
All messages sent from Alice to Blake can now be read by Chloe.
]],[[dnl
ĤϡŹǤΥƥ礭ʼǤ
İԤϡ桼θؤ˴ĤǤäꤷơ
¾οͤɤƻȤ褦
Ƥ⤷ޤ
ȤСAliceBlakeȤåChloe˥Ȥޤ
Chloeϡtagfirstterm(ֿ)򤷤Ǥ礦
ChloeϤιǡ̩θФ
AliceΤBlakeθʣ򿷤Ȥ꤫Ƥ顢
AliceBlakeå褳ɤꤷޤ
ΤӤChloeϡ̩椷
BlakeοθǺưŹ沽åBlakeޤ
ChloeϡAliceBlakeåɤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Good key management is crucial in order to ensure not just the integrity
of your keyrings but the integrity of other users' keyrings as well.
The core of key management in taggnupg is the notion of signing keys.
Key signing has two main purposes: it permits you to detect tampering
on your keyring, and it allows you to certify that a key truly belongs
to the person named by a user ID on the key.
Key signatures are also used in a scheme known as the tagfirstterm(web of
trust) to extend certification to keys not directly signed by you
but signed by others you trust.
Responsible users who practice good key management can defeat key
tampering as a practical attack on secure communication with taggnupg.
]],[[dnl
ʬθؤδΤߤʤ餺¾Υ桼θؤδݾڤ뤿ˤ⡢
ɤϷŪǤ
taggnupgˤ븰濴ϡؤν̾ȤͤǤ
ؤν̾ˤϡ2ĤμŪޤ
ؤδĤθФǤ뤳Ȥȡ
ˤξΥ桼IDǻꤵ줿ͤΤΤȾǤ뤳ȡ
2ĤǤ
ؤν̾ϡ
ľܤʤϽ̾ʤäʤοѤ¾οͤν̾ˤޤǾĥ뤿ᡢ
tagfirstterm(Ѥ)ȤȤߤǤȤޤ
ɤ¹ԤǤ桼ϡ
taggnupgȤΰ̿ˤŪʹȤƤθؤδĤϤͤޤ
]])dnl
endpara

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Managing your own keypair
,
ʬθФδ
)]])

beginpara
iydraft([[dnl
A keypair has a public key and a private key.
A public key consists of
the public portion of the master signing key,
the public portions of the subordinate signing and encryption subkeys, and
a set of user IDs used to associate the public key with a real person.
Each piece has data about itself.
For a key, this data includes its ID, when it was created, when it
will expire, etc.
For a user ID, this data includes the name of the real person it identifies,
an optional comment, and an email address.
The structure of the private key is similar, except that it contains only
the private portions of the keys, and there is no user ID information.
]],[[dnl
Фˤϡ̩ޤ
ϡ̾Ѽ縰θʬȡ
̤ν̾ѰŹ沽θʬ
οͤȸȤб˻Ȥ桼IDν礫ʤޤ
ʬˤϡʬȤˤĤƤΥǡޤ
ȤΥǡϡIDλޤߤޤ
桼IDȤΥǡϡƱꤹοͤ̾ǤդΥȡ
Żҥ᡼롦ɥ쥹ޤߤޤ
̩ʬΤߤޤȤȤȡ
桼ID󤬤ʤȤȤΤС
̩ι¤ϻƤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
The command-line option
taglink(edit-key,tagoption(--edit-key))
may be used to view a keypair.
For example,
]],[[dnl
Ф򸫤ˤϡ
taglink(edit-key,tagoption(--edit-key))
ޥɹԥץȤޤ
ȤС
]])dnl

beginscreen(width="80")
tagprompt(chloe%) taguserinput(gpg --edit-key chloe[[]]atmark[[]]cyb.org)
Secret key is available.

pub  1024D/26B6AAE1  created: 1999-06-15 expires: never      trust: -/u
sub  2048g/0CF8CB7A  created: 1999-06-15 expires: never
sub  1792G/08224617  created: 1999-06-15 expires: 2002-06-14
sub   960D/B1F423E7  created: 1999-06-15 expires: 2002-06-14
(1)  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
(2)  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
tagprompt(Command>)
endscreen

iydraft([[dnl
The public key is displayed along with an indication of whether
or not the private key is available.
Information about each component of the public key is then listed.
The first column indicates the type of the key.
The keyword tagliteral(pub) identifies the public master signing key,
and the keyword tagliteral(sub) identifies a public subordinate key.
The second column indicates the key's bit length, type, and ID.
The type is tagliteral(D) for a DSA key, tagliteral(g) for an
encryption-only
ElGamal key, and tagliteral(G) for an ElGamal key that may be used for
both encryption and signing.
The creation date and expiration date are given in columns three and four.
The user IDs are listed following the keys.
]],[[dnl
̵̩ͭȶ˸ɽ졢
줫γʬξ󤬥ꥹȤޤ
1ܤϡ
μ򤢤路ޤ
tagliteral(pub)ɤϸ(public)̾
tagliteral(sub)ɤϸ(subordinate)򤢤路ޤ
2ܤϡ
ΥӥåĹࡢID򤢤路ޤ
ˤϡDSAtagliteral(D)
ŹElGamaltagliteral(g)
Ź̾ξElGamaltagliteral(G)ޤ
34ܤϡ
դλ򤢤路ޤ
μ˥桼IDꥹȤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
More information about the key can be obtained with interactive commands.
The command taglink(toggle,tagcommand(toggle))
switches between the public and private
components of a keypair if indeed both components are available.
]],[[dnl
÷ޥɤǡˤĤƤ¾ξޤ
ʬ̩ʬξС
taglink(toggle,tagcommand(toggle))
ޥɤǡ
Фθʬ̩ʬؤǤޤ
]])dnl

beginscreen(width="80")
tagprompt(Command>) taguserinput(toggle)

sec  1024D/26B6AAE1  created: 1999-06-15 expires: never
sbb  2048g/0CF8CB7A  created: 1999-06-15 expires: never
sbb  1792G/08224617  created: 1999-06-15 expires: 2002-06-14
sbb   960D/B1F423E7  created: 1999-06-15 expires: 2002-06-14
(1)  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
(2)  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
endscreen

iydraft([[dnl
The information provided is similar to the listing for the public-key
component.
The keyword tagliteral(sec) identifies the private master signing key,
and the keyword tagliteral(sbb) identifies the private subordinates keys.
The user IDs from the public key are also listed for convenience.
]],[[dnl
Ǥϡʬΰ˻Ƥޤ
tagliteral(sec)ɤ̩̾
tagliteral(sbb)ɤ̩򤢤路ޤ
Τᡢ
Ȥä桼IDޤ
]])dnl
endpara

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Key integrity
,
δ
)]],[[ id="integrity"]])

beginpara
iydraft([[dnl
When you distribute your public key, you are distributing the public
components of your master and subordinate keys as well as the user IDs.
Distributing this material alone, however, is a security risk since
it is possible for an attacker to tamper with the key.
The public key can be modified by adding or substituting keys, or by
adding or changing user IDs.
By tampering with a user ID, the attacker could change the user ID's email
address to have email redirected to himself.
By changing one of the encryption keys, the attacker would
also be able to decrypt the messages redirected to him.
]],[[dnl
Ȥϡθθʬȥ桼IDΤȤǤ
¦˴ĤǤΤǡʪñϡǤ
桼IDɲá򴹤ˤäơѹǤޤ
¦ϡŻҥ᡼뤬ʬˤƤ褦
桼ID˴ĤơŻҥ᡼롦ɥ쥹ѤǤ礦
¦ϡƤ줿åǤ褦
Ź渰Τ1Ĥ򤹤꤫Ǥ礦
]])dnl
endpara

beginpara
iydraft([[dnl
Using digital signatures is a solution to this problem.
When data is signed by a private key, the corresponding public key
is bound to the signed data.
In other words, only the corresponding public key can be used to
verify the signature and ensure that the data has not been modified.
A public key can be protected from tampering by using its corresponding
private master key to sign the public key components and user IDs, thus
binding the components to the public master key.
Signing public key components with the corresponding private master
signing key is called tagfirstterm(self-signing), and a public key that has
self-signed user IDs bound to it is called a tagfirstterm(certificate).
]],[[dnl
Żҽ̾λѤؤβǤ
ǡ̩ˤäƽ̾Ȥ
бϡ̾줿ǡˤФͤޤ
ĤޤꡢбΤߤ̾θڤȡ
ǡ̵ѹݾڤ뤿˻Ȥޤ
б̩μ縰Ǹʬȥ桼ID˽̾
ĤޤΤǡ縰ξʬ򤿤Фͤ櫓Ǥ
ʬ򤽤б̩ʼ̾ǽ̾뤳Ȥ
tagfirstterm(ʽ̾)Ȥ
ʽ̾˥桼ID򤿤ФͤΤ
tagfirstterm()Ȥޤ
]])dnl
endpara

beginignore
%\begin{figure}
%Blank
%\caption{This should depict how self-signatures bind information to
%a public key.}\label{fig:selfsignedkey}
%\end{figure}
%
%As an example, Figure~\ref{fig:selfsignedkey} illustrates Chloe's public
%key, which has been self-signed to bind the user IDs and public subkeys
%to the public master key.
%The signatures on the user IDs can be checked with the \texttt{check}
%command from the key edit menu.
endignore

beginpara
iydraft([[dnl
As an example, Chloe has two user IDs and three subkeys.
The signatures on the user IDs can be checked with the command
taglink(check,tagcommand(check)) from the key edit menu.
]],[[dnl
ȤChloeϡ2ĤΥ桼ID3ĤäƤޤ
桼IDν̾ΥåˤϡԽ˥塼
taglink(check,tagcommand(check))
ޥɤȤޤ
]])dnl

beginscreen(width="80")
tagprompt(chloe%) taguserinput(gpg --edit-key chloe)
Secret key is available.

pub  1024D/26B6AAE1  created: 1999-06-15 expires: never      trust: -/u
sub  2048g/0CF8CB7A  created: 1999-06-15 expires: never
sub  1792G/08224617  created: 1999-06-15 expires: 2002-06-14
sub   960D/B1F423E7  created: 1999-06-15 expires: 2002-06-14
(1)  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
(2)  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>

tagprompt(Command>) taguserinput(check)
uid  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
sig!	   26B6AAE1 1999-06-15	 [self-signature]
uid  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
sig!	   26B6AAE1 1999-06-15	 [self-signature]
endscreen

iydraft([[dnl
As expected, the signing key for each signature is the master signing
key with key ID tagliteral(0x26B6AAE1).
The self-signatures on the subkeys are present in the public key, but
they are not shown by the taggnupg interface.
]],[[dnl
ͽۤɤꡢƽ̾Ѥν̾ϡ
ID[[]]tagliteral(0x26B6AAE1)μ̾Ǥ
μʽ̾ϸˤޤtaggnupgΥ󥿥եǤϸޤ
]])dnl
endpara
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Adding and deleting key components
,
ʬɲá
)]])

beginpara
iydraft([[dnl
Both new subkeys and new user IDs may be added to your keypair after
it has been created.
A user ID is added using the command
taglink(adduid,tagcommand(adduid)).
You are prompted for a real name, email address, and comment just
as when you create an initial keypair.
A subkey is added using the command
taglink(addkey,tagcommand(addkey)).
The interface is similar to the interface used when creating an initial
keypair.
The subkey may be a DSA signing key, and encrypt-only ElGamal
key, or a sign-and-encrypt ElGamal key.
When a subkey or user ID is generated it is self-signed using your
master signing key, which is why you must supply your passphrase
when the key is generated.
]],[[dnl
Ф塢桼ID⿷ɲäǤޤ
桼IDɲäˤϡ
taglink(adduid,tagcommand(adduid))
ޥɤȤޤ
̾᡼롦ɥ쥹ơ
礦ɺǽθФȤΤ褦ʥȤϥץץȤǤޤ
ɲäˤϡ
taglink(addkey,tagcommand(addkey))
ޥɤȤޤ
Υ󥿥եϡǽθФΤȤΤȻƤޤ
ϡDSA̾ŹElGamal̾ŹξElGamalΤɤ줫Ǥ
桼IDȤ̾Ǽʽ̾Τǡ
ˡѥե졼ꤷʤФʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Additional user IDs are useful when you need multiple identities.
For example, you may have an identity for your job and an identity
for your work as a political activist.
Coworkers will know you by your work user ID.
Coactivists will know you by your activist user ID.
Since those groups of people may not overlap, though, each group
may not trust the other user ID.
Both user IDs are therefore necessary.
]],[[dnl
ʣοʬΤȤ桼IDɲäǤ
ȤС̳οʬȡ
ưȤȤƤκѤοʬ뤫⤷ޤ
ʤƱνϡ̳桼IDΤʤΤäƤǤ礦
ʤƱ֤ϡưȥ桼IDΤʤΤäƤǤ礦
줾֤ͤϽŤʤʤ⤷ʤΤǡ
ƥ롼פϡ⤦Υ桼IDѤʤ⤷ޤ
äơξΥ桼IDޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Additional subkeys are also useful.
The user IDs associated with your public master key are validated by
the people with whom you
communicate, and changing the master key therefore requires recertification.
This may be difficult and time consuming if you communicate with
many people.
On the other hand, it is good to periodically change encryption subkeys.
If a key is broken, all the data encrypted with that key will be
vulnerable.
By changing keys, however, only the data encrypted with the one broken
key will be revealed.
]],[[dnl
ޤɲäǤ
縰б桼IDϡ
̿ˤäͭˤΤǡ
縰ѹˤϡƾޤ
⤷¿οͤ̿ʤ顢񤷤֤뤫⤷ޤ
Ź沽Ūʸ򴹤ϡɤȤǤ
⤷줿顢θǰŹ沽줿ǡϡ䤦Ǥ礦
򴹤ƤС
Τϡ줿ǰŹ沽줿ǡǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
Subkeys and user IDs may also be deleted.
To delete a subkey or user ID you must first select it using the
taglink(key,tagcommand(key)) or
taglink(uid,tagcommand(uid)) commands respectively.
These commands are toggles.
For example, the command tagcommand(key tagparameter(2))
selects the second subkey,
and invoking tagcommand(key tagparameter(2)) again
deselects it.
If no extra argument is given, all subkeys or user IDs are deselected.
Once the user IDs to be deleted are selected, the command
taglink(deluid,tagcommand(deluid))
actually deletes the user IDs from your key.
Similarly, the command taglink(delkey,tagcommand(delkey))
deletes all selected subkeys from both your public and private keys.
]],[[dnl
桼IDϡ⤵뤫⤷ޤ
桼IDˤϡơ
taglink(key,tagcommand(key))
ޥɤ
taglink(uid,tagcommand(uid))
ޥɤǡޤ򤷤ƤʤФʤޤ
ΥޥɤϡȥǤ
ȤСtagcommand(key tagparameter(2))ޥɤϡ
2ܤ򤷤ޤ
tagcommand(key tagparameter(2))ƵưȡȤޤ
ʤȡ桼IDȤޤ
桼ID򤤤ä򤹤ȡ
taglink(deluid,tagcommand(deluid))ޥɤǡ
桼ID˺Ǥޤ
Ʊͤˡtaglink(delkey,tagcommand(delkey))ޥɤǡ
̩ξ򤵤줿٤ƤǤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
For local keyring management, deleting key components is a good way
to trim other people's public keys of unnecessary material.
Deleting user IDs and subkeys on your own key, however, is not always
wise since it complicates key distribution.
By default, when a user imports your updated public key it will be merged
with the old copy of your public key on his ring if it exists.
The components from both keys are combined in the merge, and this
effectively restores any components you deleted.
To properly update the key, the user must first delete the old version
of your key and then import the new version.
This puts an extra burden on the people with whom you communicate.
Furthermore, if you send your key to a keyserver, the merge will
happen regardless, and anybody who downloads your key from a keyserver
will never see your key with components deleted.
Consequently, for updating your own key it is better to revoke key
components instead of deleting them.
]],[[dnl
ʸشΤᡢΰΤϡ
¾οͤθɬפʬ򤽤ȤɤˡǤ
ʤ顢ʣˤʤ뤿ᡢ
ʬθΥ桼IDκϾ˸Ȥϸ¤ޤ
Ǥϡ
桼ʤι줿ɤ߹Ȥ
⤷οͤ˸ؤСʤθŤʣʻ礵Ǥ礦
θγʬϡʻˤȤ߹蘆졢
ʬ̤ޤ
ȹˤϡ桼ϡ
ǽˤʤθŤƤ顢ɤ߹ޤʤФʤޤ
ϡʤ̿;פôˤʤޤ
ޤСؤʤθäƤʻϵƤޤ
С餢ʤθɤͤˤϳ
줿ʬΤʤ褦˸Ǥ礦
äơʬθ򹹿ˤϡ
ΤǤϤʤΰ˴ɤΤǤ
]])dnl
endpara
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Revoking key components
,
ΰ˴
)]])

beginpara
iydraft([[dnl
To revoke a subkey it must be selected.
Once selected it may be revoked with the
taglink(revkey,tagcommand(revkey)) command.
The key is revoked by adding a revocation self-signature to the key.
Unlike the command-line option tagoption(--gen-revoke), the effect of
revoking a subkey is immediate.
]],[[dnl
˴ˤϡޤ򤷤ƤʤФʤޤ
򤤤ä򤹤ȡ
taglink(revkey,tagcommand(revkey))
ޥɤ˴뤳ȤǤޤ
˴ϡ˴ʽ̾򸰤˲ä뤳Ȥˤޤ
tagoption(--gen-revoke)ޥɹԥץȰ㤤
˴θ̤¨Ǥ
]])dnl
endpara

beginscreen(width="80")
tagprompt(Command>) taguserinput(revkey)
Do you really want to revoke this key? y

You need a passphrase to unlock the secret key for
user: "Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>"
1024-bit DSA key, ID B87DBA93, created 1999-06-28


pub  1024D/B87DBA93  created: 1999-06-28 expires: never      trust: -/u
sub  2048g/B7934539  created: 1999-06-28 expires: never
sub  1792G/4E3160AD  created: 1999-06-29 expires: 2000-06-28
rev! subkey has been revoked: 1999-06-29
sub   960D/E1F56448  created: 1999-06-29 expires: 2000-06-28
(1)  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
(2)  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
endscreen

beginpara
iydraft([[dnl
A user ID is revoked differently.
Normally, a user ID collects signatures that attest that the user ID
describes the person who actually owns the associated key.
In theory, a user ID describes a person forever, since that person will
never change.
In practice, though, elements of the user ID such as the email address
and comment may change over time, thus invalidating the user ID.
]],[[dnl
桼ID˴ϡäȰ㤤ޤ
̡б븰μºݤλȤߤʤ̾ϡ桼IDǽޤ
塢
ͤѹϷ褷ƤʤΤǡ
桼IDϱʵפƱͤ򤢤路ޤ
Ǥºݾ塢Żҥ᡼롦ɥ쥹䥳ȤȤä桼IDǤϡ
ΤĤˤĤѤꤦΤʤΤǡ
桼ID̵ˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
The OpenPGP
begincomment()First reference to OpenPGP[[]]endcomment
specification does not support user ID revocation, but
a user ID can effectively be revoked by revoking the self-signature
on the user ID.
For the security reasons described
taglink(integrity,previously),
correspondents will not trust a user ID with no valid self-signature.
]],[[dnl
OpenPGP
begincomment()First reference to OpenPGP[[]]endcomment
ͤϡ桼ID˴ٱ礷Ƥޤ󤬡
桼IDˤĤƤμʽ̾˴ˤꡢƱ̤ˤʤޤ
taglink(integrity,)˼ƥͳΤᡢ
ͭʼʽ̾ʤȡ̿ϥ桼IDѤʤǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
A signature is revoked by using the command
taglink(revsig,tagcommand(revsig)).
Since you may have signed any number of user IDs, the user interface
prompts you to decide for each signature whether or not to revoke it.
]],[[dnl
̾˴ˤϡ
taglink(revsig,tagcommand(revsig))
ޥɤȤޤ
桼IDؤν̾ϤĤ⤢뤫⤷ʤΤǡ
̾Τ줾ˤĤơ˴뤫ɤ褦
ʤ桼󥿥եˤʤäƤޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(Command>) taguserinput(revsig)
You have signed these user IDs:
     Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
   signed by B87DBA93 at 1999-06-28
     Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
   signed by B87DBA93 at 1999-06-28
user ID: "Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>"
signed with your key B87DBA93 at 1999-06-28
Create a revocation certificate for this signature? (y/N)n
user ID: "Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>"
signed with your key B87DBA93 at 1999-06-28
Create a revocation certificate for this signature? (y/N)y
You are about to revoke these signatures:
     Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
   signed by B87DBA93 at 1999-06-28
Really create the revocation certificates? (y/N)y

You need a passphrase to unlock the secret key for
user: "Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>"
1024-bit DSA key, ID B87DBA93, created 1999-06-28


pub  1024D/B87DBA93  created: 1999-06-28 expires: never      trust: -/u
sub  2048g/B7934539  created: 1999-06-28 expires: never
sub  1792G/4E3160AD  created: 1999-06-29 expires: 2000-06-28
rev! subkey has been revoked: 1999-06-29
sub   960D/E1F56448  created: 1999-06-29 expires: 2000-06-28
(1)  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
(2)  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
endscreen

beginpara
iydraft([[dnl
A revoked user ID is indicated by the revocation signature on
the ID when the signatures on the key's user IDs are listed.
]],[[dnl
Υ桼IDؤν̾Ǥϡ
˴줿桼ID򤽤IDؤ˴̾Ǽޤ
]])dnl
endpara

beginscreen(width="80")
tagprompt(Command>) taguserinput(check)
uid  Chloe (Jester) taglt()chloe[[]]atmark[[]]cyb.org>
sig!	   B87DBA93 1999-06-28	 [self-signature]
uid  Chloe (Plebian) taglt()chloe[[]]atmark[[]]tel.net>
rev!	   B87DBA93 1999-06-29	 [revocation]
sig!	   B87DBA93 1999-06-28	 [self-signature]
endscreen

beginpara
iydraft([[dnl
Revoking both subkeys and self-signatures on user IDs adds revocation
self-signatures to the key.
Since signatures are being added and no material is deleted, a
revocation will always be visible to others when your updated public
key is distributed and merged with older copies of it.
Revocation therefore guarantees that everybody has a consistent
copy of your public key.
]],[[dnl
ȥ桼IDؤμʽ̾ξ˴ȡ
˴ʽ̾˲äޤ
̾ϲä졢ȤʤΤǡ
Ťʣʻ礷ȤïˤȤäƤ˴ˤʤޤ
äơ٤ƤοͤʤθΰӤʣäƤȤȤ
˴ݾڤޤ
]])dnl
endpara
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Updating a key's expiration time
,
ι
)]])

beginpara
iydraft([[dnl
The expiration time of a key may be updated with the command
taglink(expire,tagcommand(expire)) from the key edit menu.
If no key is selected the expiration time of the primary key
is updated.
Otherwise the expiration time of the selected subordinate key
is updated.
]],[[dnl
򹹿ˤϡԽ˥塼
taglink(expire,tagcommand(expire))
ޥɤȤޤ
򤷤ƤС򤷤郎ޤ
ǤʤС縰郎ޤ
]])dnl
endpara

beginpara
iydraft([[dnl
A key's expiration time is associated with the key's self-signature.
The expiration time is updated by deleting the old self-signature
and adding a new self-signature.
Since correspondents will not have deleted the old self-signature, they
will see an additional self-signature on the key when they update
their copy of your key.
The latest self-signature takes precedence, however, so all correspondents
will unambiguously know the expiration times of your keys.
]],[[dnl
ϡμʽ̾бƤޤ
Ťʽ̾ơʽ̾ä뤳Ȥǡ򹹿Ǥޤ
ʤθŤʽ꤬̾̿ꤹ̤ǤǤʤС
ʣ򹹿Ȥ˼ʽ̾ɲä褦˸ϤǤ
ʽ̾ͥʤΤǡäơ̿ϳ
ʤθ郎Ϥä狼Ǥ礦
]])dnl
endpara
endsubsection
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Validating other keys on your public keyring
,
ؤ¾θͭ
)]])

beginpara
iydraft([[dnl
In Chapter tagxref(intro) a procedure was given to validate your
correspondents' public keys: a correspondent's key is validated by
personally checking his key's fingerprint and then signing his public
key with your private key.
By personally checking the fingerprint you can be sure that the
key really does belong to him, and since you have signed they key, you
can be sure to detect any tampering with it in the future.
Unfortunately, this procedure is awkward when either you must validate
a large number of keys or communicate with people whom you do not
know personally.
]],[[dnl
ξtagxref(intro)ˤơ
̿θͭˤˡ򼨤ޤ
̤˸λåʤ̩Ǥοͤθؽ̾뤳Ȥǡ
̿θͭˤʤޤ
̤λΥåǡ
θºݤΤΤǤȳοȤˤʤޤ
̾ˤꡢ褤ʤ봳ĤǤɬФǤ뤳Ȥˤʤޤ
¿θͭˤȤ䡢
ĿŪˤΤʤͤ̿ʤФʤʤȤ
ǰʤ餳ˡǤѤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
tagGnupg addresses this problem with a mechanism popularly known
as the tagfirstterm(web of trust).
In the web of trust model, responsibility for validating public
keys is delegated to people you trust.
For example, suppose
]],[[dnl
tagGnupgǤϡ
tagfirstterm(Ѥ)ȤȤߤǤн褷ޤ
ѤؤΥǥˤơ
ͭˤǤϡʤοѤͤ˰ޤ
ȤСΤ褦ʾͤޤ礦
]])dnl
iftexi([[
]])dnl
beginitemizedlist(spacing="compact")
atitem
beginlistitem
beginpara
iydraft([[dnl
Alice has signed Blake's key, and
]],[[dnl
AliceBlakeθ˽̾ơ
]])dnl
endpara
endlistitem
atitem
beginlistitem
beginpara
iydraft([[dnl
Blake has signed Chloe's key and Dharma's key.
]],[[dnl
BlakeChloeθDharmaθ˽̾
]])dnl
endpara
endlistitem
enditemizedlist

iydraft([[dnl
If Alice trusts Blake to properly validate keys that he signs, then
Alice can infer that Chloe's and Dharma's keys are valid without
having to personally check them.
She simply uses her validated copy of Blake's public key to
check that Blake's signatures on Chloe's and Dharma's are good.
In general, assuming that Alice fully trusts everybody to properly
validate keys they sign, then any key signed by a valid key is also
considered valid.
The root is Alice's key, which is axiomatically assumed to be valid.
]],[[dnl
⤷Blakeν̾븰ϤͭˤƤ롢AliceοʤС
̤˥åޤǤʤChloeDharmaθͭAliceϿǤޤ
ChloeDharmaθξBlakeν̾ɤɤåˤϡ
ͭBlakeθʣñ˻ȤǤ
̤ˡν̾ǤŬڤͭǧ롢Aliceʬοʤ顢
ͭʸǽ̾줿븰ϡƱͤͭȹͤޤ
κϡͭȤߤʤAliceθǤ
]])dnl
endpara

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Trust in a key's owner
,
λˤ뿮
)]])

beginpara
iydraft([[dnl
In practice trust is subjective.
For example, Blake's key is valid to Alice since she signed it, but she
may not trust Blake to properly validate keys that he signs.
In that case, she would not take Chloe's and Dharma's key as valid
based on Blake's signatures alone.
The web of trust model accounts for this by associating with each
public key on your keyring an indication of how much you trust the
key's owner.
There are four trust levels.
]],[[dnl
ºݡѤȤϼŪʤΤǤ
ȤСAlice̾򤹤뤫顢BlakeθAliceˤȤäƤͭˤʤΤǤ
AliceϡBlakeν̾븰ͭˤƤȤϡ
οʤ⤷ޤ
Τ褦ʾ硢AliceϡBlakeν̾Ǥϡ
ChloeDharmaθͭȤϹͤʤǤ礦
ѤإǥǤϡؤγƸ˸λο٤б뤳Ȥǡ
Τ櫓ޤ
4Ĥοѥ٥뤬ޤ
]])dnl

beginvariablelist
beginvarlistentry
beginterm
iydraft(
unknown
,
̤
)dnl
endterm
beginlistitem
beginpara
iydraft([[dnl
Nothing is known about the owner's judgment in key signing.
Keys on your public keyring that you do not own initially have
this trust level.
]],[[dnl
ν̾ˤȽǤˤĤƤϡ狼ʤ
ʤθؾˤ¾ͤθϡޤΥ٥ˤʤޤ
]])dnl
endpara
endlistitem
endvarlistentry
beginvarlistentry
beginterm
iydraft(
none
,
Ѥʤ
)dnl
endterm
beginlistitem
beginpara
iydraft([[dnl
The owner is known to improperly sign other keys.
]],[[dnl
礬¾θŬʽ̾򤹤롢
Ȥ狼äƤ롣
]])dnl
endpara
endlistitem
endvarlistentry
beginvarlistentry
beginterm
iydraft(
marginal
,
ٿѤ
)dnl
endterm
beginlistitem
beginpara
iydraft([[dnl
The owner understands the implications of key signing and
properly validates keys before signing them.
]],[[dnl
ϸν̾ΰ̣򤷡̾˸ͭˤ롣
]])dnl
endpara
endlistitem
endvarlistentry
beginvarlistentry
beginterm
iydraft(
full
,
˿Ѥ
)dnl
endterm
beginlistitem
beginpara
iydraft([[dnl
The owner has an excellent understanding of key signing,
and his signature on a key would be as good as your own.
]],[[dnl
ϸν̾ˤ褯򤷤Ƥơ
븰ؤΤοͤν̾ϡʬȤν̾Ʊ餤ɤ
]])dnl
endpara
endlistitem
endvarlistentry
endvariablelist

iydraft([[dnl
A key's trust level is something that you alone assign to the
key, and it is considered private information.
It is not packaged with the key when it is exported; it is even
stored separately from your keyrings in a separate database.
]],[[dnl
οѥ٥ϡʤ˳ƤΤǡ̩Ȥߤʤޤ
񤭽ФȤ⡢˽񤫤줿Ϥޤ
Ǽ⸰ؤȤ̤ǡ㤦ǡ١ˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
The taggnupg key editor may be used to adjust your trust in a key's owner.
The command is taglink(trust,tagcommand(trust)).
In this example Alice edits her trust in Blake and then updates
the trust database to recompute which keys are valid based on her new
trust in Blake.
]],[[dnl
λˤ뿮٤ԽˤϡtaggnupgǥȤޤ
Υޥɤϡtaglink(trust,tagcommand(trust))Ǥ
ǡAliceBlakeؤο٤ԽƤޤ
θ塢Blakeˤ뿷٤ˤäơɤθͭƷ׻
ѥǡ١򹹿ޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --edit-key blake)

pub  1024D/8B927C8A  created: 1999-07-02 expires: never      trust: q/f
sub  1024g/C19EA233  created: 1999-07-02 expires: never
(1)  Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>

tagprompt(Command>) taguserinput(trust)
pub  1024D/8B927C8A  created: 1999-07-02 expires: never      trust: q/f
sub  1024g/C19EA233  created: 1999-07-02 expires: never
(1)  Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>

Please decide how far you trust this user to correctly
verify other users' keys (by looking at passports,
checking fingerprints from different sources[[]]tagdots)?

 1 = Don't know
 2 = I do NOT trust
 3 = I trust marginally
 4 = I trust fully
 s = please show me more information
 m = back to the main menu

tagprompt(Your decision?) taguserinput(3)

pub  1024D/8B927C8A  created: 1999-07-02 expires: never      trust: m/f
sub  1024g/C19EA233  created: 1999-07-02 expires: never
(1)  Blake (Executioner) taglt()blake[[]]atmark[[]]cyb.org>

tagprompt(Command>) taguserinput(quit)
[tagdots]
endscreen

iydraft([[dnl
Trust in the key's owner and the key's validity are indicated to the
right when the key is displayed.
Trust in the owner is displayed first and the key's validity is
second[[]]tagfootnote([[
beginpara
tagGnupg overloads the word tagldquo()trust[[]]tagrdquo by using it to mean
trust in an owner and trust in a key.
This can be confusing.
Sometimes trust in an owner is referred to as
tagfirstterm(owner-trust) to
distinguish it from trust in a key.
Throughout this manual, however, tagldquo()trust[[]]tagrdquo is used to
mean trust in a key's
owner, and tagldquo()validity[[]]tagrdquo is used to mean trust that a key
belongs to the human associated with the key ID.
endpara
]]).
]],[[dnl
ɽȡλˤ뿮Ѥ丰ͭα˼ޤ
ˤ뿮Ѥǽ顢ͭǤtagfootnote(
beginpara
tagGnupgǤϡ
ˤ뿮Ѥ丰ˤ뿮ѤȤ̣ǡ
ֿѡפȤȤФȤޤΤȤƱꤨޤ
ˤ뿮Ѥȶ̤뤿ᡢ
ˤ뿮Ѥϡ
Ȥɤtagfirstterm(ο)Ȥޤ
Υޥ˥奢ΤȤǡֿѡפϡ
λˤ뿮Ѥ̣Τ˻Ȥ
ͭפϡ
IDбƤʹ֤νͭȤѤ̣Τ˻Ȥޤ
endpara
)
]])dnl
iydraft([[dnl
The four trust/validity levels are abbreviated: unknown (tagliteral(q)),
none (tagliteral(n)), marginal (tagliteral(m)), and
full (tagliteral(f)).
In this case, Blake's key is fully valid since Alice signed it herself.
She initially has an unknown trust in Blake to properly sign other keys
but decides to trust him marginally.
]],[[dnl
4ο/ͭΥ٥ϡ̤ΤΤȤtagliteral(q)
Ѥʤ(none)Ȥtagliteral(n)
ٿѤ(marginal)Ȥtagliteral(m)
˿Ѥ(full)Ȥtagliteral(f)ṳ̂ޤ
ξ硢Aliceϼʬǽ̾򤷤ΤǡBlakeθϴͭǤ
¾θŬڤ˽̾뤿ᡢBlakeˤ뿮ѤϽ̤Τξ֤Ǥ
Ѥ뤳Ȥˤޤ
]])dnl
endpara
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Using trust to validate keys
,
ͭˤ뤿οѤλ
)]])

beginpara
iydraft([[dnl
The web of trust allows a more elaborate algorithm to be used to
validate a key.
Formerly, a key was considered valid only if you signed it personally.
beginc HERE, math endc
A more flexible algorithm can now be used: a key tagemphasis(K) is considered valid
if it meets two conditions:
]],[[dnl
ѤؤǸͭˤΤˡʥ르ꥺबȤޤ
ĿŪ˽̾ȤͭȤߤʤޤ
ǤϤäȽʥ르ꥺबȤޤ
⤷2Ĥξȡ
beginc HERE, math endc
tagemphasis(K)ϡͭȤߤʤޤ
]])dnl
iftexi([[
]])dnl
beginorderedlist(spacing="compact")
atitem
beginlistitem
beginpara
iydraft([[dnl
it is signed by enough valid keys, meaning
]],[[dnl
ʬͭʸǽ̾줿Ĥޤꡢ
]])dnl
beginitemizedlist(spacing="compact")
atitem
beginlistitem
beginpara
iydraft([[dnl
you have signed it personally,
]],[[dnl
ʤĿŪ˽̾򤷤
]])dnl
endpara
endlistitem
atitem
beginlistitem
beginpara
iydraft([[dnl
it has been signed by one fully trusted key, or
]],[[dnl
ޤϡ1Ĥδ˿Ѥ줿ǽ̾줿
]])dnl
endpara
endlistitem
atitem
beginlistitem
beginpara
iydraft([[dnl
it has been signed by three marginally trusted keys; and
]],[[dnl
ޤϡ3ĤΤٿѤ줿ǽ̾줿
]])dnl
endpara
endlistitem
enditemizedlist
iydraft(,
ˡ
)dnl
endpara
endlistitem
atitem
beginlistitem
beginpara
iydraft([[dnl
beginc HERE, math endc
the path of signed keys leading from tagemphasis(K) back
to your own key is five steps or shorter.
]],[[dnl
beginc HERE, math endc
̾줿tagemphasis(K)鼫ʬθϩϡ
5ƥåװʲ
]])dnl
endpara
endlistitem
endorderedlist

iydraft([[dnl
The path length, number of marginally trusted keys required, and number
of fully trusted keys required may be adjusted.
The numbers given above are the default values used by taggnupg.
]],[[dnl
ϩĹٿѤ줿ɬ׿˿Ѥ줿ɬ׿ϡ
ĴǤޤ
Ǽϡ
taggnupgǤδͤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
tagxref(wot-examples) shows a web of trust rooted at Alice.
The graph illustrates who has signed who's keys.
The table shows which keys Alice considers valid based on her
trust in the other members of the web.
begincomment()Potential bug: tagoption(--completes-needed) on command
line seems to be ignored when combined with tagoption(--update-trustdb).
Value is taken correctly if put in options file, however.endcomment
This example assumes that two marginally-trusted keys or one
fully-trusted key is needed to validate another key.
The maximum path length is three.
]],[[dnl
tagxref(wot-examples)ϡAlice򺬸ˤѤؤ򼨤ޤ
դϡïïθ˽̾Τ򤢤路Ƥޤ
ɽϡؤ¾ΥСˤAliceοѤ˴Ťơ
Aliceɤθͭȹͤ뤫򼨤Ƥޤ
begincommentŪХ:
tagoption(--update-trustdb)ȷ礵줿Ȥ
ޥɹԤtagoption(--completes-needed)ϡ
̵뤵褦
ץ󡦥եСͤȤ롣endcomment
ǤϡٿѤ줿2Ĥθ佽ʬ˿Ѥ줿1Ĥθ
¾θͭˤΤɬסȲꤷޤ
Ĺηϩϡ3Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
When computing valid keys in the example, Blake and Dharma's are
always considered fully valid since they were signed directly
by Alice.
The validity of the other keys depends on trust.
In the first case, Dharma is trusted fully, which implies
that Chloe's and Francis's keys will be considered valid.
In the second example, Blake and Dharma are trusted marginally.
Since two marginally trusted keys are needed to fully validate a
key, Chloe's key will be considered fully valid, but Francis's
key will be considered only marginally valid.
In the case where Chloe and Dharma are marginally trusted,
Chloe's key will be marginally valid since Dharma's key is
fully valid.
Francis's key, however, will also be considered marginally
valid since only a fully valid key can be used to validate
other keys, and Dharma's key is the only fully valid key
that has been used to sign Francis's key.
When marginal trust in Blake is added, Chloe's key becomes
fully valid and can then be used to fully validate Francis's
key and marginally validate Elena's key.
Lastly, when Blake, Chloe, and Elena are fully trusted, this is
still insufficient to validate Geoff's key since the maximum
certification path is three, but the path length from Geoff
back to Alice is four.
]],[[dnl
ͭʸη׻ǤϡAliceľܽ̾ᡢ
BlakeDharmaθϡ˽ʬͭȹͤޤ
¾θͭϡѤˤäѤޤ
ǽξ硢Dharmaϡ˿Ѥޤ
ΤChloeFrancisθͭǤȹͤ뤳Ȥˤʤޤ
ˤơBlakeDharmaϡٿѤޤ
1ĤθʬͭˤˤϤٿѤ줿2ĤθɬפʤΤǡ
ChloeθϡʬͭȹͤǤ礦
FrancisθϡͭǤȤͤǤ礦
ChloeDharmaٿѤ硢
DharmaθʬͭʤΤǡChloeθϡͭǤ礦
ʬͭʸΤߤ¾θͭˤ뤿˻Ȥ뤳Ȥȡ
Francisθؤν̾˻Ȥ줿ͣνʬͭʸDharmaθǤ뤳Ȥ顢
Francisθ⤢ͭȹͤޤ
Blakeˤ뤢٤οѤäȤChloeθϽʬͭˤʤꡢ
줫Francisθʬͭˤ
Elenaθ򤢤ͭˤ뤿ˤȤޤ
ǸˡBlakeChloeElena˿Ѥ硢ϡ
ξϩ3ǤGeoffХåAliceޤǤηϩĹ4ʤΤǡ
GeoffθͭˤˤϡޤԽʬǤ
]])dnl
endpara

beginpara
iydraft([[dnl
The web of trust model is a flexible approach to the problem of safe
public key exchange.
It permits you to tune taggnupg to reflect how you use it.
At one extreme you may insist on multiple, short paths from your
beginc HERE, math endc
key to another key tagemphasis(K) in order to trust it.
On the other hand, you may be satisfied with longer paths and
beginc HERE, math endc
perhaps as little as one path from your key to the other
key tagemphasis(K).
beginc HERE, math endc
Requiring multiple, short paths is a strong guarantee
that tagemphasis(K) belongs to whom your think it does.
The price, of course, is that it is more difficult to validate keys
since you must personally sign more keys than if you accepted fewer
and longer paths.
]],[[dnl
Ѥإǥϡʸ򴹤ؤνʥץǤ
ˤꡢʤλȤˤ碌taggnupgĴǤޤ
üǤϡʤϿѤΤᡢʬθ¾θ
beginc HERE, math endc
tagemphasis(K)ޤʣûϩˤ뤫⤷ޤ
ΰʤϡʬθ⤦θ
beginc HERE, math endc
tagemphasis(K)ޤǤΡ
ϩĹ٤ιĹϩ­Ƥ뤫⤷ޤ
ʣûϩɬפȤ뤳Ȥϡ
°Ȥʤιͤtagemphasis(K)°뤳ȤζݾڤǤ
ʤ˾ʤĹϩ줿ʤС
ꤢʤĿŪ˹¿θ˽̾ʤФʤʤΤǡ
ͭ񤷤ʤ뤳ȤǤ
]])dnl
endpara

beginfigure(wot-examples)
tagtitle([[iyiftexi([[dnl]])
iydraft(
A hypothetical web of trust
,
οѤ
)]])
beginignore
The graph indicates who has signed who's keys.
The table, in which names have been abbreviated, shows which keys are
valid depending on how Alice trusts other members in the web.
Alice considers different keys valid depending on how she trusts
the members of the web.
endignore

<mediaobject>
  <!-- using marked sections here is not the perfect solution but
       until we have figured out how to modify the stylesheets to
       prefer one format over another depending on the backend,
       we can do it this way.
       The current TeX stylesheet takes only the first imageobject
       We do mark only the first imageobject so that the mediaobject
       is valid without requiring to do an nsgmls -i foo.
  -->
  <![ %tex; [
  <imageobject>
    <imagedata fileref="signatures.eps" format="eps">
  </imageobject>
  ]]>
  <imageobject>
    <imagedata fileref="signatures.jpg" format="jpg">
  </imageobject>
  <textobject>
     <phrase>A graph indicating who has signed who's key</phrase>
  </textobject>
  <textobject>
     <para>
      Some longer blurb to verbal describe the excact content
      of the image.  This may be of use for a Braille display.
     </para>
  </textobject>
</mediaobject>


begininformaltable([[ frame="all"]])
begintgroup(4)
tagcolspec(one,1)
tagcolspec(two,2)
tagcolspec(three,3)
tagcolspec(four,4)
tagspanspec(lefthalf,one,two)
tagspanspec(righthalf,three,four)

tag3thead([[tagrow([[tagentryspanname(lefthalf,trust)
tagentryspanname(righthalf,validity)]])
tagrow([[tagentryaligncenter(marginal)
tagentryaligncenter(full)
tagentryaligncenter(marginal)
tagentryaligncenter(full)]])]])
tagtbody([[tagrow([[tag1entry
tag1entry(Dharma)
tag1entry
tag1entry([[Blake, Chloe, Dharma, Francis]])]])

tagrow([[tag1entry([[Blake, Dharma]])
tag1entry
tag1entry(Francis)
tag1entry([[Blake, Chloe, Dharma]])]])

tagrow([[tag1entry([[Chloe, Dharma]])
tag1entry
tag1entry([[Chloe, Francis]])
tag1entry([[Blake, Dharma]])]])

tagrow([[tag1entry([[Blake, Chloe, Dharma]])
tag1entry
tag1entry(Elena)
tag1entry([[Blake, Chloe, Dharma, Francis]])]])

tagrow([[tag1entry
tag1entry([[Blake, Chloe, Elena]])
tag1entry
tag1entry([[Blake, Dharma, Chloe, Elena, Francis]])]])]])
endtgroup
endinformaltable
endfigure
endsubsection
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Distributing keys
,

)]])

beginpara
iydraft([[dnl
Ideally, you distribute your key by personally giving it to your
correspondents.
In practice, however, keys are often distributed by email or some
other electronic communication medium.
Distribution by email is good practice when you have only a few
correspondents, and even if you have many correspondents, you can use
an alternative means such as posting your public key on your World Wide
Web homepage.
This is unacceptable, however, if people who need your public key do
not know where to find it on the Web.
]],[[dnl
ŪʸϡʤĿŪ̿˸򤢤뤳ȤǤ
ºݾ塢ϤФСŻҥ᡼¾Ż̿Τޤ
꤬̿ۤξʤ顢Żҥ᡼ˤϡɤǤ
꤬̿¿Ƥ⡢
ʬΥɡ磻ɡ֡ۡࡦڡǸ򼨤
ȤäˡȤޤ
⤷ʤθɬפȤͤ
֤ΤɤˤΤΤʤС̵Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
To solve this problem public key servers are used to collect
and distribute public keys.
A public key received by the server is either added to the server's
database or merged with the existing key if already present.
When a key request comes to the server, the server consults its
database and returns the requested public key if found.
]],[[dnl
褹뤿ˡСǡ
򽸤᤿ꡢꤷޤ
Сμäϡǡ١˲ä줿ꡢ
⤷С¸θʻ礵줿ꤷޤ
׵᤬СϤȡСϥǡ١򸫤ơ
⤷ĤС׵ᤵ줿֤ޤ
]])dnl
endpara

beginpara
iydraft([[dnl
A keyserver is also valuable when many people are frequently signing other
people's keys.
Without a keyserver, when Blake sign's Alice's key then Blake would send
Alice a copy of her public key signed by him so that Alice could
add the updated key to her ring as well as distribute it to all of her
correspondents.
Going through this effort fulfills Alice's and Blake's responsibility
to the community at large in building tight webs of trust and thus
improving the security of PGP.
It is nevertheless a nuisance if key signing is frequent.
]],[[dnl
¿οͤ¾οͤθˤ˽̾ƤȤ⡢
Сϲͤޤ
С̤BlakeAliceθ˽̾Ȥ
BlakeϽ̾AliceθʣAliceäơ
Alice̿ΤƱ͡
Alice줿ؤ˲ä褦ˤޤ
Ϥи뤳ȤϡˤǤѤؤˤ롢
̤Υߥ˥ƥˤAliceBlakeǤ̤
äơPGPΥƥɤޤ
Ǥʤؤν̾ˤȡϤäǤ
]])dnl
endpara

beginpara
iydraft([[dnl
Using a keyserver makes the process somewhat easier.
When Blake signs Alice's key he sends the signed key to the key server.
The key server adds Blake's signature to its copy of Alice's key.
Individuals interested in updating their copy of Alice's key then consult
the keyserver on their own initiative to retrieve the updated key.
Alice need never be involved with distribution and can retrieve signatures
on her key simply by querying a keyserver.
begincomment()tagoption(--keyserver) must come before
tagoption(--send-key) or tagoption(--recv-key).
This appears to be a bug.endcomment
]],[[dnl
βϡСȤȤǡʬñˤʤޤ
BlakeAliceθ˽̾Ȥ̾򸰥Сޤ
СϡAliceθʣBlakeν̾äޤ
Aliceθʣι˴ؿΤͤϡ
줿򸡺뤿ˡ餹ǸСĴ٤ޤ
AliceϡˤäƤɬפʤ
ñ˸СξȲˤäθν̾򸡺Ǥޤ
begincomment()tagoption(--keyserver)ϡ
tagoption(--send-key)䡢
tagoption(--recv-key)ʤФʤޤ
ϡХΤ褦˻פޤendcomment
]])dnl
endpara

beginpara
iydraft([[dnl
One or more keys may be sent to a keyserver using the command-line
option taglink(send-keys,tagoption(--send-keys)).
The option takes one or more key specifiers and sends the specified
keys to the key server.
The key server to which to send the keys is specified with the
command-line option taglink(keyserver,tagoption(--keyserver)).
Similarly, the option
taglink(recv-keys,tagoption(--recv-keys)) is used
to retrieve keys from a keyserver, but the option tagoption(--recv-keys)
requires a key ID be used to specify the key.
In the following example Alice updates her public key with new signatures
from the keyserver tagparameter(certserver.pgp.com) and then
sends her copy of Blake's public key to the same keyserver to contribute
any new signatures she may have added.
]],[[dnl
1İʾθϡ
ޥɹԥץ
taglink(send-keys,tagoption(--send-keys))
ȤС뤫⤷ޤ
Υץϡ1ʾθҤȤꡢꤵ줿򸰥Сޤ
븰Сϡޥɹԥץ
taglink(keyserver,tagoption(--keyserver))
ǻꤵޤ
Ʊͤˡ
ץtaglink(recv-keys,tagoption(--recv-keys))
С鸰Ф˻Ȥޤ

ץtaglink(recv-keys,tagoption(--recv-keys))ϡ
ꤹ뤿˻Ȥ븰IDޤ
ˤơAliceϡ
tagparameter(certserver.pgp.com)Сο̾Ǹ򹹿
ƱСAliceΤBlakeθʣäơ
AliceΤĤǤ̾£ޤ
]])dnl

beginscreen(width="80")
tagprompt(alice%) taguserinput(gpg --keyserver certserver.pgp.com --recv-key 0xBB7576AC)
gpg: requesting key BB7576AC from certserver.pgp.com tagdots
gpg: key BB7576AC: 1 new signature

gpg: Total number processed: 1
gpg:	     new signatures: 1
tagprompt(alice%) taguserinput(gpg --keyserver certserver.pgp.com --send-key blake[[]]atmark[[]]cyb.org)
gpg: success sending to 'certserver.pgp.com' (status=200)
endscreen

iydraft([[dnl
There are several popular keyservers in use around the world.
The major keyservers synchronize themselves, so it is fine to
pick a keyserver close to you on the Internet and then use it
regularly for sending and receiving keys.
]],[[dnl
ǻȤƤͭ̾ʸСĤޤ
ʥСϡƱȤꤢäƤޤ
äơʤζ᤯θС򥤥󥿡ͥåȾӡ
θ塢̤ˡääꤹΤ˻Ȥޤ
]])dnl
endpara
endsection

endchapter

