beginchapter(wise,xreflabel="4")dnl
tagdocinfo([[$Id: c4.sgml,v 1.16 2000/08/15 01:52:50 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Daily use of tagGnupg
,
tagGnupg
)]])

beginpara
iydraft([[dnl
tagGnupg is a complex tool with technical, social, and legal issues
surrounding it.
Technically, it has been designed to be used in situations having
drastically different security needs.
This complicates key management.
Socially, using taggnupg is not strictly a personal decision.
To use taggnupg effectively both parties communicating must use it.
Finally, as of 1999, laws regarding digital encryption, and in particular
whether or not using taggnupg is legal, vary from country to country and 
is currently being debated by many national governments.
]],[[dnl
tagGnupgϡȤϤൻŪǡҲŪǡ
ˡΧ˴ؤʣŪʥġǤ
ޤŪˤȡ
ŰŪ˰㤦ƥˡľ˻Ȥ褦
߷פƤޤ
Τᡢʣˤʤޤ
ƼҲŪˤȡtaggnupgȤȤϡ̩ˤϸĿͤηǤϤޤ
taggnupgŪˤˤϡ̿ԤȤʤФʤޤ
ǸˡŪˤȡ1999ǯߥǥŹ沽˴ؤˡ
ätaggnupgλѤˡŪǤΤɤˤĤƤˡϡˤ㤤
ơ¿ܤǸĤĤĤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
This chapter addresses these issues.
It gives practical advice on how to use taggnupg to meet your security needs.
It also suggests ways to promote the use of taggnupg for secure
communication between yourself and your colleagues when your colleagues
are not currently using taggnupg.
Finally, the legal status of taggnupg is outlined given the current status
of encryption laws in the world.
]],[[dnl
ξϤǤϡäн褷
ƥˡtaggnupgλˡ˴ؤ롢
ŪɥХ򤢤ޤ
ʤ֤taggnupgȤäƤʤȤΡ
ʤ֤δ֤ΰ̿Τtaggnupgλ¥ʤˡ⡢ޤ
Ǹˡ
ŹˡŪޤtaggnupgˡΧθ⤷ޤ
]])dnl
endpara

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Defining your security needs
,
ƥˡ
)]])

beginpara
iydraft([[dnl
tagGnupg is a tool you use to protect your privacy.
Your privacy is protected if you can correspond with others without
eavesdroppers reading those messages.
]],[[dnl
tagGnupgϡʤʬΥץ饤Хݸ뤿˻ȤġǤ
⤷åͤİ줺ˡ¾οͤȳ碌ʤ顢
ʤΥץ饤ХϡޤƤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
How you should use taggnupg depends on the determination and resourcefulness
of those who might want to read your encrypted messages.
An eavesdropper may be an unscrupulous system administrator casually
scanning your mail, it might be an industrial spy trying to collect
your company's secrets, or it might be a law enforcement agency trying
to prosecute you.
Using taggnupg to protect against casual eavesdropping is going to be
different than using taggnupg to protect against a determined adversary.
Your goal, ultimately, is to make it more expensive to recover the
unencrypted data than that data is worth.
]],[[dnl
ʤɤΤ褦taggnupgѤ٤ʤΤϡ
Ź沽줿ʤΥåɤߤäƤͤη䡢
񸻤˭٤ˤäѤޤ
İԤȤϡ
ˤʤΥ᡼̵ʥƥԡ
ʤβҤ̩褦Ȥ뻺ȥѥ
ʤʤ褦ȤˡԵؤǤ뤫⤷ޤ
ȯŪİݸtaggnupgȤΤȡ
ȤŨݸtaggnupgȤΤϡ㤦Ǥ礦
ŪˡʤɸϡŹ沽Υǡؤˤ
ǡβͤäȹˤ뤳ȤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
Customizing your use of taggnupg revolves around four issues:
]],[[dnl
taggnupgλѤΥಽϡ4Ĥ꤬濴Ǥ
]])dnl
iftexi([[
]])dnl
beginitemizedlist(spacing="compact")
atitem
beginlistitem
beginpara
iydraft([[dnl
choosing the key size of your public/private keypair,
]],[[dnl
ʬθ/̩Фθ
]])dnl
endpara
endlistitem

atitem
beginlistitem
beginpara
iydraft([[dnl
protecting your private key, 
]],[[dnl
ʬ̩ݸ
]])dnl
endpara
endlistitem

beginlistitem
beginpara
iydraft([[dnl
selecting expiration dates and using subkeys, and
]],[[dnl

]])dnl
endpara
endlistitem

atitem
beginlistitem
beginpara
iydraft([[dnl
managing your web of trust.
]],[[dnl
ʤοѤؤδ
]])dnl
endpara
endlistitem
enditemizedlist

iydraft([[dnl
A well-chosen key size protects you against brute-force attacks on
encrypted messages.
Protecting your private key prevents an attacker from simply using your
private key to decrypt encrypted messages and sign messages in your name.
Correctly managing your web of trust prevents attackers from masquerading
as people with whom you communicate.
Ultimately, addressing these issues with respect to your own security
needs is how you balance the extra work required to use taggnupg with
the privacy it gives you.
]],[[dnl
Ź沽åˤ깶⤫ϡŬڤʸǤޤޤ
ñ̩ȤȤˤ롢Ź沽줿åι¦䡢
ʤ̾ǤΥåؤν̾ϡ̩ޤ뤳ȤǤդޤ
Ѥؤϡ¦̿ؤΤʤꤹޤդޤ
ŪˡȤΥƥˡˤĤƤؤнϡ
taggnupgȤΤɬפȤ;פʺȤȡ
Ǥץ饤ХȤΥХ󥹤򡢤ˤȤ뤫Ǥ
]])dnl
endpara

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Choosing a key size
,

)]])

beginpara
iydraft([[dnl
Selecting a key size depends on the key.
In OpenPGP, a public/private keypair usually has multiple keys.
At the least it has a master signing key, and it probably has one or
more additional subkeys for encryption.
Using default key generation parameters with taggnupg, the master
key will be a DSA key, and the subkeys will be ElGamal keys.
]],[[dnl
ϡˤäѤޤ
OpenPGPˤơ/̩Ф̾ʣĤޤ1Ĥμ̾㤢ꡢ
Ź沽Ѥ1İʾǤդ⤭äȤ뤫⤷ޤ
taggnupgǴ기ѥ᡼Ȥȡ
縰DSAǡElGamalǤ
]])dnl
endpara

beginpara
iydraft([[dnl
DSA allows a key size up to 1024 bits.
This is not especially good given today's factoring technology, but
that is what the standard specifies.
Without question, you should use 1024 bit DSA keys.
]],[[dnl
DSAǤϡ1024ӥåȤޤǤθޤ
ΰʬ򵻽ѤСϤʤɤȤۤɤΤΤǤϤʤǤ
ɸϤꤷƤޤ
ޤǤʤDSA1024ӥåȤȤ٤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
ElGamal keys, on the other hand, may be of any size.
Since taggnupg is a hybrid public-key system, the public key is used
to encrypt a 128-bit session key, and the private key is used to
decrypt it.
Key size nevertheless affects encryption and decryption speed
since the cost of these algorithms is exponential in the size of
the key.
Larger keys also take more time to generate and take more space
to store.
Ultimately, there are diminishing returns on the extra security
a large key provides you.
After all, if the key is large enough to resist a brute-force
attack, an eavesdropper will merely switch to some other method for
obtaining your plaintext data.
Examples of other methods include robbing your home or office
and mugging you.
1024 bits is thus the recommended key size.
If you genuinely need a larger key size then you probably already
know this and should be consulting an expert in data security.
]],[[dnl
ElGamalϡ륵Ǥꤨޤ
taggnupgϺƥʤΤǡ
128ӥåȤΥå󸰤ΰŹ沽˸Ȥ̩Ȥޤ
Ǥʤ
Υ르ꥺηϡ
沾㤹Τǡ
Ź沽®˸αƶǤޤ
ޤ礭ˤϤĹ֤ݻˤϤ깭֤ޤ
Ūˤϡ鸰礭Ƥ⡢
Ǥ륻ƥϡʤ礭Ϥʤޤ
ɡʬ礭깶񹳤Ǥʤ顢
ʿʸǡγΤˡİԤϡñ¾ˡؤΤ꤫ޤǤǤ礦
ǡ¾ˡפȤϡʤβȤ䥪եߤäꡢ
ʤ򽱤äȤȤޤޤޤ
äơ1024ӥåȤǤ
⤷ä礭ˤʤ顢
ʤϡ֤ˤʤȤΤäƤơ
ǡƥȤ̤Ǥ⤷ƤϤǤ
]])dnl
endpara
endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Protecting your private key
,
̩ݸ
)]])

beginpara
iydraft([[dnl
Protecting your private key is the most important job you have to
use taggnupg correctly.
If someone obtains your private key, then all data encrypted to
the private key can be decrypted and signatures can be made in your name.
If you lose your private key, then you will no longer be able to 
decrypt documents encrypted to you in the future or in the past,
and you will not be able to make signatures.
Losing sole possession of your private key is catastrophic.
]],[[dnl
taggnupgȤʤФʤʤȤ̩ݸϡǽײǤ
⤷ʤ̩줫ˤȤС
̩ǰŹ沽ǡ椵졢
ʤ̾ǽ̾Τʤǽޤ
⤷ʤ̩ʤС
Ϥ侭⤷ϲ˼ʬ˰Ź沽ʸϤǤʤ
̾򤪤ʤȤǤʤǤ礦
̩Ȥͣκ⻺򼺤ȤϡŪǤ
]])dnl
endpara

beginpara
iydraft([[dnl
Regardless of how you use taggnupg you should store the public
key's taglink(revocation,revocation certificate) 
and a backup of your private key on write-protected media in a safe place.
For example, you could burn them on a CD-ROM and store them in your
safe deposit box at the bank in a sealed envelope.
Alternatively, you could store them on a floppy and hide it in your
house.
Whatever you do, they should be put on media that is safe to store
for as long as you expect to keep the key, and you should store
them more carefully than the copy of your private key you use daily.
]],[[dnl
taggnupgȤ˴طʤ
taglink(revocation,˴)
̩ΥХååפ򡢰ʾˤݸΤ˳Ǽ٤Ǥ
ȤСCD-ROM˾Ƥ̩졢
Ԥ¶˳Ǽ뤳ȤǤǤ礦
ΤꡢեåԡˤǼơʬβȤ˱ȤǤǤ礦
򤹤ˤ衢ݻΤᡢ
ʤͽ¬¤˳ǼǤΤξ֤٤Ǥ
ʤȤ̩ʣ깹տǼ٤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
To help safeguard your key, tagGnupg does not store your raw
private key on disk.
Instead it encrypts it using a symmetric encryption algorithm.
That is why you need a passphrase to access the key.
Thus there are two barriers an attacker must cross to access your private
key: (1) he must actually acquire the key, and (2) he must get past
the encryption.
]],[[dnl
tagGnupgϸݸΤᡢ̩ϥǥ˳Ǽޤ
ΤꡢtagGnupgϡоΰŹ沽르ꥺǰŹ沽ޤ
ؤΥ˥ѥե졼Τϡ櫓Ǥ
äơʤ̩˥ˤϡ
¦αۤʤФʤʤ2ĤΥ٤뤳Ȥˤʤޤ
1ˡʤФʤޤ
2ˡ˰Ź沽̤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
Safely storing your private key is important, but there is a cost.
Ideally, you would keep the private key on a removable, write-protected disk
such as a floppy disk, and you would use it on a single-user machine 
not connected to a network.
This may be inconvenient or impossible for you to do.
For example, you may not own your own machine and must use a computer 
at work or school, or it may mean you have to physically disconnect
your computer from your cable modem every time you want to use taggnupg.
]],[[dnl
̩ʳǼϽפǤ
ˤϷ񤬤ޤ
ŪˤСեåԡǥΤ褦ʡ
æǽǽݸ줿ǥ̩ݻ
ͥåȥ³Ƥʤ󥰥롦桼ޥǻȤǤ礦
ΤϡʤˤȤäؤԲǽ⤷ޤ
ȤСʬΥޥĤΤϤޤʤȤ
رΥԥ塼ȤͤФʤ̡
ȤȤˤʤäƤ뤫⤷ޤ
뤤ϡʤtaggnupgȤȤ˾िӤˡ
֥롦ǥफ饳ԥ塼ʪŪʬΥͤФʤ̡
Ȥ̣⤷ޤ
]])dnl
endpara

beginpara
iydraft([[dnl
This does not mean you cannot or should not use taggnupg.
It means only that you have decided that the data you are protecting is
important enough to encrypt but not so important as to take extra
steps to make the first barrier stronger.
It is your choice.
]],[[dnl
Ǥ⤳ΤȤϡʤtaggnupgȤʤȤȤ٤Ǥʤ
Ȥ̣ˤϤʤޤ
ϡޤꤿʬΥǡŹ沽뤯餤פǤϤ뤬
κǽΥ٤äȶ뤿;ʬ֤ȤۤɽפǤϤʤ
ȤȽǤ򤢤ʤȤΰ̣ǡ
⼫ʬǤȤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
A good passphrase is absolutely critical when using taggnupg.
Any attacker who gains access to your private key must bypass the 
encryption on the private key.
Instead of brute-force guessing the key, an attacker will almost
certainly instead try to guess the passphrase.
]],[[dnl
taggnupgȤäƤȤɤѥե졼ϡ˽פǤ
̩ؤΥ¦ϡ
̩ˤۤɤ줿Ź򤷤ʤФʤޤ
Ǥθο¬Τˡ
¦ϡޤְ㤤ʤѥե졼¬褦ȤǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
The motivation for trying passphrases is that most people choose
a passphrase that is easier to guess than a random 128-bit key.
If the passphrase is a word, it is much cheaper to try all the
words in the dictionaries of the world's languages.
Even if the word is permuted, tageg, k3wldood, it is still easier
to try dictionary words with a catalog of permutations.
The same problem applies to quotations.
In general, passphrases based on natural-language utterances
are poor passphrases since there is little randomness and lots
of redundancy in natural language.
You should avoid natural language passphrases if you can.
]],[[dnl
ѥե졼ߤ뤳ȤˤưŤϡ
Ǥդ128ӥåȸۤȤɤοͤäȿ¬פѥե졼Ǥ
ѥե졼ñθǤʤС
θμΤߤ뤳ȤϡȤƤ²ˤǤޤ
줬k3wldoodΤ褦ѹȤƤ⡢
ΰѴθߤ뤳ȤϡޤñǤ
ƱϡѤŬѤޤ
̡ˤۤȤ𻨤ʤ˾ĹʤΤǡ
ȯ˴Ťѥե졼ϡϤѥե졼Ǥ
ѥե졼ϤǤ򤹤٤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
A good passphrase is one that you can remember but is hard for
someone to guess.
It should include characters from the whole range of printable characters
on your keyboard.
This includes uppercase alphabetics characters, numbers, and special
characters such as tagliteral(atclosebrace) and tagliteral(|).
Be creative and spend a little time considering your passphrase; a
good choice is important to ensure your privacy.
]],[[dnl
ɤѥե졼ȤϡʤƤ뤳ȤǤ
줫¬ˤѤʤΤǤ
ϡܡɾΰǽʸϰϤʸޤ٤Ǥ
ˤϡե٥åȤʸ
tagliteral(atclosebrace)tagliteral(|)Τ褦üʸޤߤޤ
ȯơ
ʬΥѥե졼ͤΤ˾֤䤷Ƥ
ץ饤Хݾڤˤϡɤ򤬽פʤΤǤ
]])dnl
endpara
endsubsection

beginignore
beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Reacting to a compromised private key
,
ѥ줿̩
)]])

beginpara
Despite your precautions you may lose sole access to your private key.
For example, you may forget the passphrase, or someone who you think 
can bypass the encryption gets access to it.
In that case then you need to spread the word that your key is no 
longer valid.
To do that you use the key revocation certificate you should have generated
when you created the key.
Importing it onto your public keyring will revoke the public key
of the keypair you no longer wish to use.
It is then up to you to distribute the revoked public key to all 
those who may encrypt documents to you.
endpara

beginpara
A revoked public key only prevents future use of the private key.
Others will neither be able to encrypt documents to the key nor will
they be able to check signatures made with the private key.
Documents signed in the past can still be checked, however, and
documents encrypted in the past can still be decrypted.
endpara

beginpara
It is important that you protect the revocation certificate carefully.
Anybody can add the certificate to your public key and distribute it,
and there is no way to revoke a revocation certificate.
Therefore, you should store the revocation certificate in a safe
place such as with the backup of your private key.
endpara
endsubsection
endignore

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Selecting expiration dates and using subkeys
,

)]])

beginpara
iydraft([[dnl
By default, a DSA master signing key and an ElGamal encryption subkey 
are generated when you create a new keypair.
This is convenient, because the roles of the two keys are different,
and you may therefore want the keys to have different lifetimes.
The master signing key is used to make digital signatures, and it
also collects the signatures of others who have confirmed your
identity.
The encryption key is used only for decrypting encrypted documents
sent to you.
Typically, a digital signature has a long lifetime, tageg, forever, and
you also do not want to lose the signatures on your key that you worked
hard to collect.
On the other hand, the encryption subkey may be changed periodically
for extra security, since if an encryption key is broken, the
attacker can read all documents encrypted to that key both in the
future and from the past.
]],[[dnl
ФȤǥեȤǡDSAμ̾ElGamalŹ沽Ǥޤ
2Ĥθϰ㤦Τ̤ʼ̿θ뤫⤷ʤΤǡ
Ǥ
̾縰ϡŻҽ̾˻Ȥ졢ޤʤǧ¾οͤν̾⽸ޤ
Ź沽ϡϤŹʸΤ˻Ȥޤ
ƤŻҽ̾(ʵפʤɤ)Ĺ̿äƤ뤷
ΤѤäν̾ʤʤäƤۤʤǤ礦
Ź沽ȡˤθѤ˰Ź沽줿ʸ񤬡
åɤޤƤޤΤǡƥζΤᡢ
Ź沽ϡŪѹ뤫⤷ޤ
]])dnl
endpara

beginpara
iydraft([[dnl
It is almost always the case that you will not want the master
key to expire.
There are two reasons why you may choose an expiration date.
First, you may intend for the key to have a limited lifetime.
For example, it is being used for an event such as a political campaign
and will no longer be useful after the campaign is over.
Another reason is that if you lose control of the key and do not have a
revocation certificate with which to revoke the key, having an expiration
date on the master key ensures that the key will eventually fall into
disuse.
]],[[dnl
ĤۤȤɤξ硢縰ˤʤäƤ餤Ϥޤ󤬡
ͭ¤ꤹͳ2ĤϤ뤫⤷ޤ
ޤʤϡμ̿¤ȤĤ꤫⤷ޤ
ϡȤڡΤ褦ʥ٥Ȥ˻Ȥǡ
ڡ󤬽äƤޤС⤦̵̣ˤʤǤ礦
ͳϡʤʤä˴񤬤ʤʤС
縰ͭ¤뤳ȤǡɤθλȤʤʤ뤳Ȥݾڤ롢
ȤȤǤ
]])dnl
endpara

beginpara
iydraft([[dnl
Changing encryption subkeys is straightforward but can
be inconvenient.
If you generate a new keypair with an expiration date on the
subkey, that subkey will eventually expire.
Shortly before the expiration you will add a new subkey and
publish your updated public key.
Once the subkey expires, those who wish to correspond with you
must find your updated key since they will no longer be able
to encrypt to the expired key.
This may be inconvenient depending on how you distribute the key.
Fortunately, however, no extra signatures are necessary since
the new subkey will have been signed with your master signing
key, which presumably has already been validated by your
correspondents.
]],[[dnl
Ź沽θ򴹤ϡñǤؤ⤷ޤ
⤷ͭ¤˿ФʤС
ɤϡȤȤǤ礦
ľˤϡäơ줿ɽޤ
äˤʤСϤ䤽θѤ˰Ź沽뤳ȤϤǤʤʤΤǡ
ʤ̿ϡ줿ʤθ򸫤ĤʤФʤޤ
ʤθˡˤäƤϡؤ⤷ޤ
ʤ顢ˤ⡢
꤫̿ͭȤ줿ϤΤʤμ̾ˤꡢ
˽̾ƤΤǡ;פʽ̾ɬפǤ
]])dnl
endpara

beginpara
iydraft([[dnl
The inconvenience may or may not be worth the extra security.
Just as you can, an attacker can still read all documents encrypted to
an expired subkey.
Changing subkeys only protects future documents.
In order to read documents encrypted to the new subkey, the
attacker would need to mount a new attack using whatever
techniques he used against you the first time.
]],[[dnl
ؤʬΥƥβͤϡ뤫⤷ʤʤ⤷ޤ
ʤƱ͡¦ϡ
ˤʤäѤ˰Ź沽ʸޤɤळȤǤޤ
ѹϡʸݸޤ
Ѥ˰Ź沽줿ʸɤΤˡ
¦ϡǽ˻ȤäޤϤɬפǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
Finally, it only makes sense to have one valid encryption subkey on a
keyring.
There is no additional security gained by having two or more 
active subkeys.
There may of course be any number of expired keys on a keyring
so that documents encrypted in the past may still be decrypted,
but only one subkey needs to be active at any given time.
]],[[dnl
ǽŪˡؤ1ĤʰŹ沽뤳Ȥ˰̣ޤ
2İʾͭäƤ⡢ƥޤ
󡢲˰Ź沽줿ʸ񤬤äǤ褦
ؤǤդοˤʤä뤫⤷ޤ
ϡ1ĤǤդλͭǤɬפޤ
]])dnl
endpara

endsubsection

beginsubsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Managing your web of trust
,
Ѥؤδ
)]])

beginpara
iydraft([[dnl
As with protecting your private key, managing your web of trust is
another aspect of using taggnupg that requires balancing security against
ease of use.
If you are using taggnupg to protect against casual eavesdropping and
forgeries then you can afford to be relatively trusting of other
people's signatures.
On the other hand, if you are concerned that there may be a determined
attacker interested in invading your privacy, then
you should be much less trusting of other signatures and spend more time 
personally verifying signatures.
]],[[dnl
Ѥؤδϡ̩ݸƱ͡
ƥȻȤ䤹ȤΥХ󥹤ɬפtaggnupgѤ¦̤Ǥ
⤷ʤȯŪİ䵶¤ݸ뤿taggnupgȤäƤʤ顢
ʤ¾οͤν̾Ūꤹ;͵ޤ
ʤΥץ饤Х˿褦ȷ᤿¦̵ͭ˴ؿʤ顢
ʤϡ¾ν̾򤽤ʤ˿Ѥ٤Ǥʤ
ĿŪʽ̾θڤˤäĹ֤䤹٤Ǥ
]])dnl
endpara

beginpara
iydraft([[dnl
Regardless of your own security needs, though, you should 
tagemphasis(always be careful) when signing other keys.
It is selfish to sign a key with just enough confidence in the key's
validity to satisfy your own security needs.
Others, with more stringent security needs, may want to depend on 
your signature.
If they cannot depend on you then that weakens the web of trust
and makes it more difficult for all taggnupg users to communicate.
Use the same care in signing keys that you would like others to use when
you depend on their signatures.
]],[[dnl
ǤʬΥƥˡȤϴطʤ
¾θ˽̾Ȥϡtagemphasis(տ)٤Ǥ
ʬΥƥˡᡢ
ͭˤ뽽ʬʿǸ˽̾Τϡ
ʬǤ
äȸƥˡΤ¾οͤϡ
ʤν̾˰¸Ȼפ⤷ޤ
⤷οͤʤ˰¸Ǥʤʤ顢
Ѥؤϼޤꡢtaggnupg桼̿Ϥä񤷤ʤޤ
οͤν̾ˤʤ¸Ȥ
ʤ¾οͤ˻ȤäƤ餤ؤν̾ˤϡ
ƱͤդϤäƤ
]])dnl
endpara

beginpara
iydraft([[dnl
In practice, managing your web of trust reduces to assigning trust to 
others and tuning the options 
taglink(marginals-needed,tagoption(--marginals-needed))
and 
taglink(completes-needed,tagoption(--completes-needed)).
Any key you personally sign will be considered valid, but except for small
groups, it will not be practical to personally sign the key of every person
with whom you communicate.
You will therefore have to assign trust to others.
]],[[dnl
ºݾ塢
¾οͤؤοѤγƤȡ
taglink(marginals-needed,tagoption(--marginals-needed))
ץ
taglink(completes-needed,tagoption(--completes-needed))
ץĴϡ
ѤؤδǸޤ
ʤĿŪ˽̾븰ͭȹͤǤ礦
ۤɤξĤǤʤС̿θؤθĿŪ̾ʤɡ
ŪǤ礦
äƤʤϡ¾ͤˤ⿮ѤƤʤФʤʤȤˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
It is probably wise to be accurate when assigning trust and then
use the options to tune how careful taggnupg is with key validation.
As a concrete example, you may fully trust a few close friends that
you know are careful with key signing and then marginally
trust all others on your keyring.
From there, you may set tagoption(--completes-needed) to
tagliteral(1) and tagoption(--marginals-needed) to
tagliteral(2).
If you are more concerned with security you might choose values of
tagliteral(1) and tagliteral(3) or tagliteral(2)
and tagliteral(3) respectively.
If you are less concerned with privacy attacks and just want some
reasonable confidence about validity, set the values to tagliteral(1)
and tagliteral(1).
In general, higher numbers for these options imply that more people
would be needed to conspire against you in order to have a key validated
that does not actually belong to the person whom you think it does.
]],[[dnl
ѤƤƤȤˤΤǤ뤳ȡơθǡ
ͭˤĤƤtaggnupgտĴѥץȤΤ
֤Ǥ
Ȥơ
ν̾տΤäƤ23ͤοͧϴ˿Ѥ
ؾ¾Τ٤ƤοͤϤ٤Ѥʤ⤷ޤ
顢
tagoption(--completes-needed)tagliteral(1)ˡ
tagoption(--marginals-needed)tagliteral(2)ꤹǤ礦
ƥäȵˤʤ顢
tagliteral(1)tagliteral(3)䡢
tagliteral(2)tagliteral(3)ͤ򤽤줾֤Ǥ礦
ʤޤץ饤Х򵤤ˤ
ñͭˤĤƤäʿ꤬ʤ顢
ͤtagliteral(1)tagliteral(1)ꤷƤ
̤Υץˤä礭ʿͤꤹ뤳Ȥϡ
ʤȻפͤºݤˤäƤʤ褦ʸͭˤơ
ʤ򤿤֤餫ˤϡ
ä¿οͤ
Ȥ̣Ǥ
]])dnl
endpara
endsubsection
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Building your web of trust
,
Ѥؤι
)]])

beginpara
iydraft([[dnl
Wanting to use taggnupg yourself is not enough.
In order to use to communicate securely with others you must have
a web of trust.
At first glance, however, building a web of trust is a daunting task.
The people with whom you communicate need to use 
taggnupg()tagfootnote([[beginpara()In this section, taggnupg refers to the 
taggnupg implementation of OpenPGP as well as other implementations 
such as NAI's PGP product.endpara()]]), and there needs to be enough 
key signing so that keys can be considered valid.
These are not technical problems; they are social problems.
Nevertheless, you must overcome these problems if you want to 
use taggnupg.
]],[[dnl
ʬtaggnupgȤȻפǤϡԽʬǤ
¾οͤȤΰ̿˻ȤˤϡѤؤʤФʤޤ
ʤ鿮ѤؤΤϡ츫ޤŻǤ
̿taggnupg
tagfootnote(beginpara
ˤơtaggnupgϡ
NAIPGPʤΤ褦¾μƱ͡
OpenPGPtaggnupg򤤤ޤ
endpara)
Ȥɬפꡢ
ͭȹͤ뤳ȤΤǤ褦ʬʸν̾ɬפޤ
ϵŪǤϤʤҲŪǤ
ǤtaggnupgȤʤ顢ʤФʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
When getting started using taggnupg it is important to realize that you
need not securely communicate with every one of your correspondents.
Start with a small circle of people, perhaps just yourself and
one or two others who also want to exercise their right
to privacy.
Generate your keys and sign each other's public keys.
This is your initial web of trust.
By doing this you will appreciate the value of a small, robust
web of trust and will be more cautious as you grow your web
in the future.
]],[[dnl
taggnupgλȤϤǤϡ̿Ȱ̿ɬפȤϸ¤ʤ
ȤȤǧ뤳ȤפǤ
ޤñ˼ʬȤȡ
Ƥ֤Ʊץ饤ХθγѤ˾¾12ͤȤä
ͿΥǻϤƤ
ʬθơߤθ˽̾򤷤Ƥ
줬ʤκǽοѤؤǤ
뤳ȤǡѤؤοǧᡢ
迮ѤؤĹȤäȿŤˤʤǤ礦
]])dnl
endpara

beginpara
iydraft([[dnl
In addition to those in your initial web of trust, you may want to
communicate securely with others who are also using taggnupg.
Doing so, however, can be awkward for two reasons:
(1) you do not always know when someone uses or is willing to use
taggnupg, and (2) if you do know of someone who uses it, you may still have
trouble validating their key.
The first reason occurs because people do not always advertise that
they use taggnupg.
The way to change this behavior is to set the example and advertise 
that you use taggnupg.
There are at least three ways to do this: you can sign messages you mail
to others or post to message boards, you can put your public key on your
web page, or, if you put your key on a keyserver, you can put your key
ID in your email signature.
If you advertise your key then you make it that much more acceptable
for others to advertise their keys.
Furthermore, you make it easier for others to start communicating
with you securely since you have taken the initiative and made it clear
that you use taggnupg.
]],[[dnl
ǽοѤؤοͤ˲äʤϡ
ƱtaggnupgȤäƤ¾οͤȰ̿Ȼפ⤷ޤ
2ĤͳΤᡢ𤫤⤷ޤ
ޤˡ줫taggnupgѤƤȤ뤤ϡ
taggnupgǻȤäƤΤȤˤ狼ȸ¤ޤ
ˡȤ⤷taggnupgȤͤΤȤΤäƤȤƤ⡢
ͭˤΤˤޤ꤬뤫⤷ޤ
ͤϡֻtaggnupgȤäƤޤפʤɤȾȤϸ¤ʤΤǡ
ǽͳȯޤ
ο񤤤ѤˤϡʤȡtaggnupgȤäƤޤפ
򼨤ȤǤ
Τ˺3Ĥˡޤ
ʤϡï᡼ǼĤ˽̾Ǥޤ
ʬΥ֡ڡξ֤ȤǤޤ
⤷ʬθ򸰥Сξ֤ƤС
ID򤢤ʤΥ᡼ν̾뤳ȤǤޤ
⤷ʤʬθС
ʬθȤˡ¾οͤäȼ褦ˤʤǤ礦
ʤΨ褷taggnupgȤȤ餫ˤС
¾οͤʤȰ̿ϤΤϤäȴñˤʤޤ
]])dnl
endpara

beginpara
iydraft([[dnl
Key validation is more difficult.
If you do not personally know the person whose key you want to sign,
then it is not possible to sign the key yourself.
You must rely on the signatures of others and hope to find a chain
of signatures leading from the key in question back to your own.
To have any chance of finding a chain, you must take the initiative
and get your key signed by others outside of your initial web of trust.
An effective way to accomplish this is to participate in key
signing parties.
If you are going to a conference look ahead of time for a key
signing party, and if you do not see one being held, offer to 
taguref(http://www.herrons.com/kb2nsx/keysign.html, hold one).
You can also be more passive and carry your fingerprint with you
for impromptu key exchanges.
In such a situation the person to whom you gave the fingerprint
would verify it and sign your public key once he returned home.
]],[[dnl
ͭϡ񤷤ʤޤ
̾򤷤λĿŪΤʤΤʤ顢
ʬǸ˽̾뤳ȤϤǤޤ
θ餢ʤθ̾Ϣ򸫤Ĥ뤳ȤԤ
¾οͤν̾ʤФʤޤ
Ϣȯ뤢뵡Ĥᡢ
Ψ褷ơǽοѤؤγοͤ鸰˽̾ƤʤФʤޤ
뤲Ūˡϡ̾˻ä뤳ȤǤ
⤷ʤ˸̾ΤĤ˹ԤȤƤơ
ŤƤʤΤ򸫤ʤС
taguref(http://www.herrons.com/kb2nsx/keysign.html, )
ƤƤ
դˤäȼưŪˤʤꡢ¨ʤθѤ˻Ӥ뤳Ȥ⤢ꤨޤ
ξ硢򤢤ͤϡޤäȤ˵ꡢ
ڤ򤷤Ƥ顢ʤθ˽̾򤹤Ǥ礦
]])dnl
endpara

beginpara
iydraft([[dnl
Keep in mind, though, that this is optional.
You have no obligation to either publicly advertise your key or
sign other people's keys.
The power of taggnupg is that it is flexible enough to adapt to your
security needs whatever they may be.
The social reality, however, is that you will need to take the initiative
if you want to grow your web of trust and use taggnupg for as much of 
your communication as possible.
]],[[dnl
ǤޤǤǤդȤȤǰƬˤƤ
ʤϡ̳⤢ޤ󤷡
¾οͤθؤν̾򤹤̳⤢ޤ
taggnupgΥѥϡʤΥƥˡǤ졢
Ŭ뤯餤ʬʤȤǤ
⤷ʤѤؤĹ
̿ΤǤʬtaggnupgȤʤ顢
ʤΨ褹ɬפȤΤ¤Ǥ
]])dnl
endpara
endsection

beginsection()dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Using tagGnupg legally
,
tagGnupgιˡŪ
)]])

beginpara
iydraft([[dnl
The legal status of encryption software varies from country to country,
and law regarding encryption software is rapidly evolving.
taguref(http://cwis.kub.nl/~frw/people/koops/bertjaap.htm, Bert-Japp 
Koops) has an excellent 
taguref(http://cwis.kub.nl/~frw/people/koops/lawsurvy.htm, Crypto
Law Survey) to which you should refer for the legal status of
encryption software in your country.
]],[[dnl
Ź沽եȥˡΧξ֤ϡˤäư㤤
Ź沽եȥ˴ؤˡϡ®ȯŸƤޤ
ǤΰŹ沽եȥˡΧξѤˤϡ
taguref(http://cwis.kub.nl/~frw/people/koops/bertjaap.htm, Bert-Japp
Koops)
ͥ줿
taguref(http://cwis.kub.nl/~frw/people/koops/lawsurvy.htm, Crypto
Law Survey)(ŹˡĴ)򻲾Ȥ٤Ǥ
]])dnl
endpara

endsection
endchapter

