iftexi(@node Options Reference
)dnl
beginreference()dnl
tagdocinfo([[$Id: c7.sgml,v 1.10 2000/02/07 00:27:05 jashley Exp $]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Options Reference
,
ץ󻲾
)]])

beginpartintro
beginappendixsec([[ id="optionsfile"]])dnl
tagtitle([[iyiftexi([[dnl]])
iydraft(
Setting options
,
ꥪץ
)]])

beginpara
iydraft([[dnl
Options may be specified on the command line or in an options file.
The default location of the options file is
tagliteral(~/.gnupg/options).
When specifying options in the options file, omit the leading two
dashes and instead use simply the option name followed by any
arguments.
Lines in the file with a hash (tagliteral(#)) as the 
first non-white-space character are ignored.
]],[[dnl
ץϡޥɹԤ䥪ץ󡦥եǻǤޤ
ǥץ󡦥եΰ֤ϡ
tagliteral(~/.gnupg/options)Ǥ
ץ󡦥եǥץꤷƤȤ
Ԥ2ĤΥåά
ץ̾θǤդ˰³ޤ
եǡǽʸϥå
(tagliteral(#))
Ԥϡ̵뤵ޤ
]])dnl
endpara
endsection
endpartintro
iftexi([[
@menu
* keyserver::                   
* output::                      
* recipient::                   
* default-recipient::           
* default-recipient-self::      
* no-default-recipient::        
* encrypt-to::                  
* no-encrypt-to::               
* armor::                       
* no-armor::                    
* no-greeting::                 
* no-secmem-warning::           
* batch::                       
* no-batch::                    
* local-user::                  
* default-key::                 
* completes-needed::            
* marginals-needed::            
* load-extension::              
* rfc1991::                     
* allow-non::                   
* cipher-algo::                 
* compress-algo::               
* z::                           
* verbose::                     
* no-verbose::                  
* quiet::                       
* textmode::                    
* dry-run::                     
* interactive::                 
* yes::                         
* no::                          
* always-trust::                
* skip-verify::                 
* keyring::                     
* secret-keyring::              
* no-default-keyring::          
* homedir::                     
* charset::                     
* no-literal::                  
* set-filesize::                
* with-fingerprint::            
* with-colons::                 
* with-key-data::               
* lock-once::                   
* lock-multiple::               
* passphrase-fd::               
* force-mdc::                   
* force-v3-sigs::               
* openpgp::                     
* utf8-strings::                
* no-utf8-strings::             
* no-options::                  
* debug::                       
* debug-all::                   
* status-fd::                   
* logger-fd::                   
* no-comment::                  
* comment::                     
* default-comment::             
* no-version::                  
* emit-version::                
* notation-data::               
* set-policy-url::              
* set-filename::                
* use-embedded-filename::       
* max-cert-depth::              
* digest-algo::                 
* s2k-cipher-algo::             
* s2k-digest-algo::             
* s2k-mode::                    
* disable-cipher-algo::         
* disable-pubkey-algo::         
* throw-keyid::                 
* not-dash-escaped::            
* escape-from-lines::           
@end menu]])dnl

beginrefentry(keyserver)
beginrefnamediv
tagrefname(keyserver)
tagrefpurpose(iydraft(
specify the keyserver to use to locate keys
,
֤Τ˻ȤСλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(keyserver) tagreplaceableparam(server-name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option is used in conjunction with either 
taglink(recv-keys,tagoption(recv-keys)) or 
taglink(send-keys,tagoption(send-keys)) to specify a
keyserver to manage public key distribution.
]],[[dnl
Υץϡ
븰Сλˡ
taglink(recv-keys,tagoption(recv-keys))

taglink(send-keys,tagoption(send-keys))
Τɤ餫ȶ˻Ȥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(output)
beginrefnamediv
tagrefname(output)
tagrefpurpose(iydraft(
specify the file in which to place output
,
ϥեλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(output) tagreplaceableparam(file-name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option takes the output from commands and prints it to
the filename given to it as a parameter.
]],[[dnl
Υץϡ
ޥɤνϤȤꡢ
ǻꤷե̾ˤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(recipient)
beginrefnamediv
tagrefname(recipient )
tagrefpurpose(iydraft(
specify the recipient of a public-key encrypted document
,
Ź沽줿ʸμͤλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(recipient) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara 
iydraft([[dnl
This option is used in conjunction with the command
taglink(encrypt,tagoption(encrypt)).  
It must appear before tagoption(encrypt) on the command line.  
The parameter tagreplaceableparam(name) is either 
the name of the individual or the e-mail address of the individual to 
whom you are sending the message.
]],[[dnl
Υץϡ
taglink(encrypt,tagoption(encrypt))ޥɤȤȤ˻Ȥޤ
ϡޥɹԤtagoption(encrypt)ˤʤФʤޤ
tagreplaceableparam(name)ϡ
åθĿͤŻҥ᡼롦ɥ쥹Ŀͤ̾Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(default-recipient)
beginrefnamediv
tagrefname(default-recipient )
tagrefpurpose(iydraft(
specify the default recipient of a public-key encrypted document
,
ǰŹ沽줿ʸδμͤλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(default-recipient) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara 
iydraft([[dnl
The user ID tagreplaceableparam(name) is used as
the default recipient if a recipient is not otherwise specified.
]],[[dnl
ͤλꤵʤȤδμͤȤơ
桼ID[[]]tagreplaceableparam(name)Ȥ褦ˤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(default-recipient-self)
beginrefnamediv
tagrefname(default-recipient-self)
tagrefpurpose(iydraft(
use the default key user ID as the default recipient of a public-key encrypted document
,
ǰŹ沽줿ʸδμͤȤơθID
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(default-recipient-self)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara 
iydraft([[dnl
The user ID of the default key is used as the default recipient.
taggpg does not query for a recipient if this specifies a valid key.
The default key is the first key on the private keyring or the key
specified with the option
taglink(default-key,tagoption(default-key)).
]],[[dnl
μͤȤƴ기Υ桼IDȤޤ
⤷줬ͭʸꤹʤ顢
taggpgϡͤ礻򤷤ޤ
θϡ
taglink(default-key,tagoption(default-key))ץǻꤵ줿
̩ؤκǽθǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-default-recipient)
beginrefnamediv
tagrefname(no-default-recipient)
tagrefpurpose(iydraft(
ignore the options tagoption(default-recipient) and
tagoption(default-recipient-self),
tagoption(default-recipient)tagoption(default-recipient-self)Υץ̵
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-default-recipient)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara 
iydraft([[dnl
This is useful if the default recipient is usually set in the options file 
but must be ignored for a particular run of taggpg.
]],[[dnl
̤ϴμͤץ󡦥ե֤Ƥ뤬
äˤtaggpgμ¹Ի̵뤹ɬפΤȤ
줬ͭפǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(encrypt-to)
beginrefnamediv
tagrefname(encrypt-to)
tagrefpurpose(iydraft(
specify an additional recipient of a public-key encrypted document
,
ǰŹ沽줿ʸͽμͤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(encrypt-to) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option is similar to 
taglink(recipient,tagoption(recipient)) but is
intended for use in the options file.
It may be used with one's own file user ID to yield an 
tagldquo[[]]encrypt-to-self[[]]tagrdquo option.
The key specified by
tagreplaceableparam(name)
is used only when there are other recipients given by the user or by
use of the option taglink(recipient,tagoption(recipient)).
No trust checking is performed on the key specified by
tagreplaceableparam(name) and even disabled
keys may be used.
]],[[dnl
Υץϡ
taglink(recipient,tagoption(recipient))ȻƤޤ
ץ󡦥եǻȤΤΤǤ
tagldquo[[]]encrypt-to-self[[]]tagrdquoץˡ
ʬΥե롦桼IDȤ碌ƻȤ뤫⤷ޤ
桼ˤäͿ줿¾μͤΤȤ䡢
taglink(recipient,tagoption(recipient))ץȤäȤ
tagreplaceableparam(name)ǻꤵ줿Ȥޤ
tagreplaceableparam(name)ˤäƻꤵ줿ˤϡ
ѤΥå򤻤
ޤԲĤθȤȤǤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-encrypt-to)
beginrefnamediv
tagrefname(no-encrypt-to)
tagrefpurpose(iydraft(
ignore the option tagoption(encrypt-to)
,
tagoption(encrypt-to)ץ̵
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-encrypt-to)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara 
iydraft([[dnl
This is useful if messages are normally encrypted to one or more keys by 
default but must not be for a particular run of taggpg.
]],[[dnl
̥å1İʾθ˰Ź沽ʤ顢
ͭפʤΤǤ
äˤtaggpgμ¹ԻˤϤǤ⤢ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(armor)
beginrefnamediv
tagrefname(armor)
tagrefpurpose(iydraft(
ASCII-armor encrypted or signed output
,
Ź沽⤷Ͻ̾ϤASCII
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(armor)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option takes output from commands and prints it in format that
can be safely e-mailed.
]],[[dnl
Υץϡ
ޥɤνϤȤäơ
˥᡼Ǥǰޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-armor)
beginrefnamediv
tagrefname(no-armor)
tagrefpurpose(iydraft(
assume input data is not ASCII armored
,
ϥǡASCII̤Ȳ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-armor)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-greeting)
beginrefnamediv
tagrefname(no-greeting)
tagrefpurpose(iydraft(
suppress the opening copyright notice but do not enter batch mode
,
Хå⡼ɤ餺ˡϤǸ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-greeting)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-secmem-warning)
beginrefnamediv
tagrefname(no-secmem-warning)
tagrefpurpose(iydraft(
suppress warnings if insecure memory is used
,
Ф꡼ȤäƤȤηٹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-secmem-warning)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(batch)
beginrefnamediv
tagrefname(batch)
tagrefpurpose(iydraft(
use batch mode
,
Хå⡼ɤλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(batch)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
taggpg will never ask questions and will not allow interactive commands.
,
taggpgϡ
褷Ƽ򤻤
÷Υޥɤ뤵ʤ褦ˤʤޤ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-batch)
beginrefnamediv
tagrefname(no-batch)
tagrefpurpose(iydraft(
disable batch mode
,
Хå⡼ɤ̵
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-batch)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Useful if the option taglink(batch,tagoption(batch)) is
set in the options file.
]],[[dnl
taglink(batch,tagoption(batch))ץ󤬥ץ󡦥եˤȤ
Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(local-user)
beginrefnamediv
tagrefname(local-user)
tagrefpurpose(iydraft(
specifies a user id to use for signing
,
̾˻Ȥ桼IDλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(local-user) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Use tagreplaceableparam(name) as the user ID to sign.
This option is silently ignored for the list commands, so that it can be 
used in an options file.
]],[[dnl
̾桼IDȤ
tagreplaceableparam(name)Ȥޤ
Υץϡ
ץ󡦥ե˻Ȥ褦
ꥹȡޥɤǤϲ⤤鷺̵뤵ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(default-key)
beginrefnamediv
tagrefname(default-key)
tagrefpurpose(iydraft(
specifies a user ID as a default user ID for signatures
,
桼ID̾ѤδΤȤƻ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(default-user) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Use tagreplaceableparam(name) as the user ID to sign.
If this option is not used the first user ID found on the private keyring is
the default user ID.
]],[[dnl
̾桼IDȤtagreplaceableparam(name)Ȥޤ
ΥץȤʤȤδΥ桼IDϡ
̩θؤˤǽΥ桼IDǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(completes-needed)
beginrefnamediv
tagrefname(completes-needed)
tagrefpurpose(iydraft(
specifies the number of fully-trusted people needed to validate a new key.
,
ͭɬפʡʬ˿Ѥ줿ͤολ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(completes-needed) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
A public key on your keyring is validated using those signatures on
the key that were made by other valid keys on your keyring.
The option specifies the number of signatures needed if you fully
trust the owners of the keys that made the signatures.
Your trust in a key's owner is set with the command 
taglink(edit-key,tagoption(edit-key)).
]],[[dnl
ؾθϡ
ؾ¾ͭʸǺ줿ν̾ǡͭˤޤ
̾򤪤ʤäλ˿Ѥʤ顢
Υץϡɬפʽ̾οꤷޤ
λˤ뤢ʤοѤϡ
taglink(edit-key,tagoption(edit-key))
ޥɤꤵޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(marginals-needed)
beginrefnamediv
tagrefname(marginals-needed)
tagrefpurpose(iydraft(
specifies the number of marginally-trusted people needed to validate
a new key.
,
ͭɬפʡٿѤ줿ͤολ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(marginals-needed) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
A public key on your keyring is validated using those signatures on
the key that were made by other valid keys on your keyring.
The option specifies the number of signatures needed if you marginally
trust the owners of the keys that made the signatures.
Your trust in a key's owner is set with the command 
taglink(edit-key,tagoption(edit-key)).
]],[[dnl
ؾθϡ
ؾ¾ͭʸǺ줿ν̾ǡͭˤޤ
̾򤪤ʤäλ򤢤ٿѤʤ顢
Υץϡɬפʽ̾οꤷޤ
λˤ뤢ʤοѤϡ
taglink(edit-key,tagoption(edit-key))
ޥɤꤵޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(load-extension)
beginrefnamediv
tagrefname(load-extension)
tagrefpurpose(iydraft(
specifies an extension to load
,
ɤγĥҤλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(load-extension) tagreplaceableparam(object-file)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Elaborate.
,
԰ռɮ档
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(rfc1991)
beginrefnamediv
tagrefname(rfc1991)
tagrefpurpose(iydraft(
try to be more RFC1991 (PGP 2.x) compliant
,
RFC1991 (PGP 2.x)ˤʤȤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(rfc1991)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Elaborate?
,
԰ռɮ?
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(allow-non)
beginrefnamediv
tagrefname(allow-non-selfsigned-uid)
tagrefpurpose(iydraft(
allow the import of keys with user IDs which are not self-signed
,
ʽ̾Ƥʤ桼IDθɹߤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(allow-non-selfsigned-uid)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This only allows the import
- key validation will fail and you have to check
the  validity  of  the key by other means.  This
hack is needed for some  German  keys  generated
with  pgp 2.6.3in. You should really avoid using
it, because OpenPGP has better mechanics  to  do
separate signing and encryption keys.
]],[[dnl
ˤ기ɹߤΤߤǤ褦ˤʤޤ
ͭ򤷤褦ȤƤ⼺ԤΤǡ
¾μʤǸͭ򸡾ڤʤФʤޤ
Υϥåϡ
pgp 2.6.3inǤǤGermanΤɬפˤʤޤ
ºݤˤȤȤϲ򤹤٤Ǥ
ʤʤOpenPGPˤϡ
ʬΥ̾ȰŹ沽ˤĤƤΤȤȤߤ뤫Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(cipher-algo)
beginrefnamediv
tagrefname(cipher-algo)
tagrefpurpose(iydraft(
use a specified algorithm as the symmetric cipher
,
Υ르ꥺоŪŹȤƻ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(cipher-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Use tagparameter(name) as the symmetric cipher algorithm. 
Running the taggpg with the command 
taglink(version,tagoption(version)) yields a 
list of supported  algorithms.
If this is not used, the cipher algorithm is selected from the 
preferences stored with the default keypair.
For symmetric encryption, the default is Blowfish.
]],[[dnl
tagparameter(name)ŪʰŹ楢르ꥺȤƻȤޤ
taggpgtaglink(version,tagoption(version))ޥɤưȡ
ٱ礵줿르ꥺΰФޤ
Ȥʤȡ
Ź楢르ꥺϡ
θФ˳Ǽ椫Фޤ
ŪŹ沽δϡ
BlowfishǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(compress-algo)
beginrefnamediv
tagrefname(compress-algo)
tagrefpurpose(iydraft(
use a specified compression algorithm
,
ΰ̥르ꥺ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(compress-algo) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Default is 2, which
is RFC1950 compression. You may use 1 to use the
old  zlib  version  which  is  used  by PGP. The
default  algorithm  may  give   better   results
because the window size is not limited to 8K. If
this is not used the OpenPGP behavior  is  used,
tagie, the compression algorithm is selected from
the preferences; note, that this can't  be  done
if you do not encrypt the data.
]],[[dnl
ϡ
RFC1950̤2Ǥ
PGPλȤΤzlibǤȤˤϡ1Ȥޤ
ɥ8K¤ʤΤǡ
ꥢ르ꥺϡɤ̤Ϳ뤫⤷ʤ
줬Ȥʤȡ
OpenPGPοȤޤ
ʤ鰵̥르ꥺӤޤ
ǡŹ沽ʤȡ
ϻǤޤΤǡ
ա
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(z)
beginrefnamediv
tagrefname(z)
tagrefpurpose(iydraft(
set compression level
,
̥٥
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(z) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Setting tagreplaceableparam(n) to 0 disables
compression.
The default is to use the default compression level for zlib (6).
Unlike all other options, this option may only be used from the command
line and is preceded with a single leading dash instead of two dashes.
]],[[dnl
tagreplaceableparam(n)0ꤹȡ
̵̤ˤʤޤ
Ǥϡzlibδ갵̥٥(6)Ȥޤ
¾ץȰ㤤
ΥץȤΤϡ
ޥɹԤǡ
2ĤΥåꡢ
1ĤΥå夬Ԥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(verbose)
beginrefnamediv
tagrefname(verbose)
tagrefpurpose(iydraft(
provide additional information during processing
,
ɲþ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(verbose)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
If used once provides extra information during processing.
If used twice, the input data is listed in detail.
]],[[dnl
1Ȥȡδ֤ɲþФޤ
2ȤȡϥǡΥꥹȤܺ٤ˤʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-verbose)
beginrefnamediv
tagrefname(no-verbose)
tagrefpurpose(iydraft(
resets verbosity to none
,
ν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-verbose)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This causes previous uses of the option
taglink(lock-once,tagoption(verbose)) to be
ignored.
]],[[dnl
ϡ
˻Ȥätaglink(lock-once,tagoption(verbose))ץ̵ˤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(quiet)
beginrefnamediv
tagrefname(quiet)
tagrefpurpose(iydraft(
supress informational output
,
Ϥ޻
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(quiet)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
As little extra output as possible is displayed.
]],[[dnl
;פʽϤΤǤ뤫ʤ褦ɽ򤪤ʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(textmode)
beginrefnamediv
tagrefname(textmode)
tagrefpurpose(iydraft(
use canonical text mode
,
ƥȡ⡼ɤλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(textmode)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
What good is this option?
]],[[dnl
Υץϡ
ɤΤ褦?
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(dry-run)
beginrefnamediv
tagrefname(dry-run)
tagrefpurpose(iydraft(
do not make changes
,
ѹ򤷤ʤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(dry-run)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is not completely implemented.
Use with care.
]],[[dnl
ϴ˼Ƥޤ
դƻȤäƤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(interactive)
beginrefnamediv
tagrefname(interactive)
tagrefpurpose(iydraft(
prompt before overwriting files
,
եΥץץ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(interactive)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(yes)
beginrefnamediv
tagrefname(yes)
tagrefpurpose(iydraft(
assume tagldquo[[]]yes[[]]tagrdquo to most questions
,
ʬμˡyesפȲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(yes)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(no)
beginrefnamediv
tagrefname(no)
tagrefpurpose(iydraft(
assume tagldquo[[]]no[[]]tagrdquo to most questions
,
ʬμˡnoפȲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(always-trust)
beginrefnamediv
tagrefname(always-trust)
tagrefpurpose(iydraft(
skip key validation
,
θڤξά
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(always-trust)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This assumes that used key are fully trusted.
This option should not be used unless some external 
scheme is used to validate used keys.
]],[[dnl
θʬ˿ѤǤȲꤷޤ
θͭȤ뤿ᡢ
볰ηϤȤΤǤʤʤ顢
ΥץȤ٤Ǥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(skip-verify)
beginrefnamediv
tagrefname(skip-verify)
tagrefpurpose(iydraft(
skip signature verification
,
̾ڤξά
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(skip-verify)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This causes signature verification steps to be skipped.
This leads to faster decryption times if signed messages are being
decrypted.
]],[[dnl
ˤꡢ̾ڥƥåפȤФޤ
̾줿å椷ƤȤ
֤äûʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(keyring)
beginrefnamediv
tagrefname(keyring)
tagrefpurpose(iydraft(
add a keyring to the list of keyrings
,
ؤΥꥹȤؤθؤɲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(keyring) tagreplaceableparam(file)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Adds tagreplaceableparam(file) to the list of
keyrings used during processings.
If  tagreplaceableparam(file) begins with
a tilde and a slash, these are replaced by the HOME directory.
If the filename does not contain a slash, it is assumed to be
in the home directory.
The home directory is tagldquo[[]]~/.gnupg[[]]tagrdquo if the option
taglink(homedir,tagoption(homedir)) is not used.
]],[[dnl
ǻȤؤΥꥹȤtagreplaceableparam(file)äޤ
tagreplaceableparam(file)ƥǤȥåǻϤޤʤ顢
ϥۡࡦǥ쥯ȥ꡼֤ޤ
Υե̾åޤޤʤʤ顢
ۡࡦǥ쥯ȥ꡼ˤȲꤷޤ
taglink(homedir,tagoption(homedir))ץȤʤС
ۡࡦǥ쥯ȥ꡼ϡ
tagldquo[[]]~/.gnupg[[]]tagrdquoǤ
]])dnl
endpara

beginpara
iydraft([[dnl
The filename tagreplaceableparam(file) may
also be prefixed with a scheme.
The scheme tagldquo[[]]gnupg-ring:tagrdquo makes the specified file the
default keyring.
The scheme tagldquo[[]]gnupg-gdbm:tagrdquo makes the specified file the
GDBM ring.
It may be useful to use these schemes together with the option
taglink(no-default-keyring,tagoption(no-default-keyring)).
]],[[dnl
ե̾tagreplaceableparam(file)ϡ
ƬĤ뤳ȤǤޤ
tagldquo[[]]gnupg-ring:tagrdquoϤϡΥեθؤˤޤ
tagldquo[[]]gnupg-gdbm:tagrdquoϤϡΥեGDBM󥰤ˤޤ
taglink(no-default-keyring,tagoption(no-default-keyring))ץȤäˤηȤȡ
⤷ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(secret-keyring)
beginrefnamediv
tagrefname(secret-keyring)
tagrefpurpose(iydraft(
add a secret keyring
,
̩ؤɲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(secret-keyring) tagreplaceableparam(file)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is the same as the option
taglink(keyring,tagoption(keyring)) but for secret
keyrings.
]],[[dnl
̩θؤǤ뤳ȤΤ
taglink(keyring,tagoption(keyring))ץƱǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-default-keyring)
beginrefnamediv
tagrefname(no-default-keyring)
tagrefpurpose(iydraft(
do not add the default keyrings to the list of keyrings
,
ؤΥꥹȤ˴θؤäʤ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-default-keyring)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The default keyrings taken from the home directory are not used during
processing.
]],[[dnl
ˡ
ۡࡦǥ쥯ȥ꡼ȤäθؤȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(homedir)
beginrefnamediv
tagrefname(homedir)
tagrefpurpose(iydraft(
set the home directory
,
ۡࡦǥ쥯ȥ꡼
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(homedir) tagreplaceableparam(directory)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
If this option is not used, the home directory defaults to 
tagldquo[[]]~/.gnupg[[]]tagrdquo.
This overrides the environment variable GNUPGHOME.
It does not make sense to use this in an options file.
]],[[dnl
ΥץȤʤȤδΥۡࡦǥ쥯ȥ꡼ϡ
tagldquo[[]]~/.gnupg[[]]tagrdquoǤ
ϡGNUPGHOMEĶѿͥ褷ޤ
ץ󡦥եǤȤäƤ̣ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(charset)
beginrefnamediv
tagrefname(charset)
tagrefpurpose(iydraft(
set the name of the native character set.
,
ʸ̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(charset) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is used to convert some strings to UTF-8 encoding.
Valid values for tagreplaceableparam(name) are
]],[[dnl
ϡ
ʸUTF-8󥳡ǥ󥰤ѴΤ˻Ȥޤ
tagreplaceableparam(name)Ȥͭͤϡ
ʲǤ
]])dnl
endpara

begininformaltable([[ frame="all"]])
begintgroup(2)
tag3thead(tagrow(tag1entry([[iydraft(Name,̾)]])
tag1entry([[iydraft(Character set,)]])))
tagtbody(tagrow(tag1entry(iso-8859-1)
tag1entry(The default Latin 1 set))

tagrow(tag1entry(iso-8859-2)
tag1entry(The Latin 2 set))

tagrow(tag1entry(koi8-r)
tag1entry(The usual Russian set (rfc1489))))
endtgroup
endinformaltable
endrefsect1
endrefentry

beginrefentry(no-literal)
beginrefnamediv
tagrefname(no-literal)
tagrefpurpose(?)
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-literal)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is not for normal use.
Use the source code to see how it might be useful.
]],[[dnl
ϡʻѤΤΤΤǤϤޤ
ΩĤɤˤϡ
ɤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(set-filesize)
beginrefnamediv
tagrefname(set-filesize)
tagrefpurpose(?)
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(set-filesize) tagreplaceableparam(size)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is not for normal use.
Use the source code to see how it might be useful.
]],[[dnl
ϡʻѤΤΤΤǤϤޤ
ΩĤɤˤϡ
ɤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(with-fingerprint)
beginrefnamediv
tagrefname(with-fingerprint)
tagrefpurpose(iydraft(
modifies key listing output
,
ΰϤν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(with-fingerprint) 
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This is similar to the command
taglink(fingerprint,tagoption(fingerprint)) but is
an option.
This appears to be for use with the command
taglink(list-keys,tagoption(list-keys)).
]],[[dnl
ϡ
taglink(fingerprint,tagoption(fingerprint))ޥɤƱͤǤ
ץǤ
ϡ
taglink(list-keys,tagoption(list-keys))ޥɤȤä˻ȤȤǤ礦
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(with-colons)
beginrefnamediv
tagrefname(with-colons)
tagrefpurpose(iydraft(
modifies key listing output
,
ΰϤν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(with-colons)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This causes keys displayed with the command
taglink(list-keys,tagoption(list-keys)) to be delimited
by colons.
]],[[dnl
ˤꡢ
taglink(list-keys,tagoption(list-keys))ޥɤɽ븰
Ƕڤ褦ˤʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(with-key-data)
beginrefnamediv
tagrefname(with-key-data)
tagrefpurpose(iydraft(
modifies key listing output
,
ΰϤν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(with-key-data)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This causes the command
taglink(list-keys,tagoption(list-keys)) to print keys
delimited by colons as well as the public key data for each key.
]],[[dnl
ˤꡢ
taglink(list-keys,tagoption(list-keys))ޥɤɽ븰
ƸθǡƱͤˡ
Ƕڤ褦ˤʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(lock-once)
beginrefnamediv
tagrefname(lock-once)
tagrefpurpose(iydraft(
locks the databases once
,
ǡ١1å
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(lock-once)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option locks the databases the first time a lock is requested and 
does not release the lock until the process terminates.
]],[[dnl
Υץϡ
ƥå׵ᤵ줿Ȥǡ١å
ץνλޤǥåޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(lock-multiple)
beginrefnamediv
tagrefname(lock-multiple)
tagrefpurpose(iydraft(
locks the databases each time they are used
,
ǡ١ȤӤ˥å
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(lock-multiple)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option locks the database each time it is needed and releases the
lock when done.
This option may be used to override the use of 
taglink(lock-once,tagoption(lock-once)) from the 
options file.
]],[[dnl
Υץϡ
ɬפˤƥǡ١å
ȥåޤ
Υץϡ
ץ󡦥եǻȤätaglink(lock-once,tagoption(lock-once))ͥ褵Τ˻Ȥޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(passphrase-fd)
beginrefnamediv
tagrefname(passphrase-fd)
tagrefpurpose(iydraft(
read the passphrase from a different input stream
,
㤦ϥȥ꡼फΥѥե졼ɼ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(passphrase-fd) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
If the parameter tagreplaceableparam(n) is 0,
the passphrase will be read from standard input.
This can be used if only one passphrase must be supplied.
Do not use this option if you can avoid it.
]],[[dnl
tagreplaceableparam(n)0ʤ顢
ѥե졼ɸϤɤޤޤ
1ĤΥѥե졼뤵ʤФʤʤʤ顢
줬Ȥޤ
⤷Ǥʤ顢
ΥץȤʤǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(force-mdc)
beginrefnamediv
tagrefname(force-mdc)
tagrefpurpose(iydraft(
force the use of encryption with appended manipulation code
,
ɤղäŹ沽ζ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(force-mdc)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option is always used with newer ciphers with a blocksize of
greater than 64 bits.
This option may not yet be implemented.
]],[[dnl
Υץϡ
֥å64ӥåȤĶ꿷ŹǾ˻Ȥޤ
Υץϡ̤⤷ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(force-v3-sigs)
beginrefnamediv
tagrefname(force-v3-sigs)
tagrefpurpose(iydraft(
force the use of v3 signatures on data
,
ǡˤĤƤv3̾ζ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(force-v3-sigs)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
OpenPGP states that an implementation should generate v4 signatures,
but PGP 5.x recognizes v4 signatures only on key material.
This option forces v3 signatures on data as well.
]],[[dnl
OpenPGPɽˤС
Ƽϡv4̾٤Ǥ
PGP 5.xϡ
ˤĤƤv4̾ǧޤ
Υץϡ
ǡˤĤƤv3̾פޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(openpgp)
beginrefnamediv
tagrefname(openpgp)
tagrefpurpose(iydraft([[dnl
reset all packet[[,]] cipher[[,]] and digest options to the OpenPGP specification
]],
ѥåȡŹ桢󥪥ץOpenPGPͤؤΥꥻå
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(openpgp)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option resets all previous options such as
taglink(rfc1991,tagoption(lock-once)),
taglink(force-v3-sigs,tagoption(lock-once)),
taglink(cipher-algo,tagoption(cipher-algo)),
taglink(digest-algo,tagoption(digest-algo)), 
taglink(compress-algo,tagoption(compress-algo)),
taglink(s2k-cipher-algo,tagoption(s2k-cipher-algo)),
taglink(s2k-digest-algo,tagoption(s2k-digest-algo)), and
taglink(s2k-mode,tagoption(s2k-mode))
to OpenPGP compliant values.
]],[[dnl
ΥץϡҤ
taglink(rfc1991,tagoption(lock-once))
taglink(force-v3-sigs,tagoption(lock-once))
taglink(cipher-algo,tagoption(cipher-algo))
taglink(digest-algo,tagoption(digest-algo))
taglink(compress-algo,tagoption(compress-algo))
taglink(s2k-cipher-algo,tagoption(s2k-cipher-algo))
taglink(s2k-digest-algo,tagoption(s2k-digest-algo))
taglink(s2k-mode,tagoption(s2k-mode))
ȤäץꥻåȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(utf8-strings)
beginrefnamediv
tagrefname(utf8-strings)
tagrefpurpose(iydraft(
assume that arguments are provided as UTF8 strings
,
UTF8ʸȲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(utf8-strings)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Option arguments following this option are assumed to be encoded as
UTF8 strings.
]],[[dnl
Υץθ³ץϡ
UTF8ʸȤ沽Ƥ롢
Ȳꤵޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-utf8-strings)
beginrefnamediv
tagrefname(no-utf8-strings)
tagrefpurpose(iydraft(
assume that arguments are not provided as UTF8 strings
,
UTF8ʸȲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-utf8-strings)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Option arguments following this option are assumed to be
encoded in the character set specified with the option 
taglink(charset,tagoption(charset)).
This is the default behavior for taggpg.
]],[[dnl
Υץθ³ץϡ
taglink(charset,tagoption(charset))ץǻꤵ줿ʸ沽Ƥ롢
Ȳꤵޤ
ϡtaggpgδοǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-options)
beginrefnamediv
tagrefname(no-options)
tagrefpurpose(iydraft(
use no options file
,
ץ󡦥եԻ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-options)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option is processed before an attempt is made to open an options
file.
]],[[dnl
ץ󡦥ե򳫤Ȥˡ
Υץ󤬽ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(debug)
beginrefnamediv
tagrefname(debug)
tagrefpurpose(iydraft(
set debug flags
,
ǥХåե饰
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(debug) tagreplaceableparam(flags)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(flags) is
built by applying a logical OR on individual flags.
The parameter may be given in C syntax, tageg, 0x0042.
The flags are
]],[[dnl
tagreplaceableparam(flags)ϡ
ġΥե饰¤ȤäƤǤޤ
ϡȤ0x0042Τ褦CιʸǤ뤳ȤǤޤ
ʲե饰Ǥ
]])dnl
endpara

begininformaltable([[ frame="all"]])
begintgroup(2)
tag3thead(tagrow(tag1entry(Flag)
tag1entry(Meaning)))
tagtbody(tagrow(tag1entry(1)
tag1entry(Packet reading and writing details))

tagrow(tag1entry(2)
tag1entry(MPI details))

tagrow(tag1entry(4)
tag1entry(cipher and prime number details (may reveal sensitive data)))

tagrow(tag1entry(8)
tag1entry(Iobuf filter functions))

tagrow(tag1entry(16)
tag1entry(Iobuf details))

tagrow(tag1entry(32)
tag1entry(Memory allocation details))

tagrow(tag1entry(64)
tag1entry(Caching))

tagrow(tag1entry(128)
tag1entry(Show memory statistics on exit))

tagrow(tag1entry(256)
tag1entry(Trust verification details)))
endtgroup
endinformaltable
endrefsect1
endrefentry

beginrefentry(debug-all)
beginrefnamediv
tagrefname(debug-all)
tagrefpurpose(iydraft(
set all useful debugging flags
,
ƤͭפʥǥХåե饰
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(debug-all)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
See also the option taglink(debug,tagoption(debug)).
]],[[dnl
taglink(debug,tagoption(debug))ץ󻲾ȡ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(status-fd)
beginrefnamediv
tagrefname(status-fd)
tagrefpurpose(iydraft(
write status messages to an alternative output stream
,
ؽϥȥ꡼ؤξ֥å
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(status-fd) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option causes status messages to be redirected to file descriptor
tagreplaceableparam(n).
See the file tagfilename(DETAILS) in the distribution for
a listing of the messages.
]],[[dnl
Υץˤꡢ
֥åϥե뵭һtagreplaceableparam(n)˸ľޤ
åΰˤĤƤϡ
ʪtagfilename(DETAILS)ե
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(logger-fd)
beginrefnamediv
tagrefname(logger-fd)
tagrefpurpose(iydraft(
write log messages to an alternative output stream
,
ؽϥȥ꡼ؤΥå
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(logger-fd) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option causes log messages to be redirected to file descriptor
tagreplaceableparam(n) instead of to standard
error.
]],[[dnl
Υץˤꡢ
åϡ
ɸ२顼˥ե뵭һtagreplaceableparam(n)˸ľޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-comment)
beginrefnamediv
tagrefname(no-comment)
tagrefpurpose(iydraft(
do not write comment packets
,
ȤΥѥåȤ޻
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-comment) 
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option affects only the generation of secret keys.
Output of option (comment?) packets is disabled since version 0.4.2
of taggnupg.
]],[[dnl
Υץϡ
̩˱ƶޤ
ץ(?)ѥåȤνϤϡ
taggnupg0.4.2ǰʹ̵ˤʤäƤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(comment)
beginrefnamediv
tagrefname(comment)
tagrefpurpose(iydraft(
set the comment string to use in cleartext signatures
,
ꥢƥȽ̾ǻȤʸ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(comment) tagreplaceableparam(string)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(default-comment)
beginrefnamediv
tagrefname(default-comment)
tagrefpurpose(iydraft(
use the standard comment string in cleartext signatures
,
ꥢƥȽ̾Ǥɸॳʸλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(default-comment)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option overrides previous uses of 
the option taglink(comment,tagoption(comment)).
]],[[dnl
Υץϡ
Ҥtaglink(comment,tagoption(comment))ץλѤͥ褷ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(no-version)
beginrefnamediv
tagrefname(no-version)
tagrefpurpose(iydraft(
omit the version string in clear text signatures
,
ꥢƥȽ̾ǤΥСʸξά
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(no-version)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft(
Enough said.
,
鷺⤬ʡ
)dnl
endpara
endrefsect1
endrefentry

beginrefentry(emit-version)
beginrefnamediv
tagrefname(emit-version)
tagrefpurpose(iydraft(
emit the version string in cleartext signatures
,
ꥢƥȽ̾ǤΥСʸν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(emit-version)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option overrides previous uses of 
the option taglink(no-version,tagoption(no-version)).
]],[[dnl
Υץϡ
Ҥtaglink(no-version,tagoption(no-version))ץλѤͥ褷ޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(notation-data)
beginrefnamediv
tagrefname(notation-data)
tagrefpurpose(iydraft(
add data to a signature as notation data
,
ɽǡȤƥǡؤν̾ɲ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(notation-data) tagreplaceableparam(name=value)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This adds the 
tagreplaceableparam(name)/tagreplaceableparam(value) pair to a signature.
The parameter tagreplaceableparam(name) 
must consist of an alphabetic character followed by any number of alphanumeric
or underscore characters.
The parameter tagreplaceableparam(value)  may be
any printable string.
It will be encoded in UTF8, so it is important that 
the option taglink(charset,tagoption(charset)) is
used to set the character set properly.
If the parameter tagreplaceableparam(name) is
prefixed with an exclamation mark, the notation data will be
flagged as critical (see rfc2440:5.2.3.15).
]],[[dnl
ϡ
tagreplaceableparam(name)/tagreplaceableparam(value)Ф̾˲äޤ
tagreplaceableparam(name)ϡ
ѻȤθǤդοαѿʸʤФʤޤ
tagreplaceableparam(value)ϡ
ǤոĤΰǽʸǤ褤Ǥ
ϡUTF8沽ޤ
äơ
ʸŬڤꤹ뤿ᡢ
taglink(charset,tagoption(charset))ץλѤפǤ
⤷tagreplaceableparam(name)òǻϤޤʤ顢
ɽǡˡ
ɤ(critical)ե饰
(rfc2440:5.2.3.15)
ΩƤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(set-policy-url)
beginrefnamediv
tagrefname(set-policy-url)
tagrefpurpose(iydraft(
set the policy URL for signatures
,
̾ΥݥꥷURL
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(set-policy-url) tagreplaceableparam(string)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter
tagreplaceableparam(string) is used as the policy
URL for signatures (see rfc2440:5.2.3.19).
If the string is prefixed with an exclamation mark, the policy URL packet
will be flagged as critical.
]],[[dnl
̾ΥݥꥷURL
(rfc2440:5.2.3.19)
Ȥơ
tagreplaceableparam(string)Ȥޤ
⤷tagreplaceableparam(string)òǻϤޤʤ顢
ݥꥷURLѥåȤˡ
ɤե饰ΩƤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(set-filename)
beginrefnamediv
tagrefname(set-filename)
tagrefpurpose(iydraft(
sets the filename stored in encrypted or signed messages
,
Ź沽̾å˳Ǽե̾
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(set-filename) tagreplaceableparam(string)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter
tagreplaceableparam(string) is used as the filename
stored in messages.
Does this specify the output file when a message is verified or decrypted?
]],[[dnl
å˳Ǽե̾Ȥơ
tagreplaceableparam(string)Ȥޤ
åڤ椵Ȥ
줬ϥեꤹΤ?
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(use-embedded-filename)
beginrefnamediv
tagrefname(use-embedded-filename)
tagrefpurpose(iydraft(
use the filename embedded in a message for storing its plaintext or verified
version
,
ץ졼ޤϸѥƥȤγǼؤΥåؤߥե̾λ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(use-embedded-filename)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option should be used with care since it may overwrite files.
]],[[dnl
ե˾񤭤뤫⤷ʤΤǡ
ΥץդƻȤ٤Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(max-cert-depth)
beginrefnamediv
tagrefname(max-cert-depth)
tagrefpurpose(iydraft(
set the maximum depth of a certification chain
,
Ϣκο
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(max-cert-depth) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(n) sets the
maximum length of a chain of certified keys leading from an ultimately
trusted key to a key being validated.
The default is 5.
]],[[dnl
tagreplaceableparam(n)ϡ
Ū˿Ѥ줿鸡θؤΡ
줿ϢκĹꤷޤ
Ĺϡ
5Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(digest-algo)
beginrefnamediv
tagrefname(digest-algo)
tagrefpurpose(iydraft(
set the message digest algorithm
,
å󥢥르ꥺ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(digest-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(name) specifies
the name of the digest algorithm to be used.
Running taggpg with the command
taglink(version,tagoption(version)) gives a list of
supported digest algorithms.
Note that this option may violate the OpenPGP requirement that a
160-bit digest algorithm be used for DSA.
For symmetric encryption, the default algorithm is RIPEMD-160.
]],[[dnl
tagreplaceableparam(name)ϡ
Ѥ٤󥢥르ꥺꤷޤ
taggpgtaglink(version,tagoption(version))ޥɤưȡ
ٱ礵줿󥢥르ꥺΥꥹȤȤޤ
DSA160ӥåȡ󥢥르ꥺȤȤOpenPGP׷ˡ
Υץȿ뤫⤷ʤ
ȤȤդƤ
оΰŹǤδΥ르ꥺϡ
RIPEMD-160Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(s2k-cipher-algo)
beginrefnamediv
tagrefname(s2k-cipher-algo)
tagrefpurpose(iydraft(
use a specified algorithm as the symmetric cipher for encrypting private keys
,
̩оŪŹ沽르ꥺλ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(s2k-cipher-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Use tagparameter(name) as the symmetric cipher algorithm to
protect private keys. 
Running the taggpg with the command 
taglink(version,tagoption(version)) yields a 
list of supported  algorithms.
The default cipher is Blowfish.
]],[[dnl
̩ʸޤ뤿оΰŹ楢르ꥺȤtagparameter(name)Ȥޤ
taggpgtaglink(version,tagoption(version))ޥɤưȡ
ٱ礵줿르ꥺΥꥹȤȤޤ
ΰŹϡBlowfishǤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(s2k-digest-algo)
beginrefnamediv
tagrefname(s2k-digest-algo)
tagrefpurpose(iydraft(
set the message digest algorithm for mangling passphrases protecting private
keys
,
̩ޤѥե졼Υå󥢥르ꥺ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(s2k-digest-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(name) specifies
the name of the digest algorithm to be used for mangling passphrases.
The default algorithm is RIPEMD-160.
]],[[dnl
ѥե졼򤫤뤿˻Ȥ󥢥르ꥺ̾Ȥơ
tagreplaceableparam(name)ꤷޤ
Υ르ꥺϡ
RIPEMD-160Ǥ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(s2k-mode)
beginrefnamediv
tagrefname(s2k-mode)
tagrefpurpose(iydraft(
sets how passphrases are mangled
,
ѥե졼Τ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(s2k-mode) tagreplaceableparam(n)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter 
tagreplaceableparam(n)
specifies
the number of times to which a salt is added to passphrases.
If tagreplaceableparam(n) is 0 a plain passphrase
will be used.
One iteration is the default.
Unless the option
taglink(rfc1991,tagoption(rfc1991)) is used, this mode
is also used for the passphrase for symmetric encryption.
]],[[dnl
ѥե졼˱äȤơ
tagreplaceableparam(n)ꤷޤ
tagreplaceableparam(n)0ʤ顢ѥե졼򤽤Τޤ޻Ȥޤ
Ǥ1Ǥ
taglink(rfc1991,tagoption(rfc1991))ץȤʤС
оŪŹ沽Υѥե졼ˤȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(disable-cipher-algo)
beginrefnamediv
tagrefname(disable-cipher-algo)
tagrefpurpose(iydraft(
prevents a symmetric cipher from being used
,
оŪŹλѶػ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(disable-cipher-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(name) specifies
the name of a symmetric cipher algorithm to be disabled.
If the named cipher is loaded after this option is processed it will
not be disabled.
]],[[dnl
̵ȤоΰŹ楢르ꥺ̾Ȥơ
tagreplaceableparam(name)ꤷޤ
Υץ󤬽줿塢
ΰŹ椬ɤȡ
̵ǤϤʤʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(disable-pubkey-algo)
beginrefnamediv
tagrefname(disable-pubkey-algo)
tagrefpurpose(iydraft(
prevents a public key cipher from being used
,
ŹλѶػ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(disable-pubkey-algo) tagreplaceableparam(name)
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
The parameter tagreplaceableparam(name) specifies
the name of a public key cipher algorithm to be disabled.
If the named cipher is loaded after this option is processed it will
not be disabled.
]],[[dnl
̵ȤŹ楢르ꥺ̾Ȥơ
tagreplaceableparam(name)ꤷޤ
Υץ󤬽줿塢
ΰŹ椬ɤȡ
̵ǤϤʤʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(throw-keyid)
beginrefnamediv
tagrefname(throw-keyid)
tagrefpurpose(iydraft(
do not put key IDs into encrypted packets
,
Ź沽ѥåȤθIDά
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(throw-keyid) 
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option hides the receiver of the encrypted data as a countermeasure 
against traffic analysis.
It slows decryption, however, since in the worst case all the keys on
a receiver's private keyring must be tried to find the decryption key.
]],[[dnl
Υץϡ
ȥեåʬϤؤкȤưŹ沽ǡμ򱣤ޤ

渰򸫤Ĥ뤿ˡ
ǰξ硢
̩ؤθᤵʤФʤʤΤǡ
٤ʤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(not-dash-escaped)
beginrefnamediv
tagrefname(not-dash-escaped)
tagrefpurpose(iydraft(
changes the format of cleartext signatures
,
ꥢƥȽ̾ѹ
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(not-dash-escaped) 
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
This option is useful for cleartext signatures on patch files.
Messages signed this way should not be sent via email because all spaces
and line endings are hashed too.
This option cannot be used for data which has five dashes at the
beginning of a line.
A special header line is used to tell taggnupg that this option has
been used.
]],[[dnl
ΥץϡѥåեΥꥢƥȽ̾Ǥ롣
Τ褦˽̾줿åŻҥ᡼ͳ٤ǤϤޤ
ʤʤ顢ֳ֤ȹڤ뤫Ǥ
Ƭ5ĤΥåΤǡˤϡ
ΥץȤäƤϤޤ
ΥץȤäȤtaggnupgˤ狼褦ˡ
̤ʥإåԤȤޤ
]])dnl
endpara
endrefsect1
endrefentry

beginrefentry(escape-from-lines)
beginrefnamediv
tagrefname(escape-from-lines)
tagrefpurpose(iydraft([[dnl
modifies messages beginning with tagldquo[[]]From[[]]tagrdquo when cleartext signing
]],
ꥢƥȽ̾Ǥtagldquo[[]]From[[]]tagrdquoǻϤޤåν
)[[dnl]])
endrefnamediv
tagrefsynopsisdiv(eltsynopsis([[iyiftexi([[dnl]])
tagoption(escape-from-lines) 
]]))

beginrefsect1
atc([[tagtitle([[iyiftexi([[dnl]])
iydraft(
Description
,

)]])]])

beginpara
iydraft([[dnl
Because some mailers change lines starting with tagldquo[[]]From[[]]tagrdquo to
tagldquo[[]]taggt[[]]From[[]]tagrdquo this option is useful for instructing taggpg to
handle such lines specially when creating cleartext signatures.
All other PGP versions do it this way too.  
This option is not enabled by default because it would violate rfc2440.
]],[[dnl
Υ᡼顼
tagldquo[[]]From[[]]tagrdquo
ǻϤޤԤ
tagldquo[[]]taggt[[]]From[[]]tagrdquo
ˤޤ
Υץꤹȡ
taggpgϡ
ꥢƥȽ̾ΤȤ
äԤ̤˰ޤ
¾PGPСǤ⤳ʤäƤޤ
rfc2440ȿΤǡ
ǤͭˤʤäƤޤ
]])dnl
endpara
endrefsect1
endrefentry

endreference

