;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; sample file of .emacs or .mew.el
;;;
;
; This is just a sample. You should customize as you like...
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Site configuration
;;;

;(autoload 'mew "mew" nil t)
;(autoload 'mew-send "mew" nil t)
;; (setq mew-name "your name") ;; (user-full-name)
;; (setq mew-user "user name of e-mail address") ;; (user-login-name)
;(setq mew-mail-domain "domain of e-mail address")
;; (setq mew-pop-user "your POP account")   ;; (user-login-name)
;(setq mew-pop-server "your POP server")    ;; if not localhost
;(setq mew-smtp-server "your SMTP server")  ;; if not localhost
;(setq mew-icon-directory "icon directory") ;; if using XEmacs/Emacs 21
;; See also mew-config-alist for advanced use
;
;; To use local mailbox "mbox" or "maildir" instead of POP
;(setq mew-mailbox-type 'mbox)
;(setq mew-mbox-command "incm")
;(setq mew-mbox-command-arg "-d /path/to/mbox")
;; If /path/to/mbox is a file, it means "mbox".
;; If /path/to/mbox is a directory, it means "maildir".
;
;; Optional setup (Read Mail menu for Emacs 21):
;(if (boundp 'read-mail-command)
;    (setq read-mail-command 'mew))
;
;; Optional setup (e.g. C-xm for sending a message):
;(autoload 'mew-user-agent-compose "mew" nil t)
;(if (boundp 'mail-user-agent)
;    (setq mail-user-agent 'mew-user-agent))
;(if (fboundp 'define-mail-user-agent)
;    (define-mail-user-agent
;      'mew-user-agent
;      'mew-user-agent-compose
;      'mew-draft-send-message
;      'mew-draft-kill
;      'mew-send-hook))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Window tips
;;;

;; If you use XEmacs and your video chip provides only limited
;; color map(e.g. 256), put the following line to avoid exhaustion
;; of colors.
;(setq mew-demo-picture nil)

(cond
 ((featurep 'xemacs)
;  (setq-default buffer-file-coding-system 'iso-2022-jp)
;  (setq keyboard-coding-system    'iso-2022-jp)
;  (setq terminal-coding-system    'iso-2022-jp)
  (add-menu-item '("Apps") "Read Mail (Mew)" 'mew t "Read Mail (VM)...")
  (add-menu-item '("Apps") "Send Mail (Mew)" 'mew-send t "Read Mail (VM)...")
  (delete-menu-item '("Apps" "Read Mail (VM)..."))
  (delete-menu-item '("Apps" "Read Mail (MH)..."))
  (delete-menu-item '("Apps" "Send mail..."))
  (setq toolbar-mail-reader 'Mew)
  (setq toolbar-mail-commands-alist
	(cons '(Mew . mew) toolbar-mail-commands-alist))
  )
 ((>= emacs-major-version 20)
;  (setq standard-fontset-spec14
;	"-*-fixed-medium-r-normal-*-14-*-*-*-*-*-fontset-standard")
;  (create-fontset-from-fontset-spec standard-fontset-spec14 nil 'noerror)
;  (setq default-frame-alist 
;	(cons (cons 'font standard-fontset-spec14) default-frame-alist)))
  (set-face-font 'bold '(bold) t)
  (set-face-font 'italic '(italic) t)
  (set-face-font 'bold-italic '(bold italic) t)
;  (set-language-environment "Japanese")
  )
 (t ;; Mule 2.3 or Emacs 19
  )
 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Citation tip
;;;
;;;
;;; From: Kazu-kun
;;; Subject: Hello World
;;; Date: Thu, 08 Dec 1994 11:44:08 +0900
;;; Message-Id: <199509291309.WAA21663@decpc07.aist-nara.ac.jp>
;;;
;;; Kazu-kun> The quick brown fox jumped over the very lazy dog.
;;;

(setq mew-cite-fields '("From:" "Subject:" "Date:" "Message-ID:"))
(setq mew-cite-format "From: %s\nSubject: %s\nDate: %s\nMessage-ID: %s\n\n")
(setq mew-cite-prefix-function 'mew-cite-prefix-username)
;(setq mew-addrbook-for-cite-label 'nickname)
;(setq mew-addrbook-for-cite-prefix 'nickname)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Pick macro
;;;

;(mew-pick-define-macro "tocc=#" "to=#|cc=#")
;(mew-pick-define-macro "mew" "tocc=mew")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; C-u ? and M-n
;;;

;; To whose who want to search Japanese key in the entire of messages.
;; ftp://ftp.iij.ad.jp/pub/IIJ/dist/utashiro/perl/mg-xxx
;; ftp://ftp.iij.ad.jp/pub/IIJ/dist/utashiro/perl/jcode-xxx.pl
;;
;; (setq mew-prog-grep "mg")
;;
;; 1. Search an EUC key (after converting to JIS) on JIS messages.
;; (setq mew-prog-grep-opts '("-j" "jis" "-l" "-e"))
;;
;; 2. Search an EUC key (after converting to JIS) on JIS messages
;;    decoding their encoded-words.
;; (setq mew-prog-grep-opts '("-j" "jis" "-l" "-e" "-x" "&mime"))
;;
;; 3. Search an EUC key on JIS messages after converting to EUC by nkf.
;; (setq mew-prog-grep-opts '("-l" "-e" "-z" "nkf -e"))
;;
;; 4. Search an EUC key on JIS messages after converting to EUC
;;    and decoding their encoded-words by nkf. Make sure that
;;    "nkf" has the "-m" option.
;; (setq mew-prog-grep-opts '("-l" "-e" "-z" "nkf -e -m"))
;;
;; Set mew-prog-vgrep and mew-prog-vgrep-opts also.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Using "Mozilla"
;;;

;(setq mew-prog-text/html-ext "mozilla")

;(define-key mew-message-mode-map [mouse-2] 'browse-url-at-mouse)
;(setq browse-url-netscape-program "mozilla")
;(setq thing-at-point-url-path-regexp "[~/A-Za-z0-9---_.${}#%,:]+")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Using "w3m" with "mew-w3m.el"
;;;

;(setq mew-mime-multipart-alternative-list '("Text/Html" "Text/Plain" "*."))

;(condition-case nil
;    (require 'mew-w3m)
;  (file-error nil))
;(setq w3m-type 'w3m-m17n)

;;;
;;; End
;;;
