;;; -*- coding: iso-2022-7bit  -*-
;;; uiso8859-7.el --- tables between UCS and ISO-8859-7

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from 8859-7.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'greek-iso8859-7 'unicode 'iso-8859-7-vs-unicode-assoc)

(defvar
  iso-8859-7-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,F (B . ?\x00A0) ;; NO-BREAK SPACE
     (?,F!(B . ?\x02BD) ;; MODIFIER LETTER REVERSED COMMA
     (?,F"(B . ?\x02BC) ;; MODIFIER LETTER APOSTROPHE
     (?,F#(B . ?\x00A3) ;; POUND SIGN
     (?,F&(B . ?\x00A6) ;; BROKEN BAR
     (?,F'(B . ?\x00A7) ;; SECTION SIGN
     (?,F((B . ?\x00A8) ;; DIAERESIS
     (?,F)(B . ?\x00A9) ;; COPYRIGHT SIGN
     (?,F+(B . ?\x00AB) ;; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,F,(B . ?\x00AC) ;; NOT SIGN
     (?,F-(B . ?\x00AD) ;; SOFT HYPHEN
     (?,F/(B . ?\x2015) ;; HORIZONTAL BAR
     (?,F0(B . ?\x00B0) ;; DEGREE SIGN
     (?,F1(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?,F2(B . ?\x00B2) ;; SUPERSCRIPT TWO
     (?,F3(B . ?\x00B3) ;; SUPERSCRIPT THREE
     (?,F4(B . ?\x0384) ;; GREEK TONOS
     (?,F5(B . ?\x0385) ;; GREEK DIALYTIKA TONOS
     (?,F6(B . ?\x0386) ;; GREEK CAPITAL LETTER ALPHA WITH TONOS
     (?,F7(B . ?\x00B7) ;; MIDDLE DOT
     (?,F8(B . ?\x0388) ;; GREEK CAPITAL LETTER EPSILON WITH TONOS
     (?,F9(B . ?\x0389) ;; GREEK CAPITAL LETTER ETA WITH TONOS
     (?,F:(B . ?\x038A) ;; GREEK CAPITAL LETTER IOTA WITH TONOS
     (?,F;(B . ?\x00BB) ;; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     (?,F<(B . ?\x038C) ;; GREEK CAPITAL LETTER OMICRON WITH TONOS
     (?,F=(B . ?\x00BD) ;; VULGAR FRACTION ONE HALF
     (?,F>(B . ?\x038E) ;; GREEK CAPITAL LETTER UPSILON WITH TONOS
     (?,F?(B . ?\x038F) ;; GREEK CAPITAL LETTER OMEGA WITH TONOS
     (?,F@(B . ?\x0390) ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
     (?,FA(B . ?\x0391) ;; GREEK CAPITAL LETTER ALPHA
     (?,FB(B . ?\x0392) ;; GREEK CAPITAL LETTER BETA
     (?,FC(B . ?\x0393) ;; GREEK CAPITAL LETTER GAMMA
     (?,FD(B . ?\x0394) ;; GREEK CAPITAL LETTER DELTA
     (?,FE(B . ?\x0395) ;; GREEK CAPITAL LETTER EPSILON
     (?,FF(B . ?\x0396) ;; GREEK CAPITAL LETTER ZETA
     (?,FG(B . ?\x0397) ;; GREEK CAPITAL LETTER ETA
     (?,FH(B . ?\x0398) ;; GREEK CAPITAL LETTER THETA
     (?,FI(B . ?\x0399) ;; GREEK CAPITAL LETTER IOTA
     (?,FJ(B . ?\x039A) ;; GREEK CAPITAL LETTER KAPPA
     (?,FK(B . ?\x039B) ;; GREEK CAPITAL LETTER LAMDA
     (?,FL(B . ?\x039C) ;; GREEK CAPITAL LETTER MU
     (?,FM(B . ?\x039D) ;; GREEK CAPITAL LETTER NU
     (?,FN(B . ?\x039E) ;; GREEK CAPITAL LETTER XI
     (?,FO(B . ?\x039F) ;; GREEK CAPITAL LETTER OMICRON
     (?,FP(B . ?\x03A0) ;; GREEK CAPITAL LETTER PI
     (?,FQ(B . ?\x03A1) ;; GREEK CAPITAL LETTER RHO
     (?,FS(B . ?\x03A3) ;; GREEK CAPITAL LETTER SIGMA
     (?,FT(B . ?\x03A4) ;; GREEK CAPITAL LETTER TAU
     (?,FU(B . ?\x03A5) ;; GREEK CAPITAL LETTER UPSILON
     (?,FV(B . ?\x03A6) ;; GREEK CAPITAL LETTER PHI
     (?,FW(B . ?\x03A7) ;; GREEK CAPITAL LETTER CHI
     (?,FX(B . ?\x03A8) ;; GREEK CAPITAL LETTER PSI
     (?,FY(B . ?\x03A9) ;; GREEK CAPITAL LETTER OMEGA
     (?,FZ(B . ?\x03AA) ;; GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
     (?,F[(B . ?\x03AB) ;; GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
     (?,F\(B . ?\x03AC) ;; GREEK SMALL LETTER ALPHA WITH TONOS
     (?,F](B . ?\x03AD) ;; GREEK SMALL LETTER EPSILON WITH TONOS
     (?,F^(B . ?\x03AE) ;; GREEK SMALL LETTER ETA WITH TONOS
     (?,F_(B . ?\x03AF) ;; GREEK SMALL LETTER IOTA WITH TONOS
     (?,F`(B . ?\x03B0) ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
     (?,Fa(B . ?\x03B1) ;; GREEK SMALL LETTER ALPHA
     (?,Fb(B . ?\x03B2) ;; GREEK SMALL LETTER BETA
     (?,Fc(B . ?\x03B3) ;; GREEK SMALL LETTER GAMMA
     (?,Fd(B . ?\x03B4) ;; GREEK SMALL LETTER DELTA
     (?,Fe(B . ?\x03B5) ;; GREEK SMALL LETTER EPSILON
     (?,Ff(B . ?\x03B6) ;; GREEK SMALL LETTER ZETA
     (?,Fg(B . ?\x03B7) ;; GREEK SMALL LETTER ETA
     (?,Fh(B . ?\x03B8) ;; GREEK SMALL LETTER THETA
     (?,Fi(B . ?\x03B9) ;; GREEK SMALL LETTER IOTA
     (?,Fj(B . ?\x03BA) ;; GREEK SMALL LETTER KAPPA
     (?,Fk(B . ?\x03BB) ;; GREEK SMALL LETTER LAMDA
     (?,Fl(B . ?\x03BC) ;; GREEK SMALL LETTER MU
     (?,Fm(B . ?\x03BD) ;; GREEK SMALL LETTER NU
     (?,Fn(B . ?\x03BE) ;; GREEK SMALL LETTER XI
     (?,Fo(B . ?\x03BF) ;; GREEK SMALL LETTER OMICRON
     (?,Fp(B . ?\x03C0) ;; GREEK SMALL LETTER PI
     (?,Fq(B . ?\x03C1) ;; GREEK SMALL LETTER RHO
     (?,Fr(B . ?\x03C2) ;; GREEK SMALL LETTER FINAL SIGMA
     (?,Fs(B . ?\x03C3) ;; GREEK SMALL LETTER SIGMA
     (?,Ft(B . ?\x03C4) ;; GREEK SMALL LETTER TAU
     (?,Fu(B . ?\x03C5) ;; GREEK SMALL LETTER UPSILON
     (?,Fv(B . ?\x03C6) ;; GREEK SMALL LETTER PHI
     (?,Fw(B . ?\x03C7) ;; GREEK SMALL LETTER CHI
     (?,Fx(B . ?\x03C8) ;; GREEK SMALL LETTER PSI
     (?,Fy(B . ?\x03C9) ;; GREEK SMALL LETTER OMEGA
     (?,Fz(B . ?\x03CA) ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA
     (?,F{(B . ?\x03CB) ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA
     (?,F|(B . ?\x03CC) ;; GREEK SMALL LETTER OMICRON WITH TONOS
     (?,F}(B . ?\x03CD) ;; GREEK SMALL LETTER UPSILON WITH TONOS
     (?,F~(B . ?\x03CE) ;; GREEK SMALL LETTER OMEGA WITH TONOS
     )))

(provide 'uiso8859-7)
 