;;; -*- coding: iso-2022-7bit  -*-
;;; big5-sample.el --- sample configuration for big5conv

;; Copyright (C) 1999 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           MULE-UCS, Big5, CNS, Traditional Chinese

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(eval-when-compile
  (load-file "big5conv.el")

  (tae-declare-translation
   'big5-sample-translation
   `(| ,big5conv-ascii-assoc
       ,big5conv-emacs-char-1-vs-big5-assoc))

  (tae-declare-translation
   'big5-sample-mac-translation
   `(| (assoc (char-1 . big5)
	      ((?\x0A . ?\x0D)))
       big5-sample-translation))

  (defun big5-sample-decode-template (tr read write)
    (mucs-ccl-stream-form
     (mucs-ccl-read 'big5 read)
     (tae-compile tr t)
     (mucs-ccl-write write)))

  (defun big5-sample-encode-template (tr read write)
    (mucs-ccl-stream-form
     (mucs-ccl-read 'char-packed-1 read)
     (tae-compile tr nil)
     (mucs-ccl-write write)))

  (defvar big5-sample-coding-system-alist
    '((safe-charsets .
		     (ascii
		      chinese-cns11643-1
		      chinese-cns11643-2
;;		      japanese-jisx0208
;;		      chinese-gb2312
		      ))
      (mime-charset . cn-big5)))
  )

;;
;; coding system definitions.
;;

(mucs-define-package
 big5-sample

;; 
 (mucs-define-simple-coding-system
  big5-conv-unix ?B
  "Big5 coding system which convert Big5 characters to mainly CNS ones."
  (big5conv-decode-buffer-magnification
   ((big5-sample-decode-template
     'big5-sample-translation 'big5-be-2-octet 'emacs-mule)))
  (big5conv-encode-buffer-magnification
   ((big5-sample-encode-template
     'big5-sample-translation 'emacs-mule 'big5-be-2-octet)))
  big5-sample-coding-system-alist)

 (mucs-define-simple-coding-system
  big5-conv-dos ?B
  "Big5 coding system which convert Big5 characters to mainly CNS ones."
  (big5conv-decode-buffer-magnification
   ((big5-sample-decode-template
     'big5-sample-translation 'big5-be-2-octet 'emacs-mule-dos)))
  (big5conv-encode-buffer-magnification
   ((big5-sample-encode-template
     'big5-sample-translation 'emacs-mule 'big5-be-2-octet-dos)))
  big5-sample-coding-system-alist)

 (mucs-define-simple-coding-system
  big5-conv-mac ?B
  "Big5 coding system which convert Big5 characters to mainly CNS ones."
  (big5conv-decode-buffer-magnification
   ((big5-sample-decode-template
     'big5-sample-mac-translation 'big5-be-2-octet 'emacs-mule)))
  (big5conv-encode-buffer-magnification
   ((big5-sample-encode-template
     'big5-sample-mac-translation 'emacs-mule 'big5-be-2-octet)))
  big5-sample-coding-system-alist)

 (define-coding-system-alias 'big5-conv 'big5-conv-unix)

)

(provide 'big5-sample)




   
