; -*- coding: iso-2022-jp-3  -*-
;;; ujisx0213.el --- tables between UCS and JIS X 0213-2000

;;; This file is converted from X0213.csv of JIS committee.

(put 'japanese-jisx0213-1 'unicode-assoc
     'jis-x-0213-2000-1-vs-unicode-assoc)
(put 'japanese-jisx0213-2 'unicode-assoc
     'jis-x-0213-2000-2-vs-unicode-assoc)

(defvar
  jis-x-0213-2000-1-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(O"/(B . ?\x0027);; $(O%"%]%9%H%m%U%#(B
     (?$(O"0(B . ?\x0022);; $(O0zMQId(B
     (?$(O"1(B . ?\x002D);; $(O%O%$%U%s%^%$%J%9(B
     (?$(O"2(B . ?\x007E);; $(O%A%k%I(B
     (?$(O"3(B . ?\x3033);; $(O$/$N;zE@>e(B
     (?$(O"4(B . ?\x3034);; $(O$/$N;zE@>e(B($(OByE@(B)
     (?$(O"5(B . ?\x3035);; $(O$/$N;zE@2<!&$/$N;zE@2<(B($(OByE@(B)
     ;;(?$(O"6(B . ?\x(303B))  ;; $(OFs$N;zE@!&$f$9$jE@(B
     ;;(?$(O"7(B . ?\x(303C))  ;; $(O$^$95-9f(B
     ;;(?$(O"8(B . ?\x(303D))  ;; $(O%3%H(B
     ;;(?$(O"9(B . ?\x(31C0))  ;; $(O$h$j(B
     (?$(O"B(B . ?\x2284);; $(OItJ,=89g$NH]Dj(B
     (?$(O"C(B . ?\x2285);; $(OItJ,=89g$NH]Dj(B($(O5UJ}8~(B)
     (?$(O"D(B . ?\x228A);; $(O??ItJ,=89g(B2
     (?$(O"E(B . ?\x228B);; $(O??ItJ,=89g(B2($(O5UJ}8~(B)
     (?$(O"F(B . ?\x2209);; $(OMWAG$NH]Dj!&85$NH]Dj(B
     (?$(O"G(B . ?\x2205);; $(O6u=89g(B
     (?$(O"H(B . ?\x2305);; $(O<M1FE*4X78(B
     (?$(O"I(B . ?\x2306);; $(OGX7JE*4X78(B
     (?$(O"Q(B . ?\x2295);; $(OD>OB(B
     (?$(O"R(B . ?\x2296);; $(O4]IU$-%^%$%J%9(B
     (?$(O"S(B . ?\x2297);; $(O%F%s%=%k@Q(B
     (?$(O"T(B . ?\x2225);; $(OJ?9T(B
     (?$(O"U(B . ?\x2226);; $(OJ?9T$NH]Dj(B
     ;;(?$(O"V(B . ?\x(2050))  ;; $(O;O$aFs=E%Q!<%l%s!&;O$aFs=E3g8L(B
     ;;(?$(O"W(B . ?\x(2051))  ;; $(O=*$o$jFs=E%Q!<%l%s(B.$(O=*$o$jFs=E3g8L(B
     (?$(O"X(B . ?\x3018);; $(O;O$aFs=E$-$C$3$&(B($(O559C(B)$(O3g8L(B
     (?$(O"Y(B . ?\x3019);; $(O=*$o$jFs=E$-$C$3$&(B($(O559C(B)$(O3g8L(B
     (?$(O"Z(B . ?\x3016);; $(O;O$a$9$_IU$-3g8L(B($(OGr(B)
     (?$(O"[(B . ?\x3017);; $(O=*$o$j$9$_IU$-3g8L(B($(OGr(B)
     (?$(O"k(B . ?\x2262);; $(O9gF1H]Dj(B
     (?$(O"l(B . ?\x2243);; $(OA2?JE*$KEy$7$$!&%[%b%H!<%W(B
     (?$(O"m(B . ?\x2245);; $(OF17A(B
     (?$(O"n(B . ?\x2248);; $(O6a;wE*$KEy$7$$!&F1Aj(B
     (?$(O"o(B . ?\x2276);; $(O>.$5$$$+Bg$-$$(B
     (?$(O"p(B . ?\x2277);; $(OBg$-$$$+>.$5$$(B
     (?$(O"q(B . ?\x2194);; $(OF1Ey(B
     (?$(O"z(B . ?\x266E);; $(O%J%A%e%i%k(B
     (?$(O"{(B . ?\x266B);; $(OO"$3$&(B($(O7e(B)$(OIU$-H,J,2;Id(B
     (?$(O"|(B . ?\x266C);; $(OO"$3$&(B($(O7e(B)$(OIU$-==O;J,2;Id(B
     (?$(O"}(B . ?\x2669);; $(O;MJ,2;Id(B
     (?$(O#!(B . ?\x25B7);; $(O1&8~;03Q(B
     (?$(O#"(B . ?\x25B6);; $(O1&8~9u;03Q(B
     (?$(O##(B . ?\x25C1);; $(O:88~;03Q(B
     (?$(O#$(B . ?\x25C0);; $(O:88~9u;03Q(B
     (?$(O#%(B . ?\x2197);; $(O1&>e8~Lp0u(B
     (?$(O#&(B . ?\x2198);; $(O1&2<8~Lp0u(B
     (?$(O#'(B . ?\x2196);; $(O:8>e8~Lp0u(B
     (?$(O#((B . ?\x2199);; $(O:82<8~Lp0u(B
     (?$(O#)(B . ?\x21C4);; $(O1&Lp0u:8Lp0u(B
     (?$(O#*(B . ?\x21E8);; $(O1&8~GrLp0u(B
     (?$(O#+(B . ?\x21E6);; $(O:88~GrLp0u(B
     (?$(O#,(B . ?\x21E7);; $(O>e8~GrLp0u(B
     (?$(O#-(B . ?\x21E9);; $(O2<8~GrLp0u(B
     ;;(?$(O#.(B . ?\x(21F4))  ;; $(O6J$,$jLp0u>e$,$k(B
     ;;(?$(O#/(B . ?\x(21F5))  ;; $(O6J$,$jLp0u2<$,$k(B
     ;;(?$(O#:(B . ?\x(2052))  ;; $(O4]Cf9u(B
     (?$(O#;(B . ?\x25C9);; $(O<X$NL\(B
     ;;(?$(O#<(B . ?\x(31C1))  ;; $(O2N5-9f!&$$$*$j(B($(O0C(B)$(OE@(B
     ;;(?$(O#=(B . ?\x(31C2))  ;; $(OGr%4%^(B
     ;;(?$(O#>(B . ?\x(31C3))  ;; $(O%4%^(B
     (?$(O#?(B . ?\x25E6);; $(OGr%S%e%l%C%H(B
     (?$(O#@(B . ?\x2022);; $(O%S%e%l%C%H(B
     (?$(O#[(B . ?\x2213);; $(OIiKt$O@5Id9f(B
     (?$(O#\(B . ?\x2135);; $(O%"%l%U(B
     (?$(O#](B . ?\x210F);; $(O%(%$%A%P!<(B
     (?$(O#^(B . ?\x33CB);; HP$(O!&%[!<%9%Q%o!<(B($(OGONO(B)
     (?$(O#_(B . ?\x2113);; $(O%j%C%H%k(B
     (?$(O#`(B . ?\x2127);; $(O%b!<5-9f(B
     ;;(?$(O#{(B . ?\x(204E))  ;; $(OFs=E%O%$%U%s!&FsJ,Fs=E%@%C%7%e(B
     (?$(O#|(B . ?\x2013);; $(OFsJ,%@!<%7!&%@%C%7%e(B($(OFsJ,(B)
     ;;(?$(O#}(B . ?\x(239B))  ;; 2$(O%W%i%9(B
     ;;(?$(O#~(B . ?\x(239C))  ;; 3$(O%W%i%9(B
     (?$(O$t(B . ?\x3094);; $(OByE@IU$-(B"$(O$&(B"
     ;;(?$(O$u(B . ?\x(3095))  ;; $(O>.=q$-(B"$(O$+(B"
     ;;(?$(O$v(B . ?\x(3096))  ;; $(O>.=q$-(B"$(O$1(B"
     ;;(?$(O$w(B . ?\x(31D0))  ;; $(OH>ByE@IU$-(B"$(O$+(B"
     ;;(?$(O$x(B . ?\x(31D1))  ;; $(OH>ByE@IU$-(B"$(O$-(B"
     ;;(?$(O$y(B . ?\x(31D2))  ;; $(OH>ByE@IU$-(B"$(O$/(B"
     ;;(?$(O$z(B . ?\x(31D3))  ;; $(OH>ByE@IU$-(B"$(O$1(B"
     ;;(?$(O${(B . ?\x(31D4))  ;; $(OH>ByE@IU$-(B"$(O$3(B"
     ;;(?$(O%w(B . ?\x(31E0))  ;; $(OH>ByE@IU$-(B"$(O%+(B"
     ;;(?$(O%x(B . ?\x(31E1))  ;; $(OH>ByE@IU$-(B"$(O%-(B"
     ;;(?$(O%y(B . ?\x(31E2))  ;; $(OH>ByE@IU$-(B"$(O%/(B"
     ;;(?$(O%z(B . ?\x(31E3))  ;; $(OH>ByE@IU$-(B"$(O%1(B"
     ;;(?$(O%{(B . ?\x(31E4))  ;; $(OH>ByE@IU$-(B"$(O%3(B"
     ;;(?$(O%|(B . ?\x(31E5))  ;; $(OH>ByE@IU$-(B"$(O%;(B"
     ;;(?$(O%}(B . ?\x(31E6))  ;; $(OH>ByE@IU$-(B"$(O%D(B"
     ;;(?$(O%~(B . ?\x(31E7))  ;; $(OH>ByE@IU$-(B"$(O%H(B"
     (?$(O&9(B . ?\x2664);; $(O%9%Z!<%I(B($(OGr(B)
     (?$(O&:(B . ?\x2660);; $(O%9%Z!<%I(B
     (?$(O&;(B . ?\x2662);; $(O%@%$%d(B($(OGr(B)
     (?$(O&<(B . ?\x2666);; $(O%@%$%d(B
     (?$(O&=(B . ?\x2661);; $(O%O!<%H(B($(OGr(B)
     (?$(O&>(B . ?\x2665);; $(O%O!<%H(B
     (?$(O&?(B . ?\x2667);; $(O%/%i%V(B($(OGr(B)
     (?$(O&@(B . ?\x2663);; $(O%/%i%V(B
     (?$(O&Y(B . ?\x03C2);; $(O%U%!%$%J%k%7%0%^(B
     ;;(?$(O&Z(B . ?\x(23AC))  ;; $(OFs=E4]IU$-(B1
     ;;(?$(O&[(B . ?\x(23AD))  ;; $(OFs=E4]IU$-(B2
     ;;(?$(O&\(B . ?\x(23AE))  ;; $(OFs=E4]IU$-(B3
     ;;(?$(O&](B . ?\x(23AF))  ;; $(OFs=E4]IU$-(B4
     ;;(?$(O&^(B . ?\x(23B0))  ;; $(OFs=E4]IU$-(B5
     ;;(?$(O&_(B . ?\x(23B1))  ;; $(OFs=E4]IU$-(B6
     ;;(?$(O&`(B . ?\x(23B2))  ;; $(OFs=E4]IU$-(B7
     ;;(?$(O&a(B . ?\x(23B3))  ;; $(OFs=E4]IU$-(B8
     ;;(?$(O&b(B . ?\x(23B4))  ;; $(OFs=E4]IU$-(B9
     ;;(?$(O&c(B . ?\x(23B5))  ;; $(OFs=E4]IU$-(B10
     ;;(?$(O&d(B . ?\x(2616))  ;; $(OGr>-4}6p(B
     ;;(?$(O&e(B . ?\x(2617))  ;; $(O9u>-4}6p(B
     (?$(O&f(B . ?\x3020);; $(OM9JX%^!<%/(B
     (?$(O&g(B . ?\x260E);; $(OEEOC%^!<%/(B
     (?$(O&h(B . ?\x2600);; $(O@2%^!<%/(B
     (?$(O&i(B . ?\x2601);; $(OF^%^!<%/(B
     (?$(O&j(B . ?\x2602);; $(O1+%^!<%/(B
     (?$(O&k(B . ?\x2603);; $(O@c%^!<%/(B
     (?$(O&l(B . ?\x2668);; $(O29@t%^!<%/(B
     (?$(O&m(B . ?\x25B1);; $(OJ?9T;MJU7A(B
     ;;(?$(O&n(B . ?\x(31E8))  ;; $(O>.=q$-(B"$(O%/(B"
     ;;(?$(O&o(B . ?\x(31E9))  ;; $(O>.=q$-(B"$(O%7(B"
     ;;(?$(O&p(B . ?\x(31EA))  ;; $(O>.=q$-(B"$(O%9(B"
     ;;(?$(O&q(B . ?\x(31EB))  ;; $(O>.=q$-(B"$(O%H(B"
     ;;(?$(O&r(B . ?\x(31EC))  ;; $(O>.=q$-(B"$(O%L(B"
     ;;(?$(O&s(B . ?\x(31ED))  ;; $(O>.=q$-(B"$(O%O(B"
     ;;(?$(O&t(B . ?\x(31EE))  ;; $(O>.=q$-(B"$(O%R(B"
     ;;(?$(O&u(B . ?\x(31EF))  ;; $(O>.=q$-(B"$(O%U(B"
     ;;(?$(O&v(B . ?\x(31F0))  ;; $(O>.=q$-(B"$(O%X(B"
     ;;(?$(O&w(B . ?\x(31F1))  ;; $(O>.=q$-(B"$(O%[(B"
     ;;(?$(O&x(B . ?\x(31F2))  ;; $(O>.=q$-(B"$(O%W(B"
     ;;(?$(O&y(B . ?\x(31F3))  ;; $(O>.=q$-(B"$(O%`(B"
     ;;(?$(O&z(B . ?\x(31F4))  ;; $(O>.=q$-(B"$(O%i(B"
     ;;(?$(O&{(B . ?\x(31F5))  ;; $(O>.=q$-(B"$(O%j(B"
     ;;(?$(O&|(B . ?\x(31F6))  ;; $(O>.=q$-(B"$(O%k(B"
     ;;(?$(O&}(B . ?\x(31F7))  ;; $(O>.=q$-(B"$(O%l(B"
     ;;(?$(O&~(B . ?\x(31F8))  ;; $(O>.=q$-(B"$(O%m(B"
     ;;(?$(O'B(B . ?\x(239D))  ;; $(O:8>e3QAGJR(B
     ;;(?$(O'C(B . ?\x(239E))  ;; $(O:82<3QAGJR(B
     ;;(?$(O'D(B . ?\x(239F))  ;; $(O4]IU$-=D@~AGJR(B
     ;;(?$(O'E(B . ?\x(23A0))  ;; $(O4]IU$->e2#=D@~AGJR(B
     ;;(?$(O'F(B . ?\x(23A1))  ;; $(O4]IU$-2<2#=D@~AGJR(B
     ;;(?$(O'G(B . ?\x(23A2))  ;; $(O;03QIU$-=D@~AGJR(B
     ;;(?$(O'H(B . ?\x(23A3))  ;; $(O;03QIU$->e2#=D@~AGJR(B
     ;;(?$(O'I(B . ?\x(23A4))  ;; $(O;03QIU$-2<2#=D@~AGJR(B
     ;;(?$(O'J(B . ?\x(23A5))  ;; $(OGHIU$-=D@~AGJR(B
     ;;(?$(O'K(B . ?\x(23A6))  ;; $(OGHIU$->e2#=D@~AGJR(B
     ;;(?$(O'L(B . ?\x(23A7))  ;; $(OGHIU$-2<2#=D@~AGJR(B
     ;;(?$(O'M(B . ?\x(23A8))  ;; $(O>e2#=D@~AGJR(B
     ;;(?$(O'N(B . ?\x(23A9))  ;; $(O2<2#=D@~AGJR(B
     ;;(?$(O'O(B . ?\x(23AA))  ;; $(O1&>e3QAGJR(B
     ;;(?$(O'P(B . ?\x(23AB))  ;; $(O1&2<3QAGJR(B
     (?$(O'r(B . ?\x30F7);; $(OByE@IU$-(B"$(O%o(B"
     (?$(O's(B . ?\x30F8);; $(OByE@IU$-(B"$(O%p(B"
     (?$(O't(B . ?\x30F9);; $(OByE@IU$-(B"$(O%q(B"
     (?$(O'u(B . ?\x30FA);; $(OByE@IU$-(B"$(O%r(B"
     (?$(O'v(B . ?\x22DA);; $(O>.$5$$$+Ey$7$$$+Bg$-$$(B
     (?$(O'w(B . ?\x22DB);; $(OBg$-$$$+Ey$7$$$+>.$5$$(B
     (?$(O'x(B . ?\x2153);; 3$(OJ,$N(B1
     (?$(O'y(B . ?\x2154);; 3$(OJ,$N(B2
     (?$(O'z(B . ?\x2155);; 5$(OJ,$N(B1
     (?$(O'{(B . ?\x2713);; $(O%A%'%C%/%^!<%/(B
     (?$(O'|(B . ?\x2318);; $(O%3%^%s%I5-9f(B
     (?$(O'}(B . ?\x2423);; $(O6uGr5-9f(B
     ;;(?$(O'~(B . ?\x(2618))  ;; $(O%j%?!<%s5-9f(B
     ;;(?$(O(A(B . ?\x(27D0))  ;; $(O4](B21
     ;;(?$(O(B(B . ?\x(27D1))  ;; $(O4](B22
     ;;(?$(O(C(B . ?\x(27D2))  ;; $(O4](B23
     ;;(?$(O(D(B . ?\x(27D3))  ;; $(O4](B24
     ;;(?$(O(E(B . ?\x(27D4))  ;; $(O4](B25
     ;;(?$(O(F(B . ?\x(27D5))  ;; $(O4](B26
     ;;(?$(O(G(B . ?\x(27D6))  ;; $(O4](B27
     ;;(?$(O(H(B . ?\x(27D7))  ;; $(O4](B28
     ;;(?$(O(I(B . ?\x(27D8))  ;; $(O4](B29
     ;;(?$(O(J(B . ?\x(27D9))  ;; $(O4](B30
     ;;(?$(O(K(B . ?\x(27DA))  ;; $(O4](B31
     ;;(?$(O(L(B . ?\x(27DB))  ;; $(O4](B32
     ;;(?$(O(M(B . ?\x(27DC))  ;; $(O4](B33
     ;;(?$(O(N(B . ?\x(27DD))  ;; $(O4](B34
     ;;(?$(O(O(B . ?\x(27DE))  ;; $(O4](B35
     ;;(?$(O(P(B . ?\x(27DF))  ;; $(O4](B36
     ;;(?$(O(Q(B . ?\x(27E0))  ;; $(O4](B37
     ;;(?$(O(R(B . ?\x(27E1))  ;; $(O4](B38
     ;;(?$(O(S(B . ?\x(27E2))  ;; $(O4](B39
     ;;(?$(O(T(B . ?\x(27E3))  ;; $(O4](B40
     ;;(?$(O(U(B . ?\x(27E4))  ;; $(O4](B41
     ;;(?$(O(V(B . ?\x(27E5))  ;; $(O4](B42
     ;;(?$(O(W(B . ?\x(27E6))  ;; $(O4](B43
     ;;(?$(O(X(B . ?\x(27E7))  ;; $(O4](B44
     ;;(?$(O(Y(B . ?\x(27E8))  ;; $(O4](B45
     ;;(?$(O(Z(B . ?\x(27E9))  ;; $(O4](B46
     ;;(?$(O([(B . ?\x(27EA))  ;; $(O4](B47
     ;;(?$(O(\(B . ?\x(27EB))  ;; $(O4](B48
     ;;(?$(O(](B . ?\x(27EC))  ;; $(O4](B49
     ;;(?$(O(^(B . ?\x(27ED))  ;; $(O4](B50
     (?$(O(g(B . ?\x25D0);; $(O:8H>9u4](B
     (?$(O(h(B . ?\x25D1);; $(O1&H>9u4](B
     (?$(O(i(B . ?\x25D2);; $(O2<H>9u4](B
     (?$(O(j(B . ?\x25D3);; $(O>eH>9u4](B
     (?$(O(k(B . ?\x203C);; $(O1+$@$lFs$D(B
     ;;(?$(O(l(B . ?\x(2047))  ;; $(O5?LdIdFs$D(B
     (?$(O(m(B . ?\x2048);; $(O5?LdId46C2Id(B
     (?$(O(n(B . ?\x2049);; $(O46C2Id5?LdId(B
     (?$(O(o(B . ?\x01CD);; $(O%-%c%m%sIU$-(BA
     (?$(O(p(B . ?\x01CE);; $(O%-%c%m%sIU$-(BA$(O>.J8;z(B
     (?$(O(q(B . ?\x01D0);; $(O%-%c%m%sIU$-(BI$(O>.J8;z(B
     (?$(O(r(B . ?\x1E3E);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BM
     (?$(O(s(B . ?\x1E3F);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BM$(O>.J8;z(B
     (?$(O(t(B . ?\x01F8);; $(O%0%l!<%V%"%/%;%s%HIU$-(BN
     (?$(O(u(B . ?\x01F9);; $(O%0%l!<%V%"%/%;%s%HIU$-(BN$(O>.J8;z(B
     (?$(O(v(B . ?\x01D1);; $(O%-%c%m%sIU$-(BO
     (?$(O(w(B . ?\x01D2);; $(O%-%c%m%sIU$-(BO$(O>.J8;z(B
     (?$(O(x(B . ?\x01D4);; $(O%-%c%m%sIU$-(BU$(O>.J8;z(B
     (?$(O(y(B . ?\x01D6);; $(O%^%/%m%s$H%@%$%(%l%7%9IU$-(BU$(O>.J8;z(B
     (?$(O(z(B . ?\x01D8);; $(O%"%-%e!<%H%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$(O>.J8;z(B
     (?$(O({(B . ?\x01DA);; $(O%-%c%m%s$H%@%$%(%l%7%9IU$-(BU$(O>.J8;z(B
     (?$(O(|(B . ?\x01DC);; $(O%0%l!<%V%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$(O>.J8;z(B
     ;;(?$(O(}(B . ?\x)  ;; 
     ;;(?$(O(~(B . ?\x)  ;; 
     (?$(O)!(B . ?\x20AC);; $(O%f!<%m5-9f(B
     (?$(O)"(B . ?\x00A0);; $(O%N!<%V%l!<%/%9%Z!<%9(B
     (?$(O)#(B . ?\x00A1);; $(O5U46C2Id(B
     (?$(O)$(B . ?\x00A4);; $(OITFCDjDL2_5-9f(B
     (?$(O)%(B . ?\x00A6);; $(OGKCG@~(B
     (?$(O)&(B . ?\x00A9);; $(OCx:n8"I=<(5-9f(B
     (?$(O)'(B . ?\x00AA);; $(O=w@-=x?tI8<1(B
     (?$(O)((B . ?\x00AB);; $(O;O$aFs=E;33g8L0zMQ5-9f!&$O$8$a%.%e%a(B
     (?$(O))(B . ?\x00AD);; $(O%=%U%H%O%$%U%s(B
     (?$(O)*(B . ?\x00AE);; $(OEPO?>&I85-9f(B
     (?$(O)+(B . ?\x00AF);; $(O%^%/%m%s(B
     (?$(O),(B . ?\x00B2);; $(O>eIU$-(B2
     (?$(O)-(B . ?\x00B3);; $(O>eIU$-(B3
     (?$(O).(B . ?\x00B7);; $(OCfE@(B($(O%i%F%s(B)
     (?$(O)/(B . ?\x00B8);; $(O%;%G%#%i(B
     (?$(O)0(B . ?\x00B9);; $(O>eIU$-(B1
     (?$(O)1(B . ?\x00BA);; $(OCK@-=x?tI8<1(B
     (?$(O)2(B . ?\x00BB);; $(O=*$o$jFs=E;33g8L0zMQ5-9f!&=*$o$j%.%e%a(B
     (?$(O)3(B . ?\x00BC);; 4$(OJ,$N(B1
     (?$(O)4(B . ?\x00BD);; 2$(OJ,$N(B1
     (?$(O)5(B . ?\x00BE);; 4$(OJ,$N(B3
     (?$(O)6(B . ?\x00BF);; $(O5U5?LdId(B
     (?$(O)7(B . ?\x00C0);; $(O%0%l!<%V%"%/%;%s%HIU$-(BA
     (?$(O)8(B . ?\x00C1);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BA
     (?$(O)9(B . ?\x00C2);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BA
     (?$(O):(B . ?\x00C3);; $(O%A%k%IIU$-(BA
     (?$(O);(B . ?\x00C4);; $(O%@%$%(%l%7%9IU$-(BA
     (?$(O)<(B . ?\x00C5);; $(O%j%s%0%"%P%VIU$-(BA
     (?$(O)=(B . ?\x00C6);; $(OFs=EJl2;(BAE
     (?$(O)>(B . ?\x00C7);; $(O%;%G%#%iIU$-(BC
     (?$(O)?(B . ?\x00C8);; $(O%0%l!<%V%"%/%;%s%HIU$-(BE
     (?$(O)@(B . ?\x00C9);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BE
     (?$(O)A(B . ?\x00CA);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BE
     (?$(O)B(B . ?\x00CB);; $(O%@%$%(%l%7%9IU$-(BE
     (?$(O)C(B . ?\x00CC);; $(O%0%l!<%V%"%/%;%s%HIU$-(BI
     (?$(O)D(B . ?\x00CD);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BI
     (?$(O)E(B . ?\x00CE);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BI
     (?$(O)F(B . ?\x00CF);; $(O%@%$%(%l%7%9IU$-(BI
     (?$(O)G(B . ?\x00D0);; $(O%"%$%9%i%s%I8l(BETH
     (?$(O)H(B . ?\x00D1);; $(O%A%k%IIU$-(BN
     (?$(O)I(B . ?\x00D2);; $(O%0%l!<%V%"%/%;%s%HIU$-(BO
     (?$(O)J(B . ?\x00D3);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BO
     (?$(O)K(B . ?\x00D4);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BO
     (?$(O)L(B . ?\x00D5);; $(O%A%k%IIU$-(BO
     (?$(O)M(B . ?\x00D6);; $(O%@%$%(%l%7%9IU$-(BO
     (?$(O)N(B . ?\x00D8);; $(O<P@~IU$-(BO
     (?$(O)O(B . ?\x00D9);; $(O%0%l!<%V%"%/%;%s%HIU$-(BU
     (?$(O)P(B . ?\x00DA);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BU
     (?$(O)Q(B . ?\x00DB);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BU
     (?$(O)R(B . ?\x00DC);; $(O%@%$%(%l%7%9IU$-(BU
     (?$(O)S(B . ?\x00DD);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BY
     (?$(O)T(B . ?\x00DE);; $(O%"%$%9%i%s%I8l(BTHORN
     (?$(O)U(B . ?\x00DF);; $(O%I%$%D8l%(%9%D%'%C%H(B
     (?$(O)V(B . ?\x00E0);; $(O%0%l!<%V%"%/%;%s%HIU$-(BA$(O>.J8;z(B
     (?$(O)W(B . ?\x00E1);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BA$(O>.J8;z(B
     (?$(O)X(B . ?\x00E2);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BA$(O>.J8;z(B
     (?$(O)Y(B . ?\x00E3);; $(O%A%k%IIU$-(BA$(O>.J8;z(B
     (?$(O)Z(B . ?\x00E4);; $(O%@%$%(%l%7%9IU$-(BA$(O>.J8;z(B
     (?$(O)[(B . ?\x00E5);; $(O%j%s%0%"%P%VIU$-(BA$(O>.J8;z(B
     (?$(O)\(B . ?\x00E6);; $(OFs=EJl2;(BAE$(O>.J8;z(B
     (?$(O)](B . ?\x00E7);; $(O%;%G%#%iIU$-(BC$(O>.J8;z(B
     (?$(O)^(B . ?\x00E8);; $(O%0%l!<%V%"%/%;%s%HIU$-(BE$(O>.J8;z(B
     (?$(O)_(B . ?\x00E9);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BE$(O>.J8;z(B
     (?$(O)`(B . ?\x00EA);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BE$(O>.J8;z(B
     (?$(O)a(B . ?\x00EB);; $(O%@%$%(%l%7%9IU$-(BE$(O>.J8;z(B
     (?$(O)b(B . ?\x00EC);; $(O%0%l!<%V%"%/%;%s%HIU$-(BI$(O>.J8;z(B
     (?$(O)c(B . ?\x00ED);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BI$(O>.J8;z(B
     (?$(O)d(B . ?\x00EE);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BI$(O>.J8;z(B
     (?$(O)e(B . ?\x00EF);; $(O%@%$%(%l%7%9IU$-(BI$(O>.J8;z(B
     (?$(O)f(B . ?\x00F0);; $(O%"%$%9%i%s%I8l(BETH$(O>.J8;z(B
     (?$(O)g(B . ?\x00F1);; $(O%A%k%IIU$-(BN$(O>.J8;z(B
     (?$(O)h(B . ?\x00F2);; $(O%0%l!<%V%"%/%;%s%HIU$-(BO$(O>.J8;z(B
     (?$(O)i(B . ?\x00F3);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BO$(O>.J8;z(B
     (?$(O)j(B . ?\x00F4);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BO$(O>.J8;z(B
     (?$(O)k(B . ?\x00F5);; $(O%A%k%IIU$-(BO$(O>.J8;z(B
     (?$(O)l(B . ?\x00F6);; $(O%@%$%(%l%7%9IU$-(BO$(O>.J8;z(B
     (?$(O)m(B . ?\x00F8);; $(O<P@~IU$-(BO$(O>.J8;z(B
     (?$(O)n(B . ?\x00F9);; $(O%0%l!<%V%"%/%;%s%HIU$-(BU$(O>.J8;z(B
     (?$(O)o(B . ?\x00FA);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BU$(O>.J8;z(B
     (?$(O)p(B . ?\x00FB);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BU$(O>.J8;z(B
     (?$(O)q(B . ?\x00FC);; $(O%@%$%(%l%7%9IU$-(BU$(O>.J8;z(B
     (?$(O)r(B . ?\x00FD);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BY$(O>.J8;z(B
     (?$(O)s(B . ?\x00FE);; $(O%"%$%9%i%s%I8l(BTHORN$(O>.J8;z(B
     (?$(O)t(B . ?\x00FF);; $(O%@%$%(%l%7%9IU$-(BY$(O>.J8;z(B
     (?$(O)u(B . ?\x0100);; $(O%^%/%m%sIU$-(BA
     (?$(O)v(B . ?\x012A);; $(O%^%/%m%sIU$-(BI
     (?$(O)w(B . ?\x016A);; $(O%^%/%m%sIU$-(BU
     (?$(O)x(B . ?\x0112);; $(O%^%/%m%sIU$-(BE
     (?$(O)y(B . ?\x014C);; $(O%^%/%m%sIU$-(BO
     (?$(O)z(B . ?\x0101);; $(O%^%/%m%sIU$-(BA$(O>.J8;z(B
     (?$(O){(B . ?\x012B);; $(O%^%/%m%sIU$-(BI$(O>.J8;z(B
     (?$(O)|(B . ?\x016B);; $(O%^%/%m%sIU$-(BU$(O>.J8;z(B
     (?$(O)}(B . ?\x0113);; $(O%^%/%m%sIU$-(BE$(O>.J8;z(B
     (?$(O)~(B . ?\x014D);; $(O%^%/%m%sIU$-(BO$(O>.J8;z(B
     (?$(O*!(B . ?\x0104);; $(O%*%4%M%/IU$-(BA
     (?$(O*"(B . ?\x02D8);; $(O%V%j!<%V(B
     (?$(O*#(B . ?\x0141);; $(OK@IU$-(BL($(O%]!<%i%s%I8l(BL)
     (?$(O*$(B . ?\x013D);; $(O%-%c%m%sIU$-(BL
     (?$(O*%(B . ?\x015A);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BS
     (?$(O*&(B . ?\x0160);; $(O%-%c%m%sIU$-(BS
     (?$(O*'(B . ?\x015E);; $(O%;%G%#%iIU$-(BS
     (?$(O*((B . ?\x0164);; $(O%-%c%m%sIU$-(BT
     (?$(O*)(B . ?\x0179);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BZ
     (?$(O**(B . ?\x017D);; $(O%-%c%m%sIU$-(BZ
     (?$(O*+(B . ?\x017B);; $(O%I%C%H%"%P%VIU$-(BZ
     (?$(O*,(B . ?\x0105);; $(O%*%4%M%/IU$-(BA$(O>.J8;z(B
     (?$(O*-(B . ?\x02DB);; $(O%*%4%M%/(B
     (?$(O*.(B . ?\x0142);; $(OK@IU$-(BL$(O>.J8;z(B($(O%]!<%i%s%I8l(BL)
     (?$(O*/(B . ?\x013E);; $(O%-%c%m%sIU$-(BL$(O>.J8;z(B
     (?$(O*0(B . ?\x015B);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BS$(O>.J8;z(B
     (?$(O*1(B . ?\x02C7);; $(O%-%c%m%s(B
     (?$(O*2(B . ?\x0161);; $(O%-%c%m%sIU$-(BS$(O>.J8;z(B
     (?$(O*3(B . ?\x015F);; $(O%;%G%#%iIU$-(BS$(O>.J8;z(B
     (?$(O*4(B . ?\x0165);; $(O%-%c%m%sIU$-(BT$(O>.J8;z(B
     (?$(O*5(B . ?\x017A);; $(O%"%-%e!<%HIU$-(BZ$(O>.J8;z(B
     (?$(O*6(B . ?\x02DD);; $(O%@%V%k%"%-%e!<%H%"%/%;%s%H(B
     (?$(O*7(B . ?\x017E);; $(O%-%c%m%sIU$-(BZ$(O>.J8;z(B
     (?$(O*8(B . ?\x017C);; $(O%I%C%H%"%P%VIU$-(BZ$(O>.J8;z(B
     (?$(O*9(B . ?\x0154);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BR
     (?$(O*:(B . ?\x0102);; $(O%V%j!<%VIU$-(BA
     (?$(O*;(B . ?\x0139);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BL
     (?$(O*<(B . ?\x0106);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BC
     (?$(O*=(B . ?\x010C);; $(O%-%c%m%sIU$-(BC
     (?$(O*>(B . ?\x0118);; $(O%*%4%M%/IU$-(BE
     (?$(O*?(B . ?\x011A);; $(O%-%c%m%sIU$-(BE
     (?$(O*@(B . ?\x010E);; $(O%-%c%m%sIU$-(BD
     (?$(O*A(B . ?\x0143);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BN
     (?$(O*B(B . ?\x0147);; $(O%-%c%m%sIU$-(BN
     (?$(O*C(B . ?\x0150);; $(O%@%V%k%"%-%e!<%HIU$-(BO
     (?$(O*D(B . ?\x0158);; $(O%-%c%m%sIU$-(BR
     (?$(O*E(B . ?\x016E);; $(O%j%s%0%"%P%VIU$-(BU
     (?$(O*F(B . ?\x0170);; $(O%@%V%k%"%-%e!<%HIU$-(BU
     (?$(O*G(B . ?\x0162);; $(O%;%G%#%iIU$-(BT
     (?$(O*H(B . ?\x0155);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BR$(O>.J8;z(B
     (?$(O*I(B . ?\x0103);; $(O%V%j!<%VIU$-(BA$(O>.J8;z(B
     (?$(O*J(B . ?\x013A);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BL$(O>.J8;z(B
     (?$(O*K(B . ?\x0107);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BC$(O>.J8;z(B
     (?$(O*L(B . ?\x010D);; $(O%-%c%m%sIU$-(BC$(O>.J8;z(B
     (?$(O*M(B . ?\x0119);; $(O%*%4%M%/IU$-(BE$(O>.J8;z(B
     (?$(O*N(B . ?\x011B);; $(O%-%c%m%sIU$-(BE$(O>.J8;z(B
     (?$(O*O(B . ?\x010F);; $(O%-%c%m%sIU$-(BD$(O>.J8;z(B
     (?$(O*P(B . ?\x0111);; $(OK@IU$-(BD$(O>.J8;z(B
     (?$(O*Q(B . ?\x0144);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BN$(O>.J8;z(B
     (?$(O*R(B . ?\x0148);; $(O%-%c%m%sIU$-(BN$(O>.J8;z(B
     (?$(O*S(B . ?\x0151);; $(O%@%V%k%"%-%e!<%HIU$-(BO$(O>.J8;z(B
     (?$(O*T(B . ?\x0159);; $(O%-%c%m%sIU$-(BR$(O>.J8;z(B
     (?$(O*U(B . ?\x016F);; $(O%j%s%0%"%P%VIU$-(BU$(O>.J8;z(B
     (?$(O*V(B . ?\x0171);; $(O%@%V%k%"%-%e!<%HIU$-(BU$(O>.J8;z(B
     (?$(O*W(B . ?\x0163);; $(O%;%G%#%iIU$-(BT$(O>.J8;z(B
     (?$(O*X(B . ?\x02D9);; $(O%I%C%H%"%P%V(B
     (?$(O*Y(B . ?\x0108);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BC
     (?$(O*Z(B . ?\x011C);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BG
     (?$(O*[(B . ?\x0124);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BH
     (?$(O*\(B . ?\x0134);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BJ
     (?$(O*](B . ?\x015C);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BS
     (?$(O*^(B . ?\x016C);; $(O%V%j!<%VIU$-(BU
     (?$(O*_(B . ?\x0109);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BC$(O>.J8;z(B
     (?$(O*`(B . ?\x011D);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BG$(O>.J8;z(B
     (?$(O*a(B . ?\x0125);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BH$(O>.J8;z(B
     (?$(O*b(B . ?\x0135);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BJ$(O>.J8;z(B
     (?$(O*c(B . ?\x015D);; $(O%5!<%+%`%U%l%/%9%"%/%;%s%HIU$-(BS$(O>.J8;z(B
     (?$(O*d(B . ?\x016D);; $(O%V%j!<%VIU$-(BU$(O>.J8;z(B
     (?$(O*e(B . ?\x0271);; $(O%U%C%/IU$-(BM$(O>.J8;z!&M-@<?0;uI!2;(B
     (?$(O*f(B . ?\x028B);; $(O%U%C%/IU$-(BV$(O>.J8;z!&M-@<?0;u@\6a2;(B
     (?$(O*g(B . ?\x027E);; $(O%U%#%C%7%e%U%C%/IU$-(BR$(O>.J8;z!&M-@<;u7TCF$-2;(B
     (?$(O*h(B . ?\x0283);; ESH$(O>.J8;z!&L5@<8eIt;u7TK`;$2;(B
     (?$(O*i(B . ?\x0292);; EZH$(O>.J8;z!&M-@<8eIt;u7TK`;$2;(B
     (?$(O*j(B . ?\x026C);; $(O%Y%k%HIU$-(BL$(O>.J8;z!&L5@<;u7TB&LLK`;$2;(B
     (?$(O*k(B . ?\x026E);; LEZH$(O>.J8;z!&M-@<;u7TB&LLK`;$2;(B
     (?$(O*l(B . ?\x0279);; $(O%?!<%s%I(BR$(O>.J8;z!&L5@<;u7T@\6a2;(B
     (?$(O*m(B . ?\x0288);; $(O%l%H%m%U%l%C%/%9%U%C%/IU$-(BT$(O>.J8;z!&L5@<$=$j@eGKNv2;(B
     (?$(O*n(B . ?\x0256);; $(O%F!<%kIU$-(BD$(O>.J8;z!&M-@<$=$j@eGKNv2;(B
     (?$(O*o(B . ?\x0273);; $(O%l%H%m%U%l%C%/%9%U%C%/IU$-(BN$(O>.J8;z!&M-@<$=$j@eI!2;(B
     (?$(O*p(B . ?\x027D);; $(O%F!<%kIU$-(BR$(O>.J8;z!&M-@<$=$j@eCF$-2;(B
     (?$(O*q(B . ?\x0282);; $(O%U%C%/IU$-(BS$(O>.J8;z!&L5@<$=$j@eK`;$2;(B
     (?$(O*r(B . ?\x0290);; $(O%l%H%m%U%l%C%/%9%U%C%/IU$-(BZ$(O>.J8;z!&M-@<$=$j@eK`;$2;(B
     (?$(O*s(B . ?\x027B);; $(O%U%C%/IU$-%?!<%s%I(BR$(O>.J8;z!&M-@<$=$j@e@\6a2;(B
     (?$(O*t(B . ?\x026D);; $(O%l%H%m%U%l%C%/%9%U%C%/IU$-(BL$(O>.J8;z!&M-@<$=$j@eB&LL@\6a2;(B
     (?$(O*u(B . ?\x025F);; $(OK@IU$-%I%C%HL5$7(BJ$(O>.J8;z!&M-@<9E8}38GKNv2;(B
     (?$(O*v(B . ?\x0272);; $(O:8%U%C%/IU$-(BN$(O>.J8;z!&M-@<9E8}38I!2;(B
     (?$(O*w(B . ?\x029D);; $(O%/%m%9%I%F!<%kIU$-(BJ$(O>.J8;z!&M-@<9E8}38K`;$2;(B
     (?$(O*x(B . ?\x028E);; $(O%?!<%s%I(BY$(O>.J8;z!&M-@<9E8}38B&LL@\6a2;(B
     (?$(O*y(B . ?\x0261);; $(OI.5-BN(BG$(O>.J8;z!&M-@<Fp8}38GKNv2;(B
     (?$(O*z(B . ?\x014B);; ENG$(O>.J8;z!&M-@<Fp8}38I!2;(B
     (?$(O*{(B . ?\x0270);; $(O%m%s%0%l%C%0IU$-%?!<%s%I(BM$(O>.J8;z!&M-@<Fp8}38@\6a2;(B
     (?$(O*|(B . ?\x0281);; $(O%$%s%P!<%F%C%I(BR$(O%9%b!<%k%-%c%T%?%k!&M-@<8}38?bK`;$2;(B
     (?$(O*}(B . ?\x0127);; $(OK@IU$-(BH$(O>.J8;z!&L5@<0vF,K`;$2;(B
     (?$(O*~(B . ?\x0295);; $(OM-@<0vF,K`;$2;(B
     (?$(O+!(B . ?\x0294);; $(OL5@<@<LgGKNv2;(B
     (?$(O+"(B . ?\x0266);; $(O%U%C%/IU$-(BH$(O>.J8;z!&M-@<@<LgK`;$2;(B
     (?$(O+#(B . ?\x0298);; $(ON>?05[Ce2;(B
     (?$(O+$(B . ?\x01C2);; $(O9E8}38;u7T5[Ce2;(B
     (?$(O+%(B . ?\x0253);; $(O%U%C%/IU$-(BB$(O>.J8;z!&M-@<N>?0FbGK2;(B
     (?$(O+&(B . ?\x0257);; $(O%U%C%/IU$-(BD$(O>.J8;z!&M-@<;u7TFbGK2;(B
     (?$(O+'(B . ?\x0284);; $(O%U%C%/!&%P!<IU$-%I%C%H%l%9(BJ$(O>.J8;z!&M-@<9E8}38FbGK2;(B
     (?$(O+((B . ?\x0260);; $(O%U%C%/IU$-(BG$(O>.J8;z!&M-@<Fp8}38FbGK2;(B
     (?$(O+)(B . ?\x0193);; $(O%U%C%/IU$-(BG$(OBgJ8;z!&M-@<8}38?bFbGK2;(B
     (?$(O+*(B . ?\x0153);; $(O%j%,%A%c(BOE$(O>.J8;z!&1_?0A0@e9-!&CfCJJl2;(B
     (?$(O++(B . ?\x0152);; $(O%j%,%A%c(BOE$(OBgJ8;z!&1_?0A0@e9-Jl2;(B
     (?$(O+,(B . ?\x0268);; $(OK@IU$-(BI$(O>.J8;z!&Hs1_?0Cf@e69Jl2;(B
     (?$(O+-(B . ?\x0289);; $(OK@IU$-(BU$(O>.J8;z!&1_?0Cf@e69Jl2;(B
     (?$(O+.(B . ?\x0258);; $(O%j%P!<%9(BE$(O>.J8;z!&Hs1_?0Cf@e69!&CfCJJl2;(B
     (?$(O+/(B . ?\x0275);; $(OK@IU$-(BO$(O>.J8;z!&1_?0Cf@e69!&CfCJJl2;(B
     (?$(O+0(B . ?\x0259);; SCHWA$(O>.J8;z!&Hs1_?0Cf@eCf1{Jl2;(B
     (?$(O+1(B . ?\x025C);; $(O%j%P!<%9%*!<%W%s(BE$(O>.J8;z!&Hs1_?0Cf@e9-!&CfCJJl2;(B
     (?$(O+2(B . ?\x025E);; $(O%/%m!<%:%I%j%P!<%9%*!<%W%s(BE$(O>.J8;z!&1_?0Cf@e9-!&CfCJJl2;(B
     (?$(O+3(B . ?\x0250);; $(O%?!<%s%I(BA$(O>.J8;z!&Hs1_?0Cf@e69$a$N9-Jl2;(B
     (?$(O+4(B . ?\x026F);; $(O%?!<%s%I(BM$(O>.J8;z!&Hs1_?08e@e69Jl2;(B
     (?$(O+5(B . ?\x028A);; UPSILON$(O>.J8;z!&1_?08e@e9-$a$N69Jl2;(B
     (?$(O+6(B . ?\x0264);; $(O%Y%S!<%,%s%^!&Hs1_?08e@e69CfCJJl2;(B
     (?$(O+7(B . ?\x028C);; $(O%?!<%s%I(BV$(O>.J8;z!&Hs1_?08e@e9-!&CfCJJl2;(B
     (?$(O+8(B . ?\x0254);; $(O%*!<%W%s(BO$(O>.J8;z!&1_?08e@e9-!&CfCJJl2;(B
     (?$(O+9(B . ?\x0251);; ALPHA$(O>.J8;z!&Hs1_?08e@e9-Jl2;(B
     (?$(O+:(B . ?\x0252);; $(O%?!<%s%I(BALPHA$(O>.J8;z!&1_?08e@e9-Jl2;(B
     (?$(O+;(B . ?\x028D);; $(O%?!<%s%I(BW$(O>.J8;z!&L5@<N>?0!&Fp8}38K`;$2;(B
     (?$(O+<(B . ?\x0265);; $(O%?!<%s%I(BH$(O>.J8;z!&M-@<N>?0!&9E8}38@\6a2;(B
     (?$(O+=(B . ?\x02A2);; $(OM-@<0vF,38K`;$2;(B
     (?$(O+>(B . ?\x02A1);; $(O0vF,38GKNv2;(B
     (?$(O+?(B . ?\x0255);; $(O%+!<%kIU$-(BC$(O>.J8;z!&;u7T!&9E8}38K`;$2;(B
     (?$(O+@(B . ?\x0291);; $(O%+!<%kIU$-(BZ$(O>.J8;z!&;u7T!&9E8}38K`;$2;(B
     (?$(O+A(B . ?\x027A);; $(O%m%s%0%l%C%0IU$-%?!<%s%I(BR$(O>.J8;z!&;u7TB&LLCF$-2;(B
     (?$(O+B(B . ?\x0267);; $(O%U%C%/IU$-(BHENG$(O>.J8;z!&L5@<8eIt;u7TFp8}38K`;$2;(B
     (?$(O+C(B . ?\x025A);; $(O%U%C%/IU$-(BSCHWA
     ;;(?$(O+D(B . ?\x(0234))  ;; $(O%0%l!<%V%"%/%;%s%HIU$-(BAE$(O>.J8;z(B
     (?$(O+E(B . ?\x01FD);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BAE$(O>.J8;z(B
     (?$(O+F(B . ?\x1F70);; $(O%0%l!<%V%"%/%;%s%HIU$-(BALPHA$(O>.J8;z(B
     (?$(O+G(B . ?\x1F71);; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BALPHA$(O>.J8;z(B
     ;;(?$(O+H(B . ?\x(0235))  ;; $(O%0%l!<%V%"%/%;%s%HIU$-%*!<%W%s(BO$(O>.J8;z(B
     ;;(?$(O+I(B . ?\x(0236))  ;; $(O%"%-%e!<%H%"%/%;%s%HIU$-%*!<%W%s(BO$(O>.J8;z(B
     ;;(?$(O+J(B . ?\x(0237))  ;; $(O%0%l!<%V%"%/%;%s%HIU$-%?!<%s%I(BV$(O>.J8;z(B
     ;;(?$(O+K(B . ?\x(0238))  ;; $(O%"%-%e!<%H%"%/%;%s%HIU$-%?!<%s%I(BV$(O>.J8;z(B
     ;;(?$(O+L(B . ?\x(0239))  ;; $(O%0%l!<%V%"%/%;%s%HIU$-(BSCHWA$(O>.J8;z(B
     ;;(?$(O+M(B . ?\x(023A))  ;; $(O%"%-%e!<%H%"%/%;%s%HIU$-(BSCHWA$(O>.J8;z(B
     ;;(?$(O+N(B . ?\x(023B))  ;; $(O%0%l!<%V%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$(O>.J8;z(B
     ;;(?$(O+O(B . ?\x(023C))  ;; $(O%"%-%e!<%H%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$(O>.J8;z(B
     (?$(O+P(B . ?\x1F72);; $(O%0%l!<%V%"%/%;%s%HIU$-%*!<%W%s(BE$(O>.J8;z(B
     (?$(O+Q(B . ?\x1F73);; $(O%"%-%e!<%H%"%/%;%s%HIU$-%*!<%W%s(BE$(O>.J8;z(B
     (?$(O+R(B . ?\x0361);; $(OGK;$2;$^$?$OFs=ED42;5-9f(B
     (?$(O+S(B . ?\x02C8);; $(OBh0l6/@*(B
     (?$(O+T(B . ?\x02CC);; $(OBhFs6/@*(B
     (?$(O+U(B . ?\x02D0);; $(OD9(B
     (?$(O+V(B . ?\x02D1);; $(OH>D9(B
     (?$(O+W(B . ?\x0306);; $(OD6C;(B
     ;;(?$(O+X(B . ?\x(0363))  ;; $(OO"7k$7$F$$$k(B
     (?$(O+Y(B . ?\x030B);; $(OD69b(B
     (?$(O+Z(B . ?\x0301);; $(O9b(B
     (?$(O+[(B . ?\x0304);; $(OCf(B
     (?$(O+\(B . ?\x0300);; $(ODc(B
     (?$(O+](B . ?\x030F);; $(OD6Dc(B
     (?$(O+^(B . ?\x030C);; $(O>e>:D4(B
     (?$(O+_(B . ?\x0302);; $(O2<9_D4(B
     (?$(O+`(B . ?\x02E5);; $(OD69b(B
     (?$(O+a(B . ?\x02E6);; $(O9b(B
     (?$(O+b(B . ?\x02E7);; $(OCf(B
     (?$(O+c(B . ?\x02E8);; $(ODc(B
     (?$(O+d(B . ?\x02E9);; $(OD6Dc(B
     ;;(?$(O+e(B . ?\x(02EF))  ;; $(O>e>:D4(B
     ;;(?$(O+f(B . ?\x(02F0))  ;; $(O2<9_D4(B
     (?$(O+g(B . ?\x0325);; $(OL5@<(B
     (?$(O+h(B . ?\x032C);; $(OM-@<(B
     (?$(O+i(B . ?\x0339);; $(O$h$j1_?0@-$N6/$$(B
     (?$(O+j(B . ?\x031C);; $(O$h$j1_?0@-$N<e$$(B
     (?$(O+k(B . ?\x031F);; $(OA04s$j$N(B
     (?$(O+l(B . ?\x0320);; $(O8e$m4s$j$N(B
     (?$(O+m(B . ?\x0308);; $(OCf@eJl2;2=(B
     (?$(O+n(B . ?\x033D);; $(OCfCJCf@eJl2;2=(B
     (?$(O+o(B . ?\x0329);; $(O2;@a<g2;E*(B
     (?$(O+p(B . ?\x032F);; $(O2;@aI{2;E*(B
     (?$(O+q(B . ?\x02DE);; r$(O$N2;?'(B
     (?$(O+r(B . ?\x0324);; $(O$+$9$l2;(B
     (?$(O+s(B . ?\x0330);; $(O$-$7$_2;(B
     (?$(O+t(B . ?\x033C);; $(O@e@hC<?02;(B
     (?$(O+u(B . ?\x0334);; $(OFp8}382=$"$k$$$O0vF,2=(B
     (?$(O+v(B . ?\x031D);; $(O9b@e$N(B
     (?$(O+w(B . ?\x031E);; $(ODc@e$N(B
     (?$(O+x(B . ?\x0318);; $(OA0J}@e:,@-(B
     (?$(O+y(B . ?\x0319);; $(O8eJ}@e:,@-(B
     (?$(O+z(B . ?\x032A);; $(O;u(B
     (?$(O+{(B . ?\x033A);; $(O@e@hE*(B
     (?$(O+|(B . ?\x033B);; $(O@eC<E*(B
     (?$(O+}(B . ?\x0303);; $(OI!2;2=(B
     (?$(O+~(B . ?\x031A);; $(O3+J|$,J9$3$($J$$(B
     (?$(O,!(B . ?\x2776);; $(O9u4](B1
     (?$(O,"(B . ?\x2777);; $(O9u4](B2
     (?$(O,#(B . ?\x2778);; $(O9u4](B3
     (?$(O,$(B . ?\x2779);; $(O9u4](B4
     (?$(O,%(B . ?\x277A);; $(O9u4](B5
     (?$(O,&(B . ?\x277B);; $(O9u4](B6
     (?$(O,'(B . ?\x277C);; $(O9u4](B7
     (?$(O,((B . ?\x277D);; $(O9u4](B8
     (?$(O,)(B . ?\x277E);; $(O9u4](B9
     (?$(O,*(B . ?\x277F);; $(O9u4](B10
     ;;(?$(O,+(B . ?\x(27EE))  ;; $(O9u4](B11
     ;;(?$(O,,(B . ?\x(27EF))  ;; $(O9u4](B12
     ;;(?$(O,-(B . ?\x(27F0))  ;; $(O9u4](B13
     ;;(?$(O,.(B . ?\x(27F1))  ;; $(O9u4](B14
     ;;(?$(O,/(B . ?\x(27F2))  ;; $(O9u4](B15
     ;;(?$(O,0(B . ?\x(27F3))  ;; $(O9u4](B16
     ;;(?$(O,1(B . ?\x(27F4))  ;; $(O9u4](B17
     ;;(?$(O,2(B . ?\x(27F5))  ;; $(O9u4](B18
     ;;(?$(O,3(B . ?\x(27F6))  ;; $(O9u4](B19
     ;;(?$(O,4(B . ?\x(27F7))  ;; $(O9u4](B20
     (?$(O,5(B . ?\x2170);; $(O%m!<%^?t;z(B1$(O>.J8;z(B
     (?$(O,6(B . ?\x2171);; $(O%m!<%^?t;z(B2$(O>.J8;z(B
     (?$(O,7(B . ?\x2172);; $(O%m!<%^?t;z(B3$(O>.J8;z(B
     (?$(O,8(B . ?\x2173);; $(O%m!<%^?t;z(B4$(O>.J8;z(B
     (?$(O,9(B . ?\x2174);; $(O%m!<%^?t;z(B5$(O>.J8;z(B
     (?$(O,:(B . ?\x2175);; $(O%m!<%^?t;z(B6$(O>.J8;z(B
     (?$(O,;(B . ?\x2176);; $(O%m!<%^?t;z(B7$(O>.J8;z(B
     (?$(O,<(B . ?\x2177);; $(O%m!<%^?t;z(B8$(O>.J8;z(B
     (?$(O,=(B . ?\x2178);; $(O%m!<%^?t;z(B9$(O>.J8;z(B
     (?$(O,>(B . ?\x2179);; $(O%m!<%^?t;z(B10$(O>.J8;z(B
     (?$(O,?(B . ?\x217A);; $(O%m!<%^?t;z(B11$(O>.J8;z(B
     (?$(O,@(B . ?\x217B);; $(O%m!<%^?t;z(B12$(O>.J8;z(B
     (?$(O,A(B . ?\x24D0);; $(O4](Ba
     (?$(O,B(B . ?\x24D1);; $(O4](Bb
     (?$(O,C(B . ?\x24D2);; $(O4](Bc
     (?$(O,D(B . ?\x24D3);; $(O4](Bd
     (?$(O,E(B . ?\x24D4);; $(O4](Be
     (?$(O,F(B . ?\x24D5);; $(O4](Bf
     (?$(O,G(B . ?\x24D6);; $(O4](Bg
     (?$(O,H(B . ?\x24D7);; $(O4](Bh
     (?$(O,I(B . ?\x24D8);; $(O4](Bi
     (?$(O,J(B . ?\x24D9);; $(O4](Bj
     (?$(O,K(B . ?\x24DA);; $(O4](Bk
     (?$(O,L(B . ?\x24DB);; $(O4](Bl
     (?$(O,M(B . ?\x24DC);; $(O4](Bm
     (?$(O,N(B . ?\x24DD);; $(O4](Bn
     (?$(O,O(B . ?\x24DE);; $(O4](Bo
     (?$(O,P(B . ?\x24DF);; $(O4](Bp
     (?$(O,Q(B . ?\x24E0);; $(O4](Bq
     (?$(O,R(B . ?\x24E1);; $(O4](Br
     (?$(O,S(B . ?\x24E2);; $(O4](Bs
     (?$(O,T(B . ?\x24E3);; $(O4](Bt
     (?$(O,U(B . ?\x24E4);; $(O4](Bu
     (?$(O,V(B . ?\x24E5);; $(O4](Bv
     (?$(O,W(B . ?\x24E6);; $(O4](Bw
     (?$(O,X(B . ?\x24E7);; $(O4](Bx
     (?$(O,Y(B . ?\x24E8);; $(O4](By
     (?$(O,Z(B . ?\x24E9);; $(O4](Bz
     (?$(O,[(B . ?\x32D0);; $(O4]%"(B
     (?$(O,\(B . ?\x32D1);; $(O4]%$(B
     (?$(O,](B . ?\x32D2);; $(O4]%&(B
     (?$(O,^(B . ?\x32D3);; $(O4]%((B
     (?$(O,_(B . ?\x32D4);; $(O4]%*(B
     (?$(O,`(B . ?\x32D5);; $(O4]%+(B
     (?$(O,a(B . ?\x32D6);; $(O4]%-(B
     (?$(O,b(B . ?\x32D7);; $(O4]%/(B
     (?$(O,c(B . ?\x32D8);; $(O4]%1(B
     (?$(O,d(B . ?\x32D9);; $(O4]%3(B
     (?$(O,e(B . ?\x32DA);; $(O4]%5(B
     (?$(O,f(B . ?\x32DB);; $(O4]%7(B
     (?$(O,g(B . ?\x32DC);; $(O4]%9(B
     (?$(O,h(B . ?\x32DD);; $(O4]%;(B
     (?$(O,i(B . ?\x32DE);; $(O4]%=(B
     (?$(O,j(B . ?\x32DF);; $(O4]%?(B
     (?$(O,k(B . ?\x32E0);; $(O4]%A(B
     (?$(O,l(B . ?\x32E1);; $(O4]%D(B
     (?$(O,m(B . ?\x32E2);; $(O4]%F(B
     (?$(O,n(B . ?\x32E3);; $(O4]%H(B
     (?$(O,o(B . ?\x32FA);; $(O4]%m(B
     (?$(O,p(B . ?\x32E9);; $(O4]%O(B
     (?$(O,q(B . ?\x32E5);; $(O4]%K(B
     (?$(O,r(B . ?\x32ED);; $(O4]%[(B
     (?$(O,s(B . ?\x32EC);; $(O4]%X(B
     ;;(?$(O,}(B . ?\x(2053))  ;; $(O%@%V%k%"%9%F(B
     (?$(O,~(B . ?\x2042);; $(O%"%9%F%j%:%`(B
     (?$(O-!(B . ?\x2460);; $(O4](B1
     (?$(O-"(B . ?\x2461);; $(O4](B2
     (?$(O-#(B . ?\x2462);; $(O4](B3
     (?$(O-$(B . ?\x2463);; $(O4](B4
     (?$(O-%(B . ?\x2464);; $(O4](B5
     (?$(O-&(B . ?\x2465);; $(O4](B6
     (?$(O-'(B . ?\x2466);; $(O4](B7
     (?$(O-((B . ?\x2467);; $(O4](B8
     (?$(O-)(B . ?\x2468);; $(O4](B9
     (?$(O-*(B . ?\x2469);; $(O4](B10
     (?$(O-+(B . ?\x246A);; $(O4](B11
     (?$(O-,(B . ?\x246B);; $(O4](B12
     (?$(O--(B . ?\x246C);; $(O4](B13
     (?$(O-.(B . ?\x246D);; $(O4](B14
     (?$(O-/(B . ?\x246E);; $(O4](B15
     (?$(O-0(B . ?\x246F);; $(O4](B16
     (?$(O-1(B . ?\x2470);; $(O4](B17
     (?$(O-2(B . ?\x2471);; $(O4](B18
     (?$(O-3(B . ?\x2472);; $(O4](B19
     (?$(O-4(B . ?\x2473);; $(O4](B20
     (?$(O-5(B . ?\x2160);; $(O%m!<%^?t;z(B1
     (?$(O-6(B . ?\x2161);; $(O%m!<%^?t;z(B2
     (?$(O-7(B . ?\x2162);; $(O%m!<%^?t;z(B3
     (?$(O-8(B . ?\x2163);; $(O%m!<%^?t;z(B4
     (?$(O-9(B . ?\x2164);; $(O%m!<%^?t;z(B5
     (?$(O-:(B . ?\x2165);; $(O%m!<%^?t;z(B6
     (?$(O-;(B . ?\x2166);; $(O%m!<%^?t;z(B7
     (?$(O-<(B . ?\x2167);; $(O%m!<%^?t;z(B8
     (?$(O-=(B . ?\x2168);; $(O%m!<%^?t;z(B9
     (?$(O->(B . ?\x2169);; $(O%m!<%^?t;z(B10
     (?$(O-?(B . ?\x216A);; $(O%m!<%^?t;z(B11
     (?$(O-@(B . ?\x3349);; $(O%_%j(B
     (?$(O-A(B . ?\x3314);; $(O%-%m(B
     (?$(O-B(B . ?\x3322);; $(O%;%s%A(B
     (?$(O-C(B . ?\x334D);; $(O%a!<%H%k(B
     (?$(O-D(B . ?\x3318);; $(O%0%i%`(B
     (?$(O-E(B . ?\x3327);; $(O%H%s(B
     (?$(O-F(B . ?\x3303);; $(O%"!<%k(B
     (?$(O-G(B . ?\x3336);; $(O%X%/%?!<%k(B
     (?$(O-H(B . ?\x3351);; $(O%j%C%H%k(B
     (?$(O-I(B . ?\x3357);; $(O%o%C%H(B
     (?$(O-J(B . ?\x330D);; $(O%+%m%j!<(B
     (?$(O-K(B . ?\x3326);; $(O%I%k(B
     (?$(O-L(B . ?\x3323);; $(O%;%s%H(B
     (?$(O-M(B . ?\x332B);; $(O%Q!<%;%s%H(B
     (?$(O-N(B . ?\x334A);; $(O%_%j%P!<%k(B
     (?$(O-O(B . ?\x333B);; $(O%Z!<%8(B
     (?$(O-P(B . ?\x339C);; mm
     (?$(O-Q(B . ?\x339D);; cm
     (?$(O-R(B . ?\x339E);; km
     (?$(O-S(B . ?\x338E);; mg
     (?$(O-T(B . ?\x338F);; kg
     (?$(O-U(B . ?\x33C4);; cc
     (?$(O-V(B . ?\x33A1);; m2
     (?$(O-W(B . ?\x216B);; $(O%m!<%^?t;z(B12
     (?$(O-_(B . ?\x337B);; $(O859fJ?@.(B
     (?$(O-`(B . ?\x301D);; $(O;O$a%@%V%k%_%K%e!<%H(B
     (?$(O-a(B . ?\x301F);; $(O=*$o$j%@%V%k%_%K%e!<%H(B
     (?$(O-b(B . ?\x2116);; No.
     (?$(O-c(B . ?\x33CD);; K.K.
     (?$(O-d(B . ?\x2121);; TEL
     (?$(O-e(B . ?\x32A4);; $(O4]IU$->e(B
     (?$(O-f(B . ?\x32A5);; $(O4]IU$-Cf(B
     (?$(O-g(B . ?\x32A6);; $(O4]IU$-2<(B
     (?$(O-h(B . ?\x32A7);; $(O4]IU$-:8(B
     (?$(O-i(B . ?\x32A8);; $(O4]IU$-1&(B
     (?$(O-j(B . ?\x3231);; $(O3g8LIU$-3t(B
     (?$(O-k(B . ?\x3232);; $(O3g8LIU$-M-(B
     (?$(O-l(B . ?\x3239);; $(O3g8LIU$-Be(B
     (?$(O-m(B . ?\x337E);; $(O859fL@<#(B
     (?$(O-n(B . ?\x337D);; $(O859fBg@5(B
     (?$(O-o(B . ?\x337C);; $(O859f><OB(B
     (?$(O-s(B . ?\x222E);; $(O7PO)@QJ,(B
     (?$(O-x(B . ?\x221F);; $(O%U%!%/%H%j%"%k!&D>3Q(B
     (?$(O-y(B . ?\x22BF);; $(OD>3Q;03Q(B
     (?$(O-}(B . ?\x2756);; $(O;M$DI)(B
     (?$(O-~(B . ?\x261E);; $(O;X<(%^!<%/(B
     (?$(O.#(B . ?\x3402);; 
     (?$(O.$(B . ?\x4E28);; 
     (?$(O.%(B . ?\x4E2F);; 
     (?$(O.&(B . ?\x4E30);; 
     (?$(O.'(B . ?\x4E8D);; 
     (?$(O.((B . ?\x4EE1);; 
     (?$(O.)(B . ?\x4EFD);; 
     (?$(O.*(B . ?\x4EFF);; 
     (?$(O.+(B . ?\x4F03);; 
     (?$(O.,(B . ?\x4F0B);; 
     (?$(O.-(B . ?\x4F60);; 
     (?$(O..(B . ?\x4F48);; 
     (?$(O./(B . ?\x4F49);; 
     (?$(O.0(B . ?\x4F56);; 
     (?$(O.1(B . ?\x4F5F);; 
     (?$(O.2(B . ?\x4F6A);; 
     (?$(O.3(B . ?\x4F6C);; 
     (?$(O.4(B . ?\x4F7E);; 
     (?$(O.5(B . ?\x4F8A);; 
     (?$(O.6(B . ?\x4F94);; 
     (?$(O.7(B . ?\x4F97);; 
     ;;(?$(O.8(B . ?\x(fa30))  ;; 
     (?$(O.9(B . ?\x4FC9);; 
     (?$(O.:(B . ?\x4FE0);; 
     (?$(O.;(B . ?\x5001);; 
     (?$(O.<(B . ?\x5002);; 
     (?$(O.=(B . ?\x500E);; 
     (?$(O.>(B . ?\x5018);; 
     (?$(O.?(B . ?\x5027);; 
     (?$(O.@(B . ?\x502E);; 
     (?$(O.A(B . ?\x5040);; 
     (?$(O.B(B . ?\x503B);; 
     (?$(O.C(B . ?\x5041);; 
     (?$(O.D(B . ?\x5094);; 
     (?$(O.E(B . ?\x50CC);; 
     (?$(O.F(B . ?\x50F2);; 
     (?$(O.G(B . ?\x50D0);; 
     (?$(O.H(B . ?\x50E6);; 
     ;;(?$(O.I(B . ?\x(fa31))  ;; 
     (?$(O.J(B . ?\x5106);; 
     (?$(O.K(B . ?\x5103);; 
     (?$(O.L(B . ?\x510B);; 
     (?$(O.M(B . ?\x511E);; 
     (?$(O.N(B . ?\x5135);; 
     (?$(O.O(B . ?\x514A);; 
     ;;(?$(O.P(B . ?\x(fa32))  ;; 
     (?$(O.Q(B . ?\x5155);; 
     (?$(O.R(B . ?\x5157);; 
     (?$(O.S(B . ?\x34B5);; 
     (?$(O.T(B . ?\x519D);; 
     (?$(O.U(B . ?\x51C3);; 
     (?$(O.V(B . ?\x51CA);; 
     (?$(O.W(B . ?\x51DE);; 
     (?$(O.X(B . ?\x51E2);; 
     (?$(O.Y(B . ?\x51EE);; 
     (?$(O.Z(B . ?\x5201);; 
     (?$(O.[(B . ?\x34DB);; 
     (?$(O.\(B . ?\x5213);; 
     (?$(O.](B . ?\x5215);; 
     (?$(O.^(B . ?\x5249);; 
     (?$(O._(B . ?\x5257);; 
     (?$(O.`(B . ?\x5261);; 
     (?$(O.a(B . ?\x5293);; 
     (?$(O.b(B . ?\x52C8);; 
     ;;(?$(O.c(B . ?\x(fa33))  ;; 
     (?$(O.d(B . ?\x52CC);; 
     (?$(O.e(B . ?\x52D0);; 
     (?$(O.f(B . ?\x52D6);; 
     (?$(O.g(B . ?\x52DB);; 
     ;;(?$(O.h(B . ?\x(fa34))  ;; 
     (?$(O.i(B . ?\x52F0);; 
     (?$(O.j(B . ?\x52FB);; 
     (?$(O.k(B . ?\x5300);; 
     (?$(O.l(B . ?\x5307);; 
     (?$(O.m(B . ?\x531C);; 
     ;;(?$(O.n(B . ?\x(fa35))  ;; 
     (?$(O.o(B . ?\x5361);; 
     (?$(O.p(B . ?\x5363);; 
     (?$(O.q(B . ?\x537D);; 
     (?$(O.r(B . ?\x5393);; 
     (?$(O.s(B . ?\x539D);; 
     (?$(O.t(B . ?\x53B2);; 
     (?$(O.u(B . ?\x5412);; 
     (?$(O.v(B . ?\x5427);; 
     (?$(O.w(B . ?\x544D);; 
     (?$(O.x(B . ?\x549C);; 
     (?$(O.y(B . ?\x546B);; 
     (?$(O.z(B . ?\x5474);; 
     (?$(O.{(B . ?\x547F);; 
     (?$(O.|(B . ?\x5488);; 
     (?$(O.}(B . ?\x5496);; 
     (?$(O.~(B . ?\x54A1);; 
     (?$(O/!(B . ?\x54A9);; 
     (?$(O/"(B . ?\x54C6);; 
     (?$(O/#(B . ?\x54FF);; 
     (?$(O/$(B . ?\x550E);; 
     (?$(O/%(B . ?\x552B);; 
     (?$(O/&(B . ?\x5535);; 
     (?$(O/'(B . ?\x5550);; 
     (?$(O/((B . ?\x555E);; 
     (?$(O/)(B . ?\x5581);; 
     (?$(O/*(B . ?\x5586);; 
     (?$(O/+(B . ?\x558E);; 
     ;;(?$(O/,(B . ?\x(fa36))  ;; 
     (?$(O/-(B . ?\x55AD);; 
     (?$(O/.(B . ?\x55CE);; 
     ;;(?$(O//(B . ?\x(fa37))  ;; 
     (?$(O/0(B . ?\x5608);; 
     (?$(O/1(B . ?\x560E);; 
     (?$(O/2(B . ?\x563B);; 
     (?$(O/3(B . ?\x5649);; 
     (?$(O/4(B . ?\x5676);; 
     (?$(O/5(B . ?\x5666);; 
     ;;(?$(O/6(B . ?\x(fa38))  ;; 
     (?$(O/7(B . ?\x566F);; 
     (?$(O/8(B . ?\x5671);; 
     (?$(O/9(B . ?\x5672);; 
     (?$(O/:(B . ?\x5699);; 
     (?$(O/;(B . ?\x569E);; 
     (?$(O/<(B . ?\x56A9);; 
     (?$(O/=(B . ?\x56AC);; 
     (?$(O/>(B . ?\x56B3);; 
     (?$(O/?(B . ?\x56C9);; 
     (?$(O/@(B . ?\x56CA);; 
     (?$(O/A(B . ?\x570A);; 
     ;;(?$(O/B(B . ?\x(aabe))  ;; 
     (?$(O/C(B . ?\x5721);; 
     (?$(O/D(B . ?\x572F);; 
     (?$(O/E(B . ?\x5733);; 
     (?$(O/F(B . ?\x5734);; 
     (?$(O/G(B . ?\x5770);; 
     (?$(O/H(B . ?\x5777);; 
     (?$(O/I(B . ?\x577C);; 
     (?$(O/J(B . ?\x579C);; 
     (?$(O/K(B . ?\xFA0F);; 
     ;;(?$(O/L(B . ?\x(aac4))  ;; 
     (?$(O/M(B . ?\x57B8);; 
     (?$(O/N(B . ?\x57C7);; 
     (?$(O/O(B . ?\x57C8);; 
     (?$(O/P(B . ?\x57CF);; 
     (?$(O/Q(B . ?\x57E4);; 
     (?$(O/R(B . ?\x57ED);; 
     (?$(O/S(B . ?\x57F5);; 
     (?$(O/T(B . ?\x57F6);; 
     (?$(O/U(B . ?\x57FF);; 
     (?$(O/V(B . ?\x5809);; 
     (?$(O/W(B . ?\xFA10);; 
     (?$(O/X(B . ?\x5861);; 
     (?$(O/Y(B . ?\x5864);; 
     ;;(?$(O/Z(B . ?\x(fa39))  ;; 
     (?$(O/[(B . ?\x587C);; 
     (?$(O/\(B . ?\x5889);; 
     (?$(O/](B . ?\x589E);; 
     ;;(?$(O/^(B . ?\x(fa3a))  ;; 
     (?$(O/_(B . ?\x58A9);; 
     ;;(?$(O/`(B . ?\x(aac9))  ;; 
     (?$(O/a(B . ?\x58D2);; 
     (?$(O/b(B . ?\x58CE);; 
     (?$(O/c(B . ?\x58D4);; 
     (?$(O/d(B . ?\x58DA);; 
     (?$(O/e(B . ?\x58E0);; 
     (?$(O/f(B . ?\x58E9);; 
     (?$(O/g(B . ?\x590C);; 
     (?$(O/h(B . ?\x8641);; 
     (?$(O/i(B . ?\x595D);; 
     (?$(O/j(B . ?\x596D);; 
     (?$(O/k(B . ?\x598B);; 
     (?$(O/l(B . ?\x5992);; 
     (?$(O/m(B . ?\x59A4);; 
     (?$(O/n(B . ?\x59C3);; 
     (?$(O/o(B . ?\x59D2);; 
     (?$(O/p(B . ?\x59DD);; 
     (?$(O/q(B . ?\x5A13);; 
     (?$(O/r(B . ?\x5A23);; 
     (?$(O/s(B . ?\x5A67);; 
     (?$(O/t(B . ?\x5A6D);; 
     (?$(O/u(B . ?\x5A77);; 
     (?$(O/v(B . ?\x5A7E);; 
     (?$(O/w(B . ?\x5A84);; 
     (?$(O/x(B . ?\x5A9E);; 
     (?$(O/y(B . ?\x5AA7);; 
     (?$(O/z(B . ?\x5AC4);; 
     ;;(?$(O/{(B . ?\x(aad0))  ;; 
     (?$(O/|(B . ?\x5B19);; 
     (?$(O/}(B . ?\x5B25);; 
     (?$(OOU(B . ?\x5B41);; 
     (?$(OOV(B . ?\x5B56);; 
     (?$(OOW(B . ?\x5B7D);; 
     (?$(OOX(B . ?\x5B93);; 
     (?$(OOY(B . ?\x5BD8);; 
     (?$(OOZ(B . ?\x5BEC);; 
     (?$(OO[(B . ?\x5C12);; 
     (?$(OO\(B . ?\x5C1E);; 
     (?$(OO](B . ?\x5C23);; 
     (?$(OO^(B . ?\x5C2B);; 
     (?$(OO_(B . ?\x378D);; 
     (?$(OO`(B . ?\x5C62);; 
     ;;(?$(OOa(B . ?\x(fa3b))  ;; 
     ;;(?$(OOb(B . ?\x(fa3c))  ;; 
     ;;(?$(OOc(B . ?\x(aad4))  ;; 
     (?$(OOd(B . ?\x5C7A);; 
     (?$(OOe(B . ?\x5C8F);; 
     (?$(OOf(B . ?\x5C9F);; 
     (?$(OOg(B . ?\x5CA3);; 
     (?$(OOh(B . ?\x5CAA);; 
     (?$(OOi(B . ?\x5CBA);; 
     (?$(OOj(B . ?\x5CCB);; 
     (?$(OOk(B . ?\x5CD0);; 
     (?$(OOl(B . ?\x5CD2);; 
     (?$(OOm(B . ?\x5CF4);; 
     ;;(?$(OOn(B . ?\x(aadd))  ;; 
     (?$(OOo(B . ?\x37E2);; 
     (?$(OOp(B . ?\x5D0D);; 
     (?$(OOq(B . ?\x5D27);; 
     (?$(OOr(B . ?\xFA11);; 
     (?$(OOs(B . ?\x5D46);; 
     (?$(OOt(B . ?\x5D47);; 
     (?$(OOu(B . ?\x5D53);; 
     (?$(OOv(B . ?\x5D4A);; 
     (?$(OOw(B . ?\x5D6D);; 
     (?$(OOx(B . ?\x5D81);; 
     (?$(OOy(B . ?\x5DA0);; 
     (?$(OOz(B . ?\x5DA4);; 
     (?$(OO{(B . ?\x5DA7);; 
     (?$(OO|(B . ?\x5DB8);; 
     (?$(OO}(B . ?\x5DCB);; 
     (?$(Ot((B . ?\x5DE2);; 
     (?$(Ot)(B . ?\x5E14);; 
     (?$(Ot*(B . ?\x5E18);; 
     (?$(Ot+(B . ?\x5E58);; 
     (?$(Ot,(B . ?\x5E5E);; 
     (?$(Ot-(B . ?\x5EBE);; 
     (?$(Ot.(B . ?\xF928);; 
     (?$(Ot/(B . ?\x5ECB);; 
     (?$(Ot0(B . ?\x5EF9);; 
     (?$(Ot1(B . ?\x5F00);; 
     (?$(Ot2(B . ?\x5F02);; 
     (?$(Ot3(B . ?\x5F07);; 
     (?$(Ot4(B . ?\x5F1D);; 
     (?$(Ot5(B . ?\x5F23);; 
     (?$(Ot6(B . ?\x5F34);; 
     (?$(Ot7(B . ?\x5F36);; 
     (?$(Ot8(B . ?\x5F3D);; 
     (?$(Ot9(B . ?\x5F40);; 
     (?$(Ot:(B . ?\x5F45);; 
     (?$(Ot;(B . ?\x5F54);; 
     (?$(Ot<(B . ?\x5F58);; 
     (?$(Ot=(B . ?\x5F64);; 
     (?$(Ot>(B . ?\x5F67);; 
     (?$(Ot?(B . ?\x5F7D);; 
     (?$(Ot@(B . ?\x5F89);; 
     (?$(OtA(B . ?\x5F9C);; 
     (?$(OtB(B . ?\x5FA7);; 
     (?$(OtC(B . ?\x5FAF);; 
     (?$(OtD(B . ?\x5FB5);; 
     (?$(OtE(B . ?\x5FB7);; 
     (?$(OtF(B . ?\x5FC9);; 
     (?$(OtG(B . ?\x5FDE);; 
     (?$(OtH(B . ?\x5FE1);; 
     (?$(OtI(B . ?\x5FE9);; 
     (?$(OtJ(B . ?\x600D);; 
     (?$(OtK(B . ?\x6014);; 
     (?$(OtL(B . ?\x6018);; 
     (?$(OtM(B . ?\x6033);; 
     (?$(OtN(B . ?\x6035);; 
     (?$(OtO(B . ?\x6047);; 
     ;;(?$(OtP(B . ?\x(fa3d))  ;; 
     (?$(OtQ(B . ?\x609D);; 
     (?$(OtR(B . ?\x609E);; 
     (?$(OtS(B . ?\x60CB);; 
     (?$(OtT(B . ?\x60D4);; 
     (?$(OtU(B . ?\x60D5);; 
     (?$(OtV(B . ?\x60DD);; 
     (?$(OtW(B . ?\x60F8);; 
     (?$(OtX(B . ?\x611C);; 
     (?$(OtY(B . ?\x612B);; 
     (?$(OtZ(B . ?\x6130);; 
     (?$(Ot[(B . ?\x6137);; 
     ;;(?$(Ot\(B . ?\x(fa3e))  ;; 
     (?$(Ot](B . ?\x618D);; 
     ;;(?$(Ot^(B . ?\x(fa3f))  ;; 
     (?$(Ot_(B . ?\x61BC);; 
     (?$(Ot`(B . ?\x61B9);; 
     ;;(?$(Ota(B . ?\x(fa40))  ;; 
     (?$(Otb(B . ?\x6222);; 
     (?$(Otc(B . ?\x623E);; 
     (?$(Otd(B . ?\x6243);; 
     (?$(Ote(B . ?\x6256);; 
     (?$(Otf(B . ?\x625A);; 
     (?$(Otg(B . ?\x626F);; 
     (?$(Oth(B . ?\x6285);; 
     (?$(Oti(B . ?\x62C4);; 
     (?$(Otj(B . ?\x62D6);; 
     (?$(Otk(B . ?\x62FC);; 
     (?$(Otl(B . ?\x630A);; 
     (?$(Otm(B . ?\x6318);; 
     (?$(Otn(B . ?\x6339);; 
     (?$(Oto(B . ?\x6343);; 
     (?$(Otp(B . ?\x6365);; 
     (?$(Otq(B . ?\x637C);; 
     (?$(Otr(B . ?\x63E5);; 
     (?$(Ots(B . ?\x63ED);; 
     (?$(Ott(B . ?\x63F5);; 
     (?$(Otu(B . ?\x6410);; 
     (?$(Otv(B . ?\x6414);; 
     (?$(Otw(B . ?\x6422);; 
     (?$(Otx(B . ?\x6479);; 
     (?$(Oty(B . ?\x6451);; 
     (?$(Otz(B . ?\x6460);; 
     (?$(Ot{(B . ?\x646D);; 
     (?$(Ot|(B . ?\x64CE);; 
     (?$(Ot}(B . ?\x64BE);; 
     (?$(Ot~(B . ?\x64BF);; 
     (?$(Ou!(B . ?\x64C4);; 
     (?$(Ou"(B . ?\x64CA);; 
     (?$(Ou#(B . ?\x64D0);; 
     (?$(Ou$(B . ?\x64F7);; 
     (?$(Ou%(B . ?\x64FB);; 
     (?$(Ou&(B . ?\x6522);; 
     (?$(Ou'(B . ?\x6529);; 
     ;;(?$(Ou((B . ?\x(fa41))  ;; 
     (?$(Ou)(B . ?\x6567);; 
     (?$(Ou*(B . ?\x659D);; 
     ;;(?$(Ou+(B . ?\x(fa42))  ;; 
     (?$(Ou,(B . ?\x6600);; 
     (?$(Ou-(B . ?\x6609);; 
     (?$(Ou.(B . ?\x6615);; 
     (?$(Ou/(B . ?\x661E);; 
     (?$(Ou0(B . ?\x663A);; 
     (?$(Ou1(B . ?\x6622);; 
     (?$(Ou2(B . ?\x6624);; 
     (?$(Ou3(B . ?\x662B);; 
     (?$(Ou4(B . ?\x6630);; 
     (?$(Ou5(B . ?\x6631);; 
     (?$(Ou6(B . ?\x6633);; 
     (?$(Ou7(B . ?\x66FB);; 
     (?$(Ou8(B . ?\x6648);; 
     (?$(Ou9(B . ?\x664C);; 
     ;;(?$(Ou:(B . ?\x(aaf2))  ;; 
     (?$(Ou;(B . ?\x6659);; 
     (?$(Ou<(B . ?\x665A);; 
     (?$(Ou=(B . ?\x6661);; 
     (?$(Ou>(B . ?\x6665);; 
     (?$(Ou?(B . ?\x6673);; 
     ;;(?$(Ou@(B . ?\x6677?)  ;; 
     (?$(OuA(B . ?\x6678);; 
     (?$(OuB(B . ?\x668D);; 
     ;;(?$(OuC(B . ?\x(fa43))  ;; 
     (?$(OuD(B . ?\x66A0);; 
     (?$(OuE(B . ?\x66B2);; 
     (?$(OuF(B . ?\x66BB);; 
     (?$(OuG(B . ?\x66C6);; 
     (?$(OuH(B . ?\x66C8);; 
     (?$(OuI(B . ?\x3B22);; 
     (?$(OuJ(B . ?\x66DB);; 
     (?$(OuK(B . ?\x66E8);; 
     (?$(OuL(B . ?\x66FA);; 
     (?$(OuM(B . ?\x6713);; 
     (?$(OuN(B . ?\xF929);; 
     (?$(OuO(B . ?\x6733);; 
     (?$(OuP(B . ?\x6766);; 
     (?$(OuQ(B . ?\x6747);; 
     (?$(OuR(B . ?\x6748);; 
     (?$(OuS(B . ?\x677B);; 
     (?$(OuT(B . ?\x6781);; 
     (?$(OuU(B . ?\x6793);; 
     (?$(OuV(B . ?\x6798);; 
     (?$(OuW(B . ?\x679B);; 
     (?$(OuX(B . ?\x67BB);; 
     (?$(OuY(B . ?\x67F9);; 
     (?$(OuZ(B . ?\x67C0);; 
     (?$(Ou[(B . ?\x67D7);; 
     (?$(Ou\(B . ?\x67FC);; 
     (?$(Ou](B . ?\x6801);; 
     (?$(Ou^(B . ?\x6852);; 
     (?$(Ou_(B . ?\x681D);; 
     (?$(Ou`(B . ?\x682C);; 
     (?$(Oua(B . ?\x6831);; 
     (?$(Oub(B . ?\x685B);; 
     (?$(Ouc(B . ?\x6872);; 
     (?$(Oud(B . ?\x6875);; 
     ;;(?$(Oue(B . ?\x(fa44))  ;; 
     (?$(Ouf(B . ?\x68A3);; 
     (?$(Oug(B . ?\x68A5);; 
     (?$(Ouh(B . ?\x68B2);; 
     (?$(Oui(B . ?\x68C8);; 
     (?$(Ouj(B . ?\x68D0);; 
     (?$(Ouk(B . ?\x68E8);; 
     (?$(Oul(B . ?\x68ED);; 
     (?$(Oum(B . ?\x68F0);; 
     (?$(Oun(B . ?\x68F1);; 
     (?$(Ouo(B . ?\x68FC);; 
     (?$(Oup(B . ?\x690A);; 
     (?$(Ouq(B . ?\x6949);; 
     ;;(?$(Our(B . ?\x(ab04))  ;; 
     (?$(Ous(B . ?\x6935);; 
     (?$(Out(B . ?\x6942);; 
     (?$(Ouu(B . ?\x6957);; 
     (?$(Ouv(B . ?\x6963);; 
     (?$(Ouw(B . ?\x6964);; 
     (?$(Oux(B . ?\x6968);; 
     (?$(Ouy(B . ?\x6980);; 
     (?$(Ouz(B . ?\xFA14);; 
     (?$(Ou{(B . ?\x69A5);; 
     (?$(Ou|(B . ?\x69AD);; 
     (?$(Ou}(B . ?\x69CF);; 
     (?$(Ou~(B . ?\x3BB6);; 
     (?$(Ov!(B . ?\x3BC3);; 
     (?$(Ov"(B . ?\x69E2);; 
     (?$(Ov#(B . ?\x69E9);; 
     ;;(?$(Ov$(B . ?\x(fa45))  ;; 
     (?$(Ov%(B . ?\x69F5);; 
     (?$(Ov&(B . ?\x69F6);; 
     (?$(Ov'(B . ?\x6A0F);; 
     (?$(Ov((B . ?\x6A15);; 
     ;;(?$(Ov)(B . ?\x(ab0a))  ;; 
     (?$(Ov*(B . ?\x6A3B);; 
     (?$(Ov+(B . ?\x6A3E);; 
     (?$(Ov,(B . ?\x6A45);; 
     (?$(Ov-(B . ?\x6A50);; 
     (?$(Ov.(B . ?\x6A56);; 
     (?$(Ov/(B . ?\x6A5B);; 
     (?$(Ov0(B . ?\x6A6B);; 
     (?$(Ov1(B . ?\x6A73);; 
     ;;(?$(Ov2(B . ?\x(ab0c))  ;; 
     (?$(Ov3(B . ?\x6A89);; 
     (?$(Ov4(B . ?\x6A94);; 
     (?$(Ov5(B . ?\x6A9D);; 
     (?$(Ov6(B . ?\x6A9E);; 
     (?$(Ov7(B . ?\x6AA5);; 
     (?$(Ov8(B . ?\x6AE4);; 
     (?$(Ov9(B . ?\x6AE7);; 
     (?$(Ov:(B . ?\x3C0F);; 
     (?$(Ov;(B . ?\xF91D);; 
     (?$(Ov<(B . ?\x6B1B);; 
     (?$(Ov=(B . ?\x6B1E);; 
     (?$(Ov>(B . ?\x6B2C);; 
     (?$(Ov?(B . ?\x6B35);; 
     (?$(Ov@(B . ?\x6B46);; 
     (?$(OvA(B . ?\x6B56);; 
     (?$(OvB(B . ?\x6B60);; 
     (?$(OvC(B . ?\x6B65);; 
     (?$(OvD(B . ?\x6B67);; 
     (?$(OvE(B . ?\x6B77);; 
     (?$(OvF(B . ?\x6B82);; 
     (?$(OvG(B . ?\x6BA9);; 
     (?$(OvH(B . ?\x6BAD);; 
     (?$(OvI(B . ?\xF970);; 
     (?$(OvJ(B . ?\x6BCF);; 
     (?$(OvK(B . ?\x6BD6);; 
     (?$(OvL(B . ?\x6BD7);; 
     (?$(OvM(B . ?\x6BFF);; 
     (?$(OvN(B . ?\x6C05);; 
     (?$(OvO(B . ?\x6C10);; 
     (?$(OvP(B . ?\x6C33);; 
     (?$(OvQ(B . ?\x6C59);; 
     (?$(OvR(B . ?\x6C5C);; 
     (?$(OvS(B . ?\x6CAA);; 
     (?$(OvT(B . ?\x6C74);; 
     (?$(OvU(B . ?\x6C76);; 
     (?$(OvV(B . ?\x6C85);; 
     (?$(OvW(B . ?\x6C86);; 
     (?$(OvX(B . ?\x6C98);; 
     (?$(OvY(B . ?\x6C9C);; 
     (?$(OvZ(B . ?\x6CFB);; 
     (?$(Ov[(B . ?\x6CC6);; 
     (?$(Ov\(B . ?\x6CD4);; 
     (?$(Ov](B . ?\x6CE0);; 
     (?$(Ov^(B . ?\x6CEB);; 
     (?$(Ov_(B . ?\x6CEE);; 
     ;;;;(?$(Ov`(B . ?\x(ab15))  ;; 
     (?$(Ova(B . ?\x6D04);; 
     (?$(Ovb(B . ?\x6D0E);; 
     (?$(Ovc(B . ?\x6D2E);; 
     (?$(Ovd(B . ?\x6D31);; 
     (?$(Ove(B . ?\x6D39);; 
     (?$(Ovf(B . ?\x6D3F);; 
     (?$(Ovg(B . ?\x6D58);; 
     (?$(Ovh(B . ?\x6D65);; 
     ;;(?$(Ovi(B . ?\x(fa46))  ;; 
     (?$(Ovj(B . ?\x6D82);; 
     (?$(Ovk(B . ?\x6D87);; 
     (?$(Ovl(B . ?\x6D89);; 
     (?$(Ovm(B . ?\x6D94);; 
     (?$(Ovn(B . ?\x6DAA);; 
     (?$(Ovo(B . ?\x6DAC);; 
     (?$(Ovp(B . ?\x6DBF);; 
     (?$(Ovq(B . ?\x6DC4);; 
     (?$(Ovr(B . ?\x6DD6);; 
     (?$(Ovs(B . ?\x6DDA);; 
     (?$(Ovt(B . ?\x6DDB);; 
     (?$(Ovu(B . ?\x6DDD);; 
     (?$(Ovv(B . ?\x6DFC);; 
     ;;(?$(Ovw(B . ?\x(fa47))  ;; 
     (?$(Ovx(B . ?\x6E34);; 
     (?$(Ovy(B . ?\x6E44);; 
     (?$(Ovz(B . ?\x6E5C);; 
     (?$(Ov{(B . ?\x6E5E);; 
     (?$(Ov|(B . ?\x6EAB);; 
     (?$(Ov}(B . ?\x6EB1);; 
     (?$(Ov~(B . ?\x6EC1);; 
     (?$(Ow!(B . ?\x6EC7);; 
     (?$(Ow"(B . ?\x6ECE);; 
     (?$(Ow#(B . ?\x6F10);; 
     (?$(Ow$(B . ?\x6F1A);; 
     ;;(?$(Ow%(B . ?\x(fa48))  ;; 
     (?$(Ow&(B . ?\x6F2A);; 
     (?$(Ow'(B . ?\x6F2F);; 
     (?$(Ow((B . ?\x6F33);; 
     (?$(Ow)(B . ?\x6F51);; 
     (?$(Ow*(B . ?\x6F59);; 
     (?$(Ow+(B . ?\x6F5E);; 
     (?$(Ow,(B . ?\x6F61);; 
     (?$(Ow-(B . ?\x6F62);; 
     (?$(Ow.(B . ?\x6F7E);; 
     (?$(Ow/(B . ?\x6F88);; 
     (?$(Ow0(B . ?\x6F8C);; 
     (?$(Ow1(B . ?\x6F8D);; 
     (?$(Ow2(B . ?\x6F94);; 
     (?$(Ow3(B . ?\x6FA0);; 
     (?$(Ow4(B . ?\x6FA7);; 
     (?$(Ow5(B . ?\x6FB6);; 
     (?$(Ow6(B . ?\x6FBC);; 
     (?$(Ow7(B . ?\x6FC7);; 
     (?$(Ow8(B . ?\x6FCA);; 
     (?$(Ow9(B . ?\x6FF9);; 
     (?$(Ow:(B . ?\x6FF0);; 
     (?$(Ow;(B . ?\x6FF5);; 
     (?$(Ow<(B . ?\x7005);; 
     (?$(Ow=(B . ?\x7006);; 
     (?$(Ow>(B . ?\x7028);; 
     (?$(Ow?(B . ?\x704A);; 
     (?$(Ow@(B . ?\x705D);; 
     (?$(OwA(B . ?\x705E);; 
     (?$(OwB(B . ?\x704E);; 
     (?$(OwC(B . ?\x7064);; 
     (?$(OwD(B . ?\x7075);; 
     (?$(OwE(B . ?\x7085);; 
     (?$(OwF(B . ?\x70A4);; 
     (?$(OwG(B . ?\x70AB);; 
     (?$(OwH(B . ?\x70B7);; 
     (?$(OwI(B . ?\x70D4);; 
     (?$(OwJ(B . ?\x70D8);; 
     (?$(OwK(B . ?\x70E4);; 
     (?$(OwL(B . ?\x710F);; 
     (?$(OwM(B . ?\x712B);; 
     (?$(OwN(B . ?\x711E);; 
     (?$(OwO(B . ?\x7120);; 
     (?$(OwP(B . ?\x712E);; 
     (?$(OwQ(B . ?\x7130);; 
     (?$(OwR(B . ?\x7146);; 
     (?$(OwS(B . ?\x7147);; 
     (?$(OwT(B . ?\x7151);; 
     ;;(?$(OwU(B . ?\x(fa49))  ;; 
     (?$(OwV(B . ?\x7152);; 
     (?$(OwW(B . ?\x715C);; 
     (?$(OwX(B . ?\x7160);; 
     (?$(OwY(B . ?\x7168);; 
     (?$(OwZ(B . ?\xFA15);; 
     (?$(Ow[(B . ?\x7185);; 
     (?$(Ow\(B . ?\x7187);; 
     (?$(Ow](B . ?\x7192);; 
     (?$(Ow^(B . ?\x71C1);; 
     (?$(Ow_(B . ?\x71BA);; 
     (?$(Ow`(B . ?\x71C4);; 
     (?$(Owa(B . ?\x71FE);; 
     (?$(Owb(B . ?\x7200);; 
     (?$(Owc(B . ?\x7215);; 
     (?$(Owd(B . ?\x7255);; 
     (?$(Owe(B . ?\x7256);; 
     (?$(Owf(B . ?\x3E3F);; 
     (?$(Owg(B . ?\x728D);; 
     (?$(Owh(B . ?\x729B);; 
     (?$(Owi(B . ?\x72BE);; 
     (?$(Owj(B . ?\x72C0);; 
     (?$(Owk(B . ?\x72FB);; 
     ;;(?$(Owl(B . ?\x(ab24))  ;; 
     (?$(Owm(B . ?\x7327);; 
     (?$(Own(B . ?\x7328);; 
     (?$(Owo(B . ?\xFA16);; 
     (?$(Owp(B . ?\x7350);; 
     (?$(Owq(B . ?\x7366);; 
     (?$(Owr(B . ?\x737C);; 
     (?$(Ows(B . ?\x7395);; 
     (?$(Owt(B . ?\x739F);; 
     (?$(Owu(B . ?\x73A0);; 
     (?$(Owv(B . ?\x73A2);; 
     (?$(Oww(B . ?\x73A6);; 
     (?$(Owx(B . ?\x73AB);; 
     (?$(Owy(B . ?\x73C9);; 
     (?$(Owz(B . ?\x73CF);; 
     (?$(Ow{(B . ?\x73D6);; 
     (?$(Ow|(B . ?\x73D9);; 
     (?$(Ow}(B . ?\x73E3);; 
     (?$(Ow~(B . ?\x73E9);; 
     (?$(Ox!(B . ?\x7407);; 
     (?$(Ox"(B . ?\x740A);; 
     (?$(Ox#(B . ?\x741A);; 
     (?$(Ox$(B . ?\x741B);; 
     ;;(?$(Ox%(B . ?\x(fa4a))  ;; 
     (?$(Ox&(B . ?\x7426);; 
     (?$(Ox'(B . ?\x7428);; 
     (?$(Ox((B . ?\x742A);; 
     (?$(Ox)(B . ?\x742B);; 
     (?$(Ox*(B . ?\x742C);; 
     (?$(Ox+(B . ?\x742E);; 
     (?$(Ox,(B . ?\x742F);; 
     (?$(Ox-(B . ?\x7430);; 
     (?$(Ox.(B . ?\x7444);; 
     (?$(Ox/(B . ?\x7446);; 
     (?$(Ox0(B . ?\x7447);; 
     (?$(Ox1(B . ?\x744B);; 
     (?$(Ox2(B . ?\x7457);; 
     (?$(Ox3(B . ?\x7462);; 
     (?$(Ox4(B . ?\x746B);; 
     (?$(Ox5(B . ?\x746D);; 
     (?$(Ox6(B . ?\x7486);; 
     (?$(Ox7(B . ?\x7487);; 
     (?$(Ox8(B . ?\x7489);; 
     (?$(Ox9(B . ?\x7498);; 
     (?$(Ox:(B . ?\x749C);; 
     (?$(Ox;(B . ?\x749F);; 
     (?$(Ox<(B . ?\x74A3);; 
     (?$(Ox=(B . ?\x7490);; 
     (?$(Ox>(B . ?\x74A6);; 
     (?$(Ox?(B . ?\x74A8);; 
     (?$(Ox@(B . ?\x74A9);; 
     (?$(OxA(B . ?\x74B5);; 
     (?$(OxB(B . ?\x74BF);; 
     (?$(OxC(B . ?\x74C8);; 
     (?$(OxD(B . ?\x74C9);; 
     (?$(OxE(B . ?\x74DA);; 
     (?$(OxF(B . ?\x74FF);; 
     (?$(OxG(B . ?\x7501);; 
     (?$(OxH(B . ?\x7517);; 
     (?$(OxI(B . ?\x752F);; 
     (?$(OxJ(B . ?\x756F);; 
     (?$(OxK(B . ?\x7579);; 
     (?$(OxL(B . ?\x7592);; 
     (?$(OxM(B . ?\x3F72);; 
     (?$(OxN(B . ?\x75CE);; 
     (?$(OxO(B . ?\x75E4);; 
     (?$(OxP(B . ?\x7600);; 
     (?$(OxQ(B . ?\x7602);; 
     (?$(OxR(B . ?\x7608);; 
     (?$(OxS(B . ?\x7615);; 
     (?$(OxT(B . ?\x7616);; 
     (?$(OxU(B . ?\x7619);; 
     (?$(OxV(B . ?\x761E);; 
     (?$(OxW(B . ?\x762D);; 
     (?$(OxX(B . ?\x7635);; 
     (?$(OxY(B . ?\x7643);; 
     (?$(OxZ(B . ?\x764B);; 
     (?$(Ox[(B . ?\x7664);; 
     (?$(Ox\(B . ?\x7665);; 
     (?$(Ox](B . ?\x766D);; 
     (?$(Ox^(B . ?\x766F);; 
     (?$(Ox_(B . ?\x7671);; 
     (?$(Ox`(B . ?\x7681);; 
     (?$(Oxa(B . ?\x769B);; 
     (?$(Oxb(B . ?\x769D);; 
     (?$(Oxc(B . ?\x769E);; 
     (?$(Oxd(B . ?\x76A6);; 
     (?$(Oxe(B . ?\x76AA);; 
     (?$(Oxf(B . ?\x76B6);; 
     (?$(Oxg(B . ?\x76C5);; 
     (?$(Oxh(B . ?\x76CC);; 
     (?$(Oxi(B . ?\x76CE);; 
     (?$(Oxj(B . ?\x76D4);; 
     (?$(Oxk(B . ?\x76E6);; 
     (?$(Oxl(B . ?\x76F1);; 
     (?$(Oxm(B . ?\x76FC);; 
     (?$(Oxn(B . ?\x770A);; 
     (?$(Oxo(B . ?\x7719);; 
     (?$(Oxp(B . ?\x7734);; 
     (?$(Oxq(B . ?\x7736);; 
     (?$(Oxr(B . ?\x7746);; 
     (?$(Oxs(B . ?\x774D);; 
     (?$(Oxt(B . ?\x774E);; 
     (?$(Oxu(B . ?\x775C);; 
     (?$(Oxv(B . ?\x775F);; 
     (?$(Oxw(B . ?\x7762);; 
     (?$(Oxx(B . ?\x777A);; 
     (?$(Oxy(B . ?\x7780);; 
     (?$(Oxz(B . ?\x7794);; 
     (?$(Ox{(B . ?\x77AA);; 
     (?$(Ox|(B . ?\x77E0);; 
     (?$(Ox}(B . ?\x782D);; 
     ;;(?$(Ox~(B . ?\x(ab38))  ;; 
     (?$(Oy!(B . ?\x7843);; 
     (?$(Oy"(B . ?\x784E);; 
     (?$(Oy#(B . ?\x784F);; 
     (?$(Oy$(B . ?\x7851);; 
     (?$(Oy%(B . ?\x7868);; 
     (?$(Oy&(B . ?\x786E);; 
     ;;(?$(Oy'(B . ?\x(fa4b))  ;; 
     (?$(Oy((B . ?\x78B0);; 
     ;;(?$(Oy)(B . ?\x(ab3a))  ;; 
     (?$(Oy*(B . ?\x78AD);; 
     (?$(Oy+(B . ?\x78E4);; 
     (?$(Oy,(B . ?\x78F2);; 
     (?$(Oy-(B . ?\x7900);; 
     (?$(Oy.(B . ?\x78F7);; 
     (?$(Oy/(B . ?\x791C);; 
     (?$(Oy0(B . ?\x792E);; 
     (?$(Oy1(B . ?\x7931);; 
     (?$(Oy2(B . ?\x7934);; 
     ;;(?$(Oy3(B . ?\x(fa4c))  ;; 
     ;;(?$(Oy4(B . ?\x(fa4d))  ;; 
     (?$(Oy5(B . ?\x7945);; 
     (?$(Oy6(B . ?\x7946);; 
     ;;(?$(Oy7(B . ?\x(fa4e))  ;; 
     ;;(?$(Oy8(B . ?\x(fa4f))  ;; 
     ;;(?$(Oy9(B . ?\x(fa50))  ;; 
     (?$(Oy:(B . ?\x795C);; 
     ;;(?$(Oy;(B . ?\x(fa51))  ;; 
     (?$(Oy<(B . ?\xFA19);; 
     (?$(Oy=(B . ?\xFA1A);; 
     (?$(Oy>(B . ?\x7979);; 
     ;;(?$(Oy?(B . ?\x(fa52))  ;; 
     ;;(?$(Oy@(B . ?\x(fa53))  ;; 
     (?$(OyA(B . ?\xFA1B);; 
     (?$(OyB(B . ?\x7998);; 
     (?$(OyC(B . ?\x79B1);; 
     (?$(OyD(B . ?\x79B8);; 
     (?$(OyE(B . ?\x79C8);; 
     (?$(OyF(B . ?\x79CA);; 
     ;;(?$(OyG(B . ?\x(ab3c))  ;; 
     (?$(OyH(B . ?\x79D4);; 
     (?$(OyI(B . ?\x79DE);; 
     (?$(OyJ(B . ?\x79EB);; 
     (?$(OyK(B . ?\x79ED);; 
     (?$(OyL(B . ?\x7A03);; 
     ;;(?$(OyM(B . ?\x(fa54))  ;; 
     (?$(OyN(B . ?\x7A39);; 
     (?$(OyO(B . ?\x7A5D);; 
     (?$(OyP(B . ?\x7A6D);; 
     ;;(?$(OyQ(B . ?\x(fa55))  ;; 
     (?$(OyR(B . ?\x7A85);; 
     (?$(OyS(B . ?\x7AA0);; 
     ;;(?$(OyT(B . ?\x(ab3f))  ;; 
     (?$(OyU(B . ?\x7AB3);; 
     (?$(OyV(B . ?\x7ABB);; 
     (?$(OyW(B . ?\x7ACE);; 
     (?$(OyX(B . ?\x7AEB);; 
     (?$(OyY(B . ?\x7AFD);; 
     (?$(OyZ(B . ?\x7B12);; 
     (?$(Oy[(B . ?\x7B2D);; 
     (?$(Oy\(B . ?\x7B3B);; 
     (?$(Oy](B . ?\x7B47);; 
     (?$(Oy^(B . ?\x7B4E);; 
     (?$(Oy_(B . ?\x7B60);; 
     (?$(Oy`(B . ?\x7B6D);; 
     (?$(Oya(B . ?\x7B6F);; 
     (?$(Oyb(B . ?\x7B72);; 
     (?$(Oyc(B . ?\x7B9E);; 
     ;;(?$(Oyd(B . ?\x(fa56))  ;; 
     (?$(Oye(B . ?\x7BD7);; 
     (?$(Oyf(B . ?\x7BD9);; 
     (?$(Oyg(B . ?\x7C01);; 
     (?$(Oyh(B . ?\x7C31);; 
     (?$(Oyi(B . ?\x7C1E);; 
     (?$(Oyj(B . ?\x7C20);; 
     (?$(Oyk(B . ?\x7C33);; 
     (?$(Oyl(B . ?\x7C36);; 
     (?$(Oym(B . ?\x4264);; 
     ;;(?$(Oyn(B . ?\x(ab48))  ;; 
     (?$(Oyo(B . ?\x7C59);; 
     (?$(Oyp(B . ?\x7C6D);; 
     (?$(Oyq(B . ?\x7C79);; 
     (?$(Oyr(B . ?\x7C8F);; 
     (?$(Oys(B . ?\x7C94);; 
     (?$(Oyt(B . ?\x7CA0);; 
     (?$(Oyu(B . ?\x7CBC);; 
     (?$(Oyv(B . ?\x7CD5);; 
     (?$(Oyw(B . ?\x7CD9);; 
     (?$(Oyx(B . ?\x7CDD);; 
     (?$(Oyy(B . ?\x7D07);; 
     (?$(Oyz(B . ?\x7D08);; 
     (?$(Oy{(B . ?\x7D13);; 
     (?$(Oy|(B . ?\x7D1D);; 
     (?$(Oy}(B . ?\x7D23);; 
     (?$(Oy~(B . ?\x7D31);; 
     (?$(Oz!(B . ?\x7D41);; 
     (?$(Oz"(B . ?\x7D48);; 
     (?$(Oz#(B . ?\x7D53);; 
     (?$(Oz$(B . ?\x7D5C);; 
     (?$(Oz%(B . ?\x7D7A);; 
     (?$(Oz&(B . ?\x7D83);; 
     (?$(Oz'(B . ?\x7D8B);; 
     (?$(Oz((B . ?\x7DA0);; 
     (?$(Oz)(B . ?\x7DA6);; 
     (?$(Oz*(B . ?\x7DC2);; 
     (?$(Oz+(B . ?\x7DCC);; 
     (?$(Oz,(B . ?\x7DD6);; 
     (?$(Oz-(B . ?\x7DE3);; 
     ;;(?$(Oz.(B . ?\x(fa57))  ;; 
     (?$(Oz/(B . ?\x7E28);; 
     (?$(Oz0(B . ?\x7E08);; 
     (?$(Oz1(B . ?\x7E11);; 
     (?$(Oz2(B . ?\x7E15);; 
     ;;(?$(Oz3(B . ?\x(fa58))  ;; 
     (?$(Oz4(B . ?\x7E47);; 
     (?$(Oz5(B . ?\x7E52);; 
     (?$(Oz6(B . ?\x7E61);; 
     (?$(Oz7(B . ?\x7E8A);; 
     (?$(Oz8(B . ?\x7E8D);; 
     (?$(Oz9(B . ?\x7F47);; 
     ;;(?$(Oz:(B . ?\x(fa59))  ;; 
     (?$(Oz;(B . ?\x7F91);; 
     (?$(Oz<(B . ?\x7F97);; 
     (?$(Oz=(B . ?\x7FBF);; 
     (?$(Oz>(B . ?\x7FCE);; 
     (?$(Oz?(B . ?\x7FDB);; 
     (?$(Oz@(B . ?\x7FDF);; 
     (?$(OzA(B . ?\x7FEC);; 
     (?$(OzB(B . ?\x7FEE);; 
     (?$(OzC(B . ?\x7FFA);; 
     ;;(?$(OzD(B . ?\x(fa5a))  ;; 
     (?$(OzE(B . ?\x8014);; 
     (?$(OzF(B . ?\x8026);; 
     (?$(OzG(B . ?\x8035);; 
     (?$(OzH(B . ?\x8037);; 
     (?$(OzI(B . ?\x803C);; 
     (?$(OzJ(B . ?\x80CA);; 
     (?$(OzK(B . ?\x80D7);; 
     (?$(OzL(B . ?\x80E0);; 
     (?$(OzM(B . ?\x80F3);; 
     (?$(OzN(B . ?\x8118);; 
     (?$(OzO(B . ?\x814A);; 
     (?$(OzP(B . ?\x8160);; 
     (?$(OzQ(B . ?\x8167);; 
     (?$(OzR(B . ?\x8168);; 
     (?$(OzS(B . ?\x816D);; 
     (?$(OzT(B . ?\x81BB);; 
     (?$(OzU(B . ?\x81CA);; 
     (?$(OzV(B . ?\x81CF);; 
     (?$(OzW(B . ?\x81D7);; 
     ;;(?$(OzX(B . ?\x(fa5b))  ;; 
     (?$(OzY(B . ?\x4453);; 
     (?$(OzZ(B . ?\x445B);; 
     (?$(Oz[(B . ?\x8260);; 
     (?$(Oz\(B . ?\x8274);; 
     ;;(?$(Oz](B . ?\x(ab6e))  ;; 
     (?$(Oz^(B . ?\x828E);; 
     (?$(Oz_(B . ?\x82A1);; 
     (?$(Oz`(B . ?\x82A3);; 
     (?$(Oza(B . ?\x82A4);; 
     (?$(Ozb(B . ?\x82A9);; 
     (?$(Ozc(B . ?\x82AE);; 
     (?$(Ozd(B . ?\x82B7);; 
     (?$(Oze(B . ?\x82BE);; 
     (?$(Ozf(B . ?\x82BF);; 
     (?$(Ozg(B . ?\x82C6);; 
     (?$(Ozh(B . ?\x82D5);; 
     (?$(Ozi(B . ?\x82FD);; 
     (?$(Ozj(B . ?\x82FE);; 
     (?$(Ozk(B . ?\x8300);; 
     (?$(Ozl(B . ?\x8301);; 
     (?$(Ozm(B . ?\x8362);; 
     (?$(Ozn(B . ?\x8322);; 
     (?$(Ozo(B . ?\x832D);; 
     (?$(Ozp(B . ?\x833A);; 
     (?$(Ozq(B . ?\x8343);; 
     (?$(Ozr(B . ?\x8347);; 
     (?$(Ozs(B . ?\x8351);; 
     (?$(Ozt(B . ?\x8355);; 
     (?$(Ozu(B . ?\x837D);; 
     (?$(Ozv(B . ?\x8386);; 
     (?$(Ozw(B . ?\x8392);; 
     (?$(Ozx(B . ?\x8398);; 
     (?$(Ozy(B . ?\x83A7);; 
     (?$(Ozz(B . ?\x83A9);; 
     (?$(Oz{(B . ?\x83BF);; 
     (?$(Oz|(B . ?\x83C0);; 
     (?$(Oz}(B . ?\x83C7);; 
     (?$(Oz~(B . ?\x83CF);; 
     (?$(O{!(B . ?\x83D1);; 
     (?$(O{"(B . ?\x83E1);; 
     (?$(O{#(B . ?\x83EA);; 
     (?$(O{$(B . ?\x8401);; 
     (?$(O{%(B . ?\x8406);; 
     (?$(O{&(B . ?\x840A);; 
     ;;(?$(O{'(B . ?\x(fa5c))  ;; 
     (?$(O{((B . ?\x8448);; 
     (?$(O{)(B . ?\x845F);; 
     (?$(O{*(B . ?\x8470);; 
     (?$(O{+(B . ?\x8473);; 
     (?$(O{,(B . ?\x8485);; 
     (?$(O{-(B . ?\x849E);; 
     (?$(O{.(B . ?\x84AF);; 
     (?$(O{/(B . ?\x84B4);; 
     (?$(O{0(B . ?\x84BA);; 
     (?$(O{1(B . ?\x84C0);; 
     (?$(O{2(B . ?\x84C2);; 
     ;;(?$(O{3(B . ?\x(ab72))  ;; 
     (?$(O{4(B . ?\x8532);; 
     (?$(O{5(B . ?\x851E);; 
     (?$(O{6(B . ?\x8523);; 
     (?$(O{7(B . ?\x852F);; 
     (?$(O{8(B . ?\x8559);; 
     (?$(O{9(B . ?\x8564);; 
     (?$(O{:(B . ?\xFA1F);; 
     (?$(O{;(B . ?\x85AD);; 
     (?$(O{<(B . ?\x857A);; 
     (?$(O{=(B . ?\x858C);; 
     (?$(O{>(B . ?\x858F);; 
     (?$(O{?(B . ?\x85A2);; 
     (?$(O{@(B . ?\x85B0);; 
     (?$(O{A(B . ?\x85CB);; 
     (?$(O{B(B . ?\x85CE);; 
     (?$(O{C(B . ?\x85ED);; 
     (?$(O{D(B . ?\x8612);; 
     (?$(O{E(B . ?\x85FF);; 
     (?$(O{F(B . ?\x8604);; 
     (?$(O{G(B . ?\x8605);; 
     (?$(O{H(B . ?\x8610);; 
     ;;(?$(O{I(B . ?\x(ab78))  ;; 
     (?$(O{J(B . ?\x8618);; 
     (?$(O{K(B . ?\x8629);; 
     (?$(O{L(B . ?\x8638);; 
     (?$(O{M(B . ?\x8657);; 
     (?$(O{N(B . ?\x865B);; 
     (?$(O{O(B . ?\xF936);; 
     (?$(O{P(B . ?\x8662);; 
     (?$(O{Q(B . ?\x459D);; 
     (?$(O{R(B . ?\x866C);; 
     (?$(O{S(B . ?\x8675);; 
     (?$(O{T(B . ?\x8698);; 
     (?$(O{U(B . ?\x86B8);; 
     (?$(O{V(B . ?\x86FA);; 
     (?$(O{W(B . ?\x86FC);; 
     (?$(O{X(B . ?\x86FD);; 
     (?$(O{Y(B . ?\x870B);; 
     (?$(O{Z(B . ?\x8771);; 
     (?$(O{[(B . ?\x8787);; 
     (?$(O{\(B . ?\x8788);; 
     (?$(O{](B . ?\x87AC);; 
     (?$(O{^(B . ?\x87AD);; 
     (?$(O{_(B . ?\x87B5);; 
     (?$(O{`(B . ?\x45EA);; 
     (?$(O{a(B . ?\x87D6);; 
     (?$(O{b(B . ?\x87EC);; 
     (?$(O{c(B . ?\x8806);; 
     (?$(O{d(B . ?\x880A);; 
     (?$(O{e(B . ?\x8810);; 
     (?$(O{f(B . ?\x8814);; 
     (?$(O{g(B . ?\x881F);; 
     (?$(O{h(B . ?\x8898);; 
     (?$(O{i(B . ?\x88AA);; 
     (?$(O{j(B . ?\x88CA);; 
     (?$(O{k(B . ?\x88CE);; 
     ;;(?$(O{l(B . ?\x(ab83))  ;; 
     (?$(O{m(B . ?\x88F5);; 
     (?$(O{n(B . ?\x891C);; 
     ;;(?$(O{o(B . ?\x(fa5d))  ;; 
     (?$(O{p(B . ?\x8918);; 
     (?$(O{q(B . ?\x8919);; 
     (?$(O{r(B . ?\x891A);; 
     (?$(O{s(B . ?\x8927);; 
     (?$(O{t(B . ?\x8930);; 
     (?$(O{u(B . ?\x8932);; 
     (?$(O{v(B . ?\x8939);; 
     (?$(O{w(B . ?\x8940);; 
     (?$(O{x(B . ?\x8994);; 
     ;;(?$(O{y(B . ?\x(fa5e))  ;; 
     (?$(O{z(B . ?\x89D4);; 
     (?$(O{{(B . ?\x89E5);; 
     (?$(O{|(B . ?\x89F6);; 
     (?$(O{}(B . ?\x8A12);; 
     (?$(O{~(B . ?\x8A15);; 
     (?$(O|!(B . ?\x8A22);; 
     (?$(O|"(B . ?\x8A37);; 
     (?$(O|#(B . ?\x8A47);; 
     (?$(O|$(B . ?\x8A4E);; 
     (?$(O|%(B . ?\x8A5D);; 
     (?$(O|&(B . ?\x8A61);; 
     (?$(O|'(B . ?\x8A75);; 
     (?$(O|((B . ?\x8A79);; 
     (?$(O|)(B . ?\x8AA7);; 
     (?$(O|*(B . ?\x8AD0);; 
     (?$(O|+(B . ?\x8ADF);; 
     (?$(O|,(B . ?\x8AF4);; 
     (?$(O|-(B . ?\x8AF6);; 
     (?$(O|.(B . ?\xFA22);; 
     ;;(?$(O|/(B . ?\x(fa5f))  ;; 
     ;;(?$(O|0(B . ?\x(fa60))  ;; 
     (?$(O|1(B . ?\x8B46);; 
     (?$(O|2(B . ?\x8B54);; 
     (?$(O|3(B . ?\x8B59);; 
     (?$(O|4(B . ?\x8B69);; 
     (?$(O|5(B . ?\x8B9D);; 
     (?$(O|6(B . ?\x8C49);; 
     (?$(O|7(B . ?\x8C68);; 
     ;;(?$(O|8(B . ?\x(fa61))  ;; 
     (?$(O|9(B . ?\x8CE1);; 
     (?$(O|:(B . ?\x8CF4);; 
     (?$(O|;(B . ?\x8CF8);; 
     (?$(O|<(B . ?\x8CFE);; 
     ;;(?$(O|=(B . ?\x(fa62))  ;; 
     (?$(O|>(B . ?\x8D12);; 
     (?$(O|?(B . ?\x8D1B);; 
     (?$(O|@(B . ?\x8DAF);; 
     (?$(O|A(B . ?\x8DCE);; 
     (?$(O|B(B . ?\x8DD1);; 
     (?$(O|C(B . ?\x8DD7);; 
     (?$(O|D(B . ?\x8E20);; 
     (?$(O|E(B . ?\x8E23);; 
     (?$(O|F(B . ?\x8E3D);; 
     (?$(O|G(B . ?\x8E70);; 
     (?$(O|H(B . ?\x8E7B);; 
     ;;(?$(O|I(B . ?\x(ab94))  ;; 
     (?$(O|J(B . ?\x8EC0);; 
     (?$(O|K(B . ?\x4844);; 
     (?$(O|L(B . ?\x8EFA);; 
     (?$(O|M(B . ?\x8F1E);; 
     (?$(O|N(B . ?\x8F2D);; 
     (?$(O|O(B . ?\x8F36);; 
     (?$(O|P(B . ?\x8F54);; 
     ;;(?$(O|Q(B . ?\x(ab97))  ;; 
     (?$(O|R(B . ?\x8FA6);; 
     (?$(O|S(B . ?\x8FB5);; 
     (?$(O|T(B . ?\x8FE4);; 
     (?$(O|U(B . ?\x8FE8);; 
     (?$(O|V(B . ?\x8FEE);; 
     (?$(O|W(B . ?\x9008);; 
     (?$(O|X(B . ?\x902D);; 
     ;;(?$(O|Y(B . ?\x(fa63))  ;; 
     (?$(O|Z(B . ?\x9088);; 
     (?$(O|[(B . ?\x9095);; 
     (?$(O|\(B . ?\x9097);; 
     (?$(O|](B . ?\x9099);; 
     (?$(O|^(B . ?\x909B);; 
     (?$(O|_(B . ?\x90A2);; 
     (?$(O|`(B . ?\x90B3);; 
     (?$(O|a(B . ?\x90BE);; 
     (?$(O|b(B . ?\x90C4);; 
     (?$(O|c(B . ?\x90C5);; 
     (?$(O|d(B . ?\x90C7);; 
     (?$(O|e(B . ?\x90D7);; 
     (?$(O|f(B . ?\x90DD);; 
     (?$(O|g(B . ?\x90DE);; 
     (?$(O|h(B . ?\x90EF);; 
     (?$(O|i(B . ?\x90F4);; 
     (?$(O|j(B . ?\xFA26);; 
     (?$(O|k(B . ?\x9114);; 
     (?$(O|l(B . ?\x9115);; 
     (?$(O|m(B . ?\x9116);; 
     (?$(O|n(B . ?\x9122);; 
     (?$(O|o(B . ?\x9123);; 
     (?$(O|p(B . ?\x9127);; 
     (?$(O|q(B . ?\x912F);; 
     (?$(O|r(B . ?\x9131);; 
     (?$(O|s(B . ?\x9134);; 
     (?$(O|t(B . ?\x913D);; 
     (?$(O|u(B . ?\x9148);; 
     (?$(O|v(B . ?\x915B);; 
     (?$(O|w(B . ?\x9183);; 
     (?$(O|x(B . ?\x919E);; 
     (?$(O|y(B . ?\x91AC);; 
     (?$(O|z(B . ?\x91B1);; 
     (?$(O|{(B . ?\x91BC);; 
     (?$(O||(B . ?\x91D7);; 
     (?$(O|}(B . ?\x91FB);; 
     (?$(O|~(B . ?\x91E4);; 
     (?$(O}!(B . ?\x91E5);; 
     (?$(O}"(B . ?\x91ED);; 
     (?$(O}#(B . ?\x91F1);; 
     (?$(O}$(B . ?\x9207);; 
     (?$(O}%(B . ?\x9210);; 
     (?$(O}&(B . ?\x9238);; 
     (?$(O}'(B . ?\x9239);; 
     (?$(O}((B . ?\x923A);; 
     (?$(O})(B . ?\x923C);; 
     (?$(O}*(B . ?\x9240);; 
     (?$(O}+(B . ?\x9243);; 
     (?$(O},(B . ?\x924F);; 
     (?$(O}-(B . ?\x9278);; 
     (?$(O}.(B . ?\x9288);; 
     (?$(O}/(B . ?\x92C2);; 
     (?$(O}0(B . ?\x92CB);; 
     (?$(O}1(B . ?\x92CC);; 
     (?$(O}2(B . ?\x92D3);; 
     (?$(O}3(B . ?\x92E0);; 
     (?$(O}4(B . ?\x92FF);; 
     (?$(O}5(B . ?\x9304);; 
     (?$(O}6(B . ?\x931F);; 
     (?$(O}7(B . ?\x9321);; 
     (?$(O}8(B . ?\x9325);; 
     (?$(O}9(B . ?\x9348);; 
     (?$(O}:(B . ?\x9349);; 
     (?$(O};(B . ?\x934A);; 
     (?$(O}<(B . ?\x9364);; 
     (?$(O}=(B . ?\x9365);; 
     (?$(O}>(B . ?\x936A);; 
     (?$(O}?(B . ?\x9370);; 
     (?$(O}@(B . ?\x939B);; 
     (?$(O}A(B . ?\x93A3);; 
     (?$(O}B(B . ?\x93BA);; 
     (?$(O}C(B . ?\x93C6);; 
     (?$(O}D(B . ?\x93DE);; 
     (?$(O}E(B . ?\x93DF);; 
     (?$(O}F(B . ?\x9404);; 
     (?$(O}G(B . ?\x93FD);; 
     (?$(O}H(B . ?\x9433);; 
     (?$(O}I(B . ?\x944A);; 
     (?$(O}J(B . ?\x9463);; 
     (?$(O}K(B . ?\x946B);; 
     (?$(O}L(B . ?\x9471);; 
     (?$(O}M(B . ?\x9472);; 
     (?$(O}N(B . ?\x958E);; 
     (?$(O}O(B . ?\x959F);; 
     (?$(O}P(B . ?\x95A6);; 
     (?$(O}Q(B . ?\x95A9);; 
     (?$(O}R(B . ?\x95AC);; 
     (?$(O}S(B . ?\x95B6);; 
     (?$(O}T(B . ?\x95BD);; 
     (?$(O}U(B . ?\x95CB);; 
     (?$(O}V(B . ?\x95D0);; 
     (?$(O}W(B . ?\x95D3);; 
     (?$(O}X(B . ?\x49B0);; 
     (?$(O}Y(B . ?\x95DA);; 
     (?$(O}Z(B . ?\x95DE);; 
     (?$(O}[(B . ?\x9658);; 
     (?$(O}\(B . ?\x9684);; 
     (?$(O}](B . ?\xF9DC);; 
     (?$(O}^(B . ?\x969D);; 
     (?$(O}_(B . ?\x96A4);; 
     (?$(O}`(B . ?\x96A5);; 
     (?$(O}a(B . ?\x96D2);; 
     (?$(O}b(B . ?\x96DE);; 
     ;;(?$(O}c(B . ?\x(fa64))  ;; 
     (?$(O}d(B . ?\x96E9);; 
     (?$(O}e(B . ?\x96EF);; 
     (?$(O}f(B . ?\x9733);; 
     (?$(O}g(B . ?\x973B);; 
     (?$(O}h(B . ?\x974D);; 
     (?$(O}i(B . ?\x974E);; 
     (?$(O}j(B . ?\x974F);; 
     (?$(O}k(B . ?\x975A);; 
     (?$(O}l(B . ?\x976E);; 
     (?$(O}m(B . ?\x9773);; 
     (?$(O}n(B . ?\x9795);; 
     (?$(O}o(B . ?\x97AE);; 
     (?$(O}p(B . ?\x97BA);; 
     (?$(O}q(B . ?\x97C1);; 
     (?$(O}r(B . ?\x97C9);; 
     (?$(O}s(B . ?\x97DE);; 
     (?$(O}t(B . ?\x97DB);; 
     (?$(O}u(B . ?\x97F4);; 
     ;;(?$(O}v(B . ?\x(fa65))  ;; 
     (?$(O}w(B . ?\x980A);; 
     (?$(O}x(B . ?\x981E);; 
     (?$(O}y(B . ?\x982B);; 
     (?$(O}z(B . ?\x9830);; 
     ;;(?$(O}{(B . ?\x(fa66))  ;; 
     (?$(O}|(B . ?\x9852);; 
     (?$(O}}(B . ?\x9853);; 
     (?$(O}~(B . ?\x9856);; 
     (?$(O~!(B . ?\x9857);; 
     (?$(O~"(B . ?\x9859);; 
     (?$(O~#(B . ?\x985A);; 
     (?$(O~$(B . ?\xF9D0);; 
     (?$(O~%(B . ?\x9865);; 
     (?$(O~&(B . ?\x986C);; 
     (?$(O~'(B . ?\x98BA);; 
     (?$(O~((B . ?\x98C8);; 
     (?$(O~)(B . ?\x98E7);; 
     (?$(O~*(B . ?\x9958);; 
     (?$(O~+(B . ?\x999E);; 
     (?$(O~,(B . ?\x9A02);; 
     (?$(O~-(B . ?\x9A03);; 
     (?$(O~.(B . ?\x9A24);; 
     (?$(O~/(B . ?\x9A2D);; 
     (?$(O~0(B . ?\x9A2E);; 
     (?$(O~1(B . ?\x9A38);; 
     (?$(O~2(B . ?\x9A4A);; 
     (?$(O~3(B . ?\x9A4E);; 
     (?$(O~4(B . ?\x9A52);; 
     (?$(O~5(B . ?\x9AB6);; 
     (?$(O~6(B . ?\x9AC1);; 
     (?$(O~7(B . ?\x9AC3);; 
     (?$(O~8(B . ?\x9ACE);; 
     (?$(O~9(B . ?\x9AD6);; 
     (?$(O~:(B . ?\x9AF9);; 
     (?$(O~;(B . ?\x9B02);; 
     (?$(O~<(B . ?\x9B08);; 
     (?$(O~=(B . ?\x9B20);; 
     (?$(O~>(B . ?\x4C17);; 
     ;;(?$(O~?(B . ?\x(fa67))  ;; 
     (?$(O~@(B . ?\x9B5E);; 
     (?$(O~A(B . ?\x9B79);; 
     (?$(O~B(B . ?\x9B66);; 
     (?$(O~C(B . ?\x9B72);; 
     (?$(O~D(B . ?\x9B75);; 
     (?$(O~E(B . ?\x9B84);; 
     (?$(O~F(B . ?\x9B8A);; 
     (?$(O~G(B . ?\x9B8F);; 
     (?$(O~H(B . ?\x9B9E);; 
     (?$(O~I(B . ?\x9BA7);; 
     (?$(O~J(B . ?\x9BC1);; 
     (?$(O~K(B . ?\x9BCE);; 
     (?$(O~L(B . ?\x9BE5);; 
     (?$(O~M(B . ?\x9BF8);; 
     (?$(O~N(B . ?\x9BFD);; 
     (?$(O~O(B . ?\x9C00);; 
     (?$(O~P(B . ?\x9C23);; 
     (?$(O~Q(B . ?\x9C41);; 
     (?$(O~R(B . ?\x9C4F);; 
     (?$(O~S(B . ?\x9C50);; 
     (?$(O~T(B . ?\x9C53);; 
     (?$(O~U(B . ?\x9C63);; 
     (?$(O~V(B . ?\x9C65);; 
     (?$(O~W(B . ?\x9C77);; 
     (?$(O~X(B . ?\x9D1D);; 
     (?$(O~Y(B . ?\x9D1E);; 
     (?$(O~Z(B . ?\x9D43);; 
     (?$(O~[(B . ?\x9D47);; 
     (?$(O~\(B . ?\x9D52);; 
     (?$(O~](B . ?\x9D63);; 
     (?$(O~^(B . ?\x9D70);; 
     (?$(O~_(B . ?\x9D7C);; 
     (?$(O~`(B . ?\x9D8A);; 
     (?$(O~a(B . ?\x9D96);; 
     (?$(O~b(B . ?\x9DC0);; 
     (?$(O~c(B . ?\x9DAC);; 
     (?$(O~d(B . ?\x9DBC);; 
     (?$(O~e(B . ?\x9DD7);; 
     ;;(?$(O~f(B . ?\x(abd1))  ;; 
     (?$(O~g(B . ?\x9DE7);; 
     (?$(O~h(B . ?\x9E07);; 
     (?$(O~i(B . ?\x9E15);; 
     (?$(O~j(B . ?\x9E7C);; 
     (?$(O~k(B . ?\x9E9E);; 
     (?$(O~l(B . ?\x9EA4);; 
     (?$(O~m(B . ?\x9EAC);; 
     (?$(O~n(B . ?\x9EAF);; 
     (?$(O~o(B . ?\x9EB4);; 
     (?$(O~p(B . ?\x9EB5);; 
     (?$(O~q(B . ?\x9EC3);; 
     (?$(O~r(B . ?\x9ED1);; 
     (?$(O~s(B . ?\x9F10);; 
     (?$(O~t(B . ?\x9F39);; 
     (?$(O~u(B . ?\x9F57);; 
     (?$(O~v(B . ?\x9F90);; 
     (?$(O~w(B . ?\x9F94);; 
     (?$(O~x(B . ?\x9F97);; 
     (?$(O~y(B . ?\x9FA2);;
     )))

(defvar
  jis-x-0213-2000-2-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(P!"(B . ?\x4E02);; 
     (?$(P!#(B . ?\x4E0F);; 
     (?$(P!$(B . ?\x4E12);; 
     (?$(P!%(B . ?\x4E29);; 
     (?$(P!&(B . ?\x4E2B);; 
     (?$(P!'(B . ?\x4E2E);; 
     (?$(P!((B . ?\x4E40);; 
     (?$(P!)(B . ?\x4E47);; 
     (?$(P!*(B . ?\x4E48);; 
     ;;(?$(P!+(B . ?\x(aaa2))  ;; 
     (?$(P!,(B . ?\x4E51);; 
     ;;(?$(P!-(B . ?\x(aaa3))  ;; 
     ;;(?$(P!.(B . ?\x(aaa4))  ;; 
     (?$(P!/(B . ?\x4E5A);; 
     (?$(P!0(B . ?\x4E69);; 
     (?$(P!1(B . ?\x4E9D);; 
     (?$(P!2(B . ?\x342C);; 
     (?$(P!3(B . ?\x342E);; 
     (?$(P!4(B . ?\x4EB9);; 
     (?$(P!5(B . ?\x4EBB);; 
     ;;(?$(P!6(B . ?\x(aaa5))  ;; 
     (?$(P!7(B . ?\x4EBC);; 
     (?$(P!8(B . ?\x4EC3);; 
     (?$(P!9(B . ?\x4EC8);; 
     (?$(P!:(B . ?\x4ED0);; 
     (?$(P!;(B . ?\x4EEB);; 
     (?$(P!<(B . ?\x4EDA);; 
     (?$(P!=(B . ?\x4EF1);; 
     (?$(P!>(B . ?\x4EF5);; 
     (?$(P!?(B . ?\x4F00);; 
     (?$(P!@(B . ?\x4F16);; 
     (?$(P!A(B . ?\x4F64);; 
     (?$(P!B(B . ?\x4F37);; 
     (?$(P!C(B . ?\x4F3E);; 
     (?$(P!D(B . ?\x4F54);; 
     (?$(P!E(B . ?\x4F58);; 
     ;;(?$(P!F(B . ?\x(aaa6))  ;; 
     (?$(P!G(B . ?\x4F77);; 
     (?$(P!H(B . ?\x4F78);; 
     (?$(P!I(B . ?\x4F7A);; 
     (?$(P!J(B . ?\x4F7D);; 
     (?$(P!K(B . ?\x4F82);; 
     (?$(P!L(B . ?\x4F85);; 
     (?$(P!M(B . ?\x4F92);; 
     (?$(P!N(B . ?\x4F9A);; 
     (?$(P!O(B . ?\x4FE6);; 
     (?$(P!P(B . ?\x4FB2);; 
     (?$(P!Q(B . ?\x4FBE);; 
     (?$(P!R(B . ?\x4FC5);; 
     (?$(P!S(B . ?\x4FCB);; 
     (?$(P!T(B . ?\x4FCF);; 
     (?$(P!U(B . ?\x4FD2);; 
     (?$(P!V(B . ?\x346A);; 
     (?$(P!W(B . ?\x4FF2);; 
     (?$(P!X(B . ?\x5000);; 
     (?$(P!Y(B . ?\x5010);; 
     (?$(P!Z(B . ?\x5013);; 
     (?$(P![(B . ?\x501C);; 
     (?$(P!\(B . ?\x501E);; 
     (?$(P!](B . ?\x5022);; 
     (?$(P!^(B . ?\x3468);; 
     (?$(P!_(B . ?\x5042);; 
     (?$(P!`(B . ?\x5046);; 
     (?$(P!a(B . ?\x504E);; 
     (?$(P!b(B . ?\x5053);; 
     (?$(P!c(B . ?\x5057);; 
     (?$(P!d(B . ?\x5063);; 
     (?$(P!e(B . ?\x5066);; 
     (?$(P!f(B . ?\x506A);; 
     (?$(P!g(B . ?\x5070);; 
     (?$(P!h(B . ?\x50A3);; 
     (?$(P!i(B . ?\x5088);; 
     (?$(P!j(B . ?\x5092);; 
     (?$(P!k(B . ?\x5093);; 
     (?$(P!l(B . ?\x5095);; 
     (?$(P!m(B . ?\x5096);; 
     (?$(P!n(B . ?\x509C);; 
     (?$(P!o(B . ?\x50AA);; 
     ;;(?$(P!p(B . ?\x(aaa7))  ;; 
     (?$(P!q(B . ?\x50B1);; 
     (?$(P!r(B . ?\x50BA);; 
     (?$(P!s(B . ?\x50BB);; 
     (?$(P!t(B . ?\x50C4);; 
     (?$(P!u(B . ?\x50C7);; 
     (?$(P!v(B . ?\x50F3);; 
     ;;(?$(P!w(B . ?\x(aaa8))  ;; 
     (?$(P!x(B . ?\x50CE);; 
     ;;(?$(P!y(B . ?\x(aaa9))  ;; 
     (?$(P!z(B . ?\x50D4);; 
     (?$(P!{(B . ?\x50D9);; 
     (?$(P!|(B . ?\x50E1);; 
     (?$(P!}(B . ?\x50E9);; 
     (?$(P!~(B . ?\x3492);; 
     (?$(P#!(B . ?\x5108);; 
     ;;(?$(P#"(B . ?\x(aaaa))  ;; 
     (?$(P##(B . ?\x5117);; 
     (?$(P#$(B . ?\x511B);; 
     ;;(?$(P#%(B . ?\x(aaab))  ;; 
     (?$(P#&(B . ?\x5160);; 
     ;;(?$(P#'(B . ?\x(aaac))  ;; 
     (?$(P#((B . ?\x5173);; 
     (?$(P#)(B . ?\x5183);; 
     (?$(P#*(B . ?\x518B);; 
     (?$(P#+(B . ?\x34BC);; 
     (?$(P#,(B . ?\x5198);; 
     (?$(P#-(B . ?\x51A3);; 
     (?$(P#.(B . ?\x51AD);; 
     (?$(P#/(B . ?\x34C7);; 
     (?$(P#0(B . ?\x51BC);; 
     ;;(?$(P#1(B . ?\x(aaad))  ;; 
     ;;(?$(P#2(B . ?\x(aaae))  ;; 
     (?$(P#3(B . ?\x51F3);; 
     (?$(P#4(B . ?\x51F4);; 
     (?$(P#5(B . ?\x5202);; 
     (?$(P#6(B . ?\x5212);; 
     (?$(P#7(B . ?\x5216);; 
     ;;(?$(P#8(B . ?\x(aaaf))  ;; 
     (?$(P#9(B . ?\x5255);; 
     (?$(P#:(B . ?\x525C);; 
     (?$(P#;(B . ?\x526C);; 
     (?$(P#<(B . ?\x5277);; 
     (?$(P#=(B . ?\x5284);; 
     (?$(P#>(B . ?\x5282);; 
     ;;(?$(P#?(B . ?\x(aab0))  ;; 
     (?$(P#@(B . ?\x5298);; 
     ;;(?$(P#A(B . ?\x(aab1))  ;; 
     (?$(P#B(B . ?\x52A4);; 
     (?$(P#C(B . ?\x52A6);; 
     (?$(P#D(B . ?\x52AF);; 
     (?$(P#E(B . ?\x52BA);; 
     (?$(P#F(B . ?\x52BB);; 
     (?$(P#G(B . ?\x52CA);; 
     (?$(P#H(B . ?\x351F);; 
     (?$(P#I(B . ?\x52D1);; 
     ;;(?$(P#J(B . ?\x(aab2))  ;; 
     (?$(P#K(B . ?\x52F7);; 
     (?$(P#L(B . ?\x530A);; 
     (?$(P#M(B . ?\x530B);; 
     (?$(P#N(B . ?\x5324);; 
     (?$(P#O(B . ?\x5335);; 
     (?$(P#P(B . ?\x533E);; 
     (?$(P#Q(B . ?\x5342);; 
     ;;(?$(P#R(B . ?\x(aab3))  ;; 
     ;;(?$(P#S(B . ?\x(aab4))  ;; 
     (?$(P#T(B . ?\x5367);; 
     (?$(P#U(B . ?\x536C);; 
     (?$(P#V(B . ?\x537A);; 
     (?$(P#W(B . ?\x53A4);; 
     (?$(P#X(B . ?\x53B4);; 
     ;;(?$(P#Y(B . ?\x(aab5))  ;; 
     (?$(P#Z(B . ?\x53B7);; 
     (?$(P#[(B . ?\x53C0);; 
     ;;(?$(P#\(B . ?\x(aab6))  ;; 
     (?$(P#](B . ?\x355D);; 
     (?$(P#^(B . ?\x355E);; 
     (?$(P#_(B . ?\x53D5);; 
     (?$(P#`(B . ?\x53DA);; 
     (?$(P#a(B . ?\x3563);; 
     (?$(P#b(B . ?\x53F4);; 
     (?$(P#c(B . ?\x53F5);; 
     (?$(P#d(B . ?\x5455);; 
     (?$(P#e(B . ?\x5424);; 
     (?$(P#f(B . ?\x5428);; 
     (?$(P#g(B . ?\x356E);; 
     (?$(P#h(B . ?\x5443);; 
     (?$(P#i(B . ?\x5462);; 
     (?$(P#j(B . ?\x5466);; 
     (?$(P#k(B . ?\x546C);; 
     (?$(P#l(B . ?\x548A);; 
     (?$(P#m(B . ?\x548D);; 
     (?$(P#n(B . ?\x5495);; 
     (?$(P#o(B . ?\x54A0);; 
     (?$(P#p(B . ?\x54A6);; 
     (?$(P#q(B . ?\x54AD);; 
     (?$(P#r(B . ?\x54AE);; 
     (?$(P#s(B . ?\x54B7);; 
     (?$(P#t(B . ?\x54BA);; 
     (?$(P#u(B . ?\x54BF);; 
     (?$(P#v(B . ?\x54C3);; 
     ;;(?$(P#w(B . ?\x(aab7))  ;; 
     (?$(P#x(B . ?\x54EC);; 
     (?$(P#y(B . ?\x54EF);; 
     (?$(P#z(B . ?\x54F1);; 
     (?$(P#{(B . ?\x54F3);; 
     (?$(P#|(B . ?\x5500);; 
     (?$(P#}(B . ?\x5501);; 
     (?$(P#~(B . ?\x5509);; 
     (?$(P$!(B . ?\x553C);; 
     (?$(P$"(B . ?\x5541);; 
     (?$(P$#(B . ?\x35A6);; 
     (?$(P$$(B . ?\x5547);; 
     (?$(P$%(B . ?\x554A);; 
     (?$(P$&(B . ?\x35A8);; 
     (?$(P$'(B . ?\x5560);; 
     (?$(P$((B . ?\x5561);; 
     (?$(P$)(B . ?\x5564);; 
     ;;(?$(P$*(B . ?\x(aab8))  ;; 
     (?$(P$+(B . ?\x557D);; 
     (?$(P$,(B . ?\x5582);; 
     (?$(P$-(B . ?\x5588);; 
     (?$(P$.(B . ?\x5591);; 
     (?$(P$/(B . ?\x35C5);; 
     (?$(P$0(B . ?\x55D2);; 
     ;;(?$(P$1(B . ?\x(aab9))  ;; 
     ;;(?$(P$2(B . ?\x(aaba))  ;; 
     (?$(P$3(B . ?\x55BF);; 
     (?$(P$4(B . ?\x55C9);; 
     (?$(P$5(B . ?\x55CC);; 
     (?$(P$6(B . ?\x55D1);; 
     (?$(P$7(B . ?\x55DD);; 
     (?$(P$8(B . ?\x35DA);; 
     (?$(P$9(B . ?\x55E2);; 
     ;;(?$(P$:(B . ?\x(aabb))  ;; 
     (?$(P$;(B . ?\x55E9);; 
     (?$(P$<(B . ?\x5628);; 
     ;;(?$(P$=(B . ?\x(aabc))  ;; 
     (?$(P$>(B . ?\x5607);; 
     (?$(P$?(B . ?\x5610);; 
     (?$(P$@(B . ?\x5630);; 
     (?$(P$A(B . ?\x5637);; 
     (?$(P$B(B . ?\x35F4);; 
     (?$(P$C(B . ?\x563D);; 
     (?$(P$D(B . ?\x563F);; 
     (?$(P$E(B . ?\x5640);; 
     (?$(P$F(B . ?\x5647);; 
     (?$(P$G(B . ?\x565E);; 
     (?$(P$H(B . ?\x5660);; 
     (?$(P$I(B . ?\x566D);; 
     (?$(P$J(B . ?\x3605);; 
     (?$(P$K(B . ?\x5688);; 
     (?$(P$L(B . ?\x568C);; 
     (?$(P$M(B . ?\x5695);; 
     (?$(P$N(B . ?\x569A);; 
     (?$(P$O(B . ?\x569D);; 
     (?$(P$P(B . ?\x56A8);; 
     (?$(P$Q(B . ?\x56AD);; 
     (?$(P$R(B . ?\x56B2);; 
     (?$(P$S(B . ?\x56C5);; 
     (?$(P$T(B . ?\x56CD);; 
     (?$(P$U(B . ?\x56DF);; 
     (?$(P$V(B . ?\x56E8);; 
     (?$(P$W(B . ?\x56F6);; 
     (?$(P$X(B . ?\x56F7);; 
     ;;(?$(P$Y(B . ?\x(aabd))  ;; 
     (?$(P$Z(B . ?\x5715);; 
     (?$(P$[(B . ?\x5723);; 
     ;;(?$(P$\(B . ?\x(aabf))  ;; 
     (?$(P$](B . ?\x5729);; 
     ;;(?$(P$^(B . ?\x(aac0))  ;; 
     (?$(P$_(B . ?\x5745);; 
     (?$(P$`(B . ?\x5746);; 
     (?$(P$a(B . ?\x574C);; 
     (?$(P$b(B . ?\x574D);; 
     ;;(?$(P$c(B . ?\x(aac1))  ;; 
     (?$(P$d(B . ?\x5768);; 
     (?$(P$e(B . ?\x576F);; 
     (?$(P$f(B . ?\x5773);; 
     (?$(P$g(B . ?\x5774);; 
     (?$(P$h(B . ?\x5775);; 
     (?$(P$i(B . ?\x577B);; 
     ;;(?$(P$j(B . ?\x(aac2))  ;; 
     ;;(?$(P$k(B . ?\x(aac3))  ;; 
     (?$(P$l(B . ?\x57AC);; 
     (?$(P$m(B . ?\x579A);; 
     (?$(P$n(B . ?\x579D);; 
     (?$(P$o(B . ?\x579E);; 
     (?$(P$p(B . ?\x57A8);; 
     (?$(P$q(B . ?\x57D7);; 
     ;;(?$(P$r(B . ?\x(aac5))  ;; 
     (?$(P$s(B . ?\x57CC);; 
     ;;(?$(P$t(B . ?\x(aac6))  ;; 
     ;;(?$(P$u(B . ?\x(aac7))  ;; 
     (?$(P$v(B . ?\x57DE);; 
     (?$(P$w(B . ?\x57E6);; 
     (?$(P$x(B . ?\x57F0);; 
     (?$(P$y(B . ?\x364A);; 
     (?$(P$z(B . ?\x57F8);; 
     (?$(P${(B . ?\x57FB);; 
     (?$(P$|(B . ?\x57FD);; 
     (?$(P$}(B . ?\x5804);; 
     (?$(P$~(B . ?\x581E);; 
     (?$(P%!(B . ?\x5820);; 
     (?$(P%"(B . ?\x5827);; 
     (?$(P%#(B . ?\x5832);; 
     (?$(P%$(B . ?\x5839);; 
     ;;(?$(P%%(B . ?\x(aac8))  ;; 
     (?$(P%&(B . ?\x5849);; 
     (?$(P%'(B . ?\x584C);; 
     (?$(P%((B . ?\x5867);; 
     (?$(P%)(B . ?\x588A);; 
     (?$(P%*(B . ?\x588B);; 
     (?$(P%+(B . ?\x588D);; 
     (?$(P%,(B . ?\x588F);; 
     (?$(P%-(B . ?\x5890);; 
     (?$(P%.(B . ?\x5894);; 
     (?$(P%/(B . ?\x589D);; 
     (?$(P%0(B . ?\x58AA);; 
     (?$(P%1(B . ?\x58B1);; 
     ;;(?$(P%2(B . ?\x(aaca))  ;; 
     (?$(P%3(B . ?\x58C3);; 
     (?$(P%4(B . ?\x58CD);; 
     (?$(P%5(B . ?\x58E2);; 
     (?$(P%6(B . ?\x58F3);; 
     (?$(P%7(B . ?\x58F4);; 
     (?$(P%8(B . ?\x5905);; 
     (?$(P%9(B . ?\x5906);; 
     (?$(P%:(B . ?\x590B);; 
     (?$(P%;(B . ?\x590D);; 
     (?$(P%<(B . ?\x5914);; 
     (?$(P%=(B . ?\x5924);; 
     ;;(?$(P%>(B . ?\x(aacb))  ;; 
     (?$(P%?(B . ?\x3691);; 
     (?$(P%@(B . ?\x593D);; 
     (?$(P%A(B . ?\x3699);; 
     (?$(P%B(B . ?\x5946);; 
     (?$(P%C(B . ?\x3696);; 
     ;;(?$(P%D(B . ?\x(aacc))  ;; 
     (?$(P%E(B . ?\x595B);; 
     (?$(P%F(B . ?\x595F);; 
     ;;(?$(P%G(B . ?\x(aacd))  ;; 
     (?$(P%H(B . ?\x5975);; 
     (?$(P%I(B . ?\x5976);; 
     (?$(P%J(B . ?\x597C);; 
     (?$(P%K(B . ?\x599F);; 
     (?$(P%L(B . ?\x59AE);; 
     (?$(P%M(B . ?\x59BC);; 
     (?$(P%N(B . ?\x59C8);; 
     (?$(P%O(B . ?\x59CD);; 
     (?$(P%P(B . ?\x59DE);; 
     (?$(P%Q(B . ?\x59E3);; 
     (?$(P%R(B . ?\x59E4);; 
     (?$(P%S(B . ?\x59E7);; 
     (?$(P%T(B . ?\x59EE);; 
     ;;(?$(P%U(B . ?\x(aace))  ;; 
     ;;(?$(P%V(B . ?\x(aacf))  ;; 
     (?$(P%W(B . ?\x36CF);; 
     (?$(P%X(B . ?\x5A0C);; 
     (?$(P%Y(B . ?\x5A0D);; 
     (?$(P%Z(B . ?\x5A17);; 
     (?$(P%[(B . ?\x5A27);; 
     (?$(P%\(B . ?\x5A2D);; 
     (?$(P%](B . ?\x5A55);; 
     (?$(P%^(B . ?\x5A65);; 
     (?$(P%_(B . ?\x5A7A);; 
     (?$(P%`(B . ?\x5A8B);; 
     (?$(P%a(B . ?\x5A9C);; 
     (?$(P%b(B . ?\x5A9F);; 
     (?$(P%c(B . ?\x5AA0);; 
     (?$(P%d(B . ?\x5AA2);; 
     (?$(P%e(B . ?\x5AB1);; 
     (?$(P%f(B . ?\x5AB3);; 
     (?$(P%g(B . ?\x5AB5);; 
     (?$(P%h(B . ?\x5ABA);; 
     (?$(P%i(B . ?\x5ABF);; 
     (?$(P%j(B . ?\x5ADA);; 
     (?$(P%k(B . ?\x5ADC);; 
     (?$(P%l(B . ?\x5AE0);; 
     (?$(P%m(B . ?\x5AE5);; 
     (?$(P%n(B . ?\x5AF0);; 
     (?$(P%o(B . ?\x5AEE);; 
     (?$(P%p(B . ?\x5AF5);; 
     (?$(P%q(B . ?\x5B00);; 
     (?$(P%r(B . ?\x5B08);; 
     (?$(P%s(B . ?\x5B17);; 
     (?$(P%t(B . ?\x5B34);; 
     (?$(P%u(B . ?\x5B2D);; 
     (?$(P%v(B . ?\x5B4C);; 
     (?$(P%w(B . ?\x5B52);; 
     (?$(P%x(B . ?\x5B68);; 
     (?$(P%y(B . ?\x5B6F);; 
     (?$(P%z(B . ?\x5B7C);; 
     (?$(P%{(B . ?\x5B7F);; 
     (?$(P%|(B . ?\x5B81);; 
     (?$(P%}(B . ?\x5B84);; 
     ;;(?$(P%~(B . ?\x(aad1))  ;; 
     (?$(P(!(B . ?\x5B96);; 
     (?$(P("(B . ?\x5BAC);; 
     (?$(P(#(B . ?\x3761);; 
     (?$(P($(B . ?\x5BC0);; 
     (?$(P(%(B . ?\x3762);; 
     (?$(P(&(B . ?\x5BCE);; 
     (?$(P('(B . ?\x5BD6);; 
     (?$(P(((B . ?\x376C);; 
     (?$(P()(B . ?\x376B);; 
     (?$(P(*(B . ?\x5BF1);; 
     (?$(P(+(B . ?\x5BFD);; 
     (?$(P(,(B . ?\x3775);; 
     (?$(P(-(B . ?\x5C03);; 
     (?$(P(.(B . ?\x5C29);; 
     (?$(P(/(B . ?\x5C30);; 
     ;;(?$(P(0(B . ?\x(aad2))  ;; 
     (?$(P(1(B . ?\x5C5F);; 
     (?$(P(2(B . ?\x5C63);; 
     (?$(P(3(B . ?\x5C67);; 
     (?$(P(4(B . ?\x5C68);; 
     (?$(P(5(B . ?\x5C69);; 
     (?$(P(6(B . ?\x5C70);; 
     ;;(?$(P(7(B . ?\x(aad3))  ;; 
     ;;(?$(P(8(B . ?\x(aad5))  ;; 
     (?$(P(9(B . ?\x5C7C);; 
     ;;(?$(P(:(B . ?\x(aad6))  ;; 
     ;;(?$(P(;(B . ?\x(aad7))  ;; 
     (?$(P(<(B . ?\x5C88);; 
     (?$(P(=(B . ?\x5C8A);; 
     (?$(P(>(B . ?\x37C1);; 
     ;;(?$(P(?(B . ?\x(aad8))  ;; 
     ;;(?$(P(@(B . ?\x(aad9))  ;; 
     (?$(P(A(B . ?\x5CA0);; 
     (?$(P(B(B . ?\x5CA2);; 
     (?$(P(C(B . ?\x5CA6);; 
     (?$(P(D(B . ?\x5CA7);; 
     ;;(?$(P(E(B . ?\x(aada))  ;; 
     (?$(P(F(B . ?\x5CAD);; 
     (?$(P(G(B . ?\x5CB5);; 
     ;;(?$(P(H(B . ?\x(aadb))  ;; 
     (?$(P(I(B . ?\x5CC9);; 
     ;;(?$(P(J(B . ?\x(aadc))  ;; 
     ;;(?$(P(K(B . ?\x(aade))  ;; 
     (?$(P(L(B . ?\x5D06);; 
     (?$(P(M(B . ?\x5D10);; 
     (?$(P(N(B . ?\x5D2B);; 
     (?$(P(O(B . ?\x5D1D);; 
     (?$(P(P(B . ?\x5D20);; 
     (?$(P(Q(B . ?\x5D24);; 
     (?$(P(R(B . ?\x5D26);; 
     (?$(P(S(B . ?\x5D31);; 
     (?$(P(T(B . ?\x5D39);; 
     (?$(P(U(B . ?\x5D42);; 
     (?$(P(V(B . ?\x37E8);; 
     (?$(P(W(B . ?\x5D61);; 
     (?$(P(X(B . ?\x5D6A);; 
     (?$(P(Y(B . ?\x37F4);; 
     (?$(P(Z(B . ?\x5D70);; 
     ;;(?$(P([(B . ?\x(aadf))  ;; 
     (?$(P(\(B . ?\x37FD);; 
     (?$(P(](B . ?\x5D88);; 
     (?$(P(^(B . ?\x3800);; 
     (?$(P(_(B . ?\x5D92);; 
     (?$(P(`(B . ?\x5D94);; 
     (?$(P(a(B . ?\x5D97);; 
     (?$(P(b(B . ?\x5D99);; 
     (?$(P(c(B . ?\x5DB0);; 
     (?$(P(d(B . ?\x5DB2);; 
     (?$(P(e(B . ?\x5DB4);; 
     ;;(?$(P(f(B . ?\x(aae0))  ;; 
     (?$(P(g(B . ?\x5DB9);; 
     (?$(P(h(B . ?\x5DD1);; 
     (?$(P(i(B . ?\x5DD7);; 
     (?$(P(j(B . ?\x5DD8);; 
     (?$(P(k(B . ?\x5DE0);; 
     ;;(?$(P(l(B . ?\x(aae1))  ;; 
     (?$(P(m(B . ?\x5DE4);; 
     (?$(P(n(B . ?\x5DE9);; 
     (?$(P(o(B . ?\x382F);; 
     (?$(P(p(B . ?\x5E00);; 
     (?$(P(q(B . ?\x3836);; 
     (?$(P(r(B . ?\x5E12);; 
     (?$(P(s(B . ?\x5E15);; 
     (?$(P(t(B . ?\x3840);; 
     (?$(P(u(B . ?\x5E1F);; 
     (?$(P(v(B . ?\x5E2E);; 
     (?$(P(w(B . ?\x5E3E);; 
     (?$(P(x(B . ?\x5E49);; 
     (?$(P(y(B . ?\x385C);; 
     (?$(P(z(B . ?\x5E56);; 
     (?$(P({(B . ?\x3861);; 
     (?$(P(|(B . ?\x5E6B);; 
     (?$(P(}(B . ?\x5E6C);; 
     (?$(P(~(B . ?\x5E6D);; 
     (?$(P,!(B . ?\x5E6E);; 
     ;;(?$(P,"(B . ?\x(aae2))  ;; 
     (?$(P,#(B . ?\x5EA5);; 
     (?$(P,$(B . ?\x5EAA);; 
     (?$(P,%(B . ?\x5EAC);; 
     (?$(P,&(B . ?\x5EB9);; 
     (?$(P,'(B . ?\x5EBF);; 
     (?$(P,((B . ?\x5EC6);; 
     (?$(P,)(B . ?\x5ED2);; 
     (?$(P,*(B . ?\x5ED9);; 
     ;;(?$(P,+(B . ?\x(aae3))  ;; 
     (?$(P,,(B . ?\x5EFD);; 
     (?$(P,-(B . ?\x5F08);; 
     (?$(P,.(B . ?\x5F0E);; 
     (?$(P,/(B . ?\x5F1C);; 
     ;;(?$(P,0(B . ?\x(aae4))  ;; 
     (?$(P,1(B . ?\x5F1E);; 
     (?$(P,2(B . ?\x5F47);; 
     (?$(P,3(B . ?\x5F63);; 
     (?$(P,4(B . ?\x5F72);; 
     (?$(P,5(B . ?\x5F7E);; 
     (?$(P,6(B . ?\x5F8F);; 
     (?$(P,7(B . ?\x5FA2);; 
     (?$(P,8(B . ?\x5FA4);; 
     (?$(P,9(B . ?\x5FB8);; 
     (?$(P,:(B . ?\x5FC4);; 
     (?$(P,;(B . ?\x38FA);; 
     (?$(P,<(B . ?\x5FC7);; 
     (?$(P,=(B . ?\x5FCB);; 
     (?$(P,>(B . ?\x5FD2);; 
     (?$(P,?(B . ?\x5FD3);; 
     (?$(P,@(B . ?\x5FD4);; 
     (?$(P,A(B . ?\x5FE2);; 
     (?$(P,B(B . ?\x5FEE);; 
     (?$(P,C(B . ?\x5FEF);; 
     (?$(P,D(B . ?\x5FF3);; 
     (?$(P,E(B . ?\x5FFC);; 
     (?$(P,F(B . ?\x3917);; 
     (?$(P,G(B . ?\x6017);; 
     (?$(P,H(B . ?\x6022);; 
     (?$(P,I(B . ?\x6024);; 
     (?$(P,J(B . ?\x391A);; 
     (?$(P,K(B . ?\x604C);; 
     (?$(P,L(B . ?\x607F);; 
     (?$(P,M(B . ?\x608A);; 
     (?$(P,N(B . ?\x6095);; 
     (?$(P,O(B . ?\x60A8);; 
     ;;(?$(P,P(B . ?\x(aae5))  ;; 
     (?$(P,Q(B . ?\x60B0);; 
     (?$(P,R(B . ?\x60B1);; 
     (?$(P,S(B . ?\x60BE);; 
     (?$(P,T(B . ?\x60C8);; 
     (?$(P,U(B . ?\x60D9);; 
     (?$(P,V(B . ?\x60DB);; 
     ;;(?$(P,W(B . ?\x(aae6))  ;; 
     (?$(P,X(B . ?\x60F2);; 
     (?$(P,Y(B . ?\x60F5);; 
     (?$(P,Z(B . ?\x6110);; 
     (?$(P,[(B . ?\x6112);; 
     (?$(P,\(B . ?\x6113);; 
     (?$(P,](B . ?\x6119);; 
     (?$(P,^(B . ?\x611E);; 
     (?$(P,_(B . ?\x613A);; 
     (?$(P,`(B . ?\x396F);; 
     (?$(P,a(B . ?\x6141);; 
     (?$(P,b(B . ?\x6146);; 
     (?$(P,c(B . ?\x6160);; 
     (?$(P,d(B . ?\x617C);; 
     ;;(?$(P,e(B . ?\x(aae7))  ;; 
     (?$(P,f(B . ?\x6192);; 
     (?$(P,g(B . ?\x6193);; 
     (?$(P,h(B . ?\x6197);; 
     (?$(P,i(B . ?\x6198);; 
     (?$(P,j(B . ?\x61A5);; 
     (?$(P,k(B . ?\x61A8);; 
     (?$(P,l(B . ?\x61AD);; 
     ;;(?$(P,m(B . ?\x(aae8))  ;; 
     (?$(P,n(B . ?\x61D5);; 
     (?$(P,o(B . ?\x61DD);; 
     (?$(P,p(B . ?\x61DF);; 
     (?$(P,q(B . ?\x61F5);; 
     ;;(?$(P,r(B . ?\x(aae9))  ;; 
     (?$(P,s(B . ?\x6215);; 
     (?$(P,t(B . ?\x6223);; 
     (?$(P,u(B . ?\x6229);; 
     (?$(P,v(B . ?\x6246);; 
     (?$(P,w(B . ?\x624C);; 
     (?$(P,x(B . ?\x6251);; 
     (?$(P,y(B . ?\x6252);; 
     (?$(P,z(B . ?\x6261);; 
     (?$(P,{(B . ?\x6264);; 
     (?$(P,|(B . ?\x627B);; 
     (?$(P,}(B . ?\x626D);; 
     (?$(P,~(B . ?\x6273);; 
     (?$(P-!(B . ?\x6299);; 
     (?$(P-"(B . ?\x62A6);; 
     (?$(P-#(B . ?\x62D5);; 
     ;;(?$(P-$(B . ?\x(aaea))  ;; 
     (?$(P-%(B . ?\x62FD);; 
     (?$(P-&(B . ?\x6303);; 
     (?$(P-'(B . ?\x630D);; 
     (?$(P-((B . ?\x6310);; 
     ;;(?$(P-)(B . ?\x(aaeb))  ;; 
     ;;(?$(P-*(B . ?\x(aaec))  ;; 
     (?$(P-+(B . ?\x6332);; 
     (?$(P-,(B . ?\x6335);; 
     (?$(P--(B . ?\x633B);; 
     (?$(P-.(B . ?\x633C);; 
     (?$(P-/(B . ?\x6341);; 
     (?$(P-0(B . ?\x6344);; 
     (?$(P-1(B . ?\x634E);; 
     ;;(?$(P-2(B . ?\x(aaed))  ;; 
     (?$(P-3(B . ?\x6359);; 
     ;;(?$(P-4(B . ?\x(aaee))  ;; 
     ;;(?$(P-5(B . ?\x(aaef))  ;; 
     (?$(P-6(B . ?\x636C);; 
     (?$(P-7(B . ?\x6384);; 
     (?$(P-8(B . ?\x6399);; 
     ;;(?$(P-9(B . ?\x(aaf0))  ;; 
     (?$(P-:(B . ?\x6394);; 
     (?$(P-;(B . ?\x63BD);; 
     (?$(P-<(B . ?\x63F7);; 
     (?$(P-=(B . ?\x63D4);; 
     (?$(P->(B . ?\x63D5);; 
     (?$(P-?(B . ?\x63DC);; 
     (?$(P-@(B . ?\x63E0);; 
     (?$(P-A(B . ?\x63EB);; 
     (?$(P-B(B . ?\x63EC);; 
     (?$(P-C(B . ?\x63F2);; 
     (?$(P-D(B . ?\x6409);; 
     (?$(P-E(B . ?\x641E);; 
     (?$(P-F(B . ?\x6425);; 
     (?$(P-G(B . ?\x6429);; 
     (?$(P-H(B . ?\x642F);; 
     (?$(P-I(B . ?\x645A);; 
     (?$(P-J(B . ?\x645B);; 
     (?$(P-K(B . ?\x645D);; 
     (?$(P-L(B . ?\x6473);; 
     (?$(P-M(B . ?\x647D);; 
     (?$(P-N(B . ?\x6487);; 
     (?$(P-O(B . ?\x6491);; 
     (?$(P-P(B . ?\x649D);; 
     (?$(P-Q(B . ?\x649F);; 
     (?$(P-R(B . ?\x64CB);; 
     (?$(P-S(B . ?\x64CC);; 
     (?$(P-T(B . ?\x64D5);; 
     (?$(P-U(B . ?\x64D7);; 
     ;;(?$(P-V(B . ?\x(aaf1))  ;; 
     (?$(P-W(B . ?\x64E4);; 
     (?$(P-X(B . ?\x64E5);; 
     (?$(P-Y(B . ?\x64FF);; 
     (?$(P-Z(B . ?\x6504);; 
     (?$(P-[(B . ?\x3A6E);; 
     (?$(P-\(B . ?\x650F);; 
     (?$(P-](B . ?\x6514);; 
     (?$(P-^(B . ?\x6516);; 
     (?$(P-_(B . ?\x3A73);; 
     (?$(P-`(B . ?\x651E);; 
     (?$(P-a(B . ?\x6532);; 
     (?$(P-b(B . ?\x6544);; 
     (?$(P-c(B . ?\x6554);; 
     (?$(P-d(B . ?\x656B);; 
     (?$(P-e(B . ?\x657A);; 
     (?$(P-f(B . ?\x6581);; 
     (?$(P-g(B . ?\x6584);; 
     (?$(P-h(B . ?\x6585);; 
     (?$(P-i(B . ?\x658A);; 
     (?$(P-j(B . ?\x65B2);; 
     (?$(P-k(B . ?\x65B5);; 
     (?$(P-l(B . ?\x65B8);; 
     (?$(P-m(B . ?\x65BF);; 
     (?$(P-n(B . ?\x65C2);; 
     (?$(P-o(B . ?\x65C9);; 
     (?$(P-p(B . ?\x65D4);; 
     (?$(P-q(B . ?\x3AD6);; 
     (?$(P-r(B . ?\x65F2);; 
     (?$(P-s(B . ?\x65F9);; 
     (?$(P-t(B . ?\x65FC);; 
     (?$(P-u(B . ?\x6604);; 
     (?$(P-v(B . ?\x6608);; 
     (?$(P-w(B . ?\x6621);; 
     (?$(P-x(B . ?\x662A);; 
     (?$(P-y(B . ?\x6645);; 
     (?$(P-z(B . ?\x6651);; 
     (?$(P-{(B . ?\x664E);; 
     (?$(P-|(B . ?\x3AEA);; 
     ;;(?$(P-}(B . ?\x(aaf3))  ;; 
     (?$(P-~(B . ?\x6657);; 
     (?$(P.!(B . ?\x665B);; 
     (?$(P."(B . ?\x6663);; 
     ;;(?$(P.#(B . ?\x(aaf4))  ;; 
     ;;(?$(P.$(B . ?\x(aaf5))  ;; 
     (?$(P.%(B . ?\x666A);; 
     (?$(P.&(B . ?\x666B);; 
     (?$(P.'(B . ?\x666C);; 
     (?$(P.((B . ?\x666D);; 
     (?$(P.)(B . ?\x667B);; 
     (?$(P.*(B . ?\x6680);; 
     (?$(P.+(B . ?\x6690);; 
     (?$(P.,(B . ?\x6692);; 
     (?$(P.-(B . ?\x6699);; 
     (?$(P..(B . ?\x3B0E);; 
     (?$(P./(B . ?\x66AD);; 
     (?$(P.0(B . ?\x66B1);; 
     (?$(P.1(B . ?\x66B5);; 
     (?$(P.2(B . ?\x3B1A);; 
     (?$(P.3(B . ?\x66BF);; 
     (?$(P.4(B . ?\x3B1C);; 
     (?$(P.5(B . ?\x66EC);; 
     (?$(P.6(B . ?\x3AD7);; 
     (?$(P.7(B . ?\x6701);; 
     (?$(P.8(B . ?\x6705);; 
     (?$(P.9(B . ?\x6712);; 
     ;;(?$(P.:(B . ?\x(aaf6))  ;; 
     (?$(P.;(B . ?\x6719);; 
     ;;(?$(P.<(B . ?\x(aaf7))  ;; 
     ;;(?$(P.=(B . ?\x(aaf8))  ;; 
     (?$(P.>(B . ?\x674C);; 
     (?$(P.?(B . ?\x674D);; 
     (?$(P.@(B . ?\x6754);; 
     (?$(P.A(B . ?\x675D);; 
     ;;(?$(P.B(B . ?\x(aaf9))  ;; 
     ;;(?$(P.C(B . ?\x(aafa))  ;; 
     ;;(?$(P.D(B . ?\x(aafb))  ;; 
     (?$(P.E(B . ?\x6774);; 
     (?$(P.F(B . ?\x6776);; 
     ;;(?$(P.G(B . ?\x(aafc))  ;; 
     (?$(P.H(B . ?\x6792);; 
     ;;(?$(P.I(B . ?\x(aafd))  ;; 
     (?$(P.J(B . ?\x8363);; 
     (?$(P.K(B . ?\x6810);; 
     (?$(P.L(B . ?\x67B0);; 
     (?$(P.M(B . ?\x67B2);; 
     (?$(P.N(B . ?\x67C3);; 
     (?$(P.O(B . ?\x67C8);; 
     (?$(P.P(B . ?\x67D2);; 
     (?$(P.Q(B . ?\x67D9);; 
     (?$(P.R(B . ?\x67DB);; 
     (?$(P.S(B . ?\x67F0);; 
     (?$(P.T(B . ?\x67F7);; 
     ;;(?$(P.U(B . ?\x(aafe))  ;; 
     ;;(?$(P.V(B . ?\x(aaff))  ;; 
     ;;(?$(P.W(B . ?\x(ab00))  ;; 
     (?$(P.X(B . ?\x6818);; 
     (?$(P.Y(B . ?\x681F);; 
     (?$(P.Z(B . ?\x682D);; 
     ;;(?$(P.[(B . ?\x(ab01))  ;; 
     (?$(P.\(B . ?\x6833);; 
     (?$(P.](B . ?\x683B);; 
     (?$(P.^(B . ?\x683E);; 
     (?$(P._(B . ?\x6844);; 
     (?$(P.`(B . ?\x6845);; 
     (?$(P.a(B . ?\x6849);; 
     (?$(P.b(B . ?\x684C);; 
     (?$(P.c(B . ?\x6855);; 
     (?$(P.d(B . ?\x6857);; 
     (?$(P.e(B . ?\x3B77);; 
     (?$(P.f(B . ?\x686B);; 
     (?$(P.g(B . ?\x686E);; 
     (?$(P.h(B . ?\x687A);; 
     (?$(P.i(B . ?\x687C);; 
     (?$(P.j(B . ?\x6882);; 
     (?$(P.k(B . ?\x6890);; 
     (?$(P.l(B . ?\x6896);; 
     (?$(P.m(B . ?\x3B6D);; 
     (?$(P.n(B . ?\x6898);; 
     (?$(P.o(B . ?\x6899);; 
     (?$(P.p(B . ?\x689A);; 
     (?$(P.q(B . ?\x689C);; 
     (?$(P.r(B . ?\x68AA);; 
     (?$(P.s(B . ?\x68AB);; 
     (?$(P.t(B . ?\x68B4);; 
     (?$(P.u(B . ?\x68BB);; 
     (?$(P.v(B . ?\x68FB);; 
     ;;(?$(P.w(B . ?\x(ab02))  ;; 
     ;;(?$(P.x(B . ?\x(ab03))  ;; 
     (?$(P.y(B . ?\xFA13);; 
     (?$(P.z(B . ?\x68C3);; 
     (?$(P.{(B . ?\x68C5);; 
     (?$(P.|(B . ?\x68CC);; 
     (?$(P.}(B . ?\x68CF);; 
     (?$(P.~(B . ?\x68D6);; 
     (?$(P/!(B . ?\x68D9);; 
     (?$(P/"(B . ?\x68E4);; 
     (?$(P/#(B . ?\x68E5);; 
     (?$(P/$(B . ?\x68EC);; 
     (?$(P/%(B . ?\x68F7);; 
     (?$(P/&(B . ?\x6903);; 
     (?$(P/'(B . ?\x6907);; 
     (?$(P/((B . ?\x3B87);; 
     (?$(P/)(B . ?\x3B88);; 
     ;;(?$(P/*(B . ?\x(ab05))  ;; 
     (?$(P/+(B . ?\x693B);; 
     (?$(P/,(B . ?\x3B8D);; 
     (?$(P/-(B . ?\x6946);; 
     (?$(P/.(B . ?\x6969);; 
     (?$(P//(B . ?\x696C);; 
     (?$(P/0(B . ?\x6972);; 
     (?$(P/1(B . ?\x697A);; 
     (?$(P/2(B . ?\x697F);; 
     (?$(P/3(B . ?\x6992);; 
     (?$(P/4(B . ?\x3BA4);; 
     (?$(P/5(B . ?\x6996);; 
     (?$(P/6(B . ?\x6998);; 
     (?$(P/7(B . ?\x69A6);; 
     (?$(P/8(B . ?\x69B0);; 
     (?$(P/9(B . ?\x69B7);; 
     (?$(P/:(B . ?\x69BA);; 
     (?$(P/;(B . ?\x69BC);; 
     (?$(P/<(B . ?\x69C0);; 
     (?$(P/=(B . ?\x69D1);; 
     (?$(P/>(B . ?\x69D6);; 
     ;;(?$(P/?(B . ?\x(ab06))  ;; 
     ;;(?$(P/@(B . ?\x(ab07))  ;; 
     (?$(P/A(B . ?\x6A30);; 
     ;;(?$(P/B(B . ?\x(ab08))  ;; 
     ;;(?$(P/C(B . ?\x(ab09))  ;; 
     (?$(P/D(B . ?\x69E3);; 
     (?$(P/E(B . ?\x69EE);; 
     (?$(P/F(B . ?\x69EF);; 
     (?$(P/G(B . ?\x69F3);; 
     (?$(P/H(B . ?\x3BCD);; 
     (?$(P/I(B . ?\x69F4);; 
     (?$(P/J(B . ?\x69FE);; 
     (?$(P/K(B . ?\x6A11);; 
     (?$(P/L(B . ?\x6A1A);; 
     (?$(P/M(B . ?\x6A1D);; 
     ;;(?$(P/N(B . ?\x(ab0b))  ;; 
     (?$(P/O(B . ?\x6A32);; 
     (?$(P/P(B . ?\x6A33);; 
     (?$(P/Q(B . ?\x6A34);; 
     (?$(P/R(B . ?\x6A3F);; 
     (?$(P/S(B . ?\x6A46);; 
     (?$(P/T(B . ?\x6A49);; 
     (?$(P/U(B . ?\x6A7A);; 
     (?$(P/V(B . ?\x6A4E);; 
     (?$(P/W(B . ?\x6A52);; 
     (?$(P/X(B . ?\x6A64);; 
     ;;(?$(P/Y(B . ?\x(ab0d))  ;; 
     (?$(P/Z(B . ?\x6A7E);; 
     (?$(P/[(B . ?\x6A83);; 
     (?$(P/\(B . ?\x6A8B);; 
     (?$(P/](B . ?\x3BF0);; 
     (?$(P/^(B . ?\x6A91);; 
     (?$(P/_(B . ?\x6A9F);; 
     (?$(P/`(B . ?\x6AA1);; 
     ;;(?$(P/a(B . ?\x(ab0e))  ;; 
     (?$(P/b(B . ?\x6AAB);; 
     (?$(P/c(B . ?\x6ABD);; 
     (?$(P/d(B . ?\x6AC6);; 
     (?$(P/e(B . ?\x6AD4);; 
     (?$(P/f(B . ?\x6AD0);; 
     (?$(P/g(B . ?\x6ADC);; 
     (?$(P/h(B . ?\x6ADD);; 
     ;;(?$(P/i(B . ?\x(ab0f))  ;; 
     ;;(?$(P/j(B . ?\x(ab10))  ;; 
     (?$(P/k(B . ?\x6AEC);; 
     (?$(P/l(B . ?\x6AF1);; 
     (?$(P/m(B . ?\x6AF2);; 
     (?$(P/n(B . ?\x6AF3);; 
     (?$(P/o(B . ?\x6AFD);; 
     ;;(?$(P/p(B . ?\x(ab11))  ;; 
     (?$(P/q(B . ?\x6B0B);; 
     (?$(P/r(B . ?\x6B0F);; 
     (?$(P/s(B . ?\x6B10);; 
     (?$(P/t(B . ?\x6B11);; 
     ;;(?$(P/u(B . ?\x(ab12))  ;; 
     (?$(P/v(B . ?\x6B17);; 
     (?$(P/w(B . ?\x3C26);; 
     (?$(P/x(B . ?\x6B2F);; 
     (?$(P/y(B . ?\x6B4A);; 
     (?$(P/z(B . ?\x6B58);; 
     (?$(P/{(B . ?\x6B6C);; 
     (?$(P/|(B . ?\x6B75);; 
     (?$(P/}(B . ?\x6B7A);; 
     (?$(P/~(B . ?\x6B81);; 
     (?$(Pn!(B . ?\x6B9B);; 
     (?$(Pn"(B . ?\x6BAE);; 
     ;;(?$(Pn#(B . ?\x(ab13))  ;; 
     (?$(Pn$(B . ?\x6BBD);; 
     (?$(Pn%(B . ?\x6BBE);; 
     (?$(Pn&(B . ?\x6BC7);; 
     (?$(Pn'(B . ?\x6BC8);; 
     (?$(Pn((B . ?\x6BC9);; 
     (?$(Pn)(B . ?\x6BDA);; 
     (?$(Pn*(B . ?\x6BE6);; 
     (?$(Pn+(B . ?\x6BE7);; 
     (?$(Pn,(B . ?\x6BEE);; 
     (?$(Pn-(B . ?\x6BF1);; 
     (?$(Pn.(B . ?\x6C02);; 
     (?$(Pn/(B . ?\x6C0A);; 
     (?$(Pn0(B . ?\x6C0E);; 
     (?$(Pn1(B . ?\x6C35);; 
     (?$(Pn2(B . ?\x6C36);; 
     (?$(Pn3(B . ?\x6C3A);; 
     ;;(?$(Pn4(B . ?\x(ab14))  ;; 
     (?$(Pn5(B . ?\x6C3F);; 
     (?$(Pn6(B . ?\x6C4D);; 
     (?$(Pn7(B . ?\x6C5B);; 
     (?$(Pn8(B . ?\x6C6D);; 
     (?$(Pn9(B . ?\x6C84);; 
     (?$(Pn:(B . ?\x6C89);; 
     (?$(Pn;(B . ?\x3CC3);; 
     (?$(Pn<(B . ?\x6C94);; 
     (?$(Pn=(B . ?\x6C95);; 
     (?$(Pn>(B . ?\x6C97);; 
     (?$(Pn?(B . ?\x6CAD);; 
     (?$(Pn@(B . ?\x6CC2);; 
     (?$(PnA(B . ?\x6CD0);; 
     (?$(PnB(B . ?\x3CD2);; 
     (?$(PnC(B . ?\x6CD6);; 
     (?$(PnD(B . ?\x6CDA);; 
     (?$(PnE(B . ?\x6CDC);; 
     (?$(PnF(B . ?\x6CE9);; 
     (?$(PnG(B . ?\x6CEC);; 
     (?$(PnH(B . ?\x6CED);; 
     ;;(?$(PnI(B . ?\x(ab16))  ;; 
     (?$(PnJ(B . ?\x6D00);; 
     (?$(PnK(B . ?\x6D0A);; 
     (?$(PnL(B . ?\x6D24);; 
     (?$(PnM(B . ?\x6D26);; 
     (?$(PnN(B . ?\x6D27);; 
     (?$(PnO(B . ?\x6C67);; 
     (?$(PnP(B . ?\x6D2F);; 
     (?$(PnQ(B . ?\x6D3C);; 
     (?$(PnR(B . ?\x6D5B);; 
     (?$(PnS(B . ?\x6D5E);; 
     (?$(PnT(B . ?\x6D60);; 
     (?$(PnU(B . ?\x6D70);; 
     (?$(PnV(B . ?\x6D80);; 
     (?$(PnW(B . ?\x6D81);; 
     (?$(PnX(B . ?\x6D8A);; 
     (?$(PnY(B . ?\x6D8D);; 
     (?$(PnZ(B . ?\x6D91);; 
     (?$(Pn[(B . ?\x6D98);; 
     ;;(?$(Pn\(B . ?\x(ab17))  ;; 
     (?$(Pn](B . ?\x6E17);; 
     ;;(?$(Pn^(B . ?\x(ab18))  ;; 
     ;;(?$(Pn_(B . ?\x(ab19))  ;; 
     ;;(?$(Pn`(B . ?\x(ab1a))  ;; 
     (?$(Pna(B . ?\x6DAB);; 
     (?$(Pnb(B . ?\x6DAE);; 
     (?$(Pnc(B . ?\x6DB4);; 
     (?$(Pnd(B . ?\x6DC2);; 
     (?$(Pne(B . ?\x6D34);; 
     (?$(Pnf(B . ?\x6DC8);; 
     (?$(Png(B . ?\x6DCE);; 
     (?$(Pnh(B . ?\x6DCF);; 
     (?$(Pni(B . ?\x6DD0);; 
     (?$(Pnj(B . ?\x6DDF);; 
     (?$(Pnk(B . ?\x6DE9);; 
     (?$(Pnl(B . ?\x6DF6);; 
     (?$(Pnm(B . ?\x6E36);; 
     (?$(Pnn(B . ?\x6E1E);; 
     (?$(Pno(B . ?\x6E22);; 
     (?$(Pnp(B . ?\x6E27);; 
     (?$(Pnq(B . ?\x3D11);; 
     (?$(Pnr(B . ?\x6E32);; 
     (?$(Pns(B . ?\x6E3C);; 
     (?$(Pnt(B . ?\x6E48);; 
     (?$(Pnu(B . ?\x6E49);; 
     (?$(Pnv(B . ?\x6E4B);; 
     (?$(Pnw(B . ?\x6E4C);; 
     (?$(Pnx(B . ?\x6E4F);; 
     (?$(Pny(B . ?\x6E51);; 
     (?$(Pnz(B . ?\x6E53);; 
     (?$(Pn{(B . ?\x6E54);; 
     (?$(Pn|(B . ?\x6E57);; 
     (?$(Pn}(B . ?\x6E63);; 
     (?$(Pn~(B . ?\x3D1E);; 
     (?$(Po!(B . ?\x6E93);; 
     (?$(Po"(B . ?\x6EA7);; 
     (?$(Po#(B . ?\x6EB4);; 
     (?$(Po$(B . ?\x6EBF);; 
     (?$(Po%(B . ?\x6EC3);; 
     (?$(Po&(B . ?\x6ECA);; 
     (?$(Po'(B . ?\x6ED9);; 
     (?$(Po((B . ?\x6F35);; 
     (?$(Po)(B . ?\x6EEB);; 
     (?$(Po*(B . ?\x6EF9);; 
     (?$(Po+(B . ?\x6EFB);; 
     (?$(Po,(B . ?\x6F0A);; 
     (?$(Po-(B . ?\x6F0C);; 
     (?$(Po.(B . ?\x6F18);; 
     (?$(Po/(B . ?\x6F25);; 
     (?$(Po0(B . ?\x6F36);; 
     (?$(Po1(B . ?\x6F3C);; 
     ;;(?$(Po2(B . ?\x(ab1b))  ;; 
     (?$(Po3(B . ?\x6F52);; 
     (?$(Po4(B . ?\x6F57);; 
     (?$(Po5(B . ?\x6F5A);; 
     (?$(Po6(B . ?\x6F60);; 
     (?$(Po7(B . ?\x6F68);; 
     (?$(Po8(B . ?\x6F98);; 
     (?$(Po9(B . ?\x6F7D);; 
     (?$(Po:(B . ?\x6F90);; 
     (?$(Po;(B . ?\x6F96);; 
     (?$(Po<(B . ?\x6FBE);; 
     (?$(Po=(B . ?\x6F9F);; 
     (?$(Po>(B . ?\x6FA5);; 
     (?$(Po?(B . ?\x6FAF);; 
     (?$(Po@(B . ?\x3D64);; 
     (?$(PoA(B . ?\x6FB5);; 
     (?$(PoB(B . ?\x6FC8);; 
     (?$(PoC(B . ?\x6FC9);; 
     (?$(PoD(B . ?\x6FDA);; 
     (?$(PoE(B . ?\x6FDE);; 
     (?$(PoF(B . ?\x6FE9);; 
     ;;(?$(PoG(B . ?\x(ab1c))  ;; 
     (?$(PoH(B . ?\x6FFC);; 
     (?$(PoI(B . ?\x7000);; 
     (?$(PoJ(B . ?\x7007);; 
     (?$(PoK(B . ?\x700A);; 
     (?$(PoL(B . ?\x7023);; 
     ;;(?$(PoM(B . ?\x(ab1d))  ;; 
     (?$(PoN(B . ?\x7039);; 
     (?$(PoO(B . ?\x703A);; 
     (?$(PoP(B . ?\x703C);; 
     (?$(PoQ(B . ?\x7043);; 
     (?$(PoR(B . ?\x7047);; 
     (?$(PoS(B . ?\x704B);; 
     (?$(PoT(B . ?\x3D9A);; 
     (?$(PoU(B . ?\x7054);; 
     (?$(PoV(B . ?\x7065);; 
     (?$(PoW(B . ?\x7069);; 
     (?$(PoX(B . ?\x706C);; 
     (?$(PoY(B . ?\x706E);; 
     (?$(PoZ(B . ?\x7076);; 
     (?$(Po[(B . ?\x707E);; 
     (?$(Po\(B . ?\x7081);; 
     (?$(Po](B . ?\x7086);; 
     (?$(Po^(B . ?\x7095);; 
     (?$(Po_(B . ?\x7097);; 
     (?$(Po`(B . ?\x70BB);; 
     ;;(?$(Poa(B . ?\x(ab1e))  ;; 
     (?$(Pob(B . ?\x709F);; 
     (?$(Poc(B . ?\x70B1);; 
     ;;(?$(Pod(B . ?\x(ab1f))  ;; 
     (?$(Poe(B . ?\x70EC);; 
     (?$(Pof(B . ?\x70CA);; 
     (?$(Pog(B . ?\x70D1);; 
     (?$(Poh(B . ?\x70D3);; 
     (?$(Poi(B . ?\x70DC);; 
     (?$(Poj(B . ?\x7103);; 
     (?$(Pok(B . ?\x7104);; 
     (?$(Pol(B . ?\x7106);; 
     (?$(Pom(B . ?\x7107);; 
     (?$(Pon(B . ?\x7108);; 
     (?$(Poo(B . ?\x710C);; 
     (?$(Pop(B . ?\x3DC0);; 
     (?$(Poq(B . ?\x712F);; 
     (?$(Por(B . ?\x7131);; 
     (?$(Pos(B . ?\x7150);; 
     (?$(Pot(B . ?\x714A);; 
     (?$(Pou(B . ?\x7153);; 
     (?$(Pov(B . ?\x715E);; 
     (?$(Pow(B . ?\x3DD4);; 
     (?$(Pox(B . ?\x7196);; 
     (?$(Poy(B . ?\x7180);; 
     (?$(Poz(B . ?\x719B);; 
     (?$(Po{(B . ?\x71A0);; 
     (?$(Po|(B . ?\x71A2);; 
     (?$(Po}(B . ?\x71AE);; 
     (?$(Po~(B . ?\x71AF);; 
     (?$(Pp!(B . ?\x71B3);; 
     ;;(?$(Pp"(B . ?\x(ab20))  ;; 
     (?$(Pp#(B . ?\x71CB);; 
     (?$(Pp$(B . ?\x71D3);; 
     (?$(Pp%(B . ?\x71D9);; 
     (?$(Pp&(B . ?\x71DC);; 
     (?$(Pp'(B . ?\x7207);; 
     (?$(Pp((B . ?\x3E05);; 
     ;;(?$(Pp)(B . ?\x(ab21))  ;; 
     (?$(Pp*(B . ?\x722B);; 
     (?$(Pp+(B . ?\x7234);; 
     (?$(Pp,(B . ?\x7238);; 
     (?$(Pp-(B . ?\x7239);; 
     (?$(Pp.(B . ?\x4E2C);; 
     (?$(Pp/(B . ?\x7242);; 
     (?$(Pp0(B . ?\x7253);; 
     (?$(Pp1(B . ?\x7257);; 
     (?$(Pp2(B . ?\x7263);; 
     ;;(?$(Pp3(B . ?\x(ab22))  ;; 
     (?$(Pp4(B . ?\x726E);; 
     (?$(Pp5(B . ?\x726F);; 
     (?$(Pp6(B . ?\x7278);; 
     (?$(Pp7(B . ?\x727F);; 
     (?$(Pp8(B . ?\x728E);; 
     ;;(?$(Pp9(B . ?\x(ab23))  ;; 
     (?$(Pp:(B . ?\x72AD);; 
     (?$(Pp;(B . ?\x72AE);; 
     (?$(Pp<(B . ?\x72B0);; 
     (?$(Pp=(B . ?\x72B1);; 
     (?$(Pp>(B . ?\x72C1);; 
     (?$(Pp?(B . ?\x3E60);; 
     (?$(Pp@(B . ?\x72CC);; 
     (?$(PpA(B . ?\x3E66);; 
     (?$(PpB(B . ?\x3E68);; 
     (?$(PpC(B . ?\x72F3);; 
     (?$(PpD(B . ?\x72FA);; 
     (?$(PpE(B . ?\x7307);; 
     (?$(PpF(B . ?\x7312);; 
     (?$(PpG(B . ?\x7318);; 
     (?$(PpH(B . ?\x7319);; 
     (?$(PpI(B . ?\x3E83);; 
     (?$(PpJ(B . ?\x7339);; 
     (?$(PpK(B . ?\x732C);; 
     (?$(PpL(B . ?\x7331);; 
     (?$(PpM(B . ?\x7333);; 
     (?$(PpN(B . ?\x733D);; 
     (?$(PpO(B . ?\x7352);; 
     (?$(PpP(B . ?\x3E94);; 
     (?$(PpQ(B . ?\x736B);; 
     (?$(PpR(B . ?\x736C);; 
     ;;(?$(PpS(B . ?\x(ab25))  ;; 
     (?$(PpT(B . ?\x736E);; 
     (?$(PpU(B . ?\x736F);; 
     (?$(PpV(B . ?\x7371);; 
     (?$(PpW(B . ?\x7377);; 
     (?$(PpX(B . ?\x7381);; 
     (?$(PpY(B . ?\x7385);; 
     (?$(PpZ(B . ?\x738A);; 
     (?$(Pp[(B . ?\x7394);; 
     (?$(Pp\(B . ?\x7398);; 
     (?$(Pp](B . ?\x739C);; 
     (?$(Pp^(B . ?\x739E);; 
     (?$(Pp_(B . ?\x73A5);; 
     (?$(Pp`(B . ?\x73A8);; 
     (?$(Ppa(B . ?\x73B5);; 
     (?$(Ppb(B . ?\x73B7);; 
     (?$(Ppc(B . ?\x73B9);; 
     (?$(Ppd(B . ?\x73BC);; 
     (?$(Ppe(B . ?\x73BF);; 
     (?$(Ppf(B . ?\x73C5);; 
     (?$(Ppg(B . ?\x73CB);; 
     (?$(Pph(B . ?\x73E1);; 
     (?$(Ppi(B . ?\x73E7);; 
     (?$(Ppj(B . ?\x73F9);; 
     (?$(Ppk(B . ?\x7413);; 
     (?$(Ppl(B . ?\x73FA);; 
     (?$(Ppm(B . ?\x7401);; 
     (?$(Ppn(B . ?\x7424);; 
     (?$(Ppo(B . ?\x7431);; 
     (?$(Ppp(B . ?\x7439);; 
     (?$(Ppq(B . ?\x7453);; 
     (?$(Ppr(B . ?\x7440);; 
     (?$(Pps(B . ?\x7443);; 
     (?$(Ppt(B . ?\x744D);; 
     (?$(Ppu(B . ?\x7452);; 
     (?$(Ppv(B . ?\x745D);; 
     (?$(Ppw(B . ?\x7471);; 
     (?$(Ppx(B . ?\x7481);; 
     (?$(Ppy(B . ?\x7485);; 
     (?$(Ppz(B . ?\x7488);; 
     ;;(?$(Pp{(B . ?\x(ab26))  ;; 
     (?$(Pp|(B . ?\x7492);; 
     (?$(Pp}(B . ?\x7497);; 
     (?$(Pp~(B . ?\x7499);; 
     (?$(Pq!(B . ?\x74A0);; 
     (?$(Pq"(B . ?\x74A1);; 
     (?$(Pq#(B . ?\x74A5);; 
     (?$(Pq$(B . ?\x74AA);; 
     (?$(Pq%(B . ?\x74AB);; 
     (?$(Pq&(B . ?\x74B9);; 
     (?$(Pq'(B . ?\x74BB);; 
     (?$(Pq((B . ?\x74BA);; 
     (?$(Pq)(B . ?\x74D6);; 
     (?$(Pq*(B . ?\x74D8);; 
     (?$(Pq+(B . ?\x74DE);; 
     (?$(Pq,(B . ?\x74EF);; 
     (?$(Pq-(B . ?\x74EB);; 
     ;;(?$(Pq.(B . ?\x(ab27))  ;; 
     (?$(Pq/(B . ?\x74FA);; 
     ;;(?$(Pq0(B . ?\x(ab28))  ;; 
     (?$(Pq1(B . ?\x7520);; 
     (?$(Pq2(B . ?\x7524);; 
     (?$(Pq3(B . ?\x752A);; 
     (?$(Pq4(B . ?\x3F57);; 
     ;;(?$(Pq5(B . ?\x(ab29))  ;; 
     (?$(Pq6(B . ?\x753D);; 
     (?$(Pq7(B . ?\x753E);; 
     (?$(Pq8(B . ?\x7540);; 
     (?$(Pq9(B . ?\x7548);; 
     (?$(Pq:(B . ?\x754E);; 
     (?$(Pq;(B . ?\x7550);; 
     (?$(Pq<(B . ?\x7552);; 
     (?$(Pq=(B . ?\x756C);; 
     (?$(Pq>(B . ?\x7572);; 
     (?$(Pq?(B . ?\x7571);; 
     (?$(Pq@(B . ?\x757A);; 
     (?$(PqA(B . ?\x757D);; 
     (?$(PqB(B . ?\x757E);; 
     (?$(PqC(B . ?\x7581);; 
     ;;(?$(PqD(B . ?\x(ab2a))  ;; 
     (?$(PqE(B . ?\x758C);; 
     (?$(PqF(B . ?\x3F75);; 
     (?$(PqG(B . ?\x75A2);; 
     (?$(PqH(B . ?\x3F77);; 
     (?$(PqI(B . ?\x75B0);; 
     (?$(PqJ(B . ?\x75B7);; 
     (?$(PqK(B . ?\x75BF);; 
     (?$(PqL(B . ?\x75C0);; 
     (?$(PqM(B . ?\x75C6);; 
     (?$(PqN(B . ?\x75CF);; 
     (?$(PqO(B . ?\x75D3);; 
     (?$(PqP(B . ?\x75DD);; 
     (?$(PqQ(B . ?\x75DF);; 
     (?$(PqR(B . ?\x75E0);; 
     (?$(PqS(B . ?\x75E7);; 
     (?$(PqT(B . ?\x75EC);; 
     (?$(PqU(B . ?\x75EE);; 
     (?$(PqV(B . ?\x75F1);; 
     (?$(PqW(B . ?\x75F9);; 
     (?$(PqX(B . ?\x7603);; 
     (?$(PqY(B . ?\x7618);; 
     (?$(PqZ(B . ?\x7607);; 
     (?$(Pq[(B . ?\x760F);; 
     (?$(Pq\(B . ?\x3FAE);; 
     ;;(?$(Pq](B . ?\x(ab2b))  ;; 
     (?$(Pq^(B . ?\x7613);; 
     (?$(Pq_(B . ?\x761B);; 
     (?$(Pq`(B . ?\x761C);; 
     ;;(?$(Pqa(B . ?\x(ab2c))  ;; 
     (?$(Pqb(B . ?\x7625);; 
     (?$(Pqc(B . ?\x7628);; 
     (?$(Pqd(B . ?\x763C);; 
     (?$(Pqe(B . ?\x7633);; 
     ;;(?$(Pqf(B . ?\x(ab2d))  ;; 
     (?$(Pqg(B . ?\x3FC9);; 
     (?$(Pqh(B . ?\x7641);; 
     ;;(?$(Pqi(B . ?\x(ab2e))  ;; 
     (?$(Pqj(B . ?\x7649);; 
     (?$(Pqk(B . ?\x7655);; 
     (?$(Pql(B . ?\x3FD7);; 
     (?$(Pqm(B . ?\x766E);; 
     (?$(Pqn(B . ?\x7695);; 
     (?$(Pqo(B . ?\x769C);; 
     (?$(Pqp(B . ?\x76A1);; 
     (?$(Pqq(B . ?\x76A0);; 
     (?$(Pqr(B . ?\x76A7);; 
     (?$(Pqs(B . ?\x76A8);; 
     (?$(Pqt(B . ?\x76AF);; 
     ;;(?$(Pqu(B . ?\x(ab2f))  ;; 
     (?$(Pqv(B . ?\x76C9);; 
     ;;(?$(Pqw(B . ?\x(ab30))  ;; 
     (?$(Pqx(B . ?\x76E8);; 
     (?$(Pqy(B . ?\x76EC);; 
     ;;(?$(Pqz(B . ?\x(ab31))  ;; 
     (?$(Pq{(B . ?\x7717);; 
     (?$(Pq|(B . ?\x771A);; 
     (?$(Pq}(B . ?\x772D);; 
     (?$(Pq~(B . ?\x7735);; 
     ;;(?$(Pr!(B . ?\x(ab32))  ;; 
     (?$(Pr"(B . ?\x4039);; 
     ;;(?$(Pr#(B . ?\x(ab33))  ;; 
     ;;(?$(Pr$(B . ?\x(ab34))  ;; 
     (?$(Pr%(B . ?\x7758);; 
     (?$(Pr&(B . ?\x7760);; 
     (?$(Pr'(B . ?\x776A);; 
     ;;(?$(Pr((B . ?\x(ab35))  ;; 
     (?$(Pr)(B . ?\x7772);; 
     (?$(Pr*(B . ?\x777C);; 
     (?$(Pr+(B . ?\x777D);; 
     ;;(?$(Pr,(B . ?\x(ab36))  ;; 
     (?$(Pr-(B . ?\x4058);; 
     (?$(Pr.(B . ?\x779A);; 
     (?$(Pr/(B . ?\x779F);; 
     (?$(Pr0(B . ?\x77A2);; 
     (?$(Pr1(B . ?\x77A4);; 
     (?$(Pr2(B . ?\x77A9);; 
     (?$(Pr3(B . ?\x77DE);; 
     (?$(Pr4(B . ?\x77DF);; 
     (?$(Pr5(B . ?\x77E4);; 
     (?$(Pr6(B . ?\x77E6);; 
     (?$(Pr7(B . ?\x77EA);; 
     (?$(Pr8(B . ?\x77EC);; 
     (?$(Pr9(B . ?\x4093);; 
     (?$(Pr:(B . ?\x77F0);; 
     (?$(Pr;(B . ?\x77F4);; 
     (?$(Pr<(B . ?\x77FB);; 
     ;;(?$(Pr=(B . ?\x(ab37))  ;; 
     (?$(Pr>(B . ?\x7805);; 
     (?$(Pr?(B . ?\x7806);; 
     (?$(Pr@(B . ?\x7809);; 
     (?$(PrA(B . ?\x780D);; 
     (?$(PrB(B . ?\x7819);; 
     (?$(PrC(B . ?\x7821);; 
     (?$(PrD(B . ?\x782C);; 
     (?$(PrE(B . ?\x7847);; 
     (?$(PrF(B . ?\x7864);; 
     (?$(PrG(B . ?\x786A);; 
     ;;(?$(PrH(B . ?\x(ab39))  ;; 
     (?$(PrI(B . ?\x788A);; 
     (?$(PrJ(B . ?\x7894);; 
     (?$(PrK(B . ?\x78A4);; 
     (?$(PrL(B . ?\x789D);; 
     (?$(PrM(B . ?\x789E);; 
     (?$(PrN(B . ?\x789F);; 
     (?$(PrO(B . ?\x78BB);; 
     (?$(PrP(B . ?\x78C8);; 
     (?$(PrQ(B . ?\x78CC);; 
     (?$(PrR(B . ?\x78CE);; 
     (?$(PrS(B . ?\x78D5);; 
     (?$(PrT(B . ?\x78E0);; 
     (?$(PrU(B . ?\x78E1);; 
     (?$(PrV(B . ?\x78E6);; 
     (?$(PrW(B . ?\x78F9);; 
     (?$(PrX(B . ?\x78FA);; 
     (?$(PrY(B . ?\x78FB);; 
     (?$(PrZ(B . ?\x78FE);; 
     ;;(?$(Pr[(B . ?\x(ab3b))  ;; 
     (?$(Pr\(B . ?\x7910);; 
     (?$(Pr](B . ?\x791B);; 
     (?$(Pr^(B . ?\x7930);; 
     (?$(Pr_(B . ?\x7925);; 
     (?$(Pr`(B . ?\x793B);; 
     (?$(Pra(B . ?\x794A);; 
     (?$(Prb(B . ?\x7958);; 
     (?$(Prc(B . ?\x795B);; 
     (?$(Prd(B . ?\x4105);; 
     (?$(Pre(B . ?\x7967);; 
     (?$(Prf(B . ?\x7972);; 
     (?$(Prg(B . ?\x7994);; 
     (?$(Prh(B . ?\x7995);; 
     (?$(Pri(B . ?\x7996);; 
     (?$(Prj(B . ?\x799B);; 
     (?$(Prk(B . ?\x79A1);; 
     (?$(Prl(B . ?\x79A9);; 
     (?$(Prm(B . ?\x79B4);; 
     (?$(Prn(B . ?\x79BB);; 
     (?$(Pro(B . ?\x79C2);; 
     (?$(Prp(B . ?\x79C7);; 
     (?$(Prq(B . ?\x79CC);; 
     (?$(Prr(B . ?\x79CD);; 
     (?$(Prs(B . ?\x79D6);; 
     (?$(Prt(B . ?\x4148);; 
     ;;(?$(Pru(B . ?\x(ab3d))  ;; 
     ;;(?$(Prv(B . ?\x(ab3e))  ;; 
     (?$(Prw(B . ?\x414F);; 
     (?$(Prx(B . ?\x7A0A);; 
     (?$(Pry(B . ?\x7A11);; 
     (?$(Prz(B . ?\x7A15);; 
     (?$(Pr{(B . ?\x7A1B);; 
     (?$(Pr|(B . ?\x7A1E);; 
     (?$(Pr}(B . ?\x4163);; 
     (?$(Pr~(B . ?\x7A2D);; 
     (?$(Ps!(B . ?\x7A38);; 
     (?$(Ps"(B . ?\x7A47);; 
     (?$(Ps#(B . ?\x7A4C);; 
     (?$(Ps$(B . ?\x7A56);; 
     (?$(Ps%(B . ?\x7A59);; 
     (?$(Ps&(B . ?\x7A5C);; 
     (?$(Ps'(B . ?\x7A5F);; 
     (?$(Ps((B . ?\x7A60);; 
     (?$(Ps)(B . ?\x7A67);; 
     (?$(Ps*(B . ?\x7A6A);; 
     (?$(Ps+(B . ?\x7A75);; 
     (?$(Ps,(B . ?\x7A78);; 
     (?$(Ps-(B . ?\x7A82);; 
     (?$(Ps.(B . ?\x7A8A);; 
     (?$(Ps/(B . ?\x7A90);; 
     (?$(Ps0(B . ?\x7AA3);; 
     (?$(Ps1(B . ?\x7AAC);; 
     ;;(?$(Ps2(B . ?\x(ab40))  ;; 
     ;;(?$(Ps3(B . ?\x(ab41))  ;; 
     (?$(Ps4(B . ?\x7AB9);; 
     (?$(Ps5(B . ?\x7ABC);; 
     (?$(Ps6(B . ?\x7ABE);; 
     (?$(Ps7(B . ?\x41BF);; 
     (?$(Ps8(B . ?\x7ACC);; 
     (?$(Ps9(B . ?\x7AD1);; 
     (?$(Ps:(B . ?\x7AE7);; 
     (?$(Ps;(B . ?\x7AE8);; 
     (?$(Ps<(B . ?\x7AF4);; 
     ;;(?$(Ps=(B . ?\x(ab42))  ;; 
     ;;(?$(Ps>(B . ?\x(ab43))  ;; 
     (?$(Ps?(B . ?\x7B07);; 
     ;;(?$(Ps@(B . ?\x(ab44))  ;; 
     (?$(PsA(B . ?\x7B3D);; 
     (?$(PsB(B . ?\x7B27);; 
     (?$(PsC(B . ?\x7B2A);; 
     (?$(PsD(B . ?\x7B2E);; 
     (?$(PsE(B . ?\x7B2F);; 
     (?$(PsF(B . ?\x7B31);; 
     (?$(PsG(B . ?\x41E6);; 
     (?$(PsH(B . ?\x41F3);; 
     (?$(PsI(B . ?\x7B7F);; 
     (?$(PsJ(B . ?\x7B41);; 
     (?$(PsK(B . ?\x41EE);; 
     (?$(PsL(B . ?\x7B55);; 
     (?$(PsM(B . ?\x7B79);; 
     (?$(PsN(B . ?\x7B64);; 
     (?$(PsO(B . ?\x7B66);; 
     (?$(PsP(B . ?\x7B69);; 
     (?$(PsQ(B . ?\x7B73);; 
     ;;(?$(PsR(B . ?\x(ab45))  ;; 
     (?$(PsS(B . ?\x4207);; 
     (?$(PsT(B . ?\x7B90);; 
     (?$(PsU(B . ?\x7B91);; 
     (?$(PsV(B . ?\x7B9B);; 
     (?$(PsW(B . ?\x420E);; 
     (?$(PsX(B . ?\x7BAF);; 
     (?$(PsY(B . ?\x7BB5);; 
     (?$(PsZ(B . ?\x7BBC);; 
     (?$(Ps[(B . ?\x7BC5);; 
     (?$(Ps\(B . ?\x7BCA);; 
     ;;(?$(Ps](B . ?\x(ab46))  ;; 
     ;;(?$(Ps^(B . ?\x(ab47))  ;; 
     (?$(Ps_(B . ?\x7BD4);; 
     (?$(Ps`(B . ?\x7BD6);; 
     (?$(Psa(B . ?\x7BDA);; 
     (?$(Psb(B . ?\x7BEA);; 
     (?$(Psc(B . ?\x7BF0);; 
     (?$(Psd(B . ?\x7C03);; 
     (?$(Pse(B . ?\x7C0B);; 
     (?$(Psf(B . ?\x7C0E);; 
     (?$(Psg(B . ?\x7C0F);; 
     (?$(Psh(B . ?\x7C26);; 
     (?$(Psi(B . ?\x7C45);; 
     (?$(Psj(B . ?\x7C4A);; 
     (?$(Psk(B . ?\x7C51);; 
     (?$(Psl(B . ?\x7C57);; 
     (?$(Psm(B . ?\x7C5E);; 
     (?$(Psn(B . ?\x7C61);; 
     (?$(Pso(B . ?\x7C69);; 
     (?$(Psp(B . ?\x7C6E);; 
     (?$(Psq(B . ?\x7C6F);; 
     (?$(Psr(B . ?\x7C70);; 
     ;;(?$(Pss(B . ?\x(ab49))  ;; 
     ;;(?$(Pst(B . ?\x(ab4a))  ;; 
     ;;(?$(Psu(B . ?\x(ab4b))  ;; 
     (?$(Psv(B . ?\x7CA6);; 
     ;;(?$(Psw(B . ?\x(ab4c))  ;; 
     (?$(Psx(B . ?\x7CB6);; 
     (?$(Psy(B . ?\x7CB7);; 
     (?$(Psz(B . ?\x7CBF);; 
     ;;(?$(Ps{(B . ?\x(ab4d))  ;; 
     (?$(Ps|(B . ?\x7CC4);; 
     ;;(?$(Ps}(B . ?\x(ab4e))  ;; 
     (?$(Ps~(B . ?\x7CC8);; 
     (?$(Pt!(B . ?\x7CCD);; 
     ;;(?$(Pt"(B . ?\x(ab4f))  ;; 
     (?$(Pt#(B . ?\x7CD7);; 
     ;;(?$(Pt$(B . ?\x(ab50))  ;; 
     (?$(Pt%(B . ?\x7CE6);; 
     (?$(Pt&(B . ?\x7CEB);; 
     ;;(?$(Pt'(B . ?\x(ab51))  ;; 
     (?$(Pt((B . ?\x7CF5);; 
     (?$(Pt)(B . ?\x7D03);; 
     (?$(Pt*(B . ?\x7D09);; 
     (?$(Pt+(B . ?\x42C6);; 
     (?$(Pt,(B . ?\x7D12);; 
     (?$(Pt-(B . ?\x7D1E);; 
     ;;(?$(Pt.(B . ?\x(ab52))  ;; 
     ;;(?$(Pt/(B . ?\x(ab53))  ;; 
     (?$(Pt0(B . ?\x7D3D);; 
     (?$(Pt1(B . ?\x7D3E);; 
     (?$(Pt2(B . ?\x7D40);; 
     (?$(Pt3(B . ?\x7D47);; 
     ;;(?$(Pt4(B . ?\x(ab54))  ;; 
     ;;(?$(Pt5(B . ?\x(ab55))  ;; 
     (?$(Pt6(B . ?\x42D6);; 
     (?$(Pt7(B . ?\x7D59);; 
     (?$(Pt8(B . ?\x7D5A);; 
     (?$(Pt9(B . ?\x7D6A);; 
     (?$(Pt:(B . ?\x7D70);; 
     (?$(Pt;(B . ?\x42DD);; 
     (?$(Pt<(B . ?\x7D7F);; 
     ;;(?$(Pt=(B . ?\x(ab56))  ;; 
     (?$(Pt>(B . ?\x7D86);; 
     (?$(Pt?(B . ?\x7D88);; 
     (?$(Pt@(B . ?\x7D8C);; 
     (?$(PtA(B . ?\x7D97);; 
     ;;(?$(PtB(B . ?\x(ab57))  ;; 
     (?$(PtC(B . ?\x7D9D);; 
     (?$(PtD(B . ?\x7DA7);; 
     (?$(PtE(B . ?\x7DAA);; 
     (?$(PtF(B . ?\x7DB6);; 
     (?$(PtG(B . ?\x7DB7);; 
     (?$(PtH(B . ?\x7DC0);; 
     (?$(PtI(B . ?\x7DD7);; 
     (?$(PtJ(B . ?\x7DD9);; 
     (?$(PtK(B . ?\x7DE6);; 
     (?$(PtL(B . ?\x7DF1);; 
     (?$(PtM(B . ?\x7DF9);; 
     (?$(PtN(B . ?\x4302);; 
     ;;(?$(PtO(B . ?\x(ab58))  ;; 
     ;;(?$(PtP(B . ?\x(ab59))  ;; 
     (?$(PtQ(B . ?\x7E10);; 
     (?$(PtR(B . ?\x7E17);; 
     (?$(PtS(B . ?\x7E1D);; 
     (?$(PtT(B . ?\x7E20);; 
     (?$(PtU(B . ?\x7E27);; 
     (?$(PtV(B . ?\x7E2C);; 
     (?$(PtW(B . ?\x7E45);; 
     (?$(PtX(B . ?\x7E73);; 
     (?$(PtY(B . ?\x7E75);; 
     (?$(PtZ(B . ?\x7E7E);; 
     (?$(Pt[(B . ?\x7E86);; 
     (?$(Pt\(B . ?\x7E87);; 
     (?$(Pt](B . ?\x432B);; 
     (?$(Pt^(B . ?\x7E91);; 
     (?$(Pt_(B . ?\x7E98);; 
     (?$(Pt`(B . ?\x7E9A);; 
     (?$(Pta(B . ?\x4343);; 
     (?$(Ptb(B . ?\x7F3C);; 
     (?$(Ptc(B . ?\x7F3B);; 
     (?$(Ptd(B . ?\x7F3E);; 
     (?$(Pte(B . ?\x7F43);; 
     (?$(Ptf(B . ?\x7F44);; 
     (?$(Ptg(B . ?\x7F4F);; 
     (?$(Pth(B . ?\x34C1);; 
     ;;(?$(Pti(B . ?\x(ab5a))  ;; 
     (?$(Ptj(B . ?\x7F52);; 
     ;;(?$(Ptk(B . ?\x(ab5b))  ;; 
     (?$(Ptl(B . ?\x7F61);; 
     (?$(Ptm(B . ?\x7F63);; 
     (?$(Ptn(B . ?\x7F64);; 
     (?$(Pto(B . ?\x7F6D);; 
     (?$(Ptp(B . ?\x7F7D);; 
     (?$(Ptq(B . ?\x7F7E);; 
     ;;(?$(Ptr(B . ?\x(ab5c))  ;; 
     (?$(Pts(B . ?\x7F90);; 
     ;;(?$(Ptt(B . ?\x(ab5d))  ;; 
     ;;(?$(Ptu(B . ?\x(ab5e))  ;; 
     (?$(Ptv(B . ?\x7F96);; 
     (?$(Ptw(B . ?\x7F9C);; 
     (?$(Ptx(B . ?\x7FAD);; 
     ;;(?$(Pty(B . ?\x(ab5f))  ;; 
     (?$(Ptz(B . ?\x7FC3);; 
     (?$(Pt{(B . ?\x7FCF);; 
     (?$(Pt|(B . ?\x7FE3);; 
     (?$(Pt}(B . ?\x7FE5);; 
     (?$(Pt~(B . ?\x7FEF);; 
     (?$(Pu!(B . ?\x7FF2);; 
     (?$(Pu"(B . ?\x8002);; 
     (?$(Pu#(B . ?\x800A);; 
     (?$(Pu$(B . ?\x8008);; 
     (?$(Pu%(B . ?\x800E);; 
     (?$(Pu&(B . ?\x8011);; 
     (?$(Pu'(B . ?\x8016);; 
     (?$(Pu((B . ?\x8024);; 
     (?$(Pu)(B . ?\x802C);; 
     (?$(Pu*(B . ?\x8030);; 
     (?$(Pu+(B . ?\x8043);; 
     (?$(Pu,(B . ?\x8066);; 
     (?$(Pu-(B . ?\x8071);; 
     (?$(Pu.(B . ?\x8075);; 
     (?$(Pu/(B . ?\x807B);; 
     (?$(Pu0(B . ?\x8099);; 
     (?$(Pu1(B . ?\x809C);; 
     (?$(Pu2(B . ?\x80A4);; 
     (?$(Pu3(B . ?\x80A7);; 
     (?$(Pu4(B . ?\x80B8);; 
     ;;(?$(Pu5(B . ?\x(ab60))  ;; 
     (?$(Pu6(B . ?\x80C5);; 
     (?$(Pu7(B . ?\x80D5);; 
     (?$(Pu8(B . ?\x80D8);; 
     (?$(Pu9(B . ?\x80E6);; 
     ;;(?$(Pu:(B . ?\x(ab61))  ;; 
     (?$(Pu;(B . ?\x810D);; 
     (?$(Pu<(B . ?\x80F5);; 
     (?$(Pu=(B . ?\x80FB);; 
     (?$(Pu>(B . ?\x43EE);; 
     (?$(Pu?(B . ?\x8135);; 
     (?$(Pu@(B . ?\x8116);; 
     (?$(PuA(B . ?\x811E);; 
     (?$(PuB(B . ?\x43F0);; 
     (?$(PuC(B . ?\x8124);; 
     (?$(PuD(B . ?\x8127);; 
     (?$(PuE(B . ?\x812C);; 
     ;;(?$(PuF(B . ?\x(ab62))  ;; 
     (?$(PuG(B . ?\x813D);; 
     (?$(PuH(B . ?\x4408);; 
     (?$(PuI(B . ?\x8169);; 
     (?$(PuJ(B . ?\x4417);; 
     (?$(PuK(B . ?\x8181);; 
     (?$(PuL(B . ?\x441C);; 
     (?$(PuM(B . ?\x8184);; 
     (?$(PuN(B . ?\x8185);; 
     (?$(PuO(B . ?\x4422);; 
     (?$(PuP(B . ?\x8198);; 
     (?$(PuQ(B . ?\x81B2);; 
     (?$(PuR(B . ?\x81C1);; 
     (?$(PuS(B . ?\x81C3);; 
     (?$(PuT(B . ?\x81D6);; 
     (?$(PuU(B . ?\x81DB);; 
     ;;(?$(PuV(B . ?\x(ab63))  ;; 
     (?$(PuW(B . ?\x81E4);; 
     ;;(?$(PuX(B . ?\x(ab64))  ;; 
     (?$(PuY(B . ?\x81EC);; 
     ;;(?$(PuZ(B . ?\x(ab65))  ;; 
     (?$(Pu[(B . ?\x81FD);; 
     (?$(Pu\(B . ?\x81FF);; 
     ;;(?$(Pu](B . ?\x(ab66))  ;; 
     (?$(Pu^(B . ?\x8204);; 
     ;;(?$(Pu_(B . ?\x(ab67))  ;; 
     (?$(Pu`(B . ?\x8219);; 
     (?$(Pua(B . ?\x8221);; 
     (?$(Pub(B . ?\x8222);; 
     ;;(?$(Puc(B . ?\x(ab68))  ;; 
     (?$(Pud(B . ?\x8232);; 
     (?$(Pue(B . ?\x8234);; 
     (?$(Puf(B . ?\x823C);; 
     (?$(Pug(B . ?\x8246);; 
     (?$(Puh(B . ?\x8249);; 
     (?$(Pui(B . ?\x8245);; 
     ;;(?$(Puj(B . ?\x(ab69))  ;; 
     (?$(Puk(B . ?\x824B);; 
     (?$(Pul(B . ?\x4476);; 
     (?$(Pum(B . ?\x824F);; 
     (?$(Pun(B . ?\x447A);; 
     (?$(Puo(B . ?\x8257);; 
     ;;(?$(Pup(B . ?\x(ab6a))  ;; 
     (?$(Puq(B . ?\x825C);; 
     (?$(Pur(B . ?\x8263);; 
     ;;(?$(Pus(B . ?\x(ab6b))  ;; 
     ;;(?$(Put(B . ?\x(ab6c))  ;; 
     ;;(?$(Puu(B . ?\x(ab6d))  ;; 
     (?$(Puv(B . ?\x8279);; 
     (?$(Puw(B . ?\x4491);; 
     (?$(Pux(B . ?\x827D);; 
     (?$(Puy(B . ?\x827F);; 
     (?$(Puz(B . ?\x8283);; 
     (?$(Pu{(B . ?\x828A);; 
     (?$(Pu|(B . ?\x8293);; 
     (?$(Pu}(B . ?\x82A7);; 
     (?$(Pu~(B . ?\x82A8);; 
     (?$(Pv!(B . ?\x82B2);; 
     (?$(Pv"(B . ?\x82B4);; 
     (?$(Pv#(B . ?\x82BA);; 
     (?$(Pv$(B . ?\x82BC);; 
     (?$(Pv%(B . ?\x82E2);; 
     (?$(Pv&(B . ?\x82E8);; 
     (?$(Pv'(B . ?\x82F7);; 
     (?$(Pv((B . ?\x8307);; 
     (?$(Pv)(B . ?\x8308);; 
     (?$(Pv*(B . ?\x830C);; 
     (?$(Pv+(B . ?\x8354);; 
     (?$(Pv,(B . ?\x831B);; 
     (?$(Pv-(B . ?\x831D);; 
     (?$(Pv.(B . ?\x8330);; 
     (?$(Pv/(B . ?\x833C);; 
     (?$(Pv0(B . ?\x8344);; 
     (?$(Pv1(B . ?\x8357);; 
     (?$(Pv2(B . ?\x44BE);; 
     (?$(Pv3(B . ?\x837F);; 
     (?$(Pv4(B . ?\x44D4);; 
     ;;(?$(Pv5(B . ?\x(ab6f))  ;; 
     (?$(Pv6(B . ?\x838D);; 
     (?$(Pv7(B . ?\x8394);; 
     (?$(Pv8(B . ?\x8395);; 
     (?$(Pv9(B . ?\x839B);; 
     (?$(Pv:(B . ?\x839D);; 
     (?$(Pv;(B . ?\x83C9);; 
     (?$(Pv<(B . ?\x83D0);; 
     (?$(Pv=(B . ?\x83D4);; 
     (?$(Pv>(B . ?\x83DD);; 
     (?$(Pv?(B . ?\x83E5);; 
     (?$(Pv@(B . ?\x83F9);; 
     (?$(PvA(B . ?\x840F);; 
     (?$(PvB(B . ?\x8411);; 
     (?$(PvC(B . ?\x8415);; 
     ;;(?$(PvD(B . ?\x(ab70))  ;; 
     (?$(PvE(B . ?\x8417);; 
     (?$(PvF(B . ?\x8439);; 
     (?$(PvG(B . ?\x844A);; 
     (?$(PvH(B . ?\x844F);; 
     (?$(PvI(B . ?\x8451);; 
     (?$(PvJ(B . ?\x8452);; 
     (?$(PvK(B . ?\x8459);; 
     (?$(PvL(B . ?\x845A);; 
     (?$(PvM(B . ?\x845C);; 
     ;;(?$(PvN(B . ?\x(ab71))  ;; 
     (?$(PvO(B . ?\x8465);; 
     (?$(PvP(B . ?\x8476);; 
     (?$(PvQ(B . ?\x8478);; 
     (?$(PvR(B . ?\x847C);; 
     (?$(PvS(B . ?\x8481);; 
     (?$(PvT(B . ?\x450D);; 
     (?$(PvU(B . ?\x84DC);; 
     (?$(PvV(B . ?\x8497);; 
     (?$(PvW(B . ?\x84A6);; 
     (?$(PvX(B . ?\x84BE);; 
     (?$(PvY(B . ?\x4508);; 
     (?$(PvZ(B . ?\x84CE);; 
     (?$(Pv[(B . ?\x84CF);; 
     (?$(Pv\(B . ?\x84D3);; 
     ;;(?$(Pv](B . ?\x(ab73))  ;; 
     (?$(Pv^(B . ?\x84E7);; 
     (?$(Pv_(B . ?\x84EA);; 
     (?$(Pv`(B . ?\x84EF);; 
     (?$(Pva(B . ?\x84F0);; 
     (?$(Pvb(B . ?\x84F1);; 
     (?$(Pvc(B . ?\x84FA);; 
     (?$(Pvd(B . ?\x84FD);; 
     (?$(Pve(B . ?\x850C);; 
     (?$(Pvf(B . ?\x851B);; 
     (?$(Pvg(B . ?\x8524);; 
     (?$(Pvh(B . ?\x8525);; 
     (?$(Pvi(B . ?\x852B);; 
     (?$(Pvj(B . ?\x8534);; 
     (?$(Pvk(B . ?\x854F);; 
     (?$(Pvl(B . ?\x856F);; 
     (?$(Pvm(B . ?\x4525);; 
     (?$(Pvn(B . ?\x4543);; 
     (?$(Pvo(B . ?\x853E);; 
     (?$(Pvp(B . ?\x8551);; 
     (?$(Pvq(B . ?\x8553);; 
     (?$(Pvr(B . ?\x855E);; 
     (?$(Pvs(B . ?\x8561);; 
     (?$(Pvt(B . ?\x8562);; 
     ;;(?$(Pvu(B . ?\x(ab74))  ;; 
     (?$(Pvv(B . ?\x857B);; 
     (?$(Pvw(B . ?\x857D);; 
     (?$(Pvx(B . ?\x857F);; 
     (?$(Pvy(B . ?\x8581);; 
     (?$(Pvz(B . ?\x8586);; 
     (?$(Pv{(B . ?\x8593);; 
     (?$(Pv|(B . ?\x859D);; 
     (?$(Pv}(B . ?\x859F);; 
     ;;(?$(Pv~(B . ?\x(ab75))  ;; 
     ;;(?$(Pw!(B . ?\x(ab76))  ;; 
     ;;(?$(Pw"(B . ?\x(ab77))  ;; 
     (?$(Pw#(B . ?\x85B7);; 
     (?$(Pw$(B . ?\x85BC);; 
     (?$(Pw%(B . ?\x85C7);; 
     (?$(Pw&(B . ?\x85CA);; 
     (?$(Pw'(B . ?\x85D8);; 
     (?$(Pw((B . ?\x85D9);; 
     (?$(Pw)(B . ?\x85DF);; 
     (?$(Pw*(B . ?\x85E1);; 
     (?$(Pw+(B . ?\x85E6);; 
     (?$(Pw,(B . ?\x85F6);; 
     (?$(Pw-(B . ?\x8600);; 
     (?$(Pw.(B . ?\x8611);; 
     (?$(Pw/(B . ?\x861E);; 
     (?$(Pw0(B . ?\x8621);; 
     (?$(Pw1(B . ?\x8624);; 
     (?$(Pw2(B . ?\x8627);; 
     ;;(?$(Pw3(B . ?\x(ab79))  ;; 
     (?$(Pw4(B . ?\x8639);; 
     (?$(Pw5(B . ?\x863C);; 
     ;;(?$(Pw6(B . ?\x(ab7a))  ;; 
     (?$(Pw7(B . ?\x8640);; 
     (?$(Pw8(B . ?\xFA20);; 
     (?$(Pw9(B . ?\x8653);; 
     (?$(Pw:(B . ?\x8656);; 
     (?$(Pw;(B . ?\x866F);; 
     (?$(Pw<(B . ?\x8677);; 
     (?$(Pw=(B . ?\x867A);; 
     (?$(Pw>(B . ?\x8687);; 
     (?$(Pw?(B . ?\x8689);; 
     (?$(Pw@(B . ?\x868D);; 
     (?$(PwA(B . ?\x8691);; 
     (?$(PwB(B . ?\x869C);; 
     (?$(PwC(B . ?\x869D);; 
     (?$(PwD(B . ?\x86A8);; 
     (?$(PwE(B . ?\xFA21);; 
     (?$(PwF(B . ?\x86B1);; 
     (?$(PwG(B . ?\x86B3);; 
     (?$(PwH(B . ?\x86C1);; 
     (?$(PwI(B . ?\x86C3);; 
     (?$(PwJ(B . ?\x86D1);; 
     (?$(PwK(B . ?\x86D5);; 
     (?$(PwL(B . ?\x86D7);; 
     (?$(PwM(B . ?\x86E3);; 
     (?$(PwN(B . ?\x86E6);; 
     (?$(PwO(B . ?\x45B8);; 
     (?$(PwP(B . ?\x8705);; 
     (?$(PwQ(B . ?\x8707);; 
     (?$(PwR(B . ?\x870E);; 
     (?$(PwS(B . ?\x8710);; 
     (?$(PwT(B . ?\x8713);; 
     (?$(PwU(B . ?\x8719);; 
     (?$(PwV(B . ?\x871F);; 
     (?$(PwW(B . ?\x8721);; 
     (?$(PwX(B . ?\x8723);; 
     (?$(PwY(B . ?\x8731);; 
     (?$(PwZ(B . ?\x873A);; 
     (?$(Pw[(B . ?\x873E);; 
     (?$(Pw\(B . ?\x8740);; 
     (?$(Pw](B . ?\x8743);; 
     (?$(Pw^(B . ?\x8751);; 
     (?$(Pw_(B . ?\x8758);; 
     (?$(Pw`(B . ?\x8764);; 
     (?$(Pwa(B . ?\x8765);; 
     (?$(Pwb(B . ?\x8772);; 
     (?$(Pwc(B . ?\x877C);; 
     ;;(?$(Pwd(B . ?\x(ab7b))  ;; 
     ;;(?$(Pwe(B . ?\x(ab7c))  ;; 
     (?$(Pwf(B . ?\x87A7);; 
     (?$(Pwg(B . ?\x8789);; 
     (?$(Pwh(B . ?\x878B);; 
     (?$(Pwi(B . ?\x8793);; 
     (?$(Pwj(B . ?\x87A0);; 
     ;;(?$(Pwk(B . ?\x(ab7d))  ;; 
     (?$(Pwl(B . ?\x45E5);; 
     (?$(Pwm(B . ?\x87BE);; 
     ;;(?$(Pwn(B . ?\x(ab7e))  ;; 
     (?$(Pwo(B . ?\x87C1);; 
     (?$(Pwp(B . ?\x87CE);; 
     (?$(Pwq(B . ?\x87F5);; 
     (?$(Pwr(B . ?\x87DF);; 
     ;;(?$(Pws(B . ?\x(ab7f))  ;; 
     (?$(Pwt(B . ?\x87E3);; 
     (?$(Pwu(B . ?\x87E5);; 
     (?$(Pwv(B . ?\x87E6);; 
     (?$(Pww(B . ?\x87EA);; 
     (?$(Pwx(B . ?\x87EB);; 
     (?$(Pwy(B . ?\x87ED);; 
     (?$(Pwz(B . ?\x8801);; 
     (?$(Pw{(B . ?\x8803);; 
     (?$(Pw|(B . ?\x880B);; 
     (?$(Pw}(B . ?\x8813);; 
     (?$(Pw~(B . ?\x8828);; 
     (?$(Px!(B . ?\x882E);; 
     (?$(Px"(B . ?\x8832);; 
     (?$(Px#(B . ?\x883C);; 
     (?$(Px$(B . ?\x460F);; 
     (?$(Px%(B . ?\x884A);; 
     (?$(Px&(B . ?\x8858);; 
     (?$(Px'(B . ?\x885F);; 
     (?$(Px((B . ?\x8864);; 
     ;;(?$(Px)(B . ?\x(ab80))  ;; 
     ;;(?$(Px*(B . ?\x(ab81))  ;; 
     (?$(Px+(B . ?\x8869);; 
     ;;(?$(Px,(B . ?\x(ab82))  ;; 
     (?$(Px-(B . ?\x886F);; 
     (?$(Px.(B . ?\x88A0);; 
     (?$(Px/(B . ?\x88BC);; 
     (?$(Px0(B . ?\x88BD);; 
     (?$(Px1(B . ?\x88BE);; 
     (?$(Px2(B . ?\x88C0);; 
     (?$(Px3(B . ?\x88D2);; 
     ;;(?$(Px4(B . ?\x(ab84))  ;; 
     (?$(Px5(B . ?\x88D1);; 
     (?$(Px6(B . ?\x88D3);; 
     (?$(Px7(B . ?\x88DB);; 
     (?$(Px8(B . ?\x88F0);; 
     (?$(Px9(B . ?\x88F1);; 
     (?$(Px:(B . ?\x4641);; 
     (?$(Px;(B . ?\x8901);; 
     ;;(?$(Px<(B . ?\x(ab85))  ;; 
     (?$(Px=(B . ?\x8937);; 
     ;;(?$(Px>(B . ?\x(ab86))  ;; 
     (?$(Px?(B . ?\x8942);; 
     (?$(Px@(B . ?\x8945);; 
     (?$(PxA(B . ?\x8949);; 
     ;;(?$(PxB(B . ?\x(ab87))  ;; 
     (?$(PxC(B . ?\x4665);; 
     (?$(PxD(B . ?\x8962);; 
     ;;(?$(PxE(B . ?\x(ab88))  ;; 
     (?$(PxF(B . ?\x8989);; 
     (?$(PxG(B . ?\x8990);; 
     (?$(PxH(B . ?\x899F);; 
     (?$(PxI(B . ?\x89B0);; 
     (?$(PxJ(B . ?\x89B7);; 
     (?$(PxK(B . ?\x89D6);; 
     (?$(PxL(B . ?\x89D8);; 
     (?$(PxM(B . ?\x89EB);; 
     (?$(PxN(B . ?\x46A1);; 
     (?$(PxO(B . ?\x89F1);; 
     (?$(PxP(B . ?\x89F3);; 
     (?$(PxQ(B . ?\x89FD);; 
     (?$(PxR(B . ?\x89FF);; 
     (?$(PxS(B . ?\x46AF);; 
     (?$(PxT(B . ?\x8A11);; 
     (?$(PxU(B . ?\x8A14);; 
     ;;(?$(PxV(B . ?\x(ab89))  ;; 
     (?$(PxW(B . ?\x8A21);; 
     (?$(PxX(B . ?\x8A35);; 
     (?$(PxY(B . ?\x8A3E);; 
     (?$(PxZ(B . ?\x8A45);; 
     (?$(Px[(B . ?\x8A4D);; 
     (?$(Px\(B . ?\x8A58);; 
     (?$(Px](B . ?\x8AAE);; 
     (?$(Px^(B . ?\x8A90);; 
     (?$(Px_(B . ?\x8AB7);; 
     (?$(Px`(B . ?\x8ABE);; 
     (?$(Pxa(B . ?\x8AD7);; 
     (?$(Pxb(B . ?\x8AFC);; 
     ;;(?$(Pxc(B . ?\x(ab8a))  ;; 
     (?$(Pxd(B . ?\x8B0A);; 
     (?$(Pxe(B . ?\x8B05);; 
     (?$(Pxf(B . ?\x8B0D);; 
     (?$(Pxg(B . ?\x8B1C);; 
     (?$(Pxh(B . ?\x8B1F);; 
     (?$(Pxi(B . ?\x8B2D);; 
     (?$(Pxj(B . ?\x8B43);; 
     (?$(Pxk(B . ?\x470C);; 
     (?$(Pxl(B . ?\x8B51);; 
     (?$(Pxm(B . ?\x8B5E);; 
     (?$(Pxn(B . ?\x8B76);; 
     (?$(Pxo(B . ?\x8B7F);; 
     (?$(Pxp(B . ?\x8B81);; 
     (?$(Pxq(B . ?\x8B8B);; 
     (?$(Pxr(B . ?\x8B94);; 
     (?$(Pxs(B . ?\x8B95);; 
     (?$(Pxt(B . ?\x8B9C);; 
     (?$(Pxu(B . ?\x8B9E);; 
     (?$(Pxv(B . ?\x8C39);; 
     ;;(?$(Pxw(B . ?\x(ab8b))  ;; 
     (?$(Pxx(B . ?\x8C3D);; 
     ;;(?$(Pxy(B . ?\x(ab8c))  ;; 
     ;;(?$(Pxz(B . ?\x(ab8d))  ;; 
     (?$(Px{(B . ?\x8C45);; 
     (?$(Px|(B . ?\x8C47);; 
     (?$(Px}(B . ?\x8C4F);; 
     (?$(Px~(B . ?\x8C54);; 
     (?$(Py!(B . ?\x8C57);; 
     (?$(Py"(B . ?\x8C69);; 
     (?$(Py#(B . ?\x8C6D);; 
     (?$(Py$(B . ?\x8C73);; 
     ;;(?$(Py%(B . ?\x(ab8e))  ;; 
     (?$(Py&(B . ?\x8C93);; 
     (?$(Py'(B . ?\x8C92);; 
     (?$(Py((B . ?\x8C99);; 
     (?$(Py)(B . ?\x4764);; 
     (?$(Py*(B . ?\x8C9B);; 
     (?$(Py+(B . ?\x8CA4);; 
     (?$(Py,(B . ?\x8CD6);; 
     (?$(Py-(B . ?\x8CD5);; 
     (?$(Py.(B . ?\x8CD9);; 
     ;;(?$(Py/(B . ?\x(ab8f))  ;; 
     (?$(Py0(B . ?\x8CF0);; 
     (?$(Py1(B . ?\x8CF1);; 
     ;;(?$(Py2(B . ?\x(ab90))  ;; 
     (?$(Py3(B . ?\x8D09);; 
     (?$(Py4(B . ?\x8D0E);; 
     (?$(Py5(B . ?\x8D6C);; 
     (?$(Py6(B . ?\x8D84);; 
     (?$(Py7(B . ?\x8D95);; 
     (?$(Py8(B . ?\x8DA6);; 
     ;;(?$(Py9(B . ?\x(ab91))  ;; 
     (?$(Py:(B . ?\x8DC6);; 
     (?$(Py;(B . ?\x8DC8);; 
     (?$(Py<(B . ?\x8DD9);; 
     (?$(Py=(B . ?\x8DEC);; 
     (?$(Py>(B . ?\x8E0C);; 
     (?$(Py?(B . ?\x47FD);; 
     (?$(Py@(B . ?\x8DFD);; 
     (?$(PyA(B . ?\x8E06);; 
     ;;(?$(PyB(B . ?\x(ab92))  ;; 
     (?$(PyC(B . ?\x8E14);; 
     (?$(PyD(B . ?\x8E16);; 
     (?$(PyE(B . ?\x8E21);; 
     (?$(PyF(B . ?\x8E22);; 
     (?$(PyG(B . ?\x8E27);; 
     ;;(?$(PyH(B . ?\x(ab93))  ;; 
     (?$(PyI(B . ?\x4816);; 
     (?$(PyJ(B . ?\x8E36);; 
     (?$(PyK(B . ?\x8E39);; 
     (?$(PyL(B . ?\x8E4B);; 
     (?$(PyM(B . ?\x8E54);; 
     (?$(PyN(B . ?\x8E62);; 
     (?$(PyO(B . ?\x8E6C);; 
     (?$(PyP(B . ?\x8E6D);; 
     (?$(PyQ(B . ?\x8E6F);; 
     (?$(PyR(B . ?\x8E98);; 
     (?$(PyS(B . ?\x8E9E);; 
     (?$(PyT(B . ?\x8EAE);; 
     (?$(PyU(B . ?\x8EB3);; 
     (?$(PyV(B . ?\x8EB5);; 
     (?$(PyW(B . ?\x8EB6);; 
     (?$(PyX(B . ?\x8EBB);; 
     ;;(?$(PyY(B . ?\x(ab95))  ;; 
     (?$(PyZ(B . ?\x8ED1);; 
     (?$(Py[(B . ?\x8ED4);; 
     (?$(Py\(B . ?\x484E);; 
     (?$(Py](B . ?\x8EF9);; 
     ;;(?$(Py^(B . ?\x(ab96))  ;; 
     (?$(Py_(B . ?\x8F00);; 
     (?$(Py`(B . ?\x8F08);; 
     (?$(Pya(B . ?\x8F17);; 
     (?$(Pyb(B . ?\x8F2B);; 
     (?$(Pyc(B . ?\x8F40);; 
     (?$(Pyd(B . ?\x8F4A);; 
     (?$(Pye(B . ?\x8F58);; 
     ;;(?$(Pyf(B . ?\x(ab98))  ;; 
     (?$(Pyg(B . ?\x8FA4);; 
     (?$(Pyh(B . ?\x8FB4);; 
     ;;(?$(Pyi(B . ?\x(ab99))  ;; 
     (?$(Pyj(B . ?\x8FB6);; 
     ;;(?$(Pyk(B . ?\x(ab9a))  ;; 
     (?$(Pyl(B . ?\x8FC1);; 
     (?$(Pym(B . ?\x8FC6);; 
     (?$(Pyn(B . ?\xFA24);; 
     (?$(Pyo(B . ?\x8FCA);; 
     (?$(Pyp(B . ?\x8FCD);; 
     (?$(Pyq(B . ?\x8FD3);; 
     (?$(Pyr(B . ?\x8FD5);; 
     (?$(Pys(B . ?\x8FE0);; 
     (?$(Pyt(B . ?\x8FF1);; 
     (?$(Pyu(B . ?\x8FF5);; 
     (?$(Pyv(B . ?\x8FFB);; 
     (?$(Pyw(B . ?\x9002);; 
     (?$(Pyx(B . ?\x900C);; 
     (?$(Pyy(B . ?\x9037);; 
     ;;(?$(Pyz(B . ?\x(ab9b))  ;; 
     (?$(Py{(B . ?\x9043);; 
     (?$(Py|(B . ?\x9044);; 
     (?$(Py}(B . ?\x905D);; 
     ;;(?$(Py~(B . ?\x(ab9c))  ;; 
     ;;(?$(Pz!(B . ?\x(ab9d))  ;; 
     (?$(Pz"(B . ?\x9085);; 
     (?$(Pz#(B . ?\x908C);; 
     (?$(Pz$(B . ?\x9090);; 
     (?$(Pz%(B . ?\x961D);; 
     (?$(Pz&(B . ?\x90A1);; 
     (?$(Pz'(B . ?\x48B5);; 
     (?$(Pz((B . ?\x90B0);; 
     (?$(Pz)(B . ?\x90B6);; 
     (?$(Pz*(B . ?\x90C3);; 
     (?$(Pz+(B . ?\x90C8);; 
     ;;(?$(Pz,(B . ?\x(ab9e))  ;; 
     (?$(Pz-(B . ?\x90DC);; 
     (?$(Pz.(B . ?\x90DF);; 
     ;;(?$(Pz/(B . ?\x(ab9f))  ;; 
     (?$(Pz0(B . ?\x90F6);; 
     (?$(Pz1(B . ?\x90F2);; 
     (?$(Pz2(B . ?\x9100);; 
     (?$(Pz3(B . ?\x90EB);; 
     (?$(Pz4(B . ?\x90FE);; 
     (?$(Pz5(B . ?\x90FF);; 
     (?$(Pz6(B . ?\x9104);; 
     (?$(Pz7(B . ?\x9106);; 
     (?$(Pz8(B . ?\x9118);; 
     (?$(Pz9(B . ?\x911C);; 
     (?$(Pz:(B . ?\x911E);; 
     (?$(Pz;(B . ?\x9137);; 
     (?$(Pz<(B . ?\x9139);; 
     (?$(Pz=(B . ?\x913A);; 
     (?$(Pz>(B . ?\x9146);; 
     (?$(Pz?(B . ?\x9147);; 
     (?$(Pz@(B . ?\x9157);; 
     (?$(PzA(B . ?\x9159);; 
     (?$(PzB(B . ?\x9161);; 
     (?$(PzC(B . ?\x9164);; 
     (?$(PzD(B . ?\x9174);; 
     (?$(PzE(B . ?\x9179);; 
     (?$(PzF(B . ?\x9185);; 
     (?$(PzG(B . ?\x918E);; 
     (?$(PzH(B . ?\x91A8);; 
     (?$(PzI(B . ?\x91AE);; 
     (?$(PzJ(B . ?\x91B3);; 
     (?$(PzK(B . ?\x91B6);; 
     (?$(PzL(B . ?\x91C3);; 
     (?$(PzM(B . ?\x91C4);; 
     (?$(PzN(B . ?\x91DA);; 
     ;;(?$(PzO(B . ?\x(aba0))  ;; 
     ;;(?$(PzP(B . ?\x(aba1))  ;; 
     (?$(PzQ(B . ?\x91EC);; 
     (?$(PzR(B . ?\x91EE);; 
     (?$(PzS(B . ?\x9201);; 
     (?$(PzT(B . ?\x920A);; 
     (?$(PzU(B . ?\x9216);; 
     (?$(PzV(B . ?\x9217);; 
     ;;(?$(PzW(B . ?\x(aba2))  ;; 
     (?$(PzX(B . ?\x9233);; 
     (?$(PzY(B . ?\x9242);; 
     (?$(PzZ(B . ?\x9247);; 
     (?$(Pz[(B . ?\x924A);; 
     (?$(Pz\(B . ?\x924E);; 
     (?$(Pz](B . ?\x9251);; 
     (?$(Pz^(B . ?\x9256);; 
     (?$(Pz_(B . ?\x9259);; 
     (?$(Pz`(B . ?\x9260);; 
     (?$(Pza(B . ?\x9261);; 
     (?$(Pzb(B . ?\x9265);; 
     (?$(Pzc(B . ?\x9267);; 
     (?$(Pzd(B . ?\x9268);; 
     ;;(?$(Pze(B . ?\x(aba3))  ;; 
     ;;(?$(Pzf(B . ?\x(aba4))  ;; 
     (?$(Pzg(B . ?\x927C);; 
     (?$(Pzh(B . ?\x927D);; 
     (?$(Pzi(B . ?\x927F);; 
     (?$(Pzj(B . ?\x9289);; 
     (?$(Pzk(B . ?\x928D);; 
     (?$(Pzl(B . ?\x9297);; 
     (?$(Pzm(B . ?\x9299);; 
     (?$(Pzn(B . ?\x929F);; 
     (?$(Pzo(B . ?\x92A7);; 
     (?$(Pzp(B . ?\x92AB);; 
     ;;(?$(Pzq(B . ?\x(aba5))  ;; 
     ;;(?$(Pzr(B . ?\x(aba6))  ;; 
     (?$(Pzs(B . ?\x92B2);; 
     (?$(Pzt(B . ?\x92BF);; 
     (?$(Pzu(B . ?\x92C0);; 
     (?$(Pzv(B . ?\x92C6);; 
     (?$(Pzw(B . ?\x92CE);; 
     (?$(Pzx(B . ?\x92D0);; 
     (?$(Pzy(B . ?\x92D7);; 
     (?$(Pzz(B . ?\x92D9);; 
     (?$(Pz{(B . ?\x92E5);; 
     (?$(Pz|(B . ?\x92E7);; 
     (?$(Pz}(B . ?\x9311);; 
     ;;(?$(Pz~(B . ?\x(aba7))  ;; 
     ;;(?$(P{!(B . ?\x(aba8))  ;; 
     (?$(P{"(B . ?\x92F7);; 
     (?$(P{#(B . ?\x92F9);; 
     (?$(P{$(B . ?\x92FB);; 
     (?$(P{%(B . ?\x9302);; 
     (?$(P{&(B . ?\x930D);; 
     (?$(P{'(B . ?\x9315);; 
     (?$(P{((B . ?\x931D);; 
     (?$(P{)(B . ?\x931E);; 
     (?$(P{*(B . ?\x9327);; 
     (?$(P{+(B . ?\x9329);; 
     ;;(?$(P{,(B . ?\x(aba9))  ;; 
     ;;(?$(P{-(B . ?\x(abaa))  ;; 
     (?$(P{.(B . ?\x9347);; 
     (?$(P{/(B . ?\x9351);; 
     (?$(P{0(B . ?\x9357);; 
     (?$(P{1(B . ?\x935A);; 
     (?$(P{2(B . ?\x936B);; 
     (?$(P{3(B . ?\x9371);; 
     (?$(P{4(B . ?\x9373);; 
     (?$(P{5(B . ?\x93A1);; 
     ;;(?$(P{6(B . ?\x(abab))  ;; 
     ;;(?$(P{7(B . ?\x(abac))  ;; 
     (?$(P{8(B . ?\x9388);; 
     (?$(P{9(B . ?\x938B);; 
     (?$(P{:(B . ?\x938F);; 
     (?$(P{;(B . ?\x939E);; 
     (?$(P{<(B . ?\x93F5);; 
     ;;(?$(P{=(B . ?\x(abad))  ;; 
     ;;(?$(P{>(B . ?\x(abae))  ;; 
     (?$(P{?(B . ?\x93F1);; 
     (?$(P{@(B . ?\x93C1);; 
     (?$(P{A(B . ?\x93C7);; 
     (?$(P{B(B . ?\x93DC);; 
     (?$(P{C(B . ?\x93E2);; 
     (?$(P{D(B . ?\x93E7);; 
     (?$(P{E(B . ?\x9409);; 
     (?$(P{F(B . ?\x940F);; 
     (?$(P{G(B . ?\x9416);; 
     (?$(P{H(B . ?\x9417);; 
     (?$(P{I(B . ?\x93FB);; 
     (?$(P{J(B . ?\x9432);; 
     (?$(P{K(B . ?\x9434);; 
     (?$(P{L(B . ?\x943B);; 
     (?$(P{M(B . ?\x9445);; 
     ;;(?$(P{N(B . ?\x(abaf))  ;; 
     ;;(?$(P{O(B . ?\x(abb0))  ;; 
     (?$(P{P(B . ?\x946D);; 
     (?$(P{Q(B . ?\x946F);; 
     (?$(P{R(B . ?\x9578);; 
     (?$(P{S(B . ?\x9579);; 
     (?$(P{T(B . ?\x9586);; 
     (?$(P{U(B . ?\x958C);; 
     (?$(P{V(B . ?\x958D);; 
     ;;(?$(P{W(B . ?\x(abb1))  ;; 
     (?$(P{X(B . ?\x95AB);; 
     (?$(P{Y(B . ?\x95B4);; 
     ;;(?$(P{Z(B . ?\x(abb2))  ;; 
     (?$(P{[(B . ?\x95C8);; 
     ;;(?$(P{\(B . ?\x(abb3))  ;; 
     ;;(?$(P{](B . ?\x(abb4))  ;; 
     (?$(P{^(B . ?\x962C);; 
     (?$(P{_(B . ?\x9633);; 
     (?$(P{`(B . ?\x9634);; 
     ;;(?$(P{a(B . ?\x(abb5))  ;; 
     (?$(P{b(B . ?\x963C);; 
     (?$(P{c(B . ?\x9641);; 
     (?$(P{d(B . ?\x9661);; 
     ;;(?$(P{e(B . ?\x(abb6))  ;; 
     (?$(P{f(B . ?\x9682);; 
     ;;(?$(P{g(B . ?\x(abb7))  ;; 
     (?$(P{h(B . ?\x969A);; 
     ;;(?$(P{i(B . ?\x(abb8))  ;; 
     (?$(P{j(B . ?\x49E7);; 
     (?$(P{k(B . ?\x96A9);; 
     (?$(P{l(B . ?\x96AF);; 
     (?$(P{m(B . ?\x96B3);; 
     (?$(P{n(B . ?\x96BA);; 
     (?$(P{o(B . ?\x96BD);; 
     (?$(P{p(B . ?\x49FA);; 
     ;;(?$(P{q(B . ?\x(abb9))  ;; 
     (?$(P{r(B . ?\x96D8);; 
     (?$(P{s(B . ?\x96DA);; 
     (?$(P{t(B . ?\x96DD);; 
     (?$(P{u(B . ?\x4A04);; 
     (?$(P{v(B . ?\x9714);; 
     (?$(P{w(B . ?\x9723);; 
     (?$(P{x(B . ?\x4A29);; 
     (?$(P{y(B . ?\x9736);; 
     (?$(P{z(B . ?\x9741);; 
     (?$(P{{(B . ?\x9747);; 
     (?$(P{|(B . ?\x9755);; 
     (?$(P{}(B . ?\x9757);; 
     (?$(P{~(B . ?\x975B);; 
     (?$(P|!(B . ?\x976A);; 
     ;;(?$(P|"(B . ?\x(abba))  ;; 
     ;;(?$(P|#(B . ?\x(abbb))  ;; 
     (?$(P|$(B . ?\x9796);; 
     (?$(P|%(B . ?\x979A);; 
     (?$(P|&(B . ?\x979E);; 
     (?$(P|'(B . ?\x97A2);; 
     (?$(P|((B . ?\x97B1);; 
     (?$(P|)(B . ?\x97B2);; 
     (?$(P|*(B . ?\x97BE);; 
     (?$(P|+(B . ?\x97CC);; 
     (?$(P|,(B . ?\x97D1);; 
     (?$(P|-(B . ?\x97D4);; 
     (?$(P|.(B . ?\x97D8);; 
     (?$(P|/(B . ?\x97D9);; 
     (?$(P|0(B . ?\x97E1);; 
     (?$(P|1(B . ?\x97F1);; 
     (?$(P|2(B . ?\x9804);; 
     (?$(P|3(B . ?\x980D);; 
     (?$(P|4(B . ?\x980E);; 
     (?$(P|5(B . ?\x9814);; 
     (?$(P|6(B . ?\x9816);; 
     (?$(P|7(B . ?\x4ABC);; 
     ;;(?$(P|8(B . ?\x(abbc))  ;; 
     (?$(P|9(B . ?\x9823);; 
     (?$(P|:(B . ?\x9832);; 
     (?$(P|;(B . ?\x9833);; 
     (?$(P|<(B . ?\x9825);; 
     (?$(P|=(B . ?\x9847);; 
     (?$(P|>(B . ?\x9866);; 
     (?$(P|?(B . ?\x98AB);; 
     (?$(P|@(B . ?\x98AD);; 
     (?$(P|A(B . ?\x98B0);; 
     ;;(?$(P|B(B . ?\x(abbd))  ;; 
     (?$(P|C(B . ?\x98B7);; 
     (?$(P|D(B . ?\x98B8);; 
     (?$(P|E(B . ?\x98BB);; 
     (?$(P|F(B . ?\x98BC);; 
     (?$(P|G(B . ?\x98BF);; 
     (?$(P|H(B . ?\x98C2);; 
     (?$(P|I(B . ?\x98C7);; 
     (?$(P|J(B . ?\x98CB);; 
     (?$(P|K(B . ?\x98E0);; 
     ;;(?$(P|L(B . ?\x(abbe))  ;; 
     (?$(P|M(B . ?\x98E1);; 
     (?$(P|N(B . ?\x98E3);; 
     (?$(P|O(B . ?\x98E5);; 
     (?$(P|P(B . ?\x98EA);; 
     (?$(P|Q(B . ?\x98F0);; 
     (?$(P|R(B . ?\x98F1);; 
     (?$(P|S(B . ?\x98F3);; 
     (?$(P|T(B . ?\x9908);; 
     (?$(P|U(B . ?\x4B3B);; 
     ;;(?$(P|V(B . ?\x(abbf))  ;; 
     (?$(P|W(B . ?\x9916);; 
     (?$(P|X(B . ?\x9917);; 
     ;;(?$(P|Y(B . ?\x(abc0))  ;; 
     (?$(P|Z(B . ?\x991A);; 
     (?$(P|[(B . ?\x991B);; 
     (?$(P|\(B . ?\x991C);; 
     ;;(?$(P|](B . ?\x(abc1))  ;; 
     (?$(P|^(B . ?\x9931);; 
     (?$(P|_(B . ?\x9932);; 
     (?$(P|`(B . ?\x9933);; 
     (?$(P|a(B . ?\x993A);; 
     (?$(P|b(B . ?\x993B);; 
     (?$(P|c(B . ?\x993C);; 
     (?$(P|d(B . ?\x9940);; 
     (?$(P|e(B . ?\x9941);; 
     (?$(P|f(B . ?\x9946);; 
     (?$(P|g(B . ?\x994D);; 
     (?$(P|h(B . ?\x994E);; 
     (?$(P|i(B . ?\x995C);; 
     (?$(P|j(B . ?\x995F);; 
     (?$(P|k(B . ?\x9960);; 
     (?$(P|l(B . ?\x99A3);; 
     (?$(P|m(B . ?\x99A6);; 
     (?$(P|n(B . ?\x99B9);; 
     (?$(P|o(B . ?\x99BD);; 
     (?$(P|p(B . ?\x99BF);; 
     (?$(P|q(B . ?\x99C3);; 
     (?$(P|r(B . ?\x99C9);; 
     (?$(P|s(B . ?\x99D4);; 
     (?$(P|t(B . ?\x99D9);; 
     (?$(P|u(B . ?\x99DE);; 
     ;;(?$(P|v(B . ?\x(abc2))  ;; 
     (?$(P|w(B . ?\x99F0);; 
     (?$(P|x(B . ?\x99F9);; 
     (?$(P|y(B . ?\x99FC);; 
     (?$(P|z(B . ?\x9A0A);; 
     (?$(P|{(B . ?\x9A11);; 
     (?$(P||(B . ?\x9A16);; 
     (?$(P|}(B . ?\x9A1A);; 
     (?$(P|~(B . ?\x9A20);; 
     (?$(P}!(B . ?\x9A31);; 
     (?$(P}"(B . ?\x9A36);; 
     (?$(P}#(B . ?\x9A44);; 
     (?$(P}$(B . ?\x9A4C);; 
     (?$(P}%(B . ?\x9A58);; 
     (?$(P}&(B . ?\x4BC2);; 
     (?$(P}'(B . ?\x9AAF);; 
     (?$(P}((B . ?\x4BCA);; 
     (?$(P})(B . ?\x9AB7);; 
     (?$(P}*(B . ?\x4BD2);; 
     (?$(P}+(B . ?\x9AB9);; 
     ;;(?$(P},(B . ?\x(abc3))  ;; 
     (?$(P}-(B . ?\x9AC6);; 
     (?$(P}.(B . ?\x9AD0);; 
     (?$(P}/(B . ?\x9AD2);; 
     (?$(P}0(B . ?\x9AD5);; 
     (?$(P}1(B . ?\x4BE8);; 
     (?$(P}2(B . ?\x9ADC);; 
     (?$(P}3(B . ?\x9AE0);; 
     (?$(P}4(B . ?\x9AE5);; 
     (?$(P}5(B . ?\x9AE9);; 
     (?$(P}6(B . ?\x9B03);; 
     (?$(P}7(B . ?\x9B0C);; 
     (?$(P}8(B . ?\x9B10);; 
     (?$(P}9(B . ?\x9B12);; 
     (?$(P}:(B . ?\x9B16);; 
     (?$(P};(B . ?\x9B1D);; 
     (?$(P}<(B . ?\x9B2B);; 
     (?$(P}=(B . ?\x9B33);; 
     (?$(P}>(B . ?\x9B3D);; 
     (?$(P}?(B . ?\x4C20);; 
     (?$(P}@(B . ?\x9B4B);; 
     (?$(P}A(B . ?\x9B63);; 
     (?$(P}B(B . ?\x9B65);; 
     (?$(P}C(B . ?\x9B6B);; 
     (?$(P}D(B . ?\x9B6C);; 
     (?$(P}E(B . ?\x9B73);; 
     (?$(P}F(B . ?\x9B76);; 
     (?$(P}G(B . ?\x9B77);; 
     (?$(P}H(B . ?\x9BA6);; 
     (?$(P}I(B . ?\x9BAC);; 
     (?$(P}J(B . ?\x9BB1);; 
     ;;(?$(P}K(B . ?\x(abc4))  ;; 
     ;;(?$(P}L(B . ?\x(abc5))  ;; 
     (?$(P}M(B . ?\x9BB2);; 
     (?$(P}N(B . ?\x9BB8);; 
     (?$(P}O(B . ?\x9BBE);; 
     (?$(P}P(B . ?\x9BC7);; 
     (?$(P}Q(B . ?\x9BF3);; 
     (?$(P}R(B . ?\x9BD8);; 
     (?$(P}S(B . ?\x9BDD);; 
     (?$(P}T(B . ?\x9BE7);; 
     (?$(P}U(B . ?\x9BEA);; 
     (?$(P}V(B . ?\x9BEB);; 
     (?$(P}W(B . ?\x9BEF);; 
     (?$(P}X(B . ?\x9BEE);; 
     ;;(?$(P}Y(B . ?\x(abc6))  ;; 
     (?$(P}Z(B . ?\x9BFA);; 
     ;;(?$(P}[(B . ?\x(abc7))  ;; 
     (?$(P}\(B . ?\x9BF7);; 
     ;;(?$(P}](B . ?\x(abc8))  ;; 
     (?$(P}^(B . ?\x9C16);; 
     (?$(P}_(B . ?\x9C18);; 
     (?$(P}`(B . ?\x9C19);; 
     (?$(P}a(B . ?\x9C1A);; 
     (?$(P}b(B . ?\x9C1D);; 
     (?$(P}c(B . ?\x9C22);; 
     (?$(P}d(B . ?\x9C27);; 
     (?$(P}e(B . ?\x9C29);; 
     (?$(P}f(B . ?\x9C2A);; 
     ;;(?$(P}g(B . ?\x(abc9))  ;; 
     (?$(P}h(B . ?\x9C31);; 
     (?$(P}i(B . ?\x9C36);; 
     (?$(P}j(B . ?\x9C37);; 
     (?$(P}k(B . ?\x9C45);; 
     (?$(P}l(B . ?\x9C5C);; 
     ;;(?$(P}m(B . ?\x(abca))  ;; 
     (?$(P}n(B . ?\x9C49);; 
     (?$(P}o(B . ?\x9C4A);; 
     ;;(?$(P}p(B . ?\x(abcb))  ;; 
     (?$(P}q(B . ?\x9C54);; 
     (?$(P}r(B . ?\x9C58);; 
     (?$(P}s(B . ?\x9C5B);; 
     (?$(P}t(B . ?\x9C5D);; 
     (?$(P}u(B . ?\x9C5F);; 
     (?$(P}v(B . ?\x9C69);; 
     (?$(P}w(B . ?\x9C6A);; 
     (?$(P}x(B . ?\x9C6B);; 
     (?$(P}y(B . ?\x9C6D);; 
     (?$(P}z(B . ?\x9C6E);; 
     (?$(P}{(B . ?\x9C70);; 
     (?$(P}|(B . ?\x9C72);; 
     (?$(P}}(B . ?\x9C75);; 
     (?$(P}~(B . ?\x9C7A);; 
     (?$(P~!(B . ?\x9CE6);; 
     (?$(P~"(B . ?\x9CF2);; 
     (?$(P~#(B . ?\x9D0B);; 
     (?$(P~$(B . ?\x9D02);; 
     ;;(?$(P~%(B . ?\x(abcc))  ;; 
     (?$(P~&(B . ?\x9D11);; 
     (?$(P~'(B . ?\x9D17);; 
     (?$(P~((B . ?\x9D18);; 
     ;;(?$(P~)(B . ?\x(abcd))  ;; 
     (?$(P~*(B . ?\x4CC4);; 
     ;;(?$(P~+(B . ?\x(abce))  ;; 
     (?$(P~,(B . ?\x9D32);; 
     (?$(P~-(B . ?\x4CD1);; 
     (?$(P~.(B . ?\x9D42);; 
     (?$(P~/(B . ?\x9D4A);; 
     (?$(P~0(B . ?\x9D5F);; 
     (?$(P~1(B . ?\x9D62);; 
     ;;(?$(P~2(B . ?\x(abcf))  ;; 
     (?$(P~3(B . ?\x9D69);; 
     (?$(P~4(B . ?\x9D6B);; 
     ;;(?$(P~5(B . ?\x(abd0))  ;; 
     (?$(P~6(B . ?\x9D73);; 
     (?$(P~7(B . ?\x9D76);; 
     (?$(P~8(B . ?\x9D77);; 
     (?$(P~9(B . ?\x9D7E);; 
     (?$(P~:(B . ?\x9D84);; 
     (?$(P~;(B . ?\x9D8D);; 
     (?$(P~<(B . ?\x9D99);; 
     (?$(P~=(B . ?\x9DA1);; 
     (?$(P~>(B . ?\x9DBF);; 
     (?$(P~?(B . ?\x9DB5);; 
     (?$(P~@(B . ?\x9DB9);; 
     (?$(P~A(B . ?\x9DBD);; 
     (?$(P~B(B . ?\x9DC3);; 
     (?$(P~C(B . ?\x9DC7);; 
     (?$(P~D(B . ?\x9DC9);; 
     (?$(P~E(B . ?\x9DD6);; 
     (?$(P~F(B . ?\x9DDA);; 
     (?$(P~G(B . ?\x9DDF);; 
     (?$(P~H(B . ?\x9DE0);; 
     (?$(P~I(B . ?\x9DE3);; 
     (?$(P~J(B . ?\x9DF4);; 
     (?$(P~K(B . ?\x4D07);; 
     (?$(P~L(B . ?\x9E0A);; 
     (?$(P~M(B . ?\x9E02);; 
     (?$(P~N(B . ?\x9E0D);; 
     (?$(P~O(B . ?\x9E19);; 
     (?$(P~P(B . ?\x9E1C);; 
     (?$(P~Q(B . ?\x9E1D);; 
     (?$(P~R(B . ?\x9E7B);; 
     ;;(?$(P~S(B . ?\x(abd2))  ;; 
     (?$(P~T(B . ?\x9E80);; 
     (?$(P~U(B . ?\x9E85);; 
     (?$(P~V(B . ?\x9E9B);; 
     (?$(P~W(B . ?\x9EA8);; 
     ;;(?$(P~X(B . ?\x(abd3))  ;; 
     (?$(P~Y(B . ?\x9EBD);; 
     ;;(?$(P~Z(B . ?\x(abd4))  ;; 
     (?$(P~[(B . ?\x9EDF);; 
     (?$(P~\(B . ?\x9EE7);; 
     (?$(P~](B . ?\x9EEE);; 
     (?$(P~^(B . ?\x9EFF);; 
     (?$(P~_(B . ?\x9F02);; 
     (?$(P~`(B . ?\x4D79);; 
     (?$(P~a(B . ?\x9F03);; 
     (?$(P~b(B . ?\x9F17);; 
     (?$(P~c(B . ?\x9F19);; 
     (?$(P~d(B . ?\x9F2F);; 
     (?$(P~e(B . ?\x9F37);; 
     (?$(P~f(B . ?\x9F3A);; 
     (?$(P~g(B . ?\x9F3D);; 
     (?$(P~h(B . ?\x9F41);; 
     (?$(P~i(B . ?\x9F45);; 
     (?$(P~j(B . ?\x9F46);; 
     (?$(P~k(B . ?\x9F53);; 
     (?$(P~l(B . ?\x9F55);; 
     (?$(P~m(B . ?\x9F58);; 
     ;;(?$(P~n(B . ?\x(abd5))  ;; 
     (?$(P~o(B . ?\x9F5D);; 
     ;;(?$(P~p(B . ?\x(abd6))  ;; 
     (?$(P~q(B . ?\x9F69);; 
     ;;(?$(P~r(B . ?\x(abd7))  ;; 
     (?$(P~s(B . ?\x9F6D);; 
     (?$(P~t(B . ?\x9F70);; 
     (?$(P~u(B . ?\x9F75);; 
     ;;(?$(P~v(B . ?\x(abd8))  ;; 
     )))

(provide 'ujisx0213)
