; -*- coding: iso-2022-7bit  -*-
;;; u-cns-4.el --- tables between UCS and CNS 11643:1992 plain 4

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of MULE-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-4 'unicode-assoc
     'cns11643-4-vs-unicode-assoc)

(defvar cns11643-4-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(J!"(B . ?\x4E40) ; <CJK>
     (?$(J!#(B . ?\x4E41) ; <CJK>
     (?$(J!$(B . ?\x4E5A) ; <CJK>
     (?$(J!&(B . ?\x4E02) ; <CJK>
     (?$(J!'(B . ?\x4E29) ; <CJK>
     (?$(J!*(B . ?\x5202) ; <CJK>
     (?$(J!,(B . ?\x5DDC) ; <CJK>
     (?$(J!0(B . ?\x5342) ; <CJK>
     (?$(J!1(B . ?\x536A) ; <CJK>
     (?$(J!2(B . ?\x5B52) ; <CJK>
     (?$(J!4(B . ?\x5C22) ; <CJK>
     (?$(J!5(B . ?\x5C6E) ; <CJK>
     (?$(J!6(B . ?\x5FC4) ; <CJK>
     (?$(J!7(B . ?\x624C) ; <CJK>
     (?$(J!8(B . ?\x72AD) ; <CJK>
     (?$(J!9(B . ?\x4E12) ; <CJK>
     (?$(J!:(B . ?\x4E2F) ; <CJK>
     (?$(J!;(B . ?\x4E96) ; <CJK>
     (?$(J!<(B . ?\x4ED0) ; <CJK>
     (?$(J!=(B . ?\x5142) ; <CJK>
     (?$(J!>(B . ?\x5183) ; <CJK>
     (?$(J!?(B . ?\x4ECC) ; <CJK>
     (?$(J!D(B . ?\x5383) ; <CJK>
     (?$(J!E(B . ?\x53B8) ; <CJK>
     (?$(J!I(B . ?\x5928) ; <CJK>
     (?$(J!K(B . ?\x5C23) ; <CJK>
     (?$(J!L(B . ?\x5E01) ; <CJK>
     (?$(J!M(B . ?\x5F00) ; <CJK>
     (?$(J!P(B . ?\x706C) ; <CJK>
     (?$(J!Q(B . ?\x722B) ; <CJK>
     (?$(J!R(B . ?\x5188) ; <CJK>
     (?$(J!S(B . ?\x8279) ; <CJK>
     (?$(J!T(B . ?\x8FB6) ; <CJK>
     (?$(J!U(B . ?\x4E17) ; <CJK>
     (?$(J!Z(B . ?\x4EE2) ; <CJK>
     (?$(J![(B . ?\x4EDB) ; <CJK>
     (?$(J!^(B . ?\x51AD) ; <CJK>
     (?$(J!`(B . ?\x51F7) ; <CJK>
     (?$(J!e(B . ?\x531B) ; <CJK>
     (?$(J!f(B . ?\x5388) ; <CJK>
     (?$(J!g(B . ?\x5387) ; <CJK>
     (?$(J!i(B . ?\x53CF) ; <CJK>
     (?$(J!l(B . ?\x53E7) ; <CJK>
     (?$(J!m(B . ?\x56DC) ; <CJK>
     (?$(J!o(B . ?\x56D9) ; <CJK>
     (?$(J!p(B . ?\x5725) ; <CJK>
     (?$(J!q(B . ?\x5727) ; <CJK>
     (?$(J!r(B . ?\x5933) ; <CJK>
     (?$(J!s(B . ?\x5C13) ; <CJK>
     (?$(J!v(B . ?\x5C75) ; <CJK>
     (?$(J!|(B . ?\x66F1) ; <CJK>
     (?$(J"!(B . ?\x7F52) ; <CJK>
     (?$(J"'(B . ?\x4E51) ; <CJK>
     (?$(J"((B . ?\x4E6A) ; <CJK>
     (?$(J"*(B . ?\x4F0C) ; <CJK>
     (?$(J"-(B . ?\x4EFE) ; <CJK>
     (?$(J".(B . ?\x4F1B) ; <CJK>
     (?$(J"4(B . ?\x5173) ; <CJK>
     (?$(J"6(B . ?\x518E) ; <CJK>
     (?$(J"?(B . ?\x52A5) ; <CJK>
     (?$(J"A(B . ?\x52A7) ; <CJK>
     (?$(J"B(B . ?\x52A4) ; <CJK>
     (?$(J"H(B . ?\x53BD) ; <CJK>
     (?$(J"L(B . ?\x5402) ; <CJK>
     (?$(J"Q(B . ?\x572B) ; <CJK>
     (?$(J"R(B . ?\x591B) ; <CJK>
     (?$(J"S(B . ?\x5935) ; <CJK>
     (?$(J"[(B . ?\x5B90) ; <CJK>
     (?$(J"\(B . ?\x5C17) ; <CJK>
     (?$(J"_(B . ?\x5C70) ; <CJK>
     (?$(J"`(B . ?\x5C7D) ; <CJK>
     (?$(J"c(B . ?\x5DE9) ; <CJK>
     (?$(J"k(B . ?\x5F19) ; <CJK>
     (?$(J"l(B . ?\x5F1C) ; <CJK>
     (?$(J"m(B . ?\x5F75) ; <CJK>
     (?$(J"q(B . ?\x5FC8) ; <CJK>
     (?$(J#!(B . ?\x6C12) ; <CJK>
     (?$(J#'(B . ?\x72B3) ; <CJK>
     (?$(J#*(B . ?\x7390) ; <CJK>
     (?$(J#+(B . ?\x7536) ; <CJK>
     (?$(J#/(B . ?\x8281) ; <CJK>
     (?$(J#0(B . ?\x8FB8) ; <CJK>
     (?$(J#5(B . ?\x4E23) ; <CJK>
     (?$(J#9(B . ?\x4F2E) ; <CJK>
     (?$(J#;(B . ?\x514F) ; <CJK>
     (?$(J#=(B . ?\x51BA) ; <CJK>
     (?$(J#@(B . ?\x5222) ; <CJK>
     (?$(J#F(B . ?\x52AF) ; <CJK>
     (?$(J#G(B . ?\x52B0) ; <CJK>
     (?$(J#H(B . ?\x52B1) ; <CJK>
     (?$(J#I(B . ?\x52B2) ; <CJK>
     (?$(J#M(B . ?\x5364) ; <CJK>
     (?$(J#O(B . ?\x53D3) ; <CJK>
     (?$(J#[(B . ?\x5448) ; <CJK>
     (?$(J#a(B . ?\x5759) ; <CJK>
     (?$(J#b(B . ?\x593F) ; <CJK>
     (?$(J#g(B . ?\x598B) ; <CJK>
     (?$(J#i(B . ?\x5991) ; <CJK>
     (?$(J#j(B . ?\x5995) ; <CJK>
     (?$(J#o(B . ?\x5B8A) ; <CJK>
     (?$(J#z(B . ?\x5C87) ; <CJK>
     (?$(J$#(B . ?\x5E0D) ; <CJK>
     (?$(J$((B . ?\x5E8E) ; <CJK>
     (?$(J$,(B . ?\x5F7A) ; <CJK>
     (?$(J$9(B . ?\x6290) ; <CJK>
     (?$(J$<(B . ?\x629A) ; <CJK>
     (?$(J$>(B . ?\x653C) ; <CJK>
     (?$(J$?(B . ?\x653A) ; <CJK>
     (?$(J$A(B . ?\x6598) ; <CJK>
     (?$(J$F(B . ?\x6765) ; <CJK>
     (?$(J$I(B . ?\x6740) ; <CJK>
     (?$(J$h(B . ?\x79C2) ; <CJK>
     (?$(J$l(B . ?\x8288) ; <CJK>
     (?$(J$p(B . ?\x809E) ; <CJK>
     (?$(J$s(B . ?\x81EB) ; <CJK>
     (?$(J$u(B . ?\x8289) ; <CJK>
     (?$(J$y(B . ?\x8296) ; <CJK>
     (?$(J${(B . ?\x8287) ; <CJK>
     (?$(J%!(B . ?\x8FC0) ; <CJK>
     (?$(J%#(B . ?\x8FC3) ; <CJK>
     (?$(J%+(B . ?\x9578) ; <CJK>
     (?$(J%.(B . ?\x9625) ; <CJK>
     (?$(J%0(B . ?\x4E75) ; <CJK>
     (?$(J%1(B . ?\x4E74) ; <CJK>
     (?$(J%6(B . ?\x4F99) ; <CJK>
     (?$(J%=(B . ?\x4FAE) ; <CJK>
     (?$(J%>(B . ?\x4F71) ; <CJK>
     (?$(J%?(B . ?\x5153) ; <CJK>
     (?$(J%@(B . ?\x51BF) ; <CJK>
     (?$(J%C(B . ?\x51C0) ; <CJK>
     (?$(J%E(B . ?\x51EE) ; <CJK>
     (?$(J%N(B . ?\x523D) ; <CJK>
     (?$(J%P(B . ?\x52BD) ; <CJK>
     (?$(J%Q(B . ?\x530C) ; <CJK>
     (?$(J%W(B . ?\x7F37) ; <CJK>
     (?$(J%Y(B . ?\x53C0) ; <CJK>
     (?$(J%_(B . ?\x546E) ; <CJK>
     (?$(J%`(B . ?\x5483) ; <CJK>
     (?$(J%c(B . ?\x545E) ; <CJK>
     (?$(J%d(B . ?\x545D) ; <CJK>
     (?$(J%e(B . ?\x577E) ; <CJK>
     (?$(J%f(B . ?\x5779) ; <CJK>
     (?$(J%h(B . ?\x577A) ; <CJK>
     (?$(J%i(B . ?\x576C) ; <CJK>
     (?$(J%n(B . ?\x5787) ; <CJK>
     (?$(J%p(B . ?\x591D) ; <CJK>
     (?$(J%r(B . ?\x5946) ; <CJK>
     (?$(J%u(B . ?\x5943) ; <CJK>
     (?$(J&"(B . ?\x5B61) ; <CJK>
     (?$(J&#(B . ?\x5B66) ; <CJK>
     (?$(J&)(B . ?\x5C29) ; <CJK>
     (?$(J&/(B . ?\x5CB2) ; <CJK>
     (?$(J&4(B . ?\x5CC0) ; <CJK>
     (?$(J&9(B . ?\x5E9F) ; <CJK>
     (?$(J&O(B . ?\x601F) ; <CJK>
     (?$(J&P(B . ?\x5FE2) ; <CJK>
     (?$(J&a(B . ?\x6616) ; <CJK>
     (?$(J&b(B . ?\x65F9) ; <CJK>
     (?$(J&e(B . ?\x6788) ; <CJK>
     (?$(J&g(B . ?\x679B) ; <CJK>
     (?$(J&i(B . ?\x676E) ; <CJK>
     (?$(J&j(B . ?\x679E) ; <CJK>
     (?$(J&q(B . ?\x6B24) ; <CJK>
     (?$(J&v(B . ?\x6B7D) ; <CJK>
     (?$(J&{(B . ?\x6CE6) ; <CJK>
     (?$(J&}(B . ?\x6CCB) ; <CJK>
     (?$(J'&(B . ?\x6CB5) ; <CJK>
     (?$(J')(B . ?\x7097) ; <CJK>
     (?$(J'+(B . ?\x709B) ; <CJK>
     (?$(J'1(B . ?\x726B) ; <CJK>
     (?$(J'6(B . ?\x72D5) ; <CJK>
     (?$(J'@(B . ?\x7543) ; <CJK>
     (?$(J'C(B . ?\x759C) ; <CJK>
     (?$(J'R(B . ?\x77E4) ; <CJK>
     (?$(J'[(B . ?\x7ACE) ; <CJK>
     (?$(J'a(B . ?\x8013) ; <CJK>
     (?$(J'd(B . ?\x80B7) ; <CJK>
     (?$(J'i(B . ?\x80B9) ; <CJK>
     (?$(J'j(B . ?\x80BB) ; <CJK>
     (?$(J'l(B . ?\x81E4) ; <CJK>
     (?$(J'm(B . ?\x81FD) ; <CJK>
     (?$(J'n(B . ?\x820F) ; <CJK>
     (?$(J'z(B . ?\x82BF) ; <CJK>
     (?$(J'{(B . ?\x82CA) ; <CJK>
     (?$(J'~(B . ?\x82C1) ; <CJK>
     (?$(J(&(B . ?\x8FD0) ; <CJK>
     (?$(J(+(B . ?\x90AE) ; <CJK>
     (?$(J(3(B . ?\x9638) ; <CJK>
     (?$(J(8(B . ?\x4FBC) ; <CJK>
     (?$(J(=(B . ?\x4FE9) ; <CJK>
     (?$(J(>(B . ?\x4FBD) ; <CJK>
     (?$(J(?(B . ?\x4FE2) ; <CJK>
     (?$(J(@(B . ?\x5158) ; <CJK>
     (?$(J(I(B . ?\x52C6) ; <CJK>
     (?$(J(K(B . ?\x52C8) ; <CJK>
     (?$(J(N(B . ?\x5328) ; <CJK>
     (?$(J(P(B . ?\x5329) ; <CJK>
     (?$(J(^(B . ?\x57B4) ; <CJK>
     (?$(J(`(B . ?\x57A9) ; <CJK>
     (?$(J(n(B . ?\x5B68) ; <CJK>
     (?$(J(}(B . ?\x5CD5) ; <CJK>
     (?$(J),(B . ?\x5F2B) ; <CJK>
     (?$(J)1(B . ?\x5F8D) ; <CJK>
     (?$(J)6(B . ?\x6018) ; <CJK>
     (?$(J)>(B . ?\x6057) ; <CJK>
     (?$(J)?(B . ?\x6048) ; <CJK>
     (?$(J)J(B . ?\x6094) ; <CJK>
     (?$(J)K(B . ?\x6071) ; <CJK>
     (?$(J)Q(B . ?\x6312) ; <CJK>
     (?$(J)Y(B . ?\x630A) ; <CJK>
     (?$(J)[(B . ?\x6323) ; <CJK>
     (?$(J)g(B . ?\x662A) ; <CJK>
     (?$(J)m(B . ?\x67E0) ; <CJK>
     (?$(J)n(B . ?\x67BE) ; <CJK>
     (?$(J)r(B . ?\x6B29) ; <CJK>
     (?$(J*!(B . ?\x6D43) ; <CJK>
     (?$(J*%(B . ?\x6D77) ; <CJK>
     (?$(J*&(B . ?\x70A6) ; <CJK>
     (?$(J*((B . ?\x70C0) ; <CJK>
     (?$(J**(B . ?\x722F) ; <CJK>
     (?$(J*/(B . ?\x7271) ; <CJK>
     (?$(J*<(B . ?\x74EA) ; <CJK>
     (?$(J*@(B . ?\x7520) ; <CJK>
     (?$(J*J(B . ?\x75A9) ; <CJK>
     (?$(J*L(B . ?\x7685) ; <CJK>
     (?$(J*R(B . ?\x7706) ; <CJK>
     (?$(J*U(B . ?\x76F6) ; <CJK>
     (?$(J*Y(B . ?\x7700) ; <CJK>
     (?$(J*](B . ?\x7702) ; <CJK>
     (?$(J*n(B . ?\x79CC) ; <CJK>
     (?$(J+%(B . ?\x8009) ; <CJK>
     (?$(J+:(B . ?\x82DA) ; <CJK>
     (?$(J+=(B . ?\x830A) ; <CJK>
     (?$(J+[(B . ?\x9655) ; <CJK>
     (?$(J+](B . ?\x9652) ; <CJK>
     (?$(J+^(B . ?\x4E35) ; <CJK>
     (?$(J+a(B . ?\x5034) ; <CJK>
     (?$(J+b(B . ?\x5001) ; <CJK>
     (?$(J+d(B . ?\x500A) ; <CJK>
     (?$(J+n(B . ?\x5258) ; <CJK>
     (?$(J+x(B . ?\x532B) ; <CJK>
     (?$(J,&(B . ?\x54EC) ; <CJK>
     (?$(J,((B . ?\x5515) ; <CJK>
     (?$(J,)(B . ?\x54FE) ; <CJK>
     (?$(J,-(B . ?\x54E3) ; <CJK>
     (?$(J,.(B . ?\x5516) ; <CJK>
     (?$(J,3(B . ?\x57D3) ; <CJK>
     (?$(J,8(B . ?\x5959) ; <CJK>
     (?$(J,9(B . ?\x5A27) ; <CJK>
     (?$(J,=(B . ?\x5A28) ; <CJK>
     (?$(J,>(B . ?\x5A10) ; <CJK>
     (?$(J,@(B . ?\x5A0E) ; <CJK>
     (?$(J,F(B . ?\x5BAF) ; <CJK>
     (?$(J,H(B . ?\x5BBA) ; <CJK>
     (?$(J,I(B . ?\x5BB1) ; <CJK>
     (?$(J,\(B . ?\x5CFC) ; <CJK>
     (?$(J,`(B . ?\x5CF2) ; <CJK>
     (?$(J,a(B . ?\x5CFE) ; <CJK>
     (?$(J,d(B . ?\x5DF8) ; <CJK>
     (?$(J,p(B . ?\x5F2C) ; <CJK>
     (?$(J-%(B . ?\x6082) ; <CJK>
     (?$(J-,(B . ?\x6091) ; <CJK>
     (?$(J--(B . ?\x608F) ; <CJK>
     (?$(J-C(B . ?\x6547) ; <CJK>
     (?$(J-D(B . ?\x654C) ; <CJK>
     (?$(J-F(B . ?\x654F) ; <CJK>
     (?$(J-G(B . ?\x658A) ; <CJK>
     (?$(J-N(B . ?\x67E1) ; <CJK>
     (?$(J-O(B . ?\x684A) ; <CJK>
     (?$(J-S(B . ?\x6857) ; <CJK>
     (?$(J-U(B . ?\x683F) ; <CJK>
     (?$(J-Y(B . ?\x67BD) ; <CJK>
     (?$(J-\(B . ?\x6885) ; <CJK>
     (?$(J-e(B . ?\x6BBA) ; <CJK>
     (?$(J-p(B . ?\x6D41) ; <CJK>
     (?$(J-u(B . ?\x70C9) ; <CJK>
     (?$(J.*(B . ?\x73BA) ; <CJK>
     (?$(J.4(B . ?\x75C6) ; <CJK>
     (?$(J.@(B . ?\x75B7) ; <CJK>
     (?$(J.A(B . ?\x768C) ; <CJK>
     (?$(J.C(B . ?\x768D) ; <CJK>
     (?$(J.O(B . ?\x7717) ; <CJK>
     (?$(J.Q(B . ?\x771C) ; <CJK>
     (?$(J.U(B . ?\x7714) ; <CJK>
     (?$(J.Y(B . ?\x781E) ; <CJK>
     (?$(J.q(B . ?\x7B0C) ; <CJK>
     (?$(J/%(B . ?\x7D23) ; <CJK>
     (?$(J//(B . ?\x7F98) ; <CJK>
     (?$(J/0(B . ?\x7F90) ; <CJK>
     (?$(J/:(B . ?\x803A) ; <CJK>
     (?$(J/O(B . ?\x8226) ; <CJK>
     (?$(J/Z(B . ?\x832E) ; <CJK>
     (?$(J/\(B . ?\x8355) ; <CJK>
     (?$(J/](B . ?\x831A) ; <CJK>
     (?$(J/_(B . ?\x833D) ; <CJK>
     (?$(J/c(B . ?\x8330) ; <CJK>
     (?$(J/h(B . ?\x8651) ; <CJK>
     (?$(J/u(B . ?\x898E) ; <CJK>
     (?$(J/v(B . ?\x898D) ; <CJK>
     (?$(J/|(B . ?\x8A09) ; <CJK>
     (?$(J/}(B . ?\x8A14) ; <CJK>
     (?$(J0/(B . ?\x9007) ; <CJK>
     (?$(J0:(B . ?\x9579) ; <CJK>
     (?$(J0;(B . ?\x9584) ; <CJK>
     (?$(J0?(B . ?\x9657) ; <CJK>
     (?$(J0A(B . ?\x96BA) ; <CJK>
     (?$(J0B(B . ?\x98E4) ; <CJK>
     (?$(J0G(B . ?\x5067) ; <CJK>
     (?$(J0^(B . ?\x5318) ; <CJK>
     (?$(J0_(B . ?\x532C) ; <CJK>
     (?$(J0`(B . ?\x5359) ; <CJK>
     (?$(J0d(B . ?\x5368) ; <CJK>
     (?$(J0e(B . ?\x537E) ; <CJK>
     (?$(J0h(B . ?\x53A1) ; <CJK>
     (?$(J0k(B . ?\x555B) ; <CJK>
     (?$(J0r(B . ?\x5542) ; <CJK>
     (?$(J0t(B . ?\x5547) ; <CJK>
     (?$(J0w(B . ?\x553D) ; <CJK>
     (?$(J0z(B . ?\x5560) ; <CJK>
     (?$(J0{(B . ?\x57EB) ; <CJK>
     (?$(J1&(B . ?\x595F) ; <CJK>
     (?$(J1,(B . ?\x5B6F) ; <CJK>
     (?$(J15(B . ?\x5C5A) ; <CJK>
     (?$(J1R(B . ?\x5FA2) ; <CJK>
     (?$(J1S(B . ?\x5F9D) ; <CJK>
     (?$(J1W(B . ?\x5FA3) ; <CJK>
     (?$(J1h(B . ?\x60C2) ; <CJK>
     (?$(J1k(B . ?\x60A5) ; <CJK>
     (?$(J1n(B . ?\x621C) ; <CJK>
     (?$(J1p(B . ?\x621D) ; <CJK>
     (?$(J1w(B . ?\x6395) ; <CJK>
     (?$(J1x(B . ?\x639A) ; <CJK>
     (?$(J2#(B . ?\x63A6) ; <CJK>
     (?$(J2+(B . ?\x6550) ; <CJK>
     (?$(J2/(B . ?\x6552) ; <CJK>
     (?$(J24(B . ?\x65C8) ; <CJK>
     (?$(J29(B . ?\x6658) ; <CJK>
     (?$(J2>(B . ?\x6717) ; <CJK>
     (?$(J2?(B . ?\x6888) ; <CJK>
     (?$(J2N(B . ?\x6BB8) ; <CJK>
     (?$(J2P(B . ?\x6BB9) ; <CJK>
     (?$(J2m(B . ?\x6E0B) ; <CJK>
     (?$(J2r(B . ?\x7105) ; <CJK>
     (?$(J3"(B . ?\x7314) ; <CJK>
     (?$(J3#(B . ?\x7304) ; <CJK>
     (?$(J3*(B . ?\x7305) ; <CJK>
     (?$(J3,(B . ?\x7315) ; <CJK>
     (?$(J3-(B . ?\x730D) ; <CJK>
     (?$(J3O(B . ?\x772E) ; <CJK>
     (?$(J3V(B . ?\x7741) ; <CJK>
     (?$(J3[(B . ?\x77EA) ; <CJK>
     (?$(J3](B . ?\x7844) ; <CJK>
     (?$(J3z(B . ?\x7B29) ; <CJK>
     (?$(J3|(B . ?\x7B27) ; <CJK>
     (?$(J4"(B . ?\x7C9D) ; <CJK>
     (?$(J4=(B . ?\x7FC8) ; <CJK>
     (?$(J4G(B . ?\x8126) ; <CJK>
     (?$(J4M(B . ?\x811C) ; <CJK>
     (?$(J4P(B . ?\x8128) ; <CJK>
     (?$(J4g(B . ?\x8370) ; <CJK>
     (?$(J4m(B . ?\x8382) ; <CJK>
     (?$(J4o(B . ?\x83AC) ; <CJK>
     (?$(J4z(B . ?\x86AD) ; <CJK>
     (?$(J5&(B . ?\x86CA) ; <CJK>
     (?$(J5'(B . ?\x8851) ; <CJK>
     (?$(J5/(B . ?\x889D) ; <CJK>
     (?$(J54(B . ?\x8990) ; <CJK>
     (?$(J58(B . ?\x89D8) ; <CJK>
     (?$(J59(B . ?\x89D7) ; <CJK>
     (?$(J5=(B . ?\x8A2E) ; <CJK>
     (?$(J5M(B . ?\x8C59) ; <CJK>
     (?$(J5c(B . ?\x8EDA) ; <CJK>
     (?$(J5f(B . ?\x9033) ; <CJK>
     (?$(J5h(B . ?\x9018) ; <CJK>
     (?$(J5{(B . ?\x91EF) ; <CJK>
     (?$(J6-(B . ?\x9AD9) ; <CJK>
     (?$(J6.(B . ?\x4EB4) ; <CJK>
     (?$(J60(B . ?\x50A0) ; <CJK>
     (?$(J61(B . ?\x5090) ; <CJK>
     (?$(J63(B . ?\x5086) ; <CJK>
     (?$(J64(B . ?\x5084) ; <CJK>
     (?$(J66(B . ?\x508A) ; <CJK>
     (?$(J69(B . ?\x509F) ; <CJK>
     (?$(J6:(B . ?\x50A1) ; <CJK>
     (?$(J6<(B . ?\x5093) ; <CJK>
     (?$(J6?(B . ?\x51D5) ; <CJK>
     (?$(J6L(B . ?\x52E4) ; <CJK>
     (?$(J6\(B . ?\x5590) ; <CJK>
     (?$(J6h(B . ?\x5710) ; <CJK>
     (?$(J6i(B . ?\x5817) ; <CJK>
     (?$(J6m(B . ?\x5844) ; <CJK>
     (?$(J6o(B . ?\x582B) ; <CJK>
     (?$(J6q(B . ?\x5845) ; <CJK>
     (?$(J6v(B . ?\x5832) ; <CJK>
     (?$(J6y(B . ?\x5965) ; <CJK>
     (?$(J7$(B . ?\x5BCF) ; <CJK>
     (?$(J7/(B . ?\x5D56) ; <CJK>
     (?$(J75(B . ?\x5D54) ; <CJK>
     (?$(J7E(B . ?\x5F3D) ; <CJK>
     (?$(J7J(B . ?\x5FA4) ; <CJK>
     (?$(J7`(B . ?\x63EC) ; <CJK>
     (?$(J7o(B . ?\x63FA) ; <CJK>
     (?$(J7q(B . ?\x63D4) ; <CJK>
     (?$(J8$(B . ?\x6675) ; <CJK>
     (?$(J8)(B . ?\x671C) ; <CJK>
     (?$(J82(B . ?\x68D9) ; <CJK>
     (?$(J8N(B . ?\x6BF1) ; <CJK>
     (?$(J8[(B . ?\x6E37) ; <CJK>
     (?$(J8\(B . ?\x6E7C) ; <CJK>
     (?$(J8^(B . ?\x6E7D) ; <CJK>
     (?$(J8_(B . ?\x6E86) ; <CJK>
     (?$(J9%(B . ?\x74FA) ; <CJK>
     (?$(J9,(B . ?\x7572) ; <CJK>
     (?$(J94(B . ?\x75DC) ; <CJK>
     (?$(J9T(B . ?\x7867) ; <CJK>
     (?$(J9Z(B . ?\x7977) ; <CJK>
     (?$(J9[(B . ?\x79BC) ; <CJK>
     (?$(J9e(B . ?\x7A9B) ; <CJK>
     (?$(J:&(B . ?\x7D2A) ; <CJK>
     (?$(J:'(B . ?\x7D65) ; <CJK>
     (?$(J:+(B . ?\x7F64) ; <CJK>
     (?$(J:8(B . ?\x8020) ; <CJK>
     (?$(J:;(B . ?\x8120) ; <CJK>
     (?$(J:>(B . ?\x813C) ; <CJK>
     (?$(J:G(B . ?\x813F) ; <CJK>
     (?$(J:L(B . ?\x81F0) ; <CJK>
     (?$(J:M(B . ?\x81F5) ; <CJK>
     (?$(J:g(B . ?\x8415) ; <CJK>
     (?$(J:h(B . ?\x83BE) ; <CJK>
     (?$(J:o(B . ?\x86E5) ; <CJK>
     (?$(J:q(B . ?\x86D2) ; <CJK>
     (?$(J:u(B . ?\x8688) ; <CJK>
     (?$(J:v(B . ?\x86E0) ; <CJK>
     (?$(J:{(B . ?\x88B3) ; <CJK>
     (?$(J;,(B . ?\x8A53) ; <CJK>
     (?$(J;/(B . ?\x8A37) ; <CJK>
     (?$(J;0(B . ?\x8A47) ; <CJK>
     (?$(J;1(B . ?\x8A5C) ; <CJK>
     (?$(J;U(B . ?\x8EF0) ; <CJK>
     (?$(J;f(B . ?\x921D) ; <CJK>
     (?$(J;w(B . ?\x976B) ; <CJK>
     (?$(J<)(B . ?\x50C0) ; <CJK>
     (?$(J<0(B . ?\x50E7) ; <CJK>
     (?$(J<<(B . ?\x52E5) ; <CJK>
     (?$(J<@(B . ?\x53AF) ; <CJK>
     (?$(J<K(B . ?\x55D8) ; <CJK>
     (?$(J<R(B . ?\x5711) ; <CJK>
     (?$(J<S(B . ?\x5867) ; <CJK>
     (?$(J<W(B . ?\x5843) ; <CJK>
     (?$(J<n(B . ?\x5BDD) ; <CJK>
     (?$(J<t(B . ?\x5D70) ; <CJK>
     (?$(J<u(B . ?\x5D6A) ; <CJK>
     (?$(J<x(B . ?\x5D74) ; <CJK>
     (?$(J<y(B . ?\x5D5F) ; <CJK>
     (?$(J<{(B . ?\x5D61) ; <CJK>
     (?$(J<|(B . ?\x5D73) ; <CJK>
     (?$(J=*(B . ?\x5E50) ; <CJK>
     (?$(J=0(B . ?\x5F3F) ; <CJK>
     (?$(J=4(B . ?\x5FB0) ; <CJK>
     (?$(J=8(B . ?\x6135) ; <CJK>
     (?$(J=9(B . ?\x612D) ; <CJK>
     (?$(J==(B . ?\x6102) ; <CJK>
     (?$(J=C(B . ?\x6226) ; <CJK>
     (?$(J=](B . ?\x656E) ; <CJK>
     (?$(J=d(B . ?\x65D4) ; <CJK>
     (?$(J=i(B . ?\x6685) ; <CJK>
     (?$(J=l(B . ?\x6972) ; <CJK>
     (?$(J=q(B . ?\x693A) ; <CJK>
     (?$(J>6(B . ?\x6EAD) ; <CJK>
     (?$(J>?(B . ?\x6E95) ; <CJK>
     (?$(J>L(B . ?\x7243) ; <CJK>
     (?$(J>O(B . ?\x728F) ; <CJK>
     (?$(J>k(B . ?\x7575) ; <CJK>
     (?$(J>w(B . ?\x75EC) ; <CJK>
     (?$(J?)(B . ?\x7757) ; <CJK>
     (?$(J?F(B . ?\x797B) ; <CJK>
     (?$(J?J(B . ?\x7A21) ; <CJK>
     (?$(J?P(B . ?\x7A16) ; <CJK>
     (?$(J?W(B . ?\x7AE8) ; <CJK>
     (?$(J?^(B . ?\x7B6A) ; <CJK>
     (?$(J?g(B . ?\x7B5F) ; <CJK>
     (?$(J?q(B . ?\x7D82) ; <CJK>
     (?$(J?s(B . ?\x7DD0) ; <CJK>
     (?$(J?|(B . ?\x8055) ; <CJK>
     (?$(J@)(B . ?\x8168) ; <CJK>
     (?$(J@-(B . ?\x8246) ; <CJK>
     (?$(J@.(B . ?\x8243) ; <CJK>
     (?$(J@6(B . ?\x8481) ; <CJK>
     (?$(J@A(B . ?\x847C) ; <CJK>
     (?$(J@D(B . ?\x846A) ; <CJK>
     (?$(J@F(B . ?\x8488) ; <CJK>
     (?$(J@O(B . ?\x865C) ; <CJK>
     (?$(J@R(B . ?\x8710) ; <CJK>
     (?$(J@U(B . ?\x871F) ; <CJK>
     (?$(J@Y(B . ?\x870F) ; <CJK>
     (?$(J@a(B . ?\x88D3) ; <CJK>
     (?$(J@x(B . ?\x8C87) ; <CJK>
     (?$(J@~(B . ?\x8CC6) ; <CJK>
     (?$(JA9(B . ?\x90CC) ; <CJK>
     (?$(JA:(B . ?\x916D) ; <CJK>
     (?$(JA;(B . ?\x9170) ; <CJK>
     (?$(JA@(B . ?\x9258) ; <CJK>
     (?$(JAA(B . ?\x9242) ; <CJK>
     (?$(JAB(B . ?\x9268) ; <CJK>
     (?$(JAC(B . ?\x9269) ; <CJK>
     (?$(JAF(B . ?\x9243) ; <CJK>
     (?$(JAH(B . ?\x9247) ; <CJK>
     (?$(JAS(B . ?\x959D) ; <CJK>
     (?$(JAW(B . ?\x96CF) ; <CJK>
     (?$(JAc(B . ?\x97F4) ; <CJK>
     (?$(JAh(B . ?\x9809) ; <CJK>
     (?$(JAq(B . ?\x98AB) ; <CJK>
     (?$(JA{(B . ?\x98FB) ; <CJK>
     (?$(JA}(B . ?\x9AAC) ; <CJK>
     (?$(JA~(B . ?\x9AAE) ; <CJK>
     (?$(JB!(B . ?\x9AAA) ; <CJK>
     (?$(JB)(B . ?\x9B5C) ; <CJK>
     (?$(JB-(B . ?\x50D2) ; <CJK>
     (?$(JB5(B . ?\x50DF) ; <CJK>
     (?$(JBK(B . ?\x5619) ; <CJK>
     (?$(JBW(B . ?\x560A) ; <CJK>
     (?$(JBY(B . ?\x589A) ; <CJK>
     (?$(JBz(B . ?\x5C32) ; <CJK>
     (?$(JC,(B . ?\x5D85) ; <CJK>
     (?$(JC0(B . ?\x5E56) ; <CJK>
     (?$(JC5(B . ?\x5E51) ; <CJK>
     (?$(JC?(B . ?\x5FB1) ; <CJK>
     (?$(JCQ(B . ?\x618E) ; <CJK>
     (?$(JC](B . ?\x645A) ; <CJK>
     (?$(JC^(B . ?\x6463) ; <CJK>
     (?$(JCk(B . ?\x669B) ; <CJK>
     (?$(JCm(B . ?\x66A3) ; <CJK>
     (?$(JCo(B . ?\x669E) ; <CJK>
     (?$(JCw(B . ?\x69B8) ; <CJK>
     (?$(JCy(B . ?\x69BA) ; <CJK>
     (?$(JD'(B . ?\x69C7) ; <CJK>
     (?$(JD((B . ?\x69D7) ; <CJK>
     (?$(JD-(B . ?\x6B70) ; <CJK>
     (?$(JD1(B . ?\x6B9D) ; <CJK>
     (?$(JDC(B . ?\x6F16) ; <CJK>
     (?$(JDD(B . ?\x6F24) ; <CJK>
     (?$(JDR(B . ?\x6F45) ; <CJK>
     (?$(JDW(B . ?\x7179) ; <CJK>
     (?$(JDX(B . ?\x7193) ; <CJK>
     (?$(JD[(B . ?\x717A) ; <CJK>
     (?$(JD^(B . ?\x7254) ; <CJK>
     (?$(JD{(B . ?\x757C) ; <CJK>
     (?$(JD|(B . ?\x757B) ; <CJK>
     (?$(JD~(B . ?\x7612) ; <CJK>
     (?$(JE4(B . ?\x76B6) ; <CJK>
     (?$(JE5(B . ?\x76E0) ; <CJK>
     (?$(JE=(B . ?\x7773) ; <CJK>
     (?$(JE@(B . ?\x7772) ; <CJK>
     (?$(JEB(B . ?\x7770) ; <CJK>
     (?$(JES(B . ?\x789D) ; <CJK>
     (?$(JE](B . ?\x7A27) ; <CJK>
     (?$(JE^(B . ?\x7A35) ; <CJK>
     (?$(JEd(B . ?\x7BA2) ; <CJK>
     (?$(JEk(B . ?\x7B89) ; <CJK>
     (?$(JEp(B . ?\x7BA5) ; <CJK>
     (?$(JEt(B . ?\x7CB6) ; <CJK>
     (?$(JE{(B . ?\x7DA5) ; <CJK>
     (?$(JE|(B . ?\x7DC3) ; <CJK>
     (?$(JF&(B . ?\x7FAB) ; <CJK>
     (?$(JF,(B . ?\x8025) ; <CJK>
     (?$(JF3(B . ?\x8059) ; <CJK>
     (?$(JF9(B . ?\x8185) ; <CJK>
     (?$(JFF(B . ?\x818E) ; <CJK>
     (?$(JFX(B . ?\x84BE) ; <CJK>
     (?$(JFl(B . ?\x84A6) ; <CJK>
     (?$(JF~(B . ?\x872F) ; <CJK>
     (?$(JG5(B . ?\x89A0) ; <CJK>
     (?$(JGE(B . ?\x8A97) ; <CJK>
     (?$(JGT(B . ?\x8C8B) ; <CJK>
     (?$(JGj(B . ?\x8F0F) ; <CJK>
     (?$(JGu(B . ?\x9275) ; <CJK>
     (?$(JGw(B . ?\x929F) ; <CJK>
     (?$(JH"(B . ?\x95A6) ; <CJK>
     (?$(JH$(B . ?\x969A) ; <CJK>
     (?$(JH5(B . ?\x9757) ; <CJK>
     (?$(JHF(B . ?\x97F7) ; <CJK>
     (?$(JHW(B . ?\x98B0) ; <CJK>
     (?$(JH`(B . ?\x99C6) ; <CJK>
     (?$(JHk(B . ?\x9B62) ; <CJK>
     (?$(JHy(B . ?\x50FA) ; <CJK>
     (?$(JI%(B . ?\x5285) ; <CJK>
     (?$(JI.(B . ?\x5643) ; <CJK>
     (?$(JI1(B . ?\x563C) ; <CJK>
     (?$(JI2(B . ?\x5668) ; <CJK>
     (?$(JID(B . ?\x5BED) ; <CJK>
     (?$(JII(B . ?\x5C35) ; <CJK>
     (?$(JI^(B . ?\x5F47) ; <CJK>
     (?$(JIo(B . ?\x616D) ; <CJK>
     (?$(JJ'(B . ?\x649D) ; <CJK>
     (?$(JJ=(B . ?\x69F5) ; <CJK>
     (?$(JJH(B . ?\x6A03) ; <CJK>
     (?$(JJK(B . ?\x6A65) ; <CJK>
     (?$(JJN(B . ?\x6B75) ; <CJK>
     (?$(JJW(B . ?\x6F8A) ; <CJK>
     (?$(JJX(B . ?\x6F56) ; <CJK>
     (?$(JJd(B . ?\x6F98) ; <CJK>
     (?$(JJi(B . ?\x6F68) ; <CJK>
     (?$(JJl(B . ?\x7234) ; <CJK>
     (?$(JJm(B . ?\x7245) ; <CJK>
     (?$(JJu(B . ?\x735C) ; <CJK>
     (?$(JJw(B . ?\x7356) ; <CJK>
     (?$(JKW(B . ?\x78BF) ; <CJK>
     (?$(JKY(B . ?\x78BD) ; <CJK>
     (?$(JK](B . ?\x78E4) ; <CJK>
     (?$(JKc(B . ?\x7A34) ; <CJK>
     (?$(JKk(B . ?\x7A36) ; <CJK>
     (?$(JKs(B . ?\x7BBA) ; <CJK>
     (?$(JKt(B . ?\x7BBC) ; <CJK>
     (?$(JKv(B . ?\x7BC8) ; <CJK>
     (?$(JKx(B . ?\x7BC3) ; <CJK>
     (?$(JKz(B . ?\x7BB6) ; <CJK>
     (?$(JL!(B . ?\x7BC2) ; <CJK>
     (?$(JL&(B . ?\x7BC5) ; <CJK>
     (?$(JL*(B . ?\x7BBD) ; <CJK>
     (?$(JL+(B . ?\x7BB0) ; <CJK>
     (?$(JL1(B . ?\x7BBB) ; <CJK>
     (?$(JLE(B . ?\x7E04) ; <CJK>
     (?$(JLb(B . ?\x81F1) ; <CJK>
     (?$(JLj(B . ?\x8522) ; <CJK>
     (?$(JLx(B . ?\x8532) ; <CJK>
     (?$(JLz(B . ?\x8510) ; <CJK>
     (?$(JM%(B . ?\x854F) ; <CJK>
     (?$(JM((B . ?\x8772) ; <CJK>
     (?$(JM1(B . ?\x877C) ; <CJK>
     (?$(JM3(B . ?\x8779) ; <CJK>
     (?$(JM>(B . ?\x890D) ; <CJK>
     (?$(JMF(B . ?\x8908) ; <CJK>
     (?$(JMu(B . ?\x8D9E) ; <CJK>
     (?$(JN+(B . ?\x8F28) ; <CJK>
     (?$(JN-(B . ?\x8F21) ; <CJK>
     (?$(JN2(B . ?\x9066) ; <CJK>
     (?$(JN3(B . ?\x906C) ; <CJK>
     (?$(JN;(B . ?\x90F6) ; <CJK>
     (?$(JND(B . ?\x92EC) ; <CJK>
     (?$(JNE(B . ?\x92BA) ; <CJK>
     (?$(JNF(B . ?\x92E3) ; <CJK>
     (?$(JNG(B . ?\x92BD) ; <CJK>
     (?$(JNJ(B . ?\x95B4) ; <CJK>
     (?$(JNW(B . ?\x97D1) ; <CJK>
     (?$(JNZ(B . ?\x9823) ; <CJK>
     (?$(JNc(B . ?\x990B) ; <CJK>
     (?$(JNt(B . ?\x9AB2) ; <CJK>
     (?$(JNy(B . ?\x9ADB) ; <CJK>
     (?$(JO!(B . ?\x9AF0) ; <CJK>
     (?$(JO*(B . ?\x9B73) ; <CJK>
     (?$(JO,(B . ?\x9B6E) ; <CJK>
     (?$(JO0(B . ?\x9B65) ; <CJK>
     (?$(JO5(B . ?\x9B6A) ; <CJK>
     (?$(JO7(B . ?\x9B6D) ; <CJK>
     (?$(JOB(B . ?\x9D0B) ; <CJK>
     (?$(JOH(B . ?\x9E76) ; <CJK>
     (?$(JOL(B . ?\x9EA8) ; <CJK>
     (?$(JOV(B . ?\x9F11) ; <CJK>
     (?$(JOZ(B . ?\x5119) ; <CJK>
     (?$(JOd(B . ?\x5292) ; <CJK>
     (?$(JOq(B . ?\x5675) ; <CJK>
     (?$(JO{(B . ?\x596F) ; <CJK>
     (?$(JP7(B . ?\x61A5) ; <CJK>
     (?$(JP;(B . ?\x61A0) ; <CJK>
     (?$(JPI(B . ?\x657E) ; <CJK>
     (?$(JPN(B . ?\x65B4) ; <CJK>
     (?$(JPO(B . ?\x65D8) ; <CJK>
     (?$(JPP(B . ?\x66C2) ; <CJK>
     (?$(JPm(B . ?\x6BA8) ; <CJK>
     (?$(JPu(B . ?\x6F83) ; <CJK>
     (?$(JQ"(B . ?\x6FC5) ; <CJK>
     (?$(JQ#(B . ?\x71CD) ; <CJK>
     (?$(JQ-(B . ?\x729C) ; <CJK>
     (?$(JQ8(B . ?\x7499) ; <CJK>
     (?$(JQ9(B . ?\x748F) ; <CJK>
     (?$(JQ:(B . ?\x7491) ; <CJK>
     (?$(JQM(B . ?\x7639) ; <CJK>
     (?$(JQO(B . ?\x762E) ; <CJK>
     (?$(JQT(B . ?\x769F) ; <CJK>
     (?$(JQU(B . ?\x76A0) ; <CJK>
     (?$(JQ_(B . ?\x7794) ; <CJK>
     (?$(JQa(B . ?\x77AE) ; <CJK>
     (?$(JQn(B . ?\x78E6) ; <CJK>
     (?$(JR'(B . ?\x7ABC) ; <CJK>
     (?$(JR-(B . ?\x7BD6) ; <CJK>
     (?$(JRD(B . ?\x7CCF) ; <CJK>
     (?$(JRL(B . ?\x7E18) ; <CJK>
     (?$(JR\(B . ?\x806D) ; <CJK>
     (?$(JRg(B . ?\x8190) ; <CJK>
     (?$(JS$(B . ?\x8552) ; <CJK>
     (?$(JS3(B . ?\x8550) ; <CJK>
     (?$(JS9(B . ?\x87A0) ; <CJK>
     (?$(JS<(B . ?\x8786) ; <CJK>
     (?$(JSA(B . ?\x8795) ; <CJK>
     (?$(JSD(B . ?\x878C) ; <CJK>
     (?$(JSK(B . ?\x8860) ; <CJK>
     (?$(JSL(B . ?\x8860) ; <CJK>
     (?$(JSP(B . ?\x8928) ; <CJK>
     (?$(JSS(B . ?\x8920) ; <CJK>
     (?$(JSY(B . ?\x89A8) ; <CJK>
     (?$(JT)(B . ?\x8E3A) ; <CJK>
     (?$(JTB(B . ?\x9194) ; <CJK>
     (?$(JTC(B . ?\x9311) ; <CJK>
     (?$(JTE(B . ?\x9337) ; <CJK>
     (?$(JTI(B . ?\x9343) ; <CJK>
     (?$(JTR(B . ?\x96A6) ; <CJK>
     (?$(JT_(B . ?\x9795) ; <CJK>
     (?$(JTg(B . ?\x9796) ; <CJK>
     (?$(JTp(B . ?\x9825) ; <CJK>
     (?$(JT~(B . ?\x9926) ; <CJK>
     (?$(JU!(B . ?\x9934) ; <CJK>
     (?$(JU1(B . ?\x9ABA) ; <CJK>
     (?$(JUC(B . ?\x9B81) ; <CJK>
     (?$(JUE(B . ?\x9B8A) ; <CJK>
     (?$(JUG(B . ?\x9B7F) ; <CJK>
     (?$(JUR(B . ?\x9D11) ; <CJK>
     (?$(JU`(B . ?\x9ED9) ; <CJK>
     (?$(JUc(B . ?\x9F3C) ; <CJK>
     (?$(JUe(B . ?\x5123) ; <CJK>
     (?$(JUi(B . ?\x512C) ; <CJK>
     (?$(JUm(B . ?\x5295) ; <CJK>
     (?$(JUt(B . ?\x5688) ; <CJK>
     (?$(JUx(B . ?\x568B) ; <CJK>
     (?$(JV2(B . ?\x61E1) ; <CJK>
     (?$(JV3(B . ?\x61D7) ; <CJK>
     (?$(JV?(B . ?\x65A3) ; <CJK>
     (?$(JVA(B . ?\x66D3) ; <CJK>
     (?$(JVE(B . ?\x6A8B) ; <CJK>
     (?$(JVR(B . ?\x6BAC) ; <CJK>
     (?$(JV](B . ?\x701E) ; <CJK>
     (?$(JVl(B . ?\x7374) ; <CJK>
     (?$(JW!(B . ?\x7640) ; <CJK>
     (?$(JW$(B . ?\x7641) ; <CJK>
     (?$(JW-(B . ?\x76E8) ; <CJK>
     (?$(JW>(B . ?\x78F6) ; <CJK>
     (?$(JW@(B . ?\x7900) ; <CJK>
     (?$(JWH(B . ?\x7A59) ; <CJK>
     (?$(JWI(B . ?\x7A55) ; <CJK>
     (?$(JWP(B . ?\x7AF4) ; <CJK>
     (?$(JWT(B . ?\x7C04) ; <CJK>
     (?$(JWW(B . ?\x7C15) ; <CJK>
     (?$(JW_(B . ?\x7BF5) ; <CJK>
     (?$(JX'(B . ?\x81C1) ; <CJK>
     (?$(JX>(B . ?\x857D) ; <CJK>
     (?$(JX@(B . ?\x85A5) ; <CJK>
     (?$(JXb(B . ?\x893A) ; <CJK>
     (?$(JY-(B . ?\x8E51) ; <CJK>
     (?$(JY?(B . ?\x9198) ; <CJK>
     (?$(JYF(B . ?\x9384) ; <CJK>
     (?$(JYG(B . ?\x9381) ; <CJK>
     (?$(JYI(B . ?\x936F) ; <CJK>
     (?$(JYp(B . ?\x9842) ; <CJK>
     (?$(JZ)(B . ?\x9937) ; <CJK>
     (?$(JZ7(B . ?\x9AFF) ; <CJK>
     (?$(JZ?(B . ?\x9BA9) ; <CJK>
     (?$(JZA(B . ?\x9BA7) ; <CJK>
     (?$(JZC(B . ?\x9BB3) ; <CJK>
     (?$(JZD(B . ?\x9BAC) ; <CJK>
     (?$(JZE(B . ?\x9BB0) ; <CJK>
     (?$(JZI(B . ?\x9B9C) ; <CJK>
     (?$(JZM(B . ?\x9D3C) ; <CJK>
     (?$(JZN(B . ?\x9D1C) ; <CJK>
     (?$(JZO(B . ?\x9D3A) ; <CJK>
     (?$(JZU(B . ?\x9D32) ; <CJK>
     (?$(JZV(B . ?\x9D34) ; <CJK>
     (?$(JZ](B . ?\x9EC7) ; <CJK>
     (?$(JZd(B . ?\x9F3F) ; <CJK>
     (?$(J[!(B . ?\x5EEB) ; <CJK>
     (?$(J[+(B . ?\x61D5) ; <CJK>
     (?$(J[6(B . ?\x6502) ; <CJK>
     (?$(J[^(B . ?\x7012) ; <CJK>
     (?$(J[t(B . ?\x7585) ; <CJK>
     (?$(J[u(B . ?\x7654) ; <CJK>
     (?$(J[y(B . ?\x7655) ; <CJK>
     (?$(J[|(B . ?\x76A7) ; <CJK>
     (?$(J[}(B . ?\x76A8) ; <CJK>
     (?$(J\2(B . ?\x790F) ; <CJK>
     (?$(J\Z(B . ?\x7CE4) ; <CJK>
     (?$(J\[(B . ?\x7CE5) ; <CJK>
     (?$(J\^(B . ?\x7E65) ; <CJK>
     (?$(J\_(B . ?\x7E4E) ; <CJK>
     (?$(J\h(B . ?\x7F82) ; <CJK>
     (?$(J\q(B . ?\x802D) ; <CJK>
     (?$(J]((B . ?\x85CA) ; <CJK>
     (?$(J],(B . ?\x85BC) ; <CJK>
     (?$(J]i(B . ?\x8CFF) ; <CJK>
     (?$(J^$(B . ?\x91A6) ; <CJK>
     (?$(J^)(B . ?\x93B6) ; <CJK>
     (?$(J^1(B . ?\x93AB) ; <CJK>
     (?$(J^8(B . ?\x9721) ; <CJK>
     (?$(J^C(B . ?\x97A7) ; <CJK>
     (?$(J^O(B . ?\x983E) ; <CJK>
     (?$(J_"(B . ?\x9BBC) ; <CJK>
     (?$(J_&(B . ?\x9BB7) ; <CJK>
     (?$(J_*(B . ?\x9BBE) ; <CJK>
     (?$(J_4(B . ?\x9D62) ; <CJK>
     (?$(J_:(B . ?\x9E8F) ; <CJK>
     (?$(J_>(B . ?\x9ECB) ; <CJK>
     (?$(J_M(B . ?\x56A9) ; <CJK>
     (?$(J_R(B . ?\x5913) ; <CJK>
     (?$(J_U(B . ?\x5BF4) ; <CJK>
     (?$(J_`(B . ?\x61EC) ; <CJK>
     (?$(J_a(B . ?\x61EF) ; <CJK>
     (?$(J_q(B . ?\x6AD6) ; <CJK>
     (?$(J_~(B . ?\x7209) ; <CJK>
     (?$(J`%(B . ?\x7379) ; <CJK>
     (?$(J`'(B . ?\x74C6) ; <CJK>
     (?$(J`9(B . ?\x77C3) ; <CJK>
     (?$(J`B(B . ?\x791F) ; <CJK>
     (?$(J`E(B . ?\x7A65) ; <CJK>
     (?$(J`K(B . ?\x7AC6) ; <CJK>
     (?$(J`L(B . ?\x7C3A) ; <CJK>
     (?$(J`N(B . ?\x7C36) ; <CJK>
     (?$(J`Z(B . ?\x7CEB) ; <CJK>
     (?$(J`j(B . ?\x7CED) ; <CJK>
     (?$(J`o(B . ?\x7F84) ; <CJK>
     (?$(J`z(B . ?\x85E0) ; <CJK>
     (?$(J`{(B . ?\x85F3) ; <CJK>
     (?$(Ja&(B . ?\x881E) ; <CJK>
     (?$(Ja/(B . ?\x89B4) ; <CJK>
     (?$(Ja7(B . ?\x89F9) ; <CJK>
     (?$(Ja:(B . ?\x8B44) ; <CJK>
     (?$(JaO(B . ?\x8E71) ; <CJK>
     (?$(JaT(B . ?\x8E79) ; <CJK>
     (?$(JaV(B . ?\x8EC4) ; <CJK>
     (?$(Ja_(B . ?\x908C) ; <CJK>
     (?$(Jag(B . ?\x93C9) ; <CJK>
     (?$(Ja|(B . ?\x97B0) ; <CJK>
     (?$(Jb0(B . ?\x985A) ; <CJK>
     (?$(Jb8(B . ?\x9946) ; <CJK>
     (?$(JbI(B . ?\x9AC3) ; <CJK>
     (?$(JbO(B . ?\x9B0F) ; <CJK>
     (?$(JbU(B . ?\x9BF4) ; <CJK>
     (?$(JbV(B . ?\x9BFA) ; <CJK>
     (?$(Jb\(B . ?\x9BDD) ; <CJK>
     (?$(Jbf(B . ?\x9BED) ; <CJK>
     (?$(Jbh(B . ?\x9BEF) ; <CJK>
     (?$(Jbu(B . ?\x9E96) ; <CJK>
     (?$(Jb~(B . ?\x9EB3) ; <CJK>
     (?$(Jc-(B . ?\x9F8F) ; <CJK>
     (?$(Jc1(B . ?\x56B1) ; <CJK>
     (?$(Jc4(B . ?\x5B41) ; <CJK>
     (?$(Jc9(B . ?\x5E71) ; <CJK>
     (?$(JcN(B . ?\x6AF6) ; <CJK>
     (?$(JcP(B . ?\x6AF2) ; <CJK>
     (?$(Jch(B . ?\x7588) ; <CJK>
     (?$(Jd,(B . ?\x8267) ; <CJK>
     (?$(Jd7(B . ?\x860E) ; <CJK>
     (?$(JdM(B . ?\x8B5E) ; <CJK>
     (?$(JdO(B . ?\x8D0E) ; <CJK>
     (?$(Jde(B . ?\x91B6) ; <CJK>
     (?$(Jdg(B . ?\x9401) ; <CJK>
     (?$(Jdk(B . ?\x941D) ; <CJK>
     (?$(Jdo(B . ?\x942F) ; <CJK>
     (?$(Je'(B . ?\x97E0) ; <CJK>
     (?$(Je)(B . ?\x97DB) ; <CJK>
     (?$(Je*(B . ?\x97E0) ; <CJK>
     (?$(Je,(B . ?\x9861) ; <CJK>
     (?$(Je:(B . ?\x994A) ; <CJK>
     (?$(JeF(B . ?\x9A33) ; <CJK>
     (?$(JeT(B . ?\x9C0F) ; <CJK>
     (?$(JeW(B . ?\x9C11) ; <CJK>
     (?$(JeY(B . ?\x9C03) ; <CJK>
     (?$(JeZ(B . ?\x9C01) ; <CJK>
     (?$(Je](B . ?\x9C16) ; <CJK>
     (?$(Jei(B . ?\x9D93) ; <CJK>
     (?$(Jf0(B . ?\x535B) ; <CJK>
     (?$(Jf4(B . ?\x56BF) ; <CJK>
     (?$(Jf;(B . ?\x5DCE) ; <CJK>
     (?$(JfZ(B . ?\x76AC) ; <CJK>
     (?$(Jf^(B . ?\x77D2) ; <CJK>
     (?$(Jfo(B . ?\x7C52) ; <CJK>
     (?$(Jg;(B . ?\x8B73) ; <CJK>
     (?$(JgA(B . ?\x8B76) ; <CJK>
     (?$(JgQ(B . ?\x8EC7) ; <CJK>
     (?$(Jg\(B . ?\x9434) ; <CJK>
     (?$(Jgb(B . ?\x943E) ; <CJK>
     (?$(Jgq(B . ?\x97BC) ; <CJK>
     (?$(Jh6(B . ?\x9B39) ; <CJK>
     (?$(Jh9(B . ?\x9C2A) ; <CJK>
     (?$(Jh;(B . ?\x9C26) ; <CJK>
     (?$(Jh>(B . ?\x9C27) ; <CJK>
     (?$(JhC(B . ?\x9DC0) ; <CJK>
     (?$(JhD(B . ?\x9DC9) ; <CJK>
     (?$(JhV(B . ?\x9EEC) ; <CJK>
     (?$(Jh`(B . ?\x9F68) ; <CJK>
     (?$(Ji-(B . ?\x8032) ; <CJK>
     (?$(Ji.(B . ?\x8031) ; <CJK>
     (?$(JiE(B . ?\x89FD) ; <CJK>
     (?$(JiR(B . ?\x908E) ; <CJK>
     (?$(Ji^(B . ?\x97C2) ; <CJK>
     (?$(Jij(B . ?\x9A4B) ; <CJK>
     (?$(Jiq(B . ?\x9B1C) ; <CJK>
     (?$(Jit(B . ?\x9B1B) ; <CJK>
     (?$(Jj#(B . ?\x9C42) ; <CJK>
     (?$(Jj%(B . ?\x9DD4) ; <CJK>
     (?$(JjC(B . ?\x56D0) ; <CJK>
     (?$(JjD(B . ?\x56CF) ; <CJK>
     (?$(JjF(B . ?\x5DDA) ; <CJK>
     (?$(JjL(B . ?\x66EA) ; <CJK>
     (?$(Jj|(B . ?\x8B89) ; <CJK>
     (?$(Jk)(B . ?\x9458) ; <CJK>
     (?$(JkF(B . ?\x9DE7) ; <CJK>
     (?$(JkJ(B . ?\x9DEA) ; <CJK>
     (?$(JkK(B . ?\x9DF1) ; <CJK>
     (?$(Jk\(B . ?\x9F44) ; <CJK>
     (?$(Jka(B . ?\x9F6D) ; <CJK>
     (?$(Jkh(B . ?\x5DD9) ; <CJK>
     (?$(Jkt(B . ?\x77D6) ; <CJK>
     (?$(Jl#(B . ?\x883A) ; <CJK>
     (?$(Jl%(B . ?\x8975) ; <CJK>
     (?$(Jl=(B . ?\x9A5D) ; <CJK>
     (?$(JlJ(B . ?\x9C64) ; <CJK>
     (?$(JlV(B . ?\x9E0A) ; <CJK>
     (?$(Jld(B . ?\x9F73) ; <CJK>
     (?$(Jlv(B . ?\x77E1) ; <CJK>
     (?$(Jm7(B . ?\x9B2D) ; <CJK>
     (?$(Jm:(B . ?\x9E0C) ; <CJK>
     (?$(JmH(B . ?\x9F1F) ; <CJK>
     (?$(JmW(B . ?\x6C0E) ; <CJK>
     (?$(Jm[(B . ?\x7C70) ; <CJK>
     (?$(Jmb(B . ?\x9479) ; <CJK>
     (?$(Jmd(B . ?\x974A) ; <CJK>
     (?$(Jmx(B . ?\x7E9D) ; <CJK>
     (?$(Jn$(B . ?\x9960) ; <CJK>
     (?$(Jn3(B . ?\x9F9E) ; <CJK>
     (?$(JnC(B . ?\x9EF8) ; <CJK>
     (?$(JnD(B . ?\x9F3A) ; <CJK>
     (?$(JnE(B . ?\x9F7D) ; <CJK>
     (?$(JnU(B . ?\x9F96) ; <CJK>
     )))

(provide 'u-cns-4)

;;; u-cns-4.el ends here
 