;;; unicode.el --- for UNICODE special features

;; Copyright (C) 1997-2000 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;  This module supports unicode translations.

(require 'mucs)
(require 'trans-util)
(require 'tae)
(require 'mccl-font)

(require 'un-data)

(defvar mucs-unicode-default-decode-replacement ??)
(defvar mucs-unicode-default-encode-replacement ?\xFFFD)

;;;
;;; UCS generic type definition.
;;;
(mucs-define-type
 'ucs-generic
 'identity
 'identity)

;;;
;;; UCS replacement or ignore translation rule.
;;;

(defvar unicode-not-found-to-replace-or-invalid-assoc
  `(assoc (char-1 . ucs-generic)
	  ( ,@(mapcar
	       (lambda (x)
		 (cons 'invalid x))
	       unicode-ignore-characters)
	      (all . ,mucs-unicode-default-encode-replacement)
	      (,mucs-unicode-default-decode-replacement . all)))
  "Translate any values to replacement character or invalid code.
If you want to deal with untranslated character, use this translation rule.")

(defvar unicode-not-found-to-invalid-assoc
  '(assoc (char-1 . ucs-generic)
	  ((all . invalid)
	   (invalid . all)))
  "Translate any values to invalid code.
If you want to deal with untranslated character, use this translation rule.")

;;
;; Dealing with line separator problem.
;;

(defun convert-unicode-lf-2-crlf (cr-output)
  `((if (r0 == ,unicode-lf)
	,(append cr-output))))

(defvar lf-vs-cr-assoc
  `(assoc (char-1 . ucs-generic)
	  ((?\xa . ,unicode-cr))))

(defvar lf-vs-unicode-line-separator-assoc
  `(assoc (char-1 . ucs-generic)
	  ((?\xa . ,unicode-line-separator))))

;
; Unicode or its transformation format support function.
;

(defun ucs-to-char (codepoint)
  (mucs-convert 'ucs-codepoint-to-emacs-char-conversion
		codepoint))

(defun char-to-ucs (char)
  (logior (lsh (charset-id (char-charset char)) 16)
	  (char-codepoint char))
  (mucs-convert 'emacs-char-to-ucs-codepoint-conversion
		char))

(defun insert-ucs-character (codepoint)
  "Insert character which is converted from give UCS codepoint."
  (interactive "nUCS codepoint:")
  (insert (or (ucs-to-char codepoint)
	      (error "Invalid or cannot translate:U+%X"
		     codepoint))))

(provide 'unicode)
;;; unicode ends here.


