;;; -*- coding: iso-2022-7bit  -*-
;;; utis620.el --- tables between Unicode and Thai-TIS 620.

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, IPA

;; Copyright (C) 1999-2000 Miyashita Hisashi

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'thai-tis620 'unicode-assoc
     'thai-tis620-vs-unicode-assoc)

(defvar
  thai-tis620-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?,T!(B . ?\x0E01) ;; THAI CHARACTER KO KAI
     (?,T"(B . ?\x0E02) ;; THAI CHARACTER KHO KHAI
     (?,T#(B . ?\x0E03) ;; THAI CHARACTER KHO KHUAT
     (?,T$(B . ?\x0E04) ;; THAI CHARACTER KHO KHWAI
     (?,T%(B . ?\x0E05) ;; THAI CHARACTER KHO KHON
     (?,T&(B . ?\x0E06) ;; THAI CHARACTER KHO RAKHANG
     (?,T'(B . ?\x0E07) ;; THAI CHARACTER NGO NGU
     (?,T((B . ?\x0E08) ;; THAI CHARACTER CHO CHAN
     (?,T)(B . ?\x0E09) ;; THAI CHARACTER CHO CHING
     (?,T*(B . ?\x0E0A) ;; THAI CHARACTER CHO CHANG
     (?,T+(B . ?\x0E0B) ;; THAI CHARACTER SO SO
     (?,T,(B . ?\x0E0C) ;; THAI CHARACTER CHO CHOE
     (?,T-(B . ?\x0E0D) ;; THAI CHARACTER YO YING
     (?,T.(B . ?\x0E0E) ;; THAI CHARACTER DO CHADA
     (?,T/(B . ?\x0E0F) ;; THAI CHARACTER TO PATAK
     (?,T0(B . ?\x0E10) ;; THAI CHARACTER THO THAN
     (?,T1(B . ?\x0E11) ;; THAI CHARACTER THO NANGMONTHO
     (?,T2(B . ?\x0E12) ;; THAI CHARACTER THO PHUTHAO
     (?,T3(B . ?\x0E13) ;; THAI CHARACTER NO NEN
     (?,T4(B . ?\x0E14) ;; THAI CHARACTER DO DEK
     (?,T5(B . ?\x0E15) ;; THAI CHARACTER TO TAO
     (?,T6(B . ?\x0E16) ;; THAI CHARACTER THO THUNG
     (?,T7(B . ?\x0E17) ;; THAI CHARACTER THO THAHAN
     (?,T8(B . ?\x0E18) ;; THAI CHARACTER THO THONG
     (?,T9(B . ?\x0E19) ;; THAI CHARACTER NO NU
     (?,T:(B . ?\x0E1A) ;; THAI CHARACTER BO BAIMAI
     (?,T;(B . ?\x0E1B) ;; THAI CHARACTER PO PLA
     (?,T<(B . ?\x0E1C) ;; THAI CHARACTER PHO PHUNG
     (?,T=(B . ?\x0E1D) ;; THAI CHARACTER FO FA
     (?,T>(B . ?\x0E1E) ;; THAI CHARACTER PHO PHAN
     (?,T?(B . ?\x0E1F) ;; THAI CHARACTER FO FAN
     (?,T@(B . ?\x0E20) ;; THAI CHARACTER PHO SAMPHAO
     (?,TA(B . ?\x0E21) ;; THAI CHARACTER MO MA
     (?,TB(B . ?\x0E22) ;; THAI CHARACTER YO YAK
     (?,TC(B . ?\x0E23) ;; THAI CHARACTER RO RUA
     (?,TD(B . ?\x0E24) ;; THAI CHARACTER RU
     (?,TE(B . ?\x0E25) ;; THAI CHARACTER LO LING
     (?,TF(B . ?\x0E26) ;; THAI CHARACTER LU
     (?,TG(B . ?\x0E27) ;; THAI CHARACTER WO WAEN
     (?,TH(B . ?\x0E28) ;; THAI CHARACTER SO SALA
     (?,TI(B . ?\x0E29) ;; THAI CHARACTER SO RUSI
     (?,TJ(B . ?\x0E2A) ;; THAI CHARACTER SO SUA
     (?,TK(B . ?\x0E2B) ;; THAI CHARACTER HO HIP
     (?,TL(B . ?\x0E2C) ;; THAI CHARACTER LO CHULA
     (?,TM(B . ?\x0E2D) ;; THAI CHARACTER O ANG
     (?,TN(B . ?\x0E2E) ;; THAI CHARACTER HO NOKHUK
     (?,TO(B . ?\x0E2F) ;; THAI CHARACTER PAIYANNOI
     (?,TP(B . ?\x0E30) ;; THAI CHARACTER SARA A
     (?,TQ(B . ?\x0E31) ;; THAI CHARACTER MAI HAN-AKAT
     (?,TR(B . ?\x0E32) ;; THAI CHARACTER SARA AA
     (?,TS(B . ?\x0E33) ;; THAI CHARACTER SARA AM
     (?,TT(B . ?\x0E34) ;; THAI CHARACTER SARA I
     (?,TU(B . ?\x0E35) ;; THAI CHARACTER SARA II
     (?,TV(B . ?\x0E36) ;; THAI CHARACTER SARA UE
     (?,TW(B . ?\x0E37) ;; THAI CHARACTER SARA UEE
     (?,TX(B . ?\x0E38) ;; THAI CHARACTER SARA U
     (?,TY(B . ?\x0E39) ;; THAI CHARACTER SARA UU
     (?,TZ(B . ?\x0E3A) ;; THAI CHARACTER PHINTHU
     (?,T_(B . ?\x0E3F) ;; THAI CURRENCY SYMBOL BAHT
     (?,T`(B . ?\x0E40) ;; THAI CHARACTER SARA E
     (?,Ta(B . ?\x0E41) ;; THAI CHARACTER SARA AE
     (?,Tb(B . ?\x0E42) ;; THAI CHARACTER SARA O
     (?,Tc(B . ?\x0E43) ;; THAI CHARACTER SARA AI MAIMUAN
     (?,Td(B . ?\x0E44) ;; THAI CHARACTER SARA AI MAIMALAI
     (?,Te(B . ?\x0E45) ;; THAI CHARACTER LAKKHANGYAO
     (?,Tf(B . ?\x0E46) ;; THAI CHARACTER MAIYAMOK
     (?,Tg(B . ?\x0E47) ;; THAI CHARACTER MAITAIKHU
     (?,Th(B . ?\x0E48) ;; THAI CHARACTER MAI EK
     (?,Ti(B . ?\x0E49) ;; THAI CHARACTER MAI THO
     (?,Tj(B . ?\x0E4A) ;; THAI CHARACTER MAI TRI
     (?,Tk(B . ?\x0E4B) ;; THAI CHARACTER MAI CHATTAWA
     (?,Tl(B . ?\x0E4C) ;; THAI CHARACTER THANTHAKHAT
     (?,Tm(B . ?\x0E4D) ;; THAI CHARACTER NIKHAHIT
     (?,Tn(B . ?\x0E4E) ;; THAI CHARACTER YAMAKKAN
     (?,To(B . ?\x0E4F) ;; THAI CHARACTER FONGMAN
     (?,Tp(B . ?\x0E50) ;; THAI DIGIT ZERO
     (?,Tq(B . ?\x0E51) ;; THAI DIGIT ONE
     (?,Tr(B . ?\x0E52) ;; THAI DIGIT TWO
     (?,Ts(B . ?\x0E53) ;; THAI DIGIT THREE
     (?,Tt(B . ?\x0E54) ;; THAI DIGIT FOUR
     (?,Tu(B . ?\x0E55) ;; THAI DIGIT FIVE
     (?,Tv(B . ?\x0E56) ;; THAI DIGIT SIX
     (?,Tw(B . ?\x0E57) ;; THAI DIGIT SEVEN
     (?,Tx(B . ?\x0E58) ;; THAI DIGIT EIGHT
     (?,Ty(B . ?\x0E59) ;; THAI DIGIT NINE
     (?,Tz(B . ?\x0E5A) ;; THAI CHARACTER ANGKHANKHU
     (?,T{(B . ?\x0E5B) ;; THAI CHARACTER KHOMUT
     )))

(provide 'utis620)

