; -*- coding: iso-2022-7bit  -*-
;;; u-cns-5.el --- tables between UCS and CNS 11643:1992 plain 5

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of MULE-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-5 'unicode-assoc
     'cns11643-5-vs-unicode-assoc)

(defvar cns11643-5-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(K!H(B . ?\x6729) ; <CJK>
    ( ?$(K"\(B . ?\x5E07) ; <CJK>
     (?$(K"f(B . ?\x5FCB) ; <CJK>
     (?$(K#K(B . ?\x5324) ; <CJK>
     (?$(K%7(B . ?\x52B7) ; <CJK>
     (?$(K%8(B . ?\x52B8) ; <CJK>
     (?$(K%:(B . ?\x52B6) ; <CJK>
     (?$(K%;(B . ?\x52BA) ; <CJK>
     (?$(K(r(B . ?\x5C2E) ; <CJK>
     (?$(K)E(B . ?\x6306) ; <CJK>
     (?$(K)i(B . ?\x6B85) ; <CJK>
     (?$(K0F(B . ?\x8C38) ; <CJK>
     (?$(K0U(B . ?\x8ECE) ; <CJK>
     (?$(K2~(B . ?\x688E) ; <CJK>
     (?$(K3T(B . ?\x7309) ; <CJK>
     (?$(K5[(B . ?\x8A2F) ; <CJK>
     (?$(K6j(B . ?\x52DC) ; <CJK>
     (?$(K7=(B . ?\x5921) ; <CJK>
     (?$(K7|(B . ?\x5E3F) ; <CJK>
     (?$(K;$(B . ?\x7B3F) ; <CJK>
     (?$(K;o(B . ?\x83D0) ; <CJK>
     (?$(K;{(B . ?\x86E7) ; <CJK>
     (?$(K?0(B . ?\x6117) ; <CJK>
     (?$(KB](B . ?\x8714) ; <CJK>
     (?$(KBl(B . ?\x88D1) ; <CJK>
     (?$(KC-(B . ?\x8CCB) ; <CJK>
     (?$(KCP(B . ?\x8EED) ; <CJK>
     (?$(KDc(B . ?\x52EC) ; <CJK>
     (?$(KDg(B . ?\x52E8) ; <CJK>
     (?$(KGI(B . ?\x7527) ; <CJK>
     (?$(KG~(B . ?\x798C) ; <CJK>
     (?$(KH"(B . ?\x7991) ; <CJK>
     (?$(KIN(B . ?\x8660) ; <CJK>
     (?$(KK;(B . ?\x9819) ; <CJK>
     (?$(KKL(B . ?\x9904) ; <CJK>
     (?$(KKN(B . ?\x999B) ; <CJK>
     (?$(KM*(B . ?\x6184) ; <CJK>
     (?$(KN7(B . ?\x729F) ; <CJK>
     (?$(KPU(B . ?\x8770) ; <CJK>
     (?$(KQ:(B . ?\x8CE3) ; <CJK>
     (?$(KQH(B . ?\x8E37) ; <CJK>
     (?$(KR;(B . ?\x9703) ; <CJK>
     (?$(KSb(B . ?\x52F6) ; <CJK>
     (?$(KT^(B . ?\x64CC) ; <CJK>
     (?$(KUi(B . ?\x764A) ; <CJK>
     (?$(KVR(B . ?\x7AB9) ; <CJK>
     (?$(KVi(B . ?\x7BD7) ; <CJK>
     (?$(KYu(B . ?\x98B4) ; <CJK>
     (?$(KZ&(B . ?\x999F) ; <CJK>
     (?$(KZJ(B . ?\x9B8D) ; <CJK>
     (?$(KZ[(B . ?\x9E77) ; <CJK>
     (?$(K[r(B . ?\x6BA9) ; <CJK>
     (?$(K\6(B . ?\x764B) ; <CJK>
     (?$(K\C(B . ?\x76A2) ; <CJK>
     (?$(KdH(B . ?\x87F1) ; <CJK>
     (?$(Kfy(B . ?\x9BBA) ; <CJK>
     (?$(KiC(B . ?\x8804) ; <CJK>
     (?$(Kk3(B . ?\x9BD8) ; <CJK>
     (?$(Kk?(B . ?\x9D7C) ; <CJK>
     (?$(Kly(B . ?\x7C46) ; <CJK>
     (?$(KqV(B . ?\x957E) ; <CJK>
     (?$(KrK(B . ?\x9C20) ; <CJK>
     (?$(KrN(B . ?\x9C22) ; <CJK>
     (?$(KrQ(B . ?\x9C1E) ; <CJK>
     (?$(KsG(B . ?\x7C61) ; <CJK>
     (?$(Kt8(B . ?\x8970) ; <CJK>
     (?$(Ku-(B . ?\x9C43) ; <CJK>
     (?$(KuE(B . ?\x9DE0) ; <CJK>
     (?$(Kv](B . ?\x9459) ; <CJK>
     (?$(KzS(B . ?\x9C72) ; <CJK>
     (?$(K{{(B . ?\x7228) ; <CJK>
     )))

(provide 'u-cns-5)

;;; u-cns-5.el ends here
 