;;; -*- coding: iso-2022-7bit  -*-
;;; usisheng.el --- tables between Unicode and Mule sisheng charset.

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, GB 2312

;; Miyashita Hisashi(himi@bird.scphys.kyoto-u.ac.jp)
;; converted mule-unicode.txt created by TAKAHASHI Naoto.

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'chinese-sisheng 'unicode-assoc
     'chinese-sisheng-vs-unicode-assoc)

(defvar
  chinese-sisheng-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?(0!(B . ?\x0100) ;; LATIN SMALL LETTER A WITH MACRON
     (?(0"(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?(0#(B . ?\x01CE) ;; LATIN SMALL LETTER A WITH CARON
     (?(0$(B . ?\x00E0) ;; LATIN SMALL LETTER A WITH GRAVE
     (?(0%(B . ?\x0113) ;; LATIN SMALL LETTER E WITH MACRON
     (?(0&(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?(0'(B . ?\x011B) ;; LATIN SMALL LETTER E WITH CARON
     (?(0((B . ?\x00E8) ;; LATIN SMALL LETTER E WITH GRAVE
     (?(0)(B . ?\x012B) ;; LATIN SMALL LETTER I WITH MACRON
     (?(0*(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?(0+(B . ?\x01D0) ;; LATIN SMALL LETTER I WITH CARON
     (?(0,(B . ?\x00EC) ;; LATIN SMALL LETTER I WITH GRAVE
     (?(0-(B . ?\x014D) ;; LATIN SMALL LETTER O WITH MACRON
     (?(0.(B . ?\x00F3) ;; LATIN SMALL LETTER O WITH ACUTE
     (?(0/(B . ?\x01D2) ;; LATIN SMALL LETTER O WITH CARON
     (?(00(B . ?\x00F2) ;; LATIN SMALL LETTER O WITH GRAVE
     (?(01(B . ?\x016B) ;; LATIN SMALL LETTER U WITH MACRON
     (?(02(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?(03(B . ?\x01D4) ;; LATIN SMALL LETTER U WITH CARON
     (?(04(B . ?\x00F9) ;; LATIN SMALL LETTER U WITH GRAVE
     (?(05(B . ?\x01D6) ;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (?(06(B . ?\x01D8) ;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (?(07(B . ?\x01DA) ;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (?(08(B . ?\x01DC) ;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     (?(09(B . ?\x00FC) ;; LATIN SMALL LETTER U WITH DIAERESIS
     (?(0:(B . ?\x00EA) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
     (?(0<(B . ?\x1E3F) ;; LATIN SMALL LETTER M WITH ACUTE
     (?(0=(B . ?\x0144) ;; LATIN SMALL LETTER N WITH ACUTE
     (?(0>(B . ?\x0148) ;; LATIN SMALL LETTER N WITH CARON
     (?(0A(B . ?\x02C9) ;; MODIFIER LETTER MACRON
     (?(0B(B . ?\x02CA) ;; MODIFIER LETTER ACUTE ACCENT
     (?(0C(B . ?\x02C7) ;; CARON
     (?(0D(B . ?\x02CB) ;; MODIFIER LETTER GRAVE ACCENT
     (?(0E(B . ?\x3105) ;; BOPOMOFO LETTER B
     (?(0F(B . ?\x3106) ;; BOPOMOFO LETTER P
     (?(0G(B . ?\x3107) ;; BOPOMOFO LETTER M
     (?(0H(B . ?\x3108) ;; BOPOMOFO LETTER F
     (?(0I(B . ?\x3109) ;; BOPOMOFO LETTER D
     (?(0J(B . ?\x310A) ;; BOPOMOFO LETTER T
     (?(0K(B . ?\x310B) ;; BOPOMOFO LETTER N
     (?(0L(B . ?\x310C) ;; BOPOMOFO LETTER L
     (?(0M(B . ?\x310D) ;; BOPOMOFO LETTER G
     (?(0N(B . ?\x310E) ;; BOPOMOFO LETTER K
     (?(0O(B . ?\x310F) ;; BOPOMOFO LETTER H
     (?(0P(B . ?\x3110) ;; BOPOMOFO LETTER J
     (?(0Q(B . ?\x3111) ;; BOPOMOFO LETTER Q
     (?(0R(B . ?\x3112) ;; BOPOMOFO LETTER X
     (?(0S(B . ?\x3113) ;; BOPOMOFO LETTER ZH
     (?(0T(B . ?\x3114) ;; BOPOMOFO LETTER CH
     (?(0U(B . ?\x3115) ;; BOPOMOFO LETTER SH
     (?(0V(B . ?\x3116) ;; BOPOMOFO LETTER R
     (?(0W(B . ?\x3117) ;; BOPOMOFO LETTER Z
     (?(0X(B . ?\x3118) ;; BOPOMOFO LETTER C
     (?(0Y(B . ?\x3119) ;; BOPOMOFO LETTER S
     (?(0Z(B . ?\x311A) ;; BOPOMOFO LETTER A
     (?(0[(B . ?\x311B) ;; BOPOMOFO LETTER O
     (?(0\(B . ?\x311C) ;; BOPOMOFO LETTER E
     (?(0](B . ?\x311D) ;; BOPOMOFO LETTER EH
     (?(0^(B . ?\x311E) ;; BOPOMOFO LETTER AI
     (?(0_(B . ?\x311F) ;; BOPOMOFO LETTER EI
     (?(0`(B . ?\x3120) ;; BOPOMOFO LETTER AU
     (?(0a(B . ?\x3121) ;; BOPOMOFO LETTER OU
     (?(0b(B . ?\x3122) ;; BOPOMOFO LETTER AN
     (?(0c(B . ?\x3123) ;; BOPOMOFO LETTER EN
     (?(0d(B . ?\x3124) ;; BOPOMOFO LETTER ANG
     (?(0e(B . ?\x3125) ;; BOPOMOFO LETTER ENG
     (?(0f(B . ?\x3126) ;; BOPOMOFO LETTER ER
     (?(0g(B . ?\x3127) ;; BOPOMOFO LETTER I
     (?(0h(B . ?\x3128) ;; BOPOMOFO LETTER U
     (?(0i(B . ?\x3129) ;; BOPOMOFO LETTER IU
     )))

(provide 'usisheng)
