; -*- coding: iso-2022-7bit  -*-
;;; u-cns-2.el --- tables between UCS and CNS 11643:1992 plain 2

;; Copyright (c) 1991-1994 Unicode, Inc.
;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;; "Uni2CNS.Z" was originally based on "CJKXRef.text" by John
;; H. Jenkins <John_Jenkins@taligent.com>.  Here the author expresses
;; his appreciation to Ken Lunde <lunde@mv.us.adobe.com>, Christian
;; Wittern <cwittern@conline.central.de>, and Jack Halpern
;; <jhalpern@super.win.or.jp>.

;;; Code:

(put 'chinese-cns11643-2 'unicode-assoc
     'cns11643-2-vs-unicode-assoc)

(defvar cns11643-2-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(H!!(B . "0x4E42") ; <CJK>
       (?$(H!"(B . "0x4E5C") ; <CJK>
       (?$(H!#(B . "0x51F5") ; <CJK>
       (?$(H!$(B . "0x531A") ; <CJK>
       (?$(H!%(B . "0x5382") ; <CJK>
       (?$(H!&(B . "0x4E07") ; <CJK>
       (?$(H!'(B . "0x4E0C") ; <CJK>
       (?$(H!((B . "0x4E47") ; <CJK>
       (?$(H!)(B . "0x4E8D") ; <CJK>
       (?$(H!*(B . "0x56D7") ; <CJK>
       (?$(H!+(B . "0x5C6E") ; <CJK>
       (?$(H!,(B . "0x5F73") ; <CJK>
       (?$(H!-(B . "0x4E0F") ; <CJK>
       (?$(H!.(B . "0x5187") ; <CJK>
       (?$(H!/(B . "0x4E0E") ; <CJK>
       (?$(H!0(B . "0x4E2E") ; <CJK>
       (?$(H!1(B . "0x4E93") ; <CJK>
       (?$(H!2(B . "0x4EC2") ; <CJK>
       (?$(H!3(B . "0x4EC9") ; <CJK>
       (?$(H!4(B . "0x4EC8") ; <CJK>
       (?$(H!5(B . "0x5198") ; <CJK>
       (?$(H!6(B . "0x52FC") ; <CJK>
       (?$(H!7(B . "0x536C") ; <CJK>
       (?$(H!8(B . "0x53B9") ; <CJK>
       (?$(H!9(B . "0x5720") ; <CJK>
       (?$(H!:(B . "0x5903") ; <CJK>
       (?$(H!;(B . "0x592C") ; <CJK>
       (?$(H!<(B . "0x5C10") ; <CJK>
       (?$(H!=(B . "0x5DFF") ; <CJK>
       (?$(H!>(B . "0x65E1") ; <CJK>
       (?$(H!?(B . "0x6BB3") ; <CJK>
       (?$(H!@(B . "0x6BCC") ; <CJK>
       (?$(H!A(B . "0x6C14") ; <CJK>
       (?$(H!B(B . "0x723F") ; <CJK>
       (?$(H!C(B . "0x4E31") ; <CJK>
       (?$(H!D(B . "0x4E3C") ; <CJK>
       (?$(H!E(B . "0x4EE8") ; <CJK>
       (?$(H!F(B . "0x4EDC") ; <CJK>
       (?$(H!G(B . "0x4EE9") ; <CJK>
       (?$(H!H(B . "0x4EE1") ; <CJK>
       (?$(H!I(B . "0x4EDD") ; <CJK>
       (?$(H!J(B . "0x4EDA") ; <CJK>
       (?$(H!K(B . "0x520C") ; <CJK>
       (?$(H!L(B . "0x5209") ; <CJK>
       (?$(H!M(B . "0x531C") ; <CJK>
       (?$(H!N(B . "0x534C") ; <CJK>
       (?$(H!O(B . "0x5722") ; <CJK>
       (?$(H!P(B . "0x5723") ; <CJK>
       (?$(H!Q(B . "0x5917") ; <CJK>
       (?$(H!R(B . "0x592F") ; <CJK>
       (?$(H!S(B . "0x5B81") ; <CJK>
       (?$(H!T(B . "0x5B84") ; <CJK>
       (?$(H!U(B . "0x5C12") ; <CJK>
       (?$(H!V(B . "0x5C3B") ; <CJK>
       (?$(H!W(B . "0x5C74") ; <CJK>
       (?$(H!X(B . "0x5C73") ; <CJK>
       (?$(H!Y(B . "0x5E04") ; <CJK>
       (?$(H!Z(B . "0x5E80") ; <CJK>
       (?$(H![(B . "0x5E82") ; <CJK>
       (?$(H!\(B . "0x5FC9") ; <CJK>
       (?$(H!](B . "0x6209") ; <CJK>
       (?$(H!^(B . "0x6250") ; <CJK>
       (?$(H!_(B . "0x6C15") ; <CJK>
       (?$(H!`(B . "0x6C36") ; <CJK>
       (?$(H!a(B . "0x6C43") ; <CJK>
       (?$(H!b(B . "0x6C3F") ; <CJK>
       (?$(H!c(B . "0x6C3B") ; <CJK>
       (?$(H!d(B . "0x72AE") ; <CJK>
       (?$(H!e(B . "0x72B0") ; <CJK>
       (?$(H!f(B . "0x738A") ; <CJK>
       (?$(H!g(B . "0x79B8") ; <CJK>
       (?$(H!h(B . "0x808A") ; <CJK>
       (?$(H!i(B . "0x961E") ; <CJK>
       (?$(H!j(B . "0x4F0E") ; <CJK>
       (?$(H!k(B . "0x4F18") ; <CJK>
       (?$(H!l(B . "0x4F2C") ; <CJK>
       (?$(H!m(B . "0x4EF5") ; <CJK>
       (?$(H!n(B . "0x4F14") ; <CJK>
       (?$(H!o(B . "0x4EF1") ; <CJK>
       (?$(H!p(B . "0x4F00") ; <CJK>
       (?$(H!q(B . "0x4EF7") ; <CJK>
       (?$(H!r(B . "0x4F08") ; <CJK>
       (?$(H!s(B . "0x4F1D") ; <CJK>
       (?$(H!t(B . "0x4F02") ; <CJK>
       (?$(H!u(B . "0x4F05") ; <CJK>
       (?$(H!v(B . "0x4F22") ; <CJK>
       (?$(H!w(B . "0x4F13") ; <CJK>
       (?$(H!x(B . "0x4F04") ; <CJK>
       (?$(H!y(B . "0x4EF4") ; <CJK>
       (?$(H!z(B . "0x4F12") ; <CJK>
       (?$(H!{(B . "0x51B1") ; <CJK>
       (?$(H!|(B . "0x5213") ; <CJK>
       (?$(H!}(B . "0x5210") ; <CJK>
       (?$(H!~(B . "0x52A6") ; <CJK>
       (?$(H"!(B . "0x5322") ; <CJK>
       (?$(H""(B . "0x531F") ; <CJK>
       (?$(H"#(B . "0x534D") ; <CJK>
       (?$(H"$(B . "0x538A") ; <CJK>
       (?$(H"%(B . "0x5407") ; <CJK>
       (?$(H"&(B . "0x56E1") ; <CJK>
       (?$(H"'(B . "0x56DF") ; <CJK>
       (?$(H"((B . "0x572E") ; <CJK>
       (?$(H")(B . "0x572A") ; <CJK>
       (?$(H"*(B . "0x5734") ; <CJK>
       (?$(H"+(B . "0x593C") ; <CJK>
       (?$(H",(B . "0x5980") ; <CJK>
       (?$(H"-(B . "0x597C") ; <CJK>
       (?$(H".(B . "0x5985") ; <CJK>
       (?$(H"/(B . "0x597B") ; <CJK>
       (?$(H"0(B . "0x597E") ; <CJK>
       (?$(H"1(B . "0x5977") ; <CJK>
       (?$(H"2(B . "0x597F") ; <CJK>
       (?$(H"3(B . "0x5B56") ; <CJK>
       (?$(H"4(B . "0x5C15") ; <CJK>
       (?$(H"5(B . "0x5C25") ; <CJK>
       (?$(H"6(B . "0x5C7C") ; <CJK>
       (?$(H"7(B . "0x5C7A") ; <CJK>
       (?$(H"8(B . "0x5C7B") ; <CJK>
       (?$(H"9(B . "0x5C7E") ; <CJK>
       (?$(H":(B . "0x5DDF") ; <CJK>
       (?$(H";(B . "0x5E75") ; <CJK>
       (?$(H"<(B . "0x5E84") ; <CJK>
       (?$(H"=(B . "0x5F02") ; <CJK>
       (?$(H">(B . "0x5F1A") ; <CJK>
       (?$(H"?(B . "0x5F74") ; <CJK>
       (?$(H"@(B . "0x5FD5") ; <CJK>
       (?$(H"A(B . "0x5FD4") ; <CJK>
       (?$(H"B(B . "0x5FCF") ; <CJK>
       (?$(H"C(B . "0x625C") ; <CJK>
       (?$(H"D(B . "0x625E") ; <CJK>
       (?$(H"E(B . "0x6264") ; <CJK>
       (?$(H"F(B . "0x6261") ; <CJK>
       (?$(H"G(B . "0x6266") ; <CJK>
       (?$(H"H(B . "0x6262") ; <CJK>
       (?$(H"I(B . "0x6259") ; <CJK>
       (?$(H"J(B . "0x6260") ; <CJK>
       (?$(H"K(B . "0x625A") ; <CJK>
       (?$(H"L(B . "0x6265") ; <CJK>
       (?$(H"M(B . "0x6537") ; <CJK>
       (?$(H"N(B . "0x65EF") ; <CJK>
       (?$(H"O(B . "0x65EE") ; <CJK>
       (?$(H"P(B . "0x673E") ; <CJK>
       (?$(H"Q(B . "0x6739") ; <CJK>
       (?$(H"R(B . "0x6738") ; <CJK>
       (?$(H"S(B . "0x673B") ; <CJK>
       (?$(H"T(B . "0x673A") ; <CJK>
       (?$(H"U(B . "0x673F") ; <CJK>
       (?$(H"V(B . "0x673C") ; <CJK>
       (?$(H"W(B . "0x6733") ; <CJK>
       (?$(H"X(B . "0x6C18") ; <CJK>
       (?$(H"Y(B . "0x6C46") ; <CJK>
       (?$(H"Z(B . "0x6C52") ; <CJK>
       (?$(H"[(B . "0x6C5C") ; <CJK>
       (?$(H"\(B . "0x6C4F") ; <CJK>
       (?$(H"](B . "0x6C4A") ; <CJK>
       (?$(H"^(B . "0x6C54") ; <CJK>
       (?$(H"_(B . "0x6C4B") ; <CJK>
       (?$(H"`(B . "0x6C4C") ; <CJK>
       (?$(H"a(B . "0x7071") ; <CJK>
       (?$(H"b(B . "0x725E") ; <CJK>
       (?$(H"c(B . "0x72B4") ; <CJK>
       (?$(H"d(B . "0x72B5") ; <CJK>
       (?$(H"e(B . "0x738E") ; <CJK>
       (?$(H"f(B . "0x752A") ; <CJK>
       (?$(H"g(B . "0x767F") ; <CJK>
       (?$(H"h(B . "0x7A75") ; <CJK>
       (?$(H"i(B . "0x7F51") ; <CJK>
       (?$(H"j(B . "0x8278") ; <CJK>
       (?$(H"k(B . "0x827C") ; <CJK>
       (?$(H"l(B . "0x8280") ; <CJK>
       (?$(H"m(B . "0x827D") ; <CJK>
       (?$(H"n(B . "0x827F") ; <CJK>
       (?$(H"o(B . "0x864D") ; <CJK>
       (?$(H"p(B . "0x897E") ; <CJK>
       (?$(H"q(B . "0x9099") ; <CJK>
       (?$(H"r(B . "0x9097") ; <CJK>
       (?$(H"s(B . "0x9098") ; <CJK>
       (?$(H"t(B . "0x909B") ; <CJK>
       (?$(H"u(B . "0x9094") ; <CJK>
       (?$(H"v(B . "0x9622") ; <CJK>
       (?$(H"w(B . "0x9624") ; <CJK>
       (?$(H"x(B . "0x9620") ; <CJK>
       (?$(H"y(B . "0x9623") ; <CJK>
       (?$(H"z(B . "0x4F56") ; <CJK>
       (?$(H"{(B . "0x4F3B") ; <CJK>
       (?$(H"|(B . "0x4F62") ; <CJK>
       (?$(H"}(B . "0x4F49") ; <CJK>
       (?$(H"~(B . "0x4F53") ; <CJK>
       (?$(H#!(B . "0x4F64") ; <CJK>
       (?$(H#"(B . "0x4F3E") ; <CJK>
       (?$(H##(B . "0x4F67") ; <CJK>
       (?$(H#$(B . "0x4F52") ; <CJK>
       (?$(H#%(B . "0x4F5F") ; <CJK>
       (?$(H#&(B . "0x4F41") ; <CJK>
       (?$(H#'(B . "0x4F58") ; <CJK>
       (?$(H#((B . "0x4F2D") ; <CJK>
       (?$(H#)(B . "0x4F33") ; <CJK>
       (?$(H#*(B . "0x4F3F") ; <CJK>
       (?$(H#+(B . "0x4F61") ; <CJK>
       (?$(H#,(B . "0x518F") ; <CJK>
       (?$(H#-(B . "0x51B9") ; <CJK>
       (?$(H#.(B . "0x521C") ; <CJK>
       (?$(H#/(B . "0x521E") ; <CJK>
       (?$(H#0(B . "0x5221") ; <CJK>
       (?$(H#1(B . "0x52AD") ; <CJK>
       (?$(H#2(B . "0x52AE") ; <CJK>
       (?$(H#3(B . "0x5309") ; <CJK>
       (?$(H#4(B . "0x5363") ; <CJK>
       (?$(H#5(B . "0x5372") ; <CJK>
       (?$(H#6(B . "0x538E") ; <CJK>
       (?$(H#7(B . "0x538F") ; <CJK>
       (?$(H#8(B . "0x5430") ; <CJK>
       (?$(H#9(B . "0x5437") ; <CJK>
       (?$(H#:(B . "0x542A") ; <CJK>
       (?$(H#;(B . "0x5454") ; <CJK>
       (?$(H#<(B . "0x5445") ; <CJK>
       (?$(H#=(B . "0x5419") ; <CJK>
       (?$(H#>(B . "0x541C") ; <CJK>
       (?$(H#?(B . "0x5425") ; <CJK>
       (?$(H#@(B . "0x5418") ; <CJK>
       (?$(H#A(B . "0x543D") ; <CJK>
       (?$(H#B(B . "0x544F") ; <CJK>
       (?$(H#C(B . "0x5441") ; <CJK>
       (?$(H#D(B . "0x5428") ; <CJK>
       (?$(H#E(B . "0x5424") ; <CJK>
       (?$(H#F(B . "0x5447") ; <CJK>
       (?$(H#G(B . "0x56EE") ; <CJK>
       (?$(H#H(B . "0x56E7") ; <CJK>
       (?$(H#I(B . "0x56E5") ; <CJK>
       (?$(H#J(B . "0x5741") ; <CJK>
       (?$(H#K(B . "0x5745") ; <CJK>
       (?$(H#L(B . "0x574C") ; <CJK>
       (?$(H#M(B . "0x5749") ; <CJK>
       (?$(H#N(B . "0x574B") ; <CJK>
       (?$(H#O(B . "0x5752") ; <CJK>
       (?$(H#P(B . "0x5906") ; <CJK>
       (?$(H#Q(B . "0x5940") ; <CJK>
       (?$(H#R(B . "0x59A6") ; <CJK>
       (?$(H#S(B . "0x5998") ; <CJK>
       (?$(H#T(B . "0x59A0") ; <CJK>
       (?$(H#U(B . "0x5997") ; <CJK>
       (?$(H#V(B . "0x598E") ; <CJK>
       (?$(H#W(B . "0x59A2") ; <CJK>
       (?$(H#X(B . "0x5990") ; <CJK>
       (?$(H#Y(B . "0x598F") ; <CJK>
       (?$(H#Z(B . "0x59A7") ; <CJK>
       (?$(H#[(B . "0x59A1") ; <CJK>
       (?$(H#\(B . "0x5B8E") ; <CJK>
       (?$(H#](B . "0x5B92") ; <CJK>
       (?$(H#^(B . "0x5C28") ; <CJK>
       (?$(H#_(B . "0x5C2A") ; <CJK>
       (?$(H#`(B . "0x5C8D") ; <CJK>
       (?$(H#a(B . "0x5C8F") ; <CJK>
       (?$(H#b(B . "0x5C88") ; <CJK>
       (?$(H#c(B . "0x5C8B") ; <CJK>
       (?$(H#d(B . "0x5C89") ; <CJK>
       (?$(H#e(B . "0x5C92") ; <CJK>
       (?$(H#f(B . "0x5C8A") ; <CJK>
       (?$(H#g(B . "0x5C86") ; <CJK>
       (?$(H#h(B . "0x5C93") ; <CJK>
       (?$(H#i(B . "0x5C95") ; <CJK>
       (?$(H#j(B . "0x5DE0") ; <CJK>
       (?$(H#k(B . "0x5E0A") ; <CJK>
       (?$(H#l(B . "0x5E0E") ; <CJK>
       (?$(H#m(B . "0x5E8B") ; <CJK>
       (?$(H#n(B . "0x5E89") ; <CJK>
       (?$(H#o(B . "0x5E8C") ; <CJK>
       (?$(H#p(B . "0x5E88") ; <CJK>
       (?$(H#q(B . "0x5E8D") ; <CJK>
       (?$(H#r(B . "0x5F05") ; <CJK>
       (?$(H#s(B . "0x5F1D") ; <CJK>
       (?$(H#t(B . "0x5F78") ; <CJK>
       (?$(H#u(B . "0x5F76") ; <CJK>
       (?$(H#v(B . "0x5FD2") ; <CJK>
       (?$(H#w(B . "0x5FD1") ; <CJK>
       (?$(H#x(B . "0x5FD0") ; <CJK>
       (?$(H#y(B . "0x5FED") ; <CJK>
       (?$(H#z(B . "0x5FE8") ; <CJK>
       (?$(H#{(B . "0x5FEE") ; <CJK>
       (?$(H#|(B . "0x5FF3") ; <CJK>
       (?$(H#}(B . "0x5FE1") ; <CJK>
       (?$(H#~(B . "0x5FE4") ; <CJK>
       (?$(H$!(B . "0x5FE3") ; <CJK>
       (?$(H$"(B . "0x5FFA") ; <CJK>
       (?$(H$#(B . "0x5FEF") ; <CJK>
       (?$(H$$(B . "0x5FF7") ; <CJK>
       (?$(H$%(B . "0x5FFB") ; <CJK>
       (?$(H$&(B . "0x6000") ; <CJK>
       (?$(H$'(B . "0x5FF4") ; <CJK>
       (?$(H$((B . "0x623A") ; <CJK>
       (?$(H$)(B . "0x6283") ; <CJK>
       (?$(H$*(B . "0x628C") ; <CJK>
       (?$(H$+(B . "0x628E") ; <CJK>
       (?$(H$,(B . "0x628F") ; <CJK>
       (?$(H$-(B . "0x6294") ; <CJK>
       (?$(H$.(B . "0x6287") ; <CJK>
       (?$(H$/(B . "0x6271") ; <CJK>
       (?$(H$0(B . "0x627B") ; <CJK>
       (?$(H$1(B . "0x627A") ; <CJK>
       (?$(H$2(B . "0x6270") ; <CJK>
       (?$(H$3(B . "0x6281") ; <CJK>
       (?$(H$4(B . "0x6288") ; <CJK>
       (?$(H$5(B . "0x6277") ; <CJK>
       (?$(H$6(B . "0x627D") ; <CJK>
       (?$(H$7(B . "0x6272") ; <CJK>
       (?$(H$8(B . "0x6274") ; <CJK>
       (?$(H$9(B . "0x65F0") ; <CJK>
       (?$(H$:(B . "0x65F4") ; <CJK>
       (?$(H$;(B . "0x65F3") ; <CJK>
       (?$(H$<(B . "0x65F2") ; <CJK>
       (?$(H$=(B . "0x65F5") ; <CJK>
       (?$(H$>(B . "0x6745") ; <CJK>
       (?$(H$?(B . "0x6747") ; <CJK>
       (?$(H$@(B . "0x6759") ; <CJK>
       (?$(H$A(B . "0x6755") ; <CJK>
       (?$(H$B(B . "0x674C") ; <CJK>
       (?$(H$C(B . "0x6748") ; <CJK>
       (?$(H$D(B . "0x675D") ; <CJK>
       (?$(H$E(B . "0x674D") ; <CJK>
       (?$(H$F(B . "0x675A") ; <CJK>
       (?$(H$G(B . "0x674B") ; <CJK>
       (?$(H$H(B . "0x6BD0") ; <CJK>
       (?$(H$I(B . "0x6C19") ; <CJK>
       (?$(H$J(B . "0x6C1A") ; <CJK>
       (?$(H$K(B . "0x6C78") ; <CJK>
       (?$(H$L(B . "0x6C67") ; <CJK>
       (?$(H$M(B . "0x6C6B") ; <CJK>
       (?$(H$N(B . "0x6C84") ; <CJK>
       (?$(H$O(B . "0x6C8B") ; <CJK>
       (?$(H$P(B . "0x6C8F") ; <CJK>
       (?$(H$Q(B . "0x6C71") ; <CJK>
       (?$(H$R(B . "0x6C6F") ; <CJK>
       (?$(H$S(B . "0x6C69") ; <CJK>
       (?$(H$T(B . "0x6C9A") ; <CJK>
       (?$(H$U(B . "0x6C6D") ; <CJK>
       (?$(H$V(B . "0x6C87") ; <CJK>
       (?$(H$W(B . "0x6C95") ; <CJK>
       (?$(H$X(B . "0x6C9C") ; <CJK>
       (?$(H$Y(B . "0x6C66") ; <CJK>
       (?$(H$Z(B . "0x6C73") ; <CJK>
       (?$(H$[(B . "0x6C65") ; <CJK>
       (?$(H$\(B . "0x6C7B") ; <CJK>
       (?$(H$](B . "0x6C8E") ; <CJK>
       (?$(H$^(B . "0x7074") ; <CJK>
       (?$(H$_(B . "0x707A") ; <CJK>
       (?$(H$`(B . "0x7263") ; <CJK>
       (?$(H$a(B . "0x72BF") ; <CJK>
       (?$(H$b(B . "0x72BD") ; <CJK>
       (?$(H$c(B . "0x72C3") ; <CJK>
       (?$(H$d(B . "0x72C6") ; <CJK>
       (?$(H$e(B . "0x72C1") ; <CJK>
       (?$(H$f(B . "0x72BA") ; <CJK>
       (?$(H$g(B . "0x72C5") ; <CJK>
       (?$(H$h(B . "0x7395") ; <CJK>
       (?$(H$i(B . "0x7397") ; <CJK>
       (?$(H$j(B . "0x7393") ; <CJK>
       (?$(H$k(B . "0x7394") ; <CJK>
       (?$(H$l(B . "0x7392") ; <CJK>
       (?$(H$m(B . "0x753A") ; <CJK>
       (?$(H$n(B . "0x7539") ; <CJK>
       (?$(H$o(B . "0x7594") ; <CJK>
       (?$(H$p(B . "0x7595") ; <CJK>
       (?$(H$q(B . "0x7681") ; <CJK>
       (?$(H$r(B . "0x793D") ; <CJK>
       (?$(H$s(B . "0x8034") ; <CJK>
       (?$(H$t(B . "0x8095") ; <CJK>
       (?$(H$u(B . "0x8099") ; <CJK>
       (?$(H$v(B . "0x8090") ; <CJK>
       (?$(H$w(B . "0x8092") ; <CJK>
       (?$(H$x(B . "0x809C") ; <CJK>
       (?$(H$y(B . "0x8290") ; <CJK>
       (?$(H$z(B . "0x828F") ; <CJK>
       (?$(H${(B . "0x8285") ; <CJK>
       (?$(H$|(B . "0x828E") ; <CJK>
       (?$(H$}(B . "0x8291") ; <CJK>
       (?$(H$~(B . "0x8293") ; <CJK>
       (?$(H%!(B . "0x828A") ; <CJK>
       (?$(H%"(B . "0x8283") ; <CJK>
       (?$(H%#(B . "0x8284") ; <CJK>
       (?$(H%$(B . "0x8C78") ; <CJK>
       (?$(H%%(B . "0x8FC9") ; <CJK>
       (?$(H%&(B . "0x8FBF") ; <CJK>
       (?$(H%'(B . "0x909F") ; <CJK>
       (?$(H%((B . "0x90A1") ; <CJK>
       (?$(H%)(B . "0x90A5") ; <CJK>
       (?$(H%*(B . "0x909E") ; <CJK>
       (?$(H%+(B . "0x90A7") ; <CJK>
       (?$(H%,(B . "0x90A0") ; <CJK>
       (?$(H%-(B . "0x9630") ; <CJK>
       (?$(H%.(B . "0x9628") ; <CJK>
       (?$(H%/(B . "0x962F") ; <CJK>
       (?$(H%0(B . "0x962D") ; <CJK>
       (?$(H%1(B . "0x4E33") ; <CJK>
       (?$(H%2(B . "0x4F98") ; <CJK>
       (?$(H%3(B . "0x4F7C") ; <CJK>
       (?$(H%4(B . "0x4F85") ; <CJK>
       (?$(H%5(B . "0x4F7D") ; <CJK>
       (?$(H%6(B . "0x4F80") ; <CJK>
       (?$(H%7(B . "0x4F87") ; <CJK>
       (?$(H%8(B . "0x4F76") ; <CJK>
       (?$(H%9(B . "0x4F74") ; <CJK>
       (?$(H%:(B . "0x4F89") ; <CJK>
       (?$(H%;(B . "0x4F84") ; <CJK>
       (?$(H%<(B . "0x4F77") ; <CJK>
       (?$(H%=(B . "0x4F4C") ; <CJK>
       (?$(H%>(B . "0x4F97") ; <CJK>
       (?$(H%?(B . "0x4F6A") ; <CJK>
       (?$(H%@(B . "0x4F9A") ; <CJK>
       (?$(H%A(B . "0x4F79") ; <CJK>
       (?$(H%B(B . "0x4F81") ; <CJK>
       (?$(H%C(B . "0x4F78") ; <CJK>
       (?$(H%D(B . "0x4F90") ; <CJK>
       (?$(H%E(B . "0x4F9C") ; <CJK>
       (?$(H%F(B . "0x4F94") ; <CJK>
       (?$(H%G(B . "0x4F9E") ; <CJK>
       (?$(H%H(B . "0x4F92") ; <CJK>
       (?$(H%I(B . "0x4F82") ; <CJK>
       (?$(H%J(B . "0x4F95") ; <CJK>
       (?$(H%K(B . "0x4F6B") ; <CJK>
       (?$(H%L(B . "0x4F6E") ; <CJK>
       (?$(H%M(B . "0x519E") ; <CJK>
       (?$(H%N(B . "0x51BC") ; <CJK>
       (?$(H%O(B . "0x51BE") ; <CJK>
       (?$(H%P(B . "0x5235") ; <CJK>
       (?$(H%Q(B . "0x5232") ; <CJK>
       (?$(H%R(B . "0x5233") ; <CJK>
       (?$(H%S(B . "0x5246") ; <CJK>
       (?$(H%T(B . "0x5231") ; <CJK>
       (?$(H%U(B . "0x52BC") ; <CJK>
       (?$(H%V(B . "0x530A") ; <CJK>
       (?$(H%W(B . "0x530B") ; <CJK>
       (?$(H%X(B . "0x533C") ; <CJK>
       (?$(H%Y(B . "0x5392") ; <CJK>
       (?$(H%Z(B . "0x5394") ; <CJK>
       (?$(H%[(B . "0x5487") ; <CJK>
       (?$(H%\(B . "0x547F") ; <CJK>
       (?$(H%](B . "0x5481") ; <CJK>
       (?$(H%^(B . "0x5491") ; <CJK>
       (?$(H%_(B . "0x5482") ; <CJK>
       (?$(H%`(B . "0x5488") ; <CJK>
       (?$(H%a(B . "0x546B") ; <CJK>
       (?$(H%b(B . "0x547A") ; <CJK>
       (?$(H%c(B . "0x547E") ; <CJK>
       (?$(H%d(B . "0x5465") ; <CJK>
       (?$(H%e(B . "0x546C") ; <CJK>
       (?$(H%f(B . "0x5474") ; <CJK>
       (?$(H%g(B . "0x5466") ; <CJK>
       (?$(H%h(B . "0x548D") ; <CJK>
       (?$(H%i(B . "0x546F") ; <CJK>
       (?$(H%j(B . "0x5461") ; <CJK>
       (?$(H%k(B . "0x5460") ; <CJK>
       (?$(H%l(B . "0x5498") ; <CJK>
       (?$(H%m(B . "0x5463") ; <CJK>
       (?$(H%n(B . "0x5467") ; <CJK>
       (?$(H%o(B . "0x5464") ; <CJK>
       (?$(H%p(B . "0x56F7") ; <CJK>
       (?$(H%q(B . "0x56F9") ; <CJK>
       (?$(H%r(B . "0x576F") ; <CJK>
       (?$(H%s(B . "0x5772") ; <CJK>
       (?$(H%t(B . "0x576D") ; <CJK>
       (?$(H%u(B . "0x576B") ; <CJK>
       (?$(H%v(B . "0x5771") ; <CJK>
       (?$(H%w(B . "0x5770") ; <CJK>
       (?$(H%x(B . "0x5776") ; <CJK>
       (?$(H%y(B . "0x5780") ; <CJK>
       (?$(H%z(B . "0x5775") ; <CJK>
       (?$(H%{(B . "0x577B") ; <CJK>
       (?$(H%|(B . "0x5773") ; <CJK>
       (?$(H%}(B . "0x5774") ; <CJK>
       (?$(H%~(B . "0x5762") ; <CJK>
       (?$(H&!(B . "0x5768") ; <CJK>
       (?$(H&"(B . "0x577D") ; <CJK>
       (?$(H&#(B . "0x590C") ; <CJK>
       (?$(H&$(B . "0x5945") ; <CJK>
       (?$(H&%(B . "0x59B5") ; <CJK>
       (?$(H&&(B . "0x59BA") ; <CJK>
       (?$(H&'(B . "0x59CF") ; <CJK>
       (?$(H&((B . "0x59CE") ; <CJK>
       (?$(H&)(B . "0x59B2") ; <CJK>
       (?$(H&*(B . "0x59CC") ; <CJK>
       (?$(H&+(B . "0x59C1") ; <CJK>
       (?$(H&,(B . "0x59B6") ; <CJK>
       (?$(H&-(B . "0x59BC") ; <CJK>
       (?$(H&.(B . "0x59C3") ; <CJK>
       (?$(H&/(B . "0x59D6") ; <CJK>
       (?$(H&0(B . "0x59B1") ; <CJK>
       (?$(H&1(B . "0x59BD") ; <CJK>
       (?$(H&2(B . "0x59C0") ; <CJK>
       (?$(H&3(B . "0x59C8") ; <CJK>
       (?$(H&4(B . "0x59B4") ; <CJK>
       (?$(H&5(B . "0x59C7") ; <CJK>
       (?$(H&6(B . "0x5B62") ; <CJK>
       (?$(H&7(B . "0x5B65") ; <CJK>
       (?$(H&8(B . "0x5B93") ; <CJK>
       (?$(H&9(B . "0x5B95") ; <CJK>
       (?$(H&:(B . "0x5C44") ; <CJK>
       (?$(H&;(B . "0x5C47") ; <CJK>
       (?$(H&<(B . "0x5CAE") ; <CJK>
       (?$(H&=(B . "0x5CA4") ; <CJK>
       (?$(H&>(B . "0x5CA0") ; <CJK>
       (?$(H&?(B . "0x5CB5") ; <CJK>
       (?$(H&@(B . "0x5CAF") ; <CJK>
       (?$(H&A(B . "0x5CA8") ; <CJK>
       (?$(H&B(B . "0x5CAC") ; <CJK>
       (?$(H&C(B . "0x5C9F") ; <CJK>
       (?$(H&D(B . "0x5CA3") ; <CJK>
       (?$(H&E(B . "0x5CAD") ; <CJK>
       (?$(H&F(B . "0x5CA2") ; <CJK>
       (?$(H&G(B . "0x5CAA") ; <CJK>
       (?$(H&H(B . "0x5CA7") ; <CJK>
       (?$(H&I(B . "0x5C9D") ; <CJK>
       (?$(H&J(B . "0x5CA5") ; <CJK>
       (?$(H&K(B . "0x5CB6") ; <CJK>
       (?$(H&L(B . "0x5CB0") ; <CJK>
       (?$(H&M(B . "0x5CA6") ; <CJK>
       (?$(H&N(B . "0x5E17") ; <CJK>
       (?$(H&O(B . "0x5E14") ; <CJK>
       (?$(H&P(B . "0x5E19") ; <CJK>
       (?$(H&Q(B . "0x5F28") ; <CJK>
       (?$(H&R(B . "0x5F22") ; <CJK>
       (?$(H&S(B . "0x5F23") ; <CJK>
       (?$(H&T(B . "0x5F24") ; <CJK>
       (?$(H&U(B . "0x5F54") ; <CJK>
       (?$(H&V(B . "0x5F82") ; <CJK>
       (?$(H&W(B . "0x5F7E") ; <CJK>
       (?$(H&X(B . "0x5F7D") ; <CJK>
       (?$(H&Y(B . "0x5FDE") ; <CJK>
       (?$(H&Z(B . "0x5FE5") ; <CJK>
       (?$(H&[(B . "0x602D") ; <CJK>
       (?$(H&\(B . "0x6026") ; <CJK>
       (?$(H&](B . "0x6019") ; <CJK>
       (?$(H&^(B . "0x6032") ; <CJK>
       (?$(H&_(B . "0x600B") ; <CJK>
       (?$(H&`(B . "0x6034") ; <CJK>
       (?$(H&a(B . "0x600A") ; <CJK>
       (?$(H&b(B . "0x6017") ; <CJK>
       (?$(H&c(B . "0x6033") ; <CJK>
       (?$(H&d(B . "0x601A") ; <CJK>
       (?$(H&e(B . "0x601E") ; <CJK>
       (?$(H&f(B . "0x602C") ; <CJK>
       (?$(H&g(B . "0x6022") ; <CJK>
       (?$(H&h(B . "0x600D") ; <CJK>
       (?$(H&i(B . "0x6010") ; <CJK>
       (?$(H&j(B . "0x602E") ; <CJK>
       (?$(H&k(B . "0x6013") ; <CJK>
       (?$(H&l(B . "0x6011") ; <CJK>
       (?$(H&m(B . "0x600C") ; <CJK>
       (?$(H&n(B . "0x6009") ; <CJK>
       (?$(H&o(B . "0x601C") ; <CJK>
       (?$(H&p(B . "0x6214") ; <CJK>
       (?$(H&q(B . "0x623D") ; <CJK>
       (?$(H&r(B . "0x62AD") ; <CJK>
       (?$(H&s(B . "0x62B4") ; <CJK>
       (?$(H&t(B . "0x62D1") ; <CJK>
       (?$(H&u(B . "0x62BE") ; <CJK>
       (?$(H&v(B . "0x62AA") ; <CJK>
       (?$(H&w(B . "0x62B6") ; <CJK>
       (?$(H&x(B . "0x62CA") ; <CJK>
       (?$(H&y(B . "0x62AE") ; <CJK>
       (?$(H&z(B . "0x62B3") ; <CJK>
       (?$(H&{(B . "0x62AF") ; <CJK>
       (?$(H&|(B . "0x62BB") ; <CJK>
       (?$(H&}(B . "0x62A9") ; <CJK>
       (?$(H&~(B . "0x62B0") ; <CJK>
       (?$(H'!(B . "0x62B8") ; <CJK>
       (?$(H'"(B . "0x653D") ; <CJK>
       (?$(H'#(B . "0x65A8") ; <CJK>
       (?$(H'$(B . "0x65BB") ; <CJK>
       (?$(H'%(B . "0x6609") ; <CJK>
       (?$(H'&(B . "0x65FC") ; <CJK>
       (?$(H''(B . "0x6604") ; <CJK>
       (?$(H'((B . "0x6612") ; <CJK>
       (?$(H')(B . "0x6608") ; <CJK>
       (?$(H'*(B . "0x65FB") ; <CJK>
       (?$(H'+(B . "0x6603") ; <CJK>
       (?$(H',(B . "0x660B") ; <CJK>
       (?$(H'-(B . "0x660D") ; <CJK>
       (?$(H'.(B . "0x6605") ; <CJK>
       (?$(H'/(B . "0x65FD") ; <CJK>
       (?$(H'0(B . "0x6611") ; <CJK>
       (?$(H'1(B . "0x6610") ; <CJK>
       (?$(H'2(B . "0x66F6") ; <CJK>
       (?$(H'3(B . "0x670A") ; <CJK>
       (?$(H'4(B . "0x6785") ; <CJK>
       (?$(H'5(B . "0x676C") ; <CJK>
       (?$(H'6(B . "0x678E") ; <CJK>
       (?$(H'7(B . "0x6792") ; <CJK>
       (?$(H'8(B . "0x6776") ; <CJK>
       (?$(H'9(B . "0x677B") ; <CJK>
       (?$(H':(B . "0x6798") ; <CJK>
       (?$(H';(B . "0x6786") ; <CJK>
       (?$(H'<(B . "0x6784") ; <CJK>
       (?$(H'=(B . "0x6774") ; <CJK>
       (?$(H'>(B . "0x678D") ; <CJK>
       (?$(H'?(B . "0x678C") ; <CJK>
       (?$(H'@(B . "0x677A") ; <CJK>
       (?$(H'A(B . "0x679F") ; <CJK>
       (?$(H'B(B . "0x6791") ; <CJK>
       (?$(H'C(B . "0x6799") ; <CJK>
       (?$(H'D(B . "0x6783") ; <CJK>
       (?$(H'E(B . "0x677D") ; <CJK>
       (?$(H'F(B . "0x6781") ; <CJK>
       (?$(H'G(B . "0x6778") ; <CJK>
       (?$(H'H(B . "0x6779") ; <CJK>
       (?$(H'I(B . "0x6794") ; <CJK>
       (?$(H'J(B . "0x6B25") ; <CJK>
       (?$(H'K(B . "0x6B80") ; <CJK>
       (?$(H'L(B . "0x6B7E") ; <CJK>
       (?$(H'M(B . "0x6BDE") ; <CJK>
       (?$(H'N(B . "0x6C1D") ; <CJK>
       (?$(H'O(B . "0x6C93") ; <CJK>
       (?$(H'P(B . "0x6CEC") ; <CJK>
       (?$(H'Q(B . "0x6CEB") ; <CJK>
       (?$(H'R(B . "0x6CEE") ; <CJK>
       (?$(H'S(B . "0x6CD9") ; <CJK>
       (?$(H'T(B . "0x6CB6") ; <CJK>
       (?$(H'U(B . "0x6CD4") ; <CJK>
       (?$(H'V(B . "0x6CAD") ; <CJK>
       (?$(H'W(B . "0x6CE7") ; <CJK>
       (?$(H'X(B . "0x6CB7") ; <CJK>
       (?$(H'Y(B . "0x6CD0") ; <CJK>
       (?$(H'Z(B . "0x6CC2") ; <CJK>
       (?$(H'[(B . "0x6CBA") ; <CJK>
       (?$(H'\(B . "0x6CC3") ; <CJK>
       (?$(H'](B . "0x6CC6") ; <CJK>
       (?$(H'^(B . "0x6CED") ; <CJK>
       (?$(H'_(B . "0x6CF2") ; <CJK>
       (?$(H'`(B . "0x6CD2") ; <CJK>
       (?$(H'a(B . "0x6CDD") ; <CJK>
       (?$(H'b(B . "0x6CB4") ; <CJK>
       (?$(H'c(B . "0x6C8A") ; <CJK>
       (?$(H'd(B . "0x6C9D") ; <CJK>
       (?$(H'e(B . "0x6C80") ; <CJK>
       (?$(H'f(B . "0x6CDE") ; <CJK>
       (?$(H'g(B . "0x6CC0") ; <CJK>
       (?$(H'h(B . "0x6D30") ; <CJK>
       (?$(H'i(B . "0x6CCD") ; <CJK>
       (?$(H'j(B . "0x6CC7") ; <CJK>
       (?$(H'k(B . "0x6CB0") ; <CJK>
       (?$(H'l(B . "0x6CF9") ; <CJK>
       (?$(H'm(B . "0x6CCF") ; <CJK>
       (?$(H'n(B . "0x6CE9") ; <CJK>
       (?$(H'o(B . "0x6CD1") ; <CJK>
       (?$(H'p(B . "0x7094") ; <CJK>
       (?$(H'q(B . "0x7098") ; <CJK>
       (?$(H'r(B . "0x7085") ; <CJK>
       (?$(H's(B . "0x7093") ; <CJK>
       (?$(H't(B . "0x7086") ; <CJK>
       (?$(H'u(B . "0x7084") ; <CJK>
       (?$(H'v(B . "0x7091") ; <CJK>
       (?$(H'w(B . "0x7096") ; <CJK>
       (?$(H'x(B . "0x7082") ; <CJK>
       (?$(H'y(B . "0x709A") ; <CJK>
       (?$(H'z(B . "0x7083") ; <CJK>
       (?$(H'{(B . "0x726A") ; <CJK>
       (?$(H'|(B . "0x72D6") ; <CJK>
       (?$(H'}(B . "0x72CB") ; <CJK>
       (?$(H'~(B . "0x72D8") ; <CJK>
       (?$(H(!(B . "0x72C9") ; <CJK>
       (?$(H("(B . "0x72DC") ; <CJK>
       (?$(H(#(B . "0x72D2") ; <CJK>
       (?$(H($(B . "0x72D4") ; <CJK>
       (?$(H(%(B . "0x72DA") ; <CJK>
       (?$(H(&(B . "0x72CC") ; <CJK>
       (?$(H('(B . "0x72D1") ; <CJK>
       (?$(H(((B . "0x73A4") ; <CJK>
       (?$(H()(B . "0x73A1") ; <CJK>
       (?$(H(*(B . "0x73AD") ; <CJK>
       (?$(H(+(B . "0x73A6") ; <CJK>
       (?$(H(,(B . "0x73A2") ; <CJK>
       (?$(H(-(B . "0x73A0") ; <CJK>
       (?$(H(.(B . "0x73AC") ; <CJK>
       (?$(H(/(B . "0x739D") ; <CJK>
       (?$(H(0(B . "0x74DD") ; <CJK>
       (?$(H(1(B . "0x74E8") ; <CJK>
       (?$(H(2(B . "0x753F") ; <CJK>
       (?$(H(3(B . "0x7540") ; <CJK>
       (?$(H(4(B . "0x753E") ; <CJK>
       (?$(H(5(B . "0x758C") ; <CJK>
       (?$(H(6(B . "0x7598") ; <CJK>
       (?$(H(7(B . "0x76AF") ; <CJK>
       (?$(H(8(B . "0x76F3") ; <CJK>
       (?$(H(9(B . "0x76F1") ; <CJK>
       (?$(H(:(B . "0x76F0") ; <CJK>
       (?$(H(;(B . "0x76F5") ; <CJK>
       (?$(H(<(B . "0x77F8") ; <CJK>
       (?$(H(=(B . "0x77FC") ; <CJK>
       (?$(H(>(B . "0x77F9") ; <CJK>
       (?$(H(?(B . "0x77FB") ; <CJK>
       (?$(H(@(B . "0x77FA") ; <CJK>
       (?$(H(A(B . "0x77F7") ; <CJK>
       (?$(H(B(B . "0x7942") ; <CJK>
       (?$(H(C(B . "0x793F") ; <CJK>
       (?$(H(D(B . "0x79C5") ; <CJK>
       (?$(H(E(B . "0x7A78") ; <CJK>
       (?$(H(F(B . "0x7A7B") ; <CJK>
       (?$(H(G(B . "0x7AFB") ; <CJK>
       (?$(H(H(B . "0x7C75") ; <CJK>
       (?$(H(I(B . "0x7CFD") ; <CJK>
       (?$(H(J(B . "0x8035") ; <CJK>
       (?$(H(K(B . "0x808F") ; <CJK>
       (?$(H(L(B . "0x80AE") ; <CJK>
       (?$(H(M(B . "0x80A3") ; <CJK>
       (?$(H(N(B . "0x80B8") ; <CJK>
       (?$(H(O(B . "0x80B5") ; <CJK>
       (?$(H(P(B . "0x80AD") ; <CJK>
       (?$(H(Q(B . "0x8220") ; <CJK>
       (?$(H(R(B . "0x82A0") ; <CJK>
       (?$(H(S(B . "0x82C0") ; <CJK>
       (?$(H(T(B . "0x82AB") ; <CJK>
       (?$(H(U(B . "0x829A") ; <CJK>
       (?$(H(V(B . "0x8298") ; <CJK>
       (?$(H(W(B . "0x829B") ; <CJK>
       (?$(H(X(B . "0x82B5") ; <CJK>
       (?$(H(Y(B . "0x82A7") ; <CJK>
       (?$(H(Z(B . "0x82AE") ; <CJK>
       (?$(H([(B . "0x82BC") ; <CJK>
       (?$(H(\(B . "0x829E") ; <CJK>
       (?$(H(](B . "0x82BA") ; <CJK>
       (?$(H(^(B . "0x82B4") ; <CJK>
       (?$(H(_(B . "0x82A8") ; <CJK>
       (?$(H(`(B . "0x82A1") ; <CJK>
       (?$(H(a(B . "0x82A9") ; <CJK>
       (?$(H(b(B . "0x82C2") ; <CJK>
       (?$(H(c(B . "0x82A4") ; <CJK>
       (?$(H(d(B . "0x82C3") ; <CJK>
       (?$(H(e(B . "0x82B6") ; <CJK>
       (?$(H(f(B . "0x82A2") ; <CJK>
       (?$(H(g(B . "0x8670") ; <CJK>
       (?$(H(h(B . "0x866F") ; <CJK>
       (?$(H(i(B . "0x866D") ; <CJK>
       (?$(H(j(B . "0x866E") ; <CJK>
       (?$(H(k(B . "0x8C56") ; <CJK>
       (?$(H(l(B . "0x8FD2") ; <CJK>
       (?$(H(m(B . "0x8FCB") ; <CJK>
       (?$(H(n(B . "0x8FD3") ; <CJK>
       (?$(H(o(B . "0x8FCD") ; <CJK>
       (?$(H(p(B . "0x8FD6") ; <CJK>
       (?$(H(q(B . "0x8FD5") ; <CJK>
       (?$(H(r(B . "0x8FD7") ; <CJK>
       (?$(H(s(B . "0x90B2") ; <CJK>
       (?$(H(t(B . "0x90B4") ; <CJK>
       (?$(H(u(B . "0x90AF") ; <CJK>
       (?$(H(v(B . "0x90B3") ; <CJK>
       (?$(H(w(B . "0x90B0") ; <CJK>
       (?$(H(x(B . "0x9639") ; <CJK>
       (?$(H(y(B . "0x963D") ; <CJK>
       (?$(H(z(B . "0x963C") ; <CJK>
       (?$(H({(B . "0x963A") ; <CJK>
       (?$(H(|(B . "0x9643") ; <CJK>
       (?$(H(}(B . "0x4FCD") ; <CJK>
       (?$(H(~(B . "0x4FC5") ; <CJK>
       (?$(H)!(B . "0x4FD3") ; <CJK>
       (?$(H)"(B . "0x4FB2") ; <CJK>
       (?$(H)#(B . "0x4FC9") ; <CJK>
       (?$(H)$(B . "0x4FCB") ; <CJK>
       (?$(H)%(B . "0x4FC1") ; <CJK>
       (?$(H)&(B . "0x4FD4") ; <CJK>
       (?$(H)'(B . "0x4FDC") ; <CJK>
       (?$(H)((B . "0x4FD9") ; <CJK>
       (?$(H))(B . "0x4FBB") ; <CJK>
       (?$(H)*(B . "0x4FB3") ; <CJK>
       (?$(H)+(B . "0x4FDB") ; <CJK>
       (?$(H),(B . "0x4FC7") ; <CJK>
       (?$(H)-(B . "0x4FD6") ; <CJK>
       (?$(H).(B . "0x4FBA") ; <CJK>
       (?$(H)/(B . "0x4FC0") ; <CJK>
       (?$(H)0(B . "0x4FB9") ; <CJK>
       (?$(H)1(B . "0x4FEC") ; <CJK>
       (?$(H)2(B . "0x5244") ; <CJK>
       (?$(H)3(B . "0x5249") ; <CJK>
       (?$(H)4(B . "0x52C0") ; <CJK>
       (?$(H)5(B . "0x52C2") ; <CJK>
       (?$(H)6(B . "0x533D") ; <CJK>
       (?$(H)7(B . "0x537C") ; <CJK>
       (?$(H)8(B . "0x5397") ; <CJK>
       (?$(H)9(B . "0x5396") ; <CJK>
       (?$(H):(B . "0x5399") ; <CJK>
       (?$(H);(B . "0x5398") ; <CJK>
       (?$(H)<(B . "0x54BA") ; <CJK>
       (?$(H)=(B . "0x54A1") ; <CJK>
       (?$(H)>(B . "0x54AD") ; <CJK>
       (?$(H)?(B . "0x54A5") ; <CJK>
       (?$(H)@(B . "0x54CF") ; <CJK>
       (?$(H)A(B . "0x54C3") ; <CJK>
       (?$(H)B(B . "0x830D") ; <CJK>
       (?$(H)C(B . "0x54B7") ; <CJK>
       (?$(H)D(B . "0x54AE") ; <CJK>
       (?$(H)E(B . "0x54D6") ; <CJK>
       (?$(H)F(B . "0x54B6") ; <CJK>
       (?$(H)G(B . "0x54C5") ; <CJK>
       (?$(H)H(B . "0x54C6") ; <CJK>
       (?$(H)I(B . "0x54A0") ; <CJK>
       (?$(H)J(B . "0x5470") ; <CJK>
       (?$(H)K(B . "0x54BC") ; <CJK>
       (?$(H)L(B . "0x54A2") ; <CJK>
       (?$(H)M(B . "0x54BE") ; <CJK>
       (?$(H)N(B . "0x5472") ; <CJK>
       (?$(H)O(B . "0x54DE") ; <CJK>
       (?$(H)P(B . "0x54B0") ; <CJK>
       (?$(H)Q(B . "0x57B5") ; <CJK>
       (?$(H)R(B . "0x579E") ; <CJK>
       (?$(H)S(B . "0x579F") ; <CJK>
       (?$(H)T(B . "0x57A4") ; <CJK>
       (?$(H)U(B . "0x578C") ; <CJK>
       (?$(H)V(B . "0x5797") ; <CJK>
       (?$(H)W(B . "0x579D") ; <CJK>
       (?$(H)X(B . "0x579B") ; <CJK>
       (?$(H)Y(B . "0x5794") ; <CJK>
       (?$(H)Z(B . "0x5798") ; <CJK>
       (?$(H)[(B . "0x578F") ; <CJK>
       (?$(H)\(B . "0x5799") ; <CJK>
       (?$(H)](B . "0x57A5") ; <CJK>
       (?$(H)^(B . "0x579A") ; <CJK>
       (?$(H)_(B . "0x5795") ; <CJK>
       (?$(H)`(B . "0x58F4") ; <CJK>
       (?$(H)a(B . "0x590D") ; <CJK>
       (?$(H)b(B . "0x5953") ; <CJK>
       (?$(H)c(B . "0x59E1") ; <CJK>
       (?$(H)d(B . "0x59DE") ; <CJK>
       (?$(H)e(B . "0x59EE") ; <CJK>
       (?$(H)f(B . "0x5A00") ; <CJK>
       (?$(H)g(B . "0x59F1") ; <CJK>
       (?$(H)h(B . "0x59DD") ; <CJK>
       (?$(H)i(B . "0x59FA") ; <CJK>
       (?$(H)j(B . "0x59FD") ; <CJK>
       (?$(H)k(B . "0x59FC") ; <CJK>
       (?$(H)l(B . "0x59F6") ; <CJK>
       (?$(H)m(B . "0x59E4") ; <CJK>
       (?$(H)n(B . "0x59F2") ; <CJK>
       (?$(H)o(B . "0x59F7") ; <CJK>
       (?$(H)p(B . "0x59DB") ; <CJK>
       (?$(H)q(B . "0x59E9") ; <CJK>
       (?$(H)r(B . "0x59F3") ; <CJK>
       (?$(H)s(B . "0x59F5") ; <CJK>
       (?$(H)t(B . "0x59E0") ; <CJK>
       (?$(H)u(B . "0x59FE") ; <CJK>
       (?$(H)v(B . "0x59F4") ; <CJK>
       (?$(H)w(B . "0x59ED") ; <CJK>
       (?$(H)x(B . "0x5BA8") ; <CJK>
       (?$(H)y(B . "0x5C4C") ; <CJK>
       (?$(H)z(B . "0x5CD0") ; <CJK>
       (?$(H){(B . "0x5CD8") ; <CJK>
       (?$(H)|(B . "0x5CCC") ; <CJK>
       (?$(H)}(B . "0x5CD7") ; <CJK>
       (?$(H)~(B . "0x5CCB") ; <CJK>
       (?$(H*!(B . "0x5CDB") ; <CJK>
       (?$(H*"(B . "0x5CDE") ; <CJK>
       (?$(H*#(B . "0x5CDA") ; <CJK>
       (?$(H*$(B . "0x5CC9") ; <CJK>
       (?$(H*%(B . "0x5CC7") ; <CJK>
       (?$(H*&(B . "0x5CCA") ; <CJK>
       (?$(H*'(B . "0x5CD6") ; <CJK>
       (?$(H*((B . "0x5CD3") ; <CJK>
       (?$(H*)(B . "0x5CD4") ; <CJK>
       (?$(H**(B . "0x5CCF") ; <CJK>
       (?$(H*+(B . "0x5CC8") ; <CJK>
       (?$(H*,(B . "0x5CC6") ; <CJK>
       (?$(H*-(B . "0x5CCE") ; <CJK>
       (?$(H*.(B . "0x5CDF") ; <CJK>
       (?$(H*/(B . "0x5CF8") ; <CJK>
       (?$(H*0(B . "0x5DF9") ; <CJK>
       (?$(H*1(B . "0x5E21") ; <CJK>
       (?$(H*2(B . "0x5E22") ; <CJK>
       (?$(H*3(B . "0x5E23") ; <CJK>
       (?$(H*4(B . "0x5E20") ; <CJK>
       (?$(H*5(B . "0x5E24") ; <CJK>
       (?$(H*6(B . "0x5EB0") ; <CJK>
       (?$(H*7(B . "0x5EA4") ; <CJK>
       (?$(H*8(B . "0x5EA2") ; <CJK>
       (?$(H*9(B . "0x5E9B") ; <CJK>
       (?$(H*:(B . "0x5EA3") ; <CJK>
       (?$(H*;(B . "0x5EA5") ; <CJK>
       (?$(H*<(B . "0x5F07") ; <CJK>
       (?$(H*=(B . "0x5F2E") ; <CJK>
       (?$(H*>(B . "0x5F56") ; <CJK>
       (?$(H*?(B . "0x5F86") ; <CJK>
       (?$(H*@(B . "0x6037") ; <CJK>
       (?$(H*A(B . "0x6039") ; <CJK>
       (?$(H*B(B . "0x6054") ; <CJK>
       (?$(H*C(B . "0x6072") ; <CJK>
       (?$(H*D(B . "0x605E") ; <CJK>
       (?$(H*E(B . "0x6045") ; <CJK>
       (?$(H*F(B . "0x6053") ; <CJK>
       (?$(H*G(B . "0x6047") ; <CJK>
       (?$(H*H(B . "0x6049") ; <CJK>
       (?$(H*I(B . "0x605B") ; <CJK>
       (?$(H*J(B . "0x604C") ; <CJK>
       (?$(H*K(B . "0x6040") ; <CJK>
       (?$(H*L(B . "0x6042") ; <CJK>
       (?$(H*M(B . "0x605F") ; <CJK>
       (?$(H*N(B . "0x6024") ; <CJK>
       (?$(H*O(B . "0x6044") ; <CJK>
       (?$(H*P(B . "0x6058") ; <CJK>
       (?$(H*Q(B . "0x6066") ; <CJK>
       (?$(H*R(B . "0x606E") ; <CJK>
       (?$(H*S(B . "0x6242") ; <CJK>
       (?$(H*T(B . "0x6243") ; <CJK>
       (?$(H*U(B . "0x62CF") ; <CJK>
       (?$(H*V(B . "0x630D") ; <CJK>
       (?$(H*W(B . "0x630B") ; <CJK>
       (?$(H*X(B . "0x62F5") ; <CJK>
       (?$(H*Y(B . "0x630E") ; <CJK>
       (?$(H*Z(B . "0x6303") ; <CJK>
       (?$(H*[(B . "0x62EB") ; <CJK>
       (?$(H*\(B . "0x62F9") ; <CJK>
       (?$(H*](B . "0x630F") ; <CJK>
       (?$(H*^(B . "0x630C") ; <CJK>
       (?$(H*_(B . "0x62F8") ; <CJK>
       (?$(H*`(B . "0x62F6") ; <CJK>
       (?$(H*a(B . "0x6300") ; <CJK>
       (?$(H*b(B . "0x6313") ; <CJK>
       (?$(H*c(B . "0x6314") ; <CJK>
       (?$(H*d(B . "0x62FA") ; <CJK>
       (?$(H*e(B . "0x6315") ; <CJK>
       (?$(H*f(B . "0x62FB") ; <CJK>
       (?$(H*g(B . "0x62F0") ; <CJK>
       (?$(H*h(B . "0x6541") ; <CJK>
       (?$(H*i(B . "0x6543") ; <CJK>
       (?$(H*j(B . "0x65AA") ; <CJK>
       (?$(H*k(B . "0x65BF") ; <CJK>
       (?$(H*l(B . "0x6636") ; <CJK>
       (?$(H*m(B . "0x6621") ; <CJK>
       (?$(H*n(B . "0x6632") ; <CJK>
       (?$(H*o(B . "0x6635") ; <CJK>
       (?$(H*p(B . "0x661C") ; <CJK>
       (?$(H*q(B . "0x6626") ; <CJK>
       (?$(H*r(B . "0x6622") ; <CJK>
       (?$(H*s(B . "0x6633") ; <CJK>
       (?$(H*t(B . "0x662B") ; <CJK>
       (?$(H*u(B . "0x663A") ; <CJK>
       (?$(H*v(B . "0x661D") ; <CJK>
       (?$(H*w(B . "0x6634") ; <CJK>
       (?$(H*x(B . "0x6639") ; <CJK>
       (?$(H*y(B . "0x662E") ; <CJK>
       (?$(H*z(B . "0x670F") ; <CJK>
       (?$(H*{(B . "0x6710") ; <CJK>
       (?$(H*|(B . "0x67C1") ; <CJK>
       (?$(H*}(B . "0x67F2") ; <CJK>
       (?$(H*~(B . "0x67C8") ; <CJK>
       (?$(H+!(B . "0x67BA") ; <CJK>
       (?$(H+"(B . "0x67DC") ; <CJK>
       (?$(H+#(B . "0x67BB") ; <CJK>
       (?$(H+$(B . "0x67F8") ; <CJK>
       (?$(H+%(B . "0x67D8") ; <CJK>
       (?$(H+&(B . "0x67C0") ; <CJK>
       (?$(H+'(B . "0x67B7") ; <CJK>
       (?$(H+((B . "0x67C5") ; <CJK>
       (?$(H+)(B . "0x67EB") ; <CJK>
       (?$(H+*(B . "0x67E4") ; <CJK>
       (?$(H++(B . "0x67DF") ; <CJK>
       (?$(H+,(B . "0x67B5") ; <CJK>
       (?$(H+-(B . "0x67CD") ; <CJK>
       (?$(H+.(B . "0x67B3") ; <CJK>
       (?$(H+/(B . "0x67F7") ; <CJK>
       (?$(H+0(B . "0x67F6") ; <CJK>
       (?$(H+1(B . "0x67EE") ; <CJK>
       (?$(H+2(B . "0x67E3") ; <CJK>
       (?$(H+3(B . "0x67C2") ; <CJK>
       (?$(H+4(B . "0x67B9") ; <CJK>
       (?$(H+5(B . "0x67CE") ; <CJK>
       (?$(H+6(B . "0x67E7") ; <CJK>
       (?$(H+7(B . "0x67F0") ; <CJK>
       (?$(H+8(B . "0x67B2") ; <CJK>
       (?$(H+9(B . "0x67FC") ; <CJK>
       (?$(H+:(B . "0x67C6") ; <CJK>
       (?$(H+;(B . "0x67ED") ; <CJK>
       (?$(H+<(B . "0x67CC") ; <CJK>
       (?$(H+=(B . "0x67AE") ; <CJK>
       (?$(H+>(B . "0x67E6") ; <CJK>
       (?$(H+?(B . "0x67DB") ; <CJK>
       (?$(H+@(B . "0x67FA") ; <CJK>
       (?$(H+A(B . "0x67C9") ; <CJK>
       (?$(H+B(B . "0x67CA") ; <CJK>
       (?$(H+C(B . "0x67C3") ; <CJK>
       (?$(H+D(B . "0x67EA") ; <CJK>
       (?$(H+E(B . "0x67CB") ; <CJK>
       (?$(H+F(B . "0x6B28") ; <CJK>
       (?$(H+G(B . "0x6B82") ; <CJK>
       (?$(H+H(B . "0x6B84") ; <CJK>
       (?$(H+I(B . "0x6BB6") ; <CJK>
       (?$(H+J(B . "0x6BD6") ; <CJK>
       (?$(H+K(B . "0x6BD8") ; <CJK>
       (?$(H+L(B . "0x6BE0") ; <CJK>
       (?$(H+M(B . "0x6C20") ; <CJK>
       (?$(H+N(B . "0x6C21") ; <CJK>
       (?$(H+O(B . "0x6D28") ; <CJK>
       (?$(H+P(B . "0x6D34") ; <CJK>
       (?$(H+Q(B . "0x6D2D") ; <CJK>
       (?$(H+R(B . "0x6D1F") ; <CJK>
       (?$(H+S(B . "0x6D3C") ; <CJK>
       (?$(H+T(B . "0x6D3F") ; <CJK>
       (?$(H+U(B . "0x6D12") ; <CJK>
       (?$(H+V(B . "0x6D0A") ; <CJK>
       (?$(H+W(B . "0x6CDA") ; <CJK>
       (?$(H+X(B . "0x6D33") ; <CJK>
       (?$(H+Y(B . "0x6D04") ; <CJK>
       (?$(H+Z(B . "0x6D19") ; <CJK>
       (?$(H+[(B . "0x6D3A") ; <CJK>
       (?$(H+\(B . "0x6D1A") ; <CJK>
       (?$(H+](B . "0x6D11") ; <CJK>
       (?$(H+^(B . "0x6D00") ; <CJK>
       (?$(H+_(B . "0x6D1D") ; <CJK>
       (?$(H+`(B . "0x6D42") ; <CJK>
       (?$(H+a(B . "0x6D01") ; <CJK>
       (?$(H+b(B . "0x6D18") ; <CJK>
       (?$(H+c(B . "0x6D37") ; <CJK>
       (?$(H+d(B . "0x6D03") ; <CJK>
       (?$(H+e(B . "0x6D0F") ; <CJK>
       (?$(H+f(B . "0x6D40") ; <CJK>
       (?$(H+g(B . "0x6D07") ; <CJK>
       (?$(H+h(B . "0x6D20") ; <CJK>
       (?$(H+i(B . "0x6D2C") ; <CJK>
       (?$(H+j(B . "0x6D08") ; <CJK>
       (?$(H+k(B . "0x6D22") ; <CJK>
       (?$(H+l(B . "0x6D09") ; <CJK>
       (?$(H+m(B . "0x6D10") ; <CJK>
       (?$(H+n(B . "0x70B7") ; <CJK>
       (?$(H+o(B . "0x709F") ; <CJK>
       (?$(H+p(B . "0x70BE") ; <CJK>
       (?$(H+q(B . "0x70B1") ; <CJK>
       (?$(H+r(B . "0x70B0") ; <CJK>
       (?$(H+s(B . "0x70A1") ; <CJK>
       (?$(H+t(B . "0x70B4") ; <CJK>
       (?$(H+u(B . "0x70B5") ; <CJK>
       (?$(H+v(B . "0x70A9") ; <CJK>
       (?$(H+w(B . "0x7241") ; <CJK>
       (?$(H+x(B . "0x7249") ; <CJK>
       (?$(H+y(B . "0x724A") ; <CJK>
       (?$(H+z(B . "0x726C") ; <CJK>
       (?$(H+{(B . "0x7270") ; <CJK>
       (?$(H+|(B . "0x7273") ; <CJK>
       (?$(H+}(B . "0x726E") ; <CJK>
       (?$(H+~(B . "0x72CA") ; <CJK>
       (?$(H,!(B . "0x72E4") ; <CJK>
       (?$(H,"(B . "0x72E8") ; <CJK>
       (?$(H,#(B . "0x72EB") ; <CJK>
       (?$(H,$(B . "0x72DF") ; <CJK>
       (?$(H,%(B . "0x72EA") ; <CJK>
       (?$(H,&(B . "0x72E6") ; <CJK>
       (?$(H,'(B . "0x72E3") ; <CJK>
       (?$(H,((B . "0x7385") ; <CJK>
       (?$(H,)(B . "0x73CC") ; <CJK>
       (?$(H,*(B . "0x73C2") ; <CJK>
       (?$(H,+(B . "0x73C8") ; <CJK>
       (?$(H,,(B . "0x73C5") ; <CJK>
       (?$(H,-(B . "0x73B9") ; <CJK>
       (?$(H,.(B . "0x73B6") ; <CJK>
       (?$(H,/(B . "0x73B5") ; <CJK>
       (?$(H,0(B . "0x73B4") ; <CJK>
       (?$(H,1(B . "0x73EB") ; <CJK>
       (?$(H,2(B . "0x73BF") ; <CJK>
       (?$(H,3(B . "0x73C7") ; <CJK>
       (?$(H,4(B . "0x73BE") ; <CJK>
       (?$(H,5(B . "0x73C3") ; <CJK>
       (?$(H,6(B . "0x73C6") ; <CJK>
       (?$(H,7(B . "0x73B8") ; <CJK>
       (?$(H,8(B . "0x73CB") ; <CJK>
       (?$(H,9(B . "0x74EC") ; <CJK>
       (?$(H,:(B . "0x74EE") ; <CJK>
       (?$(H,;(B . "0x752E") ; <CJK>
       (?$(H,<(B . "0x7547") ; <CJK>
       (?$(H,=(B . "0x7548") ; <CJK>
       (?$(H,>(B . "0x75A7") ; <CJK>
       (?$(H,?(B . "0x75AA") ; <CJK>
       (?$(H,@(B . "0x7679") ; <CJK>
       (?$(H,A(B . "0x76C4") ; <CJK>
       (?$(H,B(B . "0x7708") ; <CJK>
       (?$(H,C(B . "0x7703") ; <CJK>
       (?$(H,D(B . "0x7704") ; <CJK>
       (?$(H,E(B . "0x7705") ; <CJK>
       (?$(H,F(B . "0x770A") ; <CJK>
       (?$(H,G(B . "0x76F7") ; <CJK>
       (?$(H,H(B . "0x76FB") ; <CJK>
       (?$(H,I(B . "0x76FA") ; <CJK>
       (?$(H,J(B . "0x77E7") ; <CJK>
       (?$(H,K(B . "0x77E8") ; <CJK>
       (?$(H,L(B . "0x7806") ; <CJK>
       (?$(H,M(B . "0x7811") ; <CJK>
       (?$(H,N(B . "0x7812") ; <CJK>
       (?$(H,O(B . "0x7805") ; <CJK>
       (?$(H,P(B . "0x7810") ; <CJK>
       (?$(H,Q(B . "0x780F") ; <CJK>
       (?$(H,R(B . "0x780E") ; <CJK>
       (?$(H,S(B . "0x7809") ; <CJK>
       (?$(H,T(B . "0x7803") ; <CJK>
       (?$(H,U(B . "0x7813") ; <CJK>
       (?$(H,V(B . "0x794A") ; <CJK>
       (?$(H,W(B . "0x794C") ; <CJK>
       (?$(H,X(B . "0x794B") ; <CJK>
       (?$(H,Y(B . "0x7945") ; <CJK>
       (?$(H,Z(B . "0x7944") ; <CJK>
       (?$(H,[(B . "0x79D5") ; <CJK>
       (?$(H,\(B . "0x79CD") ; <CJK>
       (?$(H,](B . "0x79CF") ; <CJK>
       (?$(H,^(B . "0x79D6") ; <CJK>
       (?$(H,_(B . "0x79CE") ; <CJK>
       (?$(H,`(B . "0x7A80") ; <CJK>
       (?$(H,a(B . "0x7A7E") ; <CJK>
       (?$(H,b(B . "0x7AD1") ; <CJK>
       (?$(H,c(B . "0x7B00") ; <CJK>
       (?$(H,d(B . "0x7B01") ; <CJK>
       (?$(H,e(B . "0x7C7A") ; <CJK>
       (?$(H,f(B . "0x7C78") ; <CJK>
       (?$(H,g(B . "0x7C79") ; <CJK>
       (?$(H,h(B . "0x7C7F") ; <CJK>
       (?$(H,i(B . "0x7C80") ; <CJK>
       (?$(H,j(B . "0x7C81") ; <CJK>
       (?$(H,k(B . "0x7D03") ; <CJK>
       (?$(H,l(B . "0x7D08") ; <CJK>
       (?$(H,m(B . "0x7D01") ; <CJK>
       (?$(H,n(B . "0x7F58") ; <CJK>
       (?$(H,o(B . "0x7F91") ; <CJK>
       (?$(H,p(B . "0x7F8D") ; <CJK>
       (?$(H,q(B . "0x7FBE") ; <CJK>
       (?$(H,r(B . "0x8007") ; <CJK>
       (?$(H,s(B . "0x800E") ; <CJK>
       (?$(H,t(B . "0x800F") ; <CJK>
       (?$(H,u(B . "0x8014") ; <CJK>
       (?$(H,v(B . "0x8037") ; <CJK>
       (?$(H,w(B . "0x80D8") ; <CJK>
       (?$(H,x(B . "0x80C7") ; <CJK>
       (?$(H,y(B . "0x80E0") ; <CJK>
       (?$(H,z(B . "0x80D1") ; <CJK>
       (?$(H,{(B . "0x80C8") ; <CJK>
       (?$(H,|(B . "0x80C2") ; <CJK>
       (?$(H,}(B . "0x80D0") ; <CJK>
       (?$(H,~(B . "0x80C5") ; <CJK>
       (?$(H-!(B . "0x80E3") ; <CJK>
       (?$(H-"(B . "0x80D9") ; <CJK>
       (?$(H-#(B . "0x80DC") ; <CJK>
       (?$(H-$(B . "0x80CA") ; <CJK>
       (?$(H-%(B . "0x80D5") ; <CJK>
       (?$(H-&(B . "0x80C9") ; <CJK>
       (?$(H-'(B . "0x80CF") ; <CJK>
       (?$(H-((B . "0x80D7") ; <CJK>
       (?$(H-)(B . "0x80E6") ; <CJK>
       (?$(H-*(B . "0x80CD") ; <CJK>
       (?$(H-+(B . "0x81FF") ; <CJK>
       (?$(H-,(B . "0x8221") ; <CJK>
       (?$(H--(B . "0x8294") ; <CJK>
       (?$(H-.(B . "0x82D9") ; <CJK>
       (?$(H-/(B . "0x82FE") ; <CJK>
       (?$(H-0(B . "0x82F9") ; <CJK>
       (?$(H-1(B . "0x8307") ; <CJK>
       (?$(H-2(B . "0x82E8") ; <CJK>
       (?$(H-3(B . "0x8300") ; <CJK>
       (?$(H-4(B . "0x82D5") ; <CJK>
       (?$(H-5(B . "0x833A") ; <CJK>
       (?$(H-6(B . "0x82EB") ; <CJK>
       (?$(H-7(B . "0x82D6") ; <CJK>
       (?$(H-8(B . "0x82F4") ; <CJK>
       (?$(H-9(B . "0x82EC") ; <CJK>
       (?$(H-:(B . "0x82E1") ; <CJK>
       (?$(H-;(B . "0x82F2") ; <CJK>
       (?$(H-<(B . "0x82F5") ; <CJK>
       (?$(H-=(B . "0x830C") ; <CJK>
       (?$(H->(B . "0x82FB") ; <CJK>
       (?$(H-?(B . "0x82F6") ; <CJK>
       (?$(H-@(B . "0x82F0") ; <CJK>
       (?$(H-A(B . "0x82EA") ; <CJK>
       (?$(H-B(B . "0x82E4") ; <CJK>
       (?$(H-C(B . "0x82E0") ; <CJK>
       (?$(H-D(B . "0x82FA") ; <CJK>
       (?$(H-E(B . "0x82F3") ; <CJK>
       (?$(H-F(B . "0x82ED") ; <CJK>
       (?$(H-G(B . "0x8677") ; <CJK>
       (?$(H-H(B . "0x8674") ; <CJK>
       (?$(H-I(B . "0x867C") ; <CJK>
       (?$(H-J(B . "0x8673") ; <CJK>
       (?$(H-K(B . "0x8841") ; <CJK>
       (?$(H-L(B . "0x884E") ; <CJK>
       (?$(H-M(B . "0x8867") ; <CJK>
       (?$(H-N(B . "0x886A") ; <CJK>
       (?$(H-O(B . "0x8869") ; <CJK>
       (?$(H-P(B . "0x89D3") ; <CJK>
       (?$(H-Q(B . "0x8A04") ; <CJK>
       (?$(H-R(B . "0x8A07") ; <CJK>
       (?$(H-S(B . "0x8D72") ; <CJK>
       (?$(H-T(B . "0x8FE3") ; <CJK>
       (?$(H-U(B . "0x8FE1") ; <CJK>
       (?$(H-V(B . "0x8FEE") ; <CJK>
       (?$(H-W(B . "0x8FE0") ; <CJK>
       (?$(H-X(B . "0x90F1") ; <CJK>
       (?$(H-Y(B . "0x90BD") ; <CJK>
       (?$(H-Z(B . "0x90BF") ; <CJK>
       (?$(H-[(B . "0x90D5") ; <CJK>
       (?$(H-\(B . "0x90C5") ; <CJK>
       (?$(H-](B . "0x90BE") ; <CJK>
       (?$(H-^(B . "0x90C7") ; <CJK>
       (?$(H-_(B . "0x90CB") ; <CJK>
       (?$(H-`(B . "0x90C8") ; <CJK>
       (?$(H-a(B . "0x91D4") ; <CJK>
       (?$(H-b(B . "0x91D3") ; <CJK>
       (?$(H-c(B . "0x9654") ; <CJK>
       (?$(H-d(B . "0x964F") ; <CJK>
       (?$(H-e(B . "0x9651") ; <CJK>
       (?$(H-f(B . "0x9653") ; <CJK>
       (?$(H-g(B . "0x964A") ; <CJK>
       (?$(H-h(B . "0x964E") ; <CJK>
       (?$(H-i(B . "0x501E") ; <CJK>
       (?$(H-j(B . "0x5005") ; <CJK>
       (?$(H-k(B . "0x5007") ; <CJK>
       (?$(H-l(B . "0x5013") ; <CJK>
       (?$(H-m(B . "0x5022") ; <CJK>
       (?$(H-n(B . "0x5030") ; <CJK>
       (?$(H-o(B . "0x501B") ; <CJK>
       (?$(H-p(B . "0x4FF5") ; <CJK>
       (?$(H-q(B . "0x4FF4") ; <CJK>
       (?$(H-r(B . "0x5033") ; <CJK>
       (?$(H-s(B . "0x5037") ; <CJK>
       (?$(H-t(B . "0x502C") ; <CJK>
       (?$(H-u(B . "0x4FF6") ; <CJK>
       (?$(H-v(B . "0x4FF7") ; <CJK>
       (?$(H-w(B . "0x5017") ; <CJK>
       (?$(H-x(B . "0x501C") ; <CJK>
       (?$(H-y(B . "0x5020") ; <CJK>
       (?$(H-z(B . "0x5027") ; <CJK>
       (?$(H-{(B . "0x5035") ; <CJK>
       (?$(H-|(B . "0x502F") ; <CJK>
       (?$(H-}(B . "0x5031") ; <CJK>
       (?$(H-~(B . "0x500E") ; <CJK>
       (?$(H.!(B . "0x515A") ; <CJK>
       (?$(H."(B . "0x5194") ; <CJK>
       (?$(H.#(B . "0x5193") ; <CJK>
       (?$(H.$(B . "0x51CA") ; <CJK>
       (?$(H.%(B . "0x51C4") ; <CJK>
       (?$(H.&(B . "0x51C5") ; <CJK>
       (?$(H.'(B . "0x51C8") ; <CJK>
       (?$(H.((B . "0x51CE") ; <CJK>
       (?$(H.)(B . "0x5261") ; <CJK>
       (?$(H.*(B . "0x525A") ; <CJK>
       (?$(H.+(B . "0x5252") ; <CJK>
       (?$(H.,(B . "0x525E") ; <CJK>
       (?$(H.-(B . "0x525F") ; <CJK>
       (?$(H..(B . "0x5255") ; <CJK>
       (?$(H./(B . "0x5262") ; <CJK>
       (?$(H.0(B . "0x52CD") ; <CJK>
       (?$(H.1(B . "0x530E") ; <CJK>
       (?$(H.2(B . "0x539E") ; <CJK>
       (?$(H.3(B . "0x5526") ; <CJK>
       (?$(H.4(B . "0x54E2") ; <CJK>
       (?$(H.5(B . "0x5517") ; <CJK>
       (?$(H.6(B . "0x5512") ; <CJK>
       (?$(H.7(B . "0x54E7") ; <CJK>
       (?$(H.8(B . "0x54F3") ; <CJK>
       (?$(H.9(B . "0x54E4") ; <CJK>
       (?$(H.:(B . "0x551A") ; <CJK>
       (?$(H.;(B . "0x54FF") ; <CJK>
       (?$(H.<(B . "0x5504") ; <CJK>
       (?$(H.=(B . "0x5508") ; <CJK>
       (?$(H.>(B . "0x54EB") ; <CJK>
       (?$(H.?(B . "0x5511") ; <CJK>
       (?$(H.@(B . "0x5505") ; <CJK>
       (?$(H.A(B . "0x54F1") ; <CJK>
       (?$(H.B(B . "0x550A") ; <CJK>
       (?$(H.C(B . "0x54FB") ; <CJK>
       (?$(H.D(B . "0x54F7") ; <CJK>
       (?$(H.E(B . "0x54F8") ; <CJK>
       (?$(H.F(B . "0x54E0") ; <CJK>
       (?$(H.G(B . "0x550E") ; <CJK>
       (?$(H.H(B . "0x5503") ; <CJK>
       (?$(H.I(B . "0x550B") ; <CJK>
       (?$(H.J(B . "0x5701") ; <CJK>
       (?$(H.K(B . "0x5702") ; <CJK>
       (?$(H.L(B . "0x57CC") ; <CJK>
       (?$(H.M(B . "0x5832") ; <CJK>
       (?$(H.N(B . "0x57D5") ; <CJK>
       (?$(H.O(B . "0x57D2") ; <CJK>
       (?$(H.P(B . "0x57BA") ; <CJK>
       (?$(H.Q(B . "0x57C6") ; <CJK>
       (?$(H.R(B . "0x57BD") ; <CJK>
       (?$(H.S(B . "0x57BC") ; <CJK>
       (?$(H.T(B . "0x57B8") ; <CJK>
       (?$(H.U(B . "0x57B6") ; <CJK>
       (?$(H.V(B . "0x57BF") ; <CJK>
       (?$(H.W(B . "0x57C7") ; <CJK>
       (?$(H.X(B . "0x57D0") ; <CJK>
       (?$(H.Y(B . "0x57B9") ; <CJK>
       (?$(H.Z(B . "0x57C1") ; <CJK>
       (?$(H.[(B . "0x590E") ; <CJK>
       (?$(H.\(B . "0x594A") ; <CJK>
       (?$(H.](B . "0x5A19") ; <CJK>
       (?$(H.^(B . "0x5A16") ; <CJK>
       (?$(H._(B . "0x5A2D") ; <CJK>
       (?$(H.`(B . "0x5A2E") ; <CJK>
       (?$(H.a(B . "0x5A15") ; <CJK>
       (?$(H.b(B . "0x5A0F") ; <CJK>
       (?$(H.c(B . "0x5A17") ; <CJK>
       (?$(H.d(B . "0x5A0A") ; <CJK>
       (?$(H.e(B . "0x5A1E") ; <CJK>
       (?$(H.f(B . "0x5A33") ; <CJK>
       (?$(H.g(B . "0x5B6C") ; <CJK>
       (?$(H.h(B . "0x5BA7") ; <CJK>
       (?$(H.i(B . "0x5BAD") ; <CJK>
       (?$(H.j(B . "0x5BAC") ; <CJK>
       (?$(H.k(B . "0x5C03") ; <CJK>
       (?$(H.l(B . "0x5C56") ; <CJK>
       (?$(H.m(B . "0x5C54") ; <CJK>
       (?$(H.n(B . "0x5CEC") ; <CJK>
       (?$(H.o(B . "0x5CFF") ; <CJK>
       (?$(H.p(B . "0x5CEE") ; <CJK>
       (?$(H.q(B . "0x5CF1") ; <CJK>
       (?$(H.r(B . "0x5CF7") ; <CJK>
       (?$(H.s(B . "0x5D00") ; <CJK>
       (?$(H.t(B . "0x5CF9") ; <CJK>
       (?$(H.u(B . "0x5E29") ; <CJK>
       (?$(H.v(B . "0x5E28") ; <CJK>
       (?$(H.w(B . "0x5EA8") ; <CJK>
       (?$(H.x(B . "0x5EAE") ; <CJK>
       (?$(H.y(B . "0x5EAA") ; <CJK>
       (?$(H.z(B . "0x5EAC") ; <CJK>
       (?$(H.{(B . "0x5F33") ; <CJK>
       (?$(H.|(B . "0x5F30") ; <CJK>
       (?$(H.}(B . "0x5F67") ; <CJK>
       (?$(H.~(B . "0x605D") ; <CJK>
       (?$(H/!(B . "0x605A") ; <CJK>
       (?$(H/"(B . "0x6067") ; <CJK>
       (?$(H/#(B . "0x6041") ; <CJK>
       (?$(H/$(B . "0x60A2") ; <CJK>
       (?$(H/%(B . "0x6088") ; <CJK>
       (?$(H/&(B . "0x6080") ; <CJK>
       (?$(H/'(B . "0x6092") ; <CJK>
       (?$(H/((B . "0x6081") ; <CJK>
       (?$(H/)(B . "0x609D") ; <CJK>
       (?$(H/*(B . "0x6083") ; <CJK>
       (?$(H/+(B . "0x6095") ; <CJK>
       (?$(H/,(B . "0x609B") ; <CJK>
       (?$(H/-(B . "0x6097") ; <CJK>
       (?$(H/.(B . "0x6087") ; <CJK>
       (?$(H//(B . "0x609C") ; <CJK>
       (?$(H/0(B . "0x608E") ; <CJK>
       (?$(H/1(B . "0x6219") ; <CJK>
       (?$(H/2(B . "0x6246") ; <CJK>
       (?$(H/3(B . "0x62F2") ; <CJK>
       (?$(H/4(B . "0x6310") ; <CJK>
       (?$(H/5(B . "0x6356") ; <CJK>
       (?$(H/6(B . "0x632C") ; <CJK>
       (?$(H/7(B . "0x6344") ; <CJK>
       (?$(H/8(B . "0x6345") ; <CJK>
       (?$(H/9(B . "0x6336") ; <CJK>
       (?$(H/:(B . "0x6343") ; <CJK>
       (?$(H/;(B . "0x63E4") ; <CJK>
       (?$(H/<(B . "0x6339") ; <CJK>
       (?$(H/=(B . "0x634B") ; <CJK>
       (?$(H/>(B . "0x634A") ; <CJK>
       (?$(H/?(B . "0x633C") ; <CJK>
       (?$(H/@(B . "0x6329") ; <CJK>
       (?$(H/A(B . "0x6341") ; <CJK>
       (?$(H/B(B . "0x6334") ; <CJK>
       (?$(H/C(B . "0x6358") ; <CJK>
       (?$(H/D(B . "0x6354") ; <CJK>
       (?$(H/E(B . "0x6359") ; <CJK>
       (?$(H/F(B . "0x632D") ; <CJK>
       (?$(H/G(B . "0x6347") ; <CJK>
       (?$(H/H(B . "0x6333") ; <CJK>
       (?$(H/I(B . "0x635A") ; <CJK>
       (?$(H/J(B . "0x6351") ; <CJK>
       (?$(H/K(B . "0x6338") ; <CJK>
       (?$(H/L(B . "0x6357") ; <CJK>
       (?$(H/M(B . "0x6340") ; <CJK>
       (?$(H/N(B . "0x6348") ; <CJK>
       (?$(H/O(B . "0x654A") ; <CJK>
       (?$(H/P(B . "0x6546") ; <CJK>
       (?$(H/Q(B . "0x65C6") ; <CJK>
       (?$(H/R(B . "0x65C3") ; <CJK>
       (?$(H/S(B . "0x65C4") ; <CJK>
       (?$(H/T(B . "0x65C2") ; <CJK>
       (?$(H/U(B . "0x664A") ; <CJK>
       (?$(H/V(B . "0x665F") ; <CJK>
       (?$(H/W(B . "0x6647") ; <CJK>
       (?$(H/X(B . "0x6651") ; <CJK>
       (?$(H/Y(B . "0x6712") ; <CJK>
       (?$(H/Z(B . "0x6713") ; <CJK>
       (?$(H/[(B . "0x681F") ; <CJK>
       (?$(H/\(B . "0x681A") ; <CJK>
       (?$(H/](B . "0x6849") ; <CJK>
       (?$(H/^(B . "0x6832") ; <CJK>
       (?$(H/_(B . "0x6833") ; <CJK>
       (?$(H/`(B . "0x683B") ; <CJK>
       (?$(H/a(B . "0x684B") ; <CJK>
       (?$(H/b(B . "0x684F") ; <CJK>
       (?$(H/c(B . "0x6816") ; <CJK>
       (?$(H/d(B . "0x6831") ; <CJK>
       (?$(H/e(B . "0x681C") ; <CJK>
       (?$(H/f(B . "0x6835") ; <CJK>
       (?$(H/g(B . "0x682B") ; <CJK>
       (?$(H/h(B . "0x682D") ; <CJK>
       (?$(H/i(B . "0x682F") ; <CJK>
       (?$(H/j(B . "0x684E") ; <CJK>
       (?$(H/k(B . "0x6844") ; <CJK>
       (?$(H/l(B . "0x6834") ; <CJK>
       (?$(H/m(B . "0x681D") ; <CJK>
       (?$(H/n(B . "0x6812") ; <CJK>
       (?$(H/o(B . "0x6814") ; <CJK>
       (?$(H/p(B . "0x6826") ; <CJK>
       (?$(H/q(B . "0x6828") ; <CJK>
       (?$(H/r(B . "0x682E") ; <CJK>
       (?$(H/s(B . "0x684D") ; <CJK>
       (?$(H/t(B . "0x683A") ; <CJK>
       (?$(H/u(B . "0x6825") ; <CJK>
       (?$(H/v(B . "0x6820") ; <CJK>
       (?$(H/w(B . "0x6B2C") ; <CJK>
       (?$(H/x(B . "0x6B2F") ; <CJK>
       (?$(H/y(B . "0x6B2D") ; <CJK>
       (?$(H/z(B . "0x6B31") ; <CJK>
       (?$(H/{(B . "0x6B34") ; <CJK>
       (?$(H/|(B . "0x6B6D") ; <CJK>
       (?$(H/}(B . "0x8082") ; <CJK>
       (?$(H/~(B . "0x6B88") ; <CJK>
       (?$(H0!(B . "0x6BE6") ; <CJK>
       (?$(H0"(B . "0x6BE4") ; <CJK>
       (?$(H0#(B . "0x6BE8") ; <CJK>
       (?$(H0$(B . "0x6BE3") ; <CJK>
       (?$(H0%(B . "0x6BE2") ; <CJK>
       (?$(H0&(B . "0x6BE7") ; <CJK>
       (?$(H0'(B . "0x6C25") ; <CJK>
       (?$(H0((B . "0x6D7A") ; <CJK>
       (?$(H0)(B . "0x6D63") ; <CJK>
       (?$(H0*(B . "0x6D64") ; <CJK>
       (?$(H0+(B . "0x6D76") ; <CJK>
       (?$(H0,(B . "0x6D0D") ; <CJK>
       (?$(H0-(B . "0x6D61") ; <CJK>
       (?$(H0.(B . "0x6D92") ; <CJK>
       (?$(H0/(B . "0x6D58") ; <CJK>
       (?$(H00(B . "0x6D62") ; <CJK>
       (?$(H01(B . "0x6D6D") ; <CJK>
       (?$(H02(B . "0x6D6F") ; <CJK>
       (?$(H03(B . "0x6D91") ; <CJK>
       (?$(H04(B . "0x6D8D") ; <CJK>
       (?$(H05(B . "0x6DEF") ; <CJK>
       (?$(H06(B . "0x6D7F") ; <CJK>
       (?$(H07(B . "0x6D86") ; <CJK>
       (?$(H08(B . "0x6D5E") ; <CJK>
       (?$(H09(B . "0x6D67") ; <CJK>
       (?$(H0:(B . "0x6D60") ; <CJK>
       (?$(H0;(B . "0x6D97") ; <CJK>
       (?$(H0<(B . "0x6D70") ; <CJK>
       (?$(H0=(B . "0x6D7C") ; <CJK>
       (?$(H0>(B . "0x6D5F") ; <CJK>
       (?$(H0?(B . "0x6D82") ; <CJK>
       (?$(H0@(B . "0x6D98") ; <CJK>
       (?$(H0A(B . "0x6D2F") ; <CJK>
       (?$(H0B(B . "0x6D68") ; <CJK>
       (?$(H0C(B . "0x6D8B") ; <CJK>
       (?$(H0D(B . "0x6D7E") ; <CJK>
       (?$(H0E(B . "0x6D80") ; <CJK>
       (?$(H0F(B . "0x6D84") ; <CJK>
       (?$(H0G(B . "0x6D16") ; <CJK>
       (?$(H0H(B . "0x6D83") ; <CJK>
       (?$(H0I(B . "0x6D7B") ; <CJK>
       (?$(H0J(B . "0x6D7D") ; <CJK>
       (?$(H0K(B . "0x6D75") ; <CJK>
       (?$(H0L(B . "0x6D90") ; <CJK>
       (?$(H0M(B . "0x70DC") ; <CJK>
       (?$(H0N(B . "0x70D3") ; <CJK>
       (?$(H0O(B . "0x70D1") ; <CJK>
       (?$(H0P(B . "0x70DD") ; <CJK>
       (?$(H0Q(B . "0x70CB") ; <CJK>
       (?$(H0R(B . "0x7F39") ; <CJK>
       (?$(H0S(B . "0x70E2") ; <CJK>
       (?$(H0T(B . "0x70D7") ; <CJK>
       (?$(H0U(B . "0x70D2") ; <CJK>
       (?$(H0V(B . "0x70DE") ; <CJK>
       (?$(H0W(B . "0x70E0") ; <CJK>
       (?$(H0X(B . "0x70D4") ; <CJK>
       (?$(H0Y(B . "0x70CD") ; <CJK>
       (?$(H0Z(B . "0x70C5") ; <CJK>
       (?$(H0[(B . "0x70C6") ; <CJK>
       (?$(H0\(B . "0x70C7") ; <CJK>
       (?$(H0](B . "0x70DA") ; <CJK>
       (?$(H0^(B . "0x70CE") ; <CJK>
       (?$(H0_(B . "0x70E1") ; <CJK>
       (?$(H0`(B . "0x7242") ; <CJK>
       (?$(H0a(B . "0x7278") ; <CJK>
       (?$(H0b(B . "0x7277") ; <CJK>
       (?$(H0c(B . "0x7276") ; <CJK>
       (?$(H0d(B . "0x7300") ; <CJK>
       (?$(H0e(B . "0x72FA") ; <CJK>
       (?$(H0f(B . "0x72F4") ; <CJK>
       (?$(H0g(B . "0x72FE") ; <CJK>
       (?$(H0h(B . "0x72F6") ; <CJK>
       (?$(H0i(B . "0x72F3") ; <CJK>
       (?$(H0j(B . "0x72FB") ; <CJK>
       (?$(H0k(B . "0x7301") ; <CJK>
       (?$(H0l(B . "0x73D3") ; <CJK>
       (?$(H0m(B . "0x73D9") ; <CJK>
       (?$(H0n(B . "0x73E5") ; <CJK>
       (?$(H0o(B . "0x73D6") ; <CJK>
       (?$(H0p(B . "0x73BC") ; <CJK>
       (?$(H0q(B . "0x73E7") ; <CJK>
       (?$(H0r(B . "0x73E3") ; <CJK>
       (?$(H0s(B . "0x73E9") ; <CJK>
       (?$(H0t(B . "0x73DC") ; <CJK>
       (?$(H0u(B . "0x73D2") ; <CJK>
       (?$(H0v(B . "0x73DB") ; <CJK>
       (?$(H0w(B . "0x73D4") ; <CJK>
       (?$(H0x(B . "0x73DD") ; <CJK>
       (?$(H0y(B . "0x73DA") ; <CJK>
       (?$(H0z(B . "0x73D7") ; <CJK>
       (?$(H0{(B . "0x73D8") ; <CJK>
       (?$(H0|(B . "0x73E8") ; <CJK>
       (?$(H0}(B . "0x74DE") ; <CJK>
       (?$(H0~(B . "0x74DF") ; <CJK>
       (?$(H1!(B . "0x74F4") ; <CJK>
       (?$(H1"(B . "0x74F5") ; <CJK>
       (?$(H1#(B . "0x7521") ; <CJK>
       (?$(H1$(B . "0x755B") ; <CJK>
       (?$(H1%(B . "0x755F") ; <CJK>
       (?$(H1&(B . "0x75B0") ; <CJK>
       (?$(H1'(B . "0x75C1") ; <CJK>
       (?$(H1((B . "0x75BB") ; <CJK>
       (?$(H1)(B . "0x75C4") ; <CJK>
       (?$(H1*(B . "0x75C0") ; <CJK>
       (?$(H1+(B . "0x75BF") ; <CJK>
       (?$(H1,(B . "0x75B6") ; <CJK>
       (?$(H1-(B . "0x75BA") ; <CJK>
       (?$(H1.(B . "0x768A") ; <CJK>
       (?$(H1/(B . "0x76C9") ; <CJK>
       (?$(H10(B . "0x771D") ; <CJK>
       (?$(H11(B . "0x771B") ; <CJK>
       (?$(H12(B . "0x7710") ; <CJK>
       (?$(H13(B . "0x7713") ; <CJK>
       (?$(H14(B . "0x7712") ; <CJK>
       (?$(H15(B . "0x7723") ; <CJK>
       (?$(H16(B . "0x7711") ; <CJK>
       (?$(H17(B . "0x7715") ; <CJK>
       (?$(H18(B . "0x7719") ; <CJK>
       (?$(H19(B . "0x771A") ; <CJK>
       (?$(H1:(B . "0x7722") ; <CJK>
       (?$(H1;(B . "0x7727") ; <CJK>
       (?$(H1<(B . "0x7823") ; <CJK>
       (?$(H1=(B . "0x782C") ; <CJK>
       (?$(H1>(B . "0x7822") ; <CJK>
       (?$(H1?(B . "0x7835") ; <CJK>
       (?$(H1@(B . "0x782F") ; <CJK>
       (?$(H1A(B . "0x7828") ; <CJK>
       (?$(H1B(B . "0x782E") ; <CJK>
       (?$(H1C(B . "0x782B") ; <CJK>
       (?$(H1D(B . "0x7821") ; <CJK>
       (?$(H1E(B . "0x7829") ; <CJK>
       (?$(H1F(B . "0x7833") ; <CJK>
       (?$(H1G(B . "0x782A") ; <CJK>
       (?$(H1H(B . "0x7831") ; <CJK>
       (?$(H1I(B . "0x7954") ; <CJK>
       (?$(H1J(B . "0x795B") ; <CJK>
       (?$(H1K(B . "0x794F") ; <CJK>
       (?$(H1L(B . "0x795C") ; <CJK>
       (?$(H1M(B . "0x7953") ; <CJK>
       (?$(H1N(B . "0x7952") ; <CJK>
       (?$(H1O(B . "0x7951") ; <CJK>
       (?$(H1P(B . "0x79EB") ; <CJK>
       (?$(H1Q(B . "0x79EC") ; <CJK>
       (?$(H1R(B . "0x79E0") ; <CJK>
       (?$(H1S(B . "0x79EE") ; <CJK>
       (?$(H1T(B . "0x79ED") ; <CJK>
       (?$(H1U(B . "0x79EA") ; <CJK>
       (?$(H1V(B . "0x79DC") ; <CJK>
       (?$(H1W(B . "0x79DE") ; <CJK>
       (?$(H1X(B . "0x79DD") ; <CJK>
       (?$(H1Y(B . "0x7A86") ; <CJK>
       (?$(H1Z(B . "0x7A89") ; <CJK>
       (?$(H1[(B . "0x7A85") ; <CJK>
       (?$(H1\(B . "0x7A8B") ; <CJK>
       (?$(H1](B . "0x7A8C") ; <CJK>
       (?$(H1^(B . "0x7A8A") ; <CJK>
       (?$(H1_(B . "0x7A87") ; <CJK>
       (?$(H1`(B . "0x7AD8") ; <CJK>
       (?$(H1a(B . "0x7B10") ; <CJK>
       (?$(H1b(B . "0x7B04") ; <CJK>
       (?$(H1c(B . "0x7B13") ; <CJK>
       (?$(H1d(B . "0x7B05") ; <CJK>
       (?$(H1e(B . "0x7B0F") ; <CJK>
       (?$(H1f(B . "0x7B08") ; <CJK>
       (?$(H1g(B . "0x7B0A") ; <CJK>
       (?$(H1h(B . "0x7B0E") ; <CJK>
       (?$(H1i(B . "0x7B09") ; <CJK>
       (?$(H1j(B . "0x7B12") ; <CJK>
       (?$(H1k(B . "0x7C84") ; <CJK>
       (?$(H1l(B . "0x7C91") ; <CJK>
       (?$(H1m(B . "0x7C8A") ; <CJK>
       (?$(H1n(B . "0x7C8C") ; <CJK>
       (?$(H1o(B . "0x7C88") ; <CJK>
       (?$(H1p(B . "0x7C8D") ; <CJK>
       (?$(H1q(B . "0x7C85") ; <CJK>
       (?$(H1r(B . "0x7D1E") ; <CJK>
       (?$(H1s(B . "0x7D1D") ; <CJK>
       (?$(H1t(B . "0x7D11") ; <CJK>
       (?$(H1u(B . "0x7D0E") ; <CJK>
       (?$(H1v(B . "0x7D18") ; <CJK>
       (?$(H1w(B . "0x7D16") ; <CJK>
       (?$(H1x(B . "0x7D13") ; <CJK>
       (?$(H1y(B . "0x7D1F") ; <CJK>
       (?$(H1z(B . "0x7D12") ; <CJK>
       (?$(H1{(B . "0x7D0F") ; <CJK>
       (?$(H1|(B . "0x7D0C") ; <CJK>
       (?$(H1}(B . "0x7F5C") ; <CJK>
       (?$(H1~(B . "0x7F61") ; <CJK>
       (?$(H2!(B . "0x7F5E") ; <CJK>
       (?$(H2"(B . "0x7F60") ; <CJK>
       (?$(H2#(B . "0x7F5D") ; <CJK>
       (?$(H2$(B . "0x7F5B") ; <CJK>
       (?$(H2%(B . "0x7F96") ; <CJK>
       (?$(H2&(B . "0x7F92") ; <CJK>
       (?$(H2'(B . "0x7FC3") ; <CJK>
       (?$(H2((B . "0x7FC2") ; <CJK>
       (?$(H2)(B . "0x7FC0") ; <CJK>
       (?$(H2*(B . "0x8016") ; <CJK>
       (?$(H2+(B . "0x803E") ; <CJK>
       (?$(H2,(B . "0x8039") ; <CJK>
       (?$(H2-(B . "0x80FA") ; <CJK>
       (?$(H2.(B . "0x80F2") ; <CJK>
       (?$(H2/(B . "0x80F9") ; <CJK>
       (?$(H20(B . "0x80F5") ; <CJK>
       (?$(H21(B . "0x8101") ; <CJK>
       (?$(H22(B . "0x80FB") ; <CJK>
       (?$(H23(B . "0x8100") ; <CJK>
       (?$(H24(B . "0x8201") ; <CJK>
       (?$(H25(B . "0x822F") ; <CJK>
       (?$(H26(B . "0x8225") ; <CJK>
       (?$(H27(B . "0x8333") ; <CJK>
       (?$(H28(B . "0x832D") ; <CJK>
       (?$(H29(B . "0x8344") ; <CJK>
       (?$(H2:(B . "0x8319") ; <CJK>
       (?$(H2;(B . "0x8351") ; <CJK>
       (?$(H2<(B . "0x8325") ; <CJK>
       (?$(H2=(B . "0x8356") ; <CJK>
       (?$(H2>(B . "0x833F") ; <CJK>
       (?$(H2?(B . "0x8341") ; <CJK>
       (?$(H2@(B . "0x8326") ; <CJK>
       (?$(H2A(B . "0x831C") ; <CJK>
       (?$(H2B(B . "0x8322") ; <CJK>
       (?$(H2C(B . "0x8342") ; <CJK>
       (?$(H2D(B . "0x834E") ; <CJK>
       (?$(H2E(B . "0x831B") ; <CJK>
       (?$(H2F(B . "0x832A") ; <CJK>
       (?$(H2G(B . "0x8308") ; <CJK>
       (?$(H2H(B . "0x833C") ; <CJK>
       (?$(H2I(B . "0x834D") ; <CJK>
       (?$(H2J(B . "0x8316") ; <CJK>
       (?$(H2K(B . "0x8324") ; <CJK>
       (?$(H2L(B . "0x8320") ; <CJK>
       (?$(H2M(B . "0x8337") ; <CJK>
       (?$(H2N(B . "0x832F") ; <CJK>
       (?$(H2O(B . "0x8329") ; <CJK>
       (?$(H2P(B . "0x8347") ; <CJK>
       (?$(H2Q(B . "0x8345") ; <CJK>
       (?$(H2R(B . "0x834C") ; <CJK>
       (?$(H2S(B . "0x8353") ; <CJK>
       (?$(H2T(B . "0x831E") ; <CJK>
       (?$(H2U(B . "0x832C") ; <CJK>
       (?$(H2V(B . "0x834B") ; <CJK>
       (?$(H2W(B . "0x8327") ; <CJK>
       (?$(H2X(B . "0x8348") ; <CJK>
       (?$(H2Y(B . "0x8653") ; <CJK>
       (?$(H2Z(B . "0x8652") ; <CJK>
       (?$(H2[(B . "0x86A2") ; <CJK>
       (?$(H2\(B . "0x86A8") ; <CJK>
       (?$(H2](B . "0x8696") ; <CJK>
       (?$(H2^(B . "0x868D") ; <CJK>
       (?$(H2_(B . "0x8691") ; <CJK>
       (?$(H2`(B . "0x869E") ; <CJK>
       (?$(H2a(B . "0x8687") ; <CJK>
       (?$(H2b(B . "0x8697") ; <CJK>
       (?$(H2c(B . "0x8686") ; <CJK>
       (?$(H2d(B . "0x868B") ; <CJK>
       (?$(H2e(B . "0x869A") ; <CJK>
       (?$(H2f(B . "0x8685") ; <CJK>
       (?$(H2g(B . "0x86A5") ; <CJK>
       (?$(H2h(B . "0x8699") ; <CJK>
       (?$(H2i(B . "0x86A1") ; <CJK>
       (?$(H2j(B . "0x86A7") ; <CJK>
       (?$(H2k(B . "0x8695") ; <CJK>
       (?$(H2l(B . "0x8698") ; <CJK>
       (?$(H2m(B . "0x868E") ; <CJK>
       (?$(H2n(B . "0x869D") ; <CJK>
       (?$(H2o(B . "0x8690") ; <CJK>
       (?$(H2p(B . "0x8694") ; <CJK>
       (?$(H2q(B . "0x8843") ; <CJK>
       (?$(H2r(B . "0x8844") ; <CJK>
       (?$(H2s(B . "0x886D") ; <CJK>
       (?$(H2t(B . "0x8875") ; <CJK>
       (?$(H2u(B . "0x8876") ; <CJK>
       (?$(H2v(B . "0x8872") ; <CJK>
       (?$(H2w(B . "0x8880") ; <CJK>
       (?$(H2x(B . "0x8871") ; <CJK>
       (?$(H2y(B . "0x887F") ; <CJK>
       (?$(H2z(B . "0x886F") ; <CJK>
       (?$(H2{(B . "0x8883") ; <CJK>
       (?$(H2|(B . "0x887E") ; <CJK>
       (?$(H2}(B . "0x8874") ; <CJK>
       (?$(H2~(B . "0x887C") ; <CJK>
       (?$(H3!(B . "0x8A12") ; <CJK>
       (?$(H3"(B . "0x8C47") ; <CJK>
       (?$(H3#(B . "0x8C57") ; <CJK>
       (?$(H3$(B . "0x8C7B") ; <CJK>
       (?$(H3%(B . "0x8CA4") ; <CJK>
       (?$(H3&(B . "0x8CA3") ; <CJK>
       (?$(H3'(B . "0x8D76") ; <CJK>
       (?$(H3((B . "0x8D78") ; <CJK>
       (?$(H3)(B . "0x8DB5") ; <CJK>
       (?$(H3*(B . "0x8DB7") ; <CJK>
       (?$(H3+(B . "0x8DB6") ; <CJK>
       (?$(H3,(B . "0x8ED1") ; <CJK>
       (?$(H3-(B . "0x8ED3") ; <CJK>
       (?$(H3.(B . "0x8FFE") ; <CJK>
       (?$(H3/(B . "0x8FF5") ; <CJK>
       (?$(H30(B . "0x9002") ; <CJK>
       (?$(H31(B . "0x8FFF") ; <CJK>
       (?$(H32(B . "0x8FFB") ; <CJK>
       (?$(H33(B . "0x9004") ; <CJK>
       (?$(H34(B . "0x8FFC") ; <CJK>
       (?$(H35(B . "0x8FF6") ; <CJK>
       (?$(H36(B . "0x90D6") ; <CJK>
       (?$(H37(B . "0x90E0") ; <CJK>
       (?$(H38(B . "0x90D9") ; <CJK>
       (?$(H39(B . "0x90DA") ; <CJK>
       (?$(H3:(B . "0x90E3") ; <CJK>
       (?$(H3;(B . "0x90DF") ; <CJK>
       (?$(H3<(B . "0x90E5") ; <CJK>
       (?$(H3=(B . "0x90D8") ; <CJK>
       (?$(H3>(B . "0x90DB") ; <CJK>
       (?$(H3?(B . "0x90D7") ; <CJK>
       (?$(H3@(B . "0x90DC") ; <CJK>
       (?$(H3A(B . "0x90E4") ; <CJK>
       (?$(H3B(B . "0x9150") ; <CJK>
       (?$(H3C(B . "0x914E") ; <CJK>
       (?$(H3D(B . "0x914F") ; <CJK>
       (?$(H3E(B . "0x91D5") ; <CJK>
       (?$(H3F(B . "0x91E2") ; <CJK>
       (?$(H3G(B . "0x91DA") ; <CJK>
       (?$(H3H(B . "0x965C") ; <CJK>
       (?$(H3I(B . "0x965F") ; <CJK>
       (?$(H3J(B . "0x96BC") ; <CJK>
       (?$(H3K(B . "0x98E3") ; <CJK>
       (?$(H3L(B . "0x9ADF") ; <CJK>
       (?$(H3M(B . "0x9B2F") ; <CJK>
       (?$(H3N(B . "0x4E7F") ; <CJK>
       (?$(H3O(B . "0x5070") ; <CJK>
       (?$(H3P(B . "0x506A") ; <CJK>
       (?$(H3Q(B . "0x5061") ; <CJK>
       (?$(H3R(B . "0x505E") ; <CJK>
       (?$(H3S(B . "0x5060") ; <CJK>
       (?$(H3T(B . "0x5053") ; <CJK>
       (?$(H3U(B . "0x504B") ; <CJK>
       (?$(H3V(B . "0x505D") ; <CJK>
       (?$(H3W(B . "0x5072") ; <CJK>
       (?$(H3X(B . "0x5048") ; <CJK>
       (?$(H3Y(B . "0x504D") ; <CJK>
       (?$(H3Z(B . "0x5041") ; <CJK>
       (?$(H3[(B . "0x505B") ; <CJK>
       (?$(H3\(B . "0x504A") ; <CJK>
       (?$(H3](B . "0x5062") ; <CJK>
       (?$(H3^(B . "0x5015") ; <CJK>
       (?$(H3_(B . "0x5045") ; <CJK>
       (?$(H3`(B . "0x505F") ; <CJK>
       (?$(H3a(B . "0x5069") ; <CJK>
       (?$(H3b(B . "0x506B") ; <CJK>
       (?$(H3c(B . "0x5063") ; <CJK>
       (?$(H3d(B . "0x5064") ; <CJK>
       (?$(H3e(B . "0x5046") ; <CJK>
       (?$(H3f(B . "0x5040") ; <CJK>
       (?$(H3g(B . "0x506E") ; <CJK>
       (?$(H3h(B . "0x5073") ; <CJK>
       (?$(H3i(B . "0x5057") ; <CJK>
       (?$(H3j(B . "0x5051") ; <CJK>
       (?$(H3k(B . "0x51D0") ; <CJK>
       (?$(H3l(B . "0x526B") ; <CJK>
       (?$(H3m(B . "0x526D") ; <CJK>
       (?$(H3n(B . "0x526C") ; <CJK>
       (?$(H3o(B . "0x526E") ; <CJK>
       (?$(H3p(B . "0x52D6") ; <CJK>
       (?$(H3q(B . "0x52D3") ; <CJK>
       (?$(H3r(B . "0x532D") ; <CJK>
       (?$(H3s(B . "0x539C") ; <CJK>
       (?$(H3t(B . "0x5575") ; <CJK>
       (?$(H3u(B . "0x5576") ; <CJK>
       (?$(H3v(B . "0x553C") ; <CJK>
       (?$(H3w(B . "0x554D") ; <CJK>
       (?$(H3x(B . "0x5550") ; <CJK>
       (?$(H3y(B . "0x5534") ; <CJK>
       (?$(H3z(B . "0x552A") ; <CJK>
       (?$(H3{(B . "0x5551") ; <CJK>
       (?$(H3|(B . "0x5562") ; <CJK>
       (?$(H3}(B . "0x5536") ; <CJK>
       (?$(H3~(B . "0x5535") ; <CJK>
       (?$(H4!(B . "0x5530") ; <CJK>
       (?$(H4"(B . "0x5552") ; <CJK>
       (?$(H4#(B . "0x5545") ; <CJK>
       (?$(H4$(B . "0x550C") ; <CJK>
       (?$(H4%(B . "0x5532") ; <CJK>
       (?$(H4&(B . "0x5565") ; <CJK>
       (?$(H4'(B . "0x554E") ; <CJK>
       (?$(H4((B . "0x5539") ; <CJK>
       (?$(H4)(B . "0x5548") ; <CJK>
       (?$(H4*(B . "0x552D") ; <CJK>
       (?$(H4+(B . "0x553B") ; <CJK>
       (?$(H4,(B . "0x5540") ; <CJK>
       (?$(H4-(B . "0x554B") ; <CJK>
       (?$(H4.(B . "0x570A") ; <CJK>
       (?$(H4/(B . "0x5707") ; <CJK>
       (?$(H40(B . "0x57FB") ; <CJK>
       (?$(H41(B . "0x5814") ; <CJK>
       (?$(H42(B . "0x57E2") ; <CJK>
       (?$(H43(B . "0x57F6") ; <CJK>
       (?$(H44(B . "0x57DC") ; <CJK>
       (?$(H45(B . "0x57F4") ; <CJK>
       (?$(H46(B . "0x5800") ; <CJK>
       (?$(H47(B . "0x57ED") ; <CJK>
       (?$(H48(B . "0x57FD") ; <CJK>
       (?$(H49(B . "0x5808") ; <CJK>
       (?$(H4:(B . "0x57F8") ; <CJK>
       (?$(H4;(B . "0x580B") ; <CJK>
       (?$(H4<(B . "0x57F3") ; <CJK>
       (?$(H4=(B . "0x57CF") ; <CJK>
       (?$(H4>(B . "0x5807") ; <CJK>
       (?$(H4?(B . "0x57EE") ; <CJK>
       (?$(H4@(B . "0x57E3") ; <CJK>
       (?$(H4A(B . "0x57F2") ; <CJK>
       (?$(H4B(B . "0x57E5") ; <CJK>
       (?$(H4C(B . "0x57EC") ; <CJK>
       (?$(H4D(B . "0x57E1") ; <CJK>
       (?$(H4E(B . "0x580E") ; <CJK>
       (?$(H4F(B . "0x57FC") ; <CJK>
       (?$(H4G(B . "0x5810") ; <CJK>
       (?$(H4H(B . "0x57E7") ; <CJK>
       (?$(H4I(B . "0x5801") ; <CJK>
       (?$(H4J(B . "0x580C") ; <CJK>
       (?$(H4K(B . "0x57F1") ; <CJK>
       (?$(H4L(B . "0x57E9") ; <CJK>
       (?$(H4M(B . "0x57F0") ; <CJK>
       (?$(H4N(B . "0x580D") ; <CJK>
       (?$(H4O(B . "0x5804") ; <CJK>
       (?$(H4P(B . "0x595C") ; <CJK>
       (?$(H4Q(B . "0x5A60") ; <CJK>
       (?$(H4R(B . "0x5A58") ; <CJK>
       (?$(H4S(B . "0x5A55") ; <CJK>
       (?$(H4T(B . "0x5A67") ; <CJK>
       (?$(H4U(B . "0x5A5E") ; <CJK>
       (?$(H4V(B . "0x5A38") ; <CJK>
       (?$(H4W(B . "0x5A35") ; <CJK>
       (?$(H4X(B . "0x5A6D") ; <CJK>
       (?$(H4Y(B . "0x5A50") ; <CJK>
       (?$(H4Z(B . "0x5A5F") ; <CJK>
       (?$(H4[(B . "0x5A65") ; <CJK>
       (?$(H4\(B . "0x5A6C") ; <CJK>
       (?$(H4](B . "0x5A53") ; <CJK>
       (?$(H4^(B . "0x5A64") ; <CJK>
       (?$(H4_(B . "0x5A57") ; <CJK>
       (?$(H4`(B . "0x5A43") ; <CJK>
       (?$(H4a(B . "0x5A5D") ; <CJK>
       (?$(H4b(B . "0x5A52") ; <CJK>
       (?$(H4c(B . "0x5A44") ; <CJK>
       (?$(H4d(B . "0x5A5B") ; <CJK>
       (?$(H4e(B . "0x5A48") ; <CJK>
       (?$(H4f(B . "0x5A8E") ; <CJK>
       (?$(H4g(B . "0x5A3E") ; <CJK>
       (?$(H4h(B . "0x5A4D") ; <CJK>
       (?$(H4i(B . "0x5A39") ; <CJK>
       (?$(H4j(B . "0x5A4C") ; <CJK>
       (?$(H4k(B . "0x5A70") ; <CJK>
       (?$(H4l(B . "0x5A69") ; <CJK>
       (?$(H4m(B . "0x5A47") ; <CJK>
       (?$(H4n(B . "0x5A51") ; <CJK>
       (?$(H4o(B . "0x5A56") ; <CJK>
       (?$(H4p(B . "0x5A42") ; <CJK>
       (?$(H4q(B . "0x5A5C") ; <CJK>
       (?$(H4r(B . "0x5B72") ; <CJK>
       (?$(H4s(B . "0x5B6E") ; <CJK>
       (?$(H4t(B . "0x5BC1") ; <CJK>
       (?$(H4u(B . "0x5BC0") ; <CJK>
       (?$(H4v(B . "0x5C59") ; <CJK>
       (?$(H4w(B . "0x5D1E") ; <CJK>
       (?$(H4x(B . "0x5D0B") ; <CJK>
       (?$(H4y(B . "0x5D1D") ; <CJK>
       (?$(H4z(B . "0x5D1A") ; <CJK>
       (?$(H4{(B . "0x5D20") ; <CJK>
       (?$(H4|(B . "0x5D0C") ; <CJK>
       (?$(H4}(B . "0x5D28") ; <CJK>
       (?$(H4~(B . "0x5D0D") ; <CJK>
       (?$(H5!(B . "0x5D26") ; <CJK>
       (?$(H5"(B . "0x5D25") ; <CJK>
       (?$(H5#(B . "0x5D0F") ; <CJK>
       (?$(H5$(B . "0x5D30") ; <CJK>
       (?$(H5%(B . "0x5D12") ; <CJK>
       (?$(H5&(B . "0x5D23") ; <CJK>
       (?$(H5'(B . "0x5D1F") ; <CJK>
       (?$(H5((B . "0x5D2E") ; <CJK>
       (?$(H5)(B . "0x5E3E") ; <CJK>
       (?$(H5*(B . "0x5E34") ; <CJK>
       (?$(H5+(B . "0x5EB1") ; <CJK>
       (?$(H5,(B . "0x5EB4") ; <CJK>
       (?$(H5-(B . "0x5EB9") ; <CJK>
       (?$(H5.(B . "0x5EB2") ; <CJK>
       (?$(H5/(B . "0x5EB3") ; <CJK>
       (?$(H50(B . "0x5F36") ; <CJK>
       (?$(H51(B . "0x5F38") ; <CJK>
       (?$(H52(B . "0x5F9B") ; <CJK>
       (?$(H53(B . "0x5F96") ; <CJK>
       (?$(H54(B . "0x5F9F") ; <CJK>
       (?$(H55(B . "0x608A") ; <CJK>
       (?$(H56(B . "0x6090") ; <CJK>
       (?$(H57(B . "0x6086") ; <CJK>
       (?$(H58(B . "0x60BE") ; <CJK>
       (?$(H59(B . "0x60B0") ; <CJK>
       (?$(H5:(B . "0x60BA") ; <CJK>
       (?$(H5;(B . "0x60D3") ; <CJK>
       (?$(H5<(B . "0x60D4") ; <CJK>
       (?$(H5=(B . "0x60CF") ; <CJK>
       (?$(H5>(B . "0x60E4") ; <CJK>
       (?$(H5?(B . "0x60D9") ; <CJK>
       (?$(H5@(B . "0x60DD") ; <CJK>
       (?$(H5A(B . "0x60C8") ; <CJK>
       (?$(H5B(B . "0x60B1") ; <CJK>
       (?$(H5C(B . "0x60DB") ; <CJK>
       (?$(H5D(B . "0x60B7") ; <CJK>
       (?$(H5E(B . "0x60CA") ; <CJK>
       (?$(H5F(B . "0x60BF") ; <CJK>
       (?$(H5G(B . "0x60C3") ; <CJK>
       (?$(H5H(B . "0x60CD") ; <CJK>
       (?$(H5I(B . "0x60C0") ; <CJK>
       (?$(H5J(B . "0x6332") ; <CJK>
       (?$(H5K(B . "0x6365") ; <CJK>
       (?$(H5L(B . "0x638A") ; <CJK>
       (?$(H5M(B . "0x6382") ; <CJK>
       (?$(H5N(B . "0x637D") ; <CJK>
       (?$(H5O(B . "0x63BD") ; <CJK>
       (?$(H5P(B . "0x639E") ; <CJK>
       (?$(H5Q(B . "0x63AD") ; <CJK>
       (?$(H5R(B . "0x639D") ; <CJK>
       (?$(H5S(B . "0x6397") ; <CJK>
       (?$(H5T(B . "0x63AB") ; <CJK>
       (?$(H5U(B . "0x638E") ; <CJK>
       (?$(H5V(B . "0x636F") ; <CJK>
       (?$(H5W(B . "0x6387") ; <CJK>
       (?$(H5X(B . "0x6390") ; <CJK>
       (?$(H5Y(B . "0x636E") ; <CJK>
       (?$(H5Z(B . "0x63AF") ; <CJK>
       (?$(H5[(B . "0x6375") ; <CJK>
       (?$(H5\(B . "0x639C") ; <CJK>
       (?$(H5](B . "0x636D") ; <CJK>
       (?$(H5^(B . "0x63AE") ; <CJK>
       (?$(H5_(B . "0x637C") ; <CJK>
       (?$(H5`(B . "0x63A4") ; <CJK>
       (?$(H5a(B . "0x633B") ; <CJK>
       (?$(H5b(B . "0x639F") ; <CJK>
       (?$(H5c(B . "0x6378") ; <CJK>
       (?$(H5d(B . "0x6385") ; <CJK>
       (?$(H5e(B . "0x6381") ; <CJK>
       (?$(H5f(B . "0x6391") ; <CJK>
       (?$(H5g(B . "0x638D") ; <CJK>
       (?$(H5h(B . "0x6370") ; <CJK>
       (?$(H5i(B . "0x6553") ; <CJK>
       (?$(H5j(B . "0x65CD") ; <CJK>
       (?$(H5k(B . "0x6665") ; <CJK>
       (?$(H5l(B . "0x6661") ; <CJK>
       (?$(H5m(B . "0x665B") ; <CJK>
       (?$(H5n(B . "0x6659") ; <CJK>
       (?$(H5o(B . "0x665C") ; <CJK>
       (?$(H5p(B . "0x6662") ; <CJK>
       (?$(H5q(B . "0x6718") ; <CJK>
       (?$(H5r(B . "0x6879") ; <CJK>
       (?$(H5s(B . "0x6887") ; <CJK>
       (?$(H5t(B . "0x6890") ; <CJK>
       (?$(H5u(B . "0x689C") ; <CJK>
       (?$(H5v(B . "0x686D") ; <CJK>
       (?$(H5w(B . "0x686E") ; <CJK>
       (?$(H5x(B . "0x68AE") ; <CJK>
       (?$(H5y(B . "0x68AB") ; <CJK>
       (?$(H5z(B . "0x6956") ; <CJK>
       (?$(H5{(B . "0x686F") ; <CJK>
       (?$(H5|(B . "0x68A3") ; <CJK>
       (?$(H5}(B . "0x68AC") ; <CJK>
       (?$(H5~(B . "0x68A9") ; <CJK>
       (?$(H6!(B . "0x6875") ; <CJK>
       (?$(H6"(B . "0x6874") ; <CJK>
       (?$(H6#(B . "0x68B2") ; <CJK>
       (?$(H6$(B . "0x688F") ; <CJK>
       (?$(H6%(B . "0x6877") ; <CJK>
       (?$(H6&(B . "0x6892") ; <CJK>
       (?$(H6'(B . "0x687C") ; <CJK>
       (?$(H6((B . "0x686B") ; <CJK>
       (?$(H6)(B . "0x6872") ; <CJK>
       (?$(H6*(B . "0x68AA") ; <CJK>
       (?$(H6+(B . "0x6880") ; <CJK>
       (?$(H6,(B . "0x6871") ; <CJK>
       (?$(H6-(B . "0x687E") ; <CJK>
       (?$(H6.(B . "0x689B") ; <CJK>
       (?$(H6/(B . "0x6896") ; <CJK>
       (?$(H60(B . "0x688B") ; <CJK>
       (?$(H61(B . "0x68A0") ; <CJK>
       (?$(H62(B . "0x6889") ; <CJK>
       (?$(H63(B . "0x68A4") ; <CJK>
       (?$(H64(B . "0x6878") ; <CJK>
       (?$(H65(B . "0x687B") ; <CJK>
       (?$(H66(B . "0x6891") ; <CJK>
       (?$(H67(B . "0x688C") ; <CJK>
       (?$(H68(B . "0x688A") ; <CJK>
       (?$(H69(B . "0x687D") ; <CJK>
       (?$(H6:(B . "0x6B36") ; <CJK>
       (?$(H6;(B . "0x6B33") ; <CJK>
       (?$(H6<(B . "0x6B37") ; <CJK>
       (?$(H6=(B . "0x6B38") ; <CJK>
       (?$(H6>(B . "0x6B91") ; <CJK>
       (?$(H6?(B . "0x6B8F") ; <CJK>
       (?$(H6@(B . "0x6B8D") ; <CJK>
       (?$(H6A(B . "0x6B8E") ; <CJK>
       (?$(H6B(B . "0x6B8C") ; <CJK>
       (?$(H6C(B . "0x6C2A") ; <CJK>
       (?$(H6D(B . "0x6DC0") ; <CJK>
       (?$(H6E(B . "0x6DAB") ; <CJK>
       (?$(H6F(B . "0x6DB4") ; <CJK>
       (?$(H6G(B . "0x6DB3") ; <CJK>
       (?$(H6H(B . "0x6E74") ; <CJK>
       (?$(H6I(B . "0x6DAC") ; <CJK>
       (?$(H6J(B . "0x6DE9") ; <CJK>
       (?$(H6K(B . "0x6DE2") ; <CJK>
       (?$(H6L(B . "0x6DB7") ; <CJK>
       (?$(H6M(B . "0x6DF6") ; <CJK>
       (?$(H6N(B . "0x6DD4") ; <CJK>
       (?$(H6O(B . "0x6E00") ; <CJK>
       (?$(H6P(B . "0x6DC8") ; <CJK>
       (?$(H6Q(B . "0x6DE0") ; <CJK>
       (?$(H6R(B . "0x6DDF") ; <CJK>
       (?$(H6S(B . "0x6DD6") ; <CJK>
       (?$(H6T(B . "0x6DBE") ; <CJK>
       (?$(H6U(B . "0x6DE5") ; <CJK>
       (?$(H6V(B . "0x6DDC") ; <CJK>
       (?$(H6W(B . "0x6DDD") ; <CJK>
       (?$(H6X(B . "0x6DDB") ; <CJK>
       (?$(H6Y(B . "0x6DF4") ; <CJK>
       (?$(H6Z(B . "0x6DCA") ; <CJK>
       (?$(H6[(B . "0x6DBD") ; <CJK>
       (?$(H6\(B . "0x6DED") ; <CJK>
       (?$(H6](B . "0x6DF0") ; <CJK>
       (?$(H6^(B . "0x6DBA") ; <CJK>
       (?$(H6_(B . "0x6DD5") ; <CJK>
       (?$(H6`(B . "0x6DC2") ; <CJK>
       (?$(H6a(B . "0x6DCF") ; <CJK>
       (?$(H6b(B . "0x6DC9") ; <CJK>
       (?$(H6c(B . "0x6DD0") ; <CJK>
       (?$(H6d(B . "0x6DF2") ; <CJK>
       (?$(H6e(B . "0x6DD3") ; <CJK>
       (?$(H6f(B . "0x6DFD") ; <CJK>
       (?$(H6g(B . "0x6DD7") ; <CJK>
       (?$(H6h(B . "0x6DCD") ; <CJK>
       (?$(H6i(B . "0x6DE3") ; <CJK>
       (?$(H6j(B . "0x6DBB") ; <CJK>
       (?$(H6k(B . "0x70FA") ; <CJK>
       (?$(H6l(B . "0x710D") ; <CJK>
       (?$(H6m(B . "0x70F7") ; <CJK>
       (?$(H6n(B . "0x7117") ; <CJK>
       (?$(H6o(B . "0x70F4") ; <CJK>
       (?$(H6p(B . "0x710C") ; <CJK>
       (?$(H6q(B . "0x70F0") ; <CJK>
       (?$(H6r(B . "0x7104") ; <CJK>
       (?$(H6s(B . "0x70F3") ; <CJK>
       (?$(H6t(B . "0x7110") ; <CJK>
       (?$(H6u(B . "0x70FC") ; <CJK>
       (?$(H6v(B . "0x70FF") ; <CJK>
       (?$(H6w(B . "0x7106") ; <CJK>
       (?$(H6x(B . "0x7113") ; <CJK>
       (?$(H6y(B . "0x7100") ; <CJK>
       (?$(H6z(B . "0x70F8") ; <CJK>
       (?$(H6{(B . "0x70F6") ; <CJK>
       (?$(H6|(B . "0x710B") ; <CJK>
       (?$(H6}(B . "0x7102") ; <CJK>
       (?$(H6~(B . "0x710E") ; <CJK>
       (?$(H7!(B . "0x727E") ; <CJK>
       (?$(H7"(B . "0x727B") ; <CJK>
       (?$(H7#(B . "0x727C") ; <CJK>
       (?$(H7$(B . "0x727F") ; <CJK>
       (?$(H7%(B . "0x731D") ; <CJK>
       (?$(H7&(B . "0x7317") ; <CJK>
       (?$(H7'(B . "0x7307") ; <CJK>
       (?$(H7((B . "0x7311") ; <CJK>
       (?$(H7)(B . "0x7318") ; <CJK>
       (?$(H7*(B . "0x730A") ; <CJK>
       (?$(H7+(B . "0x7308") ; <CJK>
       (?$(H7,(B . "0x72FF") ; <CJK>
       (?$(H7-(B . "0x730F") ; <CJK>
       (?$(H7.(B . "0x731E") ; <CJK>
       (?$(H7/(B . "0x7388") ; <CJK>
       (?$(H70(B . "0x73F6") ; <CJK>
       (?$(H71(B . "0x73F8") ; <CJK>
       (?$(H72(B . "0x73F5") ; <CJK>
       (?$(H73(B . "0x7404") ; <CJK>
       (?$(H74(B . "0x7401") ; <CJK>
       (?$(H75(B . "0x73FD") ; <CJK>
       (?$(H76(B . "0x7407") ; <CJK>
       (?$(H77(B . "0x7400") ; <CJK>
       (?$(H78(B . "0x73FA") ; <CJK>
       (?$(H79(B . "0x73FC") ; <CJK>
       (?$(H7:(B . "0x73FF") ; <CJK>
       (?$(H7;(B . "0x740C") ; <CJK>
       (?$(H7<(B . "0x740B") ; <CJK>
       (?$(H7=(B . "0x73F4") ; <CJK>
       (?$(H7>(B . "0x7408") ; <CJK>
       (?$(H7?(B . "0x7564") ; <CJK>
       (?$(H7@(B . "0x7563") ; <CJK>
       (?$(H7A(B . "0x75CE") ; <CJK>
       (?$(H7B(B . "0x75D2") ; <CJK>
       (?$(H7C(B . "0x75CF") ; <CJK>
       (?$(H7D(B . "0x75CB") ; <CJK>
       (?$(H7E(B . "0x75CC") ; <CJK>
       (?$(H7F(B . "0x75D1") ; <CJK>
       (?$(H7G(B . "0x75D0") ; <CJK>
       (?$(H7H(B . "0x768F") ; <CJK>
       (?$(H7I(B . "0x7689") ; <CJK>
       (?$(H7J(B . "0x76D3") ; <CJK>
       (?$(H7K(B . "0x7739") ; <CJK>
       (?$(H7L(B . "0x772F") ; <CJK>
       (?$(H7M(B . "0x772D") ; <CJK>
       (?$(H7N(B . "0x7731") ; <CJK>
       (?$(H7O(B . "0x7732") ; <CJK>
       (?$(H7P(B . "0x7734") ; <CJK>
       (?$(H7Q(B . "0x7733") ; <CJK>
       (?$(H7R(B . "0x773D") ; <CJK>
       (?$(H7S(B . "0x7725") ; <CJK>
       (?$(H7T(B . "0x773B") ; <CJK>
       (?$(H7U(B . "0x7735") ; <CJK>
       (?$(H7V(B . "0x7848") ; <CJK>
       (?$(H7W(B . "0x7852") ; <CJK>
       (?$(H7X(B . "0x7849") ; <CJK>
       (?$(H7Y(B . "0x784D") ; <CJK>
       (?$(H7Z(B . "0x784A") ; <CJK>
       (?$(H7[(B . "0x784C") ; <CJK>
       (?$(H7\(B . "0x7826") ; <CJK>
       (?$(H7](B . "0x7845") ; <CJK>
       (?$(H7^(B . "0x7850") ; <CJK>
       (?$(H7_(B . "0x7964") ; <CJK>
       (?$(H7`(B . "0x7967") ; <CJK>
       (?$(H7a(B . "0x7969") ; <CJK>
       (?$(H7b(B . "0x796A") ; <CJK>
       (?$(H7c(B . "0x7963") ; <CJK>
       (?$(H7d(B . "0x796B") ; <CJK>
       (?$(H7e(B . "0x7961") ; <CJK>
       (?$(H7f(B . "0x79BB") ; <CJK>
       (?$(H7g(B . "0x79FA") ; <CJK>
       (?$(H7h(B . "0x79F8") ; <CJK>
       (?$(H7i(B . "0x79F6") ; <CJK>
       (?$(H7j(B . "0x79F7") ; <CJK>
       (?$(H7k(B . "0x7A8F") ; <CJK>
       (?$(H7l(B . "0x7A94") ; <CJK>
       (?$(H7m(B . "0x7A90") ; <CJK>
       (?$(H7n(B . "0x7B35") ; <CJK>
       (?$(H7o(B . "0x7B3B") ; <CJK>
       (?$(H7p(B . "0x7B34") ; <CJK>
       (?$(H7q(B . "0x7B25") ; <CJK>
       (?$(H7r(B . "0x7B30") ; <CJK>
       (?$(H7s(B . "0x7B22") ; <CJK>
       (?$(H7t(B . "0x7B24") ; <CJK>
       (?$(H7u(B . "0x7B33") ; <CJK>
       (?$(H7v(B . "0x7B18") ; <CJK>
       (?$(H7w(B . "0x7B2A") ; <CJK>
       (?$(H7x(B . "0x7B1D") ; <CJK>
       (?$(H7y(B . "0x7B31") ; <CJK>
       (?$(H7z(B . "0x7B2B") ; <CJK>
       (?$(H7{(B . "0x7B2D") ; <CJK>
       (?$(H7|(B . "0x7B2F") ; <CJK>
       (?$(H7}(B . "0x7B32") ; <CJK>
       (?$(H7~(B . "0x7B38") ; <CJK>
       (?$(H8!(B . "0x7B1A") ; <CJK>
       (?$(H8"(B . "0x7B23") ; <CJK>
       (?$(H8#(B . "0x7C94") ; <CJK>
       (?$(H8$(B . "0x7C98") ; <CJK>
       (?$(H8%(B . "0x7C96") ; <CJK>
       (?$(H8&(B . "0x7CA3") ; <CJK>
       (?$(H8'(B . "0x7D35") ; <CJK>
       (?$(H8((B . "0x7D3D") ; <CJK>
       (?$(H8)(B . "0x7D38") ; <CJK>
       (?$(H8*(B . "0x7D36") ; <CJK>
       (?$(H8+(B . "0x7D3A") ; <CJK>
       (?$(H8,(B . "0x7D45") ; <CJK>
       (?$(H8-(B . "0x7D2C") ; <CJK>
       (?$(H8.(B . "0x7D29") ; <CJK>
       (?$(H8/(B . "0x7D41") ; <CJK>
       (?$(H80(B . "0x7D47") ; <CJK>
       (?$(H81(B . "0x7D3E") ; <CJK>
       (?$(H82(B . "0x7D3F") ; <CJK>
       (?$(H83(B . "0x7D4A") ; <CJK>
       (?$(H84(B . "0x7D3B") ; <CJK>
       (?$(H85(B . "0x7D28") ; <CJK>
       (?$(H86(B . "0x7F63") ; <CJK>
       (?$(H87(B . "0x7F95") ; <CJK>
       (?$(H88(B . "0x7F9C") ; <CJK>
       (?$(H89(B . "0x7F9D") ; <CJK>
       (?$(H8:(B . "0x7F9B") ; <CJK>
       (?$(H8;(B . "0x7FCA") ; <CJK>
       (?$(H8<(B . "0x7FCB") ; <CJK>
       (?$(H8=(B . "0x7FCD") ; <CJK>
       (?$(H8>(B . "0x7FD0") ; <CJK>
       (?$(H8?(B . "0x7FD1") ; <CJK>
       (?$(H8@(B . "0x7FC7") ; <CJK>
       (?$(H8A(B . "0x7FCF") ; <CJK>
       (?$(H8B(B . "0x7FC9") ; <CJK>
       (?$(H8C(B . "0x801F") ; <CJK>
       (?$(H8D(B . "0x801E") ; <CJK>
       (?$(H8E(B . "0x801B") ; <CJK>
       (?$(H8F(B . "0x8047") ; <CJK>
       (?$(H8G(B . "0x8043") ; <CJK>
       (?$(H8H(B . "0x8048") ; <CJK>
       (?$(H8I(B . "0x8118") ; <CJK>
       (?$(H8J(B . "0x8125") ; <CJK>
       (?$(H8K(B . "0x8119") ; <CJK>
       (?$(H8L(B . "0x811B") ; <CJK>
       (?$(H8M(B . "0x812D") ; <CJK>
       (?$(H8N(B . "0x811F") ; <CJK>
       (?$(H8O(B . "0x812C") ; <CJK>
       (?$(H8P(B . "0x811E") ; <CJK>
       (?$(H8Q(B . "0x8121") ; <CJK>
       (?$(H8R(B . "0x8115") ; <CJK>
       (?$(H8S(B . "0x8127") ; <CJK>
       (?$(H8T(B . "0x811D") ; <CJK>
       (?$(H8U(B . "0x8122") ; <CJK>
       (?$(H8V(B . "0x8211") ; <CJK>
       (?$(H8W(B . "0x8238") ; <CJK>
       (?$(H8X(B . "0x8233") ; <CJK>
       (?$(H8Y(B . "0x823A") ; <CJK>
       (?$(H8Z(B . "0x8234") ; <CJK>
       (?$(H8[(B . "0x8232") ; <CJK>
       (?$(H8\(B . "0x8274") ; <CJK>
       (?$(H8](B . "0x8390") ; <CJK>
       (?$(H8^(B . "0x83A3") ; <CJK>
       (?$(H8_(B . "0x83A8") ; <CJK>
       (?$(H8`(B . "0x838D") ; <CJK>
       (?$(H8a(B . "0x837A") ; <CJK>
       (?$(H8b(B . "0x8373") ; <CJK>
       (?$(H8c(B . "0x83A4") ; <CJK>
       (?$(H8d(B . "0x8374") ; <CJK>
       (?$(H8e(B . "0x838F") ; <CJK>
       (?$(H8f(B . "0x8381") ; <CJK>
       (?$(H8g(B . "0x8395") ; <CJK>
       (?$(H8h(B . "0x8399") ; <CJK>
       (?$(H8i(B . "0x8375") ; <CJK>
       (?$(H8j(B . "0x8394") ; <CJK>
       (?$(H8k(B . "0x83A9") ; <CJK>
       (?$(H8l(B . "0x837D") ; <CJK>
       (?$(H8m(B . "0x8383") ; <CJK>
       (?$(H8n(B . "0x838C") ; <CJK>
       (?$(H8o(B . "0x839D") ; <CJK>
       (?$(H8p(B . "0x839B") ; <CJK>
       (?$(H8q(B . "0x83AA") ; <CJK>
       (?$(H8r(B . "0x838B") ; <CJK>
       (?$(H8s(B . "0x837E") ; <CJK>
       (?$(H8t(B . "0x83A5") ; <CJK>
       (?$(H8u(B . "0x83AF") ; <CJK>
       (?$(H8v(B . "0x8388") ; <CJK>
       (?$(H8w(B . "0x8397") ; <CJK>
       (?$(H8x(B . "0x83B0") ; <CJK>
       (?$(H8y(B . "0x837F") ; <CJK>
       (?$(H8z(B . "0x83A6") ; <CJK>
       (?$(H8{(B . "0x8387") ; <CJK>
       (?$(H8|(B . "0x83AE") ; <CJK>
       (?$(H8}(B . "0x8376") ; <CJK>
       (?$(H8~(B . "0x8659") ; <CJK>
       (?$(H9!(B . "0x8656") ; <CJK>
       (?$(H9"(B . "0x86BF") ; <CJK>
       (?$(H9#(B . "0x86B7") ; <CJK>
       (?$(H9$(B . "0x86C2") ; <CJK>
       (?$(H9%(B . "0x86C1") ; <CJK>
       (?$(H9&(B . "0x86C5") ; <CJK>
       (?$(H9'(B . "0x86BA") ; <CJK>
       (?$(H9((B . "0x86B0") ; <CJK>
       (?$(H9)(B . "0x86C8") ; <CJK>
       (?$(H9*(B . "0x86B9") ; <CJK>
       (?$(H9+(B . "0x86B3") ; <CJK>
       (?$(H9,(B . "0x86B8") ; <CJK>
       (?$(H9-(B . "0x86CC") ; <CJK>
       (?$(H9.(B . "0x86B4") ; <CJK>
       (?$(H9/(B . "0x86BB") ; <CJK>
       (?$(H90(B . "0x86BC") ; <CJK>
       (?$(H91(B . "0x86C3") ; <CJK>
       (?$(H92(B . "0x86BD") ; <CJK>
       (?$(H93(B . "0x86BE") ; <CJK>
       (?$(H94(B . "0x8852") ; <CJK>
       (?$(H95(B . "0x8889") ; <CJK>
       (?$(H96(B . "0x8895") ; <CJK>
       (?$(H97(B . "0x88A8") ; <CJK>
       (?$(H98(B . "0x88A2") ; <CJK>
       (?$(H99(B . "0x88AA") ; <CJK>
       (?$(H9:(B . "0x889A") ; <CJK>
       (?$(H9;(B . "0x8891") ; <CJK>
       (?$(H9<(B . "0x88A1") ; <CJK>
       (?$(H9=(B . "0x889F") ; <CJK>
       (?$(H9>(B . "0x8898") ; <CJK>
       (?$(H9?(B . "0x88A7") ; <CJK>
       (?$(H9@(B . "0x8899") ; <CJK>
       (?$(H9A(B . "0x889B") ; <CJK>
       (?$(H9B(B . "0x8897") ; <CJK>
       (?$(H9C(B . "0x88A4") ; <CJK>
       (?$(H9D(B . "0x88AC") ; <CJK>
       (?$(H9E(B . "0x888C") ; <CJK>
       (?$(H9F(B . "0x8893") ; <CJK>
       (?$(H9G(B . "0x888E") ; <CJK>
       (?$(H9H(B . "0x8982") ; <CJK>
       (?$(H9I(B . "0x89D6") ; <CJK>
       (?$(H9J(B . "0x89D9") ; <CJK>
       (?$(H9K(B . "0x89D5") ; <CJK>
       (?$(H9L(B . "0x8A30") ; <CJK>
       (?$(H9M(B . "0x8A27") ; <CJK>
       (?$(H9N(B . "0x8A2C") ; <CJK>
       (?$(H9O(B . "0x8A1E") ; <CJK>
       (?$(H9P(B . "0x8C39") ; <CJK>
       (?$(H9Q(B . "0x8C3B") ; <CJK>
       (?$(H9R(B . "0x8C5C") ; <CJK>
       (?$(H9S(B . "0x8C5D") ; <CJK>
       (?$(H9T(B . "0x8C7D") ; <CJK>
       (?$(H9U(B . "0x8CA5") ; <CJK>
       (?$(H9V(B . "0x8D7D") ; <CJK>
       (?$(H9W(B . "0x8D7B") ; <CJK>
       (?$(H9X(B . "0x8D79") ; <CJK>
       (?$(H9Y(B . "0x8DBC") ; <CJK>
       (?$(H9Z(B . "0x8DC2") ; <CJK>
       (?$(H9[(B . "0x8DB9") ; <CJK>
       (?$(H9\(B . "0x8DBF") ; <CJK>
       (?$(H9](B . "0x8DC1") ; <CJK>
       (?$(H9^(B . "0x8ED8") ; <CJK>
       (?$(H9_(B . "0x8EDE") ; <CJK>
       (?$(H9`(B . "0x8EDD") ; <CJK>
       (?$(H9a(B . "0x8EDC") ; <CJK>
       (?$(H9b(B . "0x8ED7") ; <CJK>
       (?$(H9c(B . "0x8EE0") ; <CJK>
       (?$(H9d(B . "0x8EE1") ; <CJK>
       (?$(H9e(B . "0x9024") ; <CJK>
       (?$(H9f(B . "0x900B") ; <CJK>
       (?$(H9g(B . "0x9011") ; <CJK>
       (?$(H9h(B . "0x901C") ; <CJK>
       (?$(H9i(B . "0x900C") ; <CJK>
       (?$(H9j(B . "0x9021") ; <CJK>
       (?$(H9k(B . "0x90EF") ; <CJK>
       (?$(H9l(B . "0x90EA") ; <CJK>
       (?$(H9m(B . "0x90F0") ; <CJK>
       (?$(H9n(B . "0x90F4") ; <CJK>
       (?$(H9o(B . "0x90F2") ; <CJK>
       (?$(H9p(B . "0x90F3") ; <CJK>
       (?$(H9q(B . "0x90D4") ; <CJK>
       (?$(H9r(B . "0x90EB") ; <CJK>
       (?$(H9s(B . "0x90EC") ; <CJK>
       (?$(H9t(B . "0x90E9") ; <CJK>
       (?$(H9u(B . "0x9156") ; <CJK>
       (?$(H9v(B . "0x9158") ; <CJK>
       (?$(H9w(B . "0x915A") ; <CJK>
       (?$(H9x(B . "0x9153") ; <CJK>
       (?$(H9y(B . "0x9155") ; <CJK>
       (?$(H9z(B . "0x91EC") ; <CJK>
       (?$(H9{(B . "0x91F4") ; <CJK>
       (?$(H9|(B . "0x91F1") ; <CJK>
       (?$(H9}(B . "0x91F3") ; <CJK>
       (?$(H9~(B . "0x91F8") ; <CJK>
       (?$(H:!(B . "0x91E4") ; <CJK>
       (?$(H:"(B . "0x91F9") ; <CJK>
       (?$(H:#(B . "0x91EA") ; <CJK>
       (?$(H:$(B . "0x91EB") ; <CJK>
       (?$(H:%(B . "0x91F7") ; <CJK>
       (?$(H:&(B . "0x91E8") ; <CJK>
       (?$(H:'(B . "0x91EE") ; <CJK>
       (?$(H:((B . "0x957A") ; <CJK>
       (?$(H:)(B . "0x9586") ; <CJK>
       (?$(H:*(B . "0x9588") ; <CJK>
       (?$(H:+(B . "0x967C") ; <CJK>
       (?$(H:,(B . "0x966D") ; <CJK>
       (?$(H:-(B . "0x966B") ; <CJK>
       (?$(H:.(B . "0x9671") ; <CJK>
       (?$(H:/(B . "0x966F") ; <CJK>
       (?$(H:0(B . "0x96BF") ; <CJK>
       (?$(H:1(B . "0x976A") ; <CJK>
       (?$(H:2(B . "0x9804") ; <CJK>
       (?$(H:3(B . "0x98E5") ; <CJK>
       (?$(H:4(B . "0x9997") ; <CJK>
       (?$(H:5(B . "0x509B") ; <CJK>
       (?$(H:6(B . "0x5095") ; <CJK>
       (?$(H:7(B . "0x5094") ; <CJK>
       (?$(H:8(B . "0x509E") ; <CJK>
       (?$(H:9(B . "0x508B") ; <CJK>
       (?$(H::(B . "0x50A3") ; <CJK>
       (?$(H:;(B . "0x5083") ; <CJK>
       (?$(H:<(B . "0x508C") ; <CJK>
       (?$(H:=(B . "0x508E") ; <CJK>
       (?$(H:>(B . "0x509D") ; <CJK>
       (?$(H:?(B . "0x5068") ; <CJK>
       (?$(H:@(B . "0x509C") ; <CJK>
       (?$(H:A(B . "0x5092") ; <CJK>
       (?$(H:B(B . "0x5082") ; <CJK>
       (?$(H:C(B . "0x5087") ; <CJK>
       (?$(H:D(B . "0x515F") ; <CJK>
       (?$(H:E(B . "0x51D4") ; <CJK>
       (?$(H:F(B . "0x5312") ; <CJK>
       (?$(H:G(B . "0x5311") ; <CJK>
       (?$(H:H(B . "0x53A4") ; <CJK>
       (?$(H:I(B . "0x53A7") ; <CJK>
       (?$(H:J(B . "0x5591") ; <CJK>
       (?$(H:K(B . "0x55A8") ; <CJK>
       (?$(H:L(B . "0x55A5") ; <CJK>
       (?$(H:M(B . "0x55AD") ; <CJK>
       (?$(H:N(B . "0x5577") ; <CJK>
       (?$(H:O(B . "0x5645") ; <CJK>
       (?$(H:P(B . "0x55A2") ; <CJK>
       (?$(H:Q(B . "0x5593") ; <CJK>
       (?$(H:R(B . "0x5588") ; <CJK>
       (?$(H:S(B . "0x558F") ; <CJK>
       (?$(H:T(B . "0x55B5") ; <CJK>
       (?$(H:U(B . "0x5581") ; <CJK>
       (?$(H:V(B . "0x55A3") ; <CJK>
       (?$(H:W(B . "0x5592") ; <CJK>
       (?$(H:X(B . "0x55A4") ; <CJK>
       (?$(H:Y(B . "0x557D") ; <CJK>
       (?$(H:Z(B . "0x558C") ; <CJK>
       (?$(H:[(B . "0x55A6") ; <CJK>
       (?$(H:\(B . "0x557F") ; <CJK>
       (?$(H:](B . "0x5595") ; <CJK>
       (?$(H:^(B . "0x55A1") ; <CJK>
       (?$(H:_(B . "0x558E") ; <CJK>
       (?$(H:`(B . "0x570C") ; <CJK>
       (?$(H:a(B . "0x5829") ; <CJK>
       (?$(H:b(B . "0x5837") ; <CJK>
       (?$(H:c(B . "0x5819") ; <CJK>
       (?$(H:d(B . "0x581E") ; <CJK>
       (?$(H:e(B . "0x5827") ; <CJK>
       (?$(H:f(B . "0x5823") ; <CJK>
       (?$(H:g(B . "0x5828") ; <CJK>
       (?$(H:h(B . "0x57F5") ; <CJK>
       (?$(H:i(B . "0x5848") ; <CJK>
       (?$(H:j(B . "0x5825") ; <CJK>
       (?$(H:k(B . "0x581C") ; <CJK>
       (?$(H:l(B . "0x581B") ; <CJK>
       (?$(H:m(B . "0x5833") ; <CJK>
       (?$(H:n(B . "0x583F") ; <CJK>
       (?$(H:o(B . "0x5836") ; <CJK>
       (?$(H:p(B . "0x582E") ; <CJK>
       (?$(H:q(B . "0x5839") ; <CJK>
       (?$(H:r(B . "0x5838") ; <CJK>
       (?$(H:s(B . "0x582D") ; <CJK>
       (?$(H:t(B . "0x582C") ; <CJK>
       (?$(H:u(B . "0x583B") ; <CJK>
       (?$(H:v(B . "0x5961") ; <CJK>
       (?$(H:w(B . "0x5AAF") ; <CJK>
       (?$(H:x(B . "0x5A94") ; <CJK>
       (?$(H:y(B . "0x5A9F") ; <CJK>
       (?$(H:z(B . "0x5A7A") ; <CJK>
       (?$(H:{(B . "0x5AA2") ; <CJK>
       (?$(H:|(B . "0x5A9E") ; <CJK>
       (?$(H:}(B . "0x5A78") ; <CJK>
       (?$(H:~(B . "0x5AA6") ; <CJK>
       (?$(H;!(B . "0x5A7C") ; <CJK>
       (?$(H;"(B . "0x5AA5") ; <CJK>
       (?$(H;#(B . "0x5AAC") ; <CJK>
       (?$(H;$(B . "0x5A95") ; <CJK>
       (?$(H;%(B . "0x5AAE") ; <CJK>
       (?$(H;&(B . "0x5A37") ; <CJK>
       (?$(H;'(B . "0x5A84") ; <CJK>
       (?$(H;((B . "0x5A8A") ; <CJK>
       (?$(H;)(B . "0x5A97") ; <CJK>
       (?$(H;*(B . "0x5A83") ; <CJK>
       (?$(H;+(B . "0x5A8B") ; <CJK>
       (?$(H;,(B . "0x5AA9") ; <CJK>
       (?$(H;-(B . "0x5A7B") ; <CJK>
       (?$(H;.(B . "0x5A7D") ; <CJK>
       (?$(H;/(B . "0x5A8C") ; <CJK>
       (?$(H;0(B . "0x5A9C") ; <CJK>
       (?$(H;1(B . "0x5A8F") ; <CJK>
       (?$(H;2(B . "0x5A93") ; <CJK>
       (?$(H;3(B . "0x5A9D") ; <CJK>
       (?$(H;4(B . "0x5BEA") ; <CJK>
       (?$(H;5(B . "0x5BCD") ; <CJK>
       (?$(H;6(B . "0x5BCB") ; <CJK>
       (?$(H;7(B . "0x5BD4") ; <CJK>
       (?$(H;8(B . "0x5BD1") ; <CJK>
       (?$(H;9(B . "0x5BCA") ; <CJK>
       (?$(H;:(B . "0x5BCE") ; <CJK>
       (?$(H;;(B . "0x5C0C") ; <CJK>
       (?$(H;<(B . "0x5C30") ; <CJK>
       (?$(H;=(B . "0x5D37") ; <CJK>
       (?$(H;>(B . "0x5D43") ; <CJK>
       (?$(H;?(B . "0x5D6B") ; <CJK>
       (?$(H;@(B . "0x5D41") ; <CJK>
       (?$(H;A(B . "0x5D4B") ; <CJK>
       (?$(H;B(B . "0x5D3F") ; <CJK>
       (?$(H;C(B . "0x5D35") ; <CJK>
       (?$(H;D(B . "0x5D51") ; <CJK>
       (?$(H;E(B . "0x5D4E") ; <CJK>
       (?$(H;F(B . "0x5D55") ; <CJK>
       (?$(H;G(B . "0x5D33") ; <CJK>
       (?$(H;H(B . "0x5D3A") ; <CJK>
       (?$(H;I(B . "0x5D52") ; <CJK>
       (?$(H;J(B . "0x5D3D") ; <CJK>
       (?$(H;K(B . "0x5D31") ; <CJK>
       (?$(H;L(B . "0x5D59") ; <CJK>
       (?$(H;M(B . "0x5D42") ; <CJK>
       (?$(H;N(B . "0x5D39") ; <CJK>
       (?$(H;O(B . "0x5D49") ; <CJK>
       (?$(H;P(B . "0x5D38") ; <CJK>
       (?$(H;Q(B . "0x5D3C") ; <CJK>
       (?$(H;R(B . "0x5D32") ; <CJK>
       (?$(H;S(B . "0x5D36") ; <CJK>
       (?$(H;T(B . "0x5D40") ; <CJK>
       (?$(H;U(B . "0x5D45") ; <CJK>
       (?$(H;V(B . "0x5E44") ; <CJK>
       (?$(H;W(B . "0x5E41") ; <CJK>
       (?$(H;X(B . "0x5F58") ; <CJK>
       (?$(H;Y(B . "0x5FA6") ; <CJK>
       (?$(H;Z(B . "0x5FA5") ; <CJK>
       (?$(H;[(B . "0x5FAB") ; <CJK>
       (?$(H;\(B . "0x60C9") ; <CJK>
       (?$(H;](B . "0x60B9") ; <CJK>
       (?$(H;^(B . "0x60CC") ; <CJK>
       (?$(H;_(B . "0x60E2") ; <CJK>
       (?$(H;`(B . "0x60CE") ; <CJK>
       (?$(H;a(B . "0x60C4") ; <CJK>
       (?$(H;b(B . "0x6114") ; <CJK>
       (?$(H;c(B . "0x60F2") ; <CJK>
       (?$(H;d(B . "0x610A") ; <CJK>
       (?$(H;e(B . "0x6116") ; <CJK>
       (?$(H;f(B . "0x6105") ; <CJK>
       (?$(H;g(B . "0x60F5") ; <CJK>
       (?$(H;h(B . "0x6113") ; <CJK>
       (?$(H;i(B . "0x60F8") ; <CJK>
       (?$(H;j(B . "0x60FC") ; <CJK>
       (?$(H;k(B . "0x60FE") ; <CJK>
       (?$(H;l(B . "0x60C1") ; <CJK>
       (?$(H;m(B . "0x6103") ; <CJK>
       (?$(H;n(B . "0x6118") ; <CJK>
       (?$(H;o(B . "0x611D") ; <CJK>
       (?$(H;p(B . "0x6110") ; <CJK>
       (?$(H;q(B . "0x60FF") ; <CJK>
       (?$(H;r(B . "0x6104") ; <CJK>
       (?$(H;s(B . "0x610B") ; <CJK>
       (?$(H;t(B . "0x624A") ; <CJK>
       (?$(H;u(B . "0x6394") ; <CJK>
       (?$(H;v(B . "0x63B1") ; <CJK>
       (?$(H;w(B . "0x63B0") ; <CJK>
       (?$(H;x(B . "0x63CE") ; <CJK>
       (?$(H;y(B . "0x63E5") ; <CJK>
       (?$(H;z(B . "0x63E8") ; <CJK>
       (?$(H;{(B . "0x63EF") ; <CJK>
       (?$(H;|(B . "0x63C3") ; <CJK>
       (?$(H;}(B . "0x649D") ; <CJK>
       (?$(H;~(B . "0x63F3") ; <CJK>
       (?$(H<!(B . "0x63CA") ; <CJK>
       (?$(H<"(B . "0x63E0") ; <CJK>
       (?$(H<#(B . "0x63F6") ; <CJK>
       (?$(H<$(B . "0x63D5") ; <CJK>
       (?$(H<%(B . "0x63F2") ; <CJK>
       (?$(H<&(B . "0x63F5") ; <CJK>
       (?$(H<'(B . "0x6461") ; <CJK>
       (?$(H<((B . "0x63DF") ; <CJK>
       (?$(H<)(B . "0x63BE") ; <CJK>
       (?$(H<*(B . "0x63DD") ; <CJK>
       (?$(H<+(B . "0x63DC") ; <CJK>
       (?$(H<,(B . "0x63C4") ; <CJK>
       (?$(H<-(B . "0x63D8") ; <CJK>
       (?$(H<.(B . "0x63D3") ; <CJK>
       (?$(H</(B . "0x63C2") ; <CJK>
       (?$(H<0(B . "0x63C7") ; <CJK>
       (?$(H<1(B . "0x63CC") ; <CJK>
       (?$(H<2(B . "0x63CB") ; <CJK>
       (?$(H<3(B . "0x63C8") ; <CJK>
       (?$(H<4(B . "0x63F0") ; <CJK>
       (?$(H<5(B . "0x63D7") ; <CJK>
       (?$(H<6(B . "0x63D9") ; <CJK>
       (?$(H<7(B . "0x6532") ; <CJK>
       (?$(H<8(B . "0x6567") ; <CJK>
       (?$(H<9(B . "0x656A") ; <CJK>
       (?$(H<:(B . "0x6564") ; <CJK>
       (?$(H<;(B . "0x655C") ; <CJK>
       (?$(H<<(B . "0x6568") ; <CJK>
       (?$(H<=(B . "0x6565") ; <CJK>
       (?$(H<>(B . "0x658C") ; <CJK>
       (?$(H<?(B . "0x659D") ; <CJK>
       (?$(H<@(B . "0x659E") ; <CJK>
       (?$(H<A(B . "0x65AE") ; <CJK>
       (?$(H<B(B . "0x65D0") ; <CJK>
       (?$(H<C(B . "0x65D2") ; <CJK>
       (?$(H<D(B . "0x667C") ; <CJK>
       (?$(H<E(B . "0x666C") ; <CJK>
       (?$(H<F(B . "0x667B") ; <CJK>
       (?$(H<G(B . "0x6680") ; <CJK>
       (?$(H<H(B . "0x6671") ; <CJK>
       (?$(H<I(B . "0x6679") ; <CJK>
       (?$(H<J(B . "0x666A") ; <CJK>
       (?$(H<K(B . "0x6672") ; <CJK>
       (?$(H<L(B . "0x6701") ; <CJK>
       (?$(H<M(B . "0x690C") ; <CJK>
       (?$(H<N(B . "0x68D3") ; <CJK>
       (?$(H<O(B . "0x6904") ; <CJK>
       (?$(H<P(B . "0x68DC") ; <CJK>
       (?$(H<Q(B . "0x692A") ; <CJK>
       (?$(H<R(B . "0x68EC") ; <CJK>
       (?$(H<S(B . "0x68EA") ; <CJK>
       (?$(H<T(B . "0x68F1") ; <CJK>
       (?$(H<U(B . "0x690F") ; <CJK>
       (?$(H<V(B . "0x68D6") ; <CJK>
       (?$(H<W(B . "0x68F7") ; <CJK>
       (?$(H<X(B . "0x68EB") ; <CJK>
       (?$(H<Y(B . "0x68E4") ; <CJK>
       (?$(H<Z(B . "0x68F6") ; <CJK>
       (?$(H<[(B . "0x6913") ; <CJK>
       (?$(H<\(B . "0x6910") ; <CJK>
       (?$(H<](B . "0x68F3") ; <CJK>
       (?$(H<^(B . "0x68E1") ; <CJK>
       (?$(H<_(B . "0x6907") ; <CJK>
       (?$(H<`(B . "0x68CC") ; <CJK>
       (?$(H<a(B . "0x6908") ; <CJK>
       (?$(H<b(B . "0x6970") ; <CJK>
       (?$(H<c(B . "0x68B4") ; <CJK>
       (?$(H<d(B . "0x6911") ; <CJK>
       (?$(H<e(B . "0x68EF") ; <CJK>
       (?$(H<f(B . "0x68C6") ; <CJK>
       (?$(H<g(B . "0x6914") ; <CJK>
       (?$(H<h(B . "0x68F8") ; <CJK>
       (?$(H<i(B . "0x68D0") ; <CJK>
       (?$(H<j(B . "0x68FD") ; <CJK>
       (?$(H<k(B . "0x68FC") ; <CJK>
       (?$(H<l(B . "0x68E8") ; <CJK>
       (?$(H<m(B . "0x690B") ; <CJK>
       (?$(H<n(B . "0x690A") ; <CJK>
       (?$(H<o(B . "0x6917") ; <CJK>
       (?$(H<p(B . "0x68CE") ; <CJK>
       (?$(H<q(B . "0x68C8") ; <CJK>
       (?$(H<r(B . "0x68DD") ; <CJK>
       (?$(H<s(B . "0x68DE") ; <CJK>
       (?$(H<t(B . "0x68E6") ; <CJK>
       (?$(H<u(B . "0x68F4") ; <CJK>
       (?$(H<v(B . "0x68D1") ; <CJK>
       (?$(H<w(B . "0x6906") ; <CJK>
       (?$(H<x(B . "0x68D4") ; <CJK>
       (?$(H<y(B . "0x68E9") ; <CJK>
       (?$(H<z(B . "0x6915") ; <CJK>
       (?$(H<{(B . "0x6925") ; <CJK>
       (?$(H<|(B . "0x68C7") ; <CJK>
       (?$(H<}(B . "0x6B39") ; <CJK>
       (?$(H<~(B . "0x6B3B") ; <CJK>
       (?$(H=!(B . "0x6B3F") ; <CJK>
       (?$(H="(B . "0x6B3C") ; <CJK>
       (?$(H=#(B . "0x6B94") ; <CJK>
       (?$(H=$(B . "0x6B97") ; <CJK>
       (?$(H=%(B . "0x6B99") ; <CJK>
       (?$(H=&(B . "0x6B95") ; <CJK>
       (?$(H='(B . "0x6BBD") ; <CJK>
       (?$(H=((B . "0x6BF0") ; <CJK>
       (?$(H=)(B . "0x6BF2") ; <CJK>
       (?$(H=*(B . "0x6BF3") ; <CJK>
       (?$(H=+(B . "0x6C30") ; <CJK>
       (?$(H=,(B . "0x6DFC") ; <CJK>
       (?$(H=-(B . "0x6E46") ; <CJK>
       (?$(H=.(B . "0x6E47") ; <CJK>
       (?$(H=/(B . "0x6E1F") ; <CJK>
       (?$(H=0(B . "0x6E49") ; <CJK>
       (?$(H=1(B . "0x6E88") ; <CJK>
       (?$(H=2(B . "0x6E3C") ; <CJK>
       (?$(H=3(B . "0x6E3D") ; <CJK>
       (?$(H=4(B . "0x6E45") ; <CJK>
       (?$(H=5(B . "0x6E62") ; <CJK>
       (?$(H=6(B . "0x6E2B") ; <CJK>
       (?$(H=7(B . "0x6E3F") ; <CJK>
       (?$(H=8(B . "0x6E41") ; <CJK>
       (?$(H=9(B . "0x6E5D") ; <CJK>
       (?$(H=:(B . "0x6E73") ; <CJK>
       (?$(H=;(B . "0x6E1C") ; <CJK>
       (?$(H=<(B . "0x6E33") ; <CJK>
       (?$(H==(B . "0x6E4B") ; <CJK>
       (?$(H=>(B . "0x6E40") ; <CJK>
       (?$(H=?(B . "0x6E51") ; <CJK>
       (?$(H=@(B . "0x6E3B") ; <CJK>
       (?$(H=A(B . "0x6E03") ; <CJK>
       (?$(H=B(B . "0x6E2E") ; <CJK>
       (?$(H=C(B . "0x6E5E") ; <CJK>
       (?$(H=D(B . "0x6E68") ; <CJK>
       (?$(H=E(B . "0x6E5C") ; <CJK>
       (?$(H=F(B . "0x6E61") ; <CJK>
       (?$(H=G(B . "0x6E31") ; <CJK>
       (?$(H=H(B . "0x6E28") ; <CJK>
       (?$(H=I(B . "0x6E60") ; <CJK>
       (?$(H=J(B . "0x6E71") ; <CJK>
       (?$(H=K(B . "0x6E6B") ; <CJK>
       (?$(H=L(B . "0x6E39") ; <CJK>
       (?$(H=M(B . "0x6E22") ; <CJK>
       (?$(H=N(B . "0x6E30") ; <CJK>
       (?$(H=O(B . "0x6E53") ; <CJK>
       (?$(H=P(B . "0x6E65") ; <CJK>
       (?$(H=Q(B . "0x6E27") ; <CJK>
       (?$(H=R(B . "0x6E78") ; <CJK>
       (?$(H=S(B . "0x6E64") ; <CJK>
       (?$(H=T(B . "0x6E77") ; <CJK>
       (?$(H=U(B . "0x6E55") ; <CJK>
       (?$(H=V(B . "0x6E79") ; <CJK>
       (?$(H=W(B . "0x6E52") ; <CJK>
       (?$(H=X(B . "0x6E66") ; <CJK>
       (?$(H=Y(B . "0x6E35") ; <CJK>
       (?$(H=Z(B . "0x6E36") ; <CJK>
       (?$(H=[(B . "0x6E5A") ; <CJK>
       (?$(H=\(B . "0x7120") ; <CJK>
       (?$(H=](B . "0x711E") ; <CJK>
       (?$(H=^(B . "0x712F") ; <CJK>
       (?$(H=_(B . "0x70FB") ; <CJK>
       (?$(H=`(B . "0x712E") ; <CJK>
       (?$(H=a(B . "0x7131") ; <CJK>
       (?$(H=b(B . "0x7123") ; <CJK>
       (?$(H=c(B . "0x7125") ; <CJK>
       (?$(H=d(B . "0x7122") ; <CJK>
       (?$(H=e(B . "0x7132") ; <CJK>
       (?$(H=f(B . "0x711F") ; <CJK>
       (?$(H=g(B . "0x7128") ; <CJK>
       (?$(H=h(B . "0x713A") ; <CJK>
       (?$(H=i(B . "0x711B") ; <CJK>
       (?$(H=j(B . "0x724B") ; <CJK>
       (?$(H=k(B . "0x725A") ; <CJK>
       (?$(H=l(B . "0x7288") ; <CJK>
       (?$(H=m(B . "0x7289") ; <CJK>
       (?$(H=n(B . "0x7286") ; <CJK>
       (?$(H=o(B . "0x7285") ; <CJK>
       (?$(H=p(B . "0x728B") ; <CJK>
       (?$(H=q(B . "0x7312") ; <CJK>
       (?$(H=r(B . "0x730B") ; <CJK>
       (?$(H=s(B . "0x7330") ; <CJK>
       (?$(H=t(B . "0x7322") ; <CJK>
       (?$(H=u(B . "0x7331") ; <CJK>
       (?$(H=v(B . "0x7333") ; <CJK>
       (?$(H=w(B . "0x7327") ; <CJK>
       (?$(H=x(B . "0x7332") ; <CJK>
       (?$(H=y(B . "0x732D") ; <CJK>
       (?$(H=z(B . "0x7326") ; <CJK>
       (?$(H={(B . "0x7323") ; <CJK>
       (?$(H=|(B . "0x7335") ; <CJK>
       (?$(H=}(B . "0x730C") ; <CJK>
       (?$(H=~(B . "0x742E") ; <CJK>
       (?$(H>!(B . "0x742C") ; <CJK>
       (?$(H>"(B . "0x7430") ; <CJK>
       (?$(H>#(B . "0x742B") ; <CJK>
       (?$(H>$(B . "0x7416") ; <CJK>
       (?$(H>%(B . "0x741A") ; <CJK>
       (?$(H>&(B . "0x7421") ; <CJK>
       (?$(H>'(B . "0x742D") ; <CJK>
       (?$(H>((B . "0x7431") ; <CJK>
       (?$(H>)(B . "0x7424") ; <CJK>
       (?$(H>*(B . "0x7423") ; <CJK>
       (?$(H>+(B . "0x741D") ; <CJK>
       (?$(H>,(B . "0x7429") ; <CJK>
       (?$(H>-(B . "0x7420") ; <CJK>
       (?$(H>.(B . "0x7432") ; <CJK>
       (?$(H>/(B . "0x74FB") ; <CJK>
       (?$(H>0(B . "0x752F") ; <CJK>
       (?$(H>1(B . "0x756F") ; <CJK>
       (?$(H>2(B . "0x756C") ; <CJK>
       (?$(H>3(B . "0x75E7") ; <CJK>
       (?$(H>4(B . "0x75DA") ; <CJK>
       (?$(H>5(B . "0x75E1") ; <CJK>
       (?$(H>6(B . "0x75E6") ; <CJK>
       (?$(H>7(B . "0x75DD") ; <CJK>
       (?$(H>8(B . "0x75DF") ; <CJK>
       (?$(H>9(B . "0x75E4") ; <CJK>
       (?$(H>:(B . "0x75D7") ; <CJK>
       (?$(H>;(B . "0x7695") ; <CJK>
       (?$(H><(B . "0x7692") ; <CJK>
       (?$(H>=(B . "0x76DA") ; <CJK>
       (?$(H>>(B . "0x7746") ; <CJK>
       (?$(H>?(B . "0x7747") ; <CJK>
       (?$(H>@(B . "0x7744") ; <CJK>
       (?$(H>A(B . "0x774D") ; <CJK>
       (?$(H>B(B . "0x7745") ; <CJK>
       (?$(H>C(B . "0x774A") ; <CJK>
       (?$(H>D(B . "0x774E") ; <CJK>
       (?$(H>E(B . "0x774B") ; <CJK>
       (?$(H>F(B . "0x774C") ; <CJK>
       (?$(H>G(B . "0x77DE") ; <CJK>
       (?$(H>H(B . "0x77EC") ; <CJK>
       (?$(H>I(B . "0x7860") ; <CJK>
       (?$(H>J(B . "0x7864") ; <CJK>
       (?$(H>K(B . "0x7865") ; <CJK>
       (?$(H>L(B . "0x785C") ; <CJK>
       (?$(H>M(B . "0x786D") ; <CJK>
       (?$(H>N(B . "0x7871") ; <CJK>
       (?$(H>O(B . "0x786A") ; <CJK>
       (?$(H>P(B . "0x786E") ; <CJK>
       (?$(H>Q(B . "0x7870") ; <CJK>
       (?$(H>R(B . "0x7869") ; <CJK>
       (?$(H>S(B . "0x7868") ; <CJK>
       (?$(H>T(B . "0x785E") ; <CJK>
       (?$(H>U(B . "0x7862") ; <CJK>
       (?$(H>V(B . "0x7974") ; <CJK>
       (?$(H>W(B . "0x7973") ; <CJK>
       (?$(H>X(B . "0x7972") ; <CJK>
       (?$(H>Y(B . "0x7970") ; <CJK>
       (?$(H>Z(B . "0x7A02") ; <CJK>
       (?$(H>[(B . "0x7A0A") ; <CJK>
       (?$(H>\(B . "0x7A03") ; <CJK>
       (?$(H>](B . "0x7A0C") ; <CJK>
       (?$(H>^(B . "0x7A04") ; <CJK>
       (?$(H>_(B . "0x7A99") ; <CJK>
       (?$(H>`(B . "0x7AE6") ; <CJK>
       (?$(H>a(B . "0x7AE4") ; <CJK>
       (?$(H>b(B . "0x7B4A") ; <CJK>
       (?$(H>c(B . "0x7B47") ; <CJK>
       (?$(H>d(B . "0x7B44") ; <CJK>
       (?$(H>e(B . "0x7B48") ; <CJK>
       (?$(H>f(B . "0x7B4C") ; <CJK>
       (?$(H>g(B . "0x7B4E") ; <CJK>
       (?$(H>h(B . "0x7B40") ; <CJK>
       (?$(H>i(B . "0x7B58") ; <CJK>
       (?$(H>j(B . "0x7B45") ; <CJK>
       (?$(H>k(B . "0x7CA2") ; <CJK>
       (?$(H>l(B . "0x7C9E") ; <CJK>
       (?$(H>m(B . "0x7CA8") ; <CJK>
       (?$(H>n(B . "0x7CA1") ; <CJK>
       (?$(H>o(B . "0x7D58") ; <CJK>
       (?$(H>p(B . "0x7D6F") ; <CJK>
       (?$(H>q(B . "0x7D63") ; <CJK>
       (?$(H>r(B . "0x7D53") ; <CJK>
       (?$(H>s(B . "0x7D56") ; <CJK>
       (?$(H>t(B . "0x7D67") ; <CJK>
       (?$(H>u(B . "0x7D6A") ; <CJK>
       (?$(H>v(B . "0x7D4F") ; <CJK>
       (?$(H>w(B . "0x7D6D") ; <CJK>
       (?$(H>x(B . "0x7D5C") ; <CJK>
       (?$(H>y(B . "0x7D6B") ; <CJK>
       (?$(H>z(B . "0x7D52") ; <CJK>
       (?$(H>{(B . "0x7D54") ; <CJK>
       (?$(H>|(B . "0x7D69") ; <CJK>
       (?$(H>}(B . "0x7D51") ; <CJK>
       (?$(H>~(B . "0x7D5F") ; <CJK>
       (?$(H?!(B . "0x7D4E") ; <CJK>
       (?$(H?"(B . "0x7F3E") ; <CJK>
       (?$(H?#(B . "0x7F3F") ; <CJK>
       (?$(H?$(B . "0x7F65") ; <CJK>
       (?$(H?%(B . "0x7F66") ; <CJK>
       (?$(H?&(B . "0x7FA2") ; <CJK>
       (?$(H?'(B . "0x7FA0") ; <CJK>
       (?$(H?((B . "0x7FA1") ; <CJK>
       (?$(H?)(B . "0x7FD7") ; <CJK>
       (?$(H?*(B . "0x8051") ; <CJK>
       (?$(H?+(B . "0x804F") ; <CJK>
       (?$(H?,(B . "0x8050") ; <CJK>
       (?$(H?-(B . "0x80FE") ; <CJK>
       (?$(H?.(B . "0x80D4") ; <CJK>
       (?$(H?/(B . "0x8143") ; <CJK>
       (?$(H?0(B . "0x814A") ; <CJK>
       (?$(H?1(B . "0x8152") ; <CJK>
       (?$(H?2(B . "0x814F") ; <CJK>
       (?$(H?3(B . "0x8147") ; <CJK>
       (?$(H?4(B . "0x813D") ; <CJK>
       (?$(H?5(B . "0x814D") ; <CJK>
       (?$(H?6(B . "0x813A") ; <CJK>
       (?$(H?7(B . "0x81E6") ; <CJK>
       (?$(H?8(B . "0x81EE") ; <CJK>
       (?$(H?9(B . "0x81F7") ; <CJK>
       (?$(H?:(B . "0x81F8") ; <CJK>
       (?$(H?;(B . "0x81F9") ; <CJK>
       (?$(H?<(B . "0x8204") ; <CJK>
       (?$(H?=(B . "0x823C") ; <CJK>
       (?$(H?>(B . "0x823D") ; <CJK>
       (?$(H??(B . "0x823F") ; <CJK>
       (?$(H?@(B . "0x8275") ; <CJK>
       (?$(H?A(B . "0x833B") ; <CJK>
       (?$(H?B(B . "0x83CF") ; <CJK>
       (?$(H?C(B . "0x83F9") ; <CJK>
       (?$(H?D(B . "0x8423") ; <CJK>
       (?$(H?E(B . "0x83C0") ; <CJK>
       (?$(H?F(B . "0x83E8") ; <CJK>
       (?$(H?G(B . "0x8412") ; <CJK>
       (?$(H?H(B . "0x83E7") ; <CJK>
       (?$(H?I(B . "0x83E4") ; <CJK>
       (?$(H?J(B . "0x83FC") ; <CJK>
       (?$(H?K(B . "0x83F6") ; <CJK>
       (?$(H?L(B . "0x8410") ; <CJK>
       (?$(H?M(B . "0x83C6") ; <CJK>
       (?$(H?N(B . "0x83C8") ; <CJK>
       (?$(H?O(B . "0x83EB") ; <CJK>
       (?$(H?P(B . "0x83E3") ; <CJK>
       (?$(H?Q(B . "0x83BF") ; <CJK>
       (?$(H?R(B . "0x8401") ; <CJK>
       (?$(H?S(B . "0x83DD") ; <CJK>
       (?$(H?T(B . "0x83E5") ; <CJK>
       (?$(H?U(B . "0x83D8") ; <CJK>
       (?$(H?V(B . "0x83FF") ; <CJK>
       (?$(H?W(B . "0x83E1") ; <CJK>
       (?$(H?X(B . "0x83CB") ; <CJK>
       (?$(H?Y(B . "0x83CE") ; <CJK>
       (?$(H?Z(B . "0x83D6") ; <CJK>
       (?$(H?[(B . "0x83F5") ; <CJK>
       (?$(H?\(B . "0x83C9") ; <CJK>
       (?$(H?](B . "0x8409") ; <CJK>
       (?$(H?^(B . "0x840F") ; <CJK>
       (?$(H?_(B . "0x83DE") ; <CJK>
       (?$(H?`(B . "0x8411") ; <CJK>
       (?$(H?a(B . "0x8406") ; <CJK>
       (?$(H?b(B . "0x83C2") ; <CJK>
       (?$(H?c(B . "0x83F3") ; <CJK>
       (?$(H?d(B . "0x83D5") ; <CJK>
       (?$(H?e(B . "0x83FA") ; <CJK>
       (?$(H?f(B . "0x83C7") ; <CJK>
       (?$(H?g(B . "0x83D1") ; <CJK>
       (?$(H?h(B . "0x83EA") ; <CJK>
       (?$(H?i(B . "0x8413") ; <CJK>
       (?$(H?j(B . "0x839A") ; <CJK>
       (?$(H?k(B . "0x83C3") ; <CJK>
       (?$(H?l(B . "0x83EC") ; <CJK>
       (?$(H?m(B . "0x83EE") ; <CJK>
       (?$(H?n(B . "0x83C4") ; <CJK>
       (?$(H?o(B . "0x83FB") ; <CJK>
       (?$(H?p(B . "0x83D7") ; <CJK>
       (?$(H?q(B . "0x83E2") ; <CJK>
       (?$(H?r(B . "0x841B") ; <CJK>
       (?$(H?s(B . "0x83DB") ; <CJK>
       (?$(H?t(B . "0x83FE") ; <CJK>
       (?$(H?u(B . "0x86D8") ; <CJK>
       (?$(H?v(B . "0x86E2") ; <CJK>
       (?$(H?w(B . "0x86E6") ; <CJK>
       (?$(H?x(B . "0x86D3") ; <CJK>
       (?$(H?y(B . "0x86E3") ; <CJK>
       (?$(H?z(B . "0x86DA") ; <CJK>
       (?$(H?{(B . "0x86EA") ; <CJK>
       (?$(H?|(B . "0x86DD") ; <CJK>
       (?$(H?}(B . "0x86EB") ; <CJK>
       (?$(H?~(B . "0x86DC") ; <CJK>
       (?$(H@!(B . "0x86EC") ; <CJK>
       (?$(H@"(B . "0x86E9") ; <CJK>
       (?$(H@#(B . "0x86D7") ; <CJK>
       (?$(H@$(B . "0x86E8") ; <CJK>
       (?$(H@%(B . "0x86D1") ; <CJK>
       (?$(H@&(B . "0x8848") ; <CJK>
       (?$(H@'(B . "0x8856") ; <CJK>
       (?$(H@((B . "0x8855") ; <CJK>
       (?$(H@)(B . "0x88BA") ; <CJK>
       (?$(H@*(B . "0x88D7") ; <CJK>
       (?$(H@+(B . "0x88B9") ; <CJK>
       (?$(H@,(B . "0x88B8") ; <CJK>
       (?$(H@-(B . "0x88C0") ; <CJK>
       (?$(H@.(B . "0x88BE") ; <CJK>
       (?$(H@/(B . "0x88B6") ; <CJK>
       (?$(H@0(B . "0x88BC") ; <CJK>
       (?$(H@1(B . "0x88B7") ; <CJK>
       (?$(H@2(B . "0x88BD") ; <CJK>
       (?$(H@3(B . "0x88B2") ; <CJK>
       (?$(H@4(B . "0x8901") ; <CJK>
       (?$(H@5(B . "0x88C9") ; <CJK>
       (?$(H@6(B . "0x8995") ; <CJK>
       (?$(H@7(B . "0x8998") ; <CJK>
       (?$(H@8(B . "0x8997") ; <CJK>
       (?$(H@9(B . "0x89DD") ; <CJK>
       (?$(H@:(B . "0x89DA") ; <CJK>
       (?$(H@;(B . "0x89DB") ; <CJK>
       (?$(H@<(B . "0x8A4E") ; <CJK>
       (?$(H@=(B . "0x8A4D") ; <CJK>
       (?$(H@>(B . "0x8A39") ; <CJK>
       (?$(H@?(B . "0x8A59") ; <CJK>
       (?$(H@@(B . "0x8A40") ; <CJK>
       (?$(H@A(B . "0x8A57") ; <CJK>
       (?$(H@B(B . "0x8A58") ; <CJK>
       (?$(H@C(B . "0x8A44") ; <CJK>
       (?$(H@D(B . "0x8A45") ; <CJK>
       (?$(H@E(B . "0x8A52") ; <CJK>
       (?$(H@F(B . "0x8A48") ; <CJK>
       (?$(H@G(B . "0x8A51") ; <CJK>
       (?$(H@H(B . "0x8A4A") ; <CJK>
       (?$(H@I(B . "0x8A4C") ; <CJK>
       (?$(H@J(B . "0x8A4F") ; <CJK>
       (?$(H@K(B . "0x8C5F") ; <CJK>
       (?$(H@L(B . "0x8C81") ; <CJK>
       (?$(H@M(B . "0x8C80") ; <CJK>
       (?$(H@N(B . "0x8CBA") ; <CJK>
       (?$(H@O(B . "0x8CBE") ; <CJK>
       (?$(H@P(B . "0x8CB0") ; <CJK>
       (?$(H@Q(B . "0x8CB9") ; <CJK>
       (?$(H@R(B . "0x8CB5") ; <CJK>
       (?$(H@S(B . "0x8D84") ; <CJK>
       (?$(H@T(B . "0x8D80") ; <CJK>
       (?$(H@U(B . "0x8D89") ; <CJK>
       (?$(H@V(B . "0x8DD8") ; <CJK>
       (?$(H@W(B . "0x8DD3") ; <CJK>
       (?$(H@X(B . "0x8DCD") ; <CJK>
       (?$(H@Y(B . "0x8DC7") ; <CJK>
       (?$(H@Z(B . "0x8DD6") ; <CJK>
       (?$(H@[(B . "0x8DDC") ; <CJK>
       (?$(H@\(B . "0x8DCF") ; <CJK>
       (?$(H@](B . "0x8DD5") ; <CJK>
       (?$(H@^(B . "0x8DD9") ; <CJK>
       (?$(H@_(B . "0x8DC8") ; <CJK>
       (?$(H@`(B . "0x8DD7") ; <CJK>
       (?$(H@a(B . "0x8DC5") ; <CJK>
       (?$(H@b(B . "0x8EEF") ; <CJK>
       (?$(H@c(B . "0x8EF7") ; <CJK>
       (?$(H@d(B . "0x8EFA") ; <CJK>
       (?$(H@e(B . "0x8EF9") ; <CJK>
       (?$(H@f(B . "0x8EE6") ; <CJK>
       (?$(H@g(B . "0x8EEE") ; <CJK>
       (?$(H@h(B . "0x8EE5") ; <CJK>
       (?$(H@i(B . "0x8EF5") ; <CJK>
       (?$(H@j(B . "0x8EE7") ; <CJK>
       (?$(H@k(B . "0x8EE8") ; <CJK>
       (?$(H@l(B . "0x8EF6") ; <CJK>
       (?$(H@m(B . "0x8EEB") ; <CJK>
       (?$(H@n(B . "0x8EF1") ; <CJK>
       (?$(H@o(B . "0x8EEC") ; <CJK>
       (?$(H@p(B . "0x8EF4") ; <CJK>
       (?$(H@q(B . "0x8EE9") ; <CJK>
       (?$(H@r(B . "0x902D") ; <CJK>
       (?$(H@s(B . "0x9034") ; <CJK>
       (?$(H@t(B . "0x902F") ; <CJK>
       (?$(H@u(B . "0x9106") ; <CJK>
       (?$(H@v(B . "0x912C") ; <CJK>
       (?$(H@w(B . "0x9104") ; <CJK>
       (?$(H@x(B . "0x90FF") ; <CJK>
       (?$(H@y(B . "0x90FC") ; <CJK>
       (?$(H@z(B . "0x9108") ; <CJK>
       (?$(H@{(B . "0x90F9") ; <CJK>
       (?$(H@|(B . "0x90FB") ; <CJK>
       (?$(H@}(B . "0x9101") ; <CJK>
       (?$(H@~(B . "0x9100") ; <CJK>
       (?$(HA!(B . "0x9107") ; <CJK>
       (?$(HA"(B . "0x9105") ; <CJK>
       (?$(HA#(B . "0x9103") ; <CJK>
       (?$(HA$(B . "0x9161") ; <CJK>
       (?$(HA%(B . "0x9164") ; <CJK>
       (?$(HA&(B . "0x915F") ; <CJK>
       (?$(HA'(B . "0x9162") ; <CJK>
       (?$(HA((B . "0x9160") ; <CJK>
       (?$(HA)(B . "0x9201") ; <CJK>
       (?$(HA*(B . "0x920A") ; <CJK>
       (?$(HA+(B . "0x9225") ; <CJK>
       (?$(HA,(B . "0x9203") ; <CJK>
       (?$(HA-(B . "0x921A") ; <CJK>
       (?$(HA.(B . "0x9226") ; <CJK>
       (?$(HA/(B . "0x920F") ; <CJK>
       (?$(HA0(B . "0x920C") ; <CJK>
       (?$(HA1(B . "0x9200") ; <CJK>
       (?$(HA2(B . "0x9212") ; <CJK>
       (?$(HA3(B . "0x91FF") ; <CJK>
       (?$(HA4(B . "0x91FD") ; <CJK>
       (?$(HA5(B . "0x9206") ; <CJK>
       (?$(HA6(B . "0x9204") ; <CJK>
       (?$(HA7(B . "0x9227") ; <CJK>
       (?$(HA8(B . "0x9202") ; <CJK>
       (?$(HA9(B . "0x921C") ; <CJK>
       (?$(HA:(B . "0x9224") ; <CJK>
       (?$(HA;(B . "0x9219") ; <CJK>
       (?$(HA<(B . "0x9217") ; <CJK>
       (?$(HA=(B . "0x9205") ; <CJK>
       (?$(HA>(B . "0x9216") ; <CJK>
       (?$(HA?(B . "0x957B") ; <CJK>
       (?$(HA@(B . "0x958D") ; <CJK>
       (?$(HAA(B . "0x958C") ; <CJK>
       (?$(HAB(B . "0x9590") ; <CJK>
       (?$(HAC(B . "0x9687") ; <CJK>
       (?$(HAD(B . "0x967E") ; <CJK>
       (?$(HAE(B . "0x9688") ; <CJK>
       (?$(HAF(B . "0x9689") ; <CJK>
       (?$(HAG(B . "0x9683") ; <CJK>
       (?$(HAH(B . "0x9680") ; <CJK>
       (?$(HAI(B . "0x96C2") ; <CJK>
       (?$(HAJ(B . "0x96C8") ; <CJK>
       (?$(HAK(B . "0x96C3") ; <CJK>
       (?$(HAL(B . "0x96F1") ; <CJK>
       (?$(HAM(B . "0x96F0") ; <CJK>
       (?$(HAN(B . "0x976C") ; <CJK>
       (?$(HAO(B . "0x9770") ; <CJK>
       (?$(HAP(B . "0x976E") ; <CJK>
       (?$(HAQ(B . "0x9807") ; <CJK>
       (?$(HAR(B . "0x98A9") ; <CJK>
       (?$(HAS(B . "0x98EB") ; <CJK>
       (?$(HAT(B . "0x9CE6") ; <CJK>
       (?$(HAU(B . "0x9EF9") ; <CJK>
       (?$(HAV(B . "0x4E83") ; <CJK>
       (?$(HAW(B . "0x4E84") ; <CJK>
       (?$(HAX(B . "0x4EB6") ; <CJK>
       (?$(HAY(B . "0x50BD") ; <CJK>
       (?$(HAZ(B . "0x50BF") ; <CJK>
       (?$(HA[(B . "0x50C6") ; <CJK>
       (?$(HA\(B . "0x50AE") ; <CJK>
       (?$(HA](B . "0x50C4") ; <CJK>
       (?$(HA^(B . "0x50CA") ; <CJK>
       (?$(HA_(B . "0x50B4") ; <CJK>
       (?$(HA`(B . "0x50C8") ; <CJK>
       (?$(HAa(B . "0x50C2") ; <CJK>
       (?$(HAb(B . "0x50B0") ; <CJK>
       (?$(HAc(B . "0x50C1") ; <CJK>
       (?$(HAd(B . "0x50BA") ; <CJK>
       (?$(HAe(B . "0x50B1") ; <CJK>
       (?$(HAf(B . "0x50CB") ; <CJK>
       (?$(HAg(B . "0x50C9") ; <CJK>
       (?$(HAh(B . "0x50B6") ; <CJK>
       (?$(HAi(B . "0x50B8") ; <CJK>
       (?$(HAj(B . "0x51D7") ; <CJK>
       (?$(HAk(B . "0x527A") ; <CJK>
       (?$(HAl(B . "0x5278") ; <CJK>
       (?$(HAm(B . "0x527B") ; <CJK>
       (?$(HAn(B . "0x527C") ; <CJK>
       (?$(HAo(B . "0x55C3") ; <CJK>
       (?$(HAp(B . "0x55DB") ; <CJK>
       (?$(HAq(B . "0x55CC") ; <CJK>
       (?$(HAr(B . "0x55D0") ; <CJK>
       (?$(HAs(B . "0x55CB") ; <CJK>
       (?$(HAt(B . "0x55CA") ; <CJK>
       (?$(HAu(B . "0x55DD") ; <CJK>
       (?$(HAv(B . "0x55C0") ; <CJK>
       (?$(HAw(B . "0x55D4") ; <CJK>
       (?$(HAx(B . "0x55C4") ; <CJK>
       (?$(HAy(B . "0x55E9") ; <CJK>
       (?$(HAz(B . "0x55BF") ; <CJK>
       (?$(HA{(B . "0x55D2") ; <CJK>
       (?$(HA|(B . "0x558D") ; <CJK>
       (?$(HA}(B . "0x55CF") ; <CJK>
       (?$(HA~(B . "0x55D5") ; <CJK>
       (?$(HB!(B . "0x55E2") ; <CJK>
       (?$(HB"(B . "0x55D6") ; <CJK>
       (?$(HB#(B . "0x55C8") ; <CJK>
       (?$(HB$(B . "0x55F2") ; <CJK>
       (?$(HB%(B . "0x55CD") ; <CJK>
       (?$(HB&(B . "0x55D9") ; <CJK>
       (?$(HB'(B . "0x55C2") ; <CJK>
       (?$(HB((B . "0x5714") ; <CJK>
       (?$(HB)(B . "0x5853") ; <CJK>
       (?$(HB*(B . "0x5868") ; <CJK>
       (?$(HB+(B . "0x5864") ; <CJK>
       (?$(HB,(B . "0x584F") ; <CJK>
       (?$(HB-(B . "0x584D") ; <CJK>
       (?$(HB.(B . "0x5849") ; <CJK>
       (?$(HB/(B . "0x586F") ; <CJK>
       (?$(HB0(B . "0x5855") ; <CJK>
       (?$(HB1(B . "0x584E") ; <CJK>
       (?$(HB2(B . "0x585D") ; <CJK>
       (?$(HB3(B . "0x5859") ; <CJK>
       (?$(HB4(B . "0x5865") ; <CJK>
       (?$(HB5(B . "0x585B") ; <CJK>
       (?$(HB6(B . "0x583D") ; <CJK>
       (?$(HB7(B . "0x5863") ; <CJK>
       (?$(HB8(B . "0x5871") ; <CJK>
       (?$(HB9(B . "0x58FC") ; <CJK>
       (?$(HB:(B . "0x5AC7") ; <CJK>
       (?$(HB;(B . "0x5AC4") ; <CJK>
       (?$(HB<(B . "0x5ACB") ; <CJK>
       (?$(HB=(B . "0x5ABA") ; <CJK>
       (?$(HB>(B . "0x5AB8") ; <CJK>
       (?$(HB?(B . "0x5AB1") ; <CJK>
       (?$(HB@(B . "0x5AB5") ; <CJK>
       (?$(HBA(B . "0x5AB0") ; <CJK>
       (?$(HBB(B . "0x5ABF") ; <CJK>
       (?$(HBC(B . "0x5AC8") ; <CJK>
       (?$(HBD(B . "0x5ABB") ; <CJK>
       (?$(HBE(B . "0x5AC6") ; <CJK>
       (?$(HBF(B . "0x5AB7") ; <CJK>
       (?$(HBG(B . "0x5AC0") ; <CJK>
       (?$(HBH(B . "0x5ACA") ; <CJK>
       (?$(HBI(B . "0x5AB4") ; <CJK>
       (?$(HBJ(B . "0x5AB6") ; <CJK>
       (?$(HBK(B . "0x5ACD") ; <CJK>
       (?$(HBL(B . "0x5AB9") ; <CJK>
       (?$(HBM(B . "0x5A90") ; <CJK>
       (?$(HBN(B . "0x5BD6") ; <CJK>
       (?$(HBO(B . "0x5BD8") ; <CJK>
       (?$(HBP(B . "0x5BD9") ; <CJK>
       (?$(HBQ(B . "0x5C1F") ; <CJK>
       (?$(HBR(B . "0x5C33") ; <CJK>
       (?$(HBS(B . "0x5D71") ; <CJK>
       (?$(HBT(B . "0x5D63") ; <CJK>
       (?$(HBU(B . "0x5D4A") ; <CJK>
       (?$(HBV(B . "0x5D65") ; <CJK>
       (?$(HBW(B . "0x5D72") ; <CJK>
       (?$(HBX(B . "0x5D6C") ; <CJK>
       (?$(HBY(B . "0x5D5E") ; <CJK>
       (?$(HBZ(B . "0x5D68") ; <CJK>
       (?$(HB[(B . "0x5D67") ; <CJK>
       (?$(HB\(B . "0x5D62") ; <CJK>
       (?$(HB](B . "0x5DF0") ; <CJK>
       (?$(HB^(B . "0x5E4F") ; <CJK>
       (?$(HB_(B . "0x5E4E") ; <CJK>
       (?$(HB`(B . "0x5E4A") ; <CJK>
       (?$(HBa(B . "0x5E4D") ; <CJK>
       (?$(HBb(B . "0x5E4B") ; <CJK>
       (?$(HBc(B . "0x5EC5") ; <CJK>
       (?$(HBd(B . "0x5ECC") ; <CJK>
       (?$(HBe(B . "0x5EC6") ; <CJK>
       (?$(HBf(B . "0x5ECB") ; <CJK>
       (?$(HBg(B . "0x5EC7") ; <CJK>
       (?$(HBh(B . "0x5F40") ; <CJK>
       (?$(HBi(B . "0x5FAF") ; <CJK>
       (?$(HBj(B . "0x5FAD") ; <CJK>
       (?$(HBk(B . "0x60F7") ; <CJK>
       (?$(HBl(B . "0x6149") ; <CJK>
       (?$(HBm(B . "0x614A") ; <CJK>
       (?$(HBn(B . "0x612B") ; <CJK>
       (?$(HBo(B . "0x6145") ; <CJK>
       (?$(HBp(B . "0x6136") ; <CJK>
       (?$(HBq(B . "0x6132") ; <CJK>
       (?$(HBr(B . "0x612E") ; <CJK>
       (?$(HBs(B . "0x6146") ; <CJK>
       (?$(HBt(B . "0x612F") ; <CJK>
       (?$(HBu(B . "0x614F") ; <CJK>
       (?$(HBv(B . "0x6129") ; <CJK>
       (?$(HBw(B . "0x6140") ; <CJK>
       (?$(HBx(B . "0x6220") ; <CJK>
       (?$(HBy(B . "0x9168") ; <CJK>
       (?$(HBz(B . "0x6223") ; <CJK>
       (?$(HB{(B . "0x6225") ; <CJK>
       (?$(HB|(B . "0x6224") ; <CJK>
       (?$(HB}(B . "0x63C5") ; <CJK>
       (?$(HB~(B . "0x63F1") ; <CJK>
       (?$(HC!(B . "0x63EB") ; <CJK>
       (?$(HC"(B . "0x6410") ; <CJK>
       (?$(HC#(B . "0x6412") ; <CJK>
       (?$(HC$(B . "0x6409") ; <CJK>
       (?$(HC%(B . "0x6420") ; <CJK>
       (?$(HC&(B . "0x6424") ; <CJK>
       (?$(HC'(B . "0x6433") ; <CJK>
       (?$(HC((B . "0x6443") ; <CJK>
       (?$(HC)(B . "0x641F") ; <CJK>
       (?$(HC*(B . "0x6415") ; <CJK>
       (?$(HC+(B . "0x6418") ; <CJK>
       (?$(HC,(B . "0x6439") ; <CJK>
       (?$(HC-(B . "0x6437") ; <CJK>
       (?$(HC.(B . "0x6422") ; <CJK>
       (?$(HC/(B . "0x6423") ; <CJK>
       (?$(HC0(B . "0x640C") ; <CJK>
       (?$(HC1(B . "0x6426") ; <CJK>
       (?$(HC2(B . "0x6430") ; <CJK>
       (?$(HC3(B . "0x6428") ; <CJK>
       (?$(HC4(B . "0x6441") ; <CJK>
       (?$(HC5(B . "0x6435") ; <CJK>
       (?$(HC6(B . "0x642F") ; <CJK>
       (?$(HC7(B . "0x640A") ; <CJK>
       (?$(HC8(B . "0x641A") ; <CJK>
       (?$(HC9(B . "0x6440") ; <CJK>
       (?$(HC:(B . "0x6425") ; <CJK>
       (?$(HC;(B . "0x6427") ; <CJK>
       (?$(HC<(B . "0x640B") ; <CJK>
       (?$(HC=(B . "0x63E7") ; <CJK>
       (?$(HC>(B . "0x641B") ; <CJK>
       (?$(HC?(B . "0x642E") ; <CJK>
       (?$(HC@(B . "0x6421") ; <CJK>
       (?$(HCA(B . "0x640E") ; <CJK>
       (?$(HCB(B . "0x656F") ; <CJK>
       (?$(HCC(B . "0x6592") ; <CJK>
       (?$(HCD(B . "0x65D3") ; <CJK>
       (?$(HCE(B . "0x6686") ; <CJK>
       (?$(HCF(B . "0x668C") ; <CJK>
       (?$(HCG(B . "0x6695") ; <CJK>
       (?$(HCH(B . "0x6690") ; <CJK>
       (?$(HCI(B . "0x668B") ; <CJK>
       (?$(HCJ(B . "0x668A") ; <CJK>
       (?$(HCK(B . "0x6699") ; <CJK>
       (?$(HCL(B . "0x6694") ; <CJK>
       (?$(HCM(B . "0x6678") ; <CJK>
       (?$(HCN(B . "0x6720") ; <CJK>
       (?$(HCO(B . "0x6966") ; <CJK>
       (?$(HCP(B . "0x695F") ; <CJK>
       (?$(HCQ(B . "0x6938") ; <CJK>
       (?$(HCR(B . "0x694E") ; <CJK>
       (?$(HCS(B . "0x6962") ; <CJK>
       (?$(HCT(B . "0x6971") ; <CJK>
       (?$(HCU(B . "0x693F") ; <CJK>
       (?$(HCV(B . "0x6945") ; <CJK>
       (?$(HCW(B . "0x696A") ; <CJK>
       (?$(HCX(B . "0x6939") ; <CJK>
       (?$(HCY(B . "0x6942") ; <CJK>
       (?$(HCZ(B . "0x6957") ; <CJK>
       (?$(HC[(B . "0x6959") ; <CJK>
       (?$(HC\(B . "0x697A") ; <CJK>
       (?$(HC](B . "0x6948") ; <CJK>
       (?$(HC^(B . "0x6949") ; <CJK>
       (?$(HC_(B . "0x6935") ; <CJK>
       (?$(HC`(B . "0x696C") ; <CJK>
       (?$(HCa(B . "0x6933") ; <CJK>
       (?$(HCb(B . "0x693D") ; <CJK>
       (?$(HCc(B . "0x6965") ; <CJK>
       (?$(HCd(B . "0x68F0") ; <CJK>
       (?$(HCe(B . "0x6978") ; <CJK>
       (?$(HCf(B . "0x6934") ; <CJK>
       (?$(HCg(B . "0x6969") ; <CJK>
       (?$(HCh(B . "0x6940") ; <CJK>
       (?$(HCi(B . "0x696F") ; <CJK>
       (?$(HCj(B . "0x6944") ; <CJK>
       (?$(HCk(B . "0x6976") ; <CJK>
       (?$(HCl(B . "0x6958") ; <CJK>
       (?$(HCm(B . "0x6941") ; <CJK>
       (?$(HCn(B . "0x6974") ; <CJK>
       (?$(HCo(B . "0x694C") ; <CJK>
       (?$(HCp(B . "0x693B") ; <CJK>
       (?$(HCq(B . "0x694B") ; <CJK>
       (?$(HCr(B . "0x6937") ; <CJK>
       (?$(HCs(B . "0x695C") ; <CJK>
       (?$(HCt(B . "0x694F") ; <CJK>
       (?$(HCu(B . "0x6951") ; <CJK>
       (?$(HCv(B . "0x6932") ; <CJK>
       (?$(HCw(B . "0x6952") ; <CJK>
       (?$(HCx(B . "0x692F") ; <CJK>
       (?$(HCy(B . "0x697B") ; <CJK>
       (?$(HCz(B . "0x693C") ; <CJK>
       (?$(HC{(B . "0x6B46") ; <CJK>
       (?$(HC|(B . "0x6B45") ; <CJK>
       (?$(HC}(B . "0x6B43") ; <CJK>
       (?$(HC~(B . "0x6B42") ; <CJK>
       (?$(HD!(B . "0x6B48") ; <CJK>
       (?$(HD"(B . "0x6B41") ; <CJK>
       (?$(HD#(B . "0x6B9B") ; <CJK>
       (?$(HD$(B . "0x6BFB") ; <CJK>
       (?$(HD%(B . "0x6BFC") ; <CJK>
       (?$(HD&(B . "0x6BF9") ; <CJK>
       (?$(HD'(B . "0x6BF7") ; <CJK>
       (?$(HD((B . "0x6BF8") ; <CJK>
       (?$(HD)(B . "0x6E9B") ; <CJK>
       (?$(HD*(B . "0x6ED6") ; <CJK>
       (?$(HD+(B . "0x6EC8") ; <CJK>
       (?$(HD,(B . "0x6E8F") ; <CJK>
       (?$(HD-(B . "0x6EC0") ; <CJK>
       (?$(HD.(B . "0x6E9F") ; <CJK>
       (?$(HD/(B . "0x6E93") ; <CJK>
       (?$(HD0(B . "0x6E94") ; <CJK>
       (?$(HD1(B . "0x6EA0") ; <CJK>
       (?$(HD2(B . "0x6EB1") ; <CJK>
       (?$(HD3(B . "0x6EB9") ; <CJK>
       (?$(HD4(B . "0x6EC6") ; <CJK>
       (?$(HD5(B . "0x6ED2") ; <CJK>
       (?$(HD6(B . "0x6EBD") ; <CJK>
       (?$(HD7(B . "0x6EC1") ; <CJK>
       (?$(HD8(B . "0x6E9E") ; <CJK>
       (?$(HD9(B . "0x6EC9") ; <CJK>
       (?$(HD:(B . "0x6EB7") ; <CJK>
       (?$(HD;(B . "0x6EB0") ; <CJK>
       (?$(HD<(B . "0x6ECD") ; <CJK>
       (?$(HD=(B . "0x6EA6") ; <CJK>
       (?$(HD>(B . "0x6ECF") ; <CJK>
       (?$(HD?(B . "0x6EB2") ; <CJK>
       (?$(HD@(B . "0x6EBE") ; <CJK>
       (?$(HDA(B . "0x6EC3") ; <CJK>
       (?$(HDB(B . "0x6EDC") ; <CJK>
       (?$(HDC(B . "0x6ED8") ; <CJK>
       (?$(HDD(B . "0x6E99") ; <CJK>
       (?$(HDE(B . "0x6E92") ; <CJK>
       (?$(HDF(B . "0x6E8E") ; <CJK>
       (?$(HDG(B . "0x6E8D") ; <CJK>
       (?$(HDH(B . "0x6EA4") ; <CJK>
       (?$(HDI(B . "0x6EA1") ; <CJK>
       (?$(HDJ(B . "0x6EBF") ; <CJK>
       (?$(HDK(B . "0x6EB3") ; <CJK>
       (?$(HDL(B . "0x6ED0") ; <CJK>
       (?$(HDM(B . "0x6ECA") ; <CJK>
       (?$(HDN(B . "0x6E97") ; <CJK>
       (?$(HDO(B . "0x6EAE") ; <CJK>
       (?$(HDP(B . "0x6EA3") ; <CJK>
       (?$(HDQ(B . "0x7147") ; <CJK>
       (?$(HDR(B . "0x7154") ; <CJK>
       (?$(HDS(B . "0x7152") ; <CJK>
       (?$(HDT(B . "0x7163") ; <CJK>
       (?$(HDU(B . "0x7160") ; <CJK>
       (?$(HDV(B . "0x7141") ; <CJK>
       (?$(HDW(B . "0x715D") ; <CJK>
       (?$(HDX(B . "0x7162") ; <CJK>
       (?$(HDY(B . "0x7172") ; <CJK>
       (?$(HDZ(B . "0x7178") ; <CJK>
       (?$(HD[(B . "0x716A") ; <CJK>
       (?$(HD\(B . "0x7161") ; <CJK>
       (?$(HD](B . "0x7142") ; <CJK>
       (?$(HD^(B . "0x7158") ; <CJK>
       (?$(HD_(B . "0x7143") ; <CJK>
       (?$(HD`(B . "0x714B") ; <CJK>
       (?$(HDa(B . "0x7170") ; <CJK>
       (?$(HDb(B . "0x715F") ; <CJK>
       (?$(HDc(B . "0x7150") ; <CJK>
       (?$(HDd(B . "0x7153") ; <CJK>
       (?$(HDe(B . "0x7144") ; <CJK>
       (?$(HDf(B . "0x714D") ; <CJK>
       (?$(HDg(B . "0x715A") ; <CJK>
       (?$(HDh(B . "0x724F") ; <CJK>
       (?$(HDi(B . "0x728D") ; <CJK>
       (?$(HDj(B . "0x728C") ; <CJK>
       (?$(HDk(B . "0x7291") ; <CJK>
       (?$(HDl(B . "0x7290") ; <CJK>
       (?$(HDm(B . "0x728E") ; <CJK>
       (?$(HDn(B . "0x733C") ; <CJK>
       (?$(HDo(B . "0x7342") ; <CJK>
       (?$(HDp(B . "0x733B") ; <CJK>
       (?$(HDq(B . "0x733A") ; <CJK>
       (?$(HDr(B . "0x7340") ; <CJK>
       (?$(HDs(B . "0x734A") ; <CJK>
       (?$(HDt(B . "0x7349") ; <CJK>
       (?$(HDu(B . "0x7444") ; <CJK>
       (?$(HDv(B . "0x744A") ; <CJK>
       (?$(HDw(B . "0x744B") ; <CJK>
       (?$(HDx(B . "0x7452") ; <CJK>
       (?$(HDy(B . "0x7451") ; <CJK>
       (?$(HDz(B . "0x7457") ; <CJK>
       (?$(HD{(B . "0x7440") ; <CJK>
       (?$(HD|(B . "0x744F") ; <CJK>
       (?$(HD}(B . "0x7450") ; <CJK>
       (?$(HD~(B . "0x744E") ; <CJK>
       (?$(HE!(B . "0x7442") ; <CJK>
       (?$(HE"(B . "0x7446") ; <CJK>
       (?$(HE#(B . "0x744D") ; <CJK>
       (?$(HE$(B . "0x7454") ; <CJK>
       (?$(HE%(B . "0x74E1") ; <CJK>
       (?$(HE&(B . "0x74FF") ; <CJK>
       (?$(HE'(B . "0x74FE") ; <CJK>
       (?$(HE((B . "0x74FD") ; <CJK>
       (?$(HE)(B . "0x751D") ; <CJK>
       (?$(HE*(B . "0x7579") ; <CJK>
       (?$(HE+(B . "0x7577") ; <CJK>
       (?$(HE,(B . "0x6983") ; <CJK>
       (?$(HE-(B . "0x75EF") ; <CJK>
       (?$(HE.(B . "0x760F") ; <CJK>
       (?$(HE/(B . "0x7603") ; <CJK>
       (?$(HE0(B . "0x75F7") ; <CJK>
       (?$(HE1(B . "0x75FE") ; <CJK>
       (?$(HE2(B . "0x75FC") ; <CJK>
       (?$(HE3(B . "0x75F9") ; <CJK>
       (?$(HE4(B . "0x75F8") ; <CJK>
       (?$(HE5(B . "0x7610") ; <CJK>
       (?$(HE6(B . "0x75FB") ; <CJK>
       (?$(HE7(B . "0x75F6") ; <CJK>
       (?$(HE8(B . "0x75ED") ; <CJK>
       (?$(HE9(B . "0x75F5") ; <CJK>
       (?$(HE:(B . "0x75FD") ; <CJK>
       (?$(HE;(B . "0x7699") ; <CJK>
       (?$(HE<(B . "0x76B5") ; <CJK>
       (?$(HE=(B . "0x76DD") ; <CJK>
       (?$(HE>(B . "0x7755") ; <CJK>
       (?$(HE?(B . "0x775F") ; <CJK>
       (?$(HE@(B . "0x7760") ; <CJK>
       (?$(HEA(B . "0x7752") ; <CJK>
       (?$(HEB(B . "0x7756") ; <CJK>
       (?$(HEC(B . "0x775A") ; <CJK>
       (?$(HED(B . "0x7769") ; <CJK>
       (?$(HEE(B . "0x7767") ; <CJK>
       (?$(HEF(B . "0x7754") ; <CJK>
       (?$(HEG(B . "0x7759") ; <CJK>
       (?$(HEH(B . "0x776D") ; <CJK>
       (?$(HEI(B . "0x77E0") ; <CJK>
       (?$(HEJ(B . "0x7887") ; <CJK>
       (?$(HEK(B . "0x789A") ; <CJK>
       (?$(HEL(B . "0x7894") ; <CJK>
       (?$(HEM(B . "0x788F") ; <CJK>
       (?$(HEN(B . "0x7884") ; <CJK>
       (?$(HEO(B . "0x7895") ; <CJK>
       (?$(HEP(B . "0x7885") ; <CJK>
       (?$(HEQ(B . "0x7886") ; <CJK>
       (?$(HER(B . "0x78A1") ; <CJK>
       (?$(HES(B . "0x7883") ; <CJK>
       (?$(HET(B . "0x7879") ; <CJK>
       (?$(HEU(B . "0x7899") ; <CJK>
       (?$(HEV(B . "0x7880") ; <CJK>
       (?$(HEW(B . "0x7896") ; <CJK>
       (?$(HEX(B . "0x787B") ; <CJK>
       (?$(HEY(B . "0x797C") ; <CJK>
       (?$(HEZ(B . "0x7982") ; <CJK>
       (?$(HE[(B . "0x797D") ; <CJK>
       (?$(HE\(B . "0x7979") ; <CJK>
       (?$(HE](B . "0x7A11") ; <CJK>
       (?$(HE^(B . "0x7A18") ; <CJK>
       (?$(HE_(B . "0x7A19") ; <CJK>
       (?$(HE`(B . "0x7A12") ; <CJK>
       (?$(HEa(B . "0x7A17") ; <CJK>
       (?$(HEb(B . "0x7A15") ; <CJK>
       (?$(HEc(B . "0x7A22") ; <CJK>
       (?$(HEd(B . "0x7A13") ; <CJK>
       (?$(HEe(B . "0x7A1B") ; <CJK>
       (?$(HEf(B . "0x7A10") ; <CJK>
       (?$(HEg(B . "0x7AA3") ; <CJK>
       (?$(HEh(B . "0x7AA2") ; <CJK>
       (?$(HEi(B . "0x7A9E") ; <CJK>
       (?$(HEj(B . "0x7AEB") ; <CJK>
       (?$(HEk(B . "0x7B66") ; <CJK>
       (?$(HEl(B . "0x7B64") ; <CJK>
       (?$(HEm(B . "0x7B6D") ; <CJK>
       (?$(HEn(B . "0x7B74") ; <CJK>
       (?$(HEo(B . "0x7B69") ; <CJK>
       (?$(HEp(B . "0x7B72") ; <CJK>
       (?$(HEq(B . "0x7B65") ; <CJK>
       (?$(HEr(B . "0x7B73") ; <CJK>
       (?$(HEs(B . "0x7B71") ; <CJK>
       (?$(HEt(B . "0x7B70") ; <CJK>
       (?$(HEu(B . "0x7B61") ; <CJK>
       (?$(HEv(B . "0x7B78") ; <CJK>
       (?$(HEw(B . "0x7B76") ; <CJK>
       (?$(HEx(B . "0x7B63") ; <CJK>
       (?$(HEy(B . "0x7CB2") ; <CJK>
       (?$(HEz(B . "0x7CB4") ; <CJK>
       (?$(HE{(B . "0x7CAF") ; <CJK>
       (?$(HE|(B . "0x7D88") ; <CJK>
       (?$(HE}(B . "0x7D86") ; <CJK>
       (?$(HE~(B . "0x7D80") ; <CJK>
       (?$(HF!(B . "0x7D8D") ; <CJK>
       (?$(HF"(B . "0x7D7F") ; <CJK>
       (?$(HF#(B . "0x7D85") ; <CJK>
       (?$(HF$(B . "0x7D7A") ; <CJK>
       (?$(HF%(B . "0x7D8E") ; <CJK>
       (?$(HF&(B . "0x7D7B") ; <CJK>
       (?$(HF'(B . "0x7D83") ; <CJK>
       (?$(HF((B . "0x7D7C") ; <CJK>
       (?$(HF)(B . "0x7D8C") ; <CJK>
       (?$(HF*(B . "0x7D94") ; <CJK>
       (?$(HF+(B . "0x7D84") ; <CJK>
       (?$(HF,(B . "0x7D7D") ; <CJK>
       (?$(HF-(B . "0x7D92") ; <CJK>
       (?$(HF.(B . "0x7F6D") ; <CJK>
       (?$(HF/(B . "0x7F6B") ; <CJK>
       (?$(HF0(B . "0x7F67") ; <CJK>
       (?$(HF1(B . "0x7F68") ; <CJK>
       (?$(HF2(B . "0x7F6C") ; <CJK>
       (?$(HF3(B . "0x7FA6") ; <CJK>
       (?$(HF4(B . "0x7FA5") ; <CJK>
       (?$(HF5(B . "0x7FA7") ; <CJK>
       (?$(HF6(B . "0x7FDB") ; <CJK>
       (?$(HF7(B . "0x7FDC") ; <CJK>
       (?$(HF8(B . "0x8021") ; <CJK>
       (?$(HF9(B . "0x8164") ; <CJK>
       (?$(HF:(B . "0x8160") ; <CJK>
       (?$(HF;(B . "0x8177") ; <CJK>
       (?$(HF<(B . "0x815C") ; <CJK>
       (?$(HF=(B . "0x8169") ; <CJK>
       (?$(HF>(B . "0x815B") ; <CJK>
       (?$(HF?(B . "0x8162") ; <CJK>
       (?$(HF@(B . "0x8172") ; <CJK>
       (?$(HFA(B . "0x6721") ; <CJK>
       (?$(HFB(B . "0x815E") ; <CJK>
       (?$(HFC(B . "0x8176") ; <CJK>
       (?$(HFD(B . "0x8167") ; <CJK>
       (?$(HFE(B . "0x816F") ; <CJK>
       (?$(HFF(B . "0x8144") ; <CJK>
       (?$(HFG(B . "0x8161") ; <CJK>
       (?$(HFH(B . "0x821D") ; <CJK>
       (?$(HFI(B . "0x8249") ; <CJK>
       (?$(HFJ(B . "0x8244") ; <CJK>
       (?$(HFK(B . "0x8240") ; <CJK>
       (?$(HFL(B . "0x8242") ; <CJK>
       (?$(HFM(B . "0x8245") ; <CJK>
       (?$(HFN(B . "0x84F1") ; <CJK>
       (?$(HFO(B . "0x843F") ; <CJK>
       (?$(HFP(B . "0x8456") ; <CJK>
       (?$(HFQ(B . "0x8476") ; <CJK>
       (?$(HFR(B . "0x8479") ; <CJK>
       (?$(HFS(B . "0x848F") ; <CJK>
       (?$(HFT(B . "0x848D") ; <CJK>
       (?$(HFU(B . "0x8465") ; <CJK>
       (?$(HFV(B . "0x8451") ; <CJK>
       (?$(HFW(B . "0x8440") ; <CJK>
       (?$(HFX(B . "0x8486") ; <CJK>
       (?$(HFY(B . "0x8467") ; <CJK>
       (?$(HFZ(B . "0x8430") ; <CJK>
       (?$(HF[(B . "0x844D") ; <CJK>
       (?$(HF\(B . "0x847D") ; <CJK>
       (?$(HF](B . "0x845A") ; <CJK>
       (?$(HF^(B . "0x8459") ; <CJK>
       (?$(HF_(B . "0x8474") ; <CJK>
       (?$(HF`(B . "0x8473") ; <CJK>
       (?$(HFa(B . "0x845D") ; <CJK>
       (?$(HFb(B . "0x8507") ; <CJK>
       (?$(HFc(B . "0x845E") ; <CJK>
       (?$(HFd(B . "0x8437") ; <CJK>
       (?$(HFe(B . "0x843A") ; <CJK>
       (?$(HFf(B . "0x8434") ; <CJK>
       (?$(HFg(B . "0x847A") ; <CJK>
       (?$(HFh(B . "0x8443") ; <CJK>
       (?$(HFi(B . "0x8478") ; <CJK>
       (?$(HFj(B . "0x8432") ; <CJK>
       (?$(HFk(B . "0x8445") ; <CJK>
       (?$(HFl(B . "0x8429") ; <CJK>
       (?$(HFm(B . "0x83D9") ; <CJK>
       (?$(HFn(B . "0x844B") ; <CJK>
       (?$(HFo(B . "0x842F") ; <CJK>
       (?$(HFp(B . "0x8442") ; <CJK>
       (?$(HFq(B . "0x842D") ; <CJK>
       (?$(HFr(B . "0x845F") ; <CJK>
       (?$(HFs(B . "0x8470") ; <CJK>
       (?$(HFt(B . "0x8439") ; <CJK>
       (?$(HFu(B . "0x844E") ; <CJK>
       (?$(HFv(B . "0x844C") ; <CJK>
       (?$(HFw(B . "0x8452") ; <CJK>
       (?$(HFx(B . "0x846F") ; <CJK>
       (?$(HFy(B . "0x84C5") ; <CJK>
       (?$(HFz(B . "0x848E") ; <CJK>
       (?$(HF{(B . "0x843B") ; <CJK>
       (?$(HF|(B . "0x8447") ; <CJK>
       (?$(HF}(B . "0x8436") ; <CJK>
       (?$(HF~(B . "0x8433") ; <CJK>
       (?$(HG!(B . "0x8468") ; <CJK>
       (?$(HG"(B . "0x847E") ; <CJK>
       (?$(HG#(B . "0x8444") ; <CJK>
       (?$(HG$(B . "0x842B") ; <CJK>
       (?$(HG%(B . "0x8460") ; <CJK>
       (?$(HG&(B . "0x8454") ; <CJK>
       (?$(HG'(B . "0x846E") ; <CJK>
       (?$(HG((B . "0x8450") ; <CJK>
       (?$(HG)(B . "0x870B") ; <CJK>
       (?$(HG*(B . "0x8704") ; <CJK>
       (?$(HG+(B . "0x86F7") ; <CJK>
       (?$(HG,(B . "0x870C") ; <CJK>
       (?$(HG-(B . "0x86FA") ; <CJK>
       (?$(HG.(B . "0x86D6") ; <CJK>
       (?$(HG/(B . "0x86F5") ; <CJK>
       (?$(HG0(B . "0x874D") ; <CJK>
       (?$(HG1(B . "0x86F8") ; <CJK>
       (?$(HG2(B . "0x870E") ; <CJK>
       (?$(HG3(B . "0x8709") ; <CJK>
       (?$(HG4(B . "0x8701") ; <CJK>
       (?$(HG5(B . "0x86F6") ; <CJK>
       (?$(HG6(B . "0x870D") ; <CJK>
       (?$(HG7(B . "0x8705") ; <CJK>
       (?$(HG8(B . "0x88D6") ; <CJK>
       (?$(HG9(B . "0x88CB") ; <CJK>
       (?$(HG:(B . "0x88CD") ; <CJK>
       (?$(HG;(B . "0x88CE") ; <CJK>
       (?$(HG<(B . "0x88DE") ; <CJK>
       (?$(HG=(B . "0x88DB") ; <CJK>
       (?$(HG>(B . "0x88DA") ; <CJK>
       (?$(HG?(B . "0x88CC") ; <CJK>
       (?$(HG@(B . "0x88D0") ; <CJK>
       (?$(HGA(B . "0x8985") ; <CJK>
       (?$(HGB(B . "0x899B") ; <CJK>
       (?$(HGC(B . "0x89DF") ; <CJK>
       (?$(HGD(B . "0x89E5") ; <CJK>
       (?$(HGE(B . "0x89E4") ; <CJK>
       (?$(HGF(B . "0x89E1") ; <CJK>
       (?$(HGG(B . "0x89E0") ; <CJK>
       (?$(HGH(B . "0x89E2") ; <CJK>
       (?$(HGI(B . "0x89DC") ; <CJK>
       (?$(HGJ(B . "0x89E6") ; <CJK>
       (?$(HGK(B . "0x8A76") ; <CJK>
       (?$(HGL(B . "0x8A86") ; <CJK>
       (?$(HGM(B . "0x8A7F") ; <CJK>
       (?$(HGN(B . "0x8A61") ; <CJK>
       (?$(HGO(B . "0x8A3F") ; <CJK>
       (?$(HGP(B . "0x8A77") ; <CJK>
       (?$(HGQ(B . "0x8A82") ; <CJK>
       (?$(HGR(B . "0x8A84") ; <CJK>
       (?$(HGS(B . "0x8A75") ; <CJK>
       (?$(HGT(B . "0x8A83") ; <CJK>
       (?$(HGU(B . "0x8A81") ; <CJK>
       (?$(HGV(B . "0x8A74") ; <CJK>
       (?$(HGW(B . "0x8A7A") ; <CJK>
       (?$(HGX(B . "0x8C3C") ; <CJK>
       (?$(HGY(B . "0x8C4B") ; <CJK>
       (?$(HGZ(B . "0x8C4A") ; <CJK>
       (?$(HG[(B . "0x8C65") ; <CJK>
       (?$(HG\(B . "0x8C64") ; <CJK>
       (?$(HG](B . "0x8C66") ; <CJK>
       (?$(HG^(B . "0x8C86") ; <CJK>
       (?$(HG_(B . "0x8C84") ; <CJK>
       (?$(HG`(B . "0x8C85") ; <CJK>
       (?$(HGa(B . "0x8CCC") ; <CJK>
       (?$(HGb(B . "0x8D68") ; <CJK>
       (?$(HGc(B . "0x8D69") ; <CJK>
       (?$(HGd(B . "0x8D91") ; <CJK>
       (?$(HGe(B . "0x8D8C") ; <CJK>
       (?$(HGf(B . "0x8D8E") ; <CJK>
       (?$(HGg(B . "0x8D8F") ; <CJK>
       (?$(HGh(B . "0x8D8D") ; <CJK>
       (?$(HGi(B . "0x8D93") ; <CJK>
       (?$(HGj(B . "0x8D94") ; <CJK>
       (?$(HGk(B . "0x8D90") ; <CJK>
       (?$(HGl(B . "0x8D92") ; <CJK>
       (?$(HGm(B . "0x8DF0") ; <CJK>
       (?$(HGn(B . "0x8DE0") ; <CJK>
       (?$(HGo(B . "0x8DEC") ; <CJK>
       (?$(HGp(B . "0x8DF1") ; <CJK>
       (?$(HGq(B . "0x8DEE") ; <CJK>
       (?$(HGr(B . "0x8DD0") ; <CJK>
       (?$(HGs(B . "0x8DE9") ; <CJK>
       (?$(HGt(B . "0x8DE3") ; <CJK>
       (?$(HGu(B . "0x8DE2") ; <CJK>
       (?$(HGv(B . "0x8DE7") ; <CJK>
       (?$(HGw(B . "0x8DF2") ; <CJK>
       (?$(HGx(B . "0x8DEB") ; <CJK>
       (?$(HGy(B . "0x8DF4") ; <CJK>
       (?$(HGz(B . "0x8F06") ; <CJK>
       (?$(HG{(B . "0x8EFF") ; <CJK>
       (?$(HG|(B . "0x8F01") ; <CJK>
       (?$(HG}(B . "0x8F00") ; <CJK>
       (?$(HG~(B . "0x8F05") ; <CJK>
       (?$(HH!(B . "0x8F07") ; <CJK>
       (?$(HH"(B . "0x8F08") ; <CJK>
       (?$(HH#(B . "0x8F02") ; <CJK>
       (?$(HH$(B . "0x8F0B") ; <CJK>
       (?$(HH%(B . "0x9052") ; <CJK>
       (?$(HH&(B . "0x903F") ; <CJK>
       (?$(HH'(B . "0x9044") ; <CJK>
       (?$(HH((B . "0x9049") ; <CJK>
       (?$(HH)(B . "0x903D") ; <CJK>
       (?$(HH*(B . "0x9110") ; <CJK>
       (?$(HH+(B . "0x910D") ; <CJK>
       (?$(HH,(B . "0x910F") ; <CJK>
       (?$(HH-(B . "0x9111") ; <CJK>
       (?$(HH.(B . "0x9116") ; <CJK>
       (?$(HH/(B . "0x9114") ; <CJK>
       (?$(HH0(B . "0x910B") ; <CJK>
       (?$(HH1(B . "0x910E") ; <CJK>
       (?$(HH2(B . "0x916E") ; <CJK>
       (?$(HH3(B . "0x916F") ; <CJK>
       (?$(HH4(B . "0x9248") ; <CJK>
       (?$(HH5(B . "0x9252") ; <CJK>
       (?$(HH6(B . "0x9230") ; <CJK>
       (?$(HH7(B . "0x923A") ; <CJK>
       (?$(HH8(B . "0x9266") ; <CJK>
       (?$(HH9(B . "0x9233") ; <CJK>
       (?$(HH:(B . "0x9265") ; <CJK>
       (?$(HH;(B . "0x925E") ; <CJK>
       (?$(HH<(B . "0x9283") ; <CJK>
       (?$(HH=(B . "0x922E") ; <CJK>
       (?$(HH>(B . "0x924A") ; <CJK>
       (?$(HH?(B . "0x9246") ; <CJK>
       (?$(HH@(B . "0x926D") ; <CJK>
       (?$(HHA(B . "0x926C") ; <CJK>
       (?$(HHB(B . "0x924F") ; <CJK>
       (?$(HHC(B . "0x9260") ; <CJK>
       (?$(HHD(B . "0x9267") ; <CJK>
       (?$(HHE(B . "0x926F") ; <CJK>
       (?$(HHF(B . "0x9236") ; <CJK>
       (?$(HHG(B . "0x9261") ; <CJK>
       (?$(HHH(B . "0x9270") ; <CJK>
       (?$(HHI(B . "0x9231") ; <CJK>
       (?$(HHJ(B . "0x9254") ; <CJK>
       (?$(HHK(B . "0x9263") ; <CJK>
       (?$(HHL(B . "0x9250") ; <CJK>
       (?$(HHM(B . "0x9272") ; <CJK>
       (?$(HHN(B . "0x924E") ; <CJK>
       (?$(HHO(B . "0x9253") ; <CJK>
       (?$(HHP(B . "0x924C") ; <CJK>
       (?$(HHQ(B . "0x9256") ; <CJK>
       (?$(HHR(B . "0x9232") ; <CJK>
       (?$(HHS(B . "0x959F") ; <CJK>
       (?$(HHT(B . "0x959C") ; <CJK>
       (?$(HHU(B . "0x959E") ; <CJK>
       (?$(HHV(B . "0x959B") ; <CJK>
       (?$(HHW(B . "0x9692") ; <CJK>
       (?$(HHX(B . "0x9693") ; <CJK>
       (?$(HHY(B . "0x9691") ; <CJK>
       (?$(HHZ(B . "0x9697") ; <CJK>
       (?$(HH[(B . "0x96CE") ; <CJK>
       (?$(HH\(B . "0x96FA") ; <CJK>
       (?$(HH](B . "0x96FD") ; <CJK>
       (?$(HH^(B . "0x96F8") ; <CJK>
       (?$(HH_(B . "0x96F5") ; <CJK>
       (?$(HH`(B . "0x9773") ; <CJK>
       (?$(HHa(B . "0x9777") ; <CJK>
       (?$(HHb(B . "0x9778") ; <CJK>
       (?$(HHc(B . "0x9772") ; <CJK>
       (?$(HHd(B . "0x980F") ; <CJK>
       (?$(HHe(B . "0x980D") ; <CJK>
       (?$(HHf(B . "0x980E") ; <CJK>
       (?$(HHg(B . "0x98AC") ; <CJK>
       (?$(HHh(B . "0x98F6") ; <CJK>
       (?$(HHi(B . "0x98F9") ; <CJK>
       (?$(HHj(B . "0x99AF") ; <CJK>
       (?$(HHk(B . "0x99B2") ; <CJK>
       (?$(HHl(B . "0x99B0") ; <CJK>
       (?$(HHm(B . "0x99B5") ; <CJK>
       (?$(HHn(B . "0x9AAD") ; <CJK>
       (?$(HHo(B . "0x9AAB") ; <CJK>
       (?$(HHp(B . "0x9B5B") ; <CJK>
       (?$(HHq(B . "0x9CEA") ; <CJK>
       (?$(HHr(B . "0x9CED") ; <CJK>
       (?$(HHs(B . "0x9CE7") ; <CJK>
       (?$(HHt(B . "0x9E80") ; <CJK>
       (?$(HHu(B . "0x9EFD") ; <CJK>
       (?$(HHv(B . "0x50E6") ; <CJK>
       (?$(HHw(B . "0x50D4") ; <CJK>
       (?$(HHx(B . "0x50D7") ; <CJK>
       (?$(HHy(B . "0x50E8") ; <CJK>
       (?$(HHz(B . "0x50F3") ; <CJK>
       (?$(HH{(B . "0x50DB") ; <CJK>
       (?$(HH|(B . "0x50EA") ; <CJK>
       (?$(HH}(B . "0x50DD") ; <CJK>
       (?$(HH~(B . "0x50E4") ; <CJK>
       (?$(HI!(B . "0x50D3") ; <CJK>
       (?$(HI"(B . "0x50EC") ; <CJK>
       (?$(HI#(B . "0x50F0") ; <CJK>
       (?$(HI$(B . "0x50EF") ; <CJK>
       (?$(HI%(B . "0x50E3") ; <CJK>
       (?$(HI&(B . "0x50E0") ; <CJK>
       (?$(HI'(B . "0x51D8") ; <CJK>
       (?$(HI((B . "0x5280") ; <CJK>
       (?$(HI)(B . "0x5281") ; <CJK>
       (?$(HI*(B . "0x52E9") ; <CJK>
       (?$(HI+(B . "0x52EB") ; <CJK>
       (?$(HI,(B . "0x5330") ; <CJK>
       (?$(HI-(B . "0x53AC") ; <CJK>
       (?$(HI.(B . "0x5627") ; <CJK>
       (?$(HI/(B . "0x5615") ; <CJK>
       (?$(HI0(B . "0x560C") ; <CJK>
       (?$(HI1(B . "0x5612") ; <CJK>
       (?$(HI2(B . "0x55FC") ; <CJK>
       (?$(HI3(B . "0x560F") ; <CJK>
       (?$(HI4(B . "0x561C") ; <CJK>
       (?$(HI5(B . "0x5601") ; <CJK>
       (?$(HI6(B . "0x5613") ; <CJK>
       (?$(HI7(B . "0x5602") ; <CJK>
       (?$(HI8(B . "0x55FA") ; <CJK>
       (?$(HI9(B . "0x561D") ; <CJK>
       (?$(HI:(B . "0x5604") ; <CJK>
       (?$(HI;(B . "0x55FF") ; <CJK>
       (?$(HI<(B . "0x55F9") ; <CJK>
       (?$(HI=(B . "0x5889") ; <CJK>
       (?$(HI>(B . "0x587C") ; <CJK>
       (?$(HI?(B . "0x5890") ; <CJK>
       (?$(HI@(B . "0x5898") ; <CJK>
       (?$(HIA(B . "0x5886") ; <CJK>
       (?$(HIB(B . "0x5881") ; <CJK>
       (?$(HIC(B . "0x587F") ; <CJK>
       (?$(HID(B . "0x5874") ; <CJK>
       (?$(HIE(B . "0x588B") ; <CJK>
       (?$(HIF(B . "0x587A") ; <CJK>
       (?$(HIG(B . "0x5887") ; <CJK>
       (?$(HIH(B . "0x5891") ; <CJK>
       (?$(HII(B . "0x588E") ; <CJK>
       (?$(HIJ(B . "0x5876") ; <CJK>
       (?$(HIK(B . "0x5882") ; <CJK>
       (?$(HIL(B . "0x5888") ; <CJK>
       (?$(HIM(B . "0x587B") ; <CJK>
       (?$(HIN(B . "0x5894") ; <CJK>
       (?$(HIO(B . "0x588F") ; <CJK>
       (?$(HIP(B . "0x58FE") ; <CJK>
       (?$(HIQ(B . "0x596B") ; <CJK>
       (?$(HIR(B . "0x5ADC") ; <CJK>
       (?$(HIS(B . "0x5AEE") ; <CJK>
       (?$(HIT(B . "0x5AE5") ; <CJK>
       (?$(HIU(B . "0x5AD5") ; <CJK>
       (?$(HIV(B . "0x5AEA") ; <CJK>
       (?$(HIW(B . "0x5ADA") ; <CJK>
       (?$(HIX(B . "0x5AED") ; <CJK>
       (?$(HIY(B . "0x5AEB") ; <CJK>
       (?$(HIZ(B . "0x5AF3") ; <CJK>
       (?$(HI[(B . "0x5AE2") ; <CJK>
       (?$(HI\(B . "0x5AE0") ; <CJK>
       (?$(HI](B . "0x5ADB") ; <CJK>
       (?$(HI^(B . "0x5AEC") ; <CJK>
       (?$(HI_(B . "0x5ADE") ; <CJK>
       (?$(HI`(B . "0x5ADD") ; <CJK>
       (?$(HIa(B . "0x5AD9") ; <CJK>
       (?$(HIb(B . "0x5AE8") ; <CJK>
       (?$(HIc(B . "0x5ADF") ; <CJK>
       (?$(HId(B . "0x5B77") ; <CJK>
       (?$(HIe(B . "0x5BE0") ; <CJK>
       (?$(HIf(B . "0x5BE3") ; <CJK>
       (?$(HIg(B . "0x5C63") ; <CJK>
       (?$(HIh(B . "0x5D82") ; <CJK>
       (?$(HIi(B . "0x5D80") ; <CJK>
       (?$(HIj(B . "0x5D7D") ; <CJK>
       (?$(HIk(B . "0x5D86") ; <CJK>
       (?$(HIl(B . "0x5D7A") ; <CJK>
       (?$(HIm(B . "0x5D81") ; <CJK>
       (?$(HIn(B . "0x5D77") ; <CJK>
       (?$(HIo(B . "0x5D8A") ; <CJK>
       (?$(HIp(B . "0x5D89") ; <CJK>
       (?$(HIq(B . "0x5D88") ; <CJK>
       (?$(HIr(B . "0x5D7E") ; <CJK>
       (?$(HIs(B . "0x5D7C") ; <CJK>
       (?$(HIt(B . "0x5D8D") ; <CJK>
       (?$(HIu(B . "0x5D79") ; <CJK>
       (?$(HIv(B . "0x5D7F") ; <CJK>
       (?$(HIw(B . "0x5E58") ; <CJK>
       (?$(HIx(B . "0x5E59") ; <CJK>
       (?$(HIy(B . "0x5E53") ; <CJK>
       (?$(HIz(B . "0x5ED8") ; <CJK>
       (?$(HI{(B . "0x5ED1") ; <CJK>
       (?$(HI|(B . "0x5ED7") ; <CJK>
       (?$(HI}(B . "0x5ECE") ; <CJK>
       (?$(HI~(B . "0x5EDC") ; <CJK>
       (?$(HJ!(B . "0x5ED5") ; <CJK>
       (?$(HJ"(B . "0x5ED9") ; <CJK>
       (?$(HJ#(B . "0x5ED2") ; <CJK>
       (?$(HJ$(B . "0x5ED4") ; <CJK>
       (?$(HJ%(B . "0x5F44") ; <CJK>
       (?$(HJ&(B . "0x5F43") ; <CJK>
       (?$(HJ'(B . "0x5F6F") ; <CJK>
       (?$(HJ((B . "0x5FB6") ; <CJK>
       (?$(HJ)(B . "0x612C") ; <CJK>
       (?$(HJ*(B . "0x6128") ; <CJK>
       (?$(HJ+(B . "0x6141") ; <CJK>
       (?$(HJ,(B . "0x615E") ; <CJK>
       (?$(HJ-(B . "0x6171") ; <CJK>
       (?$(HJ.(B . "0x6173") ; <CJK>
       (?$(HJ/(B . "0x6152") ; <CJK>
       (?$(HJ0(B . "0x6153") ; <CJK>
       (?$(HJ1(B . "0x6172") ; <CJK>
       (?$(HJ2(B . "0x616C") ; <CJK>
       (?$(HJ3(B . "0x6180") ; <CJK>
       (?$(HJ4(B . "0x6174") ; <CJK>
       (?$(HJ5(B . "0x6154") ; <CJK>
       (?$(HJ6(B . "0x617A") ; <CJK>
       (?$(HJ7(B . "0x615B") ; <CJK>
       (?$(HJ8(B . "0x6165") ; <CJK>
       (?$(HJ9(B . "0x613B") ; <CJK>
       (?$(HJ:(B . "0x616A") ; <CJK>
       (?$(HJ;(B . "0x6161") ; <CJK>
       (?$(HJ<(B . "0x6156") ; <CJK>
       (?$(HJ=(B . "0x6229") ; <CJK>
       (?$(HJ>(B . "0x6227") ; <CJK>
       (?$(HJ?(B . "0x622B") ; <CJK>
       (?$(HJ@(B . "0x642B") ; <CJK>
       (?$(HJA(B . "0x644D") ; <CJK>
       (?$(HJB(B . "0x645B") ; <CJK>
       (?$(HJC(B . "0x645D") ; <CJK>
       (?$(HJD(B . "0x6474") ; <CJK>
       (?$(HJE(B . "0x6476") ; <CJK>
       (?$(HJF(B . "0x6472") ; <CJK>
       (?$(HJG(B . "0x6473") ; <CJK>
       (?$(HJH(B . "0x647D") ; <CJK>
       (?$(HJI(B . "0x6475") ; <CJK>
       (?$(HJJ(B . "0x6466") ; <CJK>
       (?$(HJK(B . "0x64A6") ; <CJK>
       (?$(HJL(B . "0x644E") ; <CJK>
       (?$(HJM(B . "0x6482") ; <CJK>
       (?$(HJN(B . "0x645E") ; <CJK>
       (?$(HJO(B . "0x645C") ; <CJK>
       (?$(HJP(B . "0x644B") ; <CJK>
       (?$(HJQ(B . "0x6453") ; <CJK>
       (?$(HJR(B . "0x6460") ; <CJK>
       (?$(HJS(B . "0x6450") ; <CJK>
       (?$(HJT(B . "0x647F") ; <CJK>
       (?$(HJU(B . "0x643F") ; <CJK>
       (?$(HJV(B . "0x646C") ; <CJK>
       (?$(HJW(B . "0x646B") ; <CJK>
       (?$(HJX(B . "0x6459") ; <CJK>
       (?$(HJY(B . "0x6465") ; <CJK>
       (?$(HJZ(B . "0x6477") ; <CJK>
       (?$(HJ[(B . "0x6573") ; <CJK>
       (?$(HJ\(B . "0x65A0") ; <CJK>
       (?$(HJ](B . "0x66A1") ; <CJK>
       (?$(HJ^(B . "0x66A0") ; <CJK>
       (?$(HJ_(B . "0x669F") ; <CJK>
       (?$(HJ`(B . "0x6705") ; <CJK>
       (?$(HJa(B . "0x6704") ; <CJK>
       (?$(HJb(B . "0x6722") ; <CJK>
       (?$(HJc(B . "0x69B1") ; <CJK>
       (?$(HJd(B . "0x69B6") ; <CJK>
       (?$(HJe(B . "0x69C9") ; <CJK>
       (?$(HJf(B . "0x69A0") ; <CJK>
       (?$(HJg(B . "0x69CE") ; <CJK>
       (?$(HJh(B . "0x6996") ; <CJK>
       (?$(HJi(B . "0x69B0") ; <CJK>
       (?$(HJj(B . "0x69AC") ; <CJK>
       (?$(HJk(B . "0x69BC") ; <CJK>
       (?$(HJl(B . "0x6991") ; <CJK>
       (?$(HJm(B . "0x6999") ; <CJK>
       (?$(HJn(B . "0x698E") ; <CJK>
       (?$(HJo(B . "0x69A7") ; <CJK>
       (?$(HJp(B . "0x698D") ; <CJK>
       (?$(HJq(B . "0x69A9") ; <CJK>
       (?$(HJr(B . "0x69BE") ; <CJK>
       (?$(HJs(B . "0x69AF") ; <CJK>
       (?$(HJt(B . "0x69BF") ; <CJK>
       (?$(HJu(B . "0x69C4") ; <CJK>
       (?$(HJv(B . "0x69BD") ; <CJK>
       (?$(HJw(B . "0x69A4") ; <CJK>
       (?$(HJx(B . "0x69D4") ; <CJK>
       (?$(HJy(B . "0x69B9") ; <CJK>
       (?$(HJz(B . "0x69CA") ; <CJK>
       (?$(HJ{(B . "0x699A") ; <CJK>
       (?$(HJ|(B . "0x69CF") ; <CJK>
       (?$(HJ}(B . "0x69B3") ; <CJK>
       (?$(HJ~(B . "0x6993") ; <CJK>
       (?$(HK!(B . "0x69AA") ; <CJK>
       (?$(HK"(B . "0x69A1") ; <CJK>
       (?$(HK#(B . "0x699E") ; <CJK>
       (?$(HK$(B . "0x69D9") ; <CJK>
       (?$(HK%(B . "0x6997") ; <CJK>
       (?$(HK&(B . "0x6990") ; <CJK>
       (?$(HK'(B . "0x69C2") ; <CJK>
       (?$(HK((B . "0x69B5") ; <CJK>
       (?$(HK)(B . "0x69A5") ; <CJK>
       (?$(HK*(B . "0x69C6") ; <CJK>
       (?$(HK+(B . "0x6B4A") ; <CJK>
       (?$(HK,(B . "0x6B4D") ; <CJK>
       (?$(HK-(B . "0x6B4B") ; <CJK>
       (?$(HK.(B . "0x6B9E") ; <CJK>
       (?$(HK/(B . "0x6B9F") ; <CJK>
       (?$(HK0(B . "0x6BA0") ; <CJK>
       (?$(HK1(B . "0x6BC3") ; <CJK>
       (?$(HK2(B . "0x6BC4") ; <CJK>
       (?$(HK3(B . "0x6BFE") ; <CJK>
       (?$(HK4(B . "0x6ECE") ; <CJK>
       (?$(HK5(B . "0x6EF5") ; <CJK>
       (?$(HK6(B . "0x6EF1") ; <CJK>
       (?$(HK7(B . "0x6F03") ; <CJK>
       (?$(HK8(B . "0x6F25") ; <CJK>
       (?$(HK9(B . "0x6EF8") ; <CJK>
       (?$(HK:(B . "0x6F37") ; <CJK>
       (?$(HK;(B . "0x6EFB") ; <CJK>
       (?$(HK<(B . "0x6F2E") ; <CJK>
       (?$(HK=(B . "0x6F09") ; <CJK>
       (?$(HK>(B . "0x6F4E") ; <CJK>
       (?$(HK?(B . "0x6F19") ; <CJK>
       (?$(HK@(B . "0x6F1A") ; <CJK>
       (?$(HKA(B . "0x6F27") ; <CJK>
       (?$(HKB(B . "0x6F18") ; <CJK>
       (?$(HKC(B . "0x6F3B") ; <CJK>
       (?$(HKD(B . "0x6F12") ; <CJK>
       (?$(HKE(B . "0x6EED") ; <CJK>
       (?$(HKF(B . "0x6F0A") ; <CJK>
       (?$(HKG(B . "0x6F36") ; <CJK>
       (?$(HKH(B . "0x6F73") ; <CJK>
       (?$(HKI(B . "0x6EF9") ; <CJK>
       (?$(HKJ(B . "0x6EEE") ; <CJK>
       (?$(HKK(B . "0x6F2D") ; <CJK>
       (?$(HKL(B . "0x6F40") ; <CJK>
       (?$(HKM(B . "0x6F30") ; <CJK>
       (?$(HKN(B . "0x6F3C") ; <CJK>
       (?$(HKO(B . "0x6F35") ; <CJK>
       (?$(HKP(B . "0x6EEB") ; <CJK>
       (?$(HKQ(B . "0x6F07") ; <CJK>
       (?$(HKR(B . "0x6F0E") ; <CJK>
       (?$(HKS(B . "0x6F43") ; <CJK>
       (?$(HKT(B . "0x6F05") ; <CJK>
       (?$(HKU(B . "0x6EFD") ; <CJK>
       (?$(HKV(B . "0x6EF6") ; <CJK>
       (?$(HKW(B . "0x6F39") ; <CJK>
       (?$(HKX(B . "0x6F1C") ; <CJK>
       (?$(HKY(B . "0x6EFC") ; <CJK>
       (?$(HKZ(B . "0x6F3A") ; <CJK>
       (?$(HK[(B . "0x6F1F") ; <CJK>
       (?$(HK\(B . "0x6F0D") ; <CJK>
       (?$(HK](B . "0x6F1E") ; <CJK>
       (?$(HK^(B . "0x6F08") ; <CJK>
       (?$(HK_(B . "0x6F21") ; <CJK>
       (?$(HK`(B . "0x7187") ; <CJK>
       (?$(HKa(B . "0x7190") ; <CJK>
       (?$(HKb(B . "0x7189") ; <CJK>
       (?$(HKc(B . "0x7180") ; <CJK>
       (?$(HKd(B . "0x7185") ; <CJK>
       (?$(HKe(B . "0x7182") ; <CJK>
       (?$(HKf(B . "0x718F") ; <CJK>
       (?$(HKg(B . "0x717B") ; <CJK>
       (?$(HKh(B . "0x7186") ; <CJK>
       (?$(HKi(B . "0x7181") ; <CJK>
       (?$(HKj(B . "0x7197") ; <CJK>
       (?$(HKk(B . "0x7244") ; <CJK>
       (?$(HKl(B . "0x7253") ; <CJK>
       (?$(HKm(B . "0x7297") ; <CJK>
       (?$(HKn(B . "0x7295") ; <CJK>
       (?$(HKo(B . "0x7293") ; <CJK>
       (?$(HKp(B . "0x7343") ; <CJK>
       (?$(HKq(B . "0x734D") ; <CJK>
       (?$(HKr(B . "0x7351") ; <CJK>
       (?$(HKs(B . "0x734C") ; <CJK>
       (?$(HKt(B . "0x7462") ; <CJK>
       (?$(HKu(B . "0x7473") ; <CJK>
       (?$(HKv(B . "0x7471") ; <CJK>
       (?$(HKw(B . "0x7475") ; <CJK>
       (?$(HKx(B . "0x7472") ; <CJK>
       (?$(HKy(B . "0x7467") ; <CJK>
       (?$(HKz(B . "0x746E") ; <CJK>
       (?$(HK{(B . "0x7500") ; <CJK>
       (?$(HK|(B . "0x7502") ; <CJK>
       (?$(HK}(B . "0x7503") ; <CJK>
       (?$(HK~(B . "0x757D") ; <CJK>
       (?$(HL!(B . "0x7590") ; <CJK>
       (?$(HL"(B . "0x7616") ; <CJK>
       (?$(HL#(B . "0x7608") ; <CJK>
       (?$(HL$(B . "0x760C") ; <CJK>
       (?$(HL%(B . "0x7615") ; <CJK>
       (?$(HL&(B . "0x7611") ; <CJK>
       (?$(HL'(B . "0x760A") ; <CJK>
       (?$(HL((B . "0x7614") ; <CJK>
       (?$(HL)(B . "0x76B8") ; <CJK>
       (?$(HL*(B . "0x7781") ; <CJK>
       (?$(HL+(B . "0x777C") ; <CJK>
       (?$(HL,(B . "0x7785") ; <CJK>
       (?$(HL-(B . "0x7782") ; <CJK>
       (?$(HL.(B . "0x776E") ; <CJK>
       (?$(HL/(B . "0x7780") ; <CJK>
       (?$(HL0(B . "0x776F") ; <CJK>
       (?$(HL1(B . "0x777E") ; <CJK>
       (?$(HL2(B . "0x7783") ; <CJK>
       (?$(HL3(B . "0x78B2") ; <CJK>
       (?$(HL4(B . "0x78AA") ; <CJK>
       (?$(HL5(B . "0x78B4") ; <CJK>
       (?$(HL6(B . "0x78AD") ; <CJK>
       (?$(HL7(B . "0x78A8") ; <CJK>
       (?$(HL8(B . "0x787E") ; <CJK>
       (?$(HL9(B . "0x78AB") ; <CJK>
       (?$(HL:(B . "0x789E") ; <CJK>
       (?$(HL;(B . "0x78A5") ; <CJK>
       (?$(HL<(B . "0x78A0") ; <CJK>
       (?$(HL=(B . "0x78AC") ; <CJK>
       (?$(HL>(B . "0x78A2") ; <CJK>
       (?$(HL?(B . "0x78A4") ; <CJK>
       (?$(HL@(B . "0x7998") ; <CJK>
       (?$(HLA(B . "0x798A") ; <CJK>
       (?$(HLB(B . "0x798B") ; <CJK>
       (?$(HLC(B . "0x7996") ; <CJK>
       (?$(HLD(B . "0x7995") ; <CJK>
       (?$(HLE(B . "0x7994") ; <CJK>
       (?$(HLF(B . "0x7993") ; <CJK>
       (?$(HLG(B . "0x7997") ; <CJK>
       (?$(HLH(B . "0x7988") ; <CJK>
       (?$(HLI(B . "0x7992") ; <CJK>
       (?$(HLJ(B . "0x7990") ; <CJK>
       (?$(HLK(B . "0x7A2B") ; <CJK>
       (?$(HLL(B . "0x7A4A") ; <CJK>
       (?$(HLM(B . "0x7A30") ; <CJK>
       (?$(HLN(B . "0x7A2F") ; <CJK>
       (?$(HLO(B . "0x7A28") ; <CJK>
       (?$(HLP(B . "0x7A26") ; <CJK>
       (?$(HLQ(B . "0x7AA8") ; <CJK>
       (?$(HLR(B . "0x7AAB") ; <CJK>
       (?$(HLS(B . "0x7AAC") ; <CJK>
       (?$(HLT(B . "0x7AEE") ; <CJK>
       (?$(HLU(B . "0x7B88") ; <CJK>
       (?$(HLV(B . "0x7B9C") ; <CJK>
       (?$(HLW(B . "0x7B8A") ; <CJK>
       (?$(HLX(B . "0x7B91") ; <CJK>
       (?$(HLY(B . "0x7B90") ; <CJK>
       (?$(HLZ(B . "0x7B96") ; <CJK>
       (?$(HL[(B . "0x7B8D") ; <CJK>
       (?$(HL\(B . "0x7B8C") ; <CJK>
       (?$(HL](B . "0x7B9B") ; <CJK>
       (?$(HL^(B . "0x7B8E") ; <CJK>
       (?$(HL_(B . "0x7B85") ; <CJK>
       (?$(HL`(B . "0x7B98") ; <CJK>
       (?$(HLa(B . "0x5284") ; <CJK>
       (?$(HLb(B . "0x7B99") ; <CJK>
       (?$(HLc(B . "0x7BA4") ; <CJK>
       (?$(HLd(B . "0x7B82") ; <CJK>
       (?$(HLe(B . "0x7CBB") ; <CJK>
       (?$(HLf(B . "0x7CBF") ; <CJK>
       (?$(HLg(B . "0x7CBC") ; <CJK>
       (?$(HLh(B . "0x7CBA") ; <CJK>
       (?$(HLi(B . "0x7DA7") ; <CJK>
       (?$(HLj(B . "0x7DB7") ; <CJK>
       (?$(HLk(B . "0x7DC2") ; <CJK>
       (?$(HLl(B . "0x7DA3") ; <CJK>
       (?$(HLm(B . "0x7DAA") ; <CJK>
       (?$(HLn(B . "0x7DC1") ; <CJK>
       (?$(HLo(B . "0x7DC0") ; <CJK>
       (?$(HLp(B . "0x7DC5") ; <CJK>
       (?$(HLq(B . "0x7D9D") ; <CJK>
       (?$(HLr(B . "0x7DCE") ; <CJK>
       (?$(HLs(B . "0x7DC4") ; <CJK>
       (?$(HLt(B . "0x7DC6") ; <CJK>
       (?$(HLu(B . "0x7DCB") ; <CJK>
       (?$(HLv(B . "0x7DCC") ; <CJK>
       (?$(HLw(B . "0x7DAF") ; <CJK>
       (?$(HLx(B . "0x7DB9") ; <CJK>
       (?$(HLy(B . "0x7D96") ; <CJK>
       (?$(HLz(B . "0x7DBC") ; <CJK>
       (?$(HL{(B . "0x7D9F") ; <CJK>
       (?$(HL|(B . "0x7DA6") ; <CJK>
       (?$(HL}(B . "0x7DAE") ; <CJK>
       (?$(HL~(B . "0x7DA9") ; <CJK>
       (?$(HM!(B . "0x7DA1") ; <CJK>
       (?$(HM"(B . "0x7DC9") ; <CJK>
       (?$(HM#(B . "0x7F73") ; <CJK>
       (?$(HM$(B . "0x7FE2") ; <CJK>
       (?$(HM%(B . "0x7FE3") ; <CJK>
       (?$(HM&(B . "0x7FE5") ; <CJK>
       (?$(HM'(B . "0x7FDE") ; <CJK>
       (?$(HM((B . "0x8024") ; <CJK>
       (?$(HM)(B . "0x805D") ; <CJK>
       (?$(HM*(B . "0x805C") ; <CJK>
       (?$(HM+(B . "0x8189") ; <CJK>
       (?$(HM,(B . "0x8186") ; <CJK>
       (?$(HM-(B . "0x8183") ; <CJK>
       (?$(HM.(B . "0x8187") ; <CJK>
       (?$(HM/(B . "0x818D") ; <CJK>
       (?$(HM0(B . "0x818C") ; <CJK>
       (?$(HM1(B . "0x818B") ; <CJK>
       (?$(HM2(B . "0x8215") ; <CJK>
       (?$(HM3(B . "0x8497") ; <CJK>
       (?$(HM4(B . "0x84A4") ; <CJK>
       (?$(HM5(B . "0x84A1") ; <CJK>
       (?$(HM6(B . "0x849F") ; <CJK>
       (?$(HM7(B . "0x84BA") ; <CJK>
       (?$(HM8(B . "0x84CE") ; <CJK>
       (?$(HM9(B . "0x84C2") ; <CJK>
       (?$(HM:(B . "0x84AC") ; <CJK>
       (?$(HM;(B . "0x84AE") ; <CJK>
       (?$(HM<(B . "0x84AB") ; <CJK>
       (?$(HM=(B . "0x84B9") ; <CJK>
       (?$(HM>(B . "0x84B4") ; <CJK>
       (?$(HM?(B . "0x84C1") ; <CJK>
       (?$(HM@(B . "0x84CD") ; <CJK>
       (?$(HMA(B . "0x84AA") ; <CJK>
       (?$(HMB(B . "0x849A") ; <CJK>
       (?$(HMC(B . "0x84B1") ; <CJK>
       (?$(HMD(B . "0x84D0") ; <CJK>
       (?$(HME(B . "0x849D") ; <CJK>
       (?$(HMF(B . "0x84A7") ; <CJK>
       (?$(HMG(B . "0x84BB") ; <CJK>
       (?$(HMH(B . "0x84A2") ; <CJK>
       (?$(HMI(B . "0x8494") ; <CJK>
       (?$(HMJ(B . "0x84C7") ; <CJK>
       (?$(HMK(B . "0x84CC") ; <CJK>
       (?$(HML(B . "0x849B") ; <CJK>
       (?$(HMM(B . "0x84A9") ; <CJK>
       (?$(HMN(B . "0x84AF") ; <CJK>
       (?$(HMO(B . "0x84A8") ; <CJK>
       (?$(HMP(B . "0x84D6") ; <CJK>
       (?$(HMQ(B . "0x8498") ; <CJK>
       (?$(HMR(B . "0x84B6") ; <CJK>
       (?$(HMS(B . "0x84CF") ; <CJK>
       (?$(HMT(B . "0x84A0") ; <CJK>
       (?$(HMU(B . "0x84D7") ; <CJK>
       (?$(HMV(B . "0x84D4") ; <CJK>
       (?$(HMW(B . "0x84D2") ; <CJK>
       (?$(HMX(B . "0x84DB") ; <CJK>
       (?$(HMY(B . "0x84B0") ; <CJK>
       (?$(HMZ(B . "0x8491") ; <CJK>
       (?$(HM[(B . "0x8661") ; <CJK>
       (?$(HM\(B . "0x8733") ; <CJK>
       (?$(HM](B . "0x8723") ; <CJK>
       (?$(HM^(B . "0x8728") ; <CJK>
       (?$(HM_(B . "0x876B") ; <CJK>
       (?$(HM`(B . "0x8740") ; <CJK>
       (?$(HMa(B . "0x872E") ; <CJK>
       (?$(HMb(B . "0x871E") ; <CJK>
       (?$(HMc(B . "0x8721") ; <CJK>
       (?$(HMd(B . "0x8719") ; <CJK>
       (?$(HMe(B . "0x871B") ; <CJK>
       (?$(HMf(B . "0x8743") ; <CJK>
       (?$(HMg(B . "0x872C") ; <CJK>
       (?$(HMh(B . "0x8741") ; <CJK>
       (?$(HMi(B . "0x873E") ; <CJK>
       (?$(HMj(B . "0x8746") ; <CJK>
       (?$(HMk(B . "0x8720") ; <CJK>
       (?$(HMl(B . "0x8732") ; <CJK>
       (?$(HMm(B . "0x872A") ; <CJK>
       (?$(HMn(B . "0x872D") ; <CJK>
       (?$(HMo(B . "0x873C") ; <CJK>
       (?$(HMp(B . "0x8712") ; <CJK>
       (?$(HMq(B . "0x873A") ; <CJK>
       (?$(HMr(B . "0x8731") ; <CJK>
       (?$(HMs(B . "0x8735") ; <CJK>
       (?$(HMt(B . "0x8742") ; <CJK>
       (?$(HMu(B . "0x8726") ; <CJK>
       (?$(HMv(B . "0x8727") ; <CJK>
       (?$(HMw(B . "0x8738") ; <CJK>
       (?$(HMx(B . "0x8724") ; <CJK>
       (?$(HMy(B . "0x871A") ; <CJK>
       (?$(HMz(B . "0x8730") ; <CJK>
       (?$(HM{(B . "0x8711") ; <CJK>
       (?$(HM|(B . "0x88F7") ; <CJK>
       (?$(HM}(B . "0x88E7") ; <CJK>
       (?$(HM~(B . "0x88F1") ; <CJK>
       (?$(HN!(B . "0x88F2") ; <CJK>
       (?$(HN"(B . "0x88FA") ; <CJK>
       (?$(HN#(B . "0x88FE") ; <CJK>
       (?$(HN$(B . "0x88EE") ; <CJK>
       (?$(HN%(B . "0x88FC") ; <CJK>
       (?$(HN&(B . "0x88F6") ; <CJK>
       (?$(HN'(B . "0x88FB") ; <CJK>
       (?$(HN((B . "0x88F0") ; <CJK>
       (?$(HN)(B . "0x88EC") ; <CJK>
       (?$(HN*(B . "0x88EB") ; <CJK>
       (?$(HN+(B . "0x899D") ; <CJK>
       (?$(HN,(B . "0x89A1") ; <CJK>
       (?$(HN-(B . "0x899F") ; <CJK>
       (?$(HN.(B . "0x899E") ; <CJK>
       (?$(HN/(B . "0x89E9") ; <CJK>
       (?$(HN0(B . "0x89EB") ; <CJK>
       (?$(HN1(B . "0x89E8") ; <CJK>
       (?$(HN2(B . "0x8AAB") ; <CJK>
       (?$(HN3(B . "0x8A99") ; <CJK>
       (?$(HN4(B . "0x8A8B") ; <CJK>
       (?$(HN5(B . "0x8A92") ; <CJK>
       (?$(HN6(B . "0x8A8F") ; <CJK>
       (?$(HN7(B . "0x8A96") ; <CJK>
       (?$(HN8(B . "0x8C3D") ; <CJK>
       (?$(HN9(B . "0x8C68") ; <CJK>
       (?$(HN:(B . "0x8C69") ; <CJK>
       (?$(HN;(B . "0x8CD5") ; <CJK>
       (?$(HN<(B . "0x8CCF") ; <CJK>
       (?$(HN=(B . "0x8CD7") ; <CJK>
       (?$(HN>(B . "0x8D96") ; <CJK>
       (?$(HN?(B . "0x8E09") ; <CJK>
       (?$(HN@(B . "0x8E02") ; <CJK>
       (?$(HNA(B . "0x8DFF") ; <CJK>
       (?$(HNB(B . "0x8E0D") ; <CJK>
       (?$(HNC(B . "0x8DFD") ; <CJK>
       (?$(HND(B . "0x8E0A") ; <CJK>
       (?$(HNE(B . "0x8E03") ; <CJK>
       (?$(HNF(B . "0x8E07") ; <CJK>
       (?$(HNG(B . "0x8E06") ; <CJK>
       (?$(HNH(B . "0x8E05") ; <CJK>
       (?$(HNI(B . "0x8DFE") ; <CJK>
       (?$(HNJ(B . "0x8E00") ; <CJK>
       (?$(HNK(B . "0x8E04") ; <CJK>
       (?$(HNL(B . "0x8F10") ; <CJK>
       (?$(HNM(B . "0x8F11") ; <CJK>
       (?$(HNN(B . "0x8F0E") ; <CJK>
       (?$(HNO(B . "0x8F0D") ; <CJK>
       (?$(HNP(B . "0x9123") ; <CJK>
       (?$(HNQ(B . "0x911C") ; <CJK>
       (?$(HNR(B . "0x9120") ; <CJK>
       (?$(HNS(B . "0x9122") ; <CJK>
       (?$(HNT(B . "0x911F") ; <CJK>
       (?$(HNU(B . "0x911D") ; <CJK>
       (?$(HNV(B . "0x911A") ; <CJK>
       (?$(HNW(B . "0x9124") ; <CJK>
       (?$(HNX(B . "0x9121") ; <CJK>
       (?$(HNY(B . "0x911B") ; <CJK>
       (?$(HNZ(B . "0x917A") ; <CJK>
       (?$(HN[(B . "0x9172") ; <CJK>
       (?$(HN\(B . "0x9179") ; <CJK>
       (?$(HN](B . "0x9173") ; <CJK>
       (?$(HN^(B . "0x92A5") ; <CJK>
       (?$(HN_(B . "0x92A4") ; <CJK>
       (?$(HN`(B . "0x9276") ; <CJK>
       (?$(HNa(B . "0x929B") ; <CJK>
       (?$(HNb(B . "0x927A") ; <CJK>
       (?$(HNc(B . "0x92A0") ; <CJK>
       (?$(HNd(B . "0x9294") ; <CJK>
       (?$(HNe(B . "0x92AA") ; <CJK>
       (?$(HNf(B . "0x928D") ; <CJK>
       (?$(HNg(B . "0x92A6") ; <CJK>
       (?$(HNh(B . "0x929A") ; <CJK>
       (?$(HNi(B . "0x92AB") ; <CJK>
       (?$(HNj(B . "0x9279") ; <CJK>
       (?$(HNk(B . "0x9297") ; <CJK>
       (?$(HNl(B . "0x927F") ; <CJK>
       (?$(HNm(B . "0x92A3") ; <CJK>
       (?$(HNn(B . "0x92EE") ; <CJK>
       (?$(HNo(B . "0x928E") ; <CJK>
       (?$(HNp(B . "0x9282") ; <CJK>
       (?$(HNq(B . "0x9295") ; <CJK>
       (?$(HNr(B . "0x92A2") ; <CJK>
       (?$(HNs(B . "0x927D") ; <CJK>
       (?$(HNt(B . "0x9288") ; <CJK>
       (?$(HNu(B . "0x92A1") ; <CJK>
       (?$(HNv(B . "0x928A") ; <CJK>
       (?$(HNw(B . "0x9286") ; <CJK>
       (?$(HNx(B . "0x928C") ; <CJK>
       (?$(HNy(B . "0x9299") ; <CJK>
       (?$(HNz(B . "0x92A7") ; <CJK>
       (?$(HN{(B . "0x927E") ; <CJK>
       (?$(HN|(B . "0x9287") ; <CJK>
       (?$(HN}(B . "0x92A9") ; <CJK>
       (?$(HN~(B . "0x929D") ; <CJK>
       (?$(HO!(B . "0x928B") ; <CJK>
       (?$(HO"(B . "0x922D") ; <CJK>
       (?$(HO#(B . "0x969E") ; <CJK>
       (?$(HO$(B . "0x96A1") ; <CJK>
       (?$(HO%(B . "0x96FF") ; <CJK>
       (?$(HO&(B . "0x9758") ; <CJK>
       (?$(HO'(B . "0x977D") ; <CJK>
       (?$(HO((B . "0x977A") ; <CJK>
       (?$(HO)(B . "0x977E") ; <CJK>
       (?$(HO*(B . "0x9783") ; <CJK>
       (?$(HO+(B . "0x9780") ; <CJK>
       (?$(HO,(B . "0x9782") ; <CJK>
       (?$(HO-(B . "0x977B") ; <CJK>
       (?$(HO.(B . "0x9784") ; <CJK>
       (?$(HO/(B . "0x9781") ; <CJK>
       (?$(HO0(B . "0x977F") ; <CJK>
       (?$(HO1(B . "0x97CE") ; <CJK>
       (?$(HO2(B . "0x97CD") ; <CJK>
       (?$(HO3(B . "0x9816") ; <CJK>
       (?$(HO4(B . "0x98AD") ; <CJK>
       (?$(HO5(B . "0x98AE") ; <CJK>
       (?$(HO6(B . "0x9902") ; <CJK>
       (?$(HO7(B . "0x9900") ; <CJK>
       (?$(HO8(B . "0x9907") ; <CJK>
       (?$(HO9(B . "0x999D") ; <CJK>
       (?$(HO:(B . "0x999C") ; <CJK>
       (?$(HO;(B . "0x99C3") ; <CJK>
       (?$(HO<(B . "0x99B9") ; <CJK>
       (?$(HO=(B . "0x99BB") ; <CJK>
       (?$(HO>(B . "0x99BA") ; <CJK>
       (?$(HO?(B . "0x99C2") ; <CJK>
       (?$(HO@(B . "0x99BD") ; <CJK>
       (?$(HOA(B . "0x99C7") ; <CJK>
       (?$(HOB(B . "0x9AB1") ; <CJK>
       (?$(HOC(B . "0x9AE3") ; <CJK>
       (?$(HOD(B . "0x9AE7") ; <CJK>
       (?$(HOE(B . "0x9B3E") ; <CJK>
       (?$(HOF(B . "0x9B3F") ; <CJK>
       (?$(HOG(B . "0x9B60") ; <CJK>
       (?$(HOH(B . "0x9B61") ; <CJK>
       (?$(HOI(B . "0x9B5F") ; <CJK>
       (?$(HOJ(B . "0x9CF1") ; <CJK>
       (?$(HOK(B . "0x9CF2") ; <CJK>
       (?$(HOL(B . "0x9CF5") ; <CJK>
       (?$(HOM(B . "0x9EA7") ; <CJK>
       (?$(HON(B . "0x50FF") ; <CJK>
       (?$(HOO(B . "0x5103") ; <CJK>
       (?$(HOP(B . "0x5130") ; <CJK>
       (?$(HOQ(B . "0x50F8") ; <CJK>
       (?$(HOR(B . "0x5106") ; <CJK>
       (?$(HOS(B . "0x5107") ; <CJK>
       (?$(HOT(B . "0x50F6") ; <CJK>
       (?$(HOU(B . "0x50FE") ; <CJK>
       (?$(HOV(B . "0x510B") ; <CJK>
       (?$(HOW(B . "0x510C") ; <CJK>
       (?$(HOX(B . "0x50FD") ; <CJK>
       (?$(HOY(B . "0x510A") ; <CJK>
       (?$(HOZ(B . "0x528B") ; <CJK>
       (?$(HO[(B . "0x528C") ; <CJK>
       (?$(HO\(B . "0x52F1") ; <CJK>
       (?$(HO](B . "0x52EF") ; <CJK>
       (?$(HO^(B . "0x5648") ; <CJK>
       (?$(HO_(B . "0x5642") ; <CJK>
       (?$(HO`(B . "0x564C") ; <CJK>
       (?$(HOa(B . "0x5635") ; <CJK>
       (?$(HOb(B . "0x5641") ; <CJK>
       (?$(HOc(B . "0x564A") ; <CJK>
       (?$(HOd(B . "0x5649") ; <CJK>
       (?$(HOe(B . "0x5646") ; <CJK>
       (?$(HOf(B . "0x5658") ; <CJK>
       (?$(HOg(B . "0x565A") ; <CJK>
       (?$(HOh(B . "0x5640") ; <CJK>
       (?$(HOi(B . "0x5633") ; <CJK>
       (?$(HOj(B . "0x563D") ; <CJK>
       (?$(HOk(B . "0x562C") ; <CJK>
       (?$(HOl(B . "0x563E") ; <CJK>
       (?$(HOm(B . "0x5638") ; <CJK>
       (?$(HOn(B . "0x562A") ; <CJK>
       (?$(HOo(B . "0x563A") ; <CJK>
       (?$(HOp(B . "0x571A") ; <CJK>
       (?$(HOq(B . "0x58AB") ; <CJK>
       (?$(HOr(B . "0x589D") ; <CJK>
       (?$(HOs(B . "0x58B1") ; <CJK>
       (?$(HOt(B . "0x58A0") ; <CJK>
       (?$(HOu(B . "0x58A3") ; <CJK>
       (?$(HOv(B . "0x58AF") ; <CJK>
       (?$(HOw(B . "0x58AC") ; <CJK>
       (?$(HOx(B . "0x58A5") ; <CJK>
       (?$(HOy(B . "0x58A1") ; <CJK>
       (?$(HOz(B . "0x58FF") ; <CJK>
       (?$(HO{(B . "0x5AFF") ; <CJK>
       (?$(HO|(B . "0x5AF4") ; <CJK>
       (?$(HO}(B . "0x5AFD") ; <CJK>
       (?$(HO~(B . "0x5AF7") ; <CJK>
       (?$(HP!(B . "0x5AF6") ; <CJK>
       (?$(HP"(B . "0x5B03") ; <CJK>
       (?$(HP#(B . "0x5AF8") ; <CJK>
       (?$(HP$(B . "0x5B02") ; <CJK>
       (?$(HP%(B . "0x5AF9") ; <CJK>
       (?$(HP&(B . "0x5B01") ; <CJK>
       (?$(HP'(B . "0x5B07") ; <CJK>
       (?$(HP((B . "0x5B05") ; <CJK>
       (?$(HP)(B . "0x5B0F") ; <CJK>
       (?$(HP*(B . "0x5C67") ; <CJK>
       (?$(HP+(B . "0x5D99") ; <CJK>
       (?$(HP,(B . "0x5D97") ; <CJK>
       (?$(HP-(B . "0x5D9F") ; <CJK>
       (?$(HP.(B . "0x5D92") ; <CJK>
       (?$(HP/(B . "0x5DA2") ; <CJK>
       (?$(HP0(B . "0x5D93") ; <CJK>
       (?$(HP1(B . "0x5D95") ; <CJK>
       (?$(HP2(B . "0x5DA0") ; <CJK>
       (?$(HP3(B . "0x5D9C") ; <CJK>
       (?$(HP4(B . "0x5DA1") ; <CJK>
       (?$(HP5(B . "0x5D9A") ; <CJK>
       (?$(HP6(B . "0x5D9E") ; <CJK>
       (?$(HP7(B . "0x5E69") ; <CJK>
       (?$(HP8(B . "0x5E5D") ; <CJK>
       (?$(HP9(B . "0x5E60") ; <CJK>
       (?$(HP:(B . "0x5E5C") ; <CJK>
       (?$(HP;(B . "0x7DF3") ; <CJK>
       (?$(HP<(B . "0x5EDB") ; <CJK>
       (?$(HP=(B . "0x5EDE") ; <CJK>
       (?$(HP>(B . "0x5EE1") ; <CJK>
       (?$(HP?(B . "0x5F49") ; <CJK>
       (?$(HP@(B . "0x5FB2") ; <CJK>
       (?$(HPA(B . "0x618B") ; <CJK>
       (?$(HPB(B . "0x6183") ; <CJK>
       (?$(HPC(B . "0x6179") ; <CJK>
       (?$(HPD(B . "0x61B1") ; <CJK>
       (?$(HPE(B . "0x61B0") ; <CJK>
       (?$(HPF(B . "0x61A2") ; <CJK>
       (?$(HPG(B . "0x6189") ; <CJK>
       (?$(HPH(B . "0x619B") ; <CJK>
       (?$(HPI(B . "0x6193") ; <CJK>
       (?$(HPJ(B . "0x61AF") ; <CJK>
       (?$(HPK(B . "0x61AD") ; <CJK>
       (?$(HPL(B . "0x619F") ; <CJK>
       (?$(HPM(B . "0x6192") ; <CJK>
       (?$(HPN(B . "0x61AA") ; <CJK>
       (?$(HPO(B . "0x61A1") ; <CJK>
       (?$(HPP(B . "0x618D") ; <CJK>
       (?$(HPQ(B . "0x6166") ; <CJK>
       (?$(HPR(B . "0x61B3") ; <CJK>
       (?$(HPS(B . "0x622D") ; <CJK>
       (?$(HPT(B . "0x646E") ; <CJK>
       (?$(HPU(B . "0x6470") ; <CJK>
       (?$(HPV(B . "0x6496") ; <CJK>
       (?$(HPW(B . "0x64A0") ; <CJK>
       (?$(HPX(B . "0x6485") ; <CJK>
       (?$(HPY(B . "0x6497") ; <CJK>
       (?$(HPZ(B . "0x649C") ; <CJK>
       (?$(HP[(B . "0x648F") ; <CJK>
       (?$(HP\(B . "0x648B") ; <CJK>
       (?$(HP](B . "0x648A") ; <CJK>
       (?$(HP^(B . "0x648C") ; <CJK>
       (?$(HP_(B . "0x64A3") ; <CJK>
       (?$(HP`(B . "0x649F") ; <CJK>
       (?$(HPa(B . "0x6468") ; <CJK>
       (?$(HPb(B . "0x64B1") ; <CJK>
       (?$(HPc(B . "0x6498") ; <CJK>
       (?$(HPd(B . "0x6576") ; <CJK>
       (?$(HPe(B . "0x657A") ; <CJK>
       (?$(HPf(B . "0x6579") ; <CJK>
       (?$(HPg(B . "0x657B") ; <CJK>
       (?$(HPh(B . "0x65B2") ; <CJK>
       (?$(HPi(B . "0x65B3") ; <CJK>
       (?$(HPj(B . "0x66B5") ; <CJK>
       (?$(HPk(B . "0x66B0") ; <CJK>
       (?$(HPl(B . "0x66A9") ; <CJK>
       (?$(HPm(B . "0x66B2") ; <CJK>
       (?$(HPn(B . "0x66B7") ; <CJK>
       (?$(HPo(B . "0x66AA") ; <CJK>
       (?$(HPp(B . "0x66AF") ; <CJK>
       (?$(HPq(B . "0x6A00") ; <CJK>
       (?$(HPr(B . "0x6A06") ; <CJK>
       (?$(HPs(B . "0x6A17") ; <CJK>
       (?$(HPt(B . "0x69E5") ; <CJK>
       (?$(HPu(B . "0x69F8") ; <CJK>
       (?$(HPv(B . "0x6A15") ; <CJK>
       (?$(HPw(B . "0x69F1") ; <CJK>
       (?$(HPx(B . "0x69E4") ; <CJK>
       (?$(HPy(B . "0x6A20") ; <CJK>
       (?$(HPz(B . "0x69FF") ; <CJK>
       (?$(HP{(B . "0x69EC") ; <CJK>
       (?$(HP|(B . "0x69E2") ; <CJK>
       (?$(HP}(B . "0x6A1B") ; <CJK>
       (?$(HP~(B . "0x6A1D") ; <CJK>
       (?$(HQ!(B . "0x69FE") ; <CJK>
       (?$(HQ"(B . "0x6A27") ; <CJK>
       (?$(HQ#(B . "0x69F2") ; <CJK>
       (?$(HQ$(B . "0x69EE") ; <CJK>
       (?$(HQ%(B . "0x6A14") ; <CJK>
       (?$(HQ&(B . "0x69F7") ; <CJK>
       (?$(HQ'(B . "0x69E7") ; <CJK>
       (?$(HQ((B . "0x6A40") ; <CJK>
       (?$(HQ)(B . "0x6A08") ; <CJK>
       (?$(HQ*(B . "0x69E6") ; <CJK>
       (?$(HQ+(B . "0x69FB") ; <CJK>
       (?$(HQ,(B . "0x6A0D") ; <CJK>
       (?$(HQ-(B . "0x69FC") ; <CJK>
       (?$(HQ.(B . "0x69EB") ; <CJK>
       (?$(HQ/(B . "0x6A09") ; <CJK>
       (?$(HQ0(B . "0x6A04") ; <CJK>
       (?$(HQ1(B . "0x6A18") ; <CJK>
       (?$(HQ2(B . "0x6A25") ; <CJK>
       (?$(HQ3(B . "0x6A0F") ; <CJK>
       (?$(HQ4(B . "0x69F6") ; <CJK>
       (?$(HQ5(B . "0x6A26") ; <CJK>
       (?$(HQ6(B . "0x6A07") ; <CJK>
       (?$(HQ7(B . "0x69F4") ; <CJK>
       (?$(HQ8(B . "0x6A16") ; <CJK>
       (?$(HQ9(B . "0x6B51") ; <CJK>
       (?$(HQ:(B . "0x6BA5") ; <CJK>
       (?$(HQ;(B . "0x6BA3") ; <CJK>
       (?$(HQ<(B . "0x6BA2") ; <CJK>
       (?$(HQ=(B . "0x6BA6") ; <CJK>
       (?$(HQ>(B . "0x6C01") ; <CJK>
       (?$(HQ?(B . "0x6C00") ; <CJK>
       (?$(HQ@(B . "0x6BFF") ; <CJK>
       (?$(HQA(B . "0x6C02") ; <CJK>
       (?$(HQB(B . "0x6F41") ; <CJK>
       (?$(HQC(B . "0x6F26") ; <CJK>
       (?$(HQD(B . "0x6F7E") ; <CJK>
       (?$(HQE(B . "0x6F87") ; <CJK>
       (?$(HQF(B . "0x6FC6") ; <CJK>
       (?$(HQG(B . "0x6F92") ; <CJK>
       (?$(HQH(B . "0x6F8D") ; <CJK>
       (?$(HQI(B . "0x6F89") ; <CJK>
       (?$(HQJ(B . "0x6F8C") ; <CJK>
       (?$(HQK(B . "0x6F62") ; <CJK>
       (?$(HQL(B . "0x6F4F") ; <CJK>
       (?$(HQM(B . "0x6F85") ; <CJK>
       (?$(HQN(B . "0x6F5A") ; <CJK>
       (?$(HQO(B . "0x6F96") ; <CJK>
       (?$(HQP(B . "0x6F76") ; <CJK>
       (?$(HQQ(B . "0x6F6C") ; <CJK>
       (?$(HQR(B . "0x6F82") ; <CJK>
       (?$(HQS(B . "0x6F55") ; <CJK>
       (?$(HQT(B . "0x6F72") ; <CJK>
       (?$(HQU(B . "0x6F52") ; <CJK>
       (?$(HQV(B . "0x6F50") ; <CJK>
       (?$(HQW(B . "0x6F57") ; <CJK>
       (?$(HQX(B . "0x6F94") ; <CJK>
       (?$(HQY(B . "0x6F93") ; <CJK>
       (?$(HQZ(B . "0x6F5D") ; <CJK>
       (?$(HQ[(B . "0x6F00") ; <CJK>
       (?$(HQ\(B . "0x6F61") ; <CJK>
       (?$(HQ](B . "0x6F6B") ; <CJK>
       (?$(HQ^(B . "0x6F7D") ; <CJK>
       (?$(HQ_(B . "0x6F67") ; <CJK>
       (?$(HQ`(B . "0x6F90") ; <CJK>
       (?$(HQa(B . "0x6F53") ; <CJK>
       (?$(HQb(B . "0x6F8B") ; <CJK>
       (?$(HQc(B . "0x6F69") ; <CJK>
       (?$(HQd(B . "0x6F7F") ; <CJK>
       (?$(HQe(B . "0x6F95") ; <CJK>
       (?$(HQf(B . "0x6F63") ; <CJK>
       (?$(HQg(B . "0x6F77") ; <CJK>
       (?$(HQh(B . "0x6F6A") ; <CJK>
       (?$(HQi(B . "0x6F7B") ; <CJK>
       (?$(HQj(B . "0x71B2") ; <CJK>
       (?$(HQk(B . "0x71AF") ; <CJK>
       (?$(HQl(B . "0x719B") ; <CJK>
       (?$(HQm(B . "0x71B0") ; <CJK>
       (?$(HQn(B . "0x71A0") ; <CJK>
       (?$(HQo(B . "0x719A") ; <CJK>
       (?$(HQp(B . "0x71A9") ; <CJK>
       (?$(HQq(B . "0x71B5") ; <CJK>
       (?$(HQr(B . "0x719D") ; <CJK>
       (?$(HQs(B . "0x71A5") ; <CJK>
       (?$(HQt(B . "0x719E") ; <CJK>
       (?$(HQu(B . "0x71A4") ; <CJK>
       (?$(HQv(B . "0x71A1") ; <CJK>
       (?$(HQw(B . "0x71AA") ; <CJK>
       (?$(HQx(B . "0x719C") ; <CJK>
       (?$(HQy(B . "0x71A7") ; <CJK>
       (?$(HQz(B . "0x71B3") ; <CJK>
       (?$(HQ{(B . "0x7298") ; <CJK>
       (?$(HQ|(B . "0x729A") ; <CJK>
       (?$(HQ}(B . "0x7358") ; <CJK>
       (?$(HQ~(B . "0x7352") ; <CJK>
       (?$(HR!(B . "0x735E") ; <CJK>
       (?$(HR"(B . "0x735F") ; <CJK>
       (?$(HR#(B . "0x7360") ; <CJK>
       (?$(HR$(B . "0x735D") ; <CJK>
       (?$(HR%(B . "0x735B") ; <CJK>
       (?$(HR&(B . "0x7361") ; <CJK>
       (?$(HR'(B . "0x735A") ; <CJK>
       (?$(HR((B . "0x7359") ; <CJK>
       (?$(HR)(B . "0x7362") ; <CJK>
       (?$(HR*(B . "0x7487") ; <CJK>
       (?$(HR+(B . "0x7489") ; <CJK>
       (?$(HR,(B . "0x748A") ; <CJK>
       (?$(HR-(B . "0x7486") ; <CJK>
       (?$(HR.(B . "0x7481") ; <CJK>
       (?$(HR/(B . "0x747D") ; <CJK>
       (?$(HR0(B . "0x7485") ; <CJK>
       (?$(HR1(B . "0x7488") ; <CJK>
       (?$(HR2(B . "0x747C") ; <CJK>
       (?$(HR3(B . "0x7479") ; <CJK>
       (?$(HR4(B . "0x7508") ; <CJK>
       (?$(HR5(B . "0x7507") ; <CJK>
       (?$(HR6(B . "0x757E") ; <CJK>
       (?$(HR7(B . "0x7625") ; <CJK>
       (?$(HR8(B . "0x761E") ; <CJK>
       (?$(HR9(B . "0x7619") ; <CJK>
       (?$(HR:(B . "0x761D") ; <CJK>
       (?$(HR;(B . "0x761C") ; <CJK>
       (?$(HR<(B . "0x7623") ; <CJK>
       (?$(HR=(B . "0x761A") ; <CJK>
       (?$(HR>(B . "0x7628") ; <CJK>
       (?$(HR?(B . "0x761B") ; <CJK>
       (?$(HR@(B . "0x769C") ; <CJK>
       (?$(HRA(B . "0x769D") ; <CJK>
       (?$(HRB(B . "0x769E") ; <CJK>
       (?$(HRC(B . "0x769B") ; <CJK>
       (?$(HRD(B . "0x778D") ; <CJK>
       (?$(HRE(B . "0x778F") ; <CJK>
       (?$(HRF(B . "0x7789") ; <CJK>
       (?$(HRG(B . "0x7788") ; <CJK>
       (?$(HRH(B . "0x78CD") ; <CJK>
       (?$(HRI(B . "0x78BB") ; <CJK>
       (?$(HRJ(B . "0x78CF") ; <CJK>
       (?$(HRK(B . "0x78CC") ; <CJK>
       (?$(HRL(B . "0x78D1") ; <CJK>
       (?$(HRM(B . "0x78CE") ; <CJK>
       (?$(HRN(B . "0x78D4") ; <CJK>
       (?$(HRO(B . "0x78C8") ; <CJK>
       (?$(HRP(B . "0x78C3") ; <CJK>
       (?$(HRQ(B . "0x78C4") ; <CJK>
       (?$(HRR(B . "0x78C9") ; <CJK>
       (?$(HRS(B . "0x799A") ; <CJK>
       (?$(HRT(B . "0x79A1") ; <CJK>
       (?$(HRU(B . "0x79A0") ; <CJK>
       (?$(HRV(B . "0x799C") ; <CJK>
       (?$(HRW(B . "0x79A2") ; <CJK>
       (?$(HRX(B . "0x799B") ; <CJK>
       (?$(HRY(B . "0x6B76") ; <CJK>
       (?$(HRZ(B . "0x7A39") ; <CJK>
       (?$(HR[(B . "0x7AB2") ; <CJK>
       (?$(HR\(B . "0x7AB4") ; <CJK>
       (?$(HR](B . "0x7AB3") ; <CJK>
       (?$(HR^(B . "0x7BB7") ; <CJK>
       (?$(HR_(B . "0x7BCB") ; <CJK>
       (?$(HR`(B . "0x7BBE") ; <CJK>
       (?$(HRa(B . "0x7BAC") ; <CJK>
       (?$(HRb(B . "0x7BCE") ; <CJK>
       (?$(HRc(B . "0x7BAF") ; <CJK>
       (?$(HRd(B . "0x7BB9") ; <CJK>
       (?$(HRe(B . "0x7BCA") ; <CJK>
       (?$(HRf(B . "0x7BB5") ; <CJK>
       (?$(HRg(B . "0x7CC5") ; <CJK>
       (?$(HRh(B . "0x7CC8") ; <CJK>
       (?$(HRi(B . "0x7CCC") ; <CJK>
       (?$(HRj(B . "0x7CCB") ; <CJK>
       (?$(HRk(B . "0x7DF7") ; <CJK>
       (?$(HRl(B . "0x7DDB") ; <CJK>
       (?$(HRm(B . "0x7DEA") ; <CJK>
       (?$(HRn(B . "0x7DE7") ; <CJK>
       (?$(HRo(B . "0x7DD7") ; <CJK>
       (?$(HRp(B . "0x7DE1") ; <CJK>
       (?$(HRq(B . "0x7E03") ; <CJK>
       (?$(HRr(B . "0x7DFA") ; <CJK>
       (?$(HRs(B . "0x7DE6") ; <CJK>
       (?$(HRt(B . "0x7DF6") ; <CJK>
       (?$(HRu(B . "0x7DF1") ; <CJK>
       (?$(HRv(B . "0x7DF0") ; <CJK>
       (?$(HRw(B . "0x7DEE") ; <CJK>
       (?$(HRx(B . "0x7DDF") ; <CJK>
       (?$(HRy(B . "0x7F76") ; <CJK>
       (?$(HRz(B . "0x7FAC") ; <CJK>
       (?$(HR{(B . "0x7FB0") ; <CJK>
       (?$(HR|(B . "0x7FAD") ; <CJK>
       (?$(HR}(B . "0x7FED") ; <CJK>
       (?$(HR~(B . "0x7FEB") ; <CJK>
       (?$(HS!(B . "0x7FEA") ; <CJK>
       (?$(HS"(B . "0x7FEC") ; <CJK>
       (?$(HS#(B . "0x7FE6") ; <CJK>
       (?$(HS$(B . "0x7FE8") ; <CJK>
       (?$(HS%(B . "0x8064") ; <CJK>
       (?$(HS&(B . "0x8067") ; <CJK>
       (?$(HS'(B . "0x81A3") ; <CJK>
       (?$(HS((B . "0x819F") ; <CJK>
       (?$(HS)(B . "0x819E") ; <CJK>
       (?$(HS*(B . "0x8195") ; <CJK>
       (?$(HS+(B . "0x81A2") ; <CJK>
       (?$(HS,(B . "0x8199") ; <CJK>
       (?$(HS-(B . "0x8197") ; <CJK>
       (?$(HS.(B . "0x8216") ; <CJK>
       (?$(HS/(B . "0x824F") ; <CJK>
       (?$(HS0(B . "0x8253") ; <CJK>
       (?$(HS1(B . "0x8252") ; <CJK>
       (?$(HS2(B . "0x8250") ; <CJK>
       (?$(HS3(B . "0x824E") ; <CJK>
       (?$(HS4(B . "0x8251") ; <CJK>
       (?$(HS5(B . "0x8524") ; <CJK>
       (?$(HS6(B . "0x853B") ; <CJK>
       (?$(HS7(B . "0x850F") ; <CJK>
       (?$(HS8(B . "0x8500") ; <CJK>
       (?$(HS9(B . "0x8529") ; <CJK>
       (?$(HS:(B . "0x850E") ; <CJK>
       (?$(HS;(B . "0x8509") ; <CJK>
       (?$(HS<(B . "0x850D") ; <CJK>
       (?$(HS=(B . "0x851F") ; <CJK>
       (?$(HS>(B . "0x850A") ; <CJK>
       (?$(HS?(B . "0x8527") ; <CJK>
       (?$(HS@(B . "0x851C") ; <CJK>
       (?$(HSA(B . "0x84FB") ; <CJK>
       (?$(HSB(B . "0x852B") ; <CJK>
       (?$(HSC(B . "0x84FA") ; <CJK>
       (?$(HSD(B . "0x8508") ; <CJK>
       (?$(HSE(B . "0x850C") ; <CJK>
       (?$(HSF(B . "0x84F4") ; <CJK>
       (?$(HSG(B . "0x852A") ; <CJK>
       (?$(HSH(B . "0x84F2") ; <CJK>
       (?$(HSI(B . "0x8515") ; <CJK>
       (?$(HSJ(B . "0x84F7") ; <CJK>
       (?$(HSK(B . "0x84EB") ; <CJK>
       (?$(HSL(B . "0x84F3") ; <CJK>
       (?$(HSM(B . "0x84FC") ; <CJK>
       (?$(HSN(B . "0x8512") ; <CJK>
       (?$(HSO(B . "0x84EA") ; <CJK>
       (?$(HSP(B . "0x84E9") ; <CJK>
       (?$(HSQ(B . "0x8516") ; <CJK>
       (?$(HSR(B . "0x84FE") ; <CJK>
       (?$(HSS(B . "0x8528") ; <CJK>
       (?$(HST(B . "0x851D") ; <CJK>
       (?$(HSU(B . "0x852E") ; <CJK>
       (?$(HSV(B . "0x8502") ; <CJK>
       (?$(HSW(B . "0x84FD") ; <CJK>
       (?$(HSX(B . "0x851E") ; <CJK>
       (?$(HSY(B . "0x84F6") ; <CJK>
       (?$(HSZ(B . "0x8531") ; <CJK>
       (?$(HS[(B . "0x8526") ; <CJK>
       (?$(HS\(B . "0x84E7") ; <CJK>
       (?$(HS](B . "0x84E8") ; <CJK>
       (?$(HS^(B . "0x84F0") ; <CJK>
       (?$(HS_(B . "0x84EF") ; <CJK>
       (?$(HS`(B . "0x84F9") ; <CJK>
       (?$(HSa(B . "0x8518") ; <CJK>
       (?$(HSb(B . "0x8520") ; <CJK>
       (?$(HSc(B . "0x8530") ; <CJK>
       (?$(HSd(B . "0x850B") ; <CJK>
       (?$(HSe(B . "0x8519") ; <CJK>
       (?$(HSf(B . "0x852F") ; <CJK>
       (?$(HSg(B . "0x8662") ; <CJK>
       (?$(HSh(B . "0x8756") ; <CJK>
       (?$(HSi(B . "0x8763") ; <CJK>
       (?$(HSj(B . "0x8764") ; <CJK>
       (?$(HSk(B . "0x8777") ; <CJK>
       (?$(HSl(B . "0x87E1") ; <CJK>
       (?$(HSm(B . "0x8773") ; <CJK>
       (?$(HSn(B . "0x8758") ; <CJK>
       (?$(HSo(B . "0x8754") ; <CJK>
       (?$(HSp(B . "0x875B") ; <CJK>
       (?$(HSq(B . "0x8752") ; <CJK>
       (?$(HSr(B . "0x8761") ; <CJK>
       (?$(HSs(B . "0x875A") ; <CJK>
       (?$(HSt(B . "0x8751") ; <CJK>
       (?$(HSu(B . "0x875E") ; <CJK>
       (?$(HSv(B . "0x876D") ; <CJK>
       (?$(HSw(B . "0x876A") ; <CJK>
       (?$(HSx(B . "0x8750") ; <CJK>
       (?$(HSy(B . "0x874E") ; <CJK>
       (?$(HSz(B . "0x875F") ; <CJK>
       (?$(HS{(B . "0x875D") ; <CJK>
       (?$(HS|(B . "0x876F") ; <CJK>
       (?$(HS}(B . "0x876C") ; <CJK>
       (?$(HS~(B . "0x877A") ; <CJK>
       (?$(HT!(B . "0x876E") ; <CJK>
       (?$(HT"(B . "0x875C") ; <CJK>
       (?$(HT#(B . "0x8765") ; <CJK>
       (?$(HT$(B . "0x874F") ; <CJK>
       (?$(HT%(B . "0x877B") ; <CJK>
       (?$(HT&(B . "0x8775") ; <CJK>
       (?$(HT'(B . "0x8762") ; <CJK>
       (?$(HT((B . "0x8767") ; <CJK>
       (?$(HT)(B . "0x8769") ; <CJK>
       (?$(HT*(B . "0x885A") ; <CJK>
       (?$(HT+(B . "0x8905") ; <CJK>
       (?$(HT,(B . "0x890C") ; <CJK>
       (?$(HT-(B . "0x8914") ; <CJK>
       (?$(HT.(B . "0x890B") ; <CJK>
       (?$(HT/(B . "0x8917") ; <CJK>
       (?$(HT0(B . "0x8918") ; <CJK>
       (?$(HT1(B . "0x8919") ; <CJK>
       (?$(HT2(B . "0x8906") ; <CJK>
       (?$(HT3(B . "0x8916") ; <CJK>
       (?$(HT4(B . "0x8911") ; <CJK>
       (?$(HT5(B . "0x890E") ; <CJK>
       (?$(HT6(B . "0x8909") ; <CJK>
       (?$(HT7(B . "0x89A2") ; <CJK>
       (?$(HT8(B . "0x89A4") ; <CJK>
       (?$(HT9(B . "0x89A3") ; <CJK>
       (?$(HT:(B . "0x89ED") ; <CJK>
       (?$(HT;(B . "0x89F0") ; <CJK>
       (?$(HT<(B . "0x89EC") ; <CJK>
       (?$(HT=(B . "0x8ACF") ; <CJK>
       (?$(HT>(B . "0x8AC6") ; <CJK>
       (?$(HT?(B . "0x8AB8") ; <CJK>
       (?$(HT@(B . "0x8AD3") ; <CJK>
       (?$(HTA(B . "0x8AD1") ; <CJK>
       (?$(HTB(B . "0x8AD4") ; <CJK>
       (?$(HTC(B . "0x8AD5") ; <CJK>
       (?$(HTD(B . "0x8ABB") ; <CJK>
       (?$(HTE(B . "0x8AD7") ; <CJK>
       (?$(HTF(B . "0x8ABE") ; <CJK>
       (?$(HTG(B . "0x8AC0") ; <CJK>
       (?$(HTH(B . "0x8AC5") ; <CJK>
       (?$(HTI(B . "0x8AD8") ; <CJK>
       (?$(HTJ(B . "0x8AC3") ; <CJK>
       (?$(HTK(B . "0x8ABA") ; <CJK>
       (?$(HTL(B . "0x8ABD") ; <CJK>
       (?$(HTM(B . "0x8AD9") ; <CJK>
       (?$(HTN(B . "0x8C3E") ; <CJK>
       (?$(HTO(B . "0x8C4D") ; <CJK>
       (?$(HTP(B . "0x8C8F") ; <CJK>
       (?$(HTQ(B . "0x8CE5") ; <CJK>
       (?$(HTR(B . "0x8CDF") ; <CJK>
       (?$(HTS(B . "0x8CD9") ; <CJK>
       (?$(HTT(B . "0x8CE8") ; <CJK>
       (?$(HTU(B . "0x8CDA") ; <CJK>
       (?$(HTV(B . "0x8CDD") ; <CJK>
       (?$(HTW(B . "0x8CE7") ; <CJK>
       (?$(HTX(B . "0x8DA0") ; <CJK>
       (?$(HTY(B . "0x8D9C") ; <CJK>
       (?$(HTZ(B . "0x8DA1") ; <CJK>
       (?$(HT[(B . "0x8D9B") ; <CJK>
       (?$(HT\(B . "0x8E20") ; <CJK>
       (?$(HT](B . "0x8E23") ; <CJK>
       (?$(HT^(B . "0x8E25") ; <CJK>
       (?$(HT_(B . "0x8E24") ; <CJK>
       (?$(HT`(B . "0x8E2E") ; <CJK>
       (?$(HTa(B . "0x8E15") ; <CJK>
       (?$(HTb(B . "0x8E1B") ; <CJK>
       (?$(HTc(B . "0x8E16") ; <CJK>
       (?$(HTd(B . "0x8E11") ; <CJK>
       (?$(HTe(B . "0x8E19") ; <CJK>
       (?$(HTf(B . "0x8E26") ; <CJK>
       (?$(HTg(B . "0x8E27") ; <CJK>
       (?$(HTh(B . "0x8E14") ; <CJK>
       (?$(HTi(B . "0x8E12") ; <CJK>
       (?$(HTj(B . "0x8E18") ; <CJK>
       (?$(HTk(B . "0x8E13") ; <CJK>
       (?$(HTl(B . "0x8E1C") ; <CJK>
       (?$(HTm(B . "0x8E17") ; <CJK>
       (?$(HTn(B . "0x8E1A") ; <CJK>
       (?$(HTo(B . "0x8F2C") ; <CJK>
       (?$(HTp(B . "0x8F24") ; <CJK>
       (?$(HTq(B . "0x8F18") ; <CJK>
       (?$(HTr(B . "0x8F1A") ; <CJK>
       (?$(HTs(B . "0x8F20") ; <CJK>
       (?$(HTt(B . "0x8F23") ; <CJK>
       (?$(HTu(B . "0x8F16") ; <CJK>
       (?$(HTv(B . "0x8F17") ; <CJK>
       (?$(HTw(B . "0x9073") ; <CJK>
       (?$(HTx(B . "0x9070") ; <CJK>
       (?$(HTy(B . "0x906F") ; <CJK>
       (?$(HTz(B . "0x9067") ; <CJK>
       (?$(HT{(B . "0x906B") ; <CJK>
       (?$(HT|(B . "0x912F") ; <CJK>
       (?$(HT}(B . "0x912B") ; <CJK>
       (?$(HT~(B . "0x9129") ; <CJK>
       (?$(HU!(B . "0x912A") ; <CJK>
       (?$(HU"(B . "0x9132") ; <CJK>
       (?$(HU#(B . "0x9126") ; <CJK>
       (?$(HU$(B . "0x912E") ; <CJK>
       (?$(HU%(B . "0x9185") ; <CJK>
       (?$(HU&(B . "0x9186") ; <CJK>
       (?$(HU'(B . "0x918A") ; <CJK>
       (?$(HU((B . "0x9181") ; <CJK>
       (?$(HU)(B . "0x9182") ; <CJK>
       (?$(HU*(B . "0x9184") ; <CJK>
       (?$(HU+(B . "0x9180") ; <CJK>
       (?$(HU,(B . "0x92D0") ; <CJK>
       (?$(HU-(B . "0x92C3") ; <CJK>
       (?$(HU.(B . "0x92C4") ; <CJK>
       (?$(HU/(B . "0x92C0") ; <CJK>
       (?$(HU0(B . "0x92D9") ; <CJK>
       (?$(HU1(B . "0x92B6") ; <CJK>
       (?$(HU2(B . "0x92CF") ; <CJK>
       (?$(HU3(B . "0x92F1") ; <CJK>
       (?$(HU4(B . "0x92DF") ; <CJK>
       (?$(HU5(B . "0x92D8") ; <CJK>
       (?$(HU6(B . "0x92E9") ; <CJK>
       (?$(HU7(B . "0x92D7") ; <CJK>
       (?$(HU8(B . "0x92DD") ; <CJK>
       (?$(HU9(B . "0x92CC") ; <CJK>
       (?$(HU:(B . "0x92EF") ; <CJK>
       (?$(HU;(B . "0x92C2") ; <CJK>
       (?$(HU<(B . "0x92E8") ; <CJK>
       (?$(HU=(B . "0x92CA") ; <CJK>
       (?$(HU>(B . "0x92C8") ; <CJK>
       (?$(HU?(B . "0x92CE") ; <CJK>
       (?$(HU@(B . "0x92E6") ; <CJK>
       (?$(HUA(B . "0x92CD") ; <CJK>
       (?$(HUB(B . "0x92D5") ; <CJK>
       (?$(HUC(B . "0x92C9") ; <CJK>
       (?$(HUD(B . "0x92E0") ; <CJK>
       (?$(HUE(B . "0x92DE") ; <CJK>
       (?$(HUF(B . "0x92E7") ; <CJK>
       (?$(HUG(B . "0x92D1") ; <CJK>
       (?$(HUH(B . "0x92D3") ; <CJK>
       (?$(HUI(B . "0x92B5") ; <CJK>
       (?$(HUJ(B . "0x92E1") ; <CJK>
       (?$(HUK(B . "0x9325") ; <CJK>
       (?$(HUL(B . "0x92C6") ; <CJK>
       (?$(HUM(B . "0x92B4") ; <CJK>
       (?$(HUN(B . "0x957C") ; <CJK>
       (?$(HUO(B . "0x95AC") ; <CJK>
       (?$(HUP(B . "0x95AB") ; <CJK>
       (?$(HUQ(B . "0x95AE") ; <CJK>
       (?$(HUR(B . "0x95B0") ; <CJK>
       (?$(HUS(B . "0x96A4") ; <CJK>
       (?$(HUT(B . "0x96A2") ; <CJK>
       (?$(HUU(B . "0x96D3") ; <CJK>
       (?$(HUV(B . "0x9705") ; <CJK>
       (?$(HUW(B . "0x9708") ; <CJK>
       (?$(HUX(B . "0x9702") ; <CJK>
       (?$(HUY(B . "0x975A") ; <CJK>
       (?$(HUZ(B . "0x978A") ; <CJK>
       (?$(HU[(B . "0x978E") ; <CJK>
       (?$(HU\(B . "0x9788") ; <CJK>
       (?$(HU](B . "0x97D0") ; <CJK>
       (?$(HU^(B . "0x97CF") ; <CJK>
       (?$(HU_(B . "0x981E") ; <CJK>
       (?$(HU`(B . "0x981D") ; <CJK>
       (?$(HUa(B . "0x9826") ; <CJK>
       (?$(HUb(B . "0x9829") ; <CJK>
       (?$(HUc(B . "0x9828") ; <CJK>
       (?$(HUd(B . "0x9820") ; <CJK>
       (?$(HUe(B . "0x981B") ; <CJK>
       (?$(HUf(B . "0x9827") ; <CJK>
       (?$(HUg(B . "0x98B2") ; <CJK>
       (?$(HUh(B . "0x9908") ; <CJK>
       (?$(HUi(B . "0x98FA") ; <CJK>
       (?$(HUj(B . "0x9911") ; <CJK>
       (?$(HUk(B . "0x9914") ; <CJK>
       (?$(HUl(B . "0x9916") ; <CJK>
       (?$(HUm(B . "0x9917") ; <CJK>
       (?$(HUn(B . "0x9915") ; <CJK>
       (?$(HUo(B . "0x99DC") ; <CJK>
       (?$(HUp(B . "0x99CD") ; <CJK>
       (?$(HUq(B . "0x99CF") ; <CJK>
       (?$(HUr(B . "0x99D3") ; <CJK>
       (?$(HUs(B . "0x99D4") ; <CJK>
       (?$(HUt(B . "0x99CE") ; <CJK>
       (?$(HUu(B . "0x99C9") ; <CJK>
       (?$(HUv(B . "0x99D6") ; <CJK>
       (?$(HUw(B . "0x99D8") ; <CJK>
       (?$(HUx(B . "0x99CB") ; <CJK>
       (?$(HUy(B . "0x99D7") ; <CJK>
       (?$(HUz(B . "0x99CC") ; <CJK>
       (?$(HU{(B . "0x9AB3") ; <CJK>
       (?$(HU|(B . "0x9AEC") ; <CJK>
       (?$(HU}(B . "0x9AEB") ; <CJK>
       (?$(HU~(B . "0x9AF3") ; <CJK>
       (?$(HV!(B . "0x9AF2") ; <CJK>
       (?$(HV"(B . "0x9AF1") ; <CJK>
       (?$(HV#(B . "0x9B46") ; <CJK>
       (?$(HV$(B . "0x9B43") ; <CJK>
       (?$(HV%(B . "0x9B67") ; <CJK>
       (?$(HV&(B . "0x9B74") ; <CJK>
       (?$(HV'(B . "0x9B71") ; <CJK>
       (?$(HV((B . "0x9B66") ; <CJK>
       (?$(HV)(B . "0x9B76") ; <CJK>
       (?$(HV*(B . "0x9B75") ; <CJK>
       (?$(HV+(B . "0x9B70") ; <CJK>
       (?$(HV,(B . "0x9B68") ; <CJK>
       (?$(HV-(B . "0x9B64") ; <CJK>
       (?$(HV.(B . "0x9B6C") ; <CJK>
       (?$(HV/(B . "0x9CFC") ; <CJK>
       (?$(HV0(B . "0x9CFA") ; <CJK>
       (?$(HV1(B . "0x9CFD") ; <CJK>
       (?$(HV2(B . "0x9CFF") ; <CJK>
       (?$(HV3(B . "0x9CF7") ; <CJK>
       (?$(HV4(B . "0x9D07") ; <CJK>
       (?$(HV5(B . "0x9D00") ; <CJK>
       (?$(HV6(B . "0x9CF9") ; <CJK>
       (?$(HV7(B . "0x9CFB") ; <CJK>
       (?$(HV8(B . "0x9D08") ; <CJK>
       (?$(HV9(B . "0x9D05") ; <CJK>
       (?$(HV:(B . "0x9D04") ; <CJK>
       (?$(HV;(B . "0x9E83") ; <CJK>
       (?$(HV<(B . "0x9ED3") ; <CJK>
       (?$(HV=(B . "0x9F0F") ; <CJK>
       (?$(HV>(B . "0x9F10") ; <CJK>
       (?$(HV?(B . "0x511C") ; <CJK>
       (?$(HV@(B . "0x5113") ; <CJK>
       (?$(HVA(B . "0x5117") ; <CJK>
       (?$(HVB(B . "0x511A") ; <CJK>
       (?$(HVC(B . "0x5111") ; <CJK>
       (?$(HVD(B . "0x51DE") ; <CJK>
       (?$(HVE(B . "0x5334") ; <CJK>
       (?$(HVF(B . "0x53E1") ; <CJK>
       (?$(HVG(B . "0x5670") ; <CJK>
       (?$(HVH(B . "0x5660") ; <CJK>
       (?$(HVI(B . "0x566E") ; <CJK>
       (?$(HVJ(B . "0x5673") ; <CJK>
       (?$(HVK(B . "0x5666") ; <CJK>
       (?$(HVL(B . "0x5663") ; <CJK>
       (?$(HVM(B . "0x566D") ; <CJK>
       (?$(HVN(B . "0x5672") ; <CJK>
       (?$(HVO(B . "0x565E") ; <CJK>
       (?$(HVP(B . "0x5677") ; <CJK>
       (?$(HVQ(B . "0x571C") ; <CJK>
       (?$(HVR(B . "0x571B") ; <CJK>
       (?$(HVS(B . "0x58C8") ; <CJK>
       (?$(HVT(B . "0x58BD") ; <CJK>
       (?$(HVU(B . "0x58C9") ; <CJK>
       (?$(HVV(B . "0x58BF") ; <CJK>
       (?$(HVW(B . "0x58BA") ; <CJK>
       (?$(HVX(B . "0x58C2") ; <CJK>
       (?$(HVY(B . "0x58BC") ; <CJK>
       (?$(HVZ(B . "0x58C6") ; <CJK>
       (?$(HV[(B . "0x5B17") ; <CJK>
       (?$(HV\(B . "0x5B19") ; <CJK>
       (?$(HV](B . "0x5B1B") ; <CJK>
       (?$(HV^(B . "0x5B21") ; <CJK>
       (?$(HV_(B . "0x5B14") ; <CJK>
       (?$(HV`(B . "0x5B13") ; <CJK>
       (?$(HVa(B . "0x5B10") ; <CJK>
       (?$(HVb(B . "0x5B16") ; <CJK>
       (?$(HVc(B . "0x5B28") ; <CJK>
       (?$(HVd(B . "0x5B1A") ; <CJK>
       (?$(HVe(B . "0x5B20") ; <CJK>
       (?$(HVf(B . "0x5B1E") ; <CJK>
       (?$(HVg(B . "0x5BEF") ; <CJK>
       (?$(HVh(B . "0x5DAC") ; <CJK>
       (?$(HVi(B . "0x5DB1") ; <CJK>
       (?$(HVj(B . "0x5DA9") ; <CJK>
       (?$(HVk(B . "0x5DA7") ; <CJK>
       (?$(HVl(B . "0x5DB5") ; <CJK>
       (?$(HVm(B . "0x5DB0") ; <CJK>
       (?$(HVn(B . "0x5DAE") ; <CJK>
       (?$(HVo(B . "0x5DAA") ; <CJK>
       (?$(HVp(B . "0x5DA8") ; <CJK>
       (?$(HVq(B . "0x5DB2") ; <CJK>
       (?$(HVr(B . "0x5DAD") ; <CJK>
       (?$(HVs(B . "0x5DAF") ; <CJK>
       (?$(HVt(B . "0x5DB4") ; <CJK>
       (?$(HVu(B . "0x5E67") ; <CJK>
       (?$(HVv(B . "0x5E68") ; <CJK>
       (?$(HVw(B . "0x5E66") ; <CJK>
       (?$(HVx(B . "0x5E6F") ; <CJK>
       (?$(HVy(B . "0x5EE9") ; <CJK>
       (?$(HVz(B . "0x5EE7") ; <CJK>
       (?$(HV{(B . "0x5EE6") ; <CJK>
       (?$(HV|(B . "0x5EE8") ; <CJK>
       (?$(HV}(B . "0x5EE5") ; <CJK>
       (?$(HV~(B . "0x5F4B") ; <CJK>
       (?$(HW!(B . "0x5FBC") ; <CJK>
       (?$(HW"(B . "0x5FBB") ; <CJK>
       (?$(HW#(B . "0x619D") ; <CJK>
       (?$(HW$(B . "0x61A8") ; <CJK>
       (?$(HW%(B . "0x6196") ; <CJK>
       (?$(HW&(B . "0x61C5") ; <CJK>
       (?$(HW'(B . "0x61B4") ; <CJK>
       (?$(HW((B . "0x61C6") ; <CJK>
       (?$(HW)(B . "0x61C1") ; <CJK>
       (?$(HW*(B . "0x61CC") ; <CJK>
       (?$(HW+(B . "0x61BA") ; <CJK>
       (?$(HW,(B . "0x61BF") ; <CJK>
       (?$(HW-(B . "0x61B8") ; <CJK>
       (?$(HW.(B . "0x618C") ; <CJK>
       (?$(HW/(B . "0x64D7") ; <CJK>
       (?$(HW0(B . "0x64D6") ; <CJK>
       (?$(HW1(B . "0x64D0") ; <CJK>
       (?$(HW2(B . "0x64CF") ; <CJK>
       (?$(HW3(B . "0x64C9") ; <CJK>
       (?$(HW4(B . "0x64BD") ; <CJK>
       (?$(HW5(B . "0x6489") ; <CJK>
       (?$(HW6(B . "0x64C3") ; <CJK>
       (?$(HW7(B . "0x64DB") ; <CJK>
       (?$(HW8(B . "0x64F3") ; <CJK>
       (?$(HW9(B . "0x64D9") ; <CJK>
       (?$(HW:(B . "0x6533") ; <CJK>
       (?$(HW;(B . "0x657F") ; <CJK>
       (?$(HW<(B . "0x657C") ; <CJK>
       (?$(HW=(B . "0x65A2") ; <CJK>
       (?$(HW>(B . "0x66C8") ; <CJK>
       (?$(HW?(B . "0x66BE") ; <CJK>
       (?$(HW@(B . "0x66C0") ; <CJK>
       (?$(HWA(B . "0x66CA") ; <CJK>
       (?$(HWB(B . "0x66CB") ; <CJK>
       (?$(HWC(B . "0x66CF") ; <CJK>
       (?$(HWD(B . "0x66BD") ; <CJK>
       (?$(HWE(B . "0x66BB") ; <CJK>
       (?$(HWF(B . "0x66BA") ; <CJK>
       (?$(HWG(B . "0x66CC") ; <CJK>
       (?$(HWH(B . "0x6723") ; <CJK>
       (?$(HWI(B . "0x6A34") ; <CJK>
       (?$(HWJ(B . "0x6A66") ; <CJK>
       (?$(HWK(B . "0x6A49") ; <CJK>
       (?$(HWL(B . "0x6A67") ; <CJK>
       (?$(HWM(B . "0x6A32") ; <CJK>
       (?$(HWN(B . "0x6A68") ; <CJK>
       (?$(HWO(B . "0x6A3E") ; <CJK>
       (?$(HWP(B . "0x6A5D") ; <CJK>
       (?$(HWQ(B . "0x6A6D") ; <CJK>
       (?$(HWR(B . "0x6A76") ; <CJK>
       (?$(HWS(B . "0x6A5B") ; <CJK>
       (?$(HWT(B . "0x6A51") ; <CJK>
       (?$(HWU(B . "0x6A28") ; <CJK>
       (?$(HWV(B . "0x6A5A") ; <CJK>
       (?$(HWW(B . "0x6A3B") ; <CJK>
       (?$(HWX(B . "0x6A3F") ; <CJK>
       (?$(HWY(B . "0x6A41") ; <CJK>
       (?$(HWZ(B . "0x6A6A") ; <CJK>
       (?$(HW[(B . "0x6A64") ; <CJK>
       (?$(HW\(B . "0x6A50") ; <CJK>
       (?$(HW](B . "0x6A4F") ; <CJK>
       (?$(HW^(B . "0x6A54") ; <CJK>
       (?$(HW_(B . "0x6A6F") ; <CJK>
       (?$(HW`(B . "0x6A69") ; <CJK>
       (?$(HWa(B . "0x6A60") ; <CJK>
       (?$(HWb(B . "0x6A3C") ; <CJK>
       (?$(HWc(B . "0x6A5E") ; <CJK>
       (?$(HWd(B . "0x6A56") ; <CJK>
       (?$(HWe(B . "0x6A55") ; <CJK>
       (?$(HWf(B . "0x6A4D") ; <CJK>
       (?$(HWg(B . "0x6A4E") ; <CJK>
       (?$(HWh(B . "0x6A46") ; <CJK>
       (?$(HWi(B . "0x6B55") ; <CJK>
       (?$(HWj(B . "0x6B54") ; <CJK>
       (?$(HWk(B . "0x6B56") ; <CJK>
       (?$(HWl(B . "0x6BA7") ; <CJK>
       (?$(HWm(B . "0x6BAA") ; <CJK>
       (?$(HWn(B . "0x6BAB") ; <CJK>
       (?$(HWo(B . "0x6BC8") ; <CJK>
       (?$(HWp(B . "0x6BC7") ; <CJK>
       (?$(HWq(B . "0x6C04") ; <CJK>
       (?$(HWr(B . "0x6C03") ; <CJK>
       (?$(HWs(B . "0x6C06") ; <CJK>
       (?$(HWt(B . "0x6FAD") ; <CJK>
       (?$(HWu(B . "0x6FCB") ; <CJK>
       (?$(HWv(B . "0x6FA3") ; <CJK>
       (?$(HWw(B . "0x6FC7") ; <CJK>
       (?$(HWx(B . "0x6FBC") ; <CJK>
       (?$(HWy(B . "0x6FCE") ; <CJK>
       (?$(HWz(B . "0x6FC8") ; <CJK>
       (?$(HW{(B . "0x6F5E") ; <CJK>
       (?$(HW|(B . "0x6FC4") ; <CJK>
       (?$(HW}(B . "0x6FBD") ; <CJK>
       (?$(HW~(B . "0x6F9E") ; <CJK>
       (?$(HX!(B . "0x6FCA") ; <CJK>
       (?$(HX"(B . "0x6FA8") ; <CJK>
       (?$(HX#(B . "0x7004") ; <CJK>
       (?$(HX$(B . "0x6FA5") ; <CJK>
       (?$(HX%(B . "0x6FAE") ; <CJK>
       (?$(HX&(B . "0x6FBA") ; <CJK>
       (?$(HX'(B . "0x6FAC") ; <CJK>
       (?$(HX((B . "0x6FAA") ; <CJK>
       (?$(HX)(B . "0x6FCF") ; <CJK>
       (?$(HX*(B . "0x6FBF") ; <CJK>
       (?$(HX+(B . "0x6FB8") ; <CJK>
       (?$(HX,(B . "0x6FA2") ; <CJK>
       (?$(HX-(B . "0x6FC9") ; <CJK>
       (?$(HX.(B . "0x6FAB") ; <CJK>
       (?$(HX/(B . "0x6FCD") ; <CJK>
       (?$(HX0(B . "0x6FAF") ; <CJK>
       (?$(HX1(B . "0x6FB2") ; <CJK>
       (?$(HX2(B . "0x6FB0") ; <CJK>
       (?$(HX3(B . "0x71C5") ; <CJK>
       (?$(HX4(B . "0x71C2") ; <CJK>
       (?$(HX5(B . "0x71BF") ; <CJK>
       (?$(HX6(B . "0x71B8") ; <CJK>
       (?$(HX7(B . "0x71D6") ; <CJK>
       (?$(HX8(B . "0x71C0") ; <CJK>
       (?$(HX9(B . "0x71C1") ; <CJK>
       (?$(HX:(B . "0x71CB") ; <CJK>
       (?$(HX;(B . "0x71D4") ; <CJK>
       (?$(HX<(B . "0x71CA") ; <CJK>
       (?$(HX=(B . "0x71C7") ; <CJK>
       (?$(HX>(B . "0x71CF") ; <CJK>
       (?$(HX?(B . "0x71BD") ; <CJK>
       (?$(HX@(B . "0x71D8") ; <CJK>
       (?$(HXA(B . "0x71BC") ; <CJK>
       (?$(HXB(B . "0x71C6") ; <CJK>
       (?$(HXC(B . "0x71DA") ; <CJK>
       (?$(HXD(B . "0x71DB") ; <CJK>
       (?$(HXE(B . "0x729D") ; <CJK>
       (?$(HXF(B . "0x729E") ; <CJK>
       (?$(HXG(B . "0x7369") ; <CJK>
       (?$(HXH(B . "0x7366") ; <CJK>
       (?$(HXI(B . "0x7367") ; <CJK>
       (?$(HXJ(B . "0x736C") ; <CJK>
       (?$(HXK(B . "0x7365") ; <CJK>
       (?$(HXL(B . "0x736B") ; <CJK>
       (?$(HXM(B . "0x736A") ; <CJK>
       (?$(HXN(B . "0x747F") ; <CJK>
       (?$(HXO(B . "0x749A") ; <CJK>
       (?$(HXP(B . "0x74A0") ; <CJK>
       (?$(HXQ(B . "0x7494") ; <CJK>
       (?$(HXR(B . "0x7492") ; <CJK>
       (?$(HXS(B . "0x7495") ; <CJK>
       (?$(HXT(B . "0x74A1") ; <CJK>
       (?$(HXU(B . "0x750B") ; <CJK>
       (?$(HXV(B . "0x7580") ; <CJK>
       (?$(HXW(B . "0x762F") ; <CJK>
       (?$(HXX(B . "0x762D") ; <CJK>
       (?$(HXY(B . "0x7631") ; <CJK>
       (?$(HXZ(B . "0x763D") ; <CJK>
       (?$(HX[(B . "0x7633") ; <CJK>
       (?$(HX\(B . "0x763C") ; <CJK>
       (?$(HX](B . "0x7635") ; <CJK>
       (?$(HX^(B . "0x7632") ; <CJK>
       (?$(HX_(B . "0x7630") ; <CJK>
       (?$(HX`(B . "0x76BB") ; <CJK>
       (?$(HXa(B . "0x76E6") ; <CJK>
       (?$(HXb(B . "0x779A") ; <CJK>
       (?$(HXc(B . "0x779D") ; <CJK>
       (?$(HXd(B . "0x77A1") ; <CJK>
       (?$(HXe(B . "0x779C") ; <CJK>
       (?$(HXf(B . "0x779B") ; <CJK>
       (?$(HXg(B . "0x77A2") ; <CJK>
       (?$(HXh(B . "0x77A3") ; <CJK>
       (?$(HXi(B . "0x7795") ; <CJK>
       (?$(HXj(B . "0x7799") ; <CJK>
       (?$(HXk(B . "0x7797") ; <CJK>
       (?$(HXl(B . "0x78DD") ; <CJK>
       (?$(HXm(B . "0x78E9") ; <CJK>
       (?$(HXn(B . "0x78E5") ; <CJK>
       (?$(HXo(B . "0x78EA") ; <CJK>
       (?$(HXp(B . "0x78DE") ; <CJK>
       (?$(HXq(B . "0x78E3") ; <CJK>
       (?$(HXr(B . "0x78DB") ; <CJK>
       (?$(HXs(B . "0x78E1") ; <CJK>
       (?$(HXt(B . "0x78E2") ; <CJK>
       (?$(HXu(B . "0x78ED") ; <CJK>
       (?$(HXv(B . "0x78DF") ; <CJK>
       (?$(HXw(B . "0x78E0") ; <CJK>
       (?$(HXx(B . "0x79A4") ; <CJK>
       (?$(HXy(B . "0x7A44") ; <CJK>
       (?$(HXz(B . "0x7A48") ; <CJK>
       (?$(HX{(B . "0x7A47") ; <CJK>
       (?$(HX|(B . "0x7AB6") ; <CJK>
       (?$(HX}(B . "0x7AB8") ; <CJK>
       (?$(HX~(B . "0x7AB5") ; <CJK>
       (?$(HY!(B . "0x7AB1") ; <CJK>
       (?$(HY"(B . "0x7AB7") ; <CJK>
       (?$(HY#(B . "0x7BDE") ; <CJK>
       (?$(HY$(B . "0x7BE3") ; <CJK>
       (?$(HY%(B . "0x7BE7") ; <CJK>
       (?$(HY&(B . "0x7BDD") ; <CJK>
       (?$(HY'(B . "0x7BD5") ; <CJK>
       (?$(HY((B . "0x7BE5") ; <CJK>
       (?$(HY)(B . "0x7BDA") ; <CJK>
       (?$(HY*(B . "0x7BE8") ; <CJK>
       (?$(HY+(B . "0x7BF9") ; <CJK>
       (?$(HY,(B . "0x7BD4") ; <CJK>
       (?$(HY-(B . "0x7BEA") ; <CJK>
       (?$(HY.(B . "0x7BE2") ; <CJK>
       (?$(HY/(B . "0x7BDC") ; <CJK>
       (?$(HY0(B . "0x7BEB") ; <CJK>
       (?$(HY1(B . "0x7BD8") ; <CJK>
       (?$(HY2(B . "0x7BDF") ; <CJK>
       (?$(HY3(B . "0x7CD2") ; <CJK>
       (?$(HY4(B . "0x7CD4") ; <CJK>
       (?$(HY5(B . "0x7CD7") ; <CJK>
       (?$(HY6(B . "0x7CD0") ; <CJK>
       (?$(HY7(B . "0x7CD1") ; <CJK>
       (?$(HY8(B . "0x7E12") ; <CJK>
       (?$(HY9(B . "0x7E21") ; <CJK>
       (?$(HY:(B . "0x7E17") ; <CJK>
       (?$(HY;(B . "0x7E0C") ; <CJK>
       (?$(HY<(B . "0x7E1F") ; <CJK>
       (?$(HY=(B . "0x7E20") ; <CJK>
       (?$(HY>(B . "0x7E13") ; <CJK>
       (?$(HY?(B . "0x7E0E") ; <CJK>
       (?$(HY@(B . "0x7E1C") ; <CJK>
       (?$(HYA(B . "0x7E15") ; <CJK>
       (?$(HYB(B . "0x7E1A") ; <CJK>
       (?$(HYC(B . "0x7E22") ; <CJK>
       (?$(HYD(B . "0x7E0B") ; <CJK>
       (?$(HYE(B . "0x7E0F") ; <CJK>
       (?$(HYF(B . "0x7E16") ; <CJK>
       (?$(HYG(B . "0x7E0D") ; <CJK>
       (?$(HYH(B . "0x7E14") ; <CJK>
       (?$(HYI(B . "0x7E25") ; <CJK>
       (?$(HYJ(B . "0x7E24") ; <CJK>
       (?$(HYK(B . "0x7F43") ; <CJK>
       (?$(HYL(B . "0x7F7B") ; <CJK>
       (?$(HYM(B . "0x7F7C") ; <CJK>
       (?$(HYN(B . "0x7F7A") ; <CJK>
       (?$(HYO(B . "0x7FB1") ; <CJK>
       (?$(HYP(B . "0x7FEF") ; <CJK>
       (?$(HYQ(B . "0x802A") ; <CJK>
       (?$(HYR(B . "0x8029") ; <CJK>
       (?$(HYS(B . "0x806C") ; <CJK>
       (?$(HYT(B . "0x81B1") ; <CJK>
       (?$(HYU(B . "0x81A6") ; <CJK>
       (?$(HYV(B . "0x81AE") ; <CJK>
       (?$(HYW(B . "0x81B9") ; <CJK>
       (?$(HYX(B . "0x81B5") ; <CJK>
       (?$(HYY(B . "0x81AB") ; <CJK>
       (?$(HYZ(B . "0x81B0") ; <CJK>
       (?$(HY[(B . "0x81AC") ; <CJK>
       (?$(HY\(B . "0x81B4") ; <CJK>
       (?$(HY](B . "0x81B2") ; <CJK>
       (?$(HY^(B . "0x81B7") ; <CJK>
       (?$(HY_(B . "0x81A7") ; <CJK>
       (?$(HY`(B . "0x81F2") ; <CJK>
       (?$(HYa(B . "0x8255") ; <CJK>
       (?$(HYb(B . "0x8256") ; <CJK>
       (?$(HYc(B . "0x8257") ; <CJK>
       (?$(HYd(B . "0x8556") ; <CJK>
       (?$(HYe(B . "0x8545") ; <CJK>
       (?$(HYf(B . "0x856B") ; <CJK>
       (?$(HYg(B . "0x854D") ; <CJK>
       (?$(HYh(B . "0x8553") ; <CJK>
       (?$(HYi(B . "0x8561") ; <CJK>
       (?$(HYj(B . "0x8558") ; <CJK>
       (?$(HYk(B . "0x8540") ; <CJK>
       (?$(HYl(B . "0x8546") ; <CJK>
       (?$(HYm(B . "0x8564") ; <CJK>
       (?$(HYn(B . "0x8541") ; <CJK>
       (?$(HYo(B . "0x8562") ; <CJK>
       (?$(HYp(B . "0x8544") ; <CJK>
       (?$(HYq(B . "0x8551") ; <CJK>
       (?$(HYr(B . "0x8547") ; <CJK>
       (?$(HYs(B . "0x8563") ; <CJK>
       (?$(HYt(B . "0x853E") ; <CJK>
       (?$(HYu(B . "0x855B") ; <CJK>
       (?$(HYv(B . "0x8571") ; <CJK>
       (?$(HYw(B . "0x854E") ; <CJK>
       (?$(HYx(B . "0x856E") ; <CJK>
       (?$(HYy(B . "0x8575") ; <CJK>
       (?$(HYz(B . "0x8555") ; <CJK>
       (?$(HY{(B . "0x8567") ; <CJK>
       (?$(HY|(B . "0x8560") ; <CJK>
       (?$(HY}(B . "0x858C") ; <CJK>
       (?$(HY~(B . "0x8566") ; <CJK>
       (?$(HZ!(B . "0x855D") ; <CJK>
       (?$(HZ"(B . "0x8554") ; <CJK>
       (?$(HZ#(B . "0x8565") ; <CJK>
       (?$(HZ$(B . "0x856C") ; <CJK>
       (?$(HZ%(B . "0x8663") ; <CJK>
       (?$(HZ&(B . "0x8665") ; <CJK>
       (?$(HZ'(B . "0x8664") ; <CJK>
       (?$(HZ((B . "0x87A4") ; <CJK>
       (?$(HZ)(B . "0x879B") ; <CJK>
       (?$(HZ*(B . "0x878F") ; <CJK>
       (?$(HZ+(B . "0x8797") ; <CJK>
       (?$(HZ,(B . "0x8793") ; <CJK>
       (?$(HZ-(B . "0x8792") ; <CJK>
       (?$(HZ.(B . "0x8788") ; <CJK>
       (?$(HZ/(B . "0x8781") ; <CJK>
       (?$(HZ0(B . "0x8796") ; <CJK>
       (?$(HZ1(B . "0x8798") ; <CJK>
       (?$(HZ2(B . "0x8779") ; <CJK>
       (?$(HZ3(B . "0x8787") ; <CJK>
       (?$(HZ4(B . "0x87A3") ; <CJK>
       (?$(HZ5(B . "0x8785") ; <CJK>
       (?$(HZ6(B . "0x8790") ; <CJK>
       (?$(HZ7(B . "0x8791") ; <CJK>
       (?$(HZ8(B . "0x879D") ; <CJK>
       (?$(HZ9(B . "0x8784") ; <CJK>
       (?$(HZ:(B . "0x8794") ; <CJK>
       (?$(HZ;(B . "0x879C") ; <CJK>
       (?$(HZ<(B . "0x879A") ; <CJK>
       (?$(HZ=(B . "0x8789") ; <CJK>
       (?$(HZ>(B . "0x891E") ; <CJK>
       (?$(HZ?(B . "0x8926") ; <CJK>
       (?$(HZ@(B . "0x8930") ; <CJK>
       (?$(HZA(B . "0x892D") ; <CJK>
       (?$(HZB(B . "0x892E") ; <CJK>
       (?$(HZC(B . "0x8927") ; <CJK>
       (?$(HZD(B . "0x8931") ; <CJK>
       (?$(HZE(B . "0x8922") ; <CJK>
       (?$(HZF(B . "0x8929") ; <CJK>
       (?$(HZG(B . "0x8923") ; <CJK>
       (?$(HZH(B . "0x892F") ; <CJK>
       (?$(HZI(B . "0x892C") ; <CJK>
       (?$(HZJ(B . "0x891F") ; <CJK>
       (?$(HZK(B . "0x89F1") ; <CJK>
       (?$(HZL(B . "0x8AE0") ; <CJK>
       (?$(HZM(B . "0x8AE2") ; <CJK>
       (?$(HZN(B . "0x8AF2") ; <CJK>
       (?$(HZO(B . "0x8AF4") ; <CJK>
       (?$(HZP(B . "0x8AF5") ; <CJK>
       (?$(HZQ(B . "0x8ADD") ; <CJK>
       (?$(HZR(B . "0x8B14") ; <CJK>
       (?$(HZS(B . "0x8AE4") ; <CJK>
       (?$(HZT(B . "0x8ADF") ; <CJK>
       (?$(HZU(B . "0x8AF0") ; <CJK>
       (?$(HZV(B . "0x8AC8") ; <CJK>
       (?$(HZW(B . "0x8ADE") ; <CJK>
       (?$(HZX(B . "0x8AE1") ; <CJK>
       (?$(HZY(B . "0x8AE8") ; <CJK>
       (?$(HZZ(B . "0x8AFF") ; <CJK>
       (?$(HZ[(B . "0x8AEF") ; <CJK>
       (?$(HZ\(B . "0x8AFB") ; <CJK>
       (?$(HZ](B . "0x8C91") ; <CJK>
       (?$(HZ^(B . "0x8C92") ; <CJK>
       (?$(HZ_(B . "0x8C90") ; <CJK>
       (?$(HZ`(B . "0x8CF5") ; <CJK>
       (?$(HZa(B . "0x8CEE") ; <CJK>
       (?$(HZb(B . "0x8CF1") ; <CJK>
       (?$(HZc(B . "0x8CF0") ; <CJK>
       (?$(HZd(B . "0x8CF3") ; <CJK>
       (?$(HZe(B . "0x8D6C") ; <CJK>
       (?$(HZf(B . "0x8D6E") ; <CJK>
       (?$(HZg(B . "0x8DA5") ; <CJK>
       (?$(HZh(B . "0x8DA7") ; <CJK>
       (?$(HZi(B . "0x8E33") ; <CJK>
       (?$(HZj(B . "0x8E3E") ; <CJK>
       (?$(HZk(B . "0x8E38") ; <CJK>
       (?$(HZl(B . "0x8E40") ; <CJK>
       (?$(HZm(B . "0x8E45") ; <CJK>
       (?$(HZn(B . "0x8E36") ; <CJK>
       (?$(HZo(B . "0x8E3C") ; <CJK>
       (?$(HZp(B . "0x8E3D") ; <CJK>
       (?$(HZq(B . "0x8E41") ; <CJK>
       (?$(HZr(B . "0x8E30") ; <CJK>
       (?$(HZs(B . "0x8E3F") ; <CJK>
       (?$(HZt(B . "0x8EBD") ; <CJK>
       (?$(HZu(B . "0x8F36") ; <CJK>
       (?$(HZv(B . "0x8F2E") ; <CJK>
       (?$(HZw(B . "0x8F35") ; <CJK>
       (?$(HZx(B . "0x8F32") ; <CJK>
       (?$(HZy(B . "0x8F39") ; <CJK>
       (?$(HZz(B . "0x8F37") ; <CJK>
       (?$(HZ{(B . "0x8F34") ; <CJK>
       (?$(HZ|(B . "0x9076") ; <CJK>
       (?$(HZ}(B . "0x9079") ; <CJK>
       (?$(HZ~(B . "0x907B") ; <CJK>
       (?$(H[!(B . "0x9086") ; <CJK>
       (?$(H["(B . "0x90FA") ; <CJK>
       (?$(H[#(B . "0x9133") ; <CJK>
       (?$(H[$(B . "0x9135") ; <CJK>
       (?$(H[%(B . "0x9136") ; <CJK>
       (?$(H[&(B . "0x9193") ; <CJK>
       (?$(H['(B . "0x9190") ; <CJK>
       (?$(H[((B . "0x9191") ; <CJK>
       (?$(H[)(B . "0x918D") ; <CJK>
       (?$(H[*(B . "0x918F") ; <CJK>
       (?$(H[+(B . "0x9327") ; <CJK>
       (?$(H[,(B . "0x931E") ; <CJK>
       (?$(H[-(B . "0x9308") ; <CJK>
       (?$(H[.(B . "0x931F") ; <CJK>
       (?$(H[/(B . "0x9306") ; <CJK>
       (?$(H[0(B . "0x930F") ; <CJK>
       (?$(H[1(B . "0x937A") ; <CJK>
       (?$(H[2(B . "0x9338") ; <CJK>
       (?$(H[3(B . "0x933C") ; <CJK>
       (?$(H[4(B . "0x931B") ; <CJK>
       (?$(H[5(B . "0x9323") ; <CJK>
       (?$(H[6(B . "0x9312") ; <CJK>
       (?$(H[7(B . "0x9301") ; <CJK>
       (?$(H[8(B . "0x9346") ; <CJK>
       (?$(H[9(B . "0x932D") ; <CJK>
       (?$(H[:(B . "0x930E") ; <CJK>
       (?$(H[;(B . "0x930D") ; <CJK>
       (?$(H[<(B . "0x92CB") ; <CJK>
       (?$(H[=(B . "0x931D") ; <CJK>
       (?$(H[>(B . "0x92FA") ; <CJK>
       (?$(H[?(B . "0x9313") ; <CJK>
       (?$(H[@(B . "0x92F9") ; <CJK>
       (?$(H[A(B . "0x92F7") ; <CJK>
       (?$(H[B(B . "0x9334") ; <CJK>
       (?$(H[C(B . "0x9302") ; <CJK>
       (?$(H[D(B . "0x9324") ; <CJK>
       (?$(H[E(B . "0x92FF") ; <CJK>
       (?$(H[F(B . "0x9329") ; <CJK>
       (?$(H[G(B . "0x9339") ; <CJK>
       (?$(H[H(B . "0x9335") ; <CJK>
       (?$(H[I(B . "0x932A") ; <CJK>
       (?$(H[J(B . "0x9314") ; <CJK>
       (?$(H[K(B . "0x930C") ; <CJK>
       (?$(H[L(B . "0x930B") ; <CJK>
       (?$(H[M(B . "0x92FE") ; <CJK>
       (?$(H[N(B . "0x9309") ; <CJK>
       (?$(H[O(B . "0x9300") ; <CJK>
       (?$(H[P(B . "0x92FB") ; <CJK>
       (?$(H[Q(B . "0x9316") ; <CJK>
       (?$(H[R(B . "0x95BC") ; <CJK>
       (?$(H[S(B . "0x95CD") ; <CJK>
       (?$(H[T(B . "0x95BE") ; <CJK>
       (?$(H[U(B . "0x95B9") ; <CJK>
       (?$(H[V(B . "0x95BA") ; <CJK>
       (?$(H[W(B . "0x95B6") ; <CJK>
       (?$(H[X(B . "0x95BF") ; <CJK>
       (?$(H[Y(B . "0x95B5") ; <CJK>
       (?$(H[Z(B . "0x95BD") ; <CJK>
       (?$(H[[(B . "0x96A9") ; <CJK>
       (?$(H[\(B . "0x96D4") ; <CJK>
       (?$(H[](B . "0x970B") ; <CJK>
       (?$(H[^(B . "0x9712") ; <CJK>
       (?$(H[_(B . "0x9710") ; <CJK>
       (?$(H[`(B . "0x9799") ; <CJK>
       (?$(H[a(B . "0x9797") ; <CJK>
       (?$(H[b(B . "0x9794") ; <CJK>
       (?$(H[c(B . "0x97F0") ; <CJK>
       (?$(H[d(B . "0x97F8") ; <CJK>
       (?$(H[e(B . "0x9835") ; <CJK>
       (?$(H[f(B . "0x982F") ; <CJK>
       (?$(H[g(B . "0x9832") ; <CJK>
       (?$(H[h(B . "0x9924") ; <CJK>
       (?$(H[i(B . "0x991F") ; <CJK>
       (?$(H[j(B . "0x9927") ; <CJK>
       (?$(H[k(B . "0x9929") ; <CJK>
       (?$(H[l(B . "0x999E") ; <CJK>
       (?$(H[m(B . "0x99EE") ; <CJK>
       (?$(H[n(B . "0x99EC") ; <CJK>
       (?$(H[o(B . "0x99E5") ; <CJK>
       (?$(H[p(B . "0x99E4") ; <CJK>
       (?$(H[q(B . "0x99F0") ; <CJK>
       (?$(H[r(B . "0x99E3") ; <CJK>
       (?$(H[s(B . "0x99EA") ; <CJK>
       (?$(H[t(B . "0x99E9") ; <CJK>
       (?$(H[u(B . "0x99E7") ; <CJK>
       (?$(H[v(B . "0x9AB9") ; <CJK>
       (?$(H[w(B . "0x9ABF") ; <CJK>
       (?$(H[x(B . "0x9AB4") ; <CJK>
       (?$(H[y(B . "0x9ABB") ; <CJK>
       (?$(H[z(B . "0x9AF6") ; <CJK>
       (?$(H[{(B . "0x9AFA") ; <CJK>
       (?$(H[|(B . "0x9AF9") ; <CJK>
       (?$(H[}(B . "0x9AF7") ; <CJK>
       (?$(H[~(B . "0x9B33") ; <CJK>
       (?$(H\!(B . "0x9B80") ; <CJK>
       (?$(H\"(B . "0x9B85") ; <CJK>
       (?$(H\#(B . "0x9B87") ; <CJK>
       (?$(H\$(B . "0x9B7C") ; <CJK>
       (?$(H\%(B . "0x9B7E") ; <CJK>
       (?$(H\&(B . "0x9B7B") ; <CJK>
       (?$(H\'(B . "0x9B82") ; <CJK>
       (?$(H\((B . "0x9B93") ; <CJK>
       (?$(H\)(B . "0x9B92") ; <CJK>
       (?$(H\*(B . "0x9B90") ; <CJK>
       (?$(H\+(B . "0x9B7A") ; <CJK>
       (?$(H\,(B . "0x9B95") ; <CJK>
       (?$(H\-(B . "0x9B7D") ; <CJK>
       (?$(H\.(B . "0x9B88") ; <CJK>
       (?$(H\/(B . "0x9D25") ; <CJK>
       (?$(H\0(B . "0x9D17") ; <CJK>
       (?$(H\1(B . "0x9D20") ; <CJK>
       (?$(H\2(B . "0x9D1E") ; <CJK>
       (?$(H\3(B . "0x9D14") ; <CJK>
       (?$(H\4(B . "0x9D29") ; <CJK>
       (?$(H\5(B . "0x9D1D") ; <CJK>
       (?$(H\6(B . "0x9D18") ; <CJK>
       (?$(H\7(B . "0x9D22") ; <CJK>
       (?$(H\8(B . "0x9D10") ; <CJK>
       (?$(H\9(B . "0x9D19") ; <CJK>
       (?$(H\:(B . "0x9D1F") ; <CJK>
       (?$(H\;(B . "0x9E88") ; <CJK>
       (?$(H\<(B . "0x9E86") ; <CJK>
       (?$(H\=(B . "0x9E87") ; <CJK>
       (?$(H\>(B . "0x9EAE") ; <CJK>
       (?$(H\?(B . "0x9EAD") ; <CJK>
       (?$(H\@(B . "0x9ED5") ; <CJK>
       (?$(H\A(B . "0x9ED6") ; <CJK>
       (?$(H\B(B . "0x9EFA") ; <CJK>
       (?$(H\C(B . "0x9F12") ; <CJK>
       (?$(H\D(B . "0x9F3D") ; <CJK>
       (?$(H\E(B . "0x5126") ; <CJK>
       (?$(H\F(B . "0x5125") ; <CJK>
       (?$(H\G(B . "0x5122") ; <CJK>
       (?$(H\H(B . "0x5124") ; <CJK>
       (?$(H\I(B . "0x5120") ; <CJK>
       (?$(H\J(B . "0x5129") ; <CJK>
       (?$(H\K(B . "0x52F4") ; <CJK>
       (?$(H\L(B . "0x5693") ; <CJK>
       (?$(H\M(B . "0x568C") ; <CJK>
       (?$(H\N(B . "0x568D") ; <CJK>
       (?$(H\O(B . "0x5686") ; <CJK>
       (?$(H\P(B . "0x5684") ; <CJK>
       (?$(H\Q(B . "0x5683") ; <CJK>
       (?$(H\R(B . "0x567E") ; <CJK>
       (?$(H\S(B . "0x5682") ; <CJK>
       (?$(H\T(B . "0x567F") ; <CJK>
       (?$(H\U(B . "0x5681") ; <CJK>
       (?$(H\V(B . "0x58D6") ; <CJK>
       (?$(H\W(B . "0x58D4") ; <CJK>
       (?$(H\X(B . "0x58CF") ; <CJK>
       (?$(H\Y(B . "0x58D2") ; <CJK>
       (?$(H\Z(B . "0x5B2D") ; <CJK>
       (?$(H\[(B . "0x5B25") ; <CJK>
       (?$(H\\(B . "0x5B32") ; <CJK>
       (?$(H\](B . "0x5B23") ; <CJK>
       (?$(H\^(B . "0x5B2C") ; <CJK>
       (?$(H\_(B . "0x5B27") ; <CJK>
       (?$(H\`(B . "0x5B26") ; <CJK>
       (?$(H\a(B . "0x5B2F") ; <CJK>
       (?$(H\b(B . "0x5B2E") ; <CJK>
       (?$(H\c(B . "0x5B7B") ; <CJK>
       (?$(H\d(B . "0x5BF1") ; <CJK>
       (?$(H\e(B . "0x5BF2") ; <CJK>
       (?$(H\f(B . "0x5DB7") ; <CJK>
       (?$(H\g(B . "0x5E6C") ; <CJK>
       (?$(H\h(B . "0x5E6A") ; <CJK>
       (?$(H\i(B . "0x5FBE") ; <CJK>
       (?$(H\j(B . "0x61C3") ; <CJK>
       (?$(H\k(B . "0x61B5") ; <CJK>
       (?$(H\l(B . "0x61BC") ; <CJK>
       (?$(H\m(B . "0x61E7") ; <CJK>
       (?$(H\n(B . "0x61E0") ; <CJK>
       (?$(H\o(B . "0x61E5") ; <CJK>
       (?$(H\p(B . "0x61E4") ; <CJK>
       (?$(H\q(B . "0x61E8") ; <CJK>
       (?$(H\r(B . "0x61DE") ; <CJK>
       (?$(H\s(B . "0x64EF") ; <CJK>
       (?$(H\t(B . "0x64E9") ; <CJK>
       (?$(H\u(B . "0x64E3") ; <CJK>
       (?$(H\v(B . "0x64EB") ; <CJK>
       (?$(H\w(B . "0x64E4") ; <CJK>
       (?$(H\x(B . "0x64E8") ; <CJK>
       (?$(H\y(B . "0x6581") ; <CJK>
       (?$(H\z(B . "0x6580") ; <CJK>
       (?$(H\{(B . "0x65B6") ; <CJK>
       (?$(H\|(B . "0x65DA") ; <CJK>
       (?$(H\}(B . "0x66D2") ; <CJK>
       (?$(H\~(B . "0x6A8D") ; <CJK>
       (?$(H]!(B . "0x6A96") ; <CJK>
       (?$(H]"(B . "0x6A81") ; <CJK>
       (?$(H]#(B . "0x6AA5") ; <CJK>
       (?$(H]$(B . "0x6A89") ; <CJK>
       (?$(H]%(B . "0x6A9F") ; <CJK>
       (?$(H]&(B . "0x6A9B") ; <CJK>
       (?$(H]'(B . "0x6AA1") ; <CJK>
       (?$(H]((B . "0x6A9E") ; <CJK>
       (?$(H])(B . "0x6A87") ; <CJK>
       (?$(H]*(B . "0x6A93") ; <CJK>
       (?$(H]+(B . "0x6A8E") ; <CJK>
       (?$(H],(B . "0x6A95") ; <CJK>
       (?$(H]-(B . "0x6A83") ; <CJK>
       (?$(H].(B . "0x6AA8") ; <CJK>
       (?$(H]/(B . "0x6AA4") ; <CJK>
       (?$(H]0(B . "0x6A91") ; <CJK>
       (?$(H]1(B . "0x6A7F") ; <CJK>
       (?$(H]2(B . "0x6AA6") ; <CJK>
       (?$(H]3(B . "0x6A9A") ; <CJK>
       (?$(H]4(B . "0x6A85") ; <CJK>
       (?$(H]5(B . "0x6A8C") ; <CJK>
       (?$(H]6(B . "0x6A92") ; <CJK>
       (?$(H]7(B . "0x6B5B") ; <CJK>
       (?$(H]8(B . "0x6BAD") ; <CJK>
       (?$(H]9(B . "0x6C09") ; <CJK>
       (?$(H]:(B . "0x6FCC") ; <CJK>
       (?$(H];(B . "0x6FA9") ; <CJK>
       (?$(H]<(B . "0x6FF4") ; <CJK>
       (?$(H]=(B . "0x6FD4") ; <CJK>
       (?$(H]>(B . "0x6FE3") ; <CJK>
       (?$(H]?(B . "0x6FDC") ; <CJK>
       (?$(H]@(B . "0x6FED") ; <CJK>
       (?$(H]A(B . "0x6FE7") ; <CJK>
       (?$(H]B(B . "0x6FE6") ; <CJK>
       (?$(H]C(B . "0x6FDE") ; <CJK>
       (?$(H]D(B . "0x6FF2") ; <CJK>
       (?$(H]E(B . "0x6FDD") ; <CJK>
       (?$(H]F(B . "0x6FE2") ; <CJK>
       (?$(H]G(B . "0x6FE8") ; <CJK>
       (?$(H]H(B . "0x71E1") ; <CJK>
       (?$(H]I(B . "0x71F1") ; <CJK>
       (?$(H]J(B . "0x71E8") ; <CJK>
       (?$(H]K(B . "0x71F2") ; <CJK>
       (?$(H]L(B . "0x71E4") ; <CJK>
       (?$(H]M(B . "0x71F0") ; <CJK>
       (?$(H]N(B . "0x71E2") ; <CJK>
       (?$(H]O(B . "0x7373") ; <CJK>
       (?$(H]P(B . "0x736E") ; <CJK>
       (?$(H]Q(B . "0x736F") ; <CJK>
       (?$(H]R(B . "0x7497") ; <CJK>
       (?$(H]S(B . "0x74B2") ; <CJK>
       (?$(H]T(B . "0x74AB") ; <CJK>
       (?$(H]U(B . "0x7490") ; <CJK>
       (?$(H]V(B . "0x74AA") ; <CJK>
       (?$(H]W(B . "0x74AD") ; <CJK>
       (?$(H]X(B . "0x74B1") ; <CJK>
       (?$(H]Y(B . "0x74A5") ; <CJK>
       (?$(H]Z(B . "0x74AF") ; <CJK>
       (?$(H][(B . "0x7510") ; <CJK>
       (?$(H]\(B . "0x7511") ; <CJK>
       (?$(H]](B . "0x7512") ; <CJK>
       (?$(H]^(B . "0x750F") ; <CJK>
       (?$(H]_(B . "0x7584") ; <CJK>
       (?$(H]`(B . "0x7643") ; <CJK>
       (?$(H]a(B . "0x7648") ; <CJK>
       (?$(H]b(B . "0x7649") ; <CJK>
       (?$(H]c(B . "0x7647") ; <CJK>
       (?$(H]d(B . "0x76A4") ; <CJK>
       (?$(H]e(B . "0x76E9") ; <CJK>
       (?$(H]f(B . "0x77B5") ; <CJK>
       (?$(H]g(B . "0x77AB") ; <CJK>
       (?$(H]h(B . "0x77B2") ; <CJK>
       (?$(H]i(B . "0x77B7") ; <CJK>
       (?$(H]j(B . "0x77B6") ; <CJK>
       (?$(H]k(B . "0x77B4") ; <CJK>
       (?$(H]l(B . "0x77B1") ; <CJK>
       (?$(H]m(B . "0x77A8") ; <CJK>
       (?$(H]n(B . "0x77F0") ; <CJK>
       (?$(H]o(B . "0x78F3") ; <CJK>
       (?$(H]p(B . "0x78FD") ; <CJK>
       (?$(H]q(B . "0x7902") ; <CJK>
       (?$(H]r(B . "0x78FB") ; <CJK>
       (?$(H]s(B . "0x78FC") ; <CJK>
       (?$(H]t(B . "0x78FF") ; <CJK>
       (?$(H]u(B . "0x78F2") ; <CJK>
       (?$(H]v(B . "0x7905") ; <CJK>
       (?$(H]w(B . "0x78F9") ; <CJK>
       (?$(H]x(B . "0x78FE") ; <CJK>
       (?$(H]y(B . "0x7904") ; <CJK>
       (?$(H]z(B . "0x79AB") ; <CJK>
       (?$(H]{(B . "0x79A8") ; <CJK>
       (?$(H]|(B . "0x7A5C") ; <CJK>
       (?$(H]}(B . "0x7A5B") ; <CJK>
       (?$(H]~(B . "0x7A56") ; <CJK>
       (?$(H^!(B . "0x7A58") ; <CJK>
       (?$(H^"(B . "0x7A54") ; <CJK>
       (?$(H^#(B . "0x7A5A") ; <CJK>
       (?$(H^$(B . "0x7ABE") ; <CJK>
       (?$(H^%(B . "0x7AC0") ; <CJK>
       (?$(H^&(B . "0x7AC1") ; <CJK>
       (?$(H^'(B . "0x7C05") ; <CJK>
       (?$(H^((B . "0x7C0F") ; <CJK>
       (?$(H^)(B . "0x7BF2") ; <CJK>
       (?$(H^*(B . "0x7C00") ; <CJK>
       (?$(H^+(B . "0x7BFF") ; <CJK>
       (?$(H^,(B . "0x7BFB") ; <CJK>
       (?$(H^-(B . "0x7C0E") ; <CJK>
       (?$(H^.(B . "0x7BF4") ; <CJK>
       (?$(H^/(B . "0x7C0B") ; <CJK>
       (?$(H^0(B . "0x7BF3") ; <CJK>
       (?$(H^1(B . "0x7C02") ; <CJK>
       (?$(H^2(B . "0x7C09") ; <CJK>
       (?$(H^3(B . "0x7C03") ; <CJK>
       (?$(H^4(B . "0x7C01") ; <CJK>
       (?$(H^5(B . "0x7BF8") ; <CJK>
       (?$(H^6(B . "0x7BFD") ; <CJK>
       (?$(H^7(B . "0x7C06") ; <CJK>
       (?$(H^8(B . "0x7BF0") ; <CJK>
       (?$(H^9(B . "0x7BF1") ; <CJK>
       (?$(H^:(B . "0x7C10") ; <CJK>
       (?$(H^;(B . "0x7C0A") ; <CJK>
       (?$(H^<(B . "0x7CE8") ; <CJK>
       (?$(H^=(B . "0x7E2D") ; <CJK>
       (?$(H^>(B . "0x7E3C") ; <CJK>
       (?$(H^?(B . "0x7E42") ; <CJK>
       (?$(H^@(B . "0x7E33") ; <CJK>
       (?$(H^A(B . "0x9848") ; <CJK>
       (?$(H^B(B . "0x7E38") ; <CJK>
       (?$(H^C(B . "0x7E2A") ; <CJK>
       (?$(H^D(B . "0x7E49") ; <CJK>
       (?$(H^E(B . "0x7E40") ; <CJK>
       (?$(H^F(B . "0x7E47") ; <CJK>
       (?$(H^G(B . "0x7E29") ; <CJK>
       (?$(H^H(B . "0x7E4C") ; <CJK>
       (?$(H^I(B . "0x7E30") ; <CJK>
       (?$(H^J(B . "0x7E3B") ; <CJK>
       (?$(H^K(B . "0x7E36") ; <CJK>
       (?$(H^L(B . "0x7E44") ; <CJK>
       (?$(H^M(B . "0x7E3A") ; <CJK>
       (?$(H^N(B . "0x7F45") ; <CJK>
       (?$(H^O(B . "0x7F7F") ; <CJK>
       (?$(H^P(B . "0x7F7E") ; <CJK>
       (?$(H^Q(B . "0x7F7D") ; <CJK>
       (?$(H^R(B . "0x7FF4") ; <CJK>
       (?$(H^S(B . "0x7FF2") ; <CJK>
       (?$(H^T(B . "0x802C") ; <CJK>
       (?$(H^U(B . "0x81BB") ; <CJK>
       (?$(H^V(B . "0x81C4") ; <CJK>
       (?$(H^W(B . "0x81CC") ; <CJK>
       (?$(H^X(B . "0x81CA") ; <CJK>
       (?$(H^Y(B . "0x81C5") ; <CJK>
       (?$(H^Z(B . "0x81C7") ; <CJK>
       (?$(H^[(B . "0x81BC") ; <CJK>
       (?$(H^\(B . "0x81E9") ; <CJK>
       (?$(H^](B . "0x825B") ; <CJK>
       (?$(H^^(B . "0x825A") ; <CJK>
       (?$(H^_(B . "0x825C") ; <CJK>
       (?$(H^`(B . "0x8583") ; <CJK>
       (?$(H^a(B . "0x8580") ; <CJK>
       (?$(H^b(B . "0x858F") ; <CJK>
       (?$(H^c(B . "0x85A7") ; <CJK>
       (?$(H^d(B . "0x8595") ; <CJK>
       (?$(H^e(B . "0x85A0") ; <CJK>
       (?$(H^f(B . "0x858B") ; <CJK>
       (?$(H^g(B . "0x85A3") ; <CJK>
       (?$(H^h(B . "0x857B") ; <CJK>
       (?$(H^i(B . "0x85A4") ; <CJK>
       (?$(H^j(B . "0x859A") ; <CJK>
       (?$(H^k(B . "0x859E") ; <CJK>
       (?$(H^l(B . "0x8577") ; <CJK>
       (?$(H^m(B . "0x857C") ; <CJK>
       (?$(H^n(B . "0x8589") ; <CJK>
       (?$(H^o(B . "0x85A1") ; <CJK>
       (?$(H^p(B . "0x857A") ; <CJK>
       (?$(H^q(B . "0x8578") ; <CJK>
       (?$(H^r(B . "0x8557") ; <CJK>
       (?$(H^s(B . "0x858E") ; <CJK>
       (?$(H^t(B . "0x8596") ; <CJK>
       (?$(H^u(B . "0x8586") ; <CJK>
       (?$(H^v(B . "0x858D") ; <CJK>
       (?$(H^w(B . "0x8599") ; <CJK>
       (?$(H^x(B . "0x859D") ; <CJK>
       (?$(H^y(B . "0x8581") ; <CJK>
       (?$(H^z(B . "0x85A2") ; <CJK>
       (?$(H^{(B . "0x8582") ; <CJK>
       (?$(H^|(B . "0x8588") ; <CJK>
       (?$(H^}(B . "0x8585") ; <CJK>
       (?$(H^~(B . "0x8579") ; <CJK>
       (?$(H_!(B . "0x8576") ; <CJK>
       (?$(H_"(B . "0x8598") ; <CJK>
       (?$(H_#(B . "0x8590") ; <CJK>
       (?$(H_$(B . "0x859F") ; <CJK>
       (?$(H_%(B . "0x8668") ; <CJK>
       (?$(H_&(B . "0x87BE") ; <CJK>
       (?$(H_'(B . "0x87AA") ; <CJK>
       (?$(H_((B . "0x87AD") ; <CJK>
       (?$(H_)(B . "0x87C5") ; <CJK>
       (?$(H_*(B . "0x87B0") ; <CJK>
       (?$(H_+(B . "0x87AC") ; <CJK>
       (?$(H_,(B . "0x87B9") ; <CJK>
       (?$(H_-(B . "0x87B5") ; <CJK>
       (?$(H_.(B . "0x87BC") ; <CJK>
       (?$(H_/(B . "0x87AE") ; <CJK>
       (?$(H_0(B . "0x87C9") ; <CJK>
       (?$(H_1(B . "0x87C3") ; <CJK>
       (?$(H_2(B . "0x87C2") ; <CJK>
       (?$(H_3(B . "0x87CC") ; <CJK>
       (?$(H_4(B . "0x87B7") ; <CJK>
       (?$(H_5(B . "0x87AF") ; <CJK>
       (?$(H_6(B . "0x87C4") ; <CJK>
       (?$(H_7(B . "0x87CA") ; <CJK>
       (?$(H_8(B . "0x87B4") ; <CJK>
       (?$(H_9(B . "0x87B6") ; <CJK>
       (?$(H_:(B . "0x87BF") ; <CJK>
       (?$(H_;(B . "0x87B8") ; <CJK>
       (?$(H_<(B . "0x87BD") ; <CJK>
       (?$(H_=(B . "0x87DE") ; <CJK>
       (?$(H_>(B . "0x87B2") ; <CJK>
       (?$(H_?(B . "0x8935") ; <CJK>
       (?$(H_@(B . "0x8933") ; <CJK>
       (?$(H_A(B . "0x893C") ; <CJK>
       (?$(H_B(B . "0x893E") ; <CJK>
       (?$(H_C(B . "0x8941") ; <CJK>
       (?$(H_D(B . "0x8952") ; <CJK>
       (?$(H_E(B . "0x8937") ; <CJK>
       (?$(H_F(B . "0x8942") ; <CJK>
       (?$(H_G(B . "0x89AD") ; <CJK>
       (?$(H_H(B . "0x89AF") ; <CJK>
       (?$(H_I(B . "0x89AE") ; <CJK>
       (?$(H_J(B . "0x89F2") ; <CJK>
       (?$(H_K(B . "0x89F3") ; <CJK>
       (?$(H_L(B . "0x8B1E") ; <CJK>
       (?$(H_M(B . "0x8B18") ; <CJK>
       (?$(H_N(B . "0x8B16") ; <CJK>
       (?$(H_O(B . "0x8B11") ; <CJK>
       (?$(H_P(B . "0x8B05") ; <CJK>
       (?$(H_Q(B . "0x8B0B") ; <CJK>
       (?$(H_R(B . "0x8B22") ; <CJK>
       (?$(H_S(B . "0x8B0F") ; <CJK>
       (?$(H_T(B . "0x8B12") ; <CJK>
       (?$(H_U(B . "0x8B15") ; <CJK>
       (?$(H_V(B . "0x8B07") ; <CJK>
       (?$(H_W(B . "0x8B0D") ; <CJK>
       (?$(H_X(B . "0x8B08") ; <CJK>
       (?$(H_Y(B . "0x8B06") ; <CJK>
       (?$(H_Z(B . "0x8B1C") ; <CJK>
       (?$(H_[(B . "0x8B13") ; <CJK>
       (?$(H_\(B . "0x8B1A") ; <CJK>
       (?$(H_](B . "0x8C4F") ; <CJK>
       (?$(H_^(B . "0x8C70") ; <CJK>
       (?$(H__(B . "0x8C72") ; <CJK>
       (?$(H_`(B . "0x8C71") ; <CJK>
       (?$(H_a(B . "0x8C6F") ; <CJK>
       (?$(H_b(B . "0x8C95") ; <CJK>
       (?$(H_c(B . "0x8C94") ; <CJK>
       (?$(H_d(B . "0x8CF9") ; <CJK>
       (?$(H_e(B . "0x8D6F") ; <CJK>
       (?$(H_f(B . "0x8E4E") ; <CJK>
       (?$(H_g(B . "0x8E4D") ; <CJK>
       (?$(H_h(B . "0x8E53") ; <CJK>
       (?$(H_i(B . "0x8E50") ; <CJK>
       (?$(H_j(B . "0x8E4C") ; <CJK>
       (?$(H_k(B . "0x8E47") ; <CJK>
       (?$(H_l(B . "0x8F43") ; <CJK>
       (?$(H_m(B . "0x8F40") ; <CJK>
       (?$(H_n(B . "0x9085") ; <CJK>
       (?$(H_o(B . "0x907E") ; <CJK>
       (?$(H_p(B . "0x9138") ; <CJK>
       (?$(H_q(B . "0x919A") ; <CJK>
       (?$(H_r(B . "0x91A2") ; <CJK>
       (?$(H_s(B . "0x919B") ; <CJK>
       (?$(H_t(B . "0x9199") ; <CJK>
       (?$(H_u(B . "0x919F") ; <CJK>
       (?$(H_v(B . "0x91A1") ; <CJK>
       (?$(H_w(B . "0x919D") ; <CJK>
       (?$(H_x(B . "0x91A0") ; <CJK>
       (?$(H_y(B . "0x93A1") ; <CJK>
       (?$(H_z(B . "0x9383") ; <CJK>
       (?$(H_{(B . "0x93AF") ; <CJK>
       (?$(H_|(B . "0x9364") ; <CJK>
       (?$(H_}(B . "0x9356") ; <CJK>
       (?$(H_~(B . "0x9347") ; <CJK>
       (?$(H`!(B . "0x937C") ; <CJK>
       (?$(H`"(B . "0x9358") ; <CJK>
       (?$(H`#(B . "0x935C") ; <CJK>
       (?$(H`$(B . "0x9376") ; <CJK>
       (?$(H`%(B . "0x9349") ; <CJK>
       (?$(H`&(B . "0x9350") ; <CJK>
       (?$(H`'(B . "0x9351") ; <CJK>
       (?$(H`((B . "0x9360") ; <CJK>
       (?$(H`)(B . "0x936D") ; <CJK>
       (?$(H`*(B . "0x938F") ; <CJK>
       (?$(H`+(B . "0x934C") ; <CJK>
       (?$(H`,(B . "0x936A") ; <CJK>
       (?$(H`-(B . "0x9379") ; <CJK>
       (?$(H`.(B . "0x9357") ; <CJK>
       (?$(H`/(B . "0x9355") ; <CJK>
       (?$(H`0(B . "0x9352") ; <CJK>
       (?$(H`1(B . "0x934F") ; <CJK>
       (?$(H`2(B . "0x9371") ; <CJK>
       (?$(H`3(B . "0x9377") ; <CJK>
       (?$(H`4(B . "0x937B") ; <CJK>
       (?$(H`5(B . "0x9361") ; <CJK>
       (?$(H`6(B . "0x935E") ; <CJK>
       (?$(H`7(B . "0x9363") ; <CJK>
       (?$(H`8(B . "0x9367") ; <CJK>
       (?$(H`9(B . "0x934E") ; <CJK>
       (?$(H`:(B . "0x9359") ; <CJK>
       (?$(H`;(B . "0x95C7") ; <CJK>
       (?$(H`<(B . "0x95C0") ; <CJK>
       (?$(H`=(B . "0x95C9") ; <CJK>
       (?$(H`>(B . "0x95C3") ; <CJK>
       (?$(H`?(B . "0x95C5") ; <CJK>
       (?$(H`@(B . "0x95B7") ; <CJK>
       (?$(H`A(B . "0x96AE") ; <CJK>
       (?$(H`B(B . "0x96B0") ; <CJK>
       (?$(H`C(B . "0x96AC") ; <CJK>
       (?$(H`D(B . "0x9720") ; <CJK>
       (?$(H`E(B . "0x971F") ; <CJK>
       (?$(H`F(B . "0x9718") ; <CJK>
       (?$(H`G(B . "0x971D") ; <CJK>
       (?$(H`H(B . "0x9719") ; <CJK>
       (?$(H`I(B . "0x979A") ; <CJK>
       (?$(H`J(B . "0x97A1") ; <CJK>
       (?$(H`K(B . "0x979C") ; <CJK>
       (?$(H`L(B . "0x979E") ; <CJK>
       (?$(H`M(B . "0x979D") ; <CJK>
       (?$(H`N(B . "0x97D5") ; <CJK>
       (?$(H`O(B . "0x97D4") ; <CJK>
       (?$(H`P(B . "0x97F1") ; <CJK>
       (?$(H`Q(B . "0x9841") ; <CJK>
       (?$(H`R(B . "0x9844") ; <CJK>
       (?$(H`S(B . "0x984A") ; <CJK>
       (?$(H`T(B . "0x9849") ; <CJK>
       (?$(H`U(B . "0x9845") ; <CJK>
       (?$(H`V(B . "0x9843") ; <CJK>
       (?$(H`W(B . "0x9925") ; <CJK>
       (?$(H`X(B . "0x992B") ; <CJK>
       (?$(H`Y(B . "0x992C") ; <CJK>
       (?$(H`Z(B . "0x992A") ; <CJK>
       (?$(H`[(B . "0x9933") ; <CJK>
       (?$(H`\(B . "0x9932") ; <CJK>
       (?$(H`](B . "0x992F") ; <CJK>
       (?$(H`^(B . "0x992D") ; <CJK>
       (?$(H`_(B . "0x9931") ; <CJK>
       (?$(H``(B . "0x9930") ; <CJK>
       (?$(H`a(B . "0x9998") ; <CJK>
       (?$(H`b(B . "0x99A3") ; <CJK>
       (?$(H`c(B . "0x99A1") ; <CJK>
       (?$(H`d(B . "0x9A02") ; <CJK>
       (?$(H`e(B . "0x99FA") ; <CJK>
       (?$(H`f(B . "0x99F4") ; <CJK>
       (?$(H`g(B . "0x99F7") ; <CJK>
       (?$(H`h(B . "0x99F9") ; <CJK>
       (?$(H`i(B . "0x99F8") ; <CJK>
       (?$(H`j(B . "0x99F6") ; <CJK>
       (?$(H`k(B . "0x99FB") ; <CJK>
       (?$(H`l(B . "0x99FD") ; <CJK>
       (?$(H`m(B . "0x99FE") ; <CJK>
       (?$(H`n(B . "0x99FC") ; <CJK>
       (?$(H`o(B . "0x9A03") ; <CJK>
       (?$(H`p(B . "0x9ABE") ; <CJK>
       (?$(H`q(B . "0x9AFE") ; <CJK>
       (?$(H`r(B . "0x9AFD") ; <CJK>
       (?$(H`s(B . "0x9B01") ; <CJK>
       (?$(H`t(B . "0x9AFC") ; <CJK>
       (?$(H`u(B . "0x9B48") ; <CJK>
       (?$(H`v(B . "0x9B9A") ; <CJK>
       (?$(H`w(B . "0x9BA8") ; <CJK>
       (?$(H`x(B . "0x9B9E") ; <CJK>
       (?$(H`y(B . "0x9B9B") ; <CJK>
       (?$(H`z(B . "0x9BA6") ; <CJK>
       (?$(H`{(B . "0x9BA1") ; <CJK>
       (?$(H`|(B . "0x9BA5") ; <CJK>
       (?$(H`}(B . "0x9BA4") ; <CJK>
       (?$(H`~(B . "0x9B86") ; <CJK>
       (?$(Ha!(B . "0x9BA2") ; <CJK>
       (?$(Ha"(B . "0x9BA0") ; <CJK>
       (?$(Ha#(B . "0x9BAF") ; <CJK>
       (?$(Ha$(B . "0x9D33") ; <CJK>
       (?$(Ha%(B . "0x9D41") ; <CJK>
       (?$(Ha&(B . "0x9D67") ; <CJK>
       (?$(Ha'(B . "0x9D36") ; <CJK>
       (?$(Ha((B . "0x9D2E") ; <CJK>
       (?$(Ha)(B . "0x9D2F") ; <CJK>
       (?$(Ha*(B . "0x9D31") ; <CJK>
       (?$(Ha+(B . "0x9D38") ; <CJK>
       (?$(Ha,(B . "0x9D30") ; <CJK>
       (?$(Ha-(B . "0x9D45") ; <CJK>
       (?$(Ha.(B . "0x9D42") ; <CJK>
       (?$(Ha/(B . "0x9D43") ; <CJK>
       (?$(Ha0(B . "0x9D3E") ; <CJK>
       (?$(Ha1(B . "0x9D37") ; <CJK>
       (?$(Ha2(B . "0x9D40") ; <CJK>
       (?$(Ha3(B . "0x9D3D") ; <CJK>
       (?$(Ha4(B . "0x7FF5") ; <CJK>
       (?$(Ha5(B . "0x9D2D") ; <CJK>
       (?$(Ha6(B . "0x9E8A") ; <CJK>
       (?$(Ha7(B . "0x9E89") ; <CJK>
       (?$(Ha8(B . "0x9E8D") ; <CJK>
       (?$(Ha9(B . "0x9EB0") ; <CJK>
       (?$(Ha:(B . "0x9EC8") ; <CJK>
       (?$(Ha;(B . "0x9EDA") ; <CJK>
       (?$(Ha<(B . "0x9EFB") ; <CJK>
       (?$(Ha=(B . "0x9EFF") ; <CJK>
       (?$(Ha>(B . "0x9F24") ; <CJK>
       (?$(Ha?(B . "0x9F23") ; <CJK>
       (?$(Ha@(B . "0x9F22") ; <CJK>
       (?$(HaA(B . "0x9F54") ; <CJK>
       (?$(HaB(B . "0x9FA0") ; <CJK>
       (?$(HaC(B . "0x5131") ; <CJK>
       (?$(HaD(B . "0x512D") ; <CJK>
       (?$(HaE(B . "0x512E") ; <CJK>
       (?$(HaF(B . "0x5698") ; <CJK>
       (?$(HaG(B . "0x569C") ; <CJK>
       (?$(HaH(B . "0x5697") ; <CJK>
       (?$(HaI(B . "0x569A") ; <CJK>
       (?$(HaJ(B . "0x569D") ; <CJK>
       (?$(HaK(B . "0x5699") ; <CJK>
       (?$(HaL(B . "0x5970") ; <CJK>
       (?$(HaM(B . "0x5B3C") ; <CJK>
       (?$(HaN(B . "0x5C69") ; <CJK>
       (?$(HaO(B . "0x5C6A") ; <CJK>
       (?$(HaP(B . "0x5DC0") ; <CJK>
       (?$(HaQ(B . "0x5E6D") ; <CJK>
       (?$(HaR(B . "0x5E6E") ; <CJK>
       (?$(HaS(B . "0x61D8") ; <CJK>
       (?$(HaT(B . "0x61DF") ; <CJK>
       (?$(HaU(B . "0x61ED") ; <CJK>
       (?$(HaV(B . "0x61EE") ; <CJK>
       (?$(HaW(B . "0x61F1") ; <CJK>
       (?$(HaX(B . "0x61EA") ; <CJK>
       (?$(HaY(B . "0x61F0") ; <CJK>
       (?$(HaZ(B . "0x61EB") ; <CJK>
       (?$(Ha[(B . "0x61D6") ; <CJK>
       (?$(Ha\(B . "0x61E9") ; <CJK>
       (?$(Ha](B . "0x64FF") ; <CJK>
       (?$(Ha^(B . "0x6504") ; <CJK>
       (?$(Ha_(B . "0x64FD") ; <CJK>
       (?$(Ha`(B . "0x64F8") ; <CJK>
       (?$(Haa(B . "0x6501") ; <CJK>
       (?$(Hab(B . "0x6503") ; <CJK>
       (?$(Hac(B . "0x64FC") ; <CJK>
       (?$(Had(B . "0x6594") ; <CJK>
       (?$(Hae(B . "0x65DB") ; <CJK>
       (?$(Haf(B . "0x66DA") ; <CJK>
       (?$(Hag(B . "0x66DB") ; <CJK>
       (?$(Hah(B . "0x66D8") ; <CJK>
       (?$(Hai(B . "0x6AC5") ; <CJK>
       (?$(Haj(B . "0x6AB9") ; <CJK>
       (?$(Hak(B . "0x6ABD") ; <CJK>
       (?$(Hal(B . "0x6AE1") ; <CJK>
       (?$(Ham(B . "0x6AC6") ; <CJK>
       (?$(Han(B . "0x6ABA") ; <CJK>
       (?$(Hao(B . "0x6AB6") ; <CJK>
       (?$(Hap(B . "0x6AB7") ; <CJK>
       (?$(Haq(B . "0x6AC7") ; <CJK>
       (?$(Har(B . "0x6AB4") ; <CJK>
       (?$(Has(B . "0x6AAD") ; <CJK>
       (?$(Hat(B . "0x6B5E") ; <CJK>
       (?$(Hau(B . "0x6BC9") ; <CJK>
       (?$(Hav(B . "0x6C0B") ; <CJK>
       (?$(Haw(B . "0x7007") ; <CJK>
       (?$(Hax(B . "0x700C") ; <CJK>
       (?$(Hay(B . "0x700D") ; <CJK>
       (?$(Haz(B . "0x7001") ; <CJK>
       (?$(Ha{(B . "0x7005") ; <CJK>
       (?$(Ha|(B . "0x7014") ; <CJK>
       (?$(Ha}(B . "0x700E") ; <CJK>
       (?$(Ha~(B . "0x6FFF") ; <CJK>
       (?$(Hb!(B . "0x7000") ; <CJK>
       (?$(Hb"(B . "0x6FFB") ; <CJK>
       (?$(Hb#(B . "0x7026") ; <CJK>
       (?$(Hb$(B . "0x6FFC") ; <CJK>
       (?$(Hb%(B . "0x6FF7") ; <CJK>
       (?$(Hb&(B . "0x700A") ; <CJK>
       (?$(Hb'(B . "0x7201") ; <CJK>
       (?$(Hb((B . "0x71FF") ; <CJK>
       (?$(Hb)(B . "0x71F9") ; <CJK>
       (?$(Hb*(B . "0x7203") ; <CJK>
       (?$(Hb+(B . "0x71FD") ; <CJK>
       (?$(Hb,(B . "0x7376") ; <CJK>
       (?$(Hb-(B . "0x74B8") ; <CJK>
       (?$(Hb.(B . "0x74C0") ; <CJK>
       (?$(Hb/(B . "0x74B5") ; <CJK>
       (?$(Hb0(B . "0x74C1") ; <CJK>
       (?$(Hb1(B . "0x74BE") ; <CJK>
       (?$(Hb2(B . "0x74B6") ; <CJK>
       (?$(Hb3(B . "0x74BB") ; <CJK>
       (?$(Hb4(B . "0x74C2") ; <CJK>
       (?$(Hb5(B . "0x7514") ; <CJK>
       (?$(Hb6(B . "0x7513") ; <CJK>
       (?$(Hb7(B . "0x765C") ; <CJK>
       (?$(Hb8(B . "0x7664") ; <CJK>
       (?$(Hb9(B . "0x7659") ; <CJK>
       (?$(Hb:(B . "0x7650") ; <CJK>
       (?$(Hb;(B . "0x7653") ; <CJK>
       (?$(Hb<(B . "0x7657") ; <CJK>
       (?$(Hb=(B . "0x765A") ; <CJK>
       (?$(Hb>(B . "0x76A6") ; <CJK>
       (?$(Hb?(B . "0x76BD") ; <CJK>
       (?$(Hb@(B . "0x76EC") ; <CJK>
       (?$(HbA(B . "0x77C2") ; <CJK>
       (?$(HbB(B . "0x77BA") ; <CJK>
       (?$(HbC(B . "0x790C") ; <CJK>
       (?$(HbD(B . "0x7913") ; <CJK>
       (?$(HbE(B . "0x7914") ; <CJK>
       (?$(HbF(B . "0x7909") ; <CJK>
       (?$(HbG(B . "0x7910") ; <CJK>
       (?$(HbH(B . "0x7912") ; <CJK>
       (?$(HbI(B . "0x7911") ; <CJK>
       (?$(HbJ(B . "0x79AD") ; <CJK>
       (?$(HbK(B . "0x79AC") ; <CJK>
       (?$(HbL(B . "0x7A5F") ; <CJK>
       (?$(HbM(B . "0x7C1C") ; <CJK>
       (?$(HbN(B . "0x7C29") ; <CJK>
       (?$(HbO(B . "0x7C19") ; <CJK>
       (?$(HbP(B . "0x7C20") ; <CJK>
       (?$(HbQ(B . "0x7C1F") ; <CJK>
       (?$(HbR(B . "0x7C2D") ; <CJK>
       (?$(HbS(B . "0x7C1D") ; <CJK>
       (?$(HbT(B . "0x7C26") ; <CJK>
       (?$(HbU(B . "0x7C28") ; <CJK>
       (?$(HbV(B . "0x7C22") ; <CJK>
       (?$(HbW(B . "0x7C25") ; <CJK>
       (?$(HbX(B . "0x7C30") ; <CJK>
       (?$(HbY(B . "0x7E5C") ; <CJK>
       (?$(HbZ(B . "0x7E50") ; <CJK>
       (?$(Hb[(B . "0x7E56") ; <CJK>
       (?$(Hb\(B . "0x7E63") ; <CJK>
       (?$(Hb](B . "0x7E58") ; <CJK>
       (?$(Hb^(B . "0x7E62") ; <CJK>
       (?$(Hb_(B . "0x7E5F") ; <CJK>
       (?$(Hb`(B . "0x7E51") ; <CJK>
       (?$(Hba(B . "0x7E60") ; <CJK>
       (?$(Hbb(B . "0x7E57") ; <CJK>
       (?$(Hbc(B . "0x7E53") ; <CJK>
       (?$(Hbd(B . "0x7FB5") ; <CJK>
       (?$(Hbe(B . "0x7FB3") ; <CJK>
       (?$(Hbf(B . "0x7FF7") ; <CJK>
       (?$(Hbg(B . "0x7FF8") ; <CJK>
       (?$(Hbh(B . "0x8075") ; <CJK>
       (?$(Hbi(B . "0x81D1") ; <CJK>
       (?$(Hbj(B . "0x81D2") ; <CJK>
       (?$(Hbk(B . "0x81D0") ; <CJK>
       (?$(Hbl(B . "0x825F") ; <CJK>
       (?$(Hbm(B . "0x825E") ; <CJK>
       (?$(Hbn(B . "0x85B4") ; <CJK>
       (?$(Hbo(B . "0x85C6") ; <CJK>
       (?$(Hbp(B . "0x85C0") ; <CJK>
       (?$(Hbq(B . "0x85C3") ; <CJK>
       (?$(Hbr(B . "0x85C2") ; <CJK>
       (?$(Hbs(B . "0x85B3") ; <CJK>
       (?$(Hbt(B . "0x85B5") ; <CJK>
       (?$(Hbu(B . "0x85BD") ; <CJK>
       (?$(Hbv(B . "0x85C7") ; <CJK>
       (?$(Hbw(B . "0x85C4") ; <CJK>
       (?$(Hbx(B . "0x85BF") ; <CJK>
       (?$(Hby(B . "0x85CB") ; <CJK>
       (?$(Hbz(B . "0x85CE") ; <CJK>
       (?$(Hb{(B . "0x85C8") ; <CJK>
       (?$(Hb|(B . "0x85C5") ; <CJK>
       (?$(Hb}(B . "0x85B1") ; <CJK>
       (?$(Hb~(B . "0x85B6") ; <CJK>
       (?$(Hc!(B . "0x85D2") ; <CJK>
       (?$(Hc"(B . "0x8624") ; <CJK>
       (?$(Hc#(B . "0x85B8") ; <CJK>
       (?$(Hc$(B . "0x85B7") ; <CJK>
       (?$(Hc%(B . "0x85BE") ; <CJK>
       (?$(Hc&(B . "0x8669") ; <CJK>
       (?$(Hc'(B . "0x87E7") ; <CJK>
       (?$(Hc((B . "0x87E6") ; <CJK>
       (?$(Hc)(B . "0x87E2") ; <CJK>
       (?$(Hc*(B . "0x87DB") ; <CJK>
       (?$(Hc+(B . "0x87EB") ; <CJK>
       (?$(Hc,(B . "0x87EA") ; <CJK>
       (?$(Hc-(B . "0x87E5") ; <CJK>
       (?$(Hc.(B . "0x87DF") ; <CJK>
       (?$(Hc/(B . "0x87F3") ; <CJK>
       (?$(Hc0(B . "0x87E4") ; <CJK>
       (?$(Hc1(B . "0x87D4") ; <CJK>
       (?$(Hc2(B . "0x87DC") ; <CJK>
       (?$(Hc3(B . "0x87D3") ; <CJK>
       (?$(Hc4(B . "0x87ED") ; <CJK>
       (?$(Hc5(B . "0x87D8") ; <CJK>
       (?$(Hc6(B . "0x87E3") ; <CJK>
       (?$(Hc7(B . "0x87D7") ; <CJK>
       (?$(Hc8(B . "0x87D9") ; <CJK>
       (?$(Hc9(B . "0x8801") ; <CJK>
       (?$(Hc:(B . "0x87F4") ; <CJK>
       (?$(Hc;(B . "0x87E8") ; <CJK>
       (?$(Hc<(B . "0x87DD") ; <CJK>
       (?$(Hc=(B . "0x8953") ; <CJK>
       (?$(Hc>(B . "0x894B") ; <CJK>
       (?$(Hc?(B . "0x894F") ; <CJK>
       (?$(Hc@(B . "0x894C") ; <CJK>
       (?$(HcA(B . "0x8946") ; <CJK>
       (?$(HcB(B . "0x8950") ; <CJK>
       (?$(HcC(B . "0x8951") ; <CJK>
       (?$(HcD(B . "0x8949") ; <CJK>
       (?$(HcE(B . "0x8B2A") ; <CJK>
       (?$(HcF(B . "0x8B27") ; <CJK>
       (?$(HcG(B . "0x8B23") ; <CJK>
       (?$(HcH(B . "0x8B33") ; <CJK>
       (?$(HcI(B . "0x8B30") ; <CJK>
       (?$(HcJ(B . "0x8B35") ; <CJK>
       (?$(HcK(B . "0x8B47") ; <CJK>
       (?$(HcL(B . "0x8B2F") ; <CJK>
       (?$(HcM(B . "0x8B3C") ; <CJK>
       (?$(HcN(B . "0x8B3E") ; <CJK>
       (?$(HcO(B . "0x8B31") ; <CJK>
       (?$(HcP(B . "0x8B25") ; <CJK>
       (?$(HcQ(B . "0x8B37") ; <CJK>
       (?$(HcR(B . "0x8B26") ; <CJK>
       (?$(HcS(B . "0x8B36") ; <CJK>
       (?$(HcT(B . "0x8B2E") ; <CJK>
       (?$(HcU(B . "0x8B24") ; <CJK>
       (?$(HcV(B . "0x8B3B") ; <CJK>
       (?$(HcW(B . "0x8B3D") ; <CJK>
       (?$(HcX(B . "0x8B3A") ; <CJK>
       (?$(HcY(B . "0x8C42") ; <CJK>
       (?$(HcZ(B . "0x8C75") ; <CJK>
       (?$(Hc[(B . "0x8C99") ; <CJK>
       (?$(Hc\(B . "0x8C98") ; <CJK>
       (?$(Hc](B . "0x8C97") ; <CJK>
       (?$(Hc^(B . "0x8CFE") ; <CJK>
       (?$(Hc_(B . "0x8D04") ; <CJK>
       (?$(Hc`(B . "0x8D02") ; <CJK>
       (?$(Hca(B . "0x8D00") ; <CJK>
       (?$(Hcb(B . "0x8E5C") ; <CJK>
       (?$(Hcc(B . "0x8E62") ; <CJK>
       (?$(Hcd(B . "0x8E60") ; <CJK>
       (?$(Hce(B . "0x8E57") ; <CJK>
       (?$(Hcf(B . "0x8E56") ; <CJK>
       (?$(Hcg(B . "0x8E5E") ; <CJK>
       (?$(Hch(B . "0x8E65") ; <CJK>
       (?$(Hci(B . "0x8E67") ; <CJK>
       (?$(Hcj(B . "0x8E5B") ; <CJK>
       (?$(Hck(B . "0x8E5A") ; <CJK>
       (?$(Hcl(B . "0x8E61") ; <CJK>
       (?$(Hcm(B . "0x8E5D") ; <CJK>
       (?$(Hcn(B . "0x8E69") ; <CJK>
       (?$(Hco(B . "0x8E54") ; <CJK>
       (?$(Hcp(B . "0x8F46") ; <CJK>
       (?$(Hcq(B . "0x8F47") ; <CJK>
       (?$(Hcr(B . "0x8F48") ; <CJK>
       (?$(Hcs(B . "0x8F4B") ; <CJK>
       (?$(Hct(B . "0x9128") ; <CJK>
       (?$(Hcu(B . "0x913A") ; <CJK>
       (?$(Hcv(B . "0x913B") ; <CJK>
       (?$(Hcw(B . "0x913E") ; <CJK>
       (?$(Hcx(B . "0x91A8") ; <CJK>
       (?$(Hcy(B . "0x91A5") ; <CJK>
       (?$(Hcz(B . "0x91A7") ; <CJK>
       (?$(Hc{(B . "0x91AF") ; <CJK>
       (?$(Hc|(B . "0x91AA") ; <CJK>
       (?$(Hc}(B . "0x93B5") ; <CJK>
       (?$(Hc~(B . "0x938C") ; <CJK>
       (?$(Hd!(B . "0x9392") ; <CJK>
       (?$(Hd"(B . "0x93B7") ; <CJK>
       (?$(Hd#(B . "0x939B") ; <CJK>
       (?$(Hd$(B . "0x939D") ; <CJK>
       (?$(Hd%(B . "0x9389") ; <CJK>
       (?$(Hd&(B . "0x93A7") ; <CJK>
       (?$(Hd'(B . "0x938E") ; <CJK>
       (?$(Hd((B . "0x93AA") ; <CJK>
       (?$(Hd)(B . "0x939E") ; <CJK>
       (?$(Hd*(B . "0x93A6") ; <CJK>
       (?$(Hd+(B . "0x9395") ; <CJK>
       (?$(Hd,(B . "0x9388") ; <CJK>
       (?$(Hd-(B . "0x9399") ; <CJK>
       (?$(Hd.(B . "0x939F") ; <CJK>
       (?$(Hd/(B . "0x9380") ; <CJK>
       (?$(Hd0(B . "0x938D") ; <CJK>
       (?$(Hd1(B . "0x93B1") ; <CJK>
       (?$(Hd2(B . "0x9391") ; <CJK>
       (?$(Hd3(B . "0x93B2") ; <CJK>
       (?$(Hd4(B . "0x93A4") ; <CJK>
       (?$(Hd5(B . "0x93A8") ; <CJK>
       (?$(Hd6(B . "0x93B4") ; <CJK>
       (?$(Hd7(B . "0x93A3") ; <CJK>
       (?$(Hd8(B . "0x95D2") ; <CJK>
       (?$(Hd9(B . "0x95D3") ; <CJK>
       (?$(Hd:(B . "0x95D1") ; <CJK>
       (?$(Hd;(B . "0x96B3") ; <CJK>
       (?$(Hd<(B . "0x96D7") ; <CJK>
       (?$(Hd=(B . "0x96DA") ; <CJK>
       (?$(Hd>(B . "0x5DC2") ; <CJK>
       (?$(Hd?(B . "0x96DF") ; <CJK>
       (?$(Hd@(B . "0x96D8") ; <CJK>
       (?$(HdA(B . "0x96DD") ; <CJK>
       (?$(HdB(B . "0x9723") ; <CJK>
       (?$(HdC(B . "0x9722") ; <CJK>
       (?$(HdD(B . "0x9725") ; <CJK>
       (?$(HdE(B . "0x97AC") ; <CJK>
       (?$(HdF(B . "0x97AE") ; <CJK>
       (?$(HdG(B . "0x97A8") ; <CJK>
       (?$(HdH(B . "0x97AB") ; <CJK>
       (?$(HdI(B . "0x97A4") ; <CJK>
       (?$(HdJ(B . "0x97AA") ; <CJK>
       (?$(HdK(B . "0x97A2") ; <CJK>
       (?$(HdL(B . "0x97A5") ; <CJK>
       (?$(HdM(B . "0x97D7") ; <CJK>
       (?$(HdN(B . "0x97D9") ; <CJK>
       (?$(HdO(B . "0x97D6") ; <CJK>
       (?$(HdP(B . "0x97D8") ; <CJK>
       (?$(HdQ(B . "0x97FA") ; <CJK>
       (?$(HdR(B . "0x9850") ; <CJK>
       (?$(HdS(B . "0x9851") ; <CJK>
       (?$(HdT(B . "0x9852") ; <CJK>
       (?$(HdU(B . "0x98B8") ; <CJK>
       (?$(HdV(B . "0x9941") ; <CJK>
       (?$(HdW(B . "0x993C") ; <CJK>
       (?$(HdX(B . "0x993A") ; <CJK>
       (?$(HdY(B . "0x9A0F") ; <CJK>
       (?$(HdZ(B . "0x9A0B") ; <CJK>
       (?$(Hd[(B . "0x9A09") ; <CJK>
       (?$(Hd\(B . "0x9A0D") ; <CJK>
       (?$(Hd](B . "0x9A04") ; <CJK>
       (?$(Hd^(B . "0x9A11") ; <CJK>
       (?$(Hd_(B . "0x9A0A") ; <CJK>
       (?$(Hd`(B . "0x9A05") ; <CJK>
       (?$(Hda(B . "0x9A07") ; <CJK>
       (?$(Hdb(B . "0x9A06") ; <CJK>
       (?$(Hdc(B . "0x9AC0") ; <CJK>
       (?$(Hdd(B . "0x9ADC") ; <CJK>
       (?$(Hde(B . "0x9B08") ; <CJK>
       (?$(Hdf(B . "0x9B04") ; <CJK>
       (?$(Hdg(B . "0x9B05") ; <CJK>
       (?$(Hdh(B . "0x9B29") ; <CJK>
       (?$(Hdi(B . "0x9B35") ; <CJK>
       (?$(Hdj(B . "0x9B4A") ; <CJK>
       (?$(Hdk(B . "0x9B4C") ; <CJK>
       (?$(Hdl(B . "0x9B4B") ; <CJK>
       (?$(Hdm(B . "0x9BC7") ; <CJK>
       (?$(Hdn(B . "0x9BC6") ; <CJK>
       (?$(Hdo(B . "0x9BC3") ; <CJK>
       (?$(Hdp(B . "0x9BBF") ; <CJK>
       (?$(Hdq(B . "0x9BC1") ; <CJK>
       (?$(Hdr(B . "0x9BB5") ; <CJK>
       (?$(Hds(B . "0x9BB8") ; <CJK>
       (?$(Hdt(B . "0x9BD3") ; <CJK>
       (?$(Hdu(B . "0x9BB6") ; <CJK>
       (?$(Hdv(B . "0x9BC4") ; <CJK>
       (?$(Hdw(B . "0x9BB9") ; <CJK>
       (?$(Hdx(B . "0x9BBD") ; <CJK>
       (?$(Hdy(B . "0x9D5C") ; <CJK>
       (?$(Hdz(B . "0x9D53") ; <CJK>
       (?$(Hd{(B . "0x9D4F") ; <CJK>
       (?$(Hd|(B . "0x9D4A") ; <CJK>
       (?$(Hd}(B . "0x9D5B") ; <CJK>
       (?$(Hd~(B . "0x9D4B") ; <CJK>
       (?$(He!(B . "0x9D59") ; <CJK>
       (?$(He"(B . "0x9D56") ; <CJK>
       (?$(He#(B . "0x9D4C") ; <CJK>
       (?$(He$(B . "0x9D57") ; <CJK>
       (?$(He%(B . "0x9D52") ; <CJK>
       (?$(He&(B . "0x9D54") ; <CJK>
       (?$(He'(B . "0x9D5F") ; <CJK>
       (?$(He((B . "0x9D58") ; <CJK>
       (?$(He)(B . "0x9D5A") ; <CJK>
       (?$(He*(B . "0x9E8E") ; <CJK>
       (?$(He+(B . "0x9E8C") ; <CJK>
       (?$(He,(B . "0x9EDF") ; <CJK>
       (?$(He-(B . "0x9F01") ; <CJK>
       (?$(He.(B . "0x9F00") ; <CJK>
       (?$(He/(B . "0x9F16") ; <CJK>
       (?$(He0(B . "0x9F25") ; <CJK>
       (?$(He1(B . "0x9F2B") ; <CJK>
       (?$(He2(B . "0x9F2A") ; <CJK>
       (?$(He3(B . "0x9F29") ; <CJK>
       (?$(He4(B . "0x9F28") ; <CJK>
       (?$(He5(B . "0x9F4C") ; <CJK>
       (?$(He6(B . "0x9F55") ; <CJK>
       (?$(He7(B . "0x5134") ; <CJK>
       (?$(He8(B . "0x5135") ; <CJK>
       (?$(He9(B . "0x5296") ; <CJK>
       (?$(He:(B . "0x52F7") ; <CJK>
       (?$(He;(B . "0x53B4") ; <CJK>
       (?$(He<(B . "0x56AB") ; <CJK>
       (?$(He=(B . "0x56AD") ; <CJK>
       (?$(He>(B . "0x56A6") ; <CJK>
       (?$(He?(B . "0x56A7") ; <CJK>
       (?$(He@(B . "0x56AA") ; <CJK>
       (?$(HeA(B . "0x56AC") ; <CJK>
       (?$(HeB(B . "0x58DA") ; <CJK>
       (?$(HeC(B . "0x58DD") ; <CJK>
       (?$(HeD(B . "0x58DB") ; <CJK>
       (?$(HeE(B . "0x5912") ; <CJK>
       (?$(HeF(B . "0x5B3D") ; <CJK>
       (?$(HeG(B . "0x5B3E") ; <CJK>
       (?$(HeH(B . "0x5B3F") ; <CJK>
       (?$(HeI(B . "0x5DC3") ; <CJK>
       (?$(HeJ(B . "0x5E70") ; <CJK>
       (?$(HeK(B . "0x5FBF") ; <CJK>
       (?$(HeL(B . "0x61FB") ; <CJK>
       (?$(HeM(B . "0x6507") ; <CJK>
       (?$(HeN(B . "0x6510") ; <CJK>
       (?$(HeO(B . "0x650D") ; <CJK>
       (?$(HeP(B . "0x6509") ; <CJK>
       (?$(HeQ(B . "0x650C") ; <CJK>
       (?$(HeR(B . "0x650E") ; <CJK>
       (?$(HeS(B . "0x6584") ; <CJK>
       (?$(HeT(B . "0x65DE") ; <CJK>
       (?$(HeU(B . "0x65DD") ; <CJK>
       (?$(HeV(B . "0x66DE") ; <CJK>
       (?$(HeW(B . "0x6AE7") ; <CJK>
       (?$(HeX(B . "0x6AE0") ; <CJK>
       (?$(HeY(B . "0x6ACC") ; <CJK>
       (?$(HeZ(B . "0x6AD1") ; <CJK>
       (?$(He[(B . "0x6AD9") ; <CJK>
       (?$(He\(B . "0x6ACB") ; <CJK>
       (?$(He](B . "0x6ADF") ; <CJK>
       (?$(He^(B . "0x6ADC") ; <CJK>
       (?$(He_(B . "0x6AD0") ; <CJK>
       (?$(He`(B . "0x6AEB") ; <CJK>
       (?$(Hea(B . "0x6ACF") ; <CJK>
       (?$(Heb(B . "0x6ACD") ; <CJK>
       (?$(Hec(B . "0x6ADE") ; <CJK>
       (?$(Hed(B . "0x6B60") ; <CJK>
       (?$(Hee(B . "0x6BB0") ; <CJK>
       (?$(Hef(B . "0x6C0C") ; <CJK>
       (?$(Heg(B . "0x7019") ; <CJK>
       (?$(Heh(B . "0x7027") ; <CJK>
       (?$(Hei(B . "0x7020") ; <CJK>
       (?$(Hej(B . "0x7016") ; <CJK>
       (?$(Hek(B . "0x702B") ; <CJK>
       (?$(Hel(B . "0x7021") ; <CJK>
       (?$(Hem(B . "0x7022") ; <CJK>
       (?$(Hen(B . "0x7023") ; <CJK>
       (?$(Heo(B . "0x7029") ; <CJK>
       (?$(Hep(B . "0x7017") ; <CJK>
       (?$(Heq(B . "0x7024") ; <CJK>
       (?$(Her(B . "0x701C") ; <CJK>
       (?$(Hes(B . "0x720C") ; <CJK>
       (?$(Het(B . "0x720A") ; <CJK>
       (?$(Heu(B . "0x7207") ; <CJK>
       (?$(Hev(B . "0x7202") ; <CJK>
       (?$(Hew(B . "0x7205") ; <CJK>
       (?$(Hex(B . "0x72A5") ; <CJK>
       (?$(Hey(B . "0x72A6") ; <CJK>
       (?$(Hez(B . "0x72A4") ; <CJK>
       (?$(He{(B . "0x72A3") ; <CJK>
       (?$(He|(B . "0x72A1") ; <CJK>
       (?$(He}(B . "0x74CB") ; <CJK>
       (?$(He~(B . "0x74C5") ; <CJK>
       (?$(Hf!(B . "0x74B7") ; <CJK>
       (?$(Hf"(B . "0x74C3") ; <CJK>
       (?$(Hf#(B . "0x7516") ; <CJK>
       (?$(Hf$(B . "0x7660") ; <CJK>
       (?$(Hf%(B . "0x77C9") ; <CJK>
       (?$(Hf&(B . "0x77CA") ; <CJK>
       (?$(Hf'(B . "0x77C4") ; <CJK>
       (?$(Hf((B . "0x77F1") ; <CJK>
       (?$(Hf)(B . "0x791D") ; <CJK>
       (?$(Hf*(B . "0x791B") ; <CJK>
       (?$(Hf+(B . "0x7921") ; <CJK>
       (?$(Hf,(B . "0x791C") ; <CJK>
       (?$(Hf-(B . "0x7917") ; <CJK>
       (?$(Hf.(B . "0x791E") ; <CJK>
       (?$(Hf/(B . "0x79B0") ; <CJK>
       (?$(Hf0(B . "0x7A67") ; <CJK>
       (?$(Hf1(B . "0x7A68") ; <CJK>
       (?$(Hf2(B . "0x7C33") ; <CJK>
       (?$(Hf3(B . "0x7C3C") ; <CJK>
       (?$(Hf4(B . "0x7C39") ; <CJK>
       (?$(Hf5(B . "0x7C2C") ; <CJK>
       (?$(Hf6(B . "0x7C3B") ; <CJK>
       (?$(Hf7(B . "0x7CEC") ; <CJK>
       (?$(Hf8(B . "0x7CEA") ; <CJK>
       (?$(Hf9(B . "0x7E76") ; <CJK>
       (?$(Hf:(B . "0x7E75") ; <CJK>
       (?$(Hf;(B . "0x7E78") ; <CJK>
       (?$(Hf<(B . "0x7E70") ; <CJK>
       (?$(Hf=(B . "0x7E77") ; <CJK>
       (?$(Hf>(B . "0x7E6F") ; <CJK>
       (?$(Hf?(B . "0x7E7A") ; <CJK>
       (?$(Hf@(B . "0x7E72") ; <CJK>
       (?$(HfA(B . "0x7E74") ; <CJK>
       (?$(HfB(B . "0x7E68") ; <CJK>
       (?$(HfC(B . "0x7F4B") ; <CJK>
       (?$(HfD(B . "0x7F4A") ; <CJK>
       (?$(HfE(B . "0x7F83") ; <CJK>
       (?$(HfF(B . "0x7F86") ; <CJK>
       (?$(HfG(B . "0x7FB7") ; <CJK>
       (?$(HfH(B . "0x7FFD") ; <CJK>
       (?$(HfI(B . "0x7FFE") ; <CJK>
       (?$(HfJ(B . "0x8078") ; <CJK>
       (?$(HfK(B . "0x81D7") ; <CJK>
       (?$(HfL(B . "0x81D5") ; <CJK>
       (?$(HfM(B . "0x820B") ; <CJK>
       (?$(HfN(B . "0x8264") ; <CJK>
       (?$(HfO(B . "0x8261") ; <CJK>
       (?$(HfP(B . "0x8263") ; <CJK>
       (?$(HfQ(B . "0x85EB") ; <CJK>
       (?$(HfR(B . "0x85F1") ; <CJK>
       (?$(HfS(B . "0x85ED") ; <CJK>
       (?$(HfT(B . "0x85D9") ; <CJK>
       (?$(HfU(B . "0x85E1") ; <CJK>
       (?$(HfV(B . "0x85E8") ; <CJK>
       (?$(HfW(B . "0x85DA") ; <CJK>
       (?$(HfX(B . "0x85D7") ; <CJK>
       (?$(HfY(B . "0x85EC") ; <CJK>
       (?$(HfZ(B . "0x85F2") ; <CJK>
       (?$(Hf[(B . "0x85F8") ; <CJK>
       (?$(Hf\(B . "0x85D8") ; <CJK>
       (?$(Hf](B . "0x85DF") ; <CJK>
       (?$(Hf^(B . "0x85E3") ; <CJK>
       (?$(Hf_(B . "0x85DC") ; <CJK>
       (?$(Hf`(B . "0x85D1") ; <CJK>
       (?$(Hfa(B . "0x85F0") ; <CJK>
       (?$(Hfb(B . "0x85E6") ; <CJK>
       (?$(Hfc(B . "0x85EF") ; <CJK>
       (?$(Hfd(B . "0x85DE") ; <CJK>
       (?$(Hfe(B . "0x85E2") ; <CJK>
       (?$(Hff(B . "0x8800") ; <CJK>
       (?$(Hfg(B . "0x87FA") ; <CJK>
       (?$(Hfh(B . "0x8803") ; <CJK>
       (?$(Hfi(B . "0x87F6") ; <CJK>
       (?$(Hfj(B . "0x87F7") ; <CJK>
       (?$(Hfk(B . "0x8809") ; <CJK>
       (?$(Hfl(B . "0x880C") ; <CJK>
       (?$(Hfm(B . "0x880B") ; <CJK>
       (?$(Hfn(B . "0x8806") ; <CJK>
       (?$(Hfo(B . "0x87FC") ; <CJK>
       (?$(Hfp(B . "0x8808") ; <CJK>
       (?$(Hfq(B . "0x87FF") ; <CJK>
       (?$(Hfr(B . "0x880A") ; <CJK>
       (?$(Hfs(B . "0x8802") ; <CJK>
       (?$(Hft(B . "0x8962") ; <CJK>
       (?$(Hfu(B . "0x895A") ; <CJK>
       (?$(Hfv(B . "0x895B") ; <CJK>
       (?$(Hfw(B . "0x8957") ; <CJK>
       (?$(Hfx(B . "0x8961") ; <CJK>
       (?$(Hfy(B . "0x895C") ; <CJK>
       (?$(Hfz(B . "0x8958") ; <CJK>
       (?$(Hf{(B . "0x895D") ; <CJK>
       (?$(Hf|(B . "0x8959") ; <CJK>
       (?$(Hf}(B . "0x8988") ; <CJK>
       (?$(Hf~(B . "0x89B7") ; <CJK>
       (?$(Hg!(B . "0x89B6") ; <CJK>
       (?$(Hg"(B . "0x89F6") ; <CJK>
       (?$(Hg#(B . "0x8B50") ; <CJK>
       (?$(Hg$(B . "0x8B48") ; <CJK>
       (?$(Hg%(B . "0x8B4A") ; <CJK>
       (?$(Hg&(B . "0x8B40") ; <CJK>
       (?$(Hg'(B . "0x8B53") ; <CJK>
       (?$(Hg((B . "0x8B56") ; <CJK>
       (?$(Hg)(B . "0x8B54") ; <CJK>
       (?$(Hg*(B . "0x8B4B") ; <CJK>
       (?$(Hg+(B . "0x8B55") ; <CJK>
       (?$(Hg,(B . "0x8B51") ; <CJK>
       (?$(Hg-(B . "0x8B42") ; <CJK>
       (?$(Hg.(B . "0x8B52") ; <CJK>
       (?$(Hg/(B . "0x8B57") ; <CJK>
       (?$(Hg0(B . "0x8C43") ; <CJK>
       (?$(Hg1(B . "0x8C77") ; <CJK>
       (?$(Hg2(B . "0x8C76") ; <CJK>
       (?$(Hg3(B . "0x8C9A") ; <CJK>
       (?$(Hg4(B . "0x8D06") ; <CJK>
       (?$(Hg5(B . "0x8D07") ; <CJK>
       (?$(Hg6(B . "0x8D09") ; <CJK>
       (?$(Hg7(B . "0x8DAC") ; <CJK>
       (?$(Hg8(B . "0x8DAA") ; <CJK>
       (?$(Hg9(B . "0x8DAD") ; <CJK>
       (?$(Hg:(B . "0x8DAB") ; <CJK>
       (?$(Hg;(B . "0x8E6D") ; <CJK>
       (?$(Hg<(B . "0x8E78") ; <CJK>
       (?$(Hg=(B . "0x8E73") ; <CJK>
       (?$(Hg>(B . "0x8E6A") ; <CJK>
       (?$(Hg?(B . "0x8E6F") ; <CJK>
       (?$(Hg@(B . "0x8E7B") ; <CJK>
       (?$(HgA(B . "0x8EC2") ; <CJK>
       (?$(HgB(B . "0x8F52") ; <CJK>
       (?$(HgC(B . "0x8F51") ; <CJK>
       (?$(HgD(B . "0x8F4F") ; <CJK>
       (?$(HgE(B . "0x8F50") ; <CJK>
       (?$(HgF(B . "0x8F53") ; <CJK>
       (?$(HgG(B . "0x8FB4") ; <CJK>
       (?$(HgH(B . "0x9140") ; <CJK>
       (?$(HgI(B . "0x913F") ; <CJK>
       (?$(HgJ(B . "0x91B0") ; <CJK>
       (?$(HgK(B . "0x91AD") ; <CJK>
       (?$(HgL(B . "0x93DE") ; <CJK>
       (?$(HgM(B . "0x93C7") ; <CJK>
       (?$(HgN(B . "0x93CF") ; <CJK>
       (?$(HgO(B . "0x93C2") ; <CJK>
       (?$(HgP(B . "0x93DA") ; <CJK>
       (?$(HgQ(B . "0x93D0") ; <CJK>
       (?$(HgR(B . "0x93F9") ; <CJK>
       (?$(HgS(B . "0x93EC") ; <CJK>
       (?$(HgT(B . "0x93CC") ; <CJK>
       (?$(HgU(B . "0x93D9") ; <CJK>
       (?$(HgV(B . "0x93A9") ; <CJK>
       (?$(HgW(B . "0x93E6") ; <CJK>
       (?$(HgX(B . "0x93CA") ; <CJK>
       (?$(HgY(B . "0x93D4") ; <CJK>
       (?$(HgZ(B . "0x93EE") ; <CJK>
       (?$(Hg[(B . "0x93E3") ; <CJK>
       (?$(Hg\(B . "0x93D5") ; <CJK>
       (?$(Hg](B . "0x93C4") ; <CJK>
       (?$(Hg^(B . "0x93CE") ; <CJK>
       (?$(Hg_(B . "0x93C0") ; <CJK>
       (?$(Hg`(B . "0x93D2") ; <CJK>
       (?$(Hga(B . "0x93A5") ; <CJK>
       (?$(Hgb(B . "0x93E7") ; <CJK>
       (?$(Hgc(B . "0x957D") ; <CJK>
       (?$(Hgd(B . "0x95DA") ; <CJK>
       (?$(Hge(B . "0x95DB") ; <CJK>
       (?$(Hgf(B . "0x96E1") ; <CJK>
       (?$(Hgg(B . "0x9729") ; <CJK>
       (?$(Hgh(B . "0x972B") ; <CJK>
       (?$(Hgi(B . "0x972C") ; <CJK>
       (?$(Hgj(B . "0x9728") ; <CJK>
       (?$(Hgk(B . "0x9726") ; <CJK>
       (?$(Hgl(B . "0x97B3") ; <CJK>
       (?$(Hgm(B . "0x97B7") ; <CJK>
       (?$(Hgn(B . "0x97B6") ; <CJK>
       (?$(Hgo(B . "0x97DD") ; <CJK>
       (?$(Hgp(B . "0x97DE") ; <CJK>
       (?$(Hgq(B . "0x97DF") ; <CJK>
       (?$(Hgr(B . "0x985C") ; <CJK>
       (?$(Hgs(B . "0x9859") ; <CJK>
       (?$(Hgt(B . "0x985D") ; <CJK>
       (?$(Hgu(B . "0x9857") ; <CJK>
       (?$(Hgv(B . "0x98BF") ; <CJK>
       (?$(Hgw(B . "0x98BD") ; <CJK>
       (?$(Hgx(B . "0x98BB") ; <CJK>
       (?$(Hgy(B . "0x98BE") ; <CJK>
       (?$(Hgz(B . "0x9948") ; <CJK>
       (?$(Hg{(B . "0x9947") ; <CJK>
       (?$(Hg|(B . "0x9943") ; <CJK>
       (?$(Hg}(B . "0x99A6") ; <CJK>
       (?$(Hg~(B . "0x99A7") ; <CJK>
       (?$(Hh!(B . "0x9A1A") ; <CJK>
       (?$(Hh"(B . "0x9A15") ; <CJK>
       (?$(Hh#(B . "0x9A25") ; <CJK>
       (?$(Hh$(B . "0x9A1D") ; <CJK>
       (?$(Hh%(B . "0x9A24") ; <CJK>
       (?$(Hh&(B . "0x9A1B") ; <CJK>
       (?$(Hh'(B . "0x9A22") ; <CJK>
       (?$(Hh((B . "0x9A20") ; <CJK>
       (?$(Hh)(B . "0x9A27") ; <CJK>
       (?$(Hh*(B . "0x9A23") ; <CJK>
       (?$(Hh+(B . "0x9A1E") ; <CJK>
       (?$(Hh,(B . "0x9A1C") ; <CJK>
       (?$(Hh-(B . "0x9A14") ; <CJK>
       (?$(Hh.(B . "0x9AC2") ; <CJK>
       (?$(Hh/(B . "0x9B0B") ; <CJK>
       (?$(Hh0(B . "0x9B0A") ; <CJK>
       (?$(Hh1(B . "0x9B0E") ; <CJK>
       (?$(Hh2(B . "0x9B0C") ; <CJK>
       (?$(Hh3(B . "0x9B37") ; <CJK>
       (?$(Hh4(B . "0x9BEA") ; <CJK>
       (?$(Hh5(B . "0x9BEB") ; <CJK>
       (?$(Hh6(B . "0x9BE0") ; <CJK>
       (?$(Hh7(B . "0x9BDE") ; <CJK>
       (?$(Hh8(B . "0x9BE4") ; <CJK>
       (?$(Hh9(B . "0x9BE6") ; <CJK>
       (?$(Hh:(B . "0x9BE2") ; <CJK>
       (?$(Hh;(B . "0x9BF0") ; <CJK>
       (?$(Hh<(B . "0x9BD4") ; <CJK>
       (?$(Hh=(B . "0x9BD7") ; <CJK>
       (?$(Hh>(B . "0x9BEC") ; <CJK>
       (?$(Hh?(B . "0x9BDC") ; <CJK>
       (?$(Hh@(B . "0x9BD9") ; <CJK>
       (?$(HhA(B . "0x9BE5") ; <CJK>
       (?$(HhB(B . "0x9BD5") ; <CJK>
       (?$(HhC(B . "0x9BE1") ; <CJK>
       (?$(HhD(B . "0x9BDA") ; <CJK>
       (?$(HhE(B . "0x9D77") ; <CJK>
       (?$(HhF(B . "0x9D81") ; <CJK>
       (?$(HhG(B . "0x9D8A") ; <CJK>
       (?$(HhH(B . "0x9D84") ; <CJK>
       (?$(HhI(B . "0x9D88") ; <CJK>
       (?$(HhJ(B . "0x9D71") ; <CJK>
       (?$(HhK(B . "0x9D80") ; <CJK>
       (?$(HhL(B . "0x9D78") ; <CJK>
       (?$(HhM(B . "0x9D86") ; <CJK>
       (?$(HhN(B . "0x9D8B") ; <CJK>
       (?$(HhO(B . "0x9D8C") ; <CJK>
       (?$(HhP(B . "0x9D7D") ; <CJK>
       (?$(HhQ(B . "0x9D6B") ; <CJK>
       (?$(HhR(B . "0x9D74") ; <CJK>
       (?$(HhS(B . "0x9D75") ; <CJK>
       (?$(HhT(B . "0x9D70") ; <CJK>
       (?$(HhU(B . "0x9D69") ; <CJK>
       (?$(HhV(B . "0x9D85") ; <CJK>
       (?$(HhW(B . "0x9D73") ; <CJK>
       (?$(HhX(B . "0x9D7B") ; <CJK>
       (?$(HhY(B . "0x9D82") ; <CJK>
       (?$(HhZ(B . "0x9D6F") ; <CJK>
       (?$(Hh[(B . "0x9D79") ; <CJK>
       (?$(Hh\(B . "0x9D7F") ; <CJK>
       (?$(Hh](B . "0x9D87") ; <CJK>
       (?$(Hh^(B . "0x9D68") ; <CJK>
       (?$(Hh_(B . "0x9E94") ; <CJK>
       (?$(Hh`(B . "0x9E91") ; <CJK>
       (?$(Hha(B . "0x9EC0") ; <CJK>
       (?$(Hhb(B . "0x9EFC") ; <CJK>
       (?$(Hhc(B . "0x9F2D") ; <CJK>
       (?$(Hhd(B . "0x9F40") ; <CJK>
       (?$(Hhe(B . "0x9F41") ; <CJK>
       (?$(Hhf(B . "0x9F4D") ; <CJK>
       (?$(Hhg(B . "0x9F56") ; <CJK>
       (?$(Hhh(B . "0x9F57") ; <CJK>
       (?$(Hhi(B . "0x9F58") ; <CJK>
       (?$(Hhj(B . "0x5337") ; <CJK>
       (?$(Hhk(B . "0x56B2") ; <CJK>
       (?$(Hhl(B . "0x56B5") ; <CJK>
       (?$(Hhm(B . "0x56B3") ; <CJK>
       (?$(Hhn(B . "0x58E3") ; <CJK>
       (?$(Hho(B . "0x5B45") ; <CJK>
       (?$(Hhp(B . "0x5DC6") ; <CJK>
       (?$(Hhq(B . "0x5DC7") ; <CJK>
       (?$(Hhr(B . "0x5EEE") ; <CJK>
       (?$(Hhs(B . "0x5EEF") ; <CJK>
       (?$(Hht(B . "0x5FC0") ; <CJK>
       (?$(Hhu(B . "0x5FC1") ; <CJK>
       (?$(Hhv(B . "0x61F9") ; <CJK>
       (?$(Hhw(B . "0x6517") ; <CJK>
       (?$(Hhx(B . "0x6516") ; <CJK>
       (?$(Hhy(B . "0x6515") ; <CJK>
       (?$(Hhz(B . "0x6513") ; <CJK>
       (?$(Hh{(B . "0x65DF") ; <CJK>
       (?$(Hh|(B . "0x66E8") ; <CJK>
       (?$(Hh}(B . "0x66E3") ; <CJK>
       (?$(Hh~(B . "0x66E4") ; <CJK>
       (?$(Hi!(B . "0x6AF3") ; <CJK>
       (?$(Hi"(B . "0x6AF0") ; <CJK>
       (?$(Hi#(B . "0x6AEA") ; <CJK>
       (?$(Hi$(B . "0x6AE8") ; <CJK>
       (?$(Hi%(B . "0x6AF9") ; <CJK>
       (?$(Hi&(B . "0x6AF1") ; <CJK>
       (?$(Hi'(B . "0x6AEE") ; <CJK>
       (?$(Hi((B . "0x6AEF") ; <CJK>
       (?$(Hi)(B . "0x703C") ; <CJK>
       (?$(Hi*(B . "0x7035") ; <CJK>
       (?$(Hi+(B . "0x702F") ; <CJK>
       (?$(Hi,(B . "0x7037") ; <CJK>
       (?$(Hi-(B . "0x7034") ; <CJK>
       (?$(Hi.(B . "0x7031") ; <CJK>
       (?$(Hi/(B . "0x7042") ; <CJK>
       (?$(Hi0(B . "0x7038") ; <CJK>
       (?$(Hi1(B . "0x703F") ; <CJK>
       (?$(Hi2(B . "0x703A") ; <CJK>
       (?$(Hi3(B . "0x7039") ; <CJK>
       (?$(Hi4(B . "0x702A") ; <CJK>
       (?$(Hi5(B . "0x7040") ; <CJK>
       (?$(Hi6(B . "0x703B") ; <CJK>
       (?$(Hi7(B . "0x7033") ; <CJK>
       (?$(Hi8(B . "0x7041") ; <CJK>
       (?$(Hi9(B . "0x7213") ; <CJK>
       (?$(Hi:(B . "0x7214") ; <CJK>
       (?$(Hi;(B . "0x72A8") ; <CJK>
       (?$(Hi<(B . "0x737D") ; <CJK>
       (?$(Hi=(B . "0x737C") ; <CJK>
       (?$(Hi>(B . "0x74BA") ; <CJK>
       (?$(Hi?(B . "0x76AB") ; <CJK>
       (?$(Hi@(B . "0x76AA") ; <CJK>
       (?$(HiA(B . "0x76BE") ; <CJK>
       (?$(HiB(B . "0x76ED") ; <CJK>
       (?$(HiC(B . "0x77CC") ; <CJK>
       (?$(HiD(B . "0x77CE") ; <CJK>
       (?$(HiE(B . "0x77CF") ; <CJK>
       (?$(HiF(B . "0x77CD") ; <CJK>
       (?$(HiG(B . "0x77F2") ; <CJK>
       (?$(HiH(B . "0x7925") ; <CJK>
       (?$(HiI(B . "0x7923") ; <CJK>
       (?$(HiJ(B . "0x7927") ; <CJK>
       (?$(HiK(B . "0x7928") ; <CJK>
       (?$(HiL(B . "0x7924") ; <CJK>
       (?$(HiM(B . "0x7929") ; <CJK>
       (?$(HiN(B . "0x79B2") ; <CJK>
       (?$(HiO(B . "0x7A6E") ; <CJK>
       (?$(HiP(B . "0x7A6C") ; <CJK>
       (?$(HiQ(B . "0x7A6D") ; <CJK>
       (?$(HiR(B . "0x7AF7") ; <CJK>
       (?$(HiS(B . "0x7C49") ; <CJK>
       (?$(HiT(B . "0x7C48") ; <CJK>
       (?$(HiU(B . "0x7C4A") ; <CJK>
       (?$(HiV(B . "0x7C47") ; <CJK>
       (?$(HiW(B . "0x7C45") ; <CJK>
       (?$(HiX(B . "0x7CEE") ; <CJK>
       (?$(HiY(B . "0x7E7B") ; <CJK>
       (?$(HiZ(B . "0x7E7E") ; <CJK>
       (?$(Hi[(B . "0x7E81") ; <CJK>
       (?$(Hi\(B . "0x7E80") ; <CJK>
       (?$(Hi](B . "0x7FBA") ; <CJK>
       (?$(Hi^(B . "0x7FFF") ; <CJK>
       (?$(Hi_(B . "0x8079") ; <CJK>
       (?$(Hi`(B . "0x81DB") ; <CJK>
       (?$(Hia(B . "0x81D9") ; <CJK>
       (?$(Hib(B . "0x8268") ; <CJK>
       (?$(Hic(B . "0x8269") ; <CJK>
       (?$(Hid(B . "0x8622") ; <CJK>
       (?$(Hie(B . "0x85FF") ; <CJK>
       (?$(Hif(B . "0x8601") ; <CJK>
       (?$(Hig(B . "0x85FE") ; <CJK>
       (?$(Hih(B . "0x861B") ; <CJK>
       (?$(Hii(B . "0x8600") ; <CJK>
       (?$(Hij(B . "0x85F6") ; <CJK>
       (?$(Hik(B . "0x8604") ; <CJK>
       (?$(Hil(B . "0x8609") ; <CJK>
       (?$(Him(B . "0x8605") ; <CJK>
       (?$(Hin(B . "0x860C") ; <CJK>
       (?$(Hio(B . "0x85FD") ; <CJK>
       (?$(Hip(B . "0x8819") ; <CJK>
       (?$(Hiq(B . "0x8810") ; <CJK>
       (?$(Hir(B . "0x8811") ; <CJK>
       (?$(His(B . "0x8817") ; <CJK>
       (?$(Hit(B . "0x8813") ; <CJK>
       (?$(Hiu(B . "0x8816") ; <CJK>
       (?$(Hiv(B . "0x8963") ; <CJK>
       (?$(Hiw(B . "0x8966") ; <CJK>
       (?$(Hix(B . "0x89B9") ; <CJK>
       (?$(Hiy(B . "0x89F7") ; <CJK>
       (?$(Hiz(B . "0x8B60") ; <CJK>
       (?$(Hi{(B . "0x8B6A") ; <CJK>
       (?$(Hi|(B . "0x8B5D") ; <CJK>
       (?$(Hi}(B . "0x8B68") ; <CJK>
       (?$(Hi~(B . "0x8B63") ; <CJK>
       (?$(Hj!(B . "0x8B65") ; <CJK>
       (?$(Hj"(B . "0x8B67") ; <CJK>
       (?$(Hj#(B . "0x8B6D") ; <CJK>
       (?$(Hj$(B . "0x8DAE") ; <CJK>
       (?$(Hj%(B . "0x8E86") ; <CJK>
       (?$(Hj&(B . "0x8E88") ; <CJK>
       (?$(Hj'(B . "0x8E84") ; <CJK>
       (?$(Hj((B . "0x8F59") ; <CJK>
       (?$(Hj)(B . "0x8F56") ; <CJK>
       (?$(Hj*(B . "0x8F57") ; <CJK>
       (?$(Hj+(B . "0x8F55") ; <CJK>
       (?$(Hj,(B . "0x8F58") ; <CJK>
       (?$(Hj-(B . "0x8F5A") ; <CJK>
       (?$(Hj.(B . "0x908D") ; <CJK>
       (?$(Hj/(B . "0x9143") ; <CJK>
       (?$(Hj0(B . "0x9141") ; <CJK>
       (?$(Hj1(B . "0x91B7") ; <CJK>
       (?$(Hj2(B . "0x91B5") ; <CJK>
       (?$(Hj3(B . "0x91B2") ; <CJK>
       (?$(Hj4(B . "0x91B3") ; <CJK>
       (?$(Hj5(B . "0x940B") ; <CJK>
       (?$(Hj6(B . "0x9413") ; <CJK>
       (?$(Hj7(B . "0x93FB") ; <CJK>
       (?$(Hj8(B . "0x9420") ; <CJK>
       (?$(Hj9(B . "0x940F") ; <CJK>
       (?$(Hj:(B . "0x9414") ; <CJK>
       (?$(Hj;(B . "0x93FE") ; <CJK>
       (?$(Hj<(B . "0x9415") ; <CJK>
       (?$(Hj=(B . "0x9410") ; <CJK>
       (?$(Hj>(B . "0x9428") ; <CJK>
       (?$(Hj?(B . "0x9419") ; <CJK>
       (?$(Hj@(B . "0x940D") ; <CJK>
       (?$(HjA(B . "0x93F5") ; <CJK>
       (?$(HjB(B . "0x9400") ; <CJK>
       (?$(HjC(B . "0x93F7") ; <CJK>
       (?$(HjD(B . "0x9407") ; <CJK>
       (?$(HjE(B . "0x940E") ; <CJK>
       (?$(HjF(B . "0x9416") ; <CJK>
       (?$(HjG(B . "0x9412") ; <CJK>
       (?$(HjH(B . "0x93FA") ; <CJK>
       (?$(HjI(B . "0x9409") ; <CJK>
       (?$(HjJ(B . "0x93F8") ; <CJK>
       (?$(HjK(B . "0x943C") ; <CJK>
       (?$(HjL(B . "0x940A") ; <CJK>
       (?$(HjM(B . "0x93FF") ; <CJK>
       (?$(HjN(B . "0x93FC") ; <CJK>
       (?$(HjO(B . "0x940C") ; <CJK>
       (?$(HjP(B . "0x93F6") ; <CJK>
       (?$(HjQ(B . "0x9411") ; <CJK>
       (?$(HjR(B . "0x9406") ; <CJK>
       (?$(HjS(B . "0x95DE") ; <CJK>
       (?$(HjT(B . "0x95E0") ; <CJK>
       (?$(HjU(B . "0x95DF") ; <CJK>
       (?$(HjV(B . "0x972E") ; <CJK>
       (?$(HjW(B . "0x972F") ; <CJK>
       (?$(HjX(B . "0x97B9") ; <CJK>
       (?$(HjY(B . "0x97BB") ; <CJK>
       (?$(HjZ(B . "0x97FD") ; <CJK>
       (?$(Hj[(B . "0x97FE") ; <CJK>
       (?$(Hj\(B . "0x9860") ; <CJK>
       (?$(Hj](B . "0x9862") ; <CJK>
       (?$(Hj^(B . "0x9863") ; <CJK>
       (?$(Hj_(B . "0x985F") ; <CJK>
       (?$(Hj`(B . "0x98C1") ; <CJK>
       (?$(Hja(B . "0x98C2") ; <CJK>
       (?$(Hjb(B . "0x9950") ; <CJK>
       (?$(Hjc(B . "0x994E") ; <CJK>
       (?$(Hjd(B . "0x9959") ; <CJK>
       (?$(Hje(B . "0x994C") ; <CJK>
       (?$(Hjf(B . "0x994B") ; <CJK>
       (?$(Hjg(B . "0x9953") ; <CJK>
       (?$(Hjh(B . "0x9A32") ; <CJK>
       (?$(Hji(B . "0x9A34") ; <CJK>
       (?$(Hjj(B . "0x9A31") ; <CJK>
       (?$(Hjk(B . "0x9A2C") ; <CJK>
       (?$(Hjl(B . "0x9A2A") ; <CJK>
       (?$(Hjm(B . "0x9A36") ; <CJK>
       (?$(Hjn(B . "0x9A29") ; <CJK>
       (?$(Hjo(B . "0x9A2E") ; <CJK>
       (?$(Hjp(B . "0x9A38") ; <CJK>
       (?$(Hjq(B . "0x9A2D") ; <CJK>
       (?$(Hjr(B . "0x9AC7") ; <CJK>
       (?$(Hjs(B . "0x9ACA") ; <CJK>
       (?$(Hjt(B . "0x9AC6") ; <CJK>
       (?$(Hju(B . "0x9B10") ; <CJK>
       (?$(Hjv(B . "0x9B12") ; <CJK>
       (?$(Hjw(B . "0x9B11") ; <CJK>
       (?$(Hjx(B . "0x9C0B") ; <CJK>
       (?$(Hjy(B . "0x9C08") ; <CJK>
       (?$(Hjz(B . "0x9BF7") ; <CJK>
       (?$(Hj{(B . "0x9C05") ; <CJK>
       (?$(Hj|(B . "0x9C12") ; <CJK>
       (?$(Hj}(B . "0x9BF8") ; <CJK>
       (?$(Hj~(B . "0x9C40") ; <CJK>
       (?$(Hk!(B . "0x9C07") ; <CJK>
       (?$(Hk"(B . "0x9C0E") ; <CJK>
       (?$(Hk#(B . "0x9C06") ; <CJK>
       (?$(Hk$(B . "0x9C17") ; <CJK>
       (?$(Hk%(B . "0x9C14") ; <CJK>
       (?$(Hk&(B . "0x9C09") ; <CJK>
       (?$(Hk'(B . "0x9D9F") ; <CJK>
       (?$(Hk((B . "0x9D99") ; <CJK>
       (?$(Hk)(B . "0x9DA4") ; <CJK>
       (?$(Hk*(B . "0x9D9D") ; <CJK>
       (?$(Hk+(B . "0x9D92") ; <CJK>
       (?$(Hk,(B . "0x9D98") ; <CJK>
       (?$(Hk-(B . "0x9D90") ; <CJK>
       (?$(Hk.(B . "0x9D9B") ; <CJK>
       (?$(Hk/(B . "0x9DA0") ; <CJK>
       (?$(Hk0(B . "0x9D94") ; <CJK>
       (?$(Hk1(B . "0x9D9C") ; <CJK>
       (?$(Hk2(B . "0x9DAA") ; <CJK>
       (?$(Hk3(B . "0x9D97") ; <CJK>
       (?$(Hk4(B . "0x9DA1") ; <CJK>
       (?$(Hk5(B . "0x9D9A") ; <CJK>
       (?$(Hk6(B . "0x9DA2") ; <CJK>
       (?$(Hk7(B . "0x9DA8") ; <CJK>
       (?$(Hk8(B . "0x9D9E") ; <CJK>
       (?$(Hk9(B . "0x9DA3") ; <CJK>
       (?$(Hk:(B . "0x9DBF") ; <CJK>
       (?$(Hk;(B . "0x9DA9") ; <CJK>
       (?$(Hk<(B . "0x9D96") ; <CJK>
       (?$(Hk=(B . "0x9DA6") ; <CJK>
       (?$(Hk>(B . "0x9DA7") ; <CJK>
       (?$(Hk?(B . "0x9E99") ; <CJK>
       (?$(Hk@(B . "0x9E9B") ; <CJK>
       (?$(HkA(B . "0x9E9A") ; <CJK>
       (?$(HkB(B . "0x9EE5") ; <CJK>
       (?$(HkC(B . "0x9EE4") ; <CJK>
       (?$(HkD(B . "0x9EE7") ; <CJK>
       (?$(HkE(B . "0x9EE6") ; <CJK>
       (?$(HkF(B . "0x9F30") ; <CJK>
       (?$(HkG(B . "0x9F2E") ; <CJK>
       (?$(HkH(B . "0x9F5B") ; <CJK>
       (?$(HkI(B . "0x9F60") ; <CJK>
       (?$(HkJ(B . "0x9F5E") ; <CJK>
       (?$(HkK(B . "0x9F5D") ; <CJK>
       (?$(HkL(B . "0x9F59") ; <CJK>
       (?$(HkM(B . "0x9F91") ; <CJK>
       (?$(HkN(B . "0x513A") ; <CJK>
       (?$(HkO(B . "0x5139") ; <CJK>
       (?$(HkP(B . "0x5298") ; <CJK>
       (?$(HkQ(B . "0x5297") ; <CJK>
       (?$(HkR(B . "0x56C3") ; <CJK>
       (?$(HkS(B . "0x56BD") ; <CJK>
       (?$(HkT(B . "0x56BE") ; <CJK>
       (?$(HkU(B . "0x5B48") ; <CJK>
       (?$(HkV(B . "0x5B47") ; <CJK>
       (?$(HkW(B . "0x5DCB") ; <CJK>
       (?$(HkX(B . "0x5DCF") ; <CJK>
       (?$(HkY(B . "0x5EF1") ; <CJK>
       (?$(HkZ(B . "0x61FD") ; <CJK>
       (?$(Hk[(B . "0x651B") ; <CJK>
       (?$(Hk\(B . "0x6B02") ; <CJK>
       (?$(Hk](B . "0x6AFC") ; <CJK>
       (?$(Hk^(B . "0x6B03") ; <CJK>
       (?$(Hk_(B . "0x6AF8") ; <CJK>
       (?$(Hk`(B . "0x6B00") ; <CJK>
       (?$(Hka(B . "0x7043") ; <CJK>
       (?$(Hkb(B . "0x7044") ; <CJK>
       (?$(Hkc(B . "0x704A") ; <CJK>
       (?$(Hkd(B . "0x7048") ; <CJK>
       (?$(Hke(B . "0x7049") ; <CJK>
       (?$(Hkf(B . "0x7045") ; <CJK>
       (?$(Hkg(B . "0x7046") ; <CJK>
       (?$(Hkh(B . "0x721D") ; <CJK>
       (?$(Hki(B . "0x721A") ; <CJK>
       (?$(Hkj(B . "0x7219") ; <CJK>
       (?$(Hkk(B . "0x737E") ; <CJK>
       (?$(Hkl(B . "0x7517") ; <CJK>
       (?$(Hkm(B . "0x766A") ; <CJK>
       (?$(Hkn(B . "0x77D0") ; <CJK>
       (?$(Hko(B . "0x792D") ; <CJK>
       (?$(Hkp(B . "0x7931") ; <CJK>
       (?$(Hkq(B . "0x792F") ; <CJK>
       (?$(Hkr(B . "0x7C54") ; <CJK>
       (?$(Hks(B . "0x7C53") ; <CJK>
       (?$(Hkt(B . "0x7CF2") ; <CJK>
       (?$(Hku(B . "0x7E8A") ; <CJK>
       (?$(Hkv(B . "0x7E87") ; <CJK>
       (?$(Hkw(B . "0x7E88") ; <CJK>
       (?$(Hkx(B . "0x7E8B") ; <CJK>
       (?$(Hky(B . "0x7E86") ; <CJK>
       (?$(Hkz(B . "0x7E8D") ; <CJK>
       (?$(Hk{(B . "0x7F4D") ; <CJK>
       (?$(Hk|(B . "0x7FBB") ; <CJK>
       (?$(Hk}(B . "0x8030") ; <CJK>
       (?$(Hk~(B . "0x81DD") ; <CJK>
       (?$(Hl!(B . "0x8618") ; <CJK>
       (?$(Hl"(B . "0x862A") ; <CJK>
       (?$(Hl#(B . "0x8626") ; <CJK>
       (?$(Hl$(B . "0x861F") ; <CJK>
       (?$(Hl%(B . "0x8623") ; <CJK>
       (?$(Hl&(B . "0x861C") ; <CJK>
       (?$(Hl'(B . "0x8619") ; <CJK>
       (?$(Hl((B . "0x8627") ; <CJK>
       (?$(Hl)(B . "0x862E") ; <CJK>
       (?$(Hl*(B . "0x8621") ; <CJK>
       (?$(Hl+(B . "0x8620") ; <CJK>
       (?$(Hl,(B . "0x8629") ; <CJK>
       (?$(Hl-(B . "0x861E") ; <CJK>
       (?$(Hl.(B . "0x8625") ; <CJK>
       (?$(Hl/(B . "0x8829") ; <CJK>
       (?$(Hl0(B . "0x881D") ; <CJK>
       (?$(Hl1(B . "0x881B") ; <CJK>
       (?$(Hl2(B . "0x8820") ; <CJK>
       (?$(Hl3(B . "0x8824") ; <CJK>
       (?$(Hl4(B . "0x881C") ; <CJK>
       (?$(Hl5(B . "0x882B") ; <CJK>
       (?$(Hl6(B . "0x884A") ; <CJK>
       (?$(Hl7(B . "0x896D") ; <CJK>
       (?$(Hl8(B . "0x8969") ; <CJK>
       (?$(Hl9(B . "0x896E") ; <CJK>
       (?$(Hl:(B . "0x896B") ; <CJK>
       (?$(Hl;(B . "0x89FA") ; <CJK>
       (?$(Hl<(B . "0x8B79") ; <CJK>
       (?$(Hl=(B . "0x8B78") ; <CJK>
       (?$(Hl>(B . "0x8B45") ; <CJK>
       (?$(Hl?(B . "0x8B7A") ; <CJK>
       (?$(Hl@(B . "0x8B7B") ; <CJK>
       (?$(HlA(B . "0x8D10") ; <CJK>
       (?$(HlB(B . "0x8D14") ; <CJK>
       (?$(HlC(B . "0x8DAF") ; <CJK>
       (?$(HlD(B . "0x8E8E") ; <CJK>
       (?$(HlE(B . "0x8E8C") ; <CJK>
       (?$(HlF(B . "0x8F5E") ; <CJK>
       (?$(HlG(B . "0x8F5B") ; <CJK>
       (?$(HlH(B . "0x8F5D") ; <CJK>
       (?$(HlI(B . "0x9146") ; <CJK>
       (?$(HlJ(B . "0x9144") ; <CJK>
       (?$(HlK(B . "0x9145") ; <CJK>
       (?$(HlL(B . "0x91B9") ; <CJK>
       (?$(HlM(B . "0x943F") ; <CJK>
       (?$(HlN(B . "0x943B") ; <CJK>
       (?$(HlO(B . "0x9436") ; <CJK>
       (?$(HlP(B . "0x9429") ; <CJK>
       (?$(HlQ(B . "0x943D") ; <CJK>
       (?$(HlR(B . "0x9430") ; <CJK>
       (?$(HlS(B . "0x9439") ; <CJK>
       (?$(HlT(B . "0x942A") ; <CJK>
       (?$(HlU(B . "0x9437") ; <CJK>
       (?$(HlV(B . "0x942C") ; <CJK>
       (?$(HlW(B . "0x9440") ; <CJK>
       (?$(HlX(B . "0x9431") ; <CJK>
       (?$(HlY(B . "0x95E5") ; <CJK>
       (?$(HlZ(B . "0x95E4") ; <CJK>
       (?$(Hl[(B . "0x95E3") ; <CJK>
       (?$(Hl\(B . "0x9735") ; <CJK>
       (?$(Hl](B . "0x973A") ; <CJK>
       (?$(Hl^(B . "0x97BF") ; <CJK>
       (?$(Hl_(B . "0x97E1") ; <CJK>
       (?$(Hl`(B . "0x9864") ; <CJK>
       (?$(Hla(B . "0x98C9") ; <CJK>
       (?$(Hlb(B . "0x98C6") ; <CJK>
       (?$(Hlc(B . "0x98C0") ; <CJK>
       (?$(Hld(B . "0x9958") ; <CJK>
       (?$(Hle(B . "0x9956") ; <CJK>
       (?$(Hlf(B . "0x9A39") ; <CJK>
       (?$(Hlg(B . "0x9A3D") ; <CJK>
       (?$(Hlh(B . "0x9A46") ; <CJK>
       (?$(Hli(B . "0x9A44") ; <CJK>
       (?$(Hlj(B . "0x9A42") ; <CJK>
       (?$(Hlk(B . "0x9A41") ; <CJK>
       (?$(Hll(B . "0x9A3A") ; <CJK>
       (?$(Hlm(B . "0x9A3F") ; <CJK>
       (?$(Hln(B . "0x9ACD") ; <CJK>
       (?$(Hlo(B . "0x9B15") ; <CJK>
       (?$(Hlp(B . "0x9B17") ; <CJK>
       (?$(Hlq(B . "0x9B18") ; <CJK>
       (?$(Hlr(B . "0x9B16") ; <CJK>
       (?$(Hls(B . "0x9B3A") ; <CJK>
       (?$(Hlt(B . "0x9B52") ; <CJK>
       (?$(Hlu(B . "0x9C2B") ; <CJK>
       (?$(Hlv(B . "0x9C1D") ; <CJK>
       (?$(Hlw(B . "0x9C1C") ; <CJK>
       (?$(Hlx(B . "0x9C2C") ; <CJK>
       (?$(Hly(B . "0x9C23") ; <CJK>
       (?$(Hlz(B . "0x9C28") ; <CJK>
       (?$(Hl{(B . "0x9C29") ; <CJK>
       (?$(Hl|(B . "0x9C24") ; <CJK>
       (?$(Hl}(B . "0x9C21") ; <CJK>
       (?$(Hl~(B . "0x9DB7") ; <CJK>
       (?$(Hm!(B . "0x9DB6") ; <CJK>
       (?$(Hm"(B . "0x9DBC") ; <CJK>
       (?$(Hm#(B . "0x9DC1") ; <CJK>
       (?$(Hm$(B . "0x9DC7") ; <CJK>
       (?$(Hm%(B . "0x9DCA") ; <CJK>
       (?$(Hm&(B . "0x9DCF") ; <CJK>
       (?$(Hm'(B . "0x9DBE") ; <CJK>
       (?$(Hm((B . "0x9DC5") ; <CJK>
       (?$(Hm)(B . "0x9DC3") ; <CJK>
       (?$(Hm*(B . "0x9DBB") ; <CJK>
       (?$(Hm+(B . "0x9DB5") ; <CJK>
       (?$(Hm,(B . "0x9DCE") ; <CJK>
       (?$(Hm-(B . "0x9DB9") ; <CJK>
       (?$(Hm.(B . "0x9DBA") ; <CJK>
       (?$(Hm/(B . "0x9DAC") ; <CJK>
       (?$(Hm0(B . "0x9DC8") ; <CJK>
       (?$(Hm1(B . "0x9DB1") ; <CJK>
       (?$(Hm2(B . "0x9DAD") ; <CJK>
       (?$(Hm3(B . "0x9DCC") ; <CJK>
       (?$(Hm4(B . "0x9DB3") ; <CJK>
       (?$(Hm5(B . "0x9DCD") ; <CJK>
       (?$(Hm6(B . "0x9DB2") ; <CJK>
       (?$(Hm7(B . "0x9E7A") ; <CJK>
       (?$(Hm8(B . "0x9E9C") ; <CJK>
       (?$(Hm9(B . "0x9EEB") ; <CJK>
       (?$(Hm:(B . "0x9EEE") ; <CJK>
       (?$(Hm;(B . "0x9EED") ; <CJK>
       (?$(Hm<(B . "0x9F1B") ; <CJK>
       (?$(Hm=(B . "0x9F18") ; <CJK>
       (?$(Hm>(B . "0x9F1A") ; <CJK>
       (?$(Hm?(B . "0x9F31") ; <CJK>
       (?$(Hm@(B . "0x9F4E") ; <CJK>
       (?$(HmA(B . "0x9F65") ; <CJK>
       (?$(HmB(B . "0x9F64") ; <CJK>
       (?$(HmC(B . "0x9F92") ; <CJK>
       (?$(HmD(B . "0x4EB9") ; <CJK>
       (?$(HmE(B . "0x56C6") ; <CJK>
       (?$(HmF(B . "0x56C5") ; <CJK>
       (?$(HmG(B . "0x56CB") ; <CJK>
       (?$(HmH(B . "0x5971") ; <CJK>
       (?$(HmI(B . "0x5B4B") ; <CJK>
       (?$(HmJ(B . "0x5B4C") ; <CJK>
       (?$(HmK(B . "0x5DD5") ; <CJK>
       (?$(HmL(B . "0x5DD1") ; <CJK>
       (?$(HmM(B . "0x5EF2") ; <CJK>
       (?$(HmN(B . "0x6521") ; <CJK>
       (?$(HmO(B . "0x6520") ; <CJK>
       (?$(HmP(B . "0x6526") ; <CJK>
       (?$(HmQ(B . "0x6522") ; <CJK>
       (?$(HmR(B . "0x6B0B") ; <CJK>
       (?$(HmS(B . "0x6B08") ; <CJK>
       (?$(HmT(B . "0x6B09") ; <CJK>
       (?$(HmU(B . "0x6C0D") ; <CJK>
       (?$(HmV(B . "0x7055") ; <CJK>
       (?$(HmW(B . "0x7056") ; <CJK>
       (?$(HmX(B . "0x7057") ; <CJK>
       (?$(HmY(B . "0x7052") ; <CJK>
       (?$(HmZ(B . "0x721E") ; <CJK>
       (?$(Hm[(B . "0x721F") ; <CJK>
       (?$(Hm\(B . "0x72A9") ; <CJK>
       (?$(Hm](B . "0x737F") ; <CJK>
       (?$(Hm^(B . "0x74D8") ; <CJK>
       (?$(Hm_(B . "0x74D5") ; <CJK>
       (?$(Hm`(B . "0x74D9") ; <CJK>
       (?$(Hma(B . "0x74D7") ; <CJK>
       (?$(Hmb(B . "0x766D") ; <CJK>
       (?$(Hmc(B . "0x76AD") ; <CJK>
       (?$(Hmd(B . "0x7935") ; <CJK>
       (?$(Hme(B . "0x79B4") ; <CJK>
       (?$(Hmf(B . "0x7A70") ; <CJK>
       (?$(Hmg(B . "0x7A71") ; <CJK>
       (?$(Hmh(B . "0x7C57") ; <CJK>
       (?$(Hmi(B . "0x7C5C") ; <CJK>
       (?$(Hmj(B . "0x7C59") ; <CJK>
       (?$(Hmk(B . "0x7C5B") ; <CJK>
       (?$(Hml(B . "0x7C5A") ; <CJK>
       (?$(Hmm(B . "0x7CF4") ; <CJK>
       (?$(Hmn(B . "0x7CF1") ; <CJK>
       (?$(Hmo(B . "0x7E91") ; <CJK>
       (?$(Hmp(B . "0x7F4F") ; <CJK>
       (?$(Hmq(B . "0x7F87") ; <CJK>
       (?$(Hmr(B . "0x81DE") ; <CJK>
       (?$(Hms(B . "0x826B") ; <CJK>
       (?$(Hmt(B . "0x8634") ; <CJK>
       (?$(Hmu(B . "0x8635") ; <CJK>
       (?$(Hmv(B . "0x8633") ; <CJK>
       (?$(Hmw(B . "0x862C") ; <CJK>
       (?$(Hmx(B . "0x8632") ; <CJK>
       (?$(Hmy(B . "0x8636") ; <CJK>
       (?$(Hmz(B . "0x882C") ; <CJK>
       (?$(Hm{(B . "0x8828") ; <CJK>
       (?$(Hm|(B . "0x8826") ; <CJK>
       (?$(Hm}(B . "0x882A") ; <CJK>
       (?$(Hm~(B . "0x8825") ; <CJK>
       (?$(Hn!(B . "0x8971") ; <CJK>
       (?$(Hn"(B . "0x89BF") ; <CJK>
       (?$(Hn#(B . "0x89BE") ; <CJK>
       (?$(Hn$(B . "0x89FB") ; <CJK>
       (?$(Hn%(B . "0x8B7E") ; <CJK>
       (?$(Hn&(B . "0x8B84") ; <CJK>
       (?$(Hn'(B . "0x8B82") ; <CJK>
       (?$(Hn((B . "0x8B86") ; <CJK>
       (?$(Hn)(B . "0x8B85") ; <CJK>
       (?$(Hn*(B . "0x8B7F") ; <CJK>
       (?$(Hn+(B . "0x8D15") ; <CJK>
       (?$(Hn,(B . "0x8E95") ; <CJK>
       (?$(Hn-(B . "0x8E94") ; <CJK>
       (?$(Hn.(B . "0x8E9A") ; <CJK>
       (?$(Hn/(B . "0x8E92") ; <CJK>
       (?$(Hn0(B . "0x8E90") ; <CJK>
       (?$(Hn1(B . "0x8E96") ; <CJK>
       (?$(Hn2(B . "0x8E97") ; <CJK>
       (?$(Hn3(B . "0x8F60") ; <CJK>
       (?$(Hn4(B . "0x8F62") ; <CJK>
       (?$(Hn5(B . "0x9147") ; <CJK>
       (?$(Hn6(B . "0x944C") ; <CJK>
       (?$(Hn7(B . "0x9450") ; <CJK>
       (?$(Hn8(B . "0x944A") ; <CJK>
       (?$(Hn9(B . "0x944B") ; <CJK>
       (?$(Hn:(B . "0x944F") ; <CJK>
       (?$(Hn;(B . "0x9447") ; <CJK>
       (?$(Hn<(B . "0x9445") ; <CJK>
       (?$(Hn=(B . "0x9448") ; <CJK>
       (?$(Hn>(B . "0x9449") ; <CJK>
       (?$(Hn?(B . "0x9446") ; <CJK>
       (?$(Hn@(B . "0x973F") ; <CJK>
       (?$(HnA(B . "0x97E3") ; <CJK>
       (?$(HnB(B . "0x986A") ; <CJK>
       (?$(HnC(B . "0x9869") ; <CJK>
       (?$(HnD(B . "0x98CB") ; <CJK>
       (?$(HnE(B . "0x9954") ; <CJK>
       (?$(HnF(B . "0x995B") ; <CJK>
       (?$(HnG(B . "0x9A4E") ; <CJK>
       (?$(HnH(B . "0x9A53") ; <CJK>
       (?$(HnI(B . "0x9A54") ; <CJK>
       (?$(HnJ(B . "0x9A4C") ; <CJK>
       (?$(HnK(B . "0x9A4F") ; <CJK>
       (?$(HnL(B . "0x9A48") ; <CJK>
       (?$(HnM(B . "0x9A4A") ; <CJK>
       (?$(HnN(B . "0x9A49") ; <CJK>
       (?$(HnO(B . "0x9A52") ; <CJK>
       (?$(HnP(B . "0x9A50") ; <CJK>
       (?$(HnQ(B . "0x9AD0") ; <CJK>
       (?$(HnR(B . "0x9B19") ; <CJK>
       (?$(HnS(B . "0x9B2B") ; <CJK>
       (?$(HnT(B . "0x9B3B") ; <CJK>
       (?$(HnU(B . "0x9B56") ; <CJK>
       (?$(HnV(B . "0x9B55") ; <CJK>
       (?$(HnW(B . "0x9C46") ; <CJK>
       (?$(HnX(B . "0x9C48") ; <CJK>
       (?$(HnY(B . "0x9C3F") ; <CJK>
       (?$(HnZ(B . "0x9C44") ; <CJK>
       (?$(Hn[(B . "0x9C39") ; <CJK>
       (?$(Hn\(B . "0x9C33") ; <CJK>
       (?$(Hn](B . "0x9C41") ; <CJK>
       (?$(Hn^(B . "0x9C3C") ; <CJK>
       (?$(Hn_(B . "0x9C37") ; <CJK>
       (?$(Hn`(B . "0x9C34") ; <CJK>
       (?$(Hna(B . "0x9C32") ; <CJK>
       (?$(Hnb(B . "0x9C3D") ; <CJK>
       (?$(Hnc(B . "0x9C36") ; <CJK>
       (?$(Hnd(B . "0x9DDB") ; <CJK>
       (?$(Hne(B . "0x9DD2") ; <CJK>
       (?$(Hnf(B . "0x9DDE") ; <CJK>
       (?$(Hng(B . "0x9DDA") ; <CJK>
       (?$(Hnh(B . "0x9DCB") ; <CJK>
       (?$(Hni(B . "0x9DD0") ; <CJK>
       (?$(Hnj(B . "0x9DDC") ; <CJK>
       (?$(Hnk(B . "0x9DD1") ; <CJK>
       (?$(Hnl(B . "0x9DDF") ; <CJK>
       (?$(Hnm(B . "0x9DE9") ; <CJK>
       (?$(Hnn(B . "0x9DD9") ; <CJK>
       (?$(Hno(B . "0x9DD8") ; <CJK>
       (?$(Hnp(B . "0x9DD6") ; <CJK>
       (?$(Hnq(B . "0x9DF5") ; <CJK>
       (?$(Hnr(B . "0x9DD5") ; <CJK>
       (?$(Hns(B . "0x9DDD") ; <CJK>
       (?$(Hnt(B . "0x9EB6") ; <CJK>
       (?$(Hnu(B . "0x9EF0") ; <CJK>
       (?$(Hnv(B . "0x9F35") ; <CJK>
       (?$(Hnw(B . "0x9F33") ; <CJK>
       (?$(Hnx(B . "0x9F32") ; <CJK>
       (?$(Hny(B . "0x9F42") ; <CJK>
       (?$(Hnz(B . "0x9F6B") ; <CJK>
       (?$(Hn{(B . "0x9F95") ; <CJK>
       (?$(Hn|(B . "0x9FA2") ; <CJK>
       (?$(Hn}(B . "0x513D") ; <CJK>
       (?$(Hn~(B . "0x5299") ; <CJK>
       (?$(Ho!(B . "0x58E8") ; <CJK>
       (?$(Ho"(B . "0x58E7") ; <CJK>
       (?$(Ho#(B . "0x5972") ; <CJK>
       (?$(Ho$(B . "0x5B4D") ; <CJK>
       (?$(Ho%(B . "0x5DD8") ; <CJK>
       (?$(Ho&(B . "0x882F") ; <CJK>
       (?$(Ho'(B . "0x5F4F") ; <CJK>
       (?$(Ho((B . "0x6201") ; <CJK>
       (?$(Ho)(B . "0x6203") ; <CJK>
       (?$(Ho*(B . "0x6204") ; <CJK>
       (?$(Ho+(B . "0x6529") ; <CJK>
       (?$(Ho,(B . "0x6525") ; <CJK>
       (?$(Ho-(B . "0x6596") ; <CJK>
       (?$(Ho.(B . "0x66EB") ; <CJK>
       (?$(Ho/(B . "0x6B11") ; <CJK>
       (?$(Ho0(B . "0x6B12") ; <CJK>
       (?$(Ho1(B . "0x6B0F") ; <CJK>
       (?$(Ho2(B . "0x6BCA") ; <CJK>
       (?$(Ho3(B . "0x705B") ; <CJK>
       (?$(Ho4(B . "0x705A") ; <CJK>
       (?$(Ho5(B . "0x7222") ; <CJK>
       (?$(Ho6(B . "0x7382") ; <CJK>
       (?$(Ho7(B . "0x7381") ; <CJK>
       (?$(Ho8(B . "0x7383") ; <CJK>
       (?$(Ho9(B . "0x7670") ; <CJK>
       (?$(Ho:(B . "0x77D4") ; <CJK>
       (?$(Ho;(B . "0x7C67") ; <CJK>
       (?$(Ho<(B . "0x7C66") ; <CJK>
       (?$(Ho=(B . "0x7E95") ; <CJK>
       (?$(Ho>(B . "0x826C") ; <CJK>
       (?$(Ho?(B . "0x863A") ; <CJK>
       (?$(Ho@(B . "0x8640") ; <CJK>
       (?$(HoA(B . "0x8639") ; <CJK>
       (?$(HoB(B . "0x863C") ; <CJK>
       (?$(HoC(B . "0x8631") ; <CJK>
       (?$(HoD(B . "0x863B") ; <CJK>
       (?$(HoE(B . "0x863E") ; <CJK>
       (?$(HoF(B . "0x8830") ; <CJK>
       (?$(HoG(B . "0x8832") ; <CJK>
       (?$(HoH(B . "0x882E") ; <CJK>
       (?$(HoI(B . "0x8833") ; <CJK>
       (?$(HoJ(B . "0x8976") ; <CJK>
       (?$(HoK(B . "0x8974") ; <CJK>
       (?$(HoL(B . "0x8973") ; <CJK>
       (?$(HoM(B . "0x89FE") ; <CJK>
       (?$(HoN(B . "0x8B8C") ; <CJK>
       (?$(HoO(B . "0x8B8E") ; <CJK>
       (?$(HoP(B . "0x8B8B") ; <CJK>
       (?$(HoQ(B . "0x8B88") ; <CJK>
       (?$(HoR(B . "0x8C45") ; <CJK>
       (?$(HoS(B . "0x8D19") ; <CJK>
       (?$(HoT(B . "0x8E98") ; <CJK>
       (?$(HoU(B . "0x8F64") ; <CJK>
       (?$(HoV(B . "0x8F63") ; <CJK>
       (?$(HoW(B . "0x91BC") ; <CJK>
       (?$(HoX(B . "0x9462") ; <CJK>
       (?$(HoY(B . "0x9455") ; <CJK>
       (?$(HoZ(B . "0x945D") ; <CJK>
       (?$(Ho[(B . "0x9457") ; <CJK>
       (?$(Ho\(B . "0x945E") ; <CJK>
       (?$(Ho](B . "0x97C4") ; <CJK>
       (?$(Ho^(B . "0x97C5") ; <CJK>
       (?$(Ho_(B . "0x9800") ; <CJK>
       (?$(Ho`(B . "0x9A56") ; <CJK>
       (?$(Hoa(B . "0x9A59") ; <CJK>
       (?$(Hob(B . "0x9B1E") ; <CJK>
       (?$(Hoc(B . "0x9B1F") ; <CJK>
       (?$(Hod(B . "0x9B20") ; <CJK>
       (?$(Hoe(B . "0x9C52") ; <CJK>
       (?$(Hof(B . "0x9C58") ; <CJK>
       (?$(Hog(B . "0x9C50") ; <CJK>
       (?$(Hoh(B . "0x9C4A") ; <CJK>
       (?$(Hoi(B . "0x9C4D") ; <CJK>
       (?$(Hoj(B . "0x9C4B") ; <CJK>
       (?$(Hok(B . "0x9C55") ; <CJK>
       (?$(Hol(B . "0x9C59") ; <CJK>
       (?$(Hom(B . "0x9C4C") ; <CJK>
       (?$(Hon(B . "0x9C4E") ; <CJK>
       (?$(Hoo(B . "0x9DFB") ; <CJK>
       (?$(Hop(B . "0x9DF7") ; <CJK>
       (?$(Hoq(B . "0x9DEF") ; <CJK>
       (?$(Hor(B . "0x9DE3") ; <CJK>
       (?$(Hos(B . "0x9DEB") ; <CJK>
       (?$(Hot(B . "0x9DF8") ; <CJK>
       (?$(Hou(B . "0x9DE4") ; <CJK>
       (?$(Hov(B . "0x9DF6") ; <CJK>
       (?$(How(B . "0x9DE1") ; <CJK>
       (?$(Hox(B . "0x9DEE") ; <CJK>
       (?$(Hoy(B . "0x9DE6") ; <CJK>
       (?$(Hoz(B . "0x9DF2") ; <CJK>
       (?$(Ho{(B . "0x9DF0") ; <CJK>
       (?$(Ho|(B . "0x9DE2") ; <CJK>
       (?$(Ho}(B . "0x9DEC") ; <CJK>
       (?$(Ho~(B . "0x9DF4") ; <CJK>
       (?$(Hp!(B . "0x9DF3") ; <CJK>
       (?$(Hp"(B . "0x9DE8") ; <CJK>
       (?$(Hp#(B . "0x9DED") ; <CJK>
       (?$(Hp$(B . "0x9EC2") ; <CJK>
       (?$(Hp%(B . "0x9ED0") ; <CJK>
       (?$(Hp&(B . "0x9EF2") ; <CJK>
       (?$(Hp'(B . "0x9EF3") ; <CJK>
       (?$(Hp((B . "0x9F06") ; <CJK>
       (?$(Hp)(B . "0x9F1C") ; <CJK>
       (?$(Hp*(B . "0x9F38") ; <CJK>
       (?$(Hp+(B . "0x9F37") ; <CJK>
       (?$(Hp,(B . "0x9F36") ; <CJK>
       (?$(Hp-(B . "0x9F43") ; <CJK>
       (?$(Hp.(B . "0x9F4F") ; <CJK>
       (?$(Hp/(B . "0x9F71") ; <CJK>
       (?$(Hp0(B . "0x9F70") ; <CJK>
       (?$(Hp1(B . "0x9F6E") ; <CJK>
       (?$(Hp2(B . "0x9F6F") ; <CJK>
       (?$(Hp3(B . "0x56D3") ; <CJK>
       (?$(Hp4(B . "0x56CD") ; <CJK>
       (?$(Hp5(B . "0x5B4E") ; <CJK>
       (?$(Hp6(B . "0x5C6D") ; <CJK>
       (?$(Hp7(B . "0x652D") ; <CJK>
       (?$(Hp8(B . "0x66ED") ; <CJK>
       (?$(Hp9(B . "0x66EE") ; <CJK>
       (?$(Hp:(B . "0x6B13") ; <CJK>
       (?$(Hp;(B . "0x705F") ; <CJK>
       (?$(Hp<(B . "0x7061") ; <CJK>
       (?$(Hp=(B . "0x705D") ; <CJK>
       (?$(Hp>(B . "0x7060") ; <CJK>
       (?$(Hp?(B . "0x7223") ; <CJK>
       (?$(Hp@(B . "0x74DB") ; <CJK>
       (?$(HpA(B . "0x74E5") ; <CJK>
       (?$(HpB(B . "0x77D5") ; <CJK>
       (?$(HpC(B . "0x7938") ; <CJK>
       (?$(HpD(B . "0x79B7") ; <CJK>
       (?$(HpE(B . "0x79B6") ; <CJK>
       (?$(HpF(B . "0x7C6A") ; <CJK>
       (?$(HpG(B . "0x7E97") ; <CJK>
       (?$(HpH(B . "0x7F89") ; <CJK>
       (?$(HpI(B . "0x826D") ; <CJK>
       (?$(HpJ(B . "0x8643") ; <CJK>
       (?$(HpK(B . "0x8838") ; <CJK>
       (?$(HpL(B . "0x8837") ; <CJK>
       (?$(HpM(B . "0x8835") ; <CJK>
       (?$(HpN(B . "0x884B") ; <CJK>
       (?$(HpO(B . "0x8B94") ; <CJK>
       (?$(HpP(B . "0x8B95") ; <CJK>
       (?$(HpQ(B . "0x8E9E") ; <CJK>
       (?$(HpR(B . "0x8E9F") ; <CJK>
       (?$(HpS(B . "0x8EA0") ; <CJK>
       (?$(HpT(B . "0x8E9D") ; <CJK>
       (?$(HpU(B . "0x91BE") ; <CJK>
       (?$(HpV(B . "0x91BD") ; <CJK>
       (?$(HpW(B . "0x91C2") ; <CJK>
       (?$(HpX(B . "0x946B") ; <CJK>
       (?$(HpY(B . "0x9468") ; <CJK>
       (?$(HpZ(B . "0x9469") ; <CJK>
       (?$(Hp[(B . "0x96E5") ; <CJK>
       (?$(Hp\(B . "0x9746") ; <CJK>
       (?$(Hp](B . "0x9743") ; <CJK>
       (?$(Hp^(B . "0x9747") ; <CJK>
       (?$(Hp_(B . "0x97C7") ; <CJK>
       (?$(Hp`(B . "0x97E5") ; <CJK>
       (?$(Hpa(B . "0x9A5E") ; <CJK>
       (?$(Hpb(B . "0x9AD5") ; <CJK>
       (?$(Hpc(B . "0x9B59") ; <CJK>
       (?$(Hpd(B . "0x9C63") ; <CJK>
       (?$(Hpe(B . "0x9C67") ; <CJK>
       (?$(Hpf(B . "0x9C66") ; <CJK>
       (?$(Hpg(B . "0x9C62") ; <CJK>
       (?$(Hph(B . "0x9C5E") ; <CJK>
       (?$(Hpi(B . "0x9C60") ; <CJK>
       (?$(Hpj(B . "0x9E02") ; <CJK>
       (?$(Hpk(B . "0x9DFE") ; <CJK>
       (?$(Hpl(B . "0x9E07") ; <CJK>
       (?$(Hpm(B . "0x9E03") ; <CJK>
       (?$(Hpn(B . "0x9E06") ; <CJK>
       (?$(Hpo(B . "0x9E05") ; <CJK>
       (?$(Hpp(B . "0x9E00") ; <CJK>
       (?$(Hpq(B . "0x9E01") ; <CJK>
       (?$(Hpr(B . "0x9E09") ; <CJK>
       (?$(Hps(B . "0x9DFF") ; <CJK>
       (?$(Hpt(B . "0x9DFD") ; <CJK>
       (?$(Hpu(B . "0x9E04") ; <CJK>
       (?$(Hpv(B . "0x9EA0") ; <CJK>
       (?$(Hpw(B . "0x9F1E") ; <CJK>
       (?$(Hpx(B . "0x9F46") ; <CJK>
       (?$(Hpy(B . "0x9F74") ; <CJK>
       (?$(Hpz(B . "0x9F75") ; <CJK>
       (?$(Hp{(B . "0x9F76") ; <CJK>
       (?$(Hp|(B . "0x56D4") ; <CJK>
       (?$(Hp}(B . "0x652E") ; <CJK>
       (?$(Hp~(B . "0x65B8") ; <CJK>
       (?$(Hq!(B . "0x6B18") ; <CJK>
       (?$(Hq"(B . "0x6B19") ; <CJK>
       (?$(Hq#(B . "0x6B17") ; <CJK>
       (?$(Hq$(B . "0x6B1A") ; <CJK>
       (?$(Hq%(B . "0x7062") ; <CJK>
       (?$(Hq&(B . "0x7226") ; <CJK>
       (?$(Hq'(B . "0x72AA") ; <CJK>
       (?$(Hq((B . "0x77D8") ; <CJK>
       (?$(Hq)(B . "0x77D9") ; <CJK>
       (?$(Hq*(B . "0x7939") ; <CJK>
       (?$(Hq+(B . "0x7C69") ; <CJK>
       (?$(Hq,(B . "0x7C6B") ; <CJK>
       (?$(Hq-(B . "0x7CF6") ; <CJK>
       (?$(Hq.(B . "0x7E9A") ; <CJK>
       (?$(Hq/(B . "0x7E98") ; <CJK>
       (?$(Hq0(B . "0x7E9B") ; <CJK>
       (?$(Hq1(B . "0x7E99") ; <CJK>
       (?$(Hq2(B . "0x81E0") ; <CJK>
       (?$(Hq3(B . "0x81E1") ; <CJK>
       (?$(Hq4(B . "0x8646") ; <CJK>
       (?$(Hq5(B . "0x8647") ; <CJK>
       (?$(Hq6(B . "0x8648") ; <CJK>
       (?$(Hq7(B . "0x8979") ; <CJK>
       (?$(Hq8(B . "0x897A") ; <CJK>
       (?$(Hq9(B . "0x897C") ; <CJK>
       (?$(Hq:(B . "0x897B") ; <CJK>
       (?$(Hq;(B . "0x89FF") ; <CJK>
       (?$(Hq<(B . "0x8B98") ; <CJK>
       (?$(Hq=(B . "0x8B99") ; <CJK>
       (?$(Hq>(B . "0x8EA5") ; <CJK>
       (?$(Hq?(B . "0x8EA4") ; <CJK>
       (?$(Hq@(B . "0x8EA3") ; <CJK>
       (?$(HqA(B . "0x946E") ; <CJK>
       (?$(HqB(B . "0x946D") ; <CJK>
       (?$(HqC(B . "0x946F") ; <CJK>
       (?$(HqD(B . "0x9471") ; <CJK>
       (?$(HqE(B . "0x9473") ; <CJK>
       (?$(HqF(B . "0x9749") ; <CJK>
       (?$(HqG(B . "0x9872") ; <CJK>
       (?$(HqH(B . "0x995F") ; <CJK>
       (?$(HqI(B . "0x9C68") ; <CJK>
       (?$(HqJ(B . "0x9C6E") ; <CJK>
       (?$(HqK(B . "0x9C6D") ; <CJK>
       (?$(HqL(B . "0x9E0B") ; <CJK>
       (?$(HqM(B . "0x9E0D") ; <CJK>
       (?$(HqN(B . "0x9E10") ; <CJK>
       (?$(HqO(B . "0x9E0F") ; <CJK>
       (?$(HqP(B . "0x9E12") ; <CJK>
       (?$(HqQ(B . "0x9E11") ; <CJK>
       (?$(HqR(B . "0x9EA1") ; <CJK>
       (?$(HqS(B . "0x9EF5") ; <CJK>
       (?$(HqT(B . "0x9F09") ; <CJK>
       (?$(HqU(B . "0x9F47") ; <CJK>
       (?$(HqV(B . "0x9F78") ; <CJK>
       (?$(HqW(B . "0x9F7B") ; <CJK>
       (?$(HqX(B . "0x9F7A") ; <CJK>
       (?$(HqY(B . "0x9F79") ; <CJK>
       (?$(HqZ(B . "0x571E") ; <CJK>
       (?$(Hq[(B . "0x7066") ; <CJK>
       (?$(Hq\(B . "0x7C6F") ; <CJK>
       (?$(Hq](B . "0x883C") ; <CJK>
       (?$(Hq^(B . "0x8DB2") ; <CJK>
       (?$(Hq_(B . "0x8EA6") ; <CJK>
       (?$(Hq`(B . "0x91C3") ; <CJK>
       (?$(Hqa(B . "0x9474") ; <CJK>
       (?$(Hqb(B . "0x9478") ; <CJK>
       (?$(Hqc(B . "0x9476") ; <CJK>
       (?$(Hqd(B . "0x9475") ; <CJK>
       (?$(Hqe(B . "0x9A60") ; <CJK>
       (?$(Hqf(B . "0x9B2E") ; <CJK>
       (?$(Hqg(B . "0x9C74") ; <CJK>
       (?$(Hqh(B . "0x9C73") ; <CJK>
       (?$(Hqi(B . "0x9C71") ; <CJK>
       (?$(Hqj(B . "0x9C75") ; <CJK>
       (?$(Hqk(B . "0x9E14") ; <CJK>
       (?$(Hql(B . "0x9E13") ; <CJK>
       (?$(Hqm(B . "0x9EF6") ; <CJK>
       (?$(Hqn(B . "0x9F0A") ; <CJK>
       (?$(Hqo(B . "0x9FA4") ; <CJK>
       (?$(Hqp(B . "0x7068") ; <CJK>
       (?$(Hqq(B . "0x7065") ; <CJK>
       (?$(Hqr(B . "0x7CF7") ; <CJK>
       (?$(Hqs(B . "0x866A") ; <CJK>
       (?$(Hqt(B . "0x883E") ; <CJK>
       (?$(Hqu(B . "0x883D") ; <CJK>
       (?$(Hqv(B . "0x883F") ; <CJK>
       (?$(Hqw(B . "0x8B9E") ; <CJK>
       (?$(Hqx(B . "0x8C9C") ; <CJK>
       (?$(Hqy(B . "0x8EA9") ; <CJK>
       (?$(Hqz(B . "0x8EC9") ; <CJK>
       (?$(Hq{(B . "0x974B") ; <CJK>
       (?$(Hq|(B . "0x9873") ; <CJK>
       (?$(Hq}(B . "0x9874") ; <CJK>
       (?$(Hq~(B . "0x98CC") ; <CJK>
       (?$(Hr!(B . "0x9961") ; <CJK>
       (?$(Hr"(B . "0x99AB") ; <CJK>
       (?$(Hr#(B . "0x9A64") ; <CJK>
       (?$(Hr$(B . "0x9A66") ; <CJK>
       (?$(Hr%(B . "0x9A67") ; <CJK>
       (?$(Hr&(B . "0x9B24") ; <CJK>
       (?$(Hr'(B . "0x9E15") ; <CJK>
       (?$(Hr((B . "0x9E17") ; <CJK>
       (?$(Hr)(B . "0x9F48") ; <CJK>
       (?$(Hr*(B . "0x6207") ; <CJK>
       (?$(Hr+(B . "0x6B1E") ; <CJK>
       (?$(Hr,(B . "0x7227") ; <CJK>
       (?$(Hr-(B . "0x864C") ; <CJK>
       (?$(Hr.(B . "0x8EA8") ; <CJK>
       (?$(Hr/(B . "0x9482") ; <CJK>
       (?$(Hr0(B . "0x9480") ; <CJK>
       (?$(Hr1(B . "0x9481") ; <CJK>
       (?$(Hr2(B . "0x9A69") ; <CJK>
       (?$(Hr3(B . "0x9A68") ; <CJK>
       (?$(Hr4(B . "0x9E19") ; <CJK>
       (?$(Hr5(B . "0x864B") ; <CJK>
       (?$(Hr6(B . "0x8B9F") ; <CJK>
       (?$(Hr7(B . "0x9483") ; <CJK>
       (?$(Hr8(B . "0x9C79") ; <CJK>
       (?$(Hr9(B . "0x9EB7") ; <CJK>
       (?$(Hr:(B . "0x7675") ; <CJK>
       (?$(Hr;(B . "0x9A6B") ; <CJK>
       (?$(Hr<(B . "0x9C7A") ; <CJK>
       (?$(Hr=(B . "0x9E1D") ; <CJK>
       (?$(Hr>(B . "0x7069") ; <CJK>
       (?$(Hr?(B . "0x706A") ; <CJK>
       (?$(Hr@(B . "0x7229") ; <CJK>
       (?$(HrA(B . "0x9EA4") ; <CJK>
       (?$(HrB(B . "0x9F7E") ; <CJK>
       (?$(HrC(B . "0x9F49") ; <CJK>
       (?$(HrD(B . "0x9F98") ; <CJK>
       ))))

(provide 'u-cns-2)

;;; u-cns-2.el ends here
 
