; -*- coding: iso-2022-7bit  -*-
;;; u-cns-7.el --- tables between UCS and CNS 11643:1992 plain 7

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-7 'unicode-assoc
     'cns11643-7-vs-unicode-assoc)

(defvar cns11643-7-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(M!c(B . "0x5655") ; <CJK>
       (?$(M!x(B . "0x58C4") ; <CJK>
       (?$(M"q(B . "0x617F") ; <CJK>
       (?$(M#-(B . "0x6469") ; <CJK>
       (?$(M$O(B . "0x6F6E") ; <CJK>
       (?$(M/O(B . "0x71D7") ; <CJK>
       (?$(M1-(B . "0x7CD2") ; <CJK>
       (?$(M2a(B . "0x8666") ; <CJK>
       (?$(M42(B . "0x8F3A") ; <CJK>
       (?$(M;8(B . "0x8667") ; <CJK>
       (?$(M?b(B . "0x64F5") ; <CJK>
       (?$(MAY(B . "0x7E64") ; <CJK>
       (?$(MAa(B . "0x7F80") ; <CJK>
       (?$(MCR(B . "0x8D01") ; <CJK>
       (?$(MFE(B . "0x58E1") ; <CJK>
       (?$(MHW(B . "0x7CE9") ; <CJK>
       (?$(MH|(B . "0x81CB") ; <CJK>
       (?$(MK@(B . "0x95D9") ; <CJK>
       (?$(MSG(B . "0x6707") ; <CJK>
       (?$(MVQ(B . "0x9A47") ; <CJK>
       (?$(MdR(B . "0x7674") ; <CJK>
       ))))

(provide 'u-cns-7)
 
;;; u-cns-7.el ends here
 
