;;; uascii.el --- tables between UCS and US-ASCII

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ASCII

;; This file is part of ISO10646-MULE

;; MULE-ISO10646 is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-ISO10646 is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(require 'tbl-mg)

(put 'ascii 'unicode 'us-ascii-vs-unicode-alist)

(defvar
  us-ascii-vs-unicode-alist
  (let ((i 32) result)
    (while (< i 128)
      (setq result
	    (nconc result
		   (list (cons (make-char 'ascii i) i)))
	    i (1+ i)))
    result)
  "US-ASCII vs Unicode association list")

(if (featurep 'unicode)
    (let ((table-set
	   (mucs-charset-unicode-table-set-symbol 'ascii 'unicode)))
      (put-table-set-alist table-set 'us-ascii-vs-unicode-alist)
      ((lambda (x) 
	 (put-table-set-encode-tables table-set x)
	 (put-table-set-decode-tables table-set x))
       (list
	(define-ccl-identity-translation-table
	  (intern (get-table-set-table-name table-set 1))
	  0 128)))))

(provide 'uascii)


