;;; un-data.el --- basic data for UNICODE.

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;  This module defines basic data for unicode.

(defconst unicode-byte-order-mark-lsb ?\xff)
(defconst unicode-byte-order-mark-msb ?\xfe)
(defconst unicode-signature ?\xfeff)
(defconst unicode-reverse-signature ?\xfffe)
(defconst unicode-line-separator ?\x2028)
(defconst unicode-paragraph-separator ?\x2029)
(defconst unicode-ignore-characters '(?\xffff ?\xfffe ?\xfeff))
(defconst utf8-signature '(?\xef ?\xbb ?\xbf))
(defconst unicode-cr ?\x000d)
(defconst unicode-lf ?\x000a)

(defvar utf8-dos-signature-regexp
  "^\xef\xbb\xbf[^\n]*\xd\xa\\([^\xd\xa]\\|\\'\\)")
(defvar utf8-unix-signature-regexp
  "^\xef\xbb\xbf[^\xd]*\xa\\([^\xd\xa]\\|\\'\\)")
(defvar utf8-mac-signature-regexp
  "^\xef\xbb\xbf[^\n]*\xd\\([^\xd\xa]\\|\\'\\)")
(defvar utf8-signature-regexp "^\xef\xbb\xbf")

(defvar utf16-le-dos-signature-regexp
  "^\xff\xfe\\(\xa[^\x0]\\|[^\xa].\\)*\xd\x0\xa\x0")
(defvar utf16-le-unix-signature-regexp
  "^\xff\xfe\\(\xa[^\x0]\\|[^\xa].\\)*\xa\x0")
(defvar utf16-le-mac-signature-regexp
  "^\xff\xfe\\(\xa[^\x0]\\|[^\xa].\\)*\xd\x0")
(defvar utf16-le-signature-regexp "^\xff\xfe")

(defvar utf16-be-dos-signature-regexp
  "^\xfe\xff\\(\x0[^\xa]\\|[^\x0].\\)*\x0\xd\x0\xa")
(defvar utf16-be-unix-signature-regexp
  "^\xfe\xff\\(\x0[^\xa]\\|[^\x0].\\)*\x0\xa")
(defvar utf16-be-mac-signature-regexp
  "^\xfe\xff\\(\x0[^\xa]\\|[^\x0].\\)*\x0\xd")
(defvar utf16-be-signature-regexp "^\xfe\xff")

(defvar unicode-special-relation-alist
  (list (cons ?\x0a unicode-line-separator)))

(provide 'un-data)
